"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.NomadProvider = exports.nomadProviderHeadersToTerraform = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
function nomadProviderHeadersToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        name: cdktf.stringToTerraform(struct.name),
        value: cdktf.stringToTerraform(struct.value),
    };
}
exports.nomadProviderHeadersToTerraform = nomadProviderHeadersToTerraform;
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs nomad}
*/
class NomadProvider extends cdktf.TerraformProvider {
    // ==============
    // STATIC Methods
    // ==============
    /**
    * Generates CDKTF code for importing a NomadProvider resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the NomadProvider to import
    * @param importFromId The id of the existing NomadProvider that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the NomadProvider to import is found
    */
    static generateConfigForImport(scope, importToId, importFromId, provider) {
        return new cdktf.ImportableResource(scope, importToId, { terraformResourceType: "nomad", importId: importFromId, provider });
    }
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs nomad} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options NomadProviderConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'nomad',
            terraformGeneratorMetadata: {
                providerName: 'nomad',
                providerVersion: '2.0.0',
                providerVersionConstraint: '~> 2.0'
            },
            terraformProviderSource: 'nomad'
        });
        this._address = config.address;
        this._caFile = config.caFile;
        this._caPem = config.caPem;
        this._certFile = config.certFile;
        this._certPem = config.certPem;
        this._consulToken = config.consulToken;
        this._httpAuth = config.httpAuth;
        this._ignoreEnvVars = config.ignoreEnvVars;
        this._keyFile = config.keyFile;
        this._keyPem = config.keyPem;
        this._region = config.region;
        this._secretId = config.secretId;
        this._skipVerify = config.skipVerify;
        this._vaultToken = config.vaultToken;
        this._alias = config.alias;
        this._headers = config.headers;
    }
    get address() {
        return this._address;
    }
    set address(value) {
        this._address = value;
    }
    // Temporarily expose input value. Use with caution.
    get addressInput() {
        return this._address;
    }
    get caFile() {
        return this._caFile;
    }
    set caFile(value) {
        this._caFile = value;
    }
    resetCaFile() {
        this._caFile = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get caFileInput() {
        return this._caFile;
    }
    get caPem() {
        return this._caPem;
    }
    set caPem(value) {
        this._caPem = value;
    }
    resetCaPem() {
        this._caPem = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get caPemInput() {
        return this._caPem;
    }
    get certFile() {
        return this._certFile;
    }
    set certFile(value) {
        this._certFile = value;
    }
    resetCertFile() {
        this._certFile = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get certFileInput() {
        return this._certFile;
    }
    get certPem() {
        return this._certPem;
    }
    set certPem(value) {
        this._certPem = value;
    }
    resetCertPem() {
        this._certPem = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get certPemInput() {
        return this._certPem;
    }
    get consulToken() {
        return this._consulToken;
    }
    set consulToken(value) {
        this._consulToken = value;
    }
    resetConsulToken() {
        this._consulToken = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get consulTokenInput() {
        return this._consulToken;
    }
    get httpAuth() {
        return this._httpAuth;
    }
    set httpAuth(value) {
        this._httpAuth = value;
    }
    resetHttpAuth() {
        this._httpAuth = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get httpAuthInput() {
        return this._httpAuth;
    }
    get ignoreEnvVars() {
        return this._ignoreEnvVars;
    }
    set ignoreEnvVars(value) {
        this._ignoreEnvVars = value;
    }
    resetIgnoreEnvVars() {
        this._ignoreEnvVars = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get ignoreEnvVarsInput() {
        return this._ignoreEnvVars;
    }
    get keyFile() {
        return this._keyFile;
    }
    set keyFile(value) {
        this._keyFile = value;
    }
    resetKeyFile() {
        this._keyFile = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get keyFileInput() {
        return this._keyFile;
    }
    get keyPem() {
        return this._keyPem;
    }
    set keyPem(value) {
        this._keyPem = value;
    }
    resetKeyPem() {
        this._keyPem = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get keyPemInput() {
        return this._keyPem;
    }
    get region() {
        return this._region;
    }
    set region(value) {
        this._region = value;
    }
    resetRegion() {
        this._region = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get regionInput() {
        return this._region;
    }
    get secretId() {
        return this._secretId;
    }
    set secretId(value) {
        this._secretId = value;
    }
    resetSecretId() {
        this._secretId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get secretIdInput() {
        return this._secretId;
    }
    get skipVerify() {
        return this._skipVerify;
    }
    set skipVerify(value) {
        this._skipVerify = value;
    }
    resetSkipVerify() {
        this._skipVerify = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get skipVerifyInput() {
        return this._skipVerify;
    }
    get vaultToken() {
        return this._vaultToken;
    }
    set vaultToken(value) {
        this._vaultToken = value;
    }
    resetVaultToken() {
        this._vaultToken = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get vaultTokenInput() {
        return this._vaultToken;
    }
    get alias() {
        return this._alias;
    }
    set alias(value) {
        this._alias = value;
    }
    resetAlias() {
        this._alias = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get aliasInput() {
        return this._alias;
    }
    get headers() {
        return this._headers;
    }
    set headers(value) {
        this._headers = value;
    }
    resetHeaders() {
        this._headers = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get headersInput() {
        return this._headers;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            address: cdktf.stringToTerraform(this._address),
            ca_file: cdktf.stringToTerraform(this._caFile),
            ca_pem: cdktf.stringToTerraform(this._caPem),
            cert_file: cdktf.stringToTerraform(this._certFile),
            cert_pem: cdktf.stringToTerraform(this._certPem),
            consul_token: cdktf.stringToTerraform(this._consulToken),
            http_auth: cdktf.stringToTerraform(this._httpAuth),
            ignore_env_vars: cdktf.hashMapper(cdktf.booleanToTerraform)(this._ignoreEnvVars),
            key_file: cdktf.stringToTerraform(this._keyFile),
            key_pem: cdktf.stringToTerraform(this._keyPem),
            region: cdktf.stringToTerraform(this._region),
            secret_id: cdktf.stringToTerraform(this._secretId),
            skip_verify: cdktf.booleanToTerraform(this._skipVerify),
            vault_token: cdktf.stringToTerraform(this._vaultToken),
            alias: cdktf.stringToTerraform(this._alias),
            headers: cdktf.listMapper(nomadProviderHeadersToTerraform, true)(this._headers),
        };
    }
}
exports.NomadProvider = NomadProvider;
_a = JSII_RTTI_SYMBOL_1;
NomadProvider[_a] = { fqn: "@cdktf/provider-nomad.provider.NomadProvider", version: "8.0.0" };
// =================
// STATIC PROPERTIES
// =================
NomadProvider.tfResourceType = "nomad";
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW5kZXguanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi9zcmMvcHJvdmlkZXIvaW5kZXgudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7QUFTQSwrQkFBK0I7QUFxSC9CLFNBQWdCLCtCQUErQixDQUFDLE1BQWlEO0lBQy9GLElBQUksQ0FBQyxLQUFLLENBQUMsVUFBVSxDQUFDLE1BQU0sQ0FBQyxJQUFJLEtBQUssQ0FBQyxZQUFZLENBQUMsWUFBWSxDQUFDLE1BQU0sQ0FBQyxFQUFFO1FBQUUsT0FBTyxNQUFNLENBQUM7S0FBRTtJQUM1RixJQUFJLEtBQUssQ0FBQyxnQkFBZ0IsQ0FBQyxNQUFNLENBQUMsRUFBRTtRQUNsQyxNQUFNLElBQUksS0FBSyxDQUFDLG9IQUFvSCxDQUFDLENBQUM7S0FDdkk7SUFDRCxPQUFPO1FBQ0wsSUFBSSxFQUFFLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxNQUFPLENBQUMsSUFBSSxDQUFDO1FBQzNDLEtBQUssRUFBRSxLQUFLLENBQUMsaUJBQWlCLENBQUMsTUFBTyxDQUFDLEtBQUssQ0FBQztLQUM5QyxDQUFBO0FBQ0gsQ0FBQztBQVRELDBFQVNDO0FBR0Q7O0VBRUU7QUFDRixNQUFhLGFBQWMsU0FBUSxLQUFLLENBQUMsaUJBQWlCO0lBT3hELGlCQUFpQjtJQUNqQixpQkFBaUI7SUFDakIsaUJBQWlCO0lBQ2pCOzs7Ozs7TUFNRTtJQUNLLE1BQU0sQ0FBQyx1QkFBdUIsQ0FBQyxLQUFnQixFQUFFLFVBQWtCLEVBQUUsWUFBb0IsRUFBRSxRQUFrQztRQUM5SCxPQUFPLElBQUksS0FBSyxDQUFDLGtCQUFrQixDQUFDLEtBQUssRUFBRSxVQUFVLEVBQUUsRUFBRSxxQkFBcUIsRUFBRSxPQUFPLEVBQUUsUUFBUSxFQUFFLFlBQVksRUFBRSxRQUFRLEVBQUUsQ0FBQyxDQUFDO0lBQy9ILENBQUM7SUFFTCxjQUFjO0lBQ2QsY0FBYztJQUNkLGNBQWM7SUFFZDs7Ozs7O01BTUU7SUFDRixZQUFtQixLQUFnQixFQUFFLEVBQVUsRUFBRSxNQUEyQjtRQUMxRSxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsRUFBRTtZQUNmLHFCQUFxQixFQUFFLE9BQU87WUFDOUIsMEJBQTBCLEVBQUU7Z0JBQzFCLFlBQVksRUFBRSxPQUFPO2dCQUNyQixlQUFlLEVBQUUsT0FBTztnQkFDeEIseUJBQXlCLEVBQUUsUUFBUTthQUNwQztZQUNELHVCQUF1QixFQUFFLE9BQU87U0FDakMsQ0FBQyxDQUFDO1FBQ0gsSUFBSSxDQUFDLFFBQVEsR0FBRyxNQUFNLENBQUMsT0FBTyxDQUFDO1FBQy9CLElBQUksQ0FBQyxPQUFPLEdBQUcsTUFBTSxDQUFDLE1BQU0sQ0FBQztRQUM3QixJQUFJLENBQUMsTUFBTSxHQUFHLE1BQU0sQ0FBQyxLQUFLLENBQUM7UUFDM0IsSUFBSSxDQUFDLFNBQVMsR0FBRyxNQUFNLENBQUMsUUFBUSxDQUFDO1FBQ2pDLElBQUksQ0FBQyxRQUFRLEdBQUcsTUFBTSxDQUFDLE9BQU8sQ0FBQztRQUMvQixJQUFJLENBQUMsWUFBWSxHQUFHLE1BQU0sQ0FBQyxXQUFXLENBQUM7UUFDdkMsSUFBSSxDQUFDLFNBQVMsR0FBRyxNQUFNLENBQUMsUUFBUSxDQUFDO1FBQ2pDLElBQUksQ0FBQyxjQUFjLEdBQUcsTUFBTSxDQUFDLGFBQWEsQ0FBQztRQUMzQyxJQUFJLENBQUMsUUFBUSxHQUFHLE1BQU0sQ0FBQyxPQUFPLENBQUM7UUFDL0IsSUFBSSxDQUFDLE9BQU8sR0FBRyxNQUFNLENBQUMsTUFBTSxDQUFDO1FBQzdCLElBQUksQ0FBQyxPQUFPLEdBQUcsTUFBTSxDQUFDLE1BQU0sQ0FBQztRQUM3QixJQUFJLENBQUMsU0FBUyxHQUFHLE1BQU0sQ0FBQyxRQUFRLENBQUM7UUFDakMsSUFBSSxDQUFDLFdBQVcsR0FBRyxNQUFNLENBQUMsVUFBVSxDQUFDO1FBQ3JDLElBQUksQ0FBQyxXQUFXLEdBQUcsTUFBTSxDQUFDLFVBQVUsQ0FBQztRQUNyQyxJQUFJLENBQUMsTUFBTSxHQUFHLE1BQU0sQ0FBQyxLQUFLLENBQUM7UUFDM0IsSUFBSSxDQUFDLFFBQVEsR0FBRyxNQUFNLENBQUMsT0FBTyxDQUFDO0lBQ2pDLENBQUM7SUFRRCxJQUFXLE9BQU87UUFDaEIsT0FBTyxJQUFJLENBQUMsUUFBUSxDQUFDO0lBQ3ZCLENBQUM7SUFDRCxJQUFXLE9BQU8sQ0FBQyxLQUF5QjtRQUMxQyxJQUFJLENBQUMsUUFBUSxHQUFHLEtBQUssQ0FBQztJQUN4QixDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsWUFBWTtRQUNyQixPQUFPLElBQUksQ0FBQyxRQUFRLENBQUM7SUFDdkIsQ0FBQztJQUlELElBQVcsTUFBTTtRQUNmLE9BQU8sSUFBSSxDQUFDLE9BQU8sQ0FBQztJQUN0QixDQUFDO0lBQ0QsSUFBVyxNQUFNLENBQUMsS0FBeUI7UUFDekMsSUFBSSxDQUFDLE9BQU8sR0FBRyxLQUFLLENBQUM7SUFDdkIsQ0FBQztJQUNNLFdBQVc7UUFDaEIsSUFBSSxDQUFDLE9BQU8sR0FBRyxTQUFTLENBQUM7SUFDM0IsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLFdBQVc7UUFDcEIsT0FBTyxJQUFJLENBQUMsT0FBTyxDQUFDO0lBQ3RCLENBQUM7SUFJRCxJQUFXLEtBQUs7UUFDZCxPQUFPLElBQUksQ0FBQyxNQUFNLENBQUM7SUFDckIsQ0FBQztJQUNELElBQVcsS0FBSyxDQUFDLEtBQXlCO1FBQ3hDLElBQUksQ0FBQyxNQUFNLEdBQUcsS0FBSyxDQUFDO0lBQ3RCLENBQUM7SUFDTSxVQUFVO1FBQ2YsSUFBSSxDQUFDLE1BQU0sR0FBRyxTQUFTLENBQUM7SUFDMUIsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLFVBQVU7UUFDbkIsT0FBTyxJQUFJLENBQUMsTUFBTSxDQUFDO0lBQ3JCLENBQUM7SUFJRCxJQUFXLFFBQVE7UUFDakIsT0FBTyxJQUFJLENBQUMsU0FBUyxDQUFDO0lBQ3hCLENBQUM7SUFDRCxJQUFXLFFBQVEsQ0FBQyxLQUF5QjtRQUMzQyxJQUFJLENBQUMsU0FBUyxHQUFHLEtBQUssQ0FBQztJQUN6QixDQUFDO0lBQ00sYUFBYTtRQUNsQixJQUFJLENBQUMsU0FBUyxHQUFHLFNBQVMsQ0FBQztJQUM3QixDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsYUFBYTtRQUN0QixPQUFPLElBQUksQ0FBQyxTQUFTLENBQUM7SUFDeEIsQ0FBQztJQUlELElBQVcsT0FBTztRQUNoQixPQUFPLElBQUksQ0FBQyxRQUFRLENBQUM7SUFDdkIsQ0FBQztJQUNELElBQVcsT0FBTyxDQUFDLEtBQXlCO1FBQzFDLElBQUksQ0FBQyxRQUFRLEdBQUcsS0FBSyxDQUFDO0lBQ3hCLENBQUM7SUFDTSxZQUFZO1FBQ2pCLElBQUksQ0FBQyxRQUFRLEdBQUcsU0FBUyxDQUFDO0lBQzVCLENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVyxZQUFZO1FBQ3JCLE9BQU8sSUFBSSxDQUFDLFFBQVEsQ0FBQztJQUN2QixDQUFDO0lBSUQsSUFBVyxXQUFXO1FBQ3BCLE9BQU8sSUFBSSxDQUFDLFlBQVksQ0FBQztJQUMzQixDQUFDO0lBQ0QsSUFBVyxXQUFXLENBQUMsS0FBeUI7UUFDOUMsSUFBSSxDQUFDLFlBQVksR0FBRyxLQUFLLENBQUM7SUFDNUIsQ0FBQztJQUNNLGdCQUFnQjtRQUNyQixJQUFJLENBQUMsWUFBWSxHQUFHLFNBQVMsQ0FBQztJQUNoQyxDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsZ0JBQWdCO1FBQ3pCLE9BQU8sSUFBSSxDQUFDLFlBQVksQ0FBQztJQUMzQixDQUFDO0lBSUQsSUFBVyxRQUFRO1FBQ2pCLE9BQU8sSUFBSSxDQUFDLFNBQVMsQ0FBQztJQUN4QixDQUFDO0lBQ0QsSUFBVyxRQUFRLENBQUMsS0FBeUI7UUFDM0MsSUFBSSxDQUFDLFNBQVMsR0FBRyxLQUFLLENBQUM7SUFDekIsQ0FBQztJQUNNLGFBQWE7UUFDbEIsSUFBSSxDQUFDLFNBQVMsR0FBRyxTQUFTLENBQUM7SUFDN0IsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLGFBQWE7UUFDdEIsT0FBTyxJQUFJLENBQUMsU0FBUyxDQUFDO0lBQ3hCLENBQUM7SUFJRCxJQUFXLGFBQWE7UUFDdEIsT0FBTyxJQUFJLENBQUMsY0FBYyxDQUFDO0lBQzdCLENBQUM7SUFDRCxJQUFXLGFBQWEsQ0FBQyxLQUFtRTtRQUMxRixJQUFJLENBQUMsY0FBYyxHQUFHLEtBQUssQ0FBQztJQUM5QixDQUFDO0lBQ00sa0JBQWtCO1FBQ3ZCLElBQUksQ0FBQyxjQUFjLEdBQUcsU0FBUyxDQUFDO0lBQ2xDLENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVyxrQkFBa0I7UUFDM0IsT0FBTyxJQUFJLENBQUMsY0FBYyxDQUFDO0lBQzdCLENBQUM7SUFJRCxJQUFXLE9BQU87UUFDaEIsT0FBTyxJQUFJLENBQUMsUUFBUSxDQUFDO0lBQ3ZCLENBQUM7SUFDRCxJQUFXLE9BQU8sQ0FBQyxLQUF5QjtRQUMxQyxJQUFJLENBQUMsUUFBUSxHQUFHLEtBQUssQ0FBQztJQUN4QixDQUFDO0lBQ00sWUFBWTtRQUNqQixJQUFJLENBQUMsUUFBUSxHQUFHLFNBQVMsQ0FBQztJQUM1QixDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsWUFBWTtRQUNyQixPQUFPLElBQUksQ0FBQyxRQUFRLENBQUM7SUFDdkIsQ0FBQztJQUlELElBQVcsTUFBTTtRQUNmLE9BQU8sSUFBSSxDQUFDLE9BQU8sQ0FBQztJQUN0QixDQUFDO0lBQ0QsSUFBVyxNQUFNLENBQUMsS0FBeUI7UUFDekMsSUFBSSxDQUFDLE9BQU8sR0FBRyxLQUFLLENBQUM7SUFDdkIsQ0FBQztJQUNNLFdBQVc7UUFDaEIsSUFBSSxDQUFDLE9BQU8sR0FBRyxTQUFTLENBQUM7SUFDM0IsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLFdBQVc7UUFDcEIsT0FBTyxJQUFJLENBQUMsT0FBTyxDQUFDO0lBQ3RCLENBQUM7SUFJRCxJQUFXLE1BQU07UUFDZixPQUFPLElBQUksQ0FBQyxPQUFPLENBQUM7SUFDdEIsQ0FBQztJQUNELElBQVcsTUFBTSxDQUFDLEtBQXlCO1FBQ3pDLElBQUksQ0FBQyxPQUFPLEdBQUcsS0FBSyxDQUFDO0lBQ3ZCLENBQUM7SUFDTSxXQUFXO1FBQ2hCLElBQUksQ0FBQyxPQUFPLEdBQUcsU0FBUyxDQUFDO0lBQzNCLENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVyxXQUFXO1FBQ3BCLE9BQU8sSUFBSSxDQUFDLE9BQU8sQ0FBQztJQUN0QixDQUFDO0lBSUQsSUFBVyxRQUFRO1FBQ2pCLE9BQU8sSUFBSSxDQUFDLFNBQVMsQ0FBQztJQUN4QixDQUFDO0lBQ0QsSUFBVyxRQUFRLENBQUMsS0FBeUI7UUFDM0MsSUFBSSxDQUFDLFNBQVMsR0FBRyxLQUFLLENBQUM7SUFDekIsQ0FBQztJQUNNLGFBQWE7UUFDbEIsSUFBSSxDQUFDLFNBQVMsR0FBRyxTQUFTLENBQUM7SUFDN0IsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLGFBQWE7UUFDdEIsT0FBTyxJQUFJLENBQUMsU0FBUyxDQUFDO0lBQ3hCLENBQUM7SUFJRCxJQUFXLFVBQVU7UUFDbkIsT0FBTyxJQUFJLENBQUMsV0FBVyxDQUFDO0lBQzFCLENBQUM7SUFDRCxJQUFXLFVBQVUsQ0FBQyxLQUE4QztRQUNsRSxJQUFJLENBQUMsV0FBVyxHQUFHLEtBQUssQ0FBQztJQUMzQixDQUFDO0lBQ00sZUFBZTtRQUNwQixJQUFJLENBQUMsV0FBVyxHQUFHLFNBQVMsQ0FBQztJQUMvQixDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsZUFBZTtRQUN4QixPQUFPLElBQUksQ0FBQyxXQUFXLENBQUM7SUFDMUIsQ0FBQztJQUlELElBQVcsVUFBVTtRQUNuQixPQUFPLElBQUksQ0FBQyxXQUFXLENBQUM7SUFDMUIsQ0FBQztJQUNELElBQVcsVUFBVSxDQUFDLEtBQXlCO1FBQzdDLElBQUksQ0FBQyxXQUFXLEdBQUcsS0FBSyxDQUFDO0lBQzNCLENBQUM7SUFDTSxlQUFlO1FBQ3BCLElBQUksQ0FBQyxXQUFXLEdBQUcsU0FBUyxDQUFDO0lBQy9CLENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVyxlQUFlO1FBQ3hCLE9BQU8sSUFBSSxDQUFDLFdBQVcsQ0FBQztJQUMxQixDQUFDO0lBSUQsSUFBVyxLQUFLO1FBQ2QsT0FBTyxJQUFJLENBQUMsTUFBTSxDQUFDO0lBQ3JCLENBQUM7SUFDRCxJQUFXLEtBQUssQ0FBQyxLQUF5QjtRQUN4QyxJQUFJLENBQUMsTUFBTSxHQUFHLEtBQUssQ0FBQztJQUN0QixDQUFDO0lBQ00sVUFBVTtRQUNmLElBQUksQ0FBQyxNQUFNLEdBQUcsU0FBUyxDQUFDO0lBQzFCLENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVyxVQUFVO1FBQ25CLE9BQU8sSUFBSSxDQUFDLE1BQU0sQ0FBQztJQUNyQixDQUFDO0lBSUQsSUFBVyxPQUFPO1FBQ2hCLE9BQU8sSUFBSSxDQUFDLFFBQVEsQ0FBQztJQUN2QixDQUFDO0lBQ0QsSUFBVyxPQUFPLENBQUMsS0FBNkQ7UUFDOUUsSUFBSSxDQUFDLFFBQVEsR0FBRyxLQUFLLENBQUM7SUFDeEIsQ0FBQztJQUNNLFlBQVk7UUFDakIsSUFBSSxDQUFDLFFBQVEsR0FBRyxTQUFTLENBQUM7SUFDNUIsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLFlBQVk7UUFDckIsT0FBTyxJQUFJLENBQUMsUUFBUSxDQUFDO0lBQ3ZCLENBQUM7SUFFRCxZQUFZO0lBQ1osWUFBWTtJQUNaLFlBQVk7SUFFRixvQkFBb0I7UUFDNUIsT0FBTztZQUNMLE9BQU8sRUFBRSxLQUFLLENBQUMsaUJBQWlCLENBQUMsSUFBSSxDQUFDLFFBQVEsQ0FBQztZQUMvQyxPQUFPLEVBQUUsS0FBSyxDQUFDLGlCQUFpQixDQUFDLElBQUksQ0FBQyxPQUFPLENBQUM7WUFDOUMsTUFBTSxFQUFFLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxJQUFJLENBQUMsTUFBTSxDQUFDO1lBQzVDLFNBQVMsRUFBRSxLQUFLLENBQUMsaUJBQWlCLENBQUMsSUFBSSxDQUFDLFNBQVMsQ0FBQztZQUNsRCxRQUFRLEVBQUUsS0FBSyxDQUFDLGlCQUFpQixDQUFDLElBQUksQ0FBQyxRQUFRLENBQUM7WUFDaEQsWUFBWSxFQUFFLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxJQUFJLENBQUMsWUFBWSxDQUFDO1lBQ3hELFNBQVMsRUFBRSxLQUFLLENBQUMsaUJBQWlCLENBQUMsSUFBSSxDQUFDLFNBQVMsQ0FBQztZQUNsRCxlQUFlLEVBQUUsS0FBSyxDQUFDLFVBQVUsQ0FBQyxLQUFLLENBQUMsa0JBQWtCLENBQUMsQ0FBQyxJQUFJLENBQUMsY0FBYyxDQUFDO1lBQ2hGLFFBQVEsRUFBRSxLQUFLLENBQUMsaUJBQWlCLENBQUMsSUFBSSxDQUFDLFFBQVEsQ0FBQztZQUNoRCxPQUFPLEVBQUUsS0FBSyxDQUFDLGlCQUFpQixDQUFDLElBQUksQ0FBQyxPQUFPLENBQUM7WUFDOUMsTUFBTSxFQUFFLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxJQUFJLENBQUMsT0FBTyxDQUFDO1lBQzdDLFNBQVMsRUFBRSxLQUFLLENBQUMsaUJBQWlCLENBQUMsSUFBSSxDQUFDLFNBQVMsQ0FBQztZQUNsRCxXQUFXLEVBQUUsS0FBSyxDQUFDLGtCQUFrQixDQUFDLElBQUksQ0FBQyxXQUFXLENBQUM7WUFDdkQsV0FBVyxFQUFFLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxJQUFJLENBQUMsV0FBVyxDQUFDO1lBQ3RELEtBQUssRUFBRSxLQUFLLENBQUMsaUJBQWlCLENBQUMsSUFBSSxDQUFDLE1BQU0sQ0FBQztZQUMzQyxPQUFPLEVBQUUsS0FBSyxDQUFDLFVBQVUsQ0FBQywrQkFBK0IsRUFBRSxJQUFJLENBQUMsQ0FBQyxJQUFJLENBQUMsUUFBUSxDQUFDO1NBQ2hGLENBQUM7SUFDSixDQUFDOztBQXBWSCxzQ0FxVkM7OztBQW5WQyxvQkFBb0I7QUFDcEIsb0JBQW9CO0FBQ3BCLG9CQUFvQjtBQUNHLDRCQUFjLEdBQUcsT0FBTyxDQUFDIiwic291cmNlc0NvbnRlbnQiOlsiLyoqXG4gKiBDb3B5cmlnaHQgKGMpIEhhc2hpQ29ycCwgSW5jLlxuICogU1BEWC1MaWNlbnNlLUlkZW50aWZpZXI6IE1QTC0yLjBcbiAqL1xuXG4vLyBodHRwczovL3JlZ2lzdHJ5LnRlcnJhZm9ybS5pby9wcm92aWRlcnMvaGFzaGljb3JwL25vbWFkLzIuMC4wL2RvY3Ncbi8vIGdlbmVyYXRlZCBmcm9tIHRlcnJhZm9ybSByZXNvdXJjZSBzY2hlbWFcblxuaW1wb3J0IHsgQ29uc3RydWN0IH0gZnJvbSAnY29uc3RydWN0cyc7XG5pbXBvcnQgKiBhcyBjZGt0ZiBmcm9tICdjZGt0Zic7XG5cbi8vIENvbmZpZ3VyYXRpb25cblxuZXhwb3J0IGludGVyZmFjZSBOb21hZFByb3ZpZGVyQ29uZmlnIHtcbiAgLyoqXG4gICogVVJMIG9mIHRoZSByb290IG9mIHRoZSB0YXJnZXQgTm9tYWQgYWdlbnQuXG4gICpcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vcmVnaXN0cnkudGVycmFmb3JtLmlvL3Byb3ZpZGVycy9oYXNoaWNvcnAvbm9tYWQvMi4wLjAvZG9jcyNhZGRyZXNzIE5vbWFkUHJvdmlkZXIjYWRkcmVzc31cbiAgKi9cbiAgcmVhZG9ubHkgYWRkcmVzczogc3RyaW5nO1xuICAvKipcbiAgKiBBIHBhdGggdG8gYSBQRU0tZW5jb2RlZCBjZXJ0aWZpY2F0ZSBhdXRob3JpdHkgdXNlZCB0byB2ZXJpZnkgdGhlIHJlbW90ZSBhZ2VudCdzIGNlcnRpZmljYXRlLlxuICAqXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3JlZ2lzdHJ5LnRlcnJhZm9ybS5pby9wcm92aWRlcnMvaGFzaGljb3JwL25vbWFkLzIuMC4wL2RvY3MjY2FfZmlsZSBOb21hZFByb3ZpZGVyI2NhX2ZpbGV9XG4gICovXG4gIHJlYWRvbmx5IGNhRmlsZT86IHN0cmluZztcbiAgLyoqXG4gICogUEVNLWVuY29kZWQgY2VydGlmaWNhdGUgYXV0aG9yaXR5IHVzZWQgdG8gdmVyaWZ5IHRoZSByZW1vdGUgYWdlbnQncyBjZXJ0aWZpY2F0ZS5cbiAgKlxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly9yZWdpc3RyeS50ZXJyYWZvcm0uaW8vcHJvdmlkZXJzL2hhc2hpY29ycC9ub21hZC8yLjAuMC9kb2NzI2NhX3BlbSBOb21hZFByb3ZpZGVyI2NhX3BlbX1cbiAgKi9cbiAgcmVhZG9ubHkgY2FQZW0/OiBzdHJpbmc7XG4gIC8qKlxuICAqIEEgcGF0aCB0byBhIFBFTS1lbmNvZGVkIGNlcnRpZmljYXRlIHByb3ZpZGVkIHRvIHRoZSByZW1vdGUgYWdlbnQ7IHJlcXVpcmVzIHVzZSBvZiBrZXlfZmlsZSBvciBrZXlfcGVtLlxuICAqXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3JlZ2lzdHJ5LnRlcnJhZm9ybS5pby9wcm92aWRlcnMvaGFzaGljb3JwL25vbWFkLzIuMC4wL2RvY3MjY2VydF9maWxlIE5vbWFkUHJvdmlkZXIjY2VydF9maWxlfVxuICAqL1xuICByZWFkb25seSBjZXJ0RmlsZT86IHN0cmluZztcbiAgLyoqXG4gICogUEVNLWVuY29kZWQgY2VydGlmaWNhdGUgcHJvdmlkZWQgdG8gdGhlIHJlbW90ZSBhZ2VudDsgcmVxdWlyZXMgdXNlIG9mIGtleV9maWxlIG9yIGtleV9wZW0uXG4gICpcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vcmVnaXN0cnkudGVycmFmb3JtLmlvL3Byb3ZpZGVycy9oYXNoaWNvcnAvbm9tYWQvMi4wLjAvZG9jcyNjZXJ0X3BlbSBOb21hZFByb3ZpZGVyI2NlcnRfcGVtfVxuICAqL1xuICByZWFkb25seSBjZXJ0UGVtPzogc3RyaW5nO1xuICAvKipcbiAgKiBDb25zdWwgdG9rZW4gdG8gdmFsaWRhdGUgQ29uc3VsIENvbm5lY3QgU2VydmljZSBJZGVudGl0eSBwb2xpY2llcyBzcGVjaWZpZWQgaW4gdGhlIGpvYiBmaWxlLlxuICAqXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3JlZ2lzdHJ5LnRlcnJhZm9ybS5pby9wcm92aWRlcnMvaGFzaGljb3JwL25vbWFkLzIuMC4wL2RvY3MjY29uc3VsX3Rva2VuIE5vbWFkUHJvdmlkZXIjY29uc3VsX3Rva2VufVxuICAqL1xuICByZWFkb25seSBjb25zdWxUb2tlbj86IHN0cmluZztcbiAgLyoqXG4gICogSFRUUCBiYXNpYyBhdXRoIGNvbmZpZ3VyYXRpb24uXG4gICpcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vcmVnaXN0cnkudGVycmFmb3JtLmlvL3Byb3ZpZGVycy9oYXNoaWNvcnAvbm9tYWQvMi4wLjAvZG9jcyNodHRwX2F1dGggTm9tYWRQcm92aWRlciNodHRwX2F1dGh9XG4gICovXG4gIHJlYWRvbmx5IGh0dHBBdXRoPzogc3RyaW5nO1xuICAvKipcbiAgKiBBIHNldCBvZiBlbnZpcm9ubWVudCB2YXJpYWJsZXMgdGhhdCBhcmUgaWdub3JlZCBieSB0aGUgcHJvdmlkZXIgd2hlbiBjb25maWd1cmluZyB0aGUgTm9tYWQgQVBJIGNsaWVudC5cbiAgKlxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly9yZWdpc3RyeS50ZXJyYWZvcm0uaW8vcHJvdmlkZXJzL2hhc2hpY29ycC9ub21hZC8yLjAuMC9kb2NzI2lnbm9yZV9lbnZfdmFycyBOb21hZFByb3ZpZGVyI2lnbm9yZV9lbnZfdmFyc31cbiAgKi9cbiAgcmVhZG9ubHkgaWdub3JlRW52VmFycz86IHsgW2tleTogc3RyaW5nXTogKGJvb2xlYW4gfCBjZGt0Zi5JUmVzb2x2YWJsZSkgfTtcbiAgLyoqXG4gICogQSBwYXRoIHRvIGEgUEVNLWVuY29kZWQgcHJpdmF0ZSBrZXksIHJlcXVpcmVkIGlmIGNlcnRfZmlsZSBvciBjZXJ0X3BlbSBpcyBzcGVjaWZpZWQuXG4gICpcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vcmVnaXN0cnkudGVycmFmb3JtLmlvL3Byb3ZpZGVycy9oYXNoaWNvcnAvbm9tYWQvMi4wLjAvZG9jcyNrZXlfZmlsZSBOb21hZFByb3ZpZGVyI2tleV9maWxlfVxuICAqL1xuICByZWFkb25seSBrZXlGaWxlPzogc3RyaW5nO1xuICAvKipcbiAgKiBQRU0tZW5jb2RlZCBwcml2YXRlIGtleSwgcmVxdWlyZWQgaWYgY2VydF9maWxlIG9yIGNlcnRfcGVtIGlzIHNwZWNpZmllZC5cbiAgKlxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly9yZWdpc3RyeS50ZXJyYWZvcm0uaW8vcHJvdmlkZXJzL2hhc2hpY29ycC9ub21hZC8yLjAuMC9kb2NzI2tleV9wZW0gTm9tYWRQcm92aWRlciNrZXlfcGVtfVxuICAqL1xuICByZWFkb25seSBrZXlQZW0/OiBzdHJpbmc7XG4gIC8qKlxuICAqIFJlZ2lvbiBvZiB0aGUgdGFyZ2V0IE5vbWFkIGFnZW50LlxuICAqXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3JlZ2lzdHJ5LnRlcnJhZm9ybS5pby9wcm92aWRlcnMvaGFzaGljb3JwL25vbWFkLzIuMC4wL2RvY3MjcmVnaW9uIE5vbWFkUHJvdmlkZXIjcmVnaW9ufVxuICAqL1xuICByZWFkb25seSByZWdpb24/OiBzdHJpbmc7XG4gIC8qKlxuICAqIEFDTCB0b2tlbiBzZWNyZXQgZm9yIEFQSSByZXF1ZXN0cy5cbiAgKlxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly9yZWdpc3RyeS50ZXJyYWZvcm0uaW8vcHJvdmlkZXJzL2hhc2hpY29ycC9ub21hZC8yLjAuMC9kb2NzI3NlY3JldF9pZCBOb21hZFByb3ZpZGVyI3NlY3JldF9pZH1cbiAgKi9cbiAgcmVhZG9ubHkgc2VjcmV0SWQ/OiBzdHJpbmc7XG4gIC8qKlxuICAqIFNraXAgVExTIHZlcmlmaWNhdGlvbiBvbiBjbGllbnQgc2lkZS5cbiAgKlxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly9yZWdpc3RyeS50ZXJyYWZvcm0uaW8vcHJvdmlkZXJzL2hhc2hpY29ycC9ub21hZC8yLjAuMC9kb2NzI3NraXBfdmVyaWZ5IE5vbWFkUHJvdmlkZXIjc2tpcF92ZXJpZnl9XG4gICovXG4gIHJlYWRvbmx5IHNraXBWZXJpZnk/OiBib29sZWFuIHwgY2RrdGYuSVJlc29sdmFibGU7XG4gIC8qKlxuICAqIFZhdWx0IHRva2VuIGlmIHBvbGljaWVzIGFyZSBzcGVjaWZpZWQgaW4gdGhlIGpvYiBmaWxlLlxuICAqXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3JlZ2lzdHJ5LnRlcnJhZm9ybS5pby9wcm92aWRlcnMvaGFzaGljb3JwL25vbWFkLzIuMC4wL2RvY3MjdmF1bHRfdG9rZW4gTm9tYWRQcm92aWRlciN2YXVsdF90b2tlbn1cbiAgKi9cbiAgcmVhZG9ubHkgdmF1bHRUb2tlbj86IHN0cmluZztcbiAgLyoqXG4gICogQWxpYXMgbmFtZVxuICAqXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3JlZ2lzdHJ5LnRlcnJhZm9ybS5pby9wcm92aWRlcnMvaGFzaGljb3JwL25vbWFkLzIuMC4wL2RvY3MjYWxpYXMgTm9tYWRQcm92aWRlciNhbGlhc31cbiAgKi9cbiAgcmVhZG9ubHkgYWxpYXM/OiBzdHJpbmc7XG4gIC8qKlxuICAqIGhlYWRlcnMgYmxvY2tcbiAgKlxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly9yZWdpc3RyeS50ZXJyYWZvcm0uaW8vcHJvdmlkZXJzL2hhc2hpY29ycC9ub21hZC8yLjAuMC9kb2NzI2hlYWRlcnMgTm9tYWRQcm92aWRlciNoZWFkZXJzfVxuICAqL1xuICByZWFkb25seSBoZWFkZXJzPzogTm9tYWRQcm92aWRlckhlYWRlcnNbXSB8IGNka3RmLklSZXNvbHZhYmxlO1xufVxuZXhwb3J0IGludGVyZmFjZSBOb21hZFByb3ZpZGVySGVhZGVycyB7XG4gIC8qKlxuICAqIFRoZSBoZWFkZXIgbmFtZVxuICAqXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3JlZ2lzdHJ5LnRlcnJhZm9ybS5pby9wcm92aWRlcnMvaGFzaGljb3JwL25vbWFkLzIuMC4wL2RvY3MjbmFtZSBOb21hZFByb3ZpZGVyI25hbWV9XG4gICovXG4gIHJlYWRvbmx5IG5hbWU6IHN0cmluZztcbiAgLyoqXG4gICogVGhlIGhlYWRlciB2YWx1ZVxuICAqXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3JlZ2lzdHJ5LnRlcnJhZm9ybS5pby9wcm92aWRlcnMvaGFzaGljb3JwL25vbWFkLzIuMC4wL2RvY3MjdmFsdWUgTm9tYWRQcm92aWRlciN2YWx1ZX1cbiAgKi9cbiAgcmVhZG9ubHkgdmFsdWU6IHN0cmluZztcbn1cblxuZXhwb3J0IGZ1bmN0aW9uIG5vbWFkUHJvdmlkZXJIZWFkZXJzVG9UZXJyYWZvcm0oc3RydWN0PzogTm9tYWRQcm92aWRlckhlYWRlcnMgfCBjZGt0Zi5JUmVzb2x2YWJsZSk6IGFueSB7XG4gIGlmICghY2RrdGYuY2FuSW5zcGVjdChzdHJ1Y3QpIHx8IGNka3RmLlRva2VuaXphdGlvbi5pc1Jlc29sdmFibGUoc3RydWN0KSkgeyByZXR1cm4gc3RydWN0OyB9XG4gIGlmIChjZGt0Zi5pc0NvbXBsZXhFbGVtZW50KHN0cnVjdCkpIHtcbiAgICB0aHJvdyBuZXcgRXJyb3IoXCJBIGNvbXBsZXggZWxlbWVudCB3YXMgdXNlZCBhcyBjb25maWd1cmF0aW9uLCB0aGlzIGlzIG5vdCBzdXBwb3J0ZWQ6IGh0dHBzOi8vY2RrLnRmL2NvbXBsZXgtb2JqZWN0LWFzLWNvbmZpZ3VyYXRpb25cIik7XG4gIH1cbiAgcmV0dXJuIHtcbiAgICBuYW1lOiBjZGt0Zi5zdHJpbmdUb1RlcnJhZm9ybShzdHJ1Y3QhLm5hbWUpLFxuICAgIHZhbHVlOiBjZGt0Zi5zdHJpbmdUb1RlcnJhZm9ybShzdHJ1Y3QhLnZhbHVlKSxcbiAgfVxufVxuXG5cbi8qKlxuKiBSZXByZXNlbnRzIGEge0BsaW5rIGh0dHBzOi8vcmVnaXN0cnkudGVycmFmb3JtLmlvL3Byb3ZpZGVycy9oYXNoaWNvcnAvbm9tYWQvMi4wLjAvZG9jcyBub21hZH1cbiovXG5leHBvcnQgY2xhc3MgTm9tYWRQcm92aWRlciBleHRlbmRzIGNka3RmLlRlcnJhZm9ybVByb3ZpZGVyIHtcblxuICAvLyA9PT09PT09PT09PT09PT09PVxuICAvLyBTVEFUSUMgUFJPUEVSVElFU1xuICAvLyA9PT09PT09PT09PT09PT09PVxuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IHRmUmVzb3VyY2VUeXBlID0gXCJub21hZFwiO1xuXG4gIC8vID09PT09PT09PT09PT09XG4gIC8vIFNUQVRJQyBNZXRob2RzXG4gIC8vID09PT09PT09PT09PT09XG4gIC8qKlxuICAqIEdlbmVyYXRlcyBDREtURiBjb2RlIGZvciBpbXBvcnRpbmcgYSBOb21hZFByb3ZpZGVyIHJlc291cmNlIHVwb24gcnVubmluZyBcImNka3RmIHBsYW4gPHN0YWNrLW5hbWU+XCJcbiAgKiBAcGFyYW0gc2NvcGUgVGhlIHNjb3BlIGluIHdoaWNoIHRvIGRlZmluZSB0aGlzIGNvbnN0cnVjdFxuICAqIEBwYXJhbSBpbXBvcnRUb0lkIFRoZSBjb25zdHJ1Y3QgaWQgdXNlZCBpbiB0aGUgZ2VuZXJhdGVkIGNvbmZpZyBmb3IgdGhlIE5vbWFkUHJvdmlkZXIgdG8gaW1wb3J0XG4gICogQHBhcmFtIGltcG9ydEZyb21JZCBUaGUgaWQgb2YgdGhlIGV4aXN0aW5nIE5vbWFkUHJvdmlkZXIgdGhhdCBzaG91bGQgYmUgaW1wb3J0ZWQuIFJlZmVyIHRvIHRoZSB7QGxpbmsgaHR0cHM6Ly9yZWdpc3RyeS50ZXJyYWZvcm0uaW8vcHJvdmlkZXJzL2hhc2hpY29ycC9ub21hZC8yLjAuMC9kb2NzI2ltcG9ydCBpbXBvcnQgc2VjdGlvbn0gaW4gdGhlIGRvY3VtZW50YXRpb24gb2YgdGhpcyByZXNvdXJjZSBmb3IgdGhlIGlkIHRvIHVzZVxuICAqIEBwYXJhbSBwcm92aWRlcj8gT3B0aW9uYWwgaW5zdGFuY2Ugb2YgdGhlIHByb3ZpZGVyIHdoZXJlIHRoZSBOb21hZFByb3ZpZGVyIHRvIGltcG9ydCBpcyBmb3VuZFxuICAqL1xuICBwdWJsaWMgc3RhdGljIGdlbmVyYXRlQ29uZmlnRm9ySW1wb3J0KHNjb3BlOiBDb25zdHJ1Y3QsIGltcG9ydFRvSWQ6IHN0cmluZywgaW1wb3J0RnJvbUlkOiBzdHJpbmcsIHByb3ZpZGVyPzogY2RrdGYuVGVycmFmb3JtUHJvdmlkZXIpIHtcbiAgICAgICAgcmV0dXJuIG5ldyBjZGt0Zi5JbXBvcnRhYmxlUmVzb3VyY2Uoc2NvcGUsIGltcG9ydFRvSWQsIHsgdGVycmFmb3JtUmVzb3VyY2VUeXBlOiBcIm5vbWFkXCIsIGltcG9ydElkOiBpbXBvcnRGcm9tSWQsIHByb3ZpZGVyIH0pO1xuICAgICAgfVxuXG4gIC8vID09PT09PT09PT09XG4gIC8vIElOSVRJQUxJWkVSXG4gIC8vID09PT09PT09PT09XG5cbiAgLyoqXG4gICogQ3JlYXRlIGEgbmV3IHtAbGluayBodHRwczovL3JlZ2lzdHJ5LnRlcnJhZm9ybS5pby9wcm92aWRlcnMvaGFzaGljb3JwL25vbWFkLzIuMC4wL2RvY3Mgbm9tYWR9IFJlc291cmNlXG4gICpcbiAgKiBAcGFyYW0gc2NvcGUgVGhlIHNjb3BlIGluIHdoaWNoIHRvIGRlZmluZSB0aGlzIGNvbnN0cnVjdFxuICAqIEBwYXJhbSBpZCBUaGUgc2NvcGVkIGNvbnN0cnVjdCBJRC4gTXVzdCBiZSB1bmlxdWUgYW1vbmdzdCBzaWJsaW5ncyBpbiB0aGUgc2FtZSBzY29wZVxuICAqIEBwYXJhbSBvcHRpb25zIE5vbWFkUHJvdmlkZXJDb25maWdcbiAgKi9cbiAgcHVibGljIGNvbnN0cnVjdG9yKHNjb3BlOiBDb25zdHJ1Y3QsIGlkOiBzdHJpbmcsIGNvbmZpZzogTm9tYWRQcm92aWRlckNvbmZpZykge1xuICAgIHN1cGVyKHNjb3BlLCBpZCwge1xuICAgICAgdGVycmFmb3JtUmVzb3VyY2VUeXBlOiAnbm9tYWQnLFxuICAgICAgdGVycmFmb3JtR2VuZXJhdG9yTWV0YWRhdGE6IHtcbiAgICAgICAgcHJvdmlkZXJOYW1lOiAnbm9tYWQnLFxuICAgICAgICBwcm92aWRlclZlcnNpb246ICcyLjAuMCcsXG4gICAgICAgIHByb3ZpZGVyVmVyc2lvbkNvbnN0cmFpbnQ6ICd+PiAyLjAnXG4gICAgICB9LFxuICAgICAgdGVycmFmb3JtUHJvdmlkZXJTb3VyY2U6ICdub21hZCdcbiAgICB9KTtcbiAgICB0aGlzLl9hZGRyZXNzID0gY29uZmlnLmFkZHJlc3M7XG4gICAgdGhpcy5fY2FGaWxlID0gY29uZmlnLmNhRmlsZTtcbiAgICB0aGlzLl9jYVBlbSA9IGNvbmZpZy5jYVBlbTtcbiAgICB0aGlzLl9jZXJ0RmlsZSA9IGNvbmZpZy5jZXJ0RmlsZTtcbiAgICB0aGlzLl9jZXJ0UGVtID0gY29uZmlnLmNlcnRQZW07XG4gICAgdGhpcy5fY29uc3VsVG9rZW4gPSBjb25maWcuY29uc3VsVG9rZW47XG4gICAgdGhpcy5faHR0cEF1dGggPSBjb25maWcuaHR0cEF1dGg7XG4gICAgdGhpcy5faWdub3JlRW52VmFycyA9IGNvbmZpZy5pZ25vcmVFbnZWYXJzO1xuICAgIHRoaXMuX2tleUZpbGUgPSBjb25maWcua2V5RmlsZTtcbiAgICB0aGlzLl9rZXlQZW0gPSBjb25maWcua2V5UGVtO1xuICAgIHRoaXMuX3JlZ2lvbiA9IGNvbmZpZy5yZWdpb247XG4gICAgdGhpcy5fc2VjcmV0SWQgPSBjb25maWcuc2VjcmV0SWQ7XG4gICAgdGhpcy5fc2tpcFZlcmlmeSA9IGNvbmZpZy5za2lwVmVyaWZ5O1xuICAgIHRoaXMuX3ZhdWx0VG9rZW4gPSBjb25maWcudmF1bHRUb2tlbjtcbiAgICB0aGlzLl9hbGlhcyA9IGNvbmZpZy5hbGlhcztcbiAgICB0aGlzLl9oZWFkZXJzID0gY29uZmlnLmhlYWRlcnM7XG4gIH1cblxuICAvLyA9PT09PT09PT09XG4gIC8vIEFUVFJJQlVURVNcbiAgLy8gPT09PT09PT09PVxuXG4gIC8vIGFkZHJlc3MgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiBmYWxzZSwgcmVxdWlyZWQ6IHRydWVcbiAgcHJpdmF0ZSBfYWRkcmVzcz86IHN0cmluZzsgXG4gIHB1YmxpYyBnZXQgYWRkcmVzcygpIHtcbiAgICByZXR1cm4gdGhpcy5fYWRkcmVzcztcbiAgfVxuICBwdWJsaWMgc2V0IGFkZHJlc3ModmFsdWU6IHN0cmluZyB8IHVuZGVmaW5lZCkge1xuICAgIHRoaXMuX2FkZHJlc3MgPSB2YWx1ZTtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgYWRkcmVzc0lucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9hZGRyZXNzO1xuICB9XG5cbiAgLy8gY2FfZmlsZSAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9jYUZpbGU/OiBzdHJpbmc7IFxuICBwdWJsaWMgZ2V0IGNhRmlsZSgpIHtcbiAgICByZXR1cm4gdGhpcy5fY2FGaWxlO1xuICB9XG4gIHB1YmxpYyBzZXQgY2FGaWxlKHZhbHVlOiBzdHJpbmcgfCB1bmRlZmluZWQpIHtcbiAgICB0aGlzLl9jYUZpbGUgPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXRDYUZpbGUoKSB7XG4gICAgdGhpcy5fY2FGaWxlID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCBjYUZpbGVJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fY2FGaWxlO1xuICB9XG5cbiAgLy8gY2FfcGVtIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX2NhUGVtPzogc3RyaW5nOyBcbiAgcHVibGljIGdldCBjYVBlbSgpIHtcbiAgICByZXR1cm4gdGhpcy5fY2FQZW07XG4gIH1cbiAgcHVibGljIHNldCBjYVBlbSh2YWx1ZTogc3RyaW5nIHwgdW5kZWZpbmVkKSB7XG4gICAgdGhpcy5fY2FQZW0gPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXRDYVBlbSgpIHtcbiAgICB0aGlzLl9jYVBlbSA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgY2FQZW1JbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fY2FQZW07XG4gIH1cblxuICAvLyBjZXJ0X2ZpbGUgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfY2VydEZpbGU/OiBzdHJpbmc7IFxuICBwdWJsaWMgZ2V0IGNlcnRGaWxlKCkge1xuICAgIHJldHVybiB0aGlzLl9jZXJ0RmlsZTtcbiAgfVxuICBwdWJsaWMgc2V0IGNlcnRGaWxlKHZhbHVlOiBzdHJpbmcgfCB1bmRlZmluZWQpIHtcbiAgICB0aGlzLl9jZXJ0RmlsZSA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldENlcnRGaWxlKCkge1xuICAgIHRoaXMuX2NlcnRGaWxlID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCBjZXJ0RmlsZUlucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9jZXJ0RmlsZTtcbiAgfVxuXG4gIC8vIGNlcnRfcGVtIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX2NlcnRQZW0/OiBzdHJpbmc7IFxuICBwdWJsaWMgZ2V0IGNlcnRQZW0oKSB7XG4gICAgcmV0dXJuIHRoaXMuX2NlcnRQZW07XG4gIH1cbiAgcHVibGljIHNldCBjZXJ0UGVtKHZhbHVlOiBzdHJpbmcgfCB1bmRlZmluZWQpIHtcbiAgICB0aGlzLl9jZXJ0UGVtID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0Q2VydFBlbSgpIHtcbiAgICB0aGlzLl9jZXJ0UGVtID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCBjZXJ0UGVtSW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX2NlcnRQZW07XG4gIH1cblxuICAvLyBjb25zdWxfdG9rZW4gLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfY29uc3VsVG9rZW4/OiBzdHJpbmc7IFxuICBwdWJsaWMgZ2V0IGNvbnN1bFRva2VuKCkge1xuICAgIHJldHVybiB0aGlzLl9jb25zdWxUb2tlbjtcbiAgfVxuICBwdWJsaWMgc2V0IGNvbnN1bFRva2VuKHZhbHVlOiBzdHJpbmcgfCB1bmRlZmluZWQpIHtcbiAgICB0aGlzLl9jb25zdWxUb2tlbiA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldENvbnN1bFRva2VuKCkge1xuICAgIHRoaXMuX2NvbnN1bFRva2VuID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCBjb25zdWxUb2tlbklucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9jb25zdWxUb2tlbjtcbiAgfVxuXG4gIC8vIGh0dHBfYXV0aCAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9odHRwQXV0aD86IHN0cmluZzsgXG4gIHB1YmxpYyBnZXQgaHR0cEF1dGgoKSB7XG4gICAgcmV0dXJuIHRoaXMuX2h0dHBBdXRoO1xuICB9XG4gIHB1YmxpYyBzZXQgaHR0cEF1dGgodmFsdWU6IHN0cmluZyB8IHVuZGVmaW5lZCkge1xuICAgIHRoaXMuX2h0dHBBdXRoID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0SHR0cEF1dGgoKSB7XG4gICAgdGhpcy5faHR0cEF1dGggPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IGh0dHBBdXRoSW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX2h0dHBBdXRoO1xuICB9XG5cbiAgLy8gaWdub3JlX2Vudl92YXJzIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX2lnbm9yZUVudlZhcnM/OiB7IFtrZXk6IHN0cmluZ106IChib29sZWFuIHwgY2RrdGYuSVJlc29sdmFibGUpIH07IFxuICBwdWJsaWMgZ2V0IGlnbm9yZUVudlZhcnMoKSB7XG4gICAgcmV0dXJuIHRoaXMuX2lnbm9yZUVudlZhcnM7XG4gIH1cbiAgcHVibGljIHNldCBpZ25vcmVFbnZWYXJzKHZhbHVlOiB7IFtrZXk6IHN0cmluZ106IChib29sZWFuIHwgY2RrdGYuSVJlc29sdmFibGUpIH0gfCB1bmRlZmluZWQpIHtcbiAgICB0aGlzLl9pZ25vcmVFbnZWYXJzID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0SWdub3JlRW52VmFycygpIHtcbiAgICB0aGlzLl9pZ25vcmVFbnZWYXJzID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCBpZ25vcmVFbnZWYXJzSW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX2lnbm9yZUVudlZhcnM7XG4gIH1cblxuICAvLyBrZXlfZmlsZSAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9rZXlGaWxlPzogc3RyaW5nOyBcbiAgcHVibGljIGdldCBrZXlGaWxlKCkge1xuICAgIHJldHVybiB0aGlzLl9rZXlGaWxlO1xuICB9XG4gIHB1YmxpYyBzZXQga2V5RmlsZSh2YWx1ZTogc3RyaW5nIHwgdW5kZWZpbmVkKSB7XG4gICAgdGhpcy5fa2V5RmlsZSA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldEtleUZpbGUoKSB7XG4gICAgdGhpcy5fa2V5RmlsZSA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQga2V5RmlsZUlucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9rZXlGaWxlO1xuICB9XG5cbiAgLy8ga2V5X3BlbSAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9rZXlQZW0/OiBzdHJpbmc7IFxuICBwdWJsaWMgZ2V0IGtleVBlbSgpIHtcbiAgICByZXR1cm4gdGhpcy5fa2V5UGVtO1xuICB9XG4gIHB1YmxpYyBzZXQga2V5UGVtKHZhbHVlOiBzdHJpbmcgfCB1bmRlZmluZWQpIHtcbiAgICB0aGlzLl9rZXlQZW0gPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXRLZXlQZW0oKSB7XG4gICAgdGhpcy5fa2V5UGVtID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCBrZXlQZW1JbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fa2V5UGVtO1xuICB9XG5cbiAgLy8gcmVnaW9uIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX3JlZ2lvbj86IHN0cmluZzsgXG4gIHB1YmxpYyBnZXQgcmVnaW9uKCkge1xuICAgIHJldHVybiB0aGlzLl9yZWdpb247XG4gIH1cbiAgcHVibGljIHNldCByZWdpb24odmFsdWU6IHN0cmluZyB8IHVuZGVmaW5lZCkge1xuICAgIHRoaXMuX3JlZ2lvbiA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldFJlZ2lvbigpIHtcbiAgICB0aGlzLl9yZWdpb24gPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IHJlZ2lvbklucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9yZWdpb247XG4gIH1cblxuICAvLyBzZWNyZXRfaWQgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfc2VjcmV0SWQ/OiBzdHJpbmc7IFxuICBwdWJsaWMgZ2V0IHNlY3JldElkKCkge1xuICAgIHJldHVybiB0aGlzLl9zZWNyZXRJZDtcbiAgfVxuICBwdWJsaWMgc2V0IHNlY3JldElkKHZhbHVlOiBzdHJpbmcgfCB1bmRlZmluZWQpIHtcbiAgICB0aGlzLl9zZWNyZXRJZCA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldFNlY3JldElkKCkge1xuICAgIHRoaXMuX3NlY3JldElkID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCBzZWNyZXRJZElucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9zZWNyZXRJZDtcbiAgfVxuXG4gIC8vIHNraXBfdmVyaWZ5IC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX3NraXBWZXJpZnk/OiBib29sZWFuIHwgY2RrdGYuSVJlc29sdmFibGU7IFxuICBwdWJsaWMgZ2V0IHNraXBWZXJpZnkoKSB7XG4gICAgcmV0dXJuIHRoaXMuX3NraXBWZXJpZnk7XG4gIH1cbiAgcHVibGljIHNldCBza2lwVmVyaWZ5KHZhbHVlOiBib29sZWFuIHwgY2RrdGYuSVJlc29sdmFibGUgfCB1bmRlZmluZWQpIHtcbiAgICB0aGlzLl9za2lwVmVyaWZ5ID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0U2tpcFZlcmlmeSgpIHtcbiAgICB0aGlzLl9za2lwVmVyaWZ5ID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCBza2lwVmVyaWZ5SW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX3NraXBWZXJpZnk7XG4gIH1cblxuICAvLyB2YXVsdF90b2tlbiAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF92YXVsdFRva2VuPzogc3RyaW5nOyBcbiAgcHVibGljIGdldCB2YXVsdFRva2VuKCkge1xuICAgIHJldHVybiB0aGlzLl92YXVsdFRva2VuO1xuICB9XG4gIHB1YmxpYyBzZXQgdmF1bHRUb2tlbih2YWx1ZTogc3RyaW5nIHwgdW5kZWZpbmVkKSB7XG4gICAgdGhpcy5fdmF1bHRUb2tlbiA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldFZhdWx0VG9rZW4oKSB7XG4gICAgdGhpcy5fdmF1bHRUb2tlbiA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgdmF1bHRUb2tlbklucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl92YXVsdFRva2VuO1xuICB9XG5cbiAgLy8gYWxpYXMgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfYWxpYXM/OiBzdHJpbmc7IFxuICBwdWJsaWMgZ2V0IGFsaWFzKCkge1xuICAgIHJldHVybiB0aGlzLl9hbGlhcztcbiAgfVxuICBwdWJsaWMgc2V0IGFsaWFzKHZhbHVlOiBzdHJpbmcgfCB1bmRlZmluZWQpIHtcbiAgICB0aGlzLl9hbGlhcyA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldEFsaWFzKCkge1xuICAgIHRoaXMuX2FsaWFzID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCBhbGlhc0lucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9hbGlhcztcbiAgfVxuXG4gIC8vIGhlYWRlcnMgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfaGVhZGVycz86IE5vbWFkUHJvdmlkZXJIZWFkZXJzW10gfCBjZGt0Zi5JUmVzb2x2YWJsZTsgXG4gIHB1YmxpYyBnZXQgaGVhZGVycygpIHtcbiAgICByZXR1cm4gdGhpcy5faGVhZGVycztcbiAgfVxuICBwdWJsaWMgc2V0IGhlYWRlcnModmFsdWU6IE5vbWFkUHJvdmlkZXJIZWFkZXJzW10gfCBjZGt0Zi5JUmVzb2x2YWJsZSB8IHVuZGVmaW5lZCkge1xuICAgIHRoaXMuX2hlYWRlcnMgPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXRIZWFkZXJzKCkge1xuICAgIHRoaXMuX2hlYWRlcnMgPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IGhlYWRlcnNJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5faGVhZGVycztcbiAgfVxuXG4gIC8vID09PT09PT09PVxuICAvLyBTWU5USEVTSVNcbiAgLy8gPT09PT09PT09XG5cbiAgcHJvdGVjdGVkIHN5bnRoZXNpemVBdHRyaWJ1dGVzKCk6IHsgW25hbWU6IHN0cmluZ106IGFueSB9IHtcbiAgICByZXR1cm4ge1xuICAgICAgYWRkcmVzczogY2RrdGYuc3RyaW5nVG9UZXJyYWZvcm0odGhpcy5fYWRkcmVzcyksXG4gICAgICBjYV9maWxlOiBjZGt0Zi5zdHJpbmdUb1RlcnJhZm9ybSh0aGlzLl9jYUZpbGUpLFxuICAgICAgY2FfcGVtOiBjZGt0Zi5zdHJpbmdUb1RlcnJhZm9ybSh0aGlzLl9jYVBlbSksXG4gICAgICBjZXJ0X2ZpbGU6IGNka3RmLnN0cmluZ1RvVGVycmFmb3JtKHRoaXMuX2NlcnRGaWxlKSxcbiAgICAgIGNlcnRfcGVtOiBjZGt0Zi5zdHJpbmdUb1RlcnJhZm9ybSh0aGlzLl9jZXJ0UGVtKSxcbiAgICAgIGNvbnN1bF90b2tlbjogY2RrdGYuc3RyaW5nVG9UZXJyYWZvcm0odGhpcy5fY29uc3VsVG9rZW4pLFxuICAgICAgaHR0cF9hdXRoOiBjZGt0Zi5zdHJpbmdUb1RlcnJhZm9ybSh0aGlzLl9odHRwQXV0aCksXG4gICAgICBpZ25vcmVfZW52X3ZhcnM6IGNka3RmLmhhc2hNYXBwZXIoY2RrdGYuYm9vbGVhblRvVGVycmFmb3JtKSh0aGlzLl9pZ25vcmVFbnZWYXJzKSxcbiAgICAgIGtleV9maWxlOiBjZGt0Zi5zdHJpbmdUb1RlcnJhZm9ybSh0aGlzLl9rZXlGaWxlKSxcbiAgICAgIGtleV9wZW06IGNka3RmLnN0cmluZ1RvVGVycmFmb3JtKHRoaXMuX2tleVBlbSksXG4gICAgICByZWdpb246IGNka3RmLnN0cmluZ1RvVGVycmFmb3JtKHRoaXMuX3JlZ2lvbiksXG4gICAgICBzZWNyZXRfaWQ6IGNka3RmLnN0cmluZ1RvVGVycmFmb3JtKHRoaXMuX3NlY3JldElkKSxcbiAgICAgIHNraXBfdmVyaWZ5OiBjZGt0Zi5ib29sZWFuVG9UZXJyYWZvcm0odGhpcy5fc2tpcFZlcmlmeSksXG4gICAgICB2YXVsdF90b2tlbjogY2RrdGYuc3RyaW5nVG9UZXJyYWZvcm0odGhpcy5fdmF1bHRUb2tlbiksXG4gICAgICBhbGlhczogY2RrdGYuc3RyaW5nVG9UZXJyYWZvcm0odGhpcy5fYWxpYXMpLFxuICAgICAgaGVhZGVyczogY2RrdGYubGlzdE1hcHBlcihub21hZFByb3ZpZGVySGVhZGVyc1RvVGVycmFmb3JtLCB0cnVlKSh0aGlzLl9oZWFkZXJzKSxcbiAgICB9O1xuICB9XG59XG4iXX0=