"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SchedulerConfig = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/scheduler_config nomad_scheduler_config}
*/
class SchedulerConfig extends cdktf.TerraformResource {
    // ==============
    // STATIC Methods
    // ==============
    /**
    * Generates CDKTF code for importing a SchedulerConfig resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the SchedulerConfig to import
    * @param importFromId The id of the existing SchedulerConfig that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/scheduler_config#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the SchedulerConfig to import is found
    */
    static generateConfigForImport(scope, importToId, importFromId, provider) {
        return new cdktf.ImportableResource(scope, importToId, { terraformResourceType: "nomad_scheduler_config", importId: importFromId, provider });
    }
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/scheduler_config nomad_scheduler_config} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SchedulerConfigConfig = {}
    */
    constructor(scope, id, config = {}) {
        super(scope, id, {
            terraformResourceType: 'nomad_scheduler_config',
            terraformGeneratorMetadata: {
                providerName: 'nomad',
                providerVersion: '2.0.0',
                providerVersionConstraint: '~> 2.0'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle,
            provisioners: config.provisioners,
            connection: config.connection,
            forEach: config.forEach
        });
        this._id = config.id;
        this._memoryOversubscriptionEnabled = config.memoryOversubscriptionEnabled;
        this._preemptionConfig = config.preemptionConfig;
        this._schedulerAlgorithm = config.schedulerAlgorithm;
    }
    get id() {
        return this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    resetId() {
        this._id = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get idInput() {
        return this._id;
    }
    get memoryOversubscriptionEnabled() {
        return this.getBooleanAttribute('memory_oversubscription_enabled');
    }
    set memoryOversubscriptionEnabled(value) {
        this._memoryOversubscriptionEnabled = value;
    }
    resetMemoryOversubscriptionEnabled() {
        this._memoryOversubscriptionEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get memoryOversubscriptionEnabledInput() {
        return this._memoryOversubscriptionEnabled;
    }
    get preemptionConfig() {
        return this.getBooleanMapAttribute('preemption_config');
    }
    set preemptionConfig(value) {
        this._preemptionConfig = value;
    }
    resetPreemptionConfig() {
        this._preemptionConfig = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get preemptionConfigInput() {
        return this._preemptionConfig;
    }
    get schedulerAlgorithm() {
        return this.getStringAttribute('scheduler_algorithm');
    }
    set schedulerAlgorithm(value) {
        this._schedulerAlgorithm = value;
    }
    resetSchedulerAlgorithm() {
        this._schedulerAlgorithm = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get schedulerAlgorithmInput() {
        return this._schedulerAlgorithm;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            id: cdktf.stringToTerraform(this._id),
            memory_oversubscription_enabled: cdktf.booleanToTerraform(this._memoryOversubscriptionEnabled),
            preemption_config: cdktf.hashMapper(cdktf.booleanToTerraform)(this._preemptionConfig),
            scheduler_algorithm: cdktf.stringToTerraform(this._schedulerAlgorithm),
        };
    }
}
exports.SchedulerConfig = SchedulerConfig;
_a = JSII_RTTI_SYMBOL_1;
SchedulerConfig[_a] = { fqn: "@cdktf/provider-nomad.schedulerConfig.SchedulerConfig", version: "8.0.0" };
// =================
// STATIC PROPERTIES
// =================
SchedulerConfig.tfResourceType = "nomad_scheduler_config";
//# sourceMappingURL=data:application/json;base64,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