/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface VolumeConfig extends cdktf.TerraformMetaArguments {
    /**
    * Defines whether a volume should be available concurrently.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/volume#access_mode Volume#access_mode}
    */
    readonly accessMode?: string;
    /**
    * The storage API that will be used by the volume.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/volume#attachment_mode Volume#attachment_mode}
    */
    readonly attachmentMode?: string;
    /**
    * An optional key-value map of strings passed directly to the CSI plugin to validate the volume.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/volume#context Volume#context}
    */
    readonly context?: {
        [key: string]: string;
    };
    /**
    * If true, the volume will be deregistered on destroy.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/volume#deregister_on_destroy Volume#deregister_on_destroy}
    */
    readonly deregisterOnDestroy?: boolean | cdktf.IResolvable;
    /**
    * The ID of the physical volume from the storage provider.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/volume#external_id Volume#external_id}
    */
    readonly externalId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/volume#id Volume#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The display name of the volume.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/volume#name Volume#name}
    */
    readonly name: string;
    /**
    * The namespace in which to create the volume.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/volume#namespace Volume#namespace}
    */
    readonly namespace?: string;
    /**
    * An optional key-value map of strings passed directly to the CSI plugin to configure the volume.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/volume#parameters Volume#parameters}
    */
    readonly parameters?: {
        [key: string]: string;
    };
    /**
    * The ID of the CSI plugin that manages this volume.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/volume#plugin_id Volume#plugin_id}
    */
    readonly pluginId: string;
    /**
    * An optional key-value map of strings used as credentials for publishing and unpublishing volumes.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/volume#secrets Volume#secrets}
    */
    readonly secrets?: {
        [key: string]: string;
    };
    /**
    * The type of the volume. Currently, only 'csi' is supported.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/volume#type Volume#type}
    */
    readonly type?: string;
    /**
    * The unique ID of the volume, how jobs will refer to the volume.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/volume#volume_id Volume#volume_id}
    */
    readonly volumeId: string;
    /**
    * capability block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/volume#capability Volume#capability}
    */
    readonly capability?: VolumeCapability[] | cdktf.IResolvable;
    /**
    * mount_options block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/volume#mount_options Volume#mount_options}
    */
    readonly mountOptions?: VolumeMountOptions;
    /**
    * topology_request block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/volume#topology_request Volume#topology_request}
    */
    readonly topologyRequest?: VolumeTopologyRequest;
}
export interface VolumeTopologies {
}
export declare function volumeTopologiesToTerraform(struct?: VolumeTopologies): any;
export declare class VolumeTopologiesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): VolumeTopologies | undefined;
    set internalValue(value: VolumeTopologies | undefined);
    private _segments;
    get segments(): cdktf.StringMap;
}
export declare class VolumeTopologiesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): VolumeTopologiesOutputReference;
}
export interface VolumeCapability {
    /**
    * Defines whether a volume should be available concurrently.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/volume#access_mode Volume#access_mode}
    */
    readonly accessMode: string;
    /**
    * The storage API that will be used by the volume.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/volume#attachment_mode Volume#attachment_mode}
    */
    readonly attachmentMode: string;
}
export declare function volumeCapabilityToTerraform(struct?: VolumeCapability | cdktf.IResolvable): any;
export declare class VolumeCapabilityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): VolumeCapability | cdktf.IResolvable | undefined;
    set internalValue(value: VolumeCapability | cdktf.IResolvable | undefined);
    private _accessMode?;
    get accessMode(): string;
    set accessMode(value: string);
    get accessModeInput(): string | undefined;
    private _attachmentMode?;
    get attachmentMode(): string;
    set attachmentMode(value: string);
    get attachmentModeInput(): string | undefined;
}
export declare class VolumeCapabilityList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: VolumeCapability[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): VolumeCapabilityOutputReference;
}
export interface VolumeMountOptions {
    /**
    * The file system type.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/volume#fs_type Volume#fs_type}
    */
    readonly fsType?: string;
    /**
    * The flags passed to mount.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/volume#mount_flags Volume#mount_flags}
    */
    readonly mountFlags?: string[];
}
export declare function volumeMountOptionsToTerraform(struct?: VolumeMountOptionsOutputReference | VolumeMountOptions): any;
export declare class VolumeMountOptionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): VolumeMountOptions | undefined;
    set internalValue(value: VolumeMountOptions | undefined);
    private _fsType?;
    get fsType(): string;
    set fsType(value: string);
    resetFsType(): void;
    get fsTypeInput(): string | undefined;
    private _mountFlags?;
    get mountFlags(): string[];
    set mountFlags(value: string[]);
    resetMountFlags(): void;
    get mountFlagsInput(): string[] | undefined;
}
export interface VolumeTopologyRequestRequiredTopology {
    /**
    * Define attributes for the topology request.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/volume#segments Volume#segments}
    */
    readonly segments: {
        [key: string]: string;
    };
}
export declare function volumeTopologyRequestRequiredTopologyToTerraform(struct?: VolumeTopologyRequestRequiredTopology | cdktf.IResolvable): any;
export declare class VolumeTopologyRequestRequiredTopologyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): VolumeTopologyRequestRequiredTopology | cdktf.IResolvable | undefined;
    set internalValue(value: VolumeTopologyRequestRequiredTopology | cdktf.IResolvable | undefined);
    private _segments?;
    get segments(): {
        [key: string]: string;
    };
    set segments(value: {
        [key: string]: string;
    });
    get segmentsInput(): {
        [key: string]: string;
    } | undefined;
}
export declare class VolumeTopologyRequestRequiredTopologyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: VolumeTopologyRequestRequiredTopology[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): VolumeTopologyRequestRequiredTopologyOutputReference;
}
export interface VolumeTopologyRequestRequired {
    /**
    * topology block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/volume#topology Volume#topology}
    */
    readonly topology: VolumeTopologyRequestRequiredTopology[] | cdktf.IResolvable;
}
export declare function volumeTopologyRequestRequiredToTerraform(struct?: VolumeTopologyRequestRequiredOutputReference | VolumeTopologyRequestRequired): any;
export declare class VolumeTopologyRequestRequiredOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): VolumeTopologyRequestRequired | undefined;
    set internalValue(value: VolumeTopologyRequestRequired | undefined);
    private _topology;
    get topology(): VolumeTopologyRequestRequiredTopologyList;
    putTopology(value: VolumeTopologyRequestRequiredTopology[] | cdktf.IResolvable): void;
    get topologyInput(): cdktf.IResolvable | VolumeTopologyRequestRequiredTopology[] | undefined;
}
export interface VolumeTopologyRequest {
    /**
    * required block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/volume#required Volume#required}
    */
    readonly required?: VolumeTopologyRequestRequired;
}
export declare function volumeTopologyRequestToTerraform(struct?: VolumeTopologyRequestOutputReference | VolumeTopologyRequest): any;
export declare class VolumeTopologyRequestOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): VolumeTopologyRequest | undefined;
    set internalValue(value: VolumeTopologyRequest | undefined);
    private _required;
    get required(): VolumeTopologyRequestRequiredOutputReference;
    putRequired(value: VolumeTopologyRequestRequired): void;
    resetRequired(): void;
    get requiredInput(): VolumeTopologyRequestRequired | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/volume nomad_volume}
*/
export declare class Volume extends cdktf.TerraformResource {
    static readonly tfResourceType = "nomad_volume";
    /**
    * Generates CDKTF code for importing a Volume resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the Volume to import
    * @param importFromId The id of the existing Volume that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/volume#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the Volume to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/nomad/2.0.0/docs/resources/volume nomad_volume} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options VolumeConfig
    */
    constructor(scope: Construct, id: string, config: VolumeConfig);
    private _accessMode?;
    get accessMode(): string;
    set accessMode(value: string);
    resetAccessMode(): void;
    get accessModeInput(): string | undefined;
    private _attachmentMode?;
    get attachmentMode(): string;
    set attachmentMode(value: string);
    resetAttachmentMode(): void;
    get attachmentModeInput(): string | undefined;
    private _context?;
    get context(): {
        [key: string]: string;
    };
    set context(value: {
        [key: string]: string;
    });
    resetContext(): void;
    get contextInput(): {
        [key: string]: string;
    } | undefined;
    get controllerRequired(): cdktf.IResolvable;
    get controllersExpected(): number;
    get controllersHealthy(): number;
    private _deregisterOnDestroy?;
    get deregisterOnDestroy(): boolean | cdktf.IResolvable;
    set deregisterOnDestroy(value: boolean | cdktf.IResolvable);
    resetDeregisterOnDestroy(): void;
    get deregisterOnDestroyInput(): boolean | cdktf.IResolvable | undefined;
    private _externalId?;
    get externalId(): string;
    set externalId(value: string);
    get externalIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    resetNamespace(): void;
    get namespaceInput(): string | undefined;
    get nodesExpected(): number;
    get nodesHealthy(): number;
    private _parameters?;
    get parameters(): {
        [key: string]: string;
    };
    set parameters(value: {
        [key: string]: string;
    });
    resetParameters(): void;
    get parametersInput(): {
        [key: string]: string;
    } | undefined;
    private _pluginId?;
    get pluginId(): string;
    set pluginId(value: string);
    get pluginIdInput(): string | undefined;
    get pluginProvider(): string;
    get pluginProviderVersion(): string;
    get schedulable(): cdktf.IResolvable;
    private _secrets?;
    get secrets(): {
        [key: string]: string;
    };
    set secrets(value: {
        [key: string]: string;
    });
    resetSecrets(): void;
    get secretsInput(): {
        [key: string]: string;
    } | undefined;
    private _topologies;
    get topologies(): VolumeTopologiesList;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
    private _volumeId?;
    get volumeId(): string;
    set volumeId(value: string);
    get volumeIdInput(): string | undefined;
    private _capability;
    get capability(): VolumeCapabilityList;
    putCapability(value: VolumeCapability[] | cdktf.IResolvable): void;
    resetCapability(): void;
    get capabilityInput(): cdktf.IResolvable | VolumeCapability[] | undefined;
    private _mountOptions;
    get mountOptions(): VolumeMountOptionsOutputReference;
    putMountOptions(value: VolumeMountOptions): void;
    resetMountOptions(): void;
    get mountOptionsInput(): VolumeMountOptions | undefined;
    private _topologyRequest;
    get topologyRequest(): VolumeTopologyRequestOutputReference;
    putTopologyRequest(value: VolumeTopologyRequest): void;
    resetTopologyRequest(): void;
    get topologyRequestInput(): VolumeTopologyRequest | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
