"""
  This module containes the _FyTok_ wrapper of IMAS/dd/dataset_description
  Generate at 2023-10-17T11:53:10.881387+08:00
  FyTok (rev: 0.0.0) 
 
"""

from ...modules.Utilities import *

    
from .utilities import _T_data_entry

class _T_dataset_description_simulation(SpTree):
	"""Description of the general simulation characteristics, if this data entry has
		been produced by a simulation. Several nodes describe typical time-dependent
		simulation with a time evolution as the main loop"""

	comment_before  :str =  sp_property(type="constant")
	""" Comment made when launching a simulation"""

	comment_after  :str =  sp_property(type="constant")
	""" Comment made at the end of a simulation"""

	time_begin  :float =  sp_property(type="constant",units="s")
	""" Start time"""

	time_step  :float =  sp_property(type="constant",units="s")
	""" Time interval between main steps, e.g. storage step (if relevant and constant)"""

	time_end  :float =  sp_property(type="constant",units="s")
	""" Stop time"""

	time_restart  :float =  sp_property(type="constant",units="s")
	""" Time of the last restart done during the simulation"""

	time_current  :float =  sp_property(type="constant",units="s")
	""" Current time of the simulation"""

	time_begun  :str =  sp_property(type="constant",units="UTC")
	""" Actual wall-clock time simulation started"""

	time_ended  :str =  sp_property(type="constant",units="UTC")
	""" Actual wall-clock time simulation finished"""

	workflow  :str =  sp_property(type="constant")
	""" Description of the workflow which has been used to produce this data entry (e.g.
		copy of the Kepler MOML if using Kepler)"""


class _T_dataset_description_epoch_time(SpTree):
	"""Epoch time represented as two integers, since for the moment IMAS is missing
		64bits long integers to represent epoch time with nanoseconds resolution"""

	seconds  :int =  sp_property(type="constant")
	""" Elapsed seconds since the Unix Epoch time (01/01/1970 00:00:00 UTC)"""

	nanoseconds  :int =  sp_property(type="constant")
	""" Elapsed nanoseconds since the time in seconds indicated above"""


class _T_dataset_description(IDS):
	"""General description of the dataset (collection of all IDSs within the given
		database entry). Main description text to be put in ids_properties/comment
	lifecycle_status: alpha
	lifecycle_version: 3.0.4
	lifecycle_last_change: 3.30.0"""

	dd_version="v3_38_1_dirty"
	ids_name="dataset_description"

	data_entry  :_T_data_entry =  sp_property()
	""" Definition of this data entry"""

	parent_entry  :_T_data_entry =  sp_property()
	""" Definition of the parent data entry, if the present data entry has been
		generated by applying a given workflow to a unique parent entry"""

	pulse_time_begin  :str =  sp_property(type="constant")
	""" Date and time (UTC) at which the pulse started on the experiment, expressed in a
		human readable form (ISO 8601) : the format of the string shall be :
		YYYY-MM-DDTHH:MM:SSZ. Example : 2020-07-24T14:19:00Z"""

	pulse_time_begin_epoch  :_T_dataset_description_epoch_time =  sp_property()
	""" Time at which the pulse started on the experiment, expressed in Unix Epoch time.
		Temporarily represented as two integers, since for the moment IMAS is missing
		64bits long integers to represent epoch time with nanoseconds resolution"""

	pulse_time_end_epoch  :_T_dataset_description_epoch_time =  sp_property()
	""" Time at which the pulse ended on the experiment, expressed in Unix Epoch time.
		Temporarily represented as two integers, since for the moment IMAS is missing
		64bits long integers to represent epoch time with nanoseconds resolution"""

	imas_version  :str =  sp_property(type="constant")
	""" Version of the IMAS infrastructure used to produce this data entry. Refers to
		the global IMAS repository which links to versions of every infrastructure tools"""

	dd_version  :str =  sp_property(type="constant")
	""" Version of the physics data dictionary of this dataset"""

	simulation  :_T_dataset_description_simulation =  sp_property()
	""" Description of the general simulation characteristics, if this data entry has
		been produced by a simulation. Several nodes describe typical time-dependent
		simulation with a time evolution as the main loop"""
