import type {Metadata} from 'next';
import {Geist, Geist_Mono} from 'next/font/google';
import {ReactNode} from 'react';

import './css/colors.css';
import './css/globals.css';
import styles from './css/layout.module.css';

import PackageTree from '@/app/components/PackageTree';
import Header from '@/app/components/Header';
import clsx from 'clsx';

const geistSans = Geist({
  variable: '--font-geist-sans',
  subsets: ['latin'],
});

const geistMono = Geist_Mono({
  variable: '--font-geist-mono',
  subsets: ['latin'],
});

export const metadata: Metadata = {
  title: 'dg docs',
  description: 'Generated by dg docs',
  icons: {
    icon: '/favicon.svg',
  },
};

export default async function RootLayout({
  children,
}: Readonly<{
  children: ReactNode;
}>) {
  return (
    <html lang="en">
      <body className={clsx(geistSans.variable, geistMono.variable)}>
        <div className={styles.outer}>
          <Header />
          <div className={styles.contentContainer}>
            <div className={styles.sidebar}>
              <PackageTree />
            </div>
            <div className={styles.main}>{children}</div>
          </div>
        </div>
      </body>
    </html>
  );
}
