/* Autogenerated by mlir-tblgen; don't manually edit */
#ifdef GEN_PASS_CLASSES

//===----------------------------------------------------------------------===//
// ClusterConstantSinkingPass
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class ClusterConstantSinkingPassBase : public ::mlir::FunctionPass {
public:
  using Base = ClusterConstantSinkingPassBase;

  ClusterConstantSinkingPassBase() : ::mlir::FunctionPass(::mlir::TypeID::get<DerivedT>()) {}
  ClusterConstantSinkingPassBase(const ClusterConstantSinkingPassBase &) : ::mlir::FunctionPass(::mlir::TypeID::get<DerivedT>()) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("tf-device-constant-sinking");
  }
  ::llvm::StringRef getArgument() const override { return "tf-device-constant-sinking"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("ClusterConstantSinkingPass");
  }
  ::llvm::StringRef getName() const override { return "ClusterConstantSinkingPass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

protected:
};

//===----------------------------------------------------------------------===//
// ClusterOpsByPolicyPass
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class ClusterOpsByPolicyPassBase : public ::mlir::FunctionPass {
public:
  using Base = ClusterOpsByPolicyPassBase;

  ClusterOpsByPolicyPassBase() : ::mlir::FunctionPass(::mlir::TypeID::get<DerivedT>()) {}
  ClusterOpsByPolicyPassBase(const ClusterOpsByPolicyPassBase &) : ::mlir::FunctionPass(::mlir::TypeID::get<DerivedT>()) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("cluster-ops-by-policy");
  }
  ::llvm::StringRef getArgument() const override { return "cluster-ops-by-policy"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("ClusterOpsByPolicyPass");
  }
  ::llvm::StringRef getName() const override { return "ClusterOpsByPolicyPass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  registry.insert<mlir::tf_device::TensorFlowDeviceDialect>();

  }

protected:
  ::mlir::Pass::Option<std::string> policy_name{*this, "policy-name", ::llvm::cl::desc("Adds a policy string attribute to all extracted clusters. This attribute allows to distinguish clusters formed by different policies or maybe other clustering algorithms.")};
  ::mlir::Pass::Option<int> min_cluster_size{*this, "min-cluster-size", ::llvm::cl::desc("Do not form clusters smaller of the given size."), ::llvm::cl::init(1)};
  ::mlir::Pass::Option<std::string> algorithm{*this, "algorithm", ::llvm::cl::desc("Clustering algorithm type: `use-def` or `union-find`"), ::llvm::cl::init("use-def")};
  ::mlir::Pass::ListOption<std::string> oplist{*this, "oplist", ::llvm::cl::desc("Cluster listed ops when they form a single use def-use chain, such that each op's single user is the next op in the list."), llvm::cl::MiscFlags::CommaSeparated};
};

//===----------------------------------------------------------------------===//
// ClusterOutliningPass
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class ClusterOutliningPassBase : public ::mlir::OperationPass<ModuleOp> {
public:
  using Base = ClusterOutliningPassBase;

  ClusterOutliningPassBase() : ::mlir::OperationPass<ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  ClusterOutliningPassBase(const ClusterOutliningPassBase &) : ::mlir::OperationPass<ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("tf-device-cluster-outlining");
  }
  ::llvm::StringRef getArgument() const override { return "tf-device-cluster-outlining"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("ClusterOutliningPass");
  }
  ::llvm::StringRef getName() const override { return "ClusterOutliningPass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

protected:
};

//===----------------------------------------------------------------------===//
// DeviceAttributeToLaunchPass
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class DeviceAttributeToLaunchPassBase : public ::mlir::FunctionPass {
public:
  using Base = DeviceAttributeToLaunchPassBase;

  DeviceAttributeToLaunchPassBase() : ::mlir::FunctionPass(::mlir::TypeID::get<DerivedT>()) {}
  DeviceAttributeToLaunchPassBase(const DeviceAttributeToLaunchPassBase &) : ::mlir::FunctionPass(::mlir::TypeID::get<DerivedT>()) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("tf-device-attribute-to-launch");
  }
  ::llvm::StringRef getArgument() const override { return "tf-device-attribute-to-launch"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("DeviceAttributeToLaunchPass");
  }
  ::llvm::StringRef getName() const override { return "DeviceAttributeToLaunchPass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

protected:
};

//===----------------------------------------------------------------------===//
// ExecutorDialectToFunctionalPass
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class ExecutorDialectToFunctionalPassBase : public ::mlir::FunctionPass {
public:
  using Base = ExecutorDialectToFunctionalPassBase;

  ExecutorDialectToFunctionalPassBase() : ::mlir::FunctionPass(::mlir::TypeID::get<DerivedT>()) {}
  ExecutorDialectToFunctionalPassBase(const ExecutorDialectToFunctionalPassBase &) : ::mlir::FunctionPass(::mlir::TypeID::get<DerivedT>()) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("tf-executor-to-functional-conversion");
  }
  ::llvm::StringRef getArgument() const override { return "tf-executor-to-functional-conversion"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("ExecutorDialectToFunctionalPass");
  }
  ::llvm::StringRef getName() const override { return "ExecutorDialectToFunctionalPass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

protected:
};

//===----------------------------------------------------------------------===//
// ExecutorGraphPruningPass
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class ExecutorGraphPruningPassBase : public ::mlir::FunctionPass {
public:
  using Base = ExecutorGraphPruningPassBase;

  ExecutorGraphPruningPassBase() : ::mlir::FunctionPass(::mlir::TypeID::get<DerivedT>()) {}
  ExecutorGraphPruningPassBase(const ExecutorGraphPruningPassBase &) : ::mlir::FunctionPass(::mlir::TypeID::get<DerivedT>()) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("tf-executor-graph-pruning");
  }
  ::llvm::StringRef getArgument() const override { return "tf-executor-graph-pruning"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("ExecutorGraphPruningPass");
  }
  ::llvm::StringRef getName() const override { return "ExecutorGraphPruningPass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

protected:
  ::mlir::Pass::ListOption<std::string> ops_to_preserve_{*this, "ops-to-preserve", ::llvm::cl::desc("Comma separated list of ops that should not be pruned regardless of reachability"), llvm::cl::MiscFlags::CommaSeparated};
};

//===----------------------------------------------------------------------===//
// FunctionalControlFlowToRegionsPass
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class FunctionalControlFlowToRegionsPassBase : public ::mlir::OperationPass<ModuleOp> {
public:
  using Base = FunctionalControlFlowToRegionsPassBase;

  FunctionalControlFlowToRegionsPassBase() : ::mlir::OperationPass<ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  FunctionalControlFlowToRegionsPassBase(const FunctionalControlFlowToRegionsPassBase &) : ::mlir::OperationPass<ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("tf-functional-control-flow-to-regions");
  }
  ::llvm::StringRef getArgument() const override { return "tf-functional-control-flow-to-regions"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("FunctionalControlFlowToRegionsPass");
  }
  ::llvm::StringRef getName() const override { return "FunctionalControlFlowToRegionsPass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

protected:
};

//===----------------------------------------------------------------------===//
// MarkOpsForOutsideCompilationPass
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class MarkOpsForOutsideCompilationPassBase : public ::mlir::OperationPass<ModuleOp> {
public:
  using Base = MarkOpsForOutsideCompilationPassBase;

  MarkOpsForOutsideCompilationPassBase() : ::mlir::OperationPass<ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  MarkOpsForOutsideCompilationPassBase(const MarkOpsForOutsideCompilationPassBase &) : ::mlir::OperationPass<ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("tf-mark-ops-for-outside-compilation");
  }
  ::llvm::StringRef getArgument() const override { return "tf-mark-ops-for-outside-compilation"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("MarkOpsForOutsideCompilationPass");
  }
  ::llvm::StringRef getName() const override { return "MarkOpsForOutsideCompilationPass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

protected:
};

//===----------------------------------------------------------------------===//
// PrepareTpuComputationForTfExportPass
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class PrepareTpuComputationForTfExportPassBase : public ::mlir::OperationPass<FuncOp> {
public:
  using Base = PrepareTpuComputationForTfExportPassBase;

  PrepareTpuComputationForTfExportPassBase() : ::mlir::OperationPass<FuncOp>(::mlir::TypeID::get<DerivedT>()) {}
  PrepareTpuComputationForTfExportPassBase(const PrepareTpuComputationForTfExportPassBase &) : ::mlir::OperationPass<FuncOp>(::mlir::TypeID::get<DerivedT>()) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("prepare-tpu-computation-for-tf-export");
  }
  ::llvm::StringRef getArgument() const override { return "prepare-tpu-computation-for-tf-export"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("PrepareTpuComputationForTfExportPass");
  }
  ::llvm::StringRef getName() const override { return "PrepareTpuComputationForTfExportPass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

protected:
};

//===----------------------------------------------------------------------===//
// RegionControlFlowToFunctionalPass
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class RegionControlFlowToFunctionalPassBase : public ::mlir::OperationPass<ModuleOp> {
public:
  using Base = RegionControlFlowToFunctionalPassBase;

  RegionControlFlowToFunctionalPassBase() : ::mlir::OperationPass<ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  RegionControlFlowToFunctionalPassBase(const RegionControlFlowToFunctionalPassBase &) : ::mlir::OperationPass<ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("tf-region-control-flow-to-functional");
  }
  ::llvm::StringRef getArgument() const override { return "tf-region-control-flow-to-functional"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("RegionControlFlowToFunctionalPass");
  }
  ::llvm::StringRef getName() const override { return "RegionControlFlowToFunctionalPass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

protected:
};

//===----------------------------------------------------------------------===//
// TPUClusterFormationPass
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class TPUClusterFormationPassBase : public ::mlir::OperationPass<ModuleOp> {
public:
  using Base = TPUClusterFormationPassBase;

  TPUClusterFormationPassBase() : ::mlir::OperationPass<ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  TPUClusterFormationPassBase(const TPUClusterFormationPassBase &) : ::mlir::OperationPass<ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("tf-tpu-cluster-formation");
  }
  ::llvm::StringRef getArgument() const override { return "tf-tpu-cluster-formation"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("TPUClusterFormationPass");
  }
  ::llvm::StringRef getName() const override { return "TPUClusterFormationPass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

protected:
};

//===----------------------------------------------------------------------===//
// TPUExtractOutsideCompilationPass
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class TPUExtractOutsideCompilationPassBase : public ::mlir::OperationPass<ModuleOp> {
public:
  using Base = TPUExtractOutsideCompilationPassBase;

  TPUExtractOutsideCompilationPassBase() : ::mlir::OperationPass<ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  TPUExtractOutsideCompilationPassBase(const TPUExtractOutsideCompilationPassBase &) : ::mlir::OperationPass<ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("tf-tpu-extract-outside-compilation");
  }
  ::llvm::StringRef getArgument() const override { return "tf-tpu-extract-outside-compilation"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("TPUExtractOutsideCompilationPass");
  }
  ::llvm::StringRef getName() const override { return "TPUExtractOutsideCompilationPass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

protected:
};

//===----------------------------------------------------------------------===//
// TPUReorderReplicateAndPartitionedInputsPass
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class TPUReorderReplicateAndPartitionedInputsPassBase : public ::mlir::FunctionPass {
public:
  using Base = TPUReorderReplicateAndPartitionedInputsPassBase;

  TPUReorderReplicateAndPartitionedInputsPassBase() : ::mlir::FunctionPass(::mlir::TypeID::get<DerivedT>()) {}
  TPUReorderReplicateAndPartitionedInputsPassBase(const TPUReorderReplicateAndPartitionedInputsPassBase &) : ::mlir::FunctionPass(::mlir::TypeID::get<DerivedT>()) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("tf-tpu-reorder-replicate-partitioned-inputs");
  }
  ::llvm::StringRef getArgument() const override { return "tf-tpu-reorder-replicate-partitioned-inputs"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("TPUReorderReplicateAndPartitionedInputsPass");
  }
  ::llvm::StringRef getName() const override { return "TPUReorderReplicateAndPartitionedInputsPass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

protected:
};

//===----------------------------------------------------------------------===//
// TPUResourceReadForWritePass
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class TPUResourceReadForWritePassBase : public ::mlir::OperationPass<ModuleOp> {
public:
  using Base = TPUResourceReadForWritePassBase;

  TPUResourceReadForWritePassBase() : ::mlir::OperationPass<ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  TPUResourceReadForWritePassBase(const TPUResourceReadForWritePassBase &) : ::mlir::OperationPass<ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("tf-tpu-resource-read-for-write");
  }
  ::llvm::StringRef getArgument() const override { return "tf-tpu-resource-read-for-write"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("TPUResourceReadForWritePass");
  }
  ::llvm::StringRef getName() const override { return "TPUResourceReadForWritePass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

protected:
};

//===----------------------------------------------------------------------===//
// TPUResourceReadsWritesPartitioningPass
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class TPUResourceReadsWritesPartitioningPassBase : public ::mlir::FunctionPass {
public:
  using Base = TPUResourceReadsWritesPartitioningPassBase;

  TPUResourceReadsWritesPartitioningPassBase() : ::mlir::FunctionPass(::mlir::TypeID::get<DerivedT>()) {}
  TPUResourceReadsWritesPartitioningPassBase(const TPUResourceReadsWritesPartitioningPassBase &) : ::mlir::FunctionPass(::mlir::TypeID::get<DerivedT>()) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("tf-tpu-resource-partition");
  }
  ::llvm::StringRef getArgument() const override { return "tf-tpu-resource-partition"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("TPUResourceReadsWritesPartitioningPass");
  }
  ::llvm::StringRef getName() const override { return "TPUResourceReadsWritesPartitioningPass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

protected:
};

//===----------------------------------------------------------------------===//
// TPURewritePass
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class TPURewritePassBase : public ::mlir::OperationPass<ModuleOp> {
public:
  using Base = TPURewritePassBase;

  TPURewritePassBase() : ::mlir::OperationPass<ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  TPURewritePassBase(const TPURewritePassBase &) : ::mlir::OperationPass<ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("tf-tpu-rewrite");
  }
  ::llvm::StringRef getArgument() const override { return "tf-tpu-rewrite"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("TPURewritePass");
  }
  ::llvm::StringRef getName() const override { return "TPURewritePass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

protected:
};

//===----------------------------------------------------------------------===//
// TensorFlowShapeInferencePass
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class TensorFlowShapeInferencePassBase : public ::mlir::OperationPass<ModuleOp> {
public:
  using Base = TensorFlowShapeInferencePassBase;

  TensorFlowShapeInferencePassBase() : ::mlir::OperationPass<ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  TensorFlowShapeInferencePassBase(const TensorFlowShapeInferencePassBase &) : ::mlir::OperationPass<ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("tf-shape-inference");
  }
  ::llvm::StringRef getArgument() const override { return "tf-shape-inference"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("TensorFlowShapeInferencePass");
  }
  ::llvm::StringRef getName() const override { return "TensorFlowShapeInferencePass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

protected:
  ::mlir::Pass::Option<int64_t> max_iterations_{*this, "max-iterations", ::llvm::cl::desc("Maximum shape inference iterations"), ::llvm::cl::init(10)};
};

//===----------------------------------------------------------------------===//
// VerifySuitableForExportPass
//===----------------------------------------------------------------------===//

template <typename DerivedT>
class VerifySuitableForExportPassBase : public ::mlir::OperationPass<ModuleOp> {
public:
  using Base = VerifySuitableForExportPassBase;

  VerifySuitableForExportPassBase() : ::mlir::OperationPass<ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}
  VerifySuitableForExportPassBase(const VerifySuitableForExportPassBase &) : ::mlir::OperationPass<ModuleOp>(::mlir::TypeID::get<DerivedT>()) {}

  /// Returns the command-line argument attached to this pass.
  static constexpr ::llvm::StringLiteral getArgumentName() {
    return ::llvm::StringLiteral("tf-verify-for-export");
  }
  ::llvm::StringRef getArgument() const override { return "tf-verify-for-export"; }

  /// Returns the derived pass name.
  static constexpr ::llvm::StringLiteral getPassName() {
    return ::llvm::StringLiteral("VerifySuitableForExportPass");
  }
  ::llvm::StringRef getName() const override { return "VerifySuitableForExportPass"; }

  /// Support isa/dyn_cast functionality for the derived pass class.
  static bool classof(const ::mlir::Pass *pass) {
    return pass->getTypeID() == ::mlir::TypeID::get<DerivedT>();
  }

  /// A clone method to create a copy of this pass.
  std::unique_ptr<::mlir::Pass> clonePass() const override {
    return std::make_unique<DerivedT>(*static_cast<const DerivedT *>(this));
  }

  /// Return the dialect that must be loaded in the context before this pass.
  void getDependentDialects(::mlir::DialectRegistry &registry) const override {
    
  }

protected:
};
#undef GEN_PASS_CLASSES
#endif // GEN_PASS_CLASSES
#ifdef GEN_PASS_REGISTRATION

//===----------------------------------------------------------------------===//
// ClusterConstantSinkingPass Registration
//===----------------------------------------------------------------------===//

inline void registerClusterConstantSinkingPassPass() {
  ::mlir::registerPass("tf-device-constant-sinking", "Sinks constants implicitly captured in a tf_device.cluster region.", []() -> std::unique_ptr<::mlir::Pass> {
    return TFDevice::CreateClusterConstantSinkingPass();
  });
}

//===----------------------------------------------------------------------===//
// ClusterOpsByPolicyPass Registration
//===----------------------------------------------------------------------===//

inline void registerClusterOpsByPolicyPassPass() {
  ::mlir::registerPass("cluster-ops-by-policy", "Clusters ops according to specified policy.", []() -> std::unique_ptr<::mlir::Pass> {
    return TFDevice::CreateClusterOpsByPolicyPass();
  });
}

//===----------------------------------------------------------------------===//
// ClusterOutliningPass Registration
//===----------------------------------------------------------------------===//

inline void registerClusterOutliningPassPass() {
  ::mlir::registerPass("tf-device-cluster-outlining", "Outlines regions of tf_device.cluster operations", []() -> std::unique_ptr<::mlir::Pass> {
    return TFDevice::CreateClusterOutliningPass();
  });
}

//===----------------------------------------------------------------------===//
// DeviceAttributeToLaunchPass Registration
//===----------------------------------------------------------------------===//

inline void registerDeviceAttributeToLaunchPassPass() {
  ::mlir::registerPass("tf-device-attribute-to-launch", "Wraps each TF op which has a non-empty device attribute in a tf_device.launch.", []() -> std::unique_ptr<::mlir::Pass> {
    return TFDevice::CreateDeviceAttributeToLaunchPass();
  });
}

//===----------------------------------------------------------------------===//
// ExecutorDialectToFunctionalPass Registration
//===----------------------------------------------------------------------===//

inline void registerExecutorDialectToFunctionalPassPass() {
  ::mlir::registerPass("tf-executor-to-functional-conversion", "Lifts tf_executor.island inner ops from a tf_executor.graph", []() -> std::unique_ptr<::mlir::Pass> {
    return CreateExecutorDialectToFunctionalConversionPass();
  });
}

//===----------------------------------------------------------------------===//
// ExecutorGraphPruningPass Registration
//===----------------------------------------------------------------------===//

inline void registerExecutorGraphPruningPassPass() {
  ::mlir::registerPass("tf-executor-graph-pruning", "Prunes unreachable ops in a tf_executor.graph", []() -> std::unique_ptr<::mlir::Pass> {
    return tf_executor::CreateTFExecutorGraphPruningPass();
  });
}

//===----------------------------------------------------------------------===//
// FunctionalControlFlowToRegionsPass Registration
//===----------------------------------------------------------------------===//

inline void registerFunctionalControlFlowToRegionsPassPass() {
  ::mlir::registerPass("tf-functional-control-flow-to-regions", "Transforms functional control flow operations to their region-based counterparts", []() -> std::unique_ptr<::mlir::Pass> {
    return TF::CreateTFFunctionalControlFlowToRegions();
  });
}

//===----------------------------------------------------------------------===//
// MarkOpsForOutsideCompilationPass Registration
//===----------------------------------------------------------------------===//

inline void registerMarkOpsForOutsideCompilationPassPass() {
  ::mlir::registerPass("tf-mark-ops-for-outside-compilation", "Marks ops in device cluster for outside compilation if they are unsupported on device.", []() -> std::unique_ptr<::mlir::Pass> {
    return TFDevice::CreateMarkOpsForOutsideCompilationPass();
  });
}

//===----------------------------------------------------------------------===//
// PrepareTpuComputationForTfExportPass Registration
//===----------------------------------------------------------------------===//

inline void registerPrepareTpuComputationForTfExportPassPass() {
  ::mlir::registerPass("prepare-tpu-computation-for-tf-export", "Prepare TPU computation to be legal for export to TensorFlow", []() -> std::unique_ptr<::mlir::Pass> {
    return TF::CreatePrepareTpuComputationForTfExportPass();
  });
}

//===----------------------------------------------------------------------===//
// RegionControlFlowToFunctionalPass Registration
//===----------------------------------------------------------------------===//

inline void registerRegionControlFlowToFunctionalPassPass() {
  ::mlir::registerPass("tf-region-control-flow-to-functional", "Transforms region-based control flow operations to their functional counterparts", []() -> std::unique_ptr<::mlir::Pass> {
    return TF::CreateTFRegionControlFlowToFunctional();
  });
}

//===----------------------------------------------------------------------===//
// TPUClusterFormationPass Registration
//===----------------------------------------------------------------------===//

inline void registerTPUClusterFormationPassPass() {
  ::mlir::registerPass("tf-tpu-cluster-formation", "Forms clusters from operations assigned to the same TPU computation", []() -> std::unique_ptr<::mlir::Pass> {
    return TFTPU::CreateTPUClusterFormationPass();
  });
}

//===----------------------------------------------------------------------===//
// TPUExtractOutsideCompilationPass Registration
//===----------------------------------------------------------------------===//

inline void registerTPUExtractOutsideCompilationPassPass() {
  ::mlir::registerPass("tf-tpu-extract-outside-compilation", "Extracts TPU outside compilation computation to a separate tf_device.parallel_execute region.", []() -> std::unique_ptr<::mlir::Pass> {
    return TFTPU::CreateTPUExtractOutsideCompilationPass();
  });
}

//===----------------------------------------------------------------------===//
// TPUReorderReplicateAndPartitionedInputsPass Registration
//===----------------------------------------------------------------------===//

inline void registerTPUReorderReplicateAndPartitionedInputsPassPass() {
  ::mlir::registerPass("tf-tpu-reorder-replicate-partitioned-inputs", "Reorder replicated and partitioned input ops.", []() -> std::unique_ptr<::mlir::Pass> {
    return TFTPU::CreateTPUReorderReplicateAndPartitionedInputsPass();
  });
}

//===----------------------------------------------------------------------===//
// TPUResourceReadForWritePass Registration
//===----------------------------------------------------------------------===//

inline void registerTPUResourceReadForWritePassPass() {
  ::mlir::registerPass("tf-tpu-resource-read-for-write", "Inserts tf.ReadVariableOp inputs to a TPU cluster for resource writes with no reads", []() -> std::unique_ptr<::mlir::Pass> {
    return TFTPU::CreateTPUResourceReadForWritePass();
  });
}

//===----------------------------------------------------------------------===//
// TPUResourceReadsWritesPartitioningPass Registration
//===----------------------------------------------------------------------===//

inline void registerTPUResourceReadsWritesPartitioningPassPass() {
  ::mlir::registerPass("tf-tpu-resource-partition", "Partitions unpartitioned resource read/write to partitioned resource variables.", []() -> std::unique_ptr<::mlir::Pass> {
    return TFTPU::CreateTPUResourceReadsWritesPartitioningPass();
  });
}

//===----------------------------------------------------------------------===//
// TPURewritePass Registration
//===----------------------------------------------------------------------===//

inline void registerTPURewritePassPass() {
  ::mlir::registerPass("tf-tpu-rewrite", "Rewrites a `tf_device.cluster_func` on TPUs into TPU runtime operations.", []() -> std::unique_ptr<::mlir::Pass> {
    return TFTPU::CreateTPURewritePass();
  });
}

//===----------------------------------------------------------------------===//
// TensorFlowShapeInferencePass Registration
//===----------------------------------------------------------------------===//

inline void registerTensorFlowShapeInferencePassPass() {
  ::mlir::registerPass("tf-shape-inference", "Simple Shape Inference on TensorFlow Dialect", []() -> std::unique_ptr<::mlir::Pass> {
    return TF::CreateTFShapeInferencePass();
  });
}

//===----------------------------------------------------------------------===//
// VerifySuitableForExportPass Registration
//===----------------------------------------------------------------------===//

inline void registerVerifySuitableForExportPassPass() {
  ::mlir::registerPass("tf-verify-for-export", "Verify module is suitable for export back to TF Graph", []() -> std::unique_ptr<::mlir::Pass> {
    return TF::CreateVerifySuitableForExportPass();
  });
}

//===----------------------------------------------------------------------===//
// TensorFlow Registration
//===----------------------------------------------------------------------===//

inline void registerTensorFlowPasses() {
  registerClusterConstantSinkingPassPass();
  registerClusterOpsByPolicyPassPass();
  registerClusterOutliningPassPass();
  registerDeviceAttributeToLaunchPassPass();
  registerExecutorDialectToFunctionalPassPass();
  registerExecutorGraphPruningPassPass();
  registerFunctionalControlFlowToRegionsPassPass();
  registerMarkOpsForOutsideCompilationPassPass();
  registerPrepareTpuComputationForTfExportPassPass();
  registerRegionControlFlowToFunctionalPassPass();
  registerTPUClusterFormationPassPass();
  registerTPUExtractOutsideCompilationPassPass();
  registerTPUReorderReplicateAndPartitionedInputsPassPass();
  registerTPUResourceReadForWritePassPass();
  registerTPUResourceReadsWritesPartitioningPassPass();
  registerTPURewritePassPass();
  registerTensorFlowShapeInferencePassPass();
  registerVerifySuitableForExportPassPass();
}
#undef GEN_PASS_REGISTRATION
#endif // GEN_PASS_REGISTRATION
