/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.mw.barcode.generation;

import com.aspose.barcode.BorderDashStyle;
import com.aspose.barcode.generation.BorderParameters;
import com.aspose.barcode.generation.Unit;
import com.aspose.mw.barcode.MwBarcodeException;
import com.aspose.mw.barcode.MwJavaWrapper;
import com.aspose.mw.barcode.generation.MwUnit;
import com.aspose.mw.barcode.util.HexValidator;
import com.aspose.mw.barcode.util.MwAssist;
import java.awt.Color;

public class MwBorderParameters
extends MwJavaWrapper<BorderParameters> {
    private MwUnit a;

    public MwBorderParameters(BorderParameters nativeObject) throws MwBarcodeException {
        super(nativeObject);
    }

    @Override
    protected void init() throws MwBarcodeException {
        this.a = new MwUnit(((BorderParameters)this.getNativeObject()).getWidth());
    }

    public boolean getVisible() throws MwBarcodeException {
        try {
            return ((BorderParameters)this.getNativeObject()).getVisible();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    public void setVisible(boolean value) throws MwBarcodeException {
        try {
            ((BorderParameters)this.getNativeObject()).setVisible(value);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    public MwUnit getWidth() throws MwBarcodeException {
        try {
            return this.a;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    public void setWidth(MwUnit value) throws MwBarcodeException {
        try {
            this.a = value;
            ((BorderParameters)this.getNativeObject()).setWidth((Unit)value.getNativeObject());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    public String toString() {
        return ((BorderParameters)this.getNativeObject()).toString();
    }

    public int getDashStyle() throws MwBarcodeException {
        try {
            return ((BorderParameters)this.getNativeObject()).getDashStyle().getValue();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    public void setDashStyle(int value) throws MwBarcodeException {
        try {
            BorderDashStyle borderDashStyle = ((BorderParameters)this.getNativeObject()).getDashStyle();
            for (BorderDashStyle borderDashStyle2 : BorderDashStyle.values()) {
                if (borderDashStyle2.getValue() != value) continue;
                borderDashStyle = borderDashStyle2;
                break;
            }
            ((BorderParameters)this.getNativeObject()).setDashStyle(borderDashStyle);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    public String getColor() throws MwBarcodeException {
        try {
            Color color = ((BorderParameters)this.getNativeObject()).getColor();
            String string = MwAssist.colorToHex(color);
            return string;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    public void setColor(String value) throws MwBarcodeException {
        try {
            if (!HexValidator.validate(value)) {
                throw new MwBarcodeException("Hex value " + value + " is not valid for color");
            }
            Color color = MwAssist.hexToColor(value);
            if (color == null) {
                throw new MwBarcodeException("Cannot convert  value " + value + " to Java Color");
            }
            ((BorderParameters)this.nativeObject).setColor(color);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MwBarcodeException(exception.getMessage());
        }
    }
}

