"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const child_process_1 = require("child_process");
const fs = require("fs");
const util_1 = require("./util");
/**
 * Build with Parcel
 */
function build(options) {
    const pkgPath = util_1.findPkgPath();
    let originalPkg;
    try {
        if (options.nodeVersion && pkgPath) {
            // Update engines.node (Babel target)
            originalPkg = util_1.updatePkg(pkgPath, {
                engines: { node: `>= ${options.nodeVersion}` }
            });
        }
        const args = [
            'build', options.entry,
            '--out-dir', options.outDir,
            '--out-file', 'index.js',
            '--global', options.global,
            '--target', 'node',
            '--bundle-node-modules',
            '--log-level', '2',
            !options.minify && '--no-minify',
            !options.sourceMaps && '--no-source-maps',
            ...options.cacheDir
                ? ['--cache-dir', options.cacheDir]
                : [],
        ].filter(Boolean);
        const parcel = child_process_1.spawnSync('parcel', args);
        if (parcel.error) {
            throw parcel.error;
        }
        if (parcel.status !== 0) {
            throw new Error(parcel.stderr.toString().trim());
        }
    }
    catch (err) {
        throw new Error(`Failed to build file at ${options.entry}: ${err}`);
    }
    finally { // Always restore package.json to original
        if (pkgPath && originalPkg) {
            fs.writeFileSync(pkgPath, originalPkg);
        }
    }
}
exports.build = build;
//# sourceMappingURL=data:application/json;base64,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