'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.default = collapseWhitespace;

var _normalizeHtmlWhitespace = require('normalize-html-whitespace');

var _normalizeHtmlWhitespace2 = _interopRequireDefault(_normalizeHtmlWhitespace);

var _helpers = require('../helpers');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var noWhitespaceCollapseElements = new Set(['script', 'style', 'pre', 'textarea']);

/** Collapses redundant whitespaces */
function collapseWhitespace(tree, options, collapseType, tag) {
    if (collapseType !== 'all') {
        collapseType = 'conservative';
    }

    tree.forEach(function (node, index) {
        if (typeof node === 'string' && !(0, _helpers.isComment)(node)) {
            var isTopLevel = !tag || tag === 'html' || tag === 'head';
            node = collapseRedundantWhitespaces(node, collapseType, isTopLevel);
        }

        var isAllowCollapseWhitespace = !noWhitespaceCollapseElements.has(node.tag);
        if (node.content && node.content.length && isAllowCollapseWhitespace) {
            node.content = collapseWhitespace(node.content, options, collapseType, node.tag);
        }

        tree[index] = node;
    });

    return tree;
}

function collapseRedundantWhitespaces(text, collapseType) {
    var isTopLevel = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;

    text = text && text.length > 0 ? (0, _normalizeHtmlWhitespace2.default)(text) : '';
    if (collapseType === 'all' || isTopLevel) {
        text = text.trim();
    }

    return text;
}