'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
/**
 * Minify HTML in a safe way without breaking anything.
 */
exports.default = {
    collapseAttributeWhitespace: true,
    collapseBooleanAttributes: {
        amphtml: false
    },
    collapseWhitespace: 'conservative',
    custom: [],
    deduplicateAttributeValues: true,
    mergeScripts: true,
    mergeStyles: true,
    removeUnusedCss: false,
    minifyCss: {
        preset: 'default'
    },
    minifyJs: {},
    minifyJson: {},
    minifySvg: {
        plugins: [{ collapseGroups: false }, { convertShapeToPath: false }]
    },
    removeEmptyAttributes: true,
    removeRedundantAttributes: false,
    removeComments: 'safe'
};