/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.mp4;

import com.drew.imaging.mp4.Mp4Handler;
import com.drew.lang.DateUtil;
import com.drew.lang.Rational;
import com.drew.lang.SequentialByteArrayReader;
import com.drew.lang.SequentialReader;
import com.drew.lang.annotations.NotNull;
import com.drew.lang.annotations.Nullable;
import com.drew.metadata.Metadata;
import com.drew.metadata.mp4.Mp4Context;
import com.drew.metadata.mp4.Mp4Directory;
import com.drew.metadata.mp4.media.Mp4HintHandler;
import com.drew.metadata.mp4.media.Mp4MetaHandler;
import com.drew.metadata.mp4.media.Mp4SoundHandler;
import com.drew.metadata.mp4.media.Mp4TextHandler;
import com.drew.metadata.mp4.media.Mp4UuidBoxHandler;
import com.drew.metadata.mp4.media.Mp4VideoHandler;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Mp4BoxHandler
extends Mp4Handler<Mp4Directory> {
    private static final Pattern COORDINATE_PATTERN = Pattern.compile("([+-]\\d+\\.\\d+)([+-]\\d+\\.\\d+)");

    public Mp4BoxHandler(Metadata metadata) {
        super(metadata);
    }

    @Override
    @NotNull
    protected Mp4Directory getDirectory() {
        return new Mp4Directory();
    }

    @Override
    public boolean shouldAcceptBox(@NotNull String type) {
        return type.equals("ftyp") || type.equals("mvhd") || type.equals("hdlr") || type.equals("mdhd") || type.equals("tkhd") || type.equals("udta") || type.equals("uuid");
    }

    @Override
    public boolean shouldAcceptContainer(@NotNull String type) {
        return type.equals("trak") || type.equals("meta") || type.equals("moov") || type.equals("mdia");
    }

    @Override
    public Mp4Handler<?> processBox(@NotNull String type, @Nullable byte[] payload, long boxSize, Mp4Context context) throws IOException {
        if (payload != null) {
            SequentialByteArrayReader reader = new SequentialByteArrayReader(payload);
            if (type.equals("mvhd")) {
                this.processMovieHeader(reader);
            } else if (type.equals("ftyp")) {
                this.processFileType(reader, boxSize);
            } else {
                if (type.equals("hdlr")) {
                    ((SequentialReader)reader).skip(4L);
                    ((SequentialReader)reader).skip(4L);
                    String handlerType = reader.getString(4);
                    ((SequentialReader)reader).skip(12L);
                    String name = reader.getNullTerminatedString((int)boxSize - 32, Charset.defaultCharset());
                    String HANDLER_SOUND_MEDIA = "soun";
                    String HANDLER_VIDEO_MEDIA = "vide";
                    String HANDLER_HINT_MEDIA = "hint";
                    String HANDLER_TEXT_MEDIA = "text";
                    String HANDLER_META_MEDIA = "meta";
                    if (handlerType.equals("soun")) {
                        return new Mp4SoundHandler(this.metadata, context);
                    }
                    if (handlerType.equals("vide")) {
                        return new Mp4VideoHandler(this.metadata, context);
                    }
                    if (handlerType.equals("hint")) {
                        return new Mp4HintHandler(this.metadata, context);
                    }
                    if (handlerType.equals("text")) {
                        return new Mp4TextHandler(this.metadata, context);
                    }
                    if (handlerType.equals("meta")) {
                        return new Mp4MetaHandler(this.metadata, context);
                    }
                    return this;
                }
                if (type.equals("mdhd")) {
                    this.processMediaHeader(reader, context);
                } else if (type.equals("tkhd")) {
                    this.processTrackHeader(reader);
                } else if (type.equals("uuid")) {
                    Mp4UuidBoxHandler userBoxHandler = new Mp4UuidBoxHandler(this.metadata);
                    userBoxHandler.processBox(type, payload, boxSize, context);
                } else if (type.equals("udta")) {
                    this.processUserData(reader, payload.length);
                }
            }
        } else if (type.equals("cmov")) {
            this.directory.addError("Compressed MP4 movies not supported");
        }
        return this;
    }

    private void processUserData(@NotNull SequentialReader reader, int length) throws IOException {
        Matcher matcher;
        long size;
        int LOCATION_CODE = -1451722374;
        String coordinateString = null;
        while (reader.getPosition() < (long)length && (size = reader.getUInt32()) > 4L) {
            int kind = reader.getInt32();
            if (kind == -1451722374) {
                int xyzLength = reader.getUInt16();
                reader.skip(2L);
                coordinateString = reader.getString(xyzLength, "UTF-8");
                continue;
            }
            if (size >= 8L) {
                reader.skip(size - 8L);
                continue;
            }
            return;
        }
        if (coordinateString != null && (matcher = COORDINATE_PATTERN.matcher(coordinateString)).find()) {
            double latitude = Double.parseDouble(matcher.group(1));
            double longitude = Double.parseDouble(matcher.group(2));
            this.directory.setDouble(8193, latitude);
            this.directory.setDouble(8194, longitude);
        }
    }

    private void processFileType(@NotNull SequentialReader reader, long boxSize) throws IOException {
        String majorBrand = reader.getString(4);
        long minorVersion = reader.getUInt32();
        ArrayList<String> compatibleBrands = new ArrayList<String>();
        int i = 16;
        while ((long)i < boxSize) {
            compatibleBrands.add(reader.getString(4));
            i += 4;
        }
        this.directory.setString(1, majorBrand);
        this.directory.setLong(2, minorVersion);
        this.directory.setStringArray(3, compatibleBrands.toArray(new String[compatibleBrands.size()]));
    }

    private void processMovieHeader(@NotNull SequentialReader reader) throws IOException {
        long duration;
        long timescale;
        long modificationTime;
        long creationTime;
        short version = reader.getUInt8();
        reader.skip(3L);
        if (version == 1) {
            creationTime = reader.getInt64();
            modificationTime = reader.getInt64();
            timescale = reader.getUInt32();
            duration = reader.getInt64();
        } else {
            creationTime = reader.getUInt32();
            modificationTime = reader.getUInt32();
            timescale = reader.getUInt32();
            duration = reader.getUInt32();
        }
        int rate = reader.getInt32();
        short volume = reader.getInt16();
        reader.skip(2L);
        reader.skip(8L);
        int[] matrix = new int[]{reader.getInt32(), reader.getInt32(), reader.getInt32(), reader.getInt32(), reader.getInt32(), reader.getInt32(), reader.getInt32(), reader.getInt32(), reader.getInt32()};
        reader.skip(24L);
        long nextTrackID = reader.getUInt32();
        this.directory.setDate(256, DateUtil.get1Jan1904EpochDate(creationTime));
        this.directory.setDate(257, DateUtil.get1Jan1904EpochDate(modificationTime));
        this.directory.setLong(259, duration);
        this.directory.setLong(258, timescale);
        this.directory.setRational(260, new Rational(duration, timescale));
        this.directory.setIntArray(271, matrix);
        double preferredRateInteger = (rate & 0xFFFF0000) >> 16;
        double preferredRateFraction = (double)(rate & 0xFFFF) / Math.pow(2.0, 4.0);
        this.directory.setDouble(261, preferredRateInteger + preferredRateFraction);
        double preferredVolumeInteger = (volume & 0xFF00) >> 8;
        double preferredVolumeFraction = (double)(volume & 0xFF) / Math.pow(2.0, 2.0);
        this.directory.setDouble(262, preferredVolumeInteger + preferredVolumeFraction);
        this.directory.setLong(270, nextTrackID);
    }

    private void processMediaHeader(@NotNull SequentialReader reader, Mp4Context context) throws IOException {
        short version = reader.getUInt8();
        reader.skip(3L);
        if (version == 1) {
            context.creationTime = reader.getInt64();
            context.modificationTime = reader.getInt64();
            context.timeScale = reader.getInt32();
            context.duration = reader.getInt64();
        } else {
            context.creationTime = reader.getUInt32();
            context.modificationTime = reader.getUInt32();
            context.timeScale = reader.getUInt32();
            context.duration = reader.getUInt32();
        }
        short languageBits = reader.getInt16();
        context.language = new String(new char[]{(char)(((languageBits & 0x7C00) >> 10) + 96), (char)(((languageBits & 0x3E0) >> 5) + 96), (char)((languageBits & 0x1F) + 96)});
    }

    private void processTrackHeader(@NotNull SequentialReader reader) throws IOException {
        long duration;
        long trackID;
        long modificationTime;
        long creationTime;
        short version = reader.getUInt8();
        reader.skip(3L);
        if (version == 1) {
            creationTime = reader.getInt64();
            modificationTime = reader.getInt64();
            trackID = reader.getInt32();
            reader.skip(4L);
            duration = reader.getInt64();
        } else {
            creationTime = reader.getUInt32();
            modificationTime = reader.getUInt32();
            trackID = reader.getUInt32();
            reader.skip(4L);
            duration = reader.getUInt32();
        }
        reader.skip(8L);
        short layer = reader.getInt16();
        short alternateGroup = reader.getInt16();
        short volume = reader.getInt16();
        reader.skip(2L);
        int[] matrix = new int[9];
        for (int i = 0; i < 9; ++i) {
            matrix[i] = reader.getInt32();
        }
        long width = reader.getInt32();
        long height = reader.getInt32();
        if (width != 0L && height != 0L && this.directory.getDoubleObject(512) == null) {
            int x = matrix[1] + matrix[4];
            int y = matrix[0] + matrix[3];
            double theta = Math.atan2(y, x);
            double degree = Math.toDegrees(theta);
            this.directory.setDouble(512, degree -= 45.0);
        }
    }
}

