/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.dicom;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import loci.formats.dicom.DicomVR;

public enum DicomAttribute {
    FILE_META_INFO_GROUP_LENGTH(131072),
    FILE_META_INFO_VERSION(131073),
    MEDIA_SOP_CLASS_UID(131074),
    MEDIA_SOP_INSTANCE_UID(131075),
    TRANSFER_SYNTAX_UID(131088),
    IMPLEMENTATION_UID(131090),
    IMPLEMENTATION_VERSION(131091),
    SOURCE_APPLICATION(131094),
    SPECIFIC_CHARSET(524293),
    IMAGE_TYPE(524296),
    RECOGNITION_CODE(524304),
    CREATION_DATE(524306),
    CREATION_TIME(524307),
    INSTANCE_CREATOR(524308),
    SOP_CLASS_UID(524310),
    SOP_INSTANCE_UID(524312),
    RELATED_SOP_CLASS_UID(524314),
    ORIGINAL_SOP_CLASS_UID(524315),
    STUDY_DATE(524320),
    SERIES_DATE(524321),
    ACQUISITION_DATE(524322),
    CONTENT_DATE(524323),
    OVERLAY_DATE(524324),
    CURVE_DATE(524325),
    ACQUISITION_TIMESTAMP(524330),
    STUDY_TIME(524336),
    SERIES_TIME(524337),
    ACQUISITION_TIME(524338),
    CONTENT_TIME(524339),
    OVERLAY_TIME(524340),
    CURVE_TIME(524341),
    DATASET_SUBTYPE(524353),
    ACCESSION_NUMBER(524368),
    QUERY_LEVEL(524370),
    RETRIEVE_TITLE(524372),
    INSTANCE_AVAILABILITY(524374),
    FAILED_SOP_UID_LIST(524376),
    MODALITY(524384),
    MODALITIES_IN_STUDY(524385),
    CLASSES_IN_STUDY(524386),
    CONVERSION_TYPE(524388),
    PRESENTATION_INTENT_TYPE(524392),
    MANUFACTURER(524400),
    INSTITUTION_NAME(524416),
    INSTITUTION_ADDRESS(524417),
    INSTITUTION_CODE_SEQUENCE(524418),
    REFERRING_PHYSICIAN_NAME(524432),
    REFERRING_PHYSICIAN_ADDRESS(524434),
    REFERRING_PHYSICIAN_TELEPHONE(524436),
    REFERRING_PHYSICIAN_ID(524438),
    CODE_VALUE(524544),
    CODING_SCHEME_DESIGNATOR(524546),
    CODING_SCHEME_VERSION(524547),
    CODE_MEANING(524548),
    MAPPING_RESOURCE(524549),
    CONTEXT_GROUP_VERSION(524550),
    CONTEXT_GROUP_LOCAL_VERSION(524551),
    CONTEXT_GROUP_EXTENSION_FLAG(524555),
    CODING_SCHEME_UID(524556),
    CONTEXT_GROUP_EXTENSION_CREATOR(524557),
    CONTEXT_ID(524559),
    CODING_SCHEME_ID(524560),
    CODING_SCHEME_REGISTRY(524562),
    CODING_SCHEME_EXTERNAL_ID(524564),
    CODING_SCHEME_NAME(524565),
    RESPONSIBLE_ORGANIZATION(524566),
    TIMEZONE_OFFSET_UTC(524801),
    STATION_NAME(528400),
    STUDY_DESCRIPTION(528432),
    PROCEDURE_CODE_SEQUENCE(528434),
    SERIES_DESCRIPTION(528446),
    INSTITUTIONAL_DEPARTMENT_NAME(528448),
    PHYSICIANS(528456),
    PHYSICIANS_ID(528457),
    PHYSICIAN_NAME(528464),
    PHYSICIAN_ID(528466),
    PHYSICIAN_READING(528480),
    PHYSICIAN_READING_ID(528482),
    OPERATOR_NAME(528496),
    OPERATOR_ID(528498),
    ADMITTING_DIAGNOSES_DESCRIPTION(528512),
    ADMITTING_DIAGNOSES_CODE_SEQUENCE(528516),
    MANUFACTURER_MODEL_NAME(528528),
    REFERENCED_RESULTS_SEQUENCE(528640),
    REFERENCED_STUDY_SEQUENCE(528656),
    REFERENCED_PERFORMED_PROCEDURE_STEP(528657),
    REFERENCED_SERIES_SEQUENCE(528661),
    REFERENCED_PATIENT_SEQUENCE(528672),
    REFERENCED_VISIT_SEQUENCE(528677),
    REFERENCED_OVERLAY_SEQUENCE(528688),
    REFERENCED_WAVEFORM_SEQUENCE(528698),
    REFERENCED_IMAGE_SEQUENCE(528704),
    REFERENCED_CURVE_SEQUENCE(528709),
    REFERENCED_INSTANCE_SEQUENCE(528714),
    REFERENCED_SOP_CLASS_UID(528720),
    REFERENCED_SOP_INSTANCE_UID(528725),
    SOP_CLASSES_SUPPORTED(528730),
    REFERENCED_FRAME_NUMBER(528736),
    TRANSACTION_UID(528789),
    FAILURE_REASON(528791),
    FAILED_SOP_SEQUENCE(528792),
    REFERENCED_SOP_SEQUENCE(528793),
    STUDIES_WITH_REFERENCED_INSTANCES(528896),
    RELATED_SERIES_SEQUENCE(528976),
    DERIVATION_DESCRIPTION(532753),
    SOURCE_IMAGE_SEQUENCE(532754),
    STAGE_NAME(532768),
    STAGE_NUMBER(532770),
    NUMBER_OF_STAGES(532772),
    VIEW_NAME(532775),
    VIEW_NUMBER(532776),
    NUMBER_OF_EVENT_TIMERS(532777),
    NUMBER_OF_VIEWS_STAGE(532778),
    EVENT_ELAPSED_TIME(532784),
    EVENT_TIMER_NAME(532786),
    START_TRIM(532802),
    STOP_TRIM(532803),
    RECOMMENDED_DISPLAY_FRAMERATE(532804),
    ANATOMIC_REGION_SEQUENCE(533016),
    ANATOMIC_REGION_MODIFIER_SEQUENCE(533024),
    PRIMARY_ANATOMIC_STRUCTURE_SEQUENCE(533032),
    ANATOMIC_STRUCTURE_SEQUENCE(533033),
    PRIMARY_ANATOMIC_STRUCTURE_MODIFIER(533040),
    TRANSDUCER_POSITION_SEQUENCE(533056),
    TRANSDUCER_POSITION_MODIFIER_SEQUENCE(533058),
    TRANSDUCER_ORIENTATION_SEQUENCE(533060),
    TRANSDUCER_ORIENTATION_MODIFIER(533062),
    ALTERNATE_REPRESENTATION_SEQUENCE(536577),
    FRAME_TYPE(561159),
    REFERENCED_IMAGE_EVIDENCE_SEQUENCE(561298),
    REFERENCED_RAW_DATA_SEQUENCE(561441),
    CREATOR_VERSION_UID(561443),
    DERIVATION_IMAGE_SEQUENCE(561444),
    SOURCE_IMAGE_EVIDENCE_SEQUENCE(561492),
    PIXEL_PRESENTATION(561669),
    VOLUMETRIC_PROPERTIES(561670),
    VOLUME_BASED_CALCULATION_TECHNIQUE(561671),
    COMPLEX_IMAGE_COMPONENT(561672),
    ACQUISITION_CONTRAST(561673),
    DERIVATION_CODE_SEQUENCE(561685),
    REFERENCE_GRAYSCALE_PRESENTATION_STATE(561719),
    PATIENT_NAME(0x100010),
    PATIENT_ID(0x100020),
    ISSUER_OF_PATIENT_ID(0x100021),
    PATIENT_BIRTH_DATE(0x100030),
    PATIENT_BIRTH_TIME(1048626),
    PATIENT_SEX(0x100040),
    PATIENT_INSURANCE_PLAN_CODE(0x100050),
    PATIENT_PRIMARY_LANGUAGE_CODE(0x100101),
    PATIENT_PRIMARY_LANGUAGE_MODIFIER(0x100102),
    OTHER_PATIENT_IDS(0x101000),
    OTHER_PATIENT_NAMES(0x101001),
    PATIENT_BIRTH_NAME(0x101005),
    PATIENT_AGE(0x101010),
    PATIENT_SIZE(0x101020),
    PATIENT_WEIGHT(0x101030),
    PATIENT_ADDRESS(0x101040),
    PATIENT_MOTHER_BIRTH_NAME(0x101060),
    MILITARY_RANK(0x101080),
    BRANCH_OF_SERVICE(0x101081),
    MEDICAL_RECORD_LOCATOR(0x101090),
    MEDICAL_ALERTS(0x102000),
    CONTRAST_ALLERGIES(0x102110),
    COUNTRY_OF_RESIDENCE(1057104),
    REGION_OF_RESIDENCE(1057106),
    PATIENT_TELEPHONE_NUMBER(1057108),
    ETHNIC_GROUP(1057120),
    OCCUPATION(1057152),
    SMOKING_STATUS(1057184),
    ADDITIONAL_PATIENT_HISTORY(1057200),
    PREGNANCY_STATUS(1057216),
    LAST_MENSTRUAL_DATE(1057232),
    PATIENT_RELIGIOUS_PREFERENCE(1057264),
    PATIENT_COMMENTS(0x104000),
    CLINICAL_TRIAL_SPONSOR_NAME(0x120010),
    CLINICAL_TRIAL_PROTOCOL_ID(0x120020),
    CLINICAL_TRIAL_PROTOCOL_NAME(0x120021),
    CLINICAL_TRIAL_SITE_ID(1179696),
    CLINICAL_TRIAL_SITE_NAME(1179697),
    CLINICAL_TRIAL_SUBJECT_ID(1179712),
    CLINICAL_TRIAL_SUBJECT_READING_ID(1179714),
    CLINICAL_TRIAL_TIME_POINT_ID(1179728),
    CLINICAL_TRIAL_TIME_POINT_DESCRIPTION(1179729),
    CLINICAL_TRIAL_COORDINATING_CENTER(1179744),
    CONTRAST_BOLUS_AGENT(0x180010),
    CONTRAST_BOLUS_AGENT_SEQUENCE(1572882),
    CONTRAST_BOLUS_ADMIN_ROUTE_SEQUENCE(1572884),
    BODY_PART_EXAMINED(1572885),
    SCANNING_SEQUENCE(1572896),
    SEQUENCE_VARIANT(1572897),
    SCAN_OPTIONS(1572898),
    MR_ACQUISITION_TYPE(1572899),
    SEQUENCE_NAME(1572900),
    ANGIO_FLAG(1572901),
    INTERVENTION_DRUG_INFORMATION_SEQUENCE(1572902),
    INTERVENTION_DRUG_STOP_TIME(1572903),
    INTERVENTION_DRUG_DOSE(1572904),
    INTERVENTION_DRUG_SEQUENCE(1572905),
    ADDITIONAL_DRUG_SEQUENCE(1572906),
    RADIOPHARMACEUTICAL(1572913),
    INTERVENTION_DRUG_NAME(1572916),
    INTERVENTION_DRUG_START_TIME(1572917),
    INTERVENTION_SEQUENCE(1572918),
    INTERVENTION_STATUS(1572920),
    INTERVENTION_DESCRIPTION(1572922),
    CINE_RATE(1572928),
    SLICE_THICKNESS(1572944),
    KVP(1572960),
    COUNTS_ACCUMULATED(1572976),
    ACQUISITION_TERMINATION_CONDITION(1572977),
    EFFECTIVE_DURATION(1572978),
    ACQUISITION_START_CONDITION(1572979),
    ACQUISITION_START_CONDITION_DATA(1572980),
    ACQUISITION_TERMINATION_CONDITION_DATA(1572981),
    REPETITION_TIME(0x180080),
    ECHO_TIME(0x180081),
    INVERSION_TIME(1572994),
    NUMBER_OF_AVERAGES(1572995),
    IMAGING_FREQUENCY(1572996),
    IMAGED_NUCLEUS(1572997),
    ECHO_NUMBER(1572998),
    MAGNETIC_FIELD_STRENGTH(1572999),
    SLICE_SPACING(0x180088),
    NUMBER_OF_PHASE_ENCODING_STEPS(1573001),
    DATA_COLLECTION_DIAMETER(1573008),
    ECHO_TRAIN_LENGTH(1573009),
    PERCENT_SAMPLING(1573011),
    PERCENT_PHASE_FOV(1573012),
    PIXEL_BANDWIDTH(1573013),
    DEVICE_SERIAL_NUMBER(0x181000),
    PLATE_ID(1576964),
    SECONDARY_CAPTURE_DEVICE_ID(0x181010),
    HARDCOPY_CREATION_DEVICE_ID(0x181011),
    DATE_OF_SECONDARY_CAPTURE(1576978),
    TIME_OF_SECONDARY_CAPTURE(1576980),
    SECONDARY_CAPTURE_DEVICE_MANUFACTURER(1576982),
    HARDCOPY_DEVICE_MANUFACTURER(1576983),
    SECONDARY_CAPTURE_DEVICE_MODEL_NAME(0x181018),
    SECONDARY_CAPTURE_DEVICE_SOFTWARE_VERSION(1576985),
    HARDCOPY_DEVICE_SOFTWARE_VERSION(1576986),
    HARDCOPY_DEVICE_MODEL_NAME(1576987),
    SOFTWARE_VERSION(1576992),
    VIDEO_IMAGE_FORMAT_ACQUIRED(1576994),
    DIGITAL_IMAGE_FORMAT_ACQUIRED(1576995),
    PROTOCOL_NAME(1577008),
    CONTRAST_BOLUS_ROUTE(1577024),
    CONTRAST_BOLUS_VOLUME(1577025),
    CONTRAST_BOLUS_START_TIME(1577026),
    CONTRAST_BOLUS_STOP_TIME(1577027),
    CONTRAST_BOLUS_TOTAL_DOSE(1577028),
    SYRINGE_COUNTS(1577029),
    CONTRAST_FLOW_RATE(1577030),
    CONTRAST_FLOW_DURATION(1577031),
    CONTRAST_BOLUS_INGREDIENT(1577032),
    CONTRAST_INGREDIENT_CONCENTRATION(1577033),
    SPATIAL_RESOLUTION(1577040),
    TRIGGER_TIME(1577056),
    TRIGGER_SOURCE_OR_TYPE(1577057),
    NOMINAL_INTERVAL(1577058),
    FRAME_TIME(1577059),
    FRAMING_TYPE(1577060),
    FRAME_TIME_VECTOR(1577061),
    FRAME_DELAY(1577062),
    IMAGE_TRIGGER_DELAY(1577063),
    MULTIPLEX_GROUP_TIME_OFFSET(1577064),
    TRIGGER_TIME_OFFSET(1577065),
    SYNCHRONIZATION_TRIGGER(1577066),
    SYNCHRONIZATION_CHANNEL(1577068),
    TRIGGER_SAMPLE_POSITION(1577070),
    RADIOPHARMACEUTICAL_ROUTE(1577072),
    RADIOPHARMACEUTICAL_VOLUME(1577073),
    RADIOPHARMACEUTICAL_START_TIME(1577074),
    RADIOPHARMACEUTICAL_STOP_TIME(1577075),
    RADIONUCLIDE_TOTAL_DOSE(1577076),
    RADIONUCLIDE_HALF_LIFE(1577077),
    RADIONUCLIDE_POSITRON_FRACTION(1577078),
    RADIOPHARMACEUTICAL_SPECIFIC_ACTIVITY(1577079),
    BEAT_REJECTION_FLAG(0x181080),
    LOW_RR_VALUE(0x181081),
    HIGH_RR_VALUE(1577090),
    INTERVALS_ACQUIRED(1577091),
    INTERVALS_REJECTED(1577092),
    PVC_REJECTION(1577093),
    SKIP_BEATS(1577094),
    HEART_RATE(0x181088),
    CARDIAC_NUMBER_OF_IMAGES(1577104),
    TRIGGER_WINDOW(1577108),
    RECONSTRUCTION_DIAMETER(0x181100),
    DISTANCE_SOURCE_TO_DETECTOR(0x181110),
    DISTANCE_SOURCE_TO_PATIENT(0x181111),
    ESTIMATED_RADIOGRAPHIC_MAG_FACTOR(0x181114),
    GANTRY_DETECTOR_TILT(1577248),
    GANTRY_DETECTOR_SKEW(0x181121),
    TABLE_HEIGHT(1577264),
    TABLE_TRAVERSE(0x181131),
    TABLE_MOTION(1577268),
    TABLE_VERTICAL_INCREMENT(1577269),
    TABLE_LATERAL_INCREMENT(1577270),
    TABLE_LONGITUDINAL_INCREMENT(1577271),
    TABLE_ANGLE(0x181138),
    TABLE_TYPE(1577274),
    ROTATION_DIRECTION(1577280),
    ANGULAR_POSITION(0x181141),
    RADIAL_POSITION(1577282),
    SCAN_ARC(1577283),
    ANGULAR_STEP(0x181144),
    CENTER_OF_ROTATION_OFFSET(1577285),
    FOV_SHAPE(1577287),
    FOV_DIMENSIONS(1577289),
    EXPOSURE_TIME(1577296),
    XRAY_TUBE_CURRENT(0x181151),
    EXPOSURE(1577298),
    EXPOSURE_IN_UAS(1577299),
    AVERAGE_PULSE_WIDTH(1577300),
    RADIATION_SETTING(0x181155),
    RECTIFICATION_TYPE(1577302),
    RADIATION_MODE(1577306),
    IMAGE_AREA_DOSE_PRODUCT(1577310),
    FILTER_TYPE(1577312),
    TYPE_OF_FILTERS(0x181161),
    INTENSIFIER_SIZE(1577314),
    IMAGER_PIXEL_SPACING(1577316),
    GRID(0x181166),
    GENERATOR_POWER(1577328),
    COLLIMATOR_GRID_NAME(0x181180),
    COLLIMATOR_TYPE(0x181181),
    FOCAL_DISTANCE(0x181182),
    X_FOCUS_CENTER(0x181183),
    Y_FOCUS_CENTER(0x181184),
    FOCAL_SPOTS(1577360),
    ANODE_TARGET_MATERIAL(0x181191),
    BODY_PART_THICKNESS(1577376),
    COMPRESSION_FORCE(1577378),
    DATE_OF_LAST_CALIBRATION(1577472),
    TIME_OF_LAST_CALIBRATION(1577473),
    CONVOLUTION_KERNEL(1577488),
    ACTUAL_FRAME_DURATION(1577538),
    COUNT_RATE(1577539),
    PREFERRED_PLAYBACK_SEQUENCING(1577540),
    RECEIVE_COIL_NAME(1577552),
    TRANSMIT_COIL_NAME(1577553),
    PLATE_TYPE(1577568),
    PHOSPHOR_TYPE(1577569),
    SCAN_VELOCITY(1577728),
    WHOLE_BODY_TECHNIQUE(1577729),
    SCAN_LENGTH(1577730),
    ACQUISITION_MATRIX(1577744),
    INPLANE_PHASE_ENCODING_DIRECTION(1577746),
    FLIP_ANGLE(1577748),
    VARIABLE_FLIP_ANGLE_FLAG(1577749),
    SAR(1577750),
    DB_DT(0x181318),
    ACQUISITION_DEVICE_PROCESSING_DESCRIPTION(1577984),
    ACQUISITION_DEVICE_PROCESSING_CODE(1577985),
    CASSETTE_ORIENTATION(1577986),
    CASSETTE_SIZE(1577987),
    EXPOSURES_ON_PLATE(1577988),
    RELATIVE_XRAY_EXPOSURE(1577989),
    COLUMN_ANGULATION(1578064),
    TOMO_LAYER_HEIGHT(1578080),
    TOMO_ANGLE(1578096),
    TOMO_TIME(1578112),
    TOMO_TYPE(1578128),
    TOMO_CLASS(1578129),
    NUMBER_OF_TOMOSYNTHESIS_SOURCE_IMAGES(1578133),
    POSITIONER_MOTION(1578240),
    POSITIONER_TYPE(1578248),
    POSITIONER_PRIMARY_ANGLE(1578256),
    POSITIONER_SECONDARY_ANGLE(0x181511),
    POSITIONER_PRIMARY_ANGLE_INCREMENT(1578272),
    POSITIONER_SECONDARY_ANGLE_INCREMENT(1578273),
    DETECTOR_PRIMARY_ANGLE(1578288),
    DETECTOR_SECONDARY_ANGLE(1578289),
    SHUTTER_SHAPE(1578496),
    SHUTTER_LEFT_VERTICAL_EDGE(1578498),
    SHUTTER_RIGHT_VERTICAL_EDGE(1578500),
    SHUTTER_UPPER_HORIZONTAL_EDGE(1578502),
    SHUTTER_LOWER_HORIZONTAL_EDGE(1578504),
    CENTER_OF_CIRCULAR_SHUTTER(1578512),
    RADIUS_OF_CIRCULAR_SHUTTER(1578514),
    VERTICES_OF_POLYGONAL_SHUTTER(1578528),
    SHUTTER_PRESENTATION_VALUE(1578530),
    SHUTTER_OVERLAY_GROUP(1578531),
    COLLIMATOR_SHAPE(1578752),
    COLLIMATOR_LEFT_VERTICAL_EDGE(1578754),
    COLLIMATOR_RIGHT_VERTICAL_EDGE(1578756),
    COLLIMATOR_UPPER_HORIZONTAL_EDGE(1578758),
    COLLIMATOR_LOWER_HORIZONTAL_EDGE(1578760),
    CENTER_OF_CIRCULAR_COLLIMATOR(1578768),
    RADIUS_OF_CIRCULAR_COLLIMATOR(1578770),
    VERTICES_OF_POLYGONAL_COLLIMATOR(1578784),
    ACQUISITION_TIME_SYNCHRONIZED(0x181800),
    TIME_SOURCE(0x181801),
    TIME_DISTRIBUTION_PROTOCOL(1579010),
    NTP_SOURCE_ADDRESS(1579011),
    PAGE_NUMBER_VECTOR(1581057),
    FRAME_LABEL_VECTOR(1581058),
    FRAME_PRIMARY_ANGLE_VECTOR(1581059),
    FRAME_SECONDARY_ANGLE_VECTOR(1581060),
    SLICE_LOCATION_VECTOR(1581061),
    DISPLAY_WINDOW_LABEL_VECTOR(1581062),
    NOMINAL_SCANNED_PIXEL_SPACING(1581072),
    DIGITIZING_DEVICE_TRANSPORT_DIRECTION(1581088),
    ROTATION_OF_SCANNED_FILM(1581104),
    IVUS_ACQUISITION(1585408),
    IVUS_PULLBACK_RATE(1585409),
    IVUS_GATED_RATE(1585410),
    IVUS_PULLBACK_START_FRAME_NUMBER(1585411),
    IVUS_PULLBACK_STOP_FRAME_NUMBER(1585412),
    LESION_NUMBER(1585413),
    OUTPUT_POWER(1593344),
    TRANSDUCER_DATA(1593360),
    FOCUS_DEPTH(1593362),
    PROCESSING_FUNCTION(1593376),
    POSTPROCESSING_FUNCTION(1593377),
    MECHANICAL_INDEX(1593378),
    BONE_THERMAL_INDEX(1593380),
    CRANIAL_THERMAL_INDEX(1593382),
    SOFT_TISSUE_THERMAL_INDEX(1593383),
    SOFT_TISSUE_FOCUS_THERMAL_INDEX(1593384),
    SOFT_TISSUE_SURFACE_THERMAL_INDEX(1593385),
    DEPTH_OF_SCAN_FIELD(1593424),
    PATIENT_POSITION(1593600),
    VIEW_POSITION(1593601),
    PROJECTION_EPONYMOUS_NAME_CODE(1593604),
    SENSITIVITY(1597440),
    SEQUENCE_OF_ULTRASOUND_REGIONS(1597457),
    REGION_SPATIAL_FORMAT(1597458),
    REGION_DATA_TYPE(1597460),
    REGION_FLAGS(1597462),
    REGION_LOCATION_MIN_X0(1597464),
    REGION_LOCATION_MIN_Y0(1597466),
    REGION_LOCATION_MAX_X1(1597468),
    REGION_LOCATION_MAX_Y1(1597470),
    REFERENCE_PIXEL_X0(1597472),
    REFERENCE_PIXEL_Y0(1597474),
    PHYSICAL_UNITS_X_DIRECTION(1597476),
    PHYSICAL_UNITS_Y_DIRECTION(1597478),
    REFERENCE_PIXEL_PHYSICAL_VALUE_X(1597480),
    REFERENCE_PIXEL_PHYSICAL_VALUE_Y(1597482),
    PHYSICAL_DELTA_X(1597484),
    PHYSICAL_DELTA_Y(1597486),
    TRANSDUCER_FREQUENCY(1597488),
    TRANSDUCER_TYPE(1597489),
    PULSE_REPETITION_FREQUENCY(1597490),
    DOPPLER_CORRECTION_ANGLE(1597492),
    STEERING_ANGLE(1597494),
    DOPPLER_SAMPLE_VOLUME_X_POSITION(1597497),
    DOPPLER_SAMPLE_VOLUME_Y_POSITION(1597499),
    TM_LINE_POSITION_X0(1597501),
    TM_LINE_POSITION_Y0(1597503),
    TM_LINE_POSITION_X1(1597505),
    TM_LINE_POSITION_Y1(1597507),
    PIXEL_COMPONENT_ORGANIZATION(1597508),
    PIXEL_COMPONENT_MASK(1597510),
    PIXEL_COMPONENT_RANGE_START(1597512),
    PIXEL_COMPONENT_RANGE_STOP(1597514),
    PIXEL_COMPONENT_PHYSICAL_UNITS(1597516),
    PIXEL_COMPONENT_DATA_TYPE(1597518),
    NUMBER_OF_TABLE_BREAK_POINTS(1597520),
    TABLE_OF_X_BREAK_POINTS(1597522),
    TABLE_OF_Y_BREAK_POINTS(1597524),
    NUMBER_OF_TABLE_ENTRIES(1597526),
    TABLE_OF_PIXEL_VALUES(1597528),
    TABLE_OF_PARAMETER_VALUES(1597530),
    R_WAVE_TIME_VECTOR(1597536),
    DETECTOR_CONDITIONS_NOMINAL_FLAG(1601536),
    DETECTOR_TEMPERATURE(1601537),
    DETECTOR_TYPE(1601540),
    DETECTOR_CONFIGURATION(1601541),
    DETECTOR_DESCRIPTION(1601542),
    DETECTOR_MODE(1601544),
    DETECTOR_ID(1601546),
    DATE_OF_LAST_DETECTOR_CALIBRATION(1601548),
    TIME_OF_LAST_DETECTOR_CALIBRATION(1601550),
    DETECTOR_TIME_SINCE_LAST_EXPOSURE(1601554),
    DETECTOR_ACTIVE_TIME(1601556),
    DETECTOR_ACTIVATION_OFFSET(1601558),
    DETECTOR_BINNING(1601562),
    DETECTOR_ELEMENT_PHYSICAL_SIZE(1601568),
    DETECTOR_ELEMENT_SPACING(1601570),
    DETECTOR_ACTIVE_SHAPE(1601572),
    DETECTOR_ACTIVE_DIMENSIONS(1601574),
    DETECTOR_ACTIVE_ORIGIN(1601576),
    DETECTOR_MANUFACTURER_NAME(1601578),
    DETECTOR_MODEL_NAME(1601579),
    FOV_ORIGIN(1601584),
    FOV_ROTATION(1601586),
    FOV_HORIZONTAL_FLIP(1601588),
    GRID_ABSORBING_MATERIAL(1601600),
    GRID_SPACING_MATERIAL(1601601),
    GRID_THICKNESS(1601602),
    GRID_PITCH(1601604),
    GRID_ASPECT_RATIO(1601606),
    GRID_PERIOD(1601608),
    GRID_FOCAL_DISTANCE(1601612),
    FILTER_MATERIAL(1601616),
    FILTER_THICKNESS_MIN(1601618),
    FILTER_THICKNESS_MAX(1601620),
    EXPOSURE_CONTROL_MODE(1601632),
    STUDY_INSTANCE_UID(0x20000D),
    SERIES_INSTANCE_UID(0x20000E),
    STUDY_ID(0x200010),
    SERIES_NUMBER(0x200011),
    ACQUISITION_NUMBER(0x200012),
    INSTANCE_NUMBER(2097171),
    PATIENT_ORIENTATION(0x200020),
    IMAGE_POSITION(0x200030),
    IMAGE_POSITION_PATIENT(0x200032),
    IMAGE_ORIENTATION_PATIENT(2097207),
    LOCATION(0x200050),
    FRAME_OF_REFERENCE_UID(0x200052),
    IMAGE_GEOMETRY_TYPE(0x200070),
    ACQUISITIONS_IN_SERIES(0x201001),
    REFERENCE(0x201020),
    SLICE_LOCATION(2101313),
    SAMPLES_PER_PIXEL(0x280002),
    SAMPLES_PER_PIXEL_USED(2621443),
    PHOTOMETRIC_INTERPRETATION(2621444),
    PLANAR_CONFIGURATION(2621446),
    NUMBER_OF_FRAMES(0x280008),
    FRAME_INCREMENT_POINTER(2621449),
    FRAME_DIMENSION_POINTER(2621450),
    ROWS(2621456),
    COLUMNS(2621457),
    PLANES(2621458),
    ULTRASOUND_COLOR_DATA_PRESENT(2621460),
    PIXEL_SPACING(2621488),
    ZOOM_FACTOR(2621489),
    ZOOM_CENTER(2621490),
    PIXEL_ASPECT_RATIO(2621492),
    CORRECTED_IMAGE(2621521),
    BITS_ALLOCATED(2621696),
    BITS_STORED(2621697),
    HIGH_BIT(2621698),
    PIXEL_REPRESENTATION(2621699),
    SMALLEST_IMAGE_PIXEL_VALUE(2621702),
    LARGEST_IMAGE_PIXEL_VALUE(2621703),
    SMALLEST_PIXEL_VALUE_IN_SERIES(2621704),
    LARGEST_PIXEL_VALUE_IN_SERIES(2621705),
    SMALLEST_IMAGE_PIXEL_VALUE_IN_PLANE(2621712),
    LARGEST_IMAGE_PIXEL_VALUE_IN_PLANE(2621713),
    PIXEL_PADDING_VALUE(2621728),
    QUALITY_CONTROL_IMAGE(2622208),
    BURNED_IN_ANNOTATION(2622209),
    PIXEL_INTENSITY_RELATIONSHIP(2625600),
    PIXEL_SIGN(2625601),
    WINDOW_CENTER(2625616),
    WINDOW_WIDTH(2625617),
    RESCALE_INTERCEPT(2625618),
    RESCALE_SLOPE(2625619),
    RESCALE_TYPE(2625620),
    WINDOW_CENTER_AND_WIDTH_EXPLANATION(2625621),
    RECOMMENDED_VIEWING_MODE(2625680),
    RED_LUT_DESCRIPTOR(2625793),
    GREEN_LUT_DESCRIPTOR(2625794),
    BLUE_LUT_DESCRIPTOR(2625795),
    PALETTE_LUT_UID(2625945),
    RED_LUT_DATA(2626049),
    GREEN_LUT_DATA(2626050),
    BLUE_LUT_DATA(2626051),
    SEGMENTED_RED_LUT_DATA(0x281221),
    SEGMENTED_GREEN_LUT_DATA(0x281222),
    SEGMENTED_BLUE_LUT_DATA(2626083),
    IMPLANT_PRESENT(2626304),
    PARTIAL_VIEW(2626384),
    PARTIAL_VIEW_DESCRIPTION(2626385),
    LOSSY_IMAGE_COMPRESSION(2629904),
    LOSSY_IMAGE_COMPRESSION_RATIO(0x282112),
    LOSSY_IMAGE_COMPRESSION_METHOD(2629908),
    MODALITY_LUT_SEQUENCE(2633728),
    LUT_DESCRIPTOR(2633730),
    LUT_EXPLANATION(2633731),
    MODALITY_LUT_TYPE(2633732),
    LUT_DATA(2633734),
    VOI_LUT_SEQUENCE(2633744),
    SOFTCOPY_VOI_LUT_SEQUENCE(2634000),
    BIPLANE_ACQUISITION_SEQUENCE(2641920),
    REPRESENTATIVE_FRAME_NUMBER(2646032),
    FRAME_NUMBERS_OF_INTEREST(2646048),
    FRAME_OF_INTEREST_DESCRIPTION(2646050),
    FRAME_OF_INTEREST_TYPE(2646051),
    R_WAVE_POINTER(2646080),
    MASK_SUBTRACTION_SEQUENCE(2646272),
    MASK_OPERATION(2646273),
    APPLICABLE_FRAME_RANGE(2646274),
    MASK_FRAME_NUMBERS(2646288),
    CONTRAST_FRAME_AVERAGING(2646290),
    MASK_SUBPIXEL_SHIFT(2646292),
    TID_OFFSET(2646304),
    MASK_OPERATION_EXPLANATION(2646416),
    DATA_POINT_ROWS(2658305),
    DATA_POINT_COLUMNS(2658306),
    SIGNAL_DOMAIN_COLUMNS(2658307),
    DATA_REPRESENTATION(2658568),
    PIXEL_MEASURES_SEQUENCE(2658576),
    FRAME_VOI_LUT_SEQUENCE(2658610),
    PIXEL_VALUE_TRANSFORMATION_SEQUENCE(2658629),
    SIGNAL_DOMAIN_ROWS(2658869),
    NUMBER_OF_ENERGY_WINDOWS(5505041),
    NUMBER_OF_DETECTORS(5505057),
    NUMBER_OF_ROTATIONS(5505105),
    SLICE_VECTOR(5505152),
    NUMBER_OF_SLICES(5505153),
    TYPE_OF_DETECTOR_MOTION(5505538),
    IMAGE_ID(0x540400),
    ICON_IMAGE_SEQUENCE(0x880200),
    BORDER_DENSITY(0x20100100),
    PIXEL_DATA_LENGTH(2145386496),
    EXTENDED_OFFSET_TABLE(2145386497),
    EXTENDED_OFFSET_TABLE_LENGTHS(2145386498),
    FLOAT_PIXEL_DATA(2145386504),
    DOUBLE_FLOAT_PIXEL_DATA(2145386505),
    PIXEL_DATA(2145386512),
    ITEM(-73728),
    ITEM_DELIMITATION_ITEM(-73715),
    SEQUENCE_DELIMITATION_ITEM(-73507),
    TRAILING_PADDING(-196612),
    FILE_SET_ID(266544),
    FILE_SET_DESCRIPTOR_FILE_ID(266561),
    CHARSET_OF_FILE_SET_DESCRIPTOR_FILE(266562),
    OFFSET_FIRST_DIRECTORY_RECORD(266752),
    OFFSET_LAST_DIRECTORY_RECORD(266754),
    FILE_SET_CONSISTENCY_FLAG(266770),
    DIRECTORY_RECORD_SEQUENCE(266784),
    OFFSET_OF_NEXT_DIRECTORY_RECORD(267264),
    RECORD_IN_USE_FLAG(267280),
    OFFSET_OF_REFERENCED_DIRECTORY(267296),
    DIRECTORY_RECORD_TYPE(267312),
    PRIVATE_RECORD_UID(267314),
    REFERENCED_FILE_ID(267520),
    MRDR_RECORD_OFFSET(267524),
    REFERENCED_SOP_CLASS_UID_FILE(267536),
    REFERENCED_SOP_INSTANCE_UID_FILE(267537),
    REFERENCED_TRANSFER_SYNTAX_UID_FILE(267538),
    REFERENCED_RELATED_SOP_CLASS_UID_FILE(267546),
    NUMBER_OF_REFERENCES(267776),
    ACQUISITION_DURATION(1609843),
    DIMENSION_ORGANIZATION_TYPE(2134801),
    DIMENSION_INDEX_SEQUENCE(0x209222),
    DIMENSION_INDEX_POINTER(2134373),
    DIMENSION_INDEX_PRIVATE_CREATOR(2134547),
    FUNCTIONAL_GROUP_POINTER(2134375),
    FUNCTIONAL_GROUP_PRIVATE_CREATOR(2134584),
    IN_CONCATENATION_NUMBER(2134370),
    CONCATENATION_FRAME_OFFSET_NUMBER(2134568),
    DIMENSION_ORGANIZATION_UID(2134372),
    DIMENSION_ORGANIZATION_SEQUENCE(2134561),
    DIMENSION_DESCRIPTION_LABEL(2135073),
    ILLUMINATION_WAVELENGTH(0x220055),
    ILLUMINATION_TYPE_CODE_SEQUENCE(2228246),
    LIGHT_PATH_FILTER_TYPE_STACK_CODE_SEQUENCE(2228247),
    LIGHT_PATH_FILTER_PASSTHROUGH_WAVELENGTH(0x220001),
    LIGHT_PATH_FILTER_PASS_BAND(0x220002),
    IMAGE_PATH_FILTER_PASSTHROUGH_WAVELENGTH(0x220003),
    IMAGE_PATH_FILTER_PASS_BAND(0x220004),
    IMAGE_PATH_FILTER_TYPE_STACK_CODE_SEQUENCE(2228248),
    LENSES_CODE_SEQUENCE(2228249),
    CHANNEL_DESCRIPTION_CODE_SEQUENCE(2228250),
    ICC_PROFILE(0x282000),
    COLOR_SPACE(0x282002),
    CONTAINER_ID(4195602),
    CONTAINER_ID_ISSUER_SEQUENCE(4195603),
    CONTAINER_TYPE_CODE_SEQUENCE(4195608),
    SPECIMEN_ID(4195665),
    SPECIMEN_UID(0x400554),
    ACQUISITION_CONTEXT_SEQUENCE(0x400555),
    SPECIMEN_DESCRIPTION_SEQUENCE(4195680),
    SPECIMEN_ID_ISSUER_SEQUENCE(4195682),
    SPECIMEN_PREP_SEQUENCE(4195856),
    WHOLE_SLIDE_FRAME_TYPE_SEQUENCE(4196112),
    X_OFFSET_IN_SLIDE(4196138),
    Y_OFFSET_IN_SLIDE(4196154),
    Z_OFFSET_IN_SLIDE(4196170),
    IMAGED_VOLUME_WIDTH(4718593),
    IMAGED_VOLUME_HEIGHT(4718594),
    IMAGED_VOLUME_DEPTH(4718595),
    TOTAL_PIXEL_MATRIX_COLUMNS(4718598),
    TOTAL_PIXEL_MATRIX_ROWS(4718599),
    TOTAL_PIXEL_MATRIX_ORIGIN_SEQUENCE(0x480008),
    SPECIMEN_LABEL_IN_IMAGE(4718608),
    FOCUS_METHOD(4718609),
    EXTENDED_DEPTH_OF_FIELD(4718610),
    NUMBER_OF_FOCAL_PLANES(4718611),
    DISTANCE_BETWEEN_FOCAL_PLANES(4718612),
    RECOMMENDED_ABSENT_PIXEL_CIELAB_VALUE(4718613),
    SLIDE_IMAGE_ORIENTATION(4718850),
    OPTICAL_PATH_SEQUENCE(4718853),
    OPTICAL_PATH_ID(4718854),
    OPTICAL_PATH_DESCRIPTION(4718855),
    ILLUMINATOR_TYPE_CODE_SEQUENCE(4718848),
    ILLUMINATION_COLOR_CODE_SEQUENCE(4718856),
    CONDENSER_LENS_POWER(4718865),
    OBJECTIVE_LENS_POWER(4718866),
    OBJECTIVE_LENS_NA(4718867),
    PALETTE_COLOR_LUT_SEQUENCE(4718880),
    REFERENCED_IMAGE_NAVIGATION_SEQUENCE(4719104),
    OPTICAL_PATH_ID_SEQUENCE(4719111),
    NUMBER_OPTICAL_PATHS(4719362),
    TOTAL_PIXEL_MATRIX_FOCAL_PLANES(4719363),
    PRESENTATION_LUT_SHAPE(0x20500020),
    PLANE_POSITION_SLIDE_SEQUENCE(4719130),
    COLUMN_POSITION_IN_MATRIX(4719134),
    ROW_POSITION_IN_MATRIX(4719135),
    FRAME_CONTENT_SEQUENCE(2134289),
    FRAME_ACQUISITION_DATETIME(1609844),
    FRAME_REFERENCE_DATETIME(1610065),
    FRAME_ACQUISITION_DURATION(1610272),
    DIMENSION_INDEX_VALUES(2134359),
    SHARED_FUNCTIONAL_GROUPS_SEQUENCE(1375769129),
    PER_FRAME_FUNCTIONAL_GROUPS_SEQUENCE(1375769136),
    BARCODE_VALUE(0x22000005),
    LABEL_TEXT(0x22000002),
    VARIABLE_PIXEL_DATA(2139619344),
    INVALID_PIXEL_DATA(0xFFEE000),
    INVALID(0);

    private int tag;
    private String description;
    private DicomVR defaultVR;
    private static final Map<Integer, DicomAttribute> lookup;
    private static final Map<Integer, String[]> dict;

    private DicomAttribute(int tag) {
        this.tag = tag;
    }

    private void update() {
        if (this.description == null && dict.containsKey(this.tag)) {
            String[] tokens = dict.get(this.tag);
            this.description = tokens[1];
            if (tokens.length > 2) {
                this.defaultVR = DicomVR.valueOf(tokens[2]);
            }
        }
    }

    public DicomVR getDefaultVR() {
        this.update();
        return this.defaultVR;
    }

    public static DicomVR getDefaultVR(int newTag) {
        if (dict.containsKey(newTag) && dict.get(newTag).length > 2) {
            return DicomVR.valueOf(dict.get(newTag)[2]);
        }
        return DicomVR.IMPLICIT;
    }

    public int getTag() {
        return this.tag;
    }

    public String getDescription() {
        this.update();
        return this.description;
    }

    public static String getDescription(int newTag) {
        if (dict.containsKey(newTag)) {
            return dict.get(newTag)[1];
        }
        return null;
    }

    public static DicomAttribute get(int newTag) {
        DicomAttribute v = lookup.get(newTag);
        if (v != null) {
            v.update();
        }
        return v;
    }

    public static String formatTag(int tag) {
        String s2 = Integer.toHexString(tag);
        while (s2.length() < 8) {
            s2 = "0" + s2;
        }
        return s2.substring(0, 4) + "," + s2.substring(4);
    }

    static {
        lookup = new HashMap<Integer, DicomAttribute>();
        dict = new HashMap<Integer, String[]>();
        try (InputStream stream = DicomAttribute.class.getResourceAsStream("dicom-dictionary.txt");){
            String line;
            BufferedReader in = new BufferedReader(new InputStreamReader(stream, "UTF-8"));
            while ((line = in.readLine()) != null) {
                String[] tokens = line.split(",");
                tokens[1] = tokens[1].replaceAll("\"", "").trim();
                if (tokens.length > 2) {
                    tokens[2] = tokens[2].trim();
                }
                dict.put((int)Long.parseLong(tokens[0], 16), tokens);
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
        for (DicomAttribute v : EnumSet.allOf(DicomAttribute.class)) {
            lookup.put(v.getTag(), v);
        }
    }
}

