/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.gui;

import java.lang.reflect.InvocationTargetException;
import java.util.Vector;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import loci.formats.FileStitcher;
import loci.formats.IFormatHandler;
import loci.formats.IFormatReader;
import loci.formats.IFormatWriter;
import loci.formats.ImageReader;
import loci.formats.ImageWriter;
import loci.formats.ReaderWrapper;
import loci.formats.WriterWrapper;
import loci.formats.gui.ComboFileFilter;
import loci.formats.gui.ExtensionFileFilter;
import loci.formats.gui.FormatFileFilter;
import loci.formats.gui.NoExtensionFileFilter;
import loci.formats.gui.PreviewPane;

public final class GUITools {
    private static final String ALL_TYPES = "All supported file types";

    private GUITools() {
    }

    public static FileFilter[] buildFileFilters(IFormatHandler handler) {
        FileFilter[] filters = null;
        while (true) {
            if (handler instanceof ReaderWrapper) {
                handler = ((ReaderWrapper)handler).getReader();
                continue;
            }
            if (handler instanceof FileStitcher) {
                handler = ((FileStitcher)handler).getReader();
                continue;
            }
            if (!(handler instanceof WriterWrapper)) break;
            handler = ((WriterWrapper)handler).getWriter();
        }
        if (handler instanceof ImageReader) {
            ImageReader imageReader = (ImageReader)handler;
            IFormatReader[] readers = imageReader.getReaders();
            Vector<FileFilter> filterList = new Vector<FileFilter>();
            Vector<FileFilter> comboList = new Vector<FileFilter>();
            for (int i = 0; i < readers.length; ++i) {
                filterList.add(new FormatFileFilter(readers[i]));
                String[] suffixes = readers[i].getSuffixes();
                String format = readers[i].getFormat();
                comboList.add(new ExtensionFileFilter(suffixes, format));
            }
            comboList.add(new NoExtensionFileFilter());
            FileFilter combo = GUITools.makeComboFilter(GUITools.sortFilters(comboList));
            if (combo != null) {
                filterList.add(combo);
            }
            filters = GUITools.sortFilters(filterList);
        } else if (handler instanceof ImageWriter) {
            IFormatWriter[] writers = ((ImageWriter)handler).getWriters();
            Vector<ExtensionFileFilter> filterList = new Vector<ExtensionFileFilter>();
            for (int i = 0; i < writers.length; ++i) {
                String[] suffixes = writers[i].getSuffixes();
                String format = writers[i].getFormat();
                filterList.add(new ExtensionFileFilter(suffixes, format));
            }
            filters = GUITools.sortFilters(filterList);
        } else if (handler instanceof IFormatReader) {
            IFormatReader reader = (IFormatReader)handler;
            filters = new FileFilter[]{new FormatFileFilter(reader)};
        } else {
            String[] suffixes = handler.getSuffixes();
            String format = handler.getFormat();
            filters = new FileFilter[]{new ExtensionFileFilter(suffixes, format)};
        }
        return filters;
    }

    public static JFileChooser buildFileChooser(IFormatHandler handler) {
        return GUITools.buildFileChooser(handler, true);
    }

    public static JFileChooser buildFileChooser(IFormatHandler handler, boolean preview) {
        return GUITools.buildFileChooser(GUITools.buildFileFilters(handler), preview);
    }

    public static JFileChooser buildFileChooser(FileFilter[] filters) {
        return GUITools.buildFileChooser(filters, true);
    }

    public static JFileChooser buildFileChooser(final FileFilter[] filters, final boolean preview) {
        final JFileChooser[] jfc = new JFileChooser[1];
        Runnable r = new Runnable(){

            @Override
            public void run() {
                ComboFileFilter cff;
                JFileChooser fc = new JFileChooser(System.getProperty("user.dir"));
                FileFilter[] ff = GUITools.sortFilters(filters);
                FileFilter combo = null;
                if (ff.length > 0 && ff[0] instanceof ComboFileFilter && GUITools.ALL_TYPES.equals((cff = (ComboFileFilter)ff[0]).getDescription())) {
                    combo = cff;
                }
                if (combo == null && (combo = GUITools.makeComboFilter(ff)) != null) {
                    fc.addChoosableFileFilter(combo);
                }
                for (int i = 0; i < ff.length; ++i) {
                    fc.addChoosableFileFilter(ff[i]);
                }
                if (combo != null) {
                    fc.setFileFilter(combo);
                }
                if (preview) {
                    new PreviewPane(fc);
                }
                jfc[0] = fc;
            }
        };
        if (Thread.currentThread().getName().startsWith("AWT-EventQueue")) {
            r.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(r);
            }
            catch (InterruptedException exc) {
                return null;
            }
            catch (InvocationTargetException exc) {
                return null;
            }
        }
        return jfc[0];
    }

    private static FileFilter makeComboFilter(FileFilter[] filters) {
        return filters.length > 1 ? new ComboFileFilter(filters, ALL_TYPES) : null;
    }

    private static FileFilter[] sortFilters(FileFilter[] filters) {
        filters = ComboFileFilter.sortFilters(filters);
        GUITools.shuffleAllTypesToFront(filters);
        return filters;
    }

    private static FileFilter[] sortFilters(Vector filterList) {
        FileFilter[] filters = ComboFileFilter.sortFilters(filterList);
        GUITools.shuffleAllTypesToFront(filters);
        return filters;
    }

    private static void shuffleAllTypesToFront(FileFilter[] filters) {
        for (int i = 0; i < filters.length; ++i) {
            if (!(filters[i] instanceof ComboFileFilter) || !ALL_TYPES.equals(filters[i].getDescription())) continue;
            FileFilter f = filters[i];
            for (int j = i; j >= 1; --j) {
                filters[j] = filters[j - 1];
            }
            filters[0] = f;
            break;
        }
    }
}

