/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.InflaterInputStream;
import loci.common.DataTools;
import loci.common.RandomAccessInputStream;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.in.MetadataLevel;
import loci.formats.meta.MetadataStore;
import loci.formats.tools.AmiraParameters;
import ome.units.quantity.Length;

public class AmiraReader
extends FormatReader {
    long offsetOfFirstStream;
    transient PlaneReader planeReader;
    private boolean hasPlaneReader = false;
    private String compression;
    private boolean ascii = false;
    byte[][] lut;

    public AmiraReader() {
        super("Amira", new String[]{"am", "amiramesh", "grey", "hx", "labels"});
        this.domains = new String[]{"Unknown"};
    }

    @Override
    public int getOptimalTileHeight() {
        FormatTools.assertId(this.currentId, true, 1);
        return this.getSizeY();
    }

    @Override
    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h2) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h2);
        int planeSize = FormatTools.getPlaneSize(this);
        if (this.hasPlaneReader) {
            if (this.planeReader == null) {
                this.initPlaneReader();
            }
            int bytesPerPixel = FormatTools.getBytesPerPixel(this.getPixelType());
            byte[] planeBuf = new byte[planeSize];
            this.planeReader.read(no, planeBuf);
            int srcWidth = this.getSizeX() * bytesPerPixel;
            int destWidth = w * bytesPerPixel;
            for (int j = y; j < y + h2; ++j) {
                int src = j * srcWidth + x * bytesPerPixel;
                int dest = (j - y) * destWidth;
                System.arraycopy(planeBuf, src, buf, dest, destWidth);
            }
        } else {
            this.in.seek(this.offsetOfFirstStream + (long)no * (long)planeSize);
            this.readPlane(this.in, x, y, w, h2, buf);
        }
        return buf;
    }

    @Override
    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        this.offsetOfFirstStream = 0L;
        this.planeReader = null;
        this.hasPlaneReader = false;
        this.compression = null;
        this.ascii = false;
        this.lut = null;
    }

    @Override
    protected void initFile(String id) throws FormatException, IOException {
        Map materials;
        super.initFile(id);
        this.in = new RandomAccessInputStream(id);
        AmiraParameters parameters = new AmiraParameters(this.in);
        this.offsetOfFirstStream = this.in.getFilePointer();
        LOGGER.info("Populating metadata hashtable");
        this.addGlobalMeta("Image width", parameters.width);
        this.addGlobalMeta("Image height", parameters.height);
        this.addGlobalMeta("Number of planes", parameters.depth);
        this.addGlobalMeta("Bits per pixel", 8);
        LOGGER.info("Populating core metadata");
        int channelIndex = 1;
        while (parameters.getStreams().get("@" + channelIndex) != null) {
            ++channelIndex;
        }
        CoreMetadata m3 = (CoreMetadata)this.core.get(0);
        m3.sizeX = parameters.width;
        m3.sizeY = parameters.height;
        m3.sizeZ = parameters.depth;
        m3.sizeT = 1;
        m3.sizeC = channelIndex - 1;
        m3.imageCount = this.getSizeZ() * this.getSizeC();
        m3.littleEndian = parameters.littleEndian;
        m3.dimensionOrder = "XYZCT";
        String streamType = parameters.streamTypes[0].toLowerCase();
        if (streamType.equals("byte")) {
            m3.pixelType = 1;
        } else if (streamType.equals("short")) {
            m3.pixelType = 2;
            this.addGlobalMeta("Bits per pixel", 16);
        } else if (streamType.equals("ushort")) {
            m3.pixelType = 3;
            this.addGlobalMeta("Bits per pixel", 16);
        } else if (streamType.equals("int")) {
            m3.pixelType = 4;
            this.addGlobalMeta("Bits per pixel", 32);
        } else if (streamType.equals("float")) {
            m3.pixelType = 6;
            this.addGlobalMeta("Bits per pixel", 32);
        } else {
            LOGGER.warn("Assuming data type is byte");
            m3.pixelType = 1;
        }
        LOGGER.info("Populating metadata store");
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels(store, this);
        if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
            double pixelWidth = (parameters.x1 - parameters.x0) / (double)(parameters.width - 1);
            double pixelHeight = (parameters.y1 - parameters.y0) / (double)(parameters.height - 1);
            double pixelDepth = (parameters.z1 - parameters.z0) / (double)(parameters.depth - 1);
            this.addGlobalMeta("Pixels per meter (X)", 1000000.0 / pixelWidth);
            this.addGlobalMeta("Pixels per meter (Y)", 1000000.0 / pixelHeight);
            this.addGlobalMeta("Pixels per meter (Z)", 1000000.0 / pixelDepth);
            Length sizeX = FormatTools.getPhysicalSizeX(pixelWidth);
            Length sizeY = FormatTools.getPhysicalSizeY(pixelHeight);
            Length sizeZ = FormatTools.getPhysicalSizeZ(pixelDepth);
            if (sizeX != null) {
                store.setPixelsPhysicalSizeX(sizeX, 0);
            }
            if (sizeY != null) {
                store.setPixelsPhysicalSizeY(sizeY, 0);
            }
            if (sizeZ != null) {
                store.setPixelsPhysicalSizeZ(sizeZ, 0);
            }
        }
        this.ascii = parameters.ascii;
        ArrayList streamData = (ArrayList)parameters.getStreams().get("@1");
        if (streamData.size() > 2) {
            this.compression = (String)streamData.get(2);
        }
        this.initPlaneReader();
        this.hasPlaneReader = this.planeReader != null;
        this.addGlobalMeta("Compression", this.compression);
        Map params = (Map)parameters.getMap().get("Parameters");
        if (params != null && (materials = (Map)params.get("Materials")) != null) {
            this.lut = this.getLookupTable(materials);
            m3.indexed = true;
        }
    }

    private void initPlaneReader() {
        if (this.ascii) {
            this.planeReader = new ASCII(this.getPixelType(), this.getSizeX() * this.getSizeY());
        }
        if (this.compression != null) {
            if (this.compression.startsWith("HxZip,")) {
                long size = Long.parseLong(this.compression.substring("HxZip,".length()));
                this.planeReader = new HxZip(size);
            } else if (this.compression.startsWith("HxByteRLE,")) {
                long size = Long.parseLong(this.compression.substring("HxByteRLE,".length()));
                this.planeReader = new HxRLE(this.getSizeZ(), size);
            }
        }
    }

    @Override
    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        if (!FormatTools.validStream(stream, 50, false)) {
            return false;
        }
        String c = stream.readLine();
        Matcher amiraMeshDef = Pattern.compile("#\\s+(AmiraMesh|Avizo).*?(BINARY|ASCII)(-LITTLE-ENDIAN)*").matcher(c);
        return amiraMeshDef.find();
    }

    @Override
    public byte[][] get8BitLookupTable() {
        FormatTools.assertId(this.currentId, true, 1);
        return this.lut;
    }

    byte[][] getLookupTable(Map materials) throws FormatException {
        byte[][] result = new byte[3][256];
        int i = -1;
        for (Object label : materials.keySet()) {
            ++i;
            Object object = materials.get(label);
            if (!(object instanceof Map)) {
                throw new FormatException("Invalid material: " + label);
            }
            Map material = (Map)object;
            if ((object = material.get("Color")) == null) continue;
            if (!(object instanceof Number[])) {
                throw new FormatException("Invalid material: " + label);
            }
            Number[] color = (Number[])object;
            if (color.length != 3) {
                throw new FormatException("Invalid color: " + color.length + " channels");
            }
            for (int j = 0; j < 3; ++j) {
                result[j][i] = (byte)(255.0f * color[j].floatValue());
            }
        }
        return result;
    }

    class HxRLE
    implements PlaneReader {
        long compressedSize;
        long[] offsets;
        int[] internalOffsets;
        int currentNo;
        int maxOffsetIndex;
        int planeSize;
        long lastCodeOffset = 0L;

        HxRLE(int sliceCount, long compressedSize) {
            this.compressedSize = compressedSize;
            this.offsets = new long[sliceCount + 1];
            this.internalOffsets = new int[sliceCount + 1];
            this.offsets[0] = AmiraReader.this.offsetOfFirstStream;
            this.internalOffsets[0] = 0;
            this.planeSize = FormatTools.getPlaneSize(AmiraReader.this);
            this.currentNo = 0;
            this.maxOffsetIndex = 0;
        }

        void read(byte[] buf, int len) throws FormatException, IOException {
            int off = 0;
            while (len > 0 && AmiraReader.this.in.getFilePointer() < AmiraReader.this.in.length()) {
                this.lastCodeOffset = AmiraReader.this.in.getFilePointer();
                int insn = AmiraReader.this.in.readByte();
                if (insn < 0) {
                    if ((insn &= 0x7F) > len) {
                        throw new FormatException("Slice " + this.currentNo + " is unaligned!");
                    }
                    while (insn > 0) {
                        int count = AmiraReader.this.in.read(buf, off, insn);
                        if (count < 0) {
                            throw new IOException("End of file!");
                        }
                        insn -= count;
                        len -= count;
                        off += count;
                    }
                    continue;
                }
                if (insn > len) {
                    this.internalOffsets[this.currentNo] = len;
                    insn = len;
                } else if (insn == len) {
                    this.lastCodeOffset += 2L;
                }
                if (off == 0 && this.currentNo > 0 && this.internalOffsets[this.currentNo - 1] > 0) {
                    insn -= this.internalOffsets[this.currentNo - 1];
                }
                Arrays.fill(buf, off, off + insn, AmiraReader.this.in.readByte());
                len -= insn;
                off += insn;
            }
        }

        @Override
        public byte[] read(int no, byte[] buf) throws FormatException, IOException {
            if (this.maxOffsetIndex < no) {
                AmiraReader.this.in.seek(this.offsets[this.maxOffsetIndex]);
                while (this.maxOffsetIndex <= no) {
                    Arrays.fill(buf, AmiraReader.this.getFillColor());
                    this.read(this.currentNo, buf);
                    ++this.currentNo;
                }
            } else {
                AmiraReader.this.in.seek(this.offsets[no]);
                this.currentNo = no;
                Arrays.fill(buf, AmiraReader.this.getFillColor());
                this.read(buf, this.planeSize);
                if (this.maxOffsetIndex == no) {
                    this.offsets[++this.maxOffsetIndex] = this.lastCodeOffset;
                }
            }
            return buf;
        }
    }

    class HxZip
    implements PlaneReader {
        long offsetOfStream;
        long compressedSize;
        int currentNo;
        int planeSize;
        transient InflaterInputStream decompressor;

        HxZip(long compressedSize) {
            this.compressedSize = compressedSize;
            this.planeSize = FormatTools.getPlaneSize(AmiraReader.this);
            this.offsetOfStream = AmiraReader.this.offsetOfFirstStream;
            this.currentNo = Integer.MAX_VALUE;
        }

        void initDecompressor() throws IOException {
            this.currentNo = 0;
            AmiraReader.this.in.seek(this.offsetOfStream);
            this.decompressor = new InflaterInputStream(AmiraReader.this.in);
        }

        @Override
        public byte[] read(int no, byte[] buf) throws FormatException, IOException {
            if (no < this.currentNo) {
                this.initDecompressor();
            }
            while (this.currentNo <= no) {
                int count;
                int offset = 0;
                for (int len = this.planeSize; len > 0; len -= count) {
                    count = this.decompressor.read(buf, offset, len);
                    if (count <= 0) {
                        return null;
                    }
                    offset += count;
                }
                ++this.currentNo;
            }
            return buf;
        }
    }

    class ASCII
    implements PlaneReader {
        int pixelType;
        int bytesPerPixel;
        int pixelsPerPlane;
        long[] offsets;
        byte[] numberBuffer = new byte[32];

        ASCII(int pixelType, int pixelsPerPlane) {
            this.pixelType = pixelType;
            this.pixelsPerPlane = pixelsPerPlane;
            this.bytesPerPixel = FormatTools.getBytesPerPixel(pixelType);
            this.offsets = new long[AmiraReader.this.getSizeZ() + 1];
            this.offsets[0] = AmiraReader.this.offsetOfFirstStream;
        }

        @Override
        public byte[] read(int no, byte[] buf) throws FormatException, IOException {
            if (this.offsets[no] == 0L) {
                int i = no - 1;
                while (this.offsets[i] == 0L) {
                    --i;
                }
                AmiraReader.this.in.seek(this.offsets[i]);
                while (i < no) {
                    for (int j = 0; j < this.pixelsPerPlane; ++j) {
                        this.readNumberString();
                    }
                    this.offsets[++i] = AmiraReader.this.in.getFilePointer();
                }
            } else {
                AmiraReader.this.in.seek(this.offsets[no]);
            }
            for (int j = 0; j < this.pixelsPerPlane; ++j) {
                int offset = j * this.bytesPerPixel;
                double number = this.readNumberString();
                long value = this.pixelType == 7 ? Double.doubleToLongBits(number) : (this.pixelType == 6 ? (long)Float.floatToIntBits((float)number) : (long)number);
                DataTools.unpackBytes(value, buf, offset, this.bytesPerPixel, false);
            }
            this.offsets[no + 1] = AmiraReader.this.in.getFilePointer();
            return buf;
        }

        double readNumberString() throws IOException {
            this.numberBuffer[0] = this.skipWhiteSpace();
            int i = 1;
            byte c;
            while ((c = AmiraReader.this.in.readByte()) >= 48 && c <= 57 || c == 46) {
                this.numberBuffer[i] = c;
                ++i;
            }
            return Double.parseDouble(new String(this.numberBuffer, 0, i, "UTF-8"));
        }

        byte skipWhiteSpace() throws IOException {
            byte c;
            while ((c = AmiraReader.this.in.readByte()) == 32 || c == 9 || c == 10) {
            }
            return c;
        }
    }

    static interface PlaneReader {
        public byte[] read(int var1, byte[] var2) throws FormatException, IOException;
    }
}

