/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import loci.common.DataTools;
import loci.common.Location;
import loci.common.RandomAccessInputStream;
import loci.common.xml.XMLTools;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.in.BaseTiffReader;
import loci.formats.meta.MetadataStore;
import loci.formats.tiff.IFD;
import loci.formats.tiff.PhotoInterp;
import loci.formats.tiff.TiffParser;
import loci.formats.tiff.TiffRational;
import ome.units.UNITS;
import ome.units.quantity.Time;
import ome.xml.model.primitives.Color;
import ome.xml.model.primitives.NonNegativeInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class VectraReader
extends BaseTiffReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(VectraReader.class);
    private static final String SOFTWARE_CHECK = "PerkinElmer-QPI";
    private static final String ANNOTATION_SUFFIX = "_annotations.xml";
    private static final List<String> EXTRA_FILES = Arrays.asList("CoverslipMask.tif", "FocusMap.tif", "Label.tif", "OverviewBF.tif", "OverviewFL.tif", "SampleMask.tif");
    private int pyramidDepth = 1;
    private String profileXML;
    private List<String> allFiles = new ArrayList<String>();

    public VectraReader() {
        super("PerkinElmer Vectra/QPTIFF", new String[]{"tiff", "tif", "qptiff"});
        this.domains = new String[]{"Histology", "Light Microscopy"};
        this.noSubresolutions = true;
        this.suffixSufficient = false;
        this.canSeparateSeries = false;
        this.hasCompanionFiles = true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isThisType(String name, boolean open) {
        if (!open) {
            return VectraReader.checkSuffix(name, "qptiff");
        }
        try (RandomAccessInputStream stream = new RandomAccessInputStream(name);){
            TiffParser tiffParser = new TiffParser(stream);
            tiffParser.setDoCaching(false);
            if (!tiffParser.isValidHeader()) {
                boolean bl = false;
                return bl;
            }
            IFD ifd = tiffParser.getFirstIFD();
            if (ifd == null) {
                boolean bl = false;
                return bl;
            }
            tiffParser.fillInIFD(ifd);
            String software = ifd.getIFDTextValue(305);
            boolean bl = software != null && software.startsWith(SOFTWARE_CHECK);
            return bl;
        }
        catch (IOException e) {
            LOGGER.debug("I/O exception during isThisType() evaluation.", e);
            return false;
        }
    }

    @Override
    public String[] getSeriesUsedFiles(boolean noPixels) {
        if (this.allFiles.size() == 1) {
            return super.getSeriesUsedFiles(noPixels);
        }
        if (noPixels) {
            return this.allFiles.subList(1, this.allFiles.size()).toArray(new String[this.allFiles.size() - 1]);
        }
        return this.allFiles.toArray(new String[this.allFiles.size()]);
    }

    @Override
    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h2) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h2);
        if (this.tiffParser == null) {
            this.initTiffParser();
        }
        int ifd = this.getIFDIndex(this.getCoreIndex(), no);
        this.tiffParser.getSamples((IFD)this.ifds.get(ifd), buf, x, y, w, h2);
        return buf;
    }

    @Override
    public byte[] openThumbBytes(int no) throws FormatException, IOException {
        if (this.getCoreIndex() < this.pyramidDepth - 1) {
            int currentIndex = this.getCoreIndex();
            this.setCoreIndex(this.pyramidDepth - 1);
            byte[] thumb = this.openThumbBytes(no);
            this.setCoreIndex(currentIndex);
            return thumb;
        }
        return super.openThumbBytes(no);
    }

    @Override
    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.pyramidDepth = 1;
            this.profileXML = null;
            if (this.allFiles != null) {
                this.allFiles.clear();
            }
        }
    }

    @Override
    public int getOptimalTileWidth() {
        FormatTools.assertId(this.currentId, true, 1);
        try {
            int ifd = this.getIFDIndex(this.getCoreIndex(), 0);
            return (int)((IFD)this.ifds.get(ifd)).getTileWidth();
        }
        catch (FormatException e) {
            LOGGER.debug("", e);
            return super.getOptimalTileWidth();
        }
    }

    @Override
    public int getOptimalTileHeight() {
        FormatTools.assertId(this.currentId, true, 1);
        try {
            int ifd = this.getIFDIndex(this.getCoreIndex(), 0);
            return (int)((IFD)this.ifds.get(ifd)).getTileLength();
        }
        catch (FormatException e) {
            LOGGER.debug("", e);
            return super.getOptimalTileHeight();
        }
    }

    @Override
    protected void initStandardMetadata() throws FormatException, IOException {
        int s2;
        IFD ifd;
        super.initStandardMetadata();
        Location currentFile = new Location(this.currentId).getAbsoluteFile();
        this.allFiles.add(currentFile.getAbsolutePath());
        Location parent = currentFile.getParentFile();
        Object[] list = parent.list(true);
        Arrays.sort(list);
        for (Object f : list) {
            if (!((String)f).endsWith(ANNOTATION_SUFFIX) && !EXTRA_FILES.contains(f)) continue;
            this.allFiles.add(new Location(parent, (String)f).getAbsolutePath());
        }
        this.ifds = this.tiffParser.getMainIFDs();
        this.thumbnailIFDs = null;
        for (IFD ifd2 : this.ifds) {
            this.tiffParser.fillInIFD(ifd2);
        }
        CoreMetadata m3 = (CoreMetadata)this.core.get(0, 0);
        m3.sizeC = 1;
        if (((IFD)this.ifds.get(0)).getSamplesPerPixel() == 1) {
            long width = ((IFD)this.ifds.get(0)).getImageWidth();
            long height = ((IFD)this.ifds.get(0)).getImageLength();
            int ifd3 = 1;
            while (((IFD)this.ifds.get(ifd3)).getImageWidth() == width && ((IFD)this.ifds.get(ifd3)).getImageLength() == height) {
                ++m3.sizeC;
                ++ifd3;
            }
        }
        for (int start = m3.sizeC + 1; start < this.ifds.size() && (ifd = (IFD)this.ifds.get(start)).getIFDIntValue(254) == 1; start += m3.sizeC) {
            ++this.pyramidDepth;
        }
        int coreSize = this.ifds.size() - this.pyramidDepth * (m3.sizeC - 1);
        this.core.clear();
        for (s2 = 0; s2 < coreSize; ++s2) {
            CoreMetadata ms = new CoreMetadata(m3);
            if (s2 == 0) {
                ms.resolutionCount = this.pyramidDepth;
            }
            if (s2 > 0 && s2 < this.pyramidDepth) {
                this.core.add(0, ms);
                continue;
            }
            this.core.add(ms);
        }
        for (s2 = 0; s2 < this.core.size(); ++s2) {
            for (int r = 0; r < this.core.size(s2); ++r) {
                CoreMetadata ms = (CoreMetadata)this.core.get(s2, r);
                int index = this.getIFDIndex(this.core.flattenedIndex(s2, r), 0);
                IFD ifd4 = (IFD)this.ifds.get(index);
                PhotoInterp p = ifd4.getPhotometricInterpretation();
                int samples = ifd4.getSamplesPerPixel();
                ms.rgb = samples > 1 || p == PhotoInterp.RGB;
                ms.sizeX = (int)ifd4.getImageWidth();
                ms.sizeY = (int)ifd4.getImageLength();
                ms.sizeZ = 1;
                ms.sizeT = 1;
                if (ms.rgb) {
                    ms.sizeC = samples;
                }
                ms.littleEndian = ifd4.isLittleEndian();
                ms.indexed = p == PhotoInterp.RGB_PALETTE && (this.get8BitLookupTable() != null || this.get16BitLookupTable() != null);
                ms.imageCount = ms.sizeC / samples;
                ms.pixelType = ifd4.getPixelType();
                ms.metadataComplete = true;
                ms.interleaved = false;
                ms.falseColor = false;
                ms.dimensionOrder = "XYCZT";
                ms.thumbnail = s2 != 0 || r > 0;
            }
        }
    }

    @Override
    protected void initMetadataStore() throws FormatException {
        super.initMetadataStore();
        MetadataStore store = this.makeFilterMetadata();
        String instrument = MetadataTools.createLSID("Instrument", 0);
        store.setInstrumentID(instrument, 0);
        String detector = MetadataTools.createLSID("Detector", 0, 0);
        store.setDetectorID(detector, 0, 0);
        for (int i = 0; i < this.getSeriesCount(); ++i) {
            this.setSeries(i);
            int coreIndex = this.seriesToCoreIndex(i);
            store.setImageName(this.getImageName(coreIndex), i);
            store.setImageDescription("", i);
            int ifdIndex = this.getIFDIndex(coreIndex, 0);
            IFD ifd = (IFD)this.ifds.get(ifdIndex);
            double x = ifd.getXResolution();
            double y = ifd.getYResolution();
            store.setPixelsPhysicalSizeX(FormatTools.getPhysicalSizeX(x), i);
            store.setPixelsPhysicalSizeY(FormatTools.getPhysicalSizeY(y), i);
            TiffRational xPos = ifd.getIFDRationalValue(286);
            TiffRational yPos = ifd.getIFDRationalValue(287);
            int unitMultiplier = ifd.getResolutionMultiplier();
            store.setImageInstrumentRef(instrument, i);
            for (int c = 0; c < this.getEffectiveSizeC(); ++c) {
                double position;
                store.setPlaneTheZ(new NonNegativeInteger(0), i, c);
                store.setPlaneTheT(new NonNegativeInteger(0), i, c);
                store.setPlaneTheC(new NonNegativeInteger(c), i, c);
                if (xPos != null) {
                    position = xPos.doubleValue() * (double)unitMultiplier;
                    store.setPlanePositionX(FormatTools.getPhysicalSizeX(position), i, c);
                }
                if (yPos != null) {
                    position = yPos.doubleValue() * (double)unitMultiplier;
                    store.setPlanePositionY(FormatTools.getPhysicalSizeY(position), i, c);
                }
                store.setDetectorSettingsID(detector, i, c);
            }
        }
        this.setSeries(0);
        int omeImageCount = this.hasFlattenedResolutions() ? this.pyramidDepth : 1;
        for (int c = 0; c < this.getEffectiveSizeC(); ++c) {
            String storedChannelName = null;
            String biomarker = null;
            String xml = this.getIFDComment(c);
            try {
                Element root = XMLTools.parseDOM(xml).getDocumentElement();
                NodeList children = root.getChildNodes();
                for (int i = 0; i < children.getLength(); ++i) {
                    if (!(children.item(i) instanceof Element)) continue;
                    Element e = (Element)children.item(i);
                    String name = e.getNodeName();
                    String value = e.getTextContent();
                    if (name.equals("ScanProfile")) {
                        if (value.startsWith("{")) {
                            this.profileXML = value;
                        } else {
                            try {
                                Document profileRoot = XMLTools.createDocument();
                                Node tmp = profileRoot.importNode(e, true);
                                profileRoot.appendChild(tmp);
                                this.profileXML = XMLTools.getXML(profileRoot);
                            }
                            catch (Exception ex) {
                                LOGGER.debug("Could not preserve scan profile metadata", ex);
                            }
                        }
                        this.addGlobalMeta(name, this.profileXML);
                    } else if (name.equals("Responsivity")) {
                        NodeList filters = e.getChildNodes();
                        int channelDigits = String.valueOf(this.getEffectiveSizeC()).length();
                        String prefix = String.format("Responsivity Filter #%0" + channelDigits + "d ", c + 1);
                        for (int f = 0; f < filters.getLength(); ++f) {
                            if (!"Filter".equals(filters.item(f).getNodeName())) continue;
                            this.processParentNode(filters.item(f), prefix);
                        }
                    } else if (name.equals("ExcitationFilter")) {
                        this.handleFilter(e, c);
                    } else if (name.equals("EmissionFilter")) {
                        this.handleFilter(e, c);
                    } else if (name.equals("CameraSettings")) {
                        NodeList settings = e.getChildNodes();
                        for (int q = 0; q < settings.getLength(); ++q) {
                            if (!(settings.item(q) instanceof Element)) continue;
                            Element setting = (Element)settings.item(q);
                            String settingName = setting.getNodeName();
                            String settingValue = setting.getTextContent();
                            if (settingName.equals("ROI")) {
                                Double x = null;
                                Double y = null;
                                Double w = null;
                                Double h2 = null;
                                NodeList roi = setting.getChildNodes();
                                for (int r = 0; r < roi.getLength(); ++r) {
                                    Node dim = roi.item(r);
                                    String dimName = dim.getNodeName();
                                    Double dimValue = DataTools.parseDouble(dim.getTextContent());
                                    if (dimName.equals("X")) {
                                        x = dimValue;
                                        continue;
                                    }
                                    if (dimName.equals("Y")) {
                                        y = dimValue;
                                        continue;
                                    }
                                    if (dimName.equals("Width")) {
                                        w = dimValue;
                                        continue;
                                    }
                                    if (!dimName.equals("Height")) continue;
                                    h2 = dimValue;
                                }
                                settingValue = String.format("[%f, %f, %f, %f]", x, y, w, h2);
                            }
                            this.addGlobalMetaList(settingName, settingValue);
                            if (settingName.equals("Gain")) {
                                for (int series = 0; series < omeImageCount; ++series) {
                                    store.setDetectorSettingsGain(DataTools.parseDouble(settingValue), series, c);
                                }
                                continue;
                            }
                            if (!settingName.equals("Binning")) continue;
                            for (int series = 0; series < omeImageCount; ++series) {
                                store.setDetectorSettingsBinning(MetadataTools.getBinning(settingValue + "x" + settingValue), series, c);
                            }
                        }
                    } else {
                        this.addGlobalMetaList(name, value);
                    }
                    if (name.equals("Name")) {
                        storedChannelName = value;
                        continue;
                    }
                    if (name.equals("Biomarker")) {
                        biomarker = value;
                        continue;
                    }
                    if (name.equals("SampleDescription")) {
                        for (int series = 0; series < omeImageCount; ++series) {
                            store.setImageDescription(value, series);
                        }
                        continue;
                    }
                    if (name.equals("OperatorName")) {
                        String experimenter = MetadataTools.createLSID("Experimenter", 0);
                        store.setExperimenterID(experimenter, 0);
                        store.setExperimenterUserName(value, 0);
                        for (int series = 0; series < omeImageCount; ++series) {
                            store.setImageExperimenterRef(experimenter, 0);
                        }
                        continue;
                    }
                    if (name.equals("InstrumentType")) {
                        store.setMicroscopeModel(value, 0);
                        continue;
                    }
                    if (name.equals("CameraType")) {
                        store.setDetectorModel(value, 0, 0);
                        continue;
                    }
                    if (name.equals("Color")) {
                        String[] components = value.split(",");
                        Color color = new Color(Integer.parseInt(components[0]), Integer.parseInt(components[1]), Integer.parseInt(components[2]), 255);
                        for (int series = 0; series < omeImageCount; ++series) {
                            store.setChannelColor(color, series, c);
                        }
                        continue;
                    }
                    if (name.equals("Objective") && c == 0) {
                        String objective = MetadataTools.createLSID("Objective", 0, 0);
                        store.setObjectiveID(objective, 0, 0);
                        store.setObjectiveModel(value, 0, 0);
                        try {
                            String mag = value.toLowerCase().replace("x", "");
                            Double magFactor = DataTools.parseDouble(mag);
                            store.setObjectiveNominalMagnification(magFactor, 0, 0);
                        }
                        catch (NumberFormatException ex) {
                            LOGGER.info("Could not determine magnification: {}", (Object)value);
                        }
                        for (int series = 0; series < this.getSeriesCount(); ++series) {
                            store.setObjectiveSettingsID(objective, series);
                        }
                        continue;
                    }
                    if (!name.equals("ExposureTime")) continue;
                    Time exposure = new Time(DataTools.parseDouble(value), UNITS.MICROSECOND);
                    store.setPlaneExposureTime(exposure, 0, c);
                }
            }
            catch (IOException | ParserConfigurationException | SAXException e) {
                LOGGER.warn("Could not parse XML for channel {}", (Object)c);
                LOGGER.debug("", e);
            }
            boolean validBiomarker = biomarker != null && !biomarker.isEmpty();
            boolean validName = storedChannelName != null && !storedChannelName.isEmpty();
            for (int series = 0; series < omeImageCount; ++series) {
                if (validBiomarker) {
                    store.setChannelName(biomarker, series, c);
                    if (!validName) continue;
                    store.setChannelFluor(storedChannelName, series, c);
                    continue;
                }
                store.setChannelName(storedChannelName, series, c);
            }
        }
    }

    private void handleFilter(Element filter, int channel) {
        int channelDigits = String.valueOf(this.getEffectiveSizeC()).length();
        String prefix = String.format("%s #%0" + channelDigits + "d ", filter.getNodeName(), channel + 1);
        NodeList properties = filter.getChildNodes();
        for (int p = 0; p < properties.getLength(); ++p) {
            Node n = properties.item(p);
            String propName = n.getNodeName();
            if (propName.equals("Bands")) {
                NodeList bands = n.getChildNodes();
                int bandIndex = 1;
                for (int b = 0; b < bands.getLength(); ++b) {
                    Node band = bands.item(b);
                    if (!(band instanceof Element)) continue;
                    this.processParentNode(band, prefix + "Band #" + bandIndex + " ");
                    ++bandIndex;
                }
                continue;
            }
            if (!(n instanceof Element)) continue;
            this.addGlobalMeta(prefix + propName, n.getTextContent());
        }
    }

    private void processParentNode(Node parent, String prefix) {
        NodeList children = parent.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node n = children.item(i);
            if (!(n instanceof Element)) continue;
            this.addGlobalMeta(prefix + n.getNodeName(), n.getTextContent());
        }
    }

    public String getScanProfileXML() {
        FormatTools.assertId(this.currentId, true, 1);
        return this.profileXML;
    }

    private String getImageName(int coreIndex) {
        if (coreIndex < this.pyramidDepth) {
            return "resolution #" + (coreIndex + 1);
        }
        if (coreIndex == this.pyramidDepth) {
            return "thumbnail";
        }
        String name = this.getImageType(this.getIFDIndex(coreIndex, 0));
        if (name != null) {
            return name;
        }
        return this.core.flattenedSize() == this.ifds.size() - 1 ? "label" : "macro";
    }

    private String getIFDComment(int ifdIndex) {
        String xml = ((IFD)this.ifds.get(ifdIndex)).getComment().trim();
        xml = xml.replace("utf-16", "utf-8");
        return xml;
    }

    private String getImageType(int ifdIndex) {
        String xml = this.getIFDComment(ifdIndex);
        try {
            Element root = XMLTools.parseDOM(xml).getDocumentElement();
            NodeList types = root.getElementsByTagName("ImageType");
            if (types.getLength() > 0) {
                return types.item(0).getTextContent();
            }
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            LOGGER.debug("Could not determine image type for IFD #" + ifdIndex, e);
        }
        return null;
    }

    private int getIFDIndex(int coreIndex, int no) {
        if (coreIndex == 0) {
            return no;
        }
        if (coreIndex < this.pyramidDepth) {
            return this.getImageCount() * coreIndex + 1 + no;
        }
        if (coreIndex == this.pyramidDepth) {
            return ((CoreMetadata)this.core.get((int)0, (int)0)).imageCount;
        }
        return this.ifds.size() - (this.core.flattenedSize() - coreIndex);
    }
}

