/*
 * Decompiled with CFR 0.152.
 */
package ome.specification;

import java.io.InputStream;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;

public class SchemaResolver
implements LSResourceResolver {
    private DOMImplementationLS theDOMImplementationLS = null;
    private static final String GIT_MASTER_PATH = "http://git.openmicroscopy.org/src/master/components/specification";
    private static final String GIT_DEVELOP_PATH = "http://git.openmicroscopy.org/src/develop/components/specification";
    private static final String MAIN_PATH = "http://www.openmicroscopy.org/Schemas/";
    private static final String MAIN_SEARCH_PATH = "/released-schema/";
    private static final String LEGACY_AC_PATH = "http://www.openmicroscopy.org/XMLschemas/AnalysisChain/RC1/";
    private static final String LEGACY_AM_PATH = "http://www.openmicroscopy.org/XMLschemas/AnalysisModule/RC1/";
    private static final String LEGACY_BF_PATH = "http://www.openmicroscopy.org/XMLschemas/BinaryFile/RC1/";
    private static final String LEGACY_CA_PATH = "http://www.openmicroscopy.org/XMLschemas/CA/RC1/";
    private static final String LEGACY_CL_PATH = "http://www.openmicroscopy.org/XMLschemas/CLI/RC1/";
    private static final String LEGACY_DH_PATH = "http://www.openmicroscopy.org/XMLschemas/DataHistory/IR3/";
    private static final String LEGACY_ML_PATH = "http://www.openmicroscopy.org/XMLschemas/MLI/IR2/";
    private static final String LEGACY_OM_PATH = "http://www.openmicroscopy.org/XMLschemas/OME/FC/";
    private static final String LEGACY_ST_PATH = "http://www.openmicroscopy.org/XMLschemas/STD/RC2/";
    private static final String LEGACY_SEARCH_PATH = "/released-schema/2003-FC/";

    public SchemaResolver() throws InstantiationException {
        try {
            DOMImplementationRegistry theDOMImplementationRegistryA = DOMImplementationRegistry.newInstance();
            this.theDOMImplementationLS = (DOMImplementationLS)((Object)theDOMImplementationRegistryA.getDOMImplementation("XML 3.0 LS 3.0"));
        }
        catch (Exception theDOMImplementationRegistryA) {
            // empty catch block
        }
        if (this.theDOMImplementationLS == null) {
            try {
                DOMImplementationRegistry theDOMImplementationRegistryB = DOMImplementationRegistry.newInstance();
                this.theDOMImplementationLS = (DOMImplementationLS)((Object)theDOMImplementationRegistryB.getDOMImplementation("LS"));
            }
            catch (Exception theDOMImplementationRegistryB) {
                // empty catch block
            }
        }
        if (this.theDOMImplementationLS == null) {
            try {
                System.setProperty("org.w3c.dom.DOMImplementationSourceList", "org.apache.xerces.dom.DOMImplementationSourceImpl");
                DOMImplementationRegistry theDOMImplementationRegistryC = DOMImplementationRegistry.newInstance();
                this.theDOMImplementationLS = (DOMImplementationLS)((Object)theDOMImplementationRegistryC.getDOMImplementation("LS"));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.theDOMImplementationLS == null) {
            throw new InstantiationException("SchemaResolver could not create suitable DOMImplementationLS");
        }
    }

    @Override
    public LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
        LSInput theResult;
        if (systemId.equals("http://www.w3.org/2001/xml.xsd")) {
            theResult = this.makeSubstutionStream("/released-schema/external/xml.xsd", systemId);
        } else if (systemId.startsWith(GIT_MASTER_PATH)) {
            theResult = this.makeSubstutionStream(systemId.substring(GIT_MASTER_PATH.length()), systemId);
        } else if (systemId.startsWith(GIT_DEVELOP_PATH)) {
            theResult = this.makeSubstutionStream(systemId.substring(GIT_DEVELOP_PATH.length()), systemId);
        } else if (systemId.startsWith(MAIN_PATH)) {
            theResult = this.makeSubstutionStream(MAIN_SEARCH_PATH + systemId.substring(MAIN_PATH.length()), systemId);
        } else if (systemId.startsWith(LEGACY_AC_PATH)) {
            theResult = this.makeSubstutionStream(LEGACY_SEARCH_PATH + systemId.substring(LEGACY_AC_PATH.length()), systemId);
        } else if (systemId.startsWith(LEGACY_AM_PATH)) {
            theResult = this.makeSubstutionStream(LEGACY_SEARCH_PATH + systemId.substring(LEGACY_AM_PATH.length()), systemId);
        } else if (systemId.startsWith(LEGACY_BF_PATH)) {
            theResult = this.makeSubstutionStream(LEGACY_SEARCH_PATH + systemId.substring(LEGACY_BF_PATH.length()), systemId);
        } else if (systemId.startsWith(LEGACY_CA_PATH)) {
            theResult = this.makeSubstutionStream(LEGACY_SEARCH_PATH + systemId.substring(LEGACY_CA_PATH.length()), systemId);
        } else if (systemId.startsWith(LEGACY_CL_PATH)) {
            theResult = this.makeSubstutionStream(LEGACY_SEARCH_PATH + systemId.substring(LEGACY_CL_PATH.length()), systemId);
        } else if (systemId.startsWith(LEGACY_DH_PATH)) {
            theResult = this.makeSubstutionStream(LEGACY_SEARCH_PATH + systemId.substring(LEGACY_DH_PATH.length()), systemId);
        } else if (systemId.startsWith(LEGACY_ML_PATH)) {
            theResult = this.makeSubstutionStream(LEGACY_SEARCH_PATH + systemId.substring(LEGACY_ML_PATH.length()), systemId);
        } else if (systemId.startsWith(LEGACY_OM_PATH)) {
            theResult = this.makeSubstutionStream(LEGACY_SEARCH_PATH + systemId.substring(LEGACY_OM_PATH.length()), systemId);
        } else if (systemId.startsWith(LEGACY_ST_PATH)) {
            theResult = this.makeSubstutionStream(LEGACY_SEARCH_PATH + systemId.substring(LEGACY_ST_PATH.length()), systemId);
        } else {
            throw new RuntimeException("SchemaResolver does not know path to resolve: [" + systemId + "] from OME specification jar.");
        }
        return theResult;
    }

    private LSInput makeSubstutionStream(String theResourcePath, String systemId) {
        LSInput theResult = this.theDOMImplementationLS.createLSInput();
        InputStream theResourcesStream = this.getClass().getResourceAsStream(theResourcePath);
        theResult.setByteStream(theResourcesStream);
        theResult.setSystemId(systemId);
        return theResult;
    }
}

