/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.model;

import java.util.List;
import ome.xml.model.NumericAnnotation;
import ome.xml.model.OMEModel;
import ome.xml.model.OMEModelObject;
import ome.xml.model.Reference;
import ome.xml.model.StructuredAnnotations;
import ome.xml.model.enums.EnumerationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DoubleAnnotation
extends NumericAnnotation {
    public static final String NAMESPACE = "http://www.openmicroscopy.org/Schemas/OME/2016-06";
    private static final Logger LOGGER = LoggerFactory.getLogger(DoubleAnnotation.class);
    private Double value;
    private StructuredAnnotations structuredAnnotations;

    public DoubleAnnotation() {
    }

    public DoubleAnnotation(Element element, OMEModel model) throws EnumerationException {
        this.update(element, model);
    }

    public DoubleAnnotation(DoubleAnnotation orig) {
        super(orig);
        this.value = orig.value;
        this.structuredAnnotations = orig.structuredAnnotations;
    }

    @Override
    public void update(Element element, OMEModel model) throws EnumerationException {
        super.update(element, model);
        List<Element> Value_nodeList = DoubleAnnotation.getChildrenByTagName(element, "Value");
        if (Value_nodeList.size() > 1) {
            throw new RuntimeException(String.format("Value node list size %d != 1", Value_nodeList.size()));
        }
        if (Value_nodeList.size() != 0) {
            this.setValue(Double.valueOf(Value_nodeList.get(0).getTextContent()));
        }
    }

    @Override
    public boolean link(Reference reference, OMEModelObject o) {
        return super.link(reference, o);
    }

    public Double getValue() {
        return this.value;
    }

    public void setValue(Double value) {
        this.value = value;
    }

    public StructuredAnnotations getStructuredAnnotations() {
        return this.structuredAnnotations;
    }

    public void setStructuredAnnotations(StructuredAnnotations structuredAnnotations_BackReference) {
        this.structuredAnnotations = structuredAnnotations_BackReference;
    }

    @Override
    public Element asXMLElement(Document document) {
        return this.asXMLElement(document, null);
    }

    @Override
    public Element asXMLElement(Document document, Element DoubleAnnotation_element) {
        if (DoubleAnnotation_element == null) {
            DoubleAnnotation_element = document.createElementNS(NAMESPACE, "DoubleAnnotation");
        }
        super.asXMLElement(document, DoubleAnnotation_element);
        if (this.value != null) {
            Element value_element = document.createElementNS(NAMESPACE, "Value");
            value_element.setTextContent(this.value.toString());
            DoubleAnnotation_element.appendChild(value_element);
        }
        return DoubleAnnotation_element;
    }
}

