/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.model;

import java.util.ArrayList;
import java.util.List;
import ome.units.quantity.Length;
import ome.units.quantity.Time;
import ome.xml.model.AbstractOMEModelObject;
import ome.xml.model.BinData;
import ome.xml.model.Channel;
import ome.xml.model.MetadataOnly;
import ome.xml.model.OMEModel;
import ome.xml.model.OMEModelObject;
import ome.xml.model.Plane;
import ome.xml.model.Reference;
import ome.xml.model.TiffData;
import ome.xml.model.enums.DimensionOrder;
import ome.xml.model.enums.EnumerationException;
import ome.xml.model.enums.PixelType;
import ome.xml.model.enums.UnitsLength;
import ome.xml.model.enums.UnitsTime;
import ome.xml.model.enums.handlers.UnitsLengthEnumHandler;
import ome.xml.model.enums.handlers.UnitsTimeEnumHandler;
import ome.xml.model.primitives.PositiveFloat;
import ome.xml.model.primitives.PositiveInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Pixels
extends AbstractOMEModelObject {
    public static final String NAMESPACE = "http://www.openmicroscopy.org/Schemas/OME/2016-06";
    private static final Logger LOGGER = LoggerFactory.getLogger(Pixels.class);
    private String id;
    private DimensionOrder dimensionOrder;
    private PixelType type;
    private PositiveInteger significantBits;
    private Boolean interleaved;
    private Boolean bigEndian;
    private PositiveInteger sizeX;
    private PositiveInteger sizeY;
    private PositiveInteger sizeZ;
    private PositiveInteger sizeC;
    private PositiveInteger sizeT;
    private Length physicalSizeX;
    private Length physicalSizeY;
    private Length physicalSizeZ;
    private Time timeIncrement;
    private List<Channel> channels = new ArrayList<Channel>();
    private List<BinData> binDataBlocks = new ArrayList<BinData>();
    private List<TiffData> tiffDataBlocks = new ArrayList<TiffData>();
    private MetadataOnly metadataOnly;
    private List<Plane> planes = new ArrayList<Plane>();

    public Pixels() {
    }

    public Pixels(Element element, OMEModel model) throws EnumerationException {
        this.update(element, model);
    }

    public Pixels(Pixels orig) {
        this.id = orig.id;
        this.dimensionOrder = orig.dimensionOrder;
        this.type = orig.type;
        this.significantBits = orig.significantBits;
        this.interleaved = orig.interleaved;
        this.bigEndian = orig.bigEndian;
        this.sizeX = orig.sizeX;
        this.sizeY = orig.sizeY;
        this.sizeZ = orig.sizeZ;
        this.sizeC = orig.sizeC;
        this.sizeT = orig.sizeT;
        this.physicalSizeX = orig.physicalSizeX;
        this.physicalSizeY = orig.physicalSizeY;
        this.physicalSizeZ = orig.physicalSizeZ;
        this.timeIncrement = orig.timeIncrement;
        this.channels = orig.channels;
        this.binDataBlocks = orig.binDataBlocks;
        this.tiffDataBlocks = orig.tiffDataBlocks;
        this.metadataOnly = orig.metadataOnly;
        this.planes = orig.planes;
    }

    @Override
    public void update(Element element, OMEModel model) throws EnumerationException {
        Object modelUnit;
        String unitSymbol;
        super.update(element, model);
        if (!element.hasAttribute("ID") && this.getID() == null) {
            throw new RuntimeException("Pixels missing required ID property.");
        }
        if (element.hasAttribute("ID")) {
            this.setID(String.valueOf(element.getAttribute("ID")));
            model.addModelObject(this.getID(), this);
        }
        if (element.hasAttribute("DimensionOrder")) {
            this.setDimensionOrder(DimensionOrder.fromString(element.getAttribute("DimensionOrder")));
        }
        if (element.hasAttribute("Type")) {
            this.setType(PixelType.fromString(element.getAttribute("Type")));
        }
        if (element.hasAttribute("SignificantBits")) {
            this.setSignificantBits(PositiveInteger.valueOf(element.getAttribute("SignificantBits")));
        }
        if (element.hasAttribute("Interleaved")) {
            this.setInterleaved(Boolean.valueOf(element.getAttribute("Interleaved")));
        }
        if (element.hasAttribute("BigEndian")) {
            this.setBigEndian(Boolean.valueOf(element.getAttribute("BigEndian")));
        }
        if (element.hasAttribute("SizeX")) {
            this.setSizeX(PositiveInteger.valueOf(element.getAttribute("SizeX")));
        }
        if (element.hasAttribute("SizeY")) {
            this.setSizeY(PositiveInteger.valueOf(element.getAttribute("SizeY")));
        }
        if (element.hasAttribute("SizeZ")) {
            this.setSizeZ(PositiveInteger.valueOf(element.getAttribute("SizeZ")));
        }
        if (element.hasAttribute("SizeC")) {
            this.setSizeC(PositiveInteger.valueOf(element.getAttribute("SizeC")));
        }
        if (element.hasAttribute("SizeT")) {
            this.setSizeT(PositiveInteger.valueOf(element.getAttribute("SizeT")));
        }
        if (element.hasAttribute("PhysicalSizeX")) {
            unitSymbol = element.getAttribute("PhysicalSizeXUnit");
            if (unitSymbol == null || unitSymbol.isEmpty()) {
                unitSymbol = Pixels.getPhysicalSizeXUnitXsdDefault();
            }
            modelUnit = UnitsLength.fromString(unitSymbol);
            PositiveFloat positiveFloat = PositiveFloat.valueOf(element.getAttribute("PhysicalSizeX"));
            this.setPhysicalSizeX(UnitsLengthEnumHandler.getQuantity(positiveFloat, (UnitsLength)modelUnit));
        }
        if (element.hasAttribute("PhysicalSizeY")) {
            unitSymbol = element.getAttribute("PhysicalSizeYUnit");
            if (unitSymbol == null || unitSymbol.isEmpty()) {
                unitSymbol = Pixels.getPhysicalSizeYUnitXsdDefault();
            }
            modelUnit = UnitsLength.fromString(unitSymbol);
            PositiveFloat positiveFloat = PositiveFloat.valueOf(element.getAttribute("PhysicalSizeY"));
            this.setPhysicalSizeY(UnitsLengthEnumHandler.getQuantity(positiveFloat, (UnitsLength)modelUnit));
        }
        if (element.hasAttribute("PhysicalSizeZ")) {
            unitSymbol = element.getAttribute("PhysicalSizeZUnit");
            if (unitSymbol == null || unitSymbol.isEmpty()) {
                unitSymbol = Pixels.getPhysicalSizeZUnitXsdDefault();
            }
            modelUnit = UnitsLength.fromString(unitSymbol);
            PositiveFloat positiveFloat = PositiveFloat.valueOf(element.getAttribute("PhysicalSizeZ"));
            this.setPhysicalSizeZ(UnitsLengthEnumHandler.getQuantity(positiveFloat, (UnitsLength)modelUnit));
        }
        if (element.hasAttribute("TimeIncrement")) {
            unitSymbol = element.getAttribute("TimeIncrementUnit");
            if (unitSymbol == null || unitSymbol.isEmpty()) {
                unitSymbol = Pixels.getTimeIncrementUnitXsdDefault();
            }
            modelUnit = UnitsTime.fromString(unitSymbol);
            Double d = Double.valueOf(element.getAttribute("TimeIncrement"));
            this.setTimeIncrement(UnitsTimeEnumHandler.getQuantity(d, (UnitsTime)modelUnit));
        }
        List<Element> Channel_nodeList = Pixels.getChildrenByTagName(element, "Channel");
        for (Element element2 : Channel_nodeList) {
            this.addChannel(new Channel(element2, model));
        }
        List<Element> BinData_nodeList = Pixels.getChildrenByTagName(element, "BinData");
        for (Element element3 : BinData_nodeList) {
            this.addBinData(new BinData(element3, model));
        }
        List<Element> list = Pixels.getChildrenByTagName(element, "TiffData");
        for (Element TiffData_element : list) {
            this.addTiffData(new TiffData(TiffData_element, model));
        }
        List<Element> list2 = Pixels.getChildrenByTagName(element, "MetadataOnly");
        if (list2.size() > 1) {
            throw new RuntimeException(String.format("MetadataOnly node list size %d != 1", list2.size()));
        }
        if (list2.size() != 0) {
            this.setMetadataOnly(new MetadataOnly(list2.get(0), model));
        }
        List<Element> Plane_nodeList = Pixels.getChildrenByTagName(element, "Plane");
        for (Element Plane_element : Plane_nodeList) {
            this.addPlane(new Plane(Plane_element, model));
        }
    }

    @Override
    public boolean link(Reference reference, OMEModelObject o) {
        return super.link(reference, o);
    }

    public String getID() {
        return this.id;
    }

    public void setID(String id) {
        this.id = id;
    }

    public DimensionOrder getDimensionOrder() {
        return this.dimensionOrder;
    }

    public void setDimensionOrder(DimensionOrder dimensionOrder) {
        this.dimensionOrder = dimensionOrder;
    }

    public PixelType getType() {
        return this.type;
    }

    public void setType(PixelType type) {
        this.type = type;
    }

    public PositiveInteger getSignificantBits() {
        return this.significantBits;
    }

    public void setSignificantBits(PositiveInteger significantBits) {
        this.significantBits = significantBits;
    }

    public Boolean getInterleaved() {
        return this.interleaved;
    }

    public void setInterleaved(Boolean interleaved) {
        this.interleaved = interleaved;
    }

    public Boolean getBigEndian() {
        return this.bigEndian;
    }

    public void setBigEndian(Boolean bigEndian) {
        this.bigEndian = bigEndian;
    }

    public PositiveInteger getSizeX() {
        return this.sizeX;
    }

    public void setSizeX(PositiveInteger sizeX) {
        this.sizeX = sizeX;
    }

    public PositiveInteger getSizeY() {
        return this.sizeY;
    }

    public void setSizeY(PositiveInteger sizeY) {
        this.sizeY = sizeY;
    }

    public PositiveInteger getSizeZ() {
        return this.sizeZ;
    }

    public void setSizeZ(PositiveInteger sizeZ) {
        this.sizeZ = sizeZ;
    }

    public PositiveInteger getSizeC() {
        return this.sizeC;
    }

    public void setSizeC(PositiveInteger sizeC) {
        this.sizeC = sizeC;
    }

    public PositiveInteger getSizeT() {
        return this.sizeT;
    }

    public void setSizeT(PositiveInteger sizeT) {
        this.sizeT = sizeT;
    }

    public Length getPhysicalSizeX() {
        return this.physicalSizeX;
    }

    public void setPhysicalSizeX(Length physicalSizeX) {
        this.physicalSizeX = physicalSizeX;
    }

    public static String getPhysicalSizeXUnitXsdDefault() {
        return "\u00b5m";
    }

    public Length getPhysicalSizeY() {
        return this.physicalSizeY;
    }

    public void setPhysicalSizeY(Length physicalSizeY) {
        this.physicalSizeY = physicalSizeY;
    }

    public static String getPhysicalSizeYUnitXsdDefault() {
        return "\u00b5m";
    }

    public Length getPhysicalSizeZ() {
        return this.physicalSizeZ;
    }

    public void setPhysicalSizeZ(Length physicalSizeZ) {
        this.physicalSizeZ = physicalSizeZ;
    }

    public static String getPhysicalSizeZUnitXsdDefault() {
        return "\u00b5m";
    }

    public Time getTimeIncrement() {
        return this.timeIncrement;
    }

    public void setTimeIncrement(Time timeIncrement) {
        this.timeIncrement = timeIncrement;
    }

    public static String getTimeIncrementUnitXsdDefault() {
        return "s";
    }

    public int sizeOfChannelList() {
        return this.channels.size();
    }

    public List<Channel> copyChannelList() {
        return new ArrayList<Channel>(this.channels);
    }

    public Channel getChannel(int index) {
        return this.channels.get(index);
    }

    public Channel setChannel(int index, Channel channel) {
        channel.setPixels(this);
        return this.channels.set(index, channel);
    }

    public void addChannel(Channel channel) {
        channel.setPixels(this);
        this.channels.add(channel);
    }

    public void removeChannel(Channel channel) {
        this.channels.remove(channel);
    }

    public int sizeOfBinDataList() {
        return this.binDataBlocks.size();
    }

    public List<BinData> copyBinDataList() {
        return new ArrayList<BinData>(this.binDataBlocks);
    }

    public BinData getBinData(int index) {
        return this.binDataBlocks.get(index);
    }

    public BinData setBinData(int index, BinData binData) {
        binData.setPixels(this);
        return this.binDataBlocks.set(index, binData);
    }

    public void addBinData(BinData binData) {
        binData.setPixels(this);
        this.binDataBlocks.add(binData);
    }

    public void removeBinData(BinData binData) {
        this.binDataBlocks.remove(binData);
    }

    public int sizeOfTiffDataList() {
        return this.tiffDataBlocks.size();
    }

    public List<TiffData> copyTiffDataList() {
        return new ArrayList<TiffData>(this.tiffDataBlocks);
    }

    public TiffData getTiffData(int index) {
        return this.tiffDataBlocks.get(index);
    }

    public TiffData setTiffData(int index, TiffData tiffData) {
        tiffData.setPixels(this);
        return this.tiffDataBlocks.set(index, tiffData);
    }

    public void addTiffData(TiffData tiffData) {
        tiffData.setPixels(this);
        this.tiffDataBlocks.add(tiffData);
    }

    public void removeTiffData(TiffData tiffData) {
        this.tiffDataBlocks.remove(tiffData);
    }

    public MetadataOnly getMetadataOnly() {
        return this.metadataOnly;
    }

    public void setMetadataOnly(MetadataOnly metadataOnly) {
        this.metadataOnly = metadataOnly;
    }

    public int sizeOfPlaneList() {
        return this.planes.size();
    }

    public List<Plane> copyPlaneList() {
        return new ArrayList<Plane>(this.planes);
    }

    public Plane getPlane(int index) {
        return this.planes.get(index);
    }

    public Plane setPlane(int index, Plane plane) {
        plane.setPixels(this);
        return this.planes.set(index, plane);
    }

    public void addPlane(Plane plane) {
        plane.setPixels(this);
        this.planes.add(plane);
    }

    public void removePlane(Plane plane) {
        this.planes.remove(plane);
    }

    @Override
    public Element asXMLElement(Document document) {
        return this.asXMLElement(document, null);
    }

    @Override
    public Element asXMLElement(Document document, Element Pixels_element) {
        Element child;
        Enum enumUnits;
        if (Pixels_element == null) {
            Pixels_element = document.createElementNS(NAMESPACE, "Pixels");
        }
        super.asXMLElement(document, Pixels_element);
        if (this.id != null) {
            Pixels_element.setAttribute("ID", this.id);
        }
        if (this.dimensionOrder != null) {
            Pixels_element.setAttribute("DimensionOrder", this.dimensionOrder.toString());
        }
        if (this.type != null) {
            Pixels_element.setAttribute("Type", this.type.toString());
        }
        if (this.significantBits != null) {
            Pixels_element.setAttribute("SignificantBits", this.significantBits.toString());
        }
        if (this.interleaved != null) {
            Pixels_element.setAttribute("Interleaved", this.interleaved.toString());
        }
        if (this.bigEndian != null) {
            Pixels_element.setAttribute("BigEndian", this.bigEndian.toString());
        }
        if (this.sizeX != null) {
            Pixels_element.setAttribute("SizeX", this.sizeX.toString());
        }
        if (this.sizeY != null) {
            Pixels_element.setAttribute("SizeY", this.sizeY.toString());
        }
        if (this.sizeZ != null) {
            Pixels_element.setAttribute("SizeZ", this.sizeZ.toString());
        }
        if (this.sizeC != null) {
            Pixels_element.setAttribute("SizeC", this.sizeC.toString());
        }
        if (this.sizeT != null) {
            Pixels_element.setAttribute("SizeT", this.sizeT.toString());
        }
        if (this.physicalSizeX != null) {
            if (this.physicalSizeX.value() != null) {
                Pixels_element.setAttribute("PhysicalSizeX", this.physicalSizeX.value().toString());
            }
            if (this.physicalSizeX.unit() != null) {
                try {
                    enumUnits = UnitsLength.fromString(this.physicalSizeX.unit().getSymbol());
                    Pixels_element.setAttribute("PhysicalSizeXUnit", ((UnitsLength)enumUnits).toString());
                }
                catch (EnumerationException e) {
                    LOGGER.debug("Unable to create xml for Pixels:PhysicalSizeXUnit: {}", (Object)e.toString());
                }
            }
        }
        if (this.physicalSizeY != null) {
            if (this.physicalSizeY.value() != null) {
                Pixels_element.setAttribute("PhysicalSizeY", this.physicalSizeY.value().toString());
            }
            if (this.physicalSizeY.unit() != null) {
                try {
                    enumUnits = UnitsLength.fromString(this.physicalSizeY.unit().getSymbol());
                    Pixels_element.setAttribute("PhysicalSizeYUnit", ((UnitsLength)enumUnits).toString());
                }
                catch (EnumerationException e) {
                    LOGGER.debug("Unable to create xml for Pixels:PhysicalSizeYUnit: {}", (Object)e.toString());
                }
            }
        }
        if (this.physicalSizeZ != null) {
            if (this.physicalSizeZ.value() != null) {
                Pixels_element.setAttribute("PhysicalSizeZ", this.physicalSizeZ.value().toString());
            }
            if (this.physicalSizeZ.unit() != null) {
                try {
                    enumUnits = UnitsLength.fromString(this.physicalSizeZ.unit().getSymbol());
                    Pixels_element.setAttribute("PhysicalSizeZUnit", ((UnitsLength)enumUnits).toString());
                }
                catch (EnumerationException e) {
                    LOGGER.debug("Unable to create xml for Pixels:PhysicalSizeZUnit: {}", (Object)e.toString());
                }
            }
        }
        if (this.timeIncrement != null) {
            if (this.timeIncrement.value() != null) {
                Pixels_element.setAttribute("TimeIncrement", this.timeIncrement.value().toString());
            }
            if (this.timeIncrement.unit() != null) {
                try {
                    enumUnits = UnitsTime.fromString(this.timeIncrement.unit().getSymbol());
                    Pixels_element.setAttribute("TimeIncrementUnit", ((UnitsTime)enumUnits).toString());
                }
                catch (EnumerationException e) {
                    LOGGER.debug("Unable to create xml for Pixels:TimeIncrementUnit: {}", (Object)e.toString());
                }
            }
        }
        if (this.channels != null) {
            for (Channel channels_value : this.channels) {
                child = document.createElementNS(NAMESPACE, "Channel");
                channels_value.asXMLElement(document, child);
                Pixels_element.appendChild(child);
            }
        }
        if (this.binDataBlocks != null) {
            for (BinData binDataBlocks_value : this.binDataBlocks) {
                child = document.createElementNS(NAMESPACE, "BinData");
                binDataBlocks_value.asXMLElement(document, child);
                Pixels_element.appendChild(child);
            }
        }
        if (this.tiffDataBlocks != null) {
            for (TiffData tiffDataBlocks_value : this.tiffDataBlocks) {
                child = document.createElementNS(NAMESPACE, "TiffData");
                tiffDataBlocks_value.asXMLElement(document, child);
                Pixels_element.appendChild(child);
            }
        }
        if (this.metadataOnly != null) {
            Element child2 = document.createElementNS(NAMESPACE, "MetadataOnly");
            this.metadataOnly.asXMLElement(document, child2);
            Pixels_element.appendChild(child2);
        }
        if (this.planes != null) {
            for (Plane planes_value : this.planes) {
                child = document.createElementNS(NAMESPACE, "Plane");
                planes_value.asXMLElement(document, child);
                Pixels_element.appendChild(child);
            }
        }
        return Pixels_element;
    }
}

