/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.model;

import java.util.List;
import ome.xml.model.AbstractOMEModelObject;
import ome.xml.model.OMEModel;
import ome.xml.model.OMEModelObject;
import ome.xml.model.Pixels;
import ome.xml.model.Reference;
import ome.xml.model.UUID;
import ome.xml.model.enums.EnumerationException;
import ome.xml.model.primitives.NonNegativeInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TiffData
extends AbstractOMEModelObject {
    public static final String NAMESPACE = "http://www.openmicroscopy.org/Schemas/OME/2016-06";
    private static final Logger LOGGER = LoggerFactory.getLogger(TiffData.class);
    private NonNegativeInteger ifd;
    private NonNegativeInteger firstZ;
    private NonNegativeInteger firstT;
    private NonNegativeInteger firstC;
    private NonNegativeInteger planeCount;
    private UUID uuid;
    private Pixels pixels;

    public TiffData() {
    }

    public TiffData(Element element, OMEModel model) throws EnumerationException {
        this.update(element, model);
    }

    public TiffData(TiffData orig) {
        this.ifd = orig.ifd;
        this.firstZ = orig.firstZ;
        this.firstT = orig.firstT;
        this.firstC = orig.firstC;
        this.planeCount = orig.planeCount;
        this.uuid = orig.uuid;
        this.pixels = orig.pixels;
    }

    @Override
    public void update(Element element, OMEModel model) throws EnumerationException {
        List<Element> UUID_nodeList;
        super.update(element, model);
        if (element.hasAttribute("IFD")) {
            this.setIFD(NonNegativeInteger.valueOf(element.getAttribute("IFD")));
        }
        if (element.hasAttribute("FirstZ")) {
            this.setFirstZ(NonNegativeInteger.valueOf(element.getAttribute("FirstZ")));
        }
        if (element.hasAttribute("FirstT")) {
            this.setFirstT(NonNegativeInteger.valueOf(element.getAttribute("FirstT")));
        }
        if (element.hasAttribute("FirstC")) {
            this.setFirstC(NonNegativeInteger.valueOf(element.getAttribute("FirstC")));
        }
        if (element.hasAttribute("PlaneCount")) {
            this.setPlaneCount(NonNegativeInteger.valueOf(element.getAttribute("PlaneCount")));
        }
        if ((UUID_nodeList = TiffData.getChildrenByTagName(element, "UUID")).size() > 1) {
            throw new RuntimeException(String.format("UUID node list size %d != 1", UUID_nodeList.size()));
        }
        if (UUID_nodeList.size() != 0) {
            this.setUUID(new UUID(UUID_nodeList.get(0), model));
        }
    }

    @Override
    public boolean link(Reference reference, OMEModelObject o) {
        return super.link(reference, o);
    }

    public NonNegativeInteger getIFD() {
        return this.ifd;
    }

    public void setIFD(NonNegativeInteger ifd) {
        this.ifd = ifd;
    }

    public NonNegativeInteger getFirstZ() {
        return this.firstZ;
    }

    public void setFirstZ(NonNegativeInteger firstZ) {
        this.firstZ = firstZ;
    }

    public NonNegativeInteger getFirstT() {
        return this.firstT;
    }

    public void setFirstT(NonNegativeInteger firstT) {
        this.firstT = firstT;
    }

    public NonNegativeInteger getFirstC() {
        return this.firstC;
    }

    public void setFirstC(NonNegativeInteger firstC) {
        this.firstC = firstC;
    }

    public NonNegativeInteger getPlaneCount() {
        return this.planeCount;
    }

    public void setPlaneCount(NonNegativeInteger planeCount) {
        this.planeCount = planeCount;
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public void setUUID(UUID uuid) {
        this.uuid = uuid;
    }

    public Pixels getPixels() {
        return this.pixels;
    }

    public void setPixels(Pixels pixels_BackReference) {
        this.pixels = pixels_BackReference;
    }

    @Override
    public Element asXMLElement(Document document) {
        return this.asXMLElement(document, null);
    }

    @Override
    public Element asXMLElement(Document document, Element TiffData_element) {
        if (TiffData_element == null) {
            TiffData_element = document.createElementNS(NAMESPACE, "TiffData");
        }
        super.asXMLElement(document, TiffData_element);
        if (this.ifd != null) {
            TiffData_element.setAttribute("IFD", this.ifd.toString());
        }
        if (this.firstZ != null) {
            TiffData_element.setAttribute("FirstZ", this.firstZ.toString());
        }
        if (this.firstT != null) {
            TiffData_element.setAttribute("FirstT", this.firstT.toString());
        }
        if (this.firstC != null) {
            TiffData_element.setAttribute("FirstC", this.firstC.toString());
        }
        if (this.planeCount != null) {
            TiffData_element.setAttribute("PlaneCount", this.planeCount.toString());
        }
        if (this.uuid != null) {
            Element child = document.createElementNS(NAMESPACE, "UUID");
            this.uuid.asXMLElement(document, child);
            TiffData_element.appendChild(child);
        }
        return TiffData_element;
    }
}

