/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.model.enums;

import ome.xml.model.enums.Enumeration;
import ome.xml.model.enums.EnumerationException;

public enum FontFamily implements Enumeration
{
    SERIF("serif"),
    SANSSERIF("sans-serif"),
    CURSIVE("cursive"),
    FANTASY("fantasy"),
    MONOSPACE("monospace");

    private final String value;

    private FontFamily(String value) {
        this.value = value;
    }

    public static FontFamily fromString(String value) throws EnumerationException {
        if ("serif".equals(value)) {
            return SERIF;
        }
        if ("sans-serif".equals(value)) {
            return SANSSERIF;
        }
        if ("cursive".equals(value)) {
            return CURSIVE;
        }
        if ("fantasy".equals(value)) {
            return FANTASY;
        }
        if ("monospace".equals(value)) {
            return MONOSPACE;
        }
        String s2 = String.format("'%s' not a supported value of '%s'", value, FontFamily.class);
        throw new EnumerationException(s2);
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return this.value;
    }
}

