/*
 * Decompiled with CFR 0.152.
 */
package org.perf4j.helpers;

import java.util.Map;
import org.perf4j.GroupedTimingStatistics;
import org.perf4j.TimingStatistics;
import org.perf4j.helpers.GroupedTimingStatisticsFormatter;
import org.perf4j.helpers.MiscUtils;

public class GroupedTimingStatisticsCsvFormatter
implements GroupedTimingStatisticsFormatter {
    public static final String DEFAULT_FORMAT_STRING = "tag,start,stop,mean,min,max,stddev,count";
    private boolean pivot;
    private TimingStatsValueRetriever[] valueRetrievers;
    private GroupedTimingStatisticsValueRetriever[] pivotedValueRetrievers;

    public GroupedTimingStatisticsCsvFormatter() {
        this(false, DEFAULT_FORMAT_STRING);
    }

    public GroupedTimingStatisticsCsvFormatter(boolean pivot, String configString) {
        this.pivot = pivot;
        String[] configElements = MiscUtils.splitAndTrim(configString, ",");
        if (pivot) {
            this.pivotedValueRetrievers = new GroupedTimingStatisticsValueRetriever[configElements.length];
            for (int i = 0; i < configElements.length; ++i) {
                this.pivotedValueRetrievers[i] = this.parsePivotedTimingStatsConfig(configElements[i]);
            }
        } else {
            this.valueRetrievers = new TimingStatsValueRetriever[configElements.length];
            for (int i = 0; i < configElements.length; ++i) {
                this.valueRetrievers[i] = this.parseTimingStatsConfig(configElements[i]);
            }
        }
    }

    public String format(GroupedTimingStatistics stats) {
        String startTime = this.formatDate(stats.getStartTime());
        String stopTime = this.formatDate(stats.getStopTime());
        long windowLength = stats.getStopTime() - stats.getStartTime();
        StringBuilder retVal = new StringBuilder();
        if (this.pivot) {
            for (int i = 0; i < this.pivotedValueRetrievers.length; ++i) {
                if (i > 0) {
                    retVal.append(',');
                }
                this.pivotedValueRetrievers[i].appendValue(startTime, stopTime, windowLength, stats, retVal);
            }
            retVal.append(MiscUtils.NEWLINE);
        } else {
            for (Map.Entry<String, TimingStatistics> tagAndStats : stats.getStatisticsByTag().entrySet()) {
                String tag = tagAndStats.getKey();
                TimingStatistics timingStats = tagAndStats.getValue();
                for (int i = 0; i < this.valueRetrievers.length; ++i) {
                    if (i > 0) {
                        retVal.append(',');
                    }
                    this.valueRetrievers[i].appendValue(tag, startTime, stopTime, windowLength, timingStats, retVal);
                }
                retVal.append(MiscUtils.NEWLINE);
            }
        }
        return retVal.toString();
    }

    protected String formatDate(long timeInMillis) {
        return MiscUtils.formatDateIso8601(timeInMillis);
    }

    protected GroupedTimingStatisticsValueRetriever parsePivotedTimingStatsConfig(String configName) {
        if ("start".equalsIgnoreCase(configName)) {
            return new GroupedTimingStatisticsValueRetriever(){

                public void appendValue(String start, String stop, long windowLength, GroupedTimingStatistics stats, StringBuilder toAppend) {
                    toAppend.append(start);
                }
            };
        }
        if ("stop".equalsIgnoreCase(configName)) {
            return new GroupedTimingStatisticsValueRetriever(){

                public void appendValue(String start, String stop, long windowLength, GroupedTimingStatistics stats, StringBuilder toAppend) {
                    toAppend.append(stop);
                }
            };
        }
        if (configName.toLowerCase().endsWith("mean")) {
            final String tag = configName.substring(0, configName.length() - "mean".length());
            return new GroupedTimingStatisticsValueRetriever(){

                public void appendValue(String start, String stop, long windowLength, GroupedTimingStatistics stats, StringBuilder toAppend) {
                    TimingStatistics timingStats = (TimingStatistics)stats.getStatisticsByTag().get(tag);
                    toAppend.append(timingStats == null ? "" : Double.valueOf(timingStats.getMean()));
                }
            };
        }
        if (configName.toLowerCase().endsWith("min")) {
            final String tag = configName.substring(0, configName.length() - "min".length());
            return new GroupedTimingStatisticsValueRetriever(){

                public void appendValue(String start, String stop, long windowLength, GroupedTimingStatistics stats, StringBuilder toAppend) {
                    TimingStatistics timingStats = (TimingStatistics)stats.getStatisticsByTag().get(tag);
                    toAppend.append(timingStats == null ? "" : Long.valueOf(timingStats.getMin()));
                }
            };
        }
        if (configName.toLowerCase().endsWith("max")) {
            final String tag = configName.substring(0, configName.length() - "max".length());
            return new GroupedTimingStatisticsValueRetriever(){

                public void appendValue(String start, String stop, long windowLength, GroupedTimingStatistics stats, StringBuilder toAppend) {
                    TimingStatistics timingStats = (TimingStatistics)stats.getStatisticsByTag().get(tag);
                    toAppend.append(timingStats == null ? "" : Long.valueOf(timingStats.getMax()));
                }
            };
        }
        if (configName.toLowerCase().endsWith("stddev")) {
            final String tag = configName.substring(0, configName.length() - "stddev".length());
            return new GroupedTimingStatisticsValueRetriever(){

                public void appendValue(String start, String stop, long windowLength, GroupedTimingStatistics stats, StringBuilder toAppend) {
                    TimingStatistics timingStats = (TimingStatistics)stats.getStatisticsByTag().get(tag);
                    toAppend.append(timingStats == null ? "" : Double.valueOf(timingStats.getStandardDeviation()));
                }
            };
        }
        if (configName.toLowerCase().endsWith("count")) {
            final String tag = configName.substring(0, configName.length() - "count".length());
            return new GroupedTimingStatisticsValueRetriever(){

                public void appendValue(String start, String stop, long windowLength, GroupedTimingStatistics stats, StringBuilder toAppend) {
                    TimingStatistics timingStats = (TimingStatistics)stats.getStatisticsByTag().get(tag);
                    toAppend.append(timingStats == null ? "" : Integer.valueOf(timingStats.getCount()));
                }
            };
        }
        if (configName.toLowerCase().endsWith("tps")) {
            final String tag = configName.substring(0, configName.length() - "tps".length());
            return new GroupedTimingStatisticsValueRetriever(){

                public void appendValue(String start, String stop, long windowLength, GroupedTimingStatistics stats, StringBuilder toAppend) {
                    TimingStatistics timingStats = (TimingStatistics)stats.getStatisticsByTag().get(tag);
                    if (timingStats == null) {
                        toAppend.append("");
                    } else {
                        toAppend.append((double)timingStats.getCount() * 1000.0 / (double)windowLength);
                    }
                }
            };
        }
        throw new IllegalArgumentException("Unknown CSV format config string: " + configName);
    }

    protected TimingStatsValueRetriever parseTimingStatsConfig(String configName) {
        if ("tag".equals(configName)) {
            return new TimingStatsValueRetriever(){

                public void appendValue(String tag, String start, String stop, long windowLength, TimingStatistics timingStats, StringBuilder toAppend) {
                    MiscUtils.escapeStringForCsv(tag, toAppend);
                }
            };
        }
        if ("start".equals(configName)) {
            return new TimingStatsValueRetriever(){

                public void appendValue(String tag, String start, String stop, long windowLength, TimingStatistics timingStats, StringBuilder toAppend) {
                    toAppend.append(start);
                }
            };
        }
        if ("stop".equals(configName)) {
            return new TimingStatsValueRetriever(){

                public void appendValue(String tag, String start, String stop, long windowLength, TimingStatistics timingStats, StringBuilder toAppend) {
                    toAppend.append(stop);
                }
            };
        }
        if ("mean".equals(configName)) {
            return new TimingStatsValueRetriever(){

                public void appendValue(String tag, String start, String stop, long windowLength, TimingStatistics timingStats, StringBuilder toAppend) {
                    toAppend.append(timingStats.getMean());
                }
            };
        }
        if ("min".equals(configName)) {
            return new TimingStatsValueRetriever(){

                public void appendValue(String tag, String start, String stop, long windowLength, TimingStatistics timingStats, StringBuilder toAppend) {
                    toAppend.append(timingStats.getMin());
                }
            };
        }
        if ("max".equals(configName)) {
            return new TimingStatsValueRetriever(){

                public void appendValue(String tag, String start, String stop, long windowLength, TimingStatistics timingStats, StringBuilder toAppend) {
                    toAppend.append(timingStats.getMax());
                }
            };
        }
        if ("stddev".equals(configName)) {
            return new TimingStatsValueRetriever(){

                public void appendValue(String tag, String start, String stop, long windowLength, TimingStatistics timingStats, StringBuilder toAppend) {
                    toAppend.append(timingStats.getStandardDeviation());
                }
            };
        }
        if ("count".equals(configName)) {
            return new TimingStatsValueRetriever(){

                public void appendValue(String tag, String start, String stop, long windowLength, TimingStatistics timingStats, StringBuilder toAppend) {
                    toAppend.append(timingStats.getCount());
                }
            };
        }
        if ("tps".equals(configName)) {
            return new TimingStatsValueRetriever(){

                public void appendValue(String tag, String start, String stop, long windowLength, TimingStatistics timingStats, StringBuilder toAppend) {
                    toAppend.append((double)timingStats.getCount() * 1000.0 / (double)windowLength);
                }
            };
        }
        throw new IllegalArgumentException("Unknown CSV format config string: " + configName);
    }

    protected static interface GroupedTimingStatisticsValueRetriever {
        public void appendValue(String var1, String var2, long var3, GroupedTimingStatistics var5, StringBuilder var6);
    }

    protected static interface TimingStatsValueRetriever {
        public void appendValue(String var1, String var2, String var3, long var4, TimingStatistics var6, StringBuilder var7);
    }
}

