/*
 * Decompiled with CFR 0.152.
 */
package thredds.inventory;

import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import thredds.inventory.CollectionAbstract;
import thredds.inventory.MFile;
import thredds.inventory.MFileIterator;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.util.CloseableIterator;

public class CollectionListRange
extends CollectionAbstract {
    private final List<MFile> mfiles = new ArrayList<MFile>();
    private final CalendarDate startDate;
    private final CalendarDate endDate;

    public CollectionListRange(String collectionName, String root, CalendarDate startDate, CalendarDate endDate, Logger logger) {
        super(collectionName, logger);
        this.setRoot(root);
        this.startDate = startDate;
        this.endDate = endDate;
    }

    public CalendarDate getStartDate() {
        return this.startDate;
    }

    public CalendarDate getEndDate() {
        return this.endDate;
    }

    public void addFile(MFile mfile) {
        this.mfiles.add(mfile);
    }

    @Override
    public Iterable<MFile> getFilesSorted() {
        return this.mfiles;
    }

    @Override
    public CloseableIterator<MFile> getFileIterator() {
        return new MFileIterator(this.mfiles.iterator(), null);
    }

    @Override
    public void close() {
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("collectionName", this.collectionName).add("startDate", this.startDate).add("endDate", this.endDate).toString();
    }
}

