/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dataset.transform;

import ucar.nc2.AttributeContainer;
import ucar.nc2.Dimension;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.TransformType;
import ucar.nc2.dataset.VerticalCT;
import ucar.nc2.dataset.transform.AbstractTransformBuilder;
import ucar.nc2.dataset.transform.VertTransformBuilderIF;
import ucar.unidata.geoloc.vertical.AtmosSigma;
import ucar.unidata.geoloc.vertical.VerticalTransform;
import ucar.unidata.util.Parameter;

public class CFSigma
extends AbstractTransformBuilder
implements VertTransformBuilderIF {
    private String sigma = "";
    private String ps = "";
    private String ptop = "";

    @Override
    public String getTransformName() {
        return VerticalCT.Type.Sigma.name();
    }

    public TransformType getTransformType() {
        return TransformType.Vertical;
    }

    @Override
    public VerticalCT makeCoordinateTransform(NetcdfDataset ds, AttributeContainer ctv) {
        String formula_terms = this.getFormula(ctv);
        if (null == formula_terms) {
            return null;
        }
        String[] values = this.parseFormula(formula_terms, "sigma ps ptop");
        if (values == null) {
            return null;
        }
        this.sigma = values[0];
        this.ps = values[1];
        this.ptop = values[2];
        VerticalCT rs = new VerticalCT("AtmSigma_Transform_" + ctv.getName(), this.getTransformName(), VerticalCT.Type.Sigma, this);
        rs.addParameter(new Parameter("standard_name", this.getTransformName()));
        rs.addParameter(new Parameter("formula_terms", formula_terms));
        rs.addParameter(new Parameter("formula", "pressure(x,y,z) = ptop + sigma(z)*(surfacePressure(x,y)-ptop)"));
        if (!this.addParameter(rs, "SurfacePressure_variableName", ds, this.ps)) {
            return null;
        }
        if (!this.addParameter(rs, "Sigma_variableName", ds, this.sigma)) {
            return null;
        }
        if (!this.addParameter(rs, "PressureTop_variableName", ds, this.ptop)) {
            return null;
        }
        return rs;
    }

    public String toString() {
        return "Sigma:sigma:" + this.sigma + " ps:" + this.ps + " ptop:" + this.ptop;
    }

    @Override
    public VerticalTransform makeMathTransform(NetcdfDataset ds, Dimension timeDim, VerticalCT vCT) {
        return new AtmosSigma(ds, timeDim, vCT.getParameters());
    }
}

