/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point;

import java.io.IOException;
import javax.annotation.Nonnull;
import ucar.nc2.ft.DsgFeatureCollection;
import ucar.nc2.ft.PointFeature;
import ucar.nc2.ft.PointFeatureCC;
import ucar.nc2.ft.PointFeatureCCC;
import ucar.nc2.ft.PointFeatureCollection;
import ucar.nc2.ft.point.CollectionInfo;
import ucar.nc2.time.CalendarDateRange;
import ucar.nc2.time.CalendarDateUnit;
import ucar.nc2.util.IOIterator;
import ucar.unidata.geoloc.LatLonRect;

public class DsgCollectionHelper {
    DsgFeatureCollection dsg;

    public DsgCollectionHelper(DsgFeatureCollection dsg) {
        this.dsg = dsg;
    }

    @Nonnull
    public CollectionInfo calcBounds() throws IOException {
        if (this.dsg instanceof PointFeatureCollection) {
            return this.calcBounds((PointFeatureCollection)this.dsg);
        }
        if (this.dsg instanceof PointFeatureCC) {
            return this.calcBounds((PointFeatureCC)this.dsg);
        }
        if (this.dsg instanceof PointFeatureCCC) {
            return this.calcBounds((PointFeatureCCC)this.dsg);
        }
        throw new IllegalStateException(this.dsg.getClass().getName());
    }

    private CollectionInfo calcBounds(PointFeatureCollection pfc) {
        LatLonRect bbox = null;
        double minTime = Double.MAX_VALUE;
        double maxTime = -1.7976931348623157E308;
        int count = 0;
        for (PointFeature pf : pfc) {
            if (bbox == null) {
                bbox = new LatLonRect(pf.getLocation().getLatLon(), 0.001, 0.001);
            } else {
                bbox.extend(pf.getLocation().getLatLon());
            }
            double obsTime = pf.getObservationTime();
            minTime = Math.min(minTime, obsTime);
            maxTime = Math.max(maxTime, obsTime);
            ++count;
        }
        if (count == 0) {
            return new CollectionInfo(null, null, 0, 0);
        }
        CalendarDateUnit cdu = this.dsg.getTimeUnit();
        CalendarDateRange dateRange = CalendarDateRange.of(cdu.makeCalendarDate(minTime), cdu.makeCalendarDate(maxTime));
        return new CollectionInfo(bbox, dateRange, count, count);
    }

    private CollectionInfo calcBounds(PointFeatureCC pfcc) throws IOException {
        try (IOIterator<PointFeatureCollection> iter = pfcc.getCollectionIterator();){
            CollectionInfo result = null;
            while (iter.hasNext()) {
                PointFeatureCollection pfc = iter.next();
                CollectionInfo b = this.calcBounds(pfc);
                if (result == null) {
                    result = b;
                    continue;
                }
                result.extend(b);
            }
            CollectionInfo collectionInfo = result;
            return collectionInfo;
        }
    }

    private CollectionInfo calcBounds(PointFeatureCCC pfccc) throws IOException {
        try (IOIterator<PointFeatureCC> iter = pfccc.getCollectionIterator();){
            CollectionInfo result = null;
            while (iter.hasNext()) {
                PointFeatureCC pfcc = iter.next();
                CollectionInfo b = this.calcBounds(pfcc);
                if (result == null) {
                    result = b;
                    continue;
                }
                result.extend(b);
            }
            CollectionInfo collectionInfo = result;
            return collectionInfo;
        }
    }
}

