/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.internal.dataset.conv;

import java.io.IOException;
import java.util.Optional;
import ucar.ma2.Array;
import ucar.ma2.ArrayFloat;
import ucar.ma2.DataType;
import ucar.ma2.Index;
import ucar.nc2.Attribute;
import ucar.nc2.Variable;
import ucar.nc2.constants.AxisType;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.CoordinateAxis1D;
import ucar.nc2.dataset.CoordinateTransform;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.ProjectionCT;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.dataset.spi.CoordSystemBuilderFactory;
import ucar.nc2.internal.dataset.CoordSystemBuilder;
import ucar.nc2.units.SimpleUnit;
import ucar.nc2.util.CancelTask;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.Projection;
import ucar.unidata.geoloc.ProjectionPoint;
import ucar.unidata.geoloc.ProjectionPointImpl;
import ucar.unidata.geoloc.projection.LambertConformal;

public class ADASConvention
extends CoordSystemBuilder {
    private static final String CONVENTION_NAME = "ARPS/ADAS";
    private ProjectionCT projCT;
    private static final boolean debugProj = false;

    ADASConvention(NetcdfDataset.Builder datasetBuilder) {
        super(datasetBuilder);
        this.conventionName = CONVENTION_NAME;
    }

    @Override
    protected void augmentDataset(CancelTask cancelTask) throws IOException {
        if (!this.rootGroup.findVariable("x").isPresent()) {
            return;
        }
        Attribute att = this.rootGroup.getAttributeContainer().findAttribute("MAPPROJ");
        int projType = att.getNumericValue().intValue();
        double lat1 = this.rootGroup.getAttributeContainer().findAttributeDouble("TRUELAT1", Double.NaN);
        double lat2 = this.rootGroup.getAttributeContainer().findAttributeDouble("TRUELAT2", Double.NaN);
        double lat_origin = lat1;
        double lon_origin = this.rootGroup.getAttributeContainer().findAttributeDouble("TRUELON", Double.NaN);
        double false_easting = 0.0;
        double false_northing = 0.0;
        String projName = this.rootGroup.getAttributeContainer().findAttValueIgnoreCase("grid_mapping_name", null);
        if (projName != null) {
            projName = projName.trim();
            lat_origin = this.rootGroup.getAttributeContainer().findAttributeDouble("latitude_of_projection_origin", Double.NaN);
            lon_origin = this.rootGroup.getAttributeContainer().findAttributeDouble("longitude_of_central_meridian", Double.NaN);
            false_easting = this.rootGroup.getAttributeContainer().findAttributeDouble("false_easting", 0.0);
            false_northing = this.rootGroup.getAttributeContainer().findAttributeDouble("false_northing", 0.0);
            Attribute att2 = this.rootGroup.getAttributeContainer().findAttributeIgnoreCase("standard_parallel");
            if (att2 != null) {
                lat1 = att2.getNumericValue().doubleValue();
                lat2 = att2.getLength() > 1 ? att2.getNumericValue(1).doubleValue() : lat1;
            }
        } else if (projType == 2) {
            projName = "lambert_conformal_conic";
        }
        Optional<Variable.Builder<?>> coordOpt = this.rootGroup.findVariable("x_stag");
        if (coordOpt.isPresent()) {
            Variable.Builder<?> coord = coordOpt.get();
            if (!Double.isNaN(false_easting) || !Double.isNaN(false_northing)) {
                String units = coord.getAttributeContainer().findAttValueIgnoreCase("units", null);
                double scalef = 1.0;
                try {
                    scalef = SimpleUnit.getConversionFactor(units, "km");
                }
                catch (IllegalArgumentException e) {
                    log.error(units + " not convertible to km");
                }
                false_easting *= scalef;
                false_northing *= scalef;
            }
        }
        if ("lambert_conformal_conic".equalsIgnoreCase(projName)) {
            LambertConformal proj = new LambertConformal(lat_origin, lon_origin, lat1, lat2, false_easting, false_northing);
            this.projCT = new ProjectionCT("Projection", "FGDC", proj);
            if (false_easting == 0.0) {
                this.calcCenterPoints(proj);
            }
        } else {
            this.parseInfo.format("ERROR: unknown projection type = %s%n", projName);
        }
        if (this.projCT != null) {
            VariableDS.Builder v = this.makeCoordinateTransformVariable(this.projCT);
            v.addAttribute(new Attribute("_CoordinateAxisTypes", "GeoX GeoY"));
            this.rootGroup.addVariable(v);
        }
        this.makeCoordAxis("x");
        this.makeCoordAxis("y");
        this.makeCoordAxis("z");
        this.rootGroup.findVariable("ZPSOIL").ifPresent(vb -> vb.addAttribute(new Attribute("_CoordinateAxisType", AxisType.GeoZ.toString())));
    }

    private void calcCenterPoints(Projection proj) throws IOException {
        double lat_check = this.rootGroup.getAttributeContainer().findAttributeDouble("CTRLAT", Double.NaN);
        double lon_check = this.rootGroup.getAttributeContainer().findAttributeDouble("CTRLON", Double.NaN);
        LatLonPointImpl lpt0 = new LatLonPointImpl(lat_check, lon_check);
        ProjectionPoint ppt0 = proj.latLonToProj(lpt0, new ProjectionPointImpl());
        VariableDS.Builder xstag = (VariableDS.Builder)this.rootGroup.findVariable("x_stag").orElseThrow(() -> new IllegalStateException("Must have x_stag Variable"));
        Variable xstagOrg = xstag.orgVar;
        int nxpts = (int)xstagOrg.getSize();
        ArrayFloat.D1 xstagData = (ArrayFloat.D1)xstagOrg.read();
        float center_x = xstagData.get(nxpts - 1);
        double false_easting = (double)(center_x / 2000.0f) - ppt0.getX() * 1000.0;
        VariableDS.Builder ystag = (VariableDS.Builder)this.rootGroup.findVariable("y_stag").orElseThrow(() -> new IllegalStateException("Must have y_stag Variable"));
        Variable ystagOrg = ystag.orgVar;
        int nypts = (int)ystagOrg.getSize();
        ArrayFloat.D1 ystagData = (ArrayFloat.D1)ystagOrg.read();
        float center_y = ystagData.get(nypts - 1);
        double false_northing = (double)(center_y / 2000.0f) - ppt0.getY() * 1000.0;
        log.debug("false easting/northing= {} {} ", (Object)false_easting, (Object)false_northing);
        double dx = this.rootGroup.getAttributeContainer().findAttributeDouble("DX", Double.NaN);
        double dy = this.rootGroup.getAttributeContainer().findAttributeDouble("DY", Double.NaN);
        double w = dx * (double)(nxpts - 1);
        double h2 = dy * (double)(nypts - 1);
        double startx = ppt0.getX() * 1000.0 - w / 2.0;
        double starty = ppt0.getY() * 1000.0 - h2 / 2.0;
        xstag.setAutoGen(startx, dx);
        ystag.setAutoGen(starty, dy);
    }

    @Override
    protected void makeCoordinateTransforms() {
        if (this.projCT != null) {
            CoordSystemBuilder.VarProcess vp = this.findVarProcess(this.projCT.getName(), null);
            vp.isCoordinateTransform = true;
            vp.ct = CoordinateTransform.builder().setPreBuilt(this.projCT);
        }
        super.makeCoordinateTransforms();
    }

    @Override
    protected AxisType getAxisType(VariableDS.Builder vb) {
        String vname = vb.shortName;
        if (vname.equalsIgnoreCase("x") || vname.equalsIgnoreCase("x_stag")) {
            return AxisType.GeoX;
        }
        if (vname.equalsIgnoreCase("lon")) {
            return AxisType.Lon;
        }
        if (vname.equalsIgnoreCase("y") || vname.equalsIgnoreCase("y_stag")) {
            return AxisType.GeoY;
        }
        if (vname.equalsIgnoreCase("lat")) {
            return AxisType.Lat;
        }
        if (vname.equalsIgnoreCase("z") || vname.equalsIgnoreCase("z_stag")) {
            return AxisType.GeoZ;
        }
        if (vname.equalsIgnoreCase("Z")) {
            return AxisType.Height;
        }
        if (vname.equalsIgnoreCase("time")) {
            return AxisType.Time;
        }
        String unit = vb.getUnits();
        if (unit != null) {
            if (SimpleUnit.isCompatible("millibar", unit)) {
                return AxisType.Pressure;
            }
            if (SimpleUnit.isCompatible("m", unit)) {
                return AxisType.Height;
            }
        }
        return null;
    }

    public String getZisPositive(CoordinateAxis v) {
        return "down";
    }

    private void makeCoordAxis(String axisName) throws IOException {
        String name = axisName + "_stag";
        if (!this.rootGroup.findVariable(name).isPresent()) {
            return;
        }
        VariableDS.Builder stagV = (VariableDS.Builder)this.rootGroup.findVariable(name).get();
        Array data_stag = stagV.orgVar.read();
        int n = (int)data_stag.getSize() - 1;
        DataType dt = DataType.getType(data_stag);
        Array data = Array.factory(dt, new int[]{n});
        Index stagIndex = data_stag.getIndex();
        Index dataIndex = data.getIndex();
        for (int i = 0; i < n; ++i) {
            double val = data_stag.getDouble(stagIndex.set(i)) + data_stag.getDouble(stagIndex.set(i + 1));
            data.setDouble(dataIndex.set(i), 0.5 * val);
        }
        DataType dtype = DataType.getType(data);
        String units = stagV.getAttributeContainer().findAttValueIgnoreCase("units", "m");
        CoordinateAxis.Builder cb = (CoordinateAxis.Builder)((CoordinateAxis1D.Builder)((CoordinateAxis1D.Builder)((CoordinateAxis1D.Builder)((CoordinateAxis1D.Builder)CoordinateAxis1D.builder().setName(axisName)).setDataType(dtype)).setDimensionsByName(axisName)).setUnits(units)).setDesc("synthesized non-staggered " + axisName + " coordinate");
        cb.setCachedData(data, true);
        this.datasetBuilder.replaceCoordinateAxis(this.rootGroup, cb);
    }

    public static class Factory
    implements CoordSystemBuilderFactory {
        @Override
        public String getConventionName() {
            return ADASConvention.CONVENTION_NAME;
        }

        @Override
        public CoordSystemBuilder open(NetcdfDataset.Builder datasetBuilder) {
            return new ADASConvention(datasetBuilder);
        }
    }
}

