/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.geoloc.vertical;

import java.io.IOException;
import java.util.List;
import ucar.ma2.Array;
import ucar.ma2.ArrayDouble;
import ucar.ma2.DataType;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.MAMath;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.unidata.geoloc.vertical.VerticalTransformImpl;
import ucar.unidata.util.Parameter;

public class VTfromExistingData
extends VerticalTransformImpl {
    public static final String existingDataField = "existingDataField";
    private Variable existingData;

    public VTfromExistingData(NetcdfFile ds, Dimension timeDim, List<Parameter> params) {
        super(timeDim);
        String vname = this.getParameterStringValue(params, existingDataField);
        this.existingData = ds.findVariable(vname);
        this.units = this.existingData.getUnitsString();
    }

    @Override
    public ArrayDouble.D3 getCoordinateArray(int timeIndex) throws IOException, InvalidRangeException {
        Array data = this.readArray(this.existingData, timeIndex);
        int[] shape = data.getShape();
        ArrayDouble.D3 ddata = (ArrayDouble.D3)Array.factory(DataType.DOUBLE, shape);
        MAMath.copyDouble(ddata, data);
        return ddata;
    }

    @Override
    public ArrayDouble.D1 getCoordinateArray1D(int timeIndex, int xIndex, int yIndex) throws IOException, InvalidRangeException {
        ArrayDouble.D3 ddata = this.getCoordinateArray(timeIndex);
        int[] origin = new int[]{0, yIndex, xIndex};
        int[] shape = new int[]{ddata.getShape()[0], 1, 1};
        return (ArrayDouble.D1)ddata.section(origin, shape).reduce();
    }
}

