"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ControlPolicyAttachment = exports.ControlPolicyAttachmentProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const resourcemanager_generated_1 = require("./resourcemanager.generated");
Object.defineProperty(exports, "ControlPolicyAttachmentProperty", { enumerable: true, get: function () { return resourcemanager_generated_1.RosControlPolicyAttachment; } });
/**
 * This class encapsulates and extends the ROS resource type `ALIYUN::ResourceManager::ControlPolicyAttachment`.
 * @Note This class may have some new functions to facilitate development, so it is recommended to use this class instead of `RosControlPolicyAttachment`for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/aliyun-resourcemanager-controlpolicyattachment
 */
class ControlPolicyAttachment extends ros.Resource {
    /**
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        this.scope = scope;
        this.id = id;
        this.props = props;
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        const rosControlPolicyAttachment = new resourcemanager_generated_1.RosControlPolicyAttachment(this, id, {
            targetId: props.targetId,
            policyId: props.policyId,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosControlPolicyAttachment;
        this.attrAttachDate = rosControlPolicyAttachment.attrAttachDate;
        this.attrDescription = rosControlPolicyAttachment.attrDescription;
        this.attrPolicyId = rosControlPolicyAttachment.attrPolicyId;
        this.attrPolicyName = rosControlPolicyAttachment.attrPolicyName;
        this.attrPolicyType = rosControlPolicyAttachment.attrPolicyType;
        this.attrTargetId = rosControlPolicyAttachment.attrTargetId;
    }
}
exports.ControlPolicyAttachment = ControlPolicyAttachment;
//# sourceMappingURL=data:application/json;base64,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