"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Folder = exports.FolderProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const resourcemanager_generated_1 = require("./resourcemanager.generated");
Object.defineProperty(exports, "FolderProperty", { enumerable: true, get: function () { return resourcemanager_generated_1.RosFolder; } });
/**
 * This class encapsulates and extends the ROS resource type `ALIYUN::ResourceManager::Folder`.
 * @Note This class may have some new functions to facilitate development, so it is recommended to use this class instead of `RosFolder`for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/aliyun-resourcemanager-folder
 */
class Folder extends ros.Resource {
    /**
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        this.scope = scope;
        this.id = id;
        this.props = props;
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        const rosFolder = new resourcemanager_generated_1.RosFolder(this, id, {
            folderName: props.folderName,
            parentFolderId: props.parentFolderId,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosFolder;
        this.attrFolderId = rosFolder.attrFolderId;
        this.attrFolderName = rosFolder.attrFolderName;
        this.attrParentFolderId = rosFolder.attrParentFolderId;
    }
}
exports.Folder = Folder;
//# sourceMappingURL=data:application/json;base64,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