"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PolicyAttachment = exports.PolicyAttachmentProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const resourcemanager_generated_1 = require("./resourcemanager.generated");
Object.defineProperty(exports, "PolicyAttachmentProperty", { enumerable: true, get: function () { return resourcemanager_generated_1.RosPolicyAttachment; } });
/**
 * This class encapsulates and extends the ROS resource type `ALIYUN::ResourceManager::PolicyAttachment`.
 * @Note This class may have some new functions to facilitate development, so it is recommended to use this class instead of `RosPolicyAttachment`for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/aliyun-resourcemanager-policyattachment
 */
class PolicyAttachment extends ros.Resource {
    /**
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        this.scope = scope;
        this.id = id;
        this.props = props;
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        const rosPolicyAttachment = new resourcemanager_generated_1.RosPolicyAttachment(this, id, {
            policyType: props.policyType,
            resourceGroupId: props.resourceGroupId,
            policyName: props.policyName,
            principalName: props.principalName,
            principalType: props.principalType,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosPolicyAttachment;
        this.attrAttachDate = rosPolicyAttachment.attrAttachDate;
        this.attrDescription = rosPolicyAttachment.attrDescription;
        this.attrPolicyName = rosPolicyAttachment.attrPolicyName;
        this.attrPolicyType = rosPolicyAttachment.attrPolicyType;
        this.attrPrincipalName = rosPolicyAttachment.attrPrincipalName;
        this.attrPrincipalType = rosPolicyAttachment.attrPrincipalType;
        this.attrResourceGroupId = rosPolicyAttachment.attrResourceGroupId;
    }
}
exports.PolicyAttachment = PolicyAttachment;
//# sourceMappingURL=data:application/json;base64,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