"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ResourceShare = exports.ResourceShareProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const resourcemanager_generated_1 = require("./resourcemanager.generated");
Object.defineProperty(exports, "ResourceShareProperty", { enumerable: true, get: function () { return resourcemanager_generated_1.RosResourceShare; } });
/**
 * This class encapsulates and extends the ROS resource type `ALIYUN::ResourceManager::ResourceShare`.
 * @Note This class may have some new functions to facilitate development, so it is recommended to use this class instead of `RosResourceShare`for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/aliyun-resourcemanager-resourceshare
 */
class ResourceShare extends ros.Resource {
    /**
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        this.scope = scope;
        this.id = id;
        this.props = props;
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        const rosResourceShare = new resourcemanager_generated_1.RosResourceShare(this, id, {
            resourceShareName: props.resourceShareName,
            allowExternalTargets: props.allowExternalTargets === undefined || props.allowExternalTargets === null ? false : props.allowExternalTargets,
            targets: props.targets,
            resources: props.resources,
            permissionNames: props.permissionNames,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosResourceShare;
        this.attrResourceShareId = rosResourceShare.attrResourceShareId;
    }
}
exports.ResourceShare = ResourceShare;
//# sourceMappingURL=data:application/json;base64,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