/******/ (() => { // webpackBootstrap
/******/ 	var __webpack_modules__ = ({

/***/ "./node_modules/@ant-design/colors/lib/generate.js":
/*!*********************************************************!*\
  !*** ./node_modules/@ant-design/colors/lib/generate.js ***!
  \*********************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
var tinycolor2_1 = __importDefault(__webpack_require__(/*! tinycolor2 */ "./node_modules/tinycolor2/tinycolor.js"));
var hueStep = 2; // 色相阶梯
var saturationStep = 16; // 饱和度阶梯，浅色部分
var saturationStep2 = 5; // 饱和度阶梯，深色部分
var brightnessStep1 = 5; // 亮度阶梯，浅色部分
var brightnessStep2 = 15; // 亮度阶梯，深色部分
var lightColorCount = 5; // 浅色数量，主色上
var darkColorCount = 4; // 深色数量，主色下
function getHue(hsv, i, light) {
    var hue;
    // 根据色相不同，色相转向不同
    if (Math.round(hsv.h) >= 60 && Math.round(hsv.h) <= 240) {
        hue = light ? Math.round(hsv.h) - hueStep * i : Math.round(hsv.h) + hueStep * i;
    }
    else {
        hue = light ? Math.round(hsv.h) + hueStep * i : Math.round(hsv.h) - hueStep * i;
    }
    if (hue < 0) {
        hue += 360;
    }
    else if (hue >= 360) {
        hue -= 360;
    }
    return hue;
}
function getSaturation(hsv, i, light) {
    // grey color don't change saturation
    if (hsv.h === 0 && hsv.s === 0) {
        return hsv.s;
    }
    var saturation;
    if (light) {
        saturation = Math.round(hsv.s * 100) - saturationStep * i;
    }
    else if (i === darkColorCount) {
        saturation = Math.round(hsv.s * 100) + saturationStep;
    }
    else {
        saturation = Math.round(hsv.s * 100) + saturationStep2 * i;
    }
    // 边界值修正
    if (saturation > 100) {
        saturation = 100;
    }
    // 第一格的 s 限制在 6-10 之间
    if (light && i === lightColorCount && saturation > 10) {
        saturation = 10;
    }
    if (saturation < 6) {
        saturation = 6;
    }
    return saturation;
}
function getValue(hsv, i, light) {
    if (light) {
        return Math.round(hsv.v * 100) + brightnessStep1 * i;
    }
    return Math.round(hsv.v * 100) - brightnessStep2 * i;
}
function generate(color) {
    var patterns = [];
    var pColor = tinycolor2_1.default(color);
    for (var i = lightColorCount; i > 0; i -= 1) {
        var hsv = pColor.toHsv();
        var colorString = tinycolor2_1.default({
            h: getHue(hsv, i, true),
            s: getSaturation(hsv, i, true),
            v: getValue(hsv, i, true),
        }).toHexString();
        patterns.push(colorString);
    }
    patterns.push(pColor.toHexString());
    for (var i = 1; i <= darkColorCount; i += 1) {
        var hsv = pColor.toHsv();
        var colorString = tinycolor2_1.default({
            h: getHue(hsv, i),
            s: getSaturation(hsv, i),
            v: getValue(hsv, i),
        }).toHexString();
        patterns.push(colorString);
    }
    return patterns;
}
exports["default"] = generate;


/***/ }),

/***/ "./node_modules/@ant-design/colors/lib/index.js":
/*!******************************************************!*\
  !*** ./node_modules/@ant-design/colors/lib/index.js ***!
  \******************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
var generate_1 = __importDefault(__webpack_require__(/*! ./generate */ "./node_modules/@ant-design/colors/lib/generate.js"));
exports.generate = generate_1.default;
var presetPrimaryColors = {
    red: '#F5222D',
    volcano: '#FA541C',
    orange: '#FA8C16',
    gold: '#FAAD14',
    yellow: '#FADB14',
    lime: '#A0D911',
    green: '#52C41A',
    cyan: '#13C2C2',
    blue: '#1890FF',
    geekblue: '#2F54EB',
    purple: '#722ED1',
    magenta: '#EB2F96',
    grey: '#666666',
};
exports.presetPrimaryColors = presetPrimaryColors;
var presetPalettes = {};
exports.presetPalettes = presetPalettes;
Object.keys(presetPrimaryColors).forEach(function (key) {
    presetPalettes[key] = generate_1.default(presetPrimaryColors[key]);
    presetPalettes[key].primary = presetPalettes[key][5];
});
var red = presetPalettes.red;
exports.red = red;
var volcano = presetPalettes.volcano;
exports.volcano = volcano;
var gold = presetPalettes.gold;
exports.gold = gold;
var orange = presetPalettes.orange;
exports.orange = orange;
var yellow = presetPalettes.yellow;
exports.yellow = yellow;
var lime = presetPalettes.lime;
exports.lime = lime;
var green = presetPalettes.green;
exports.green = green;
var cyan = presetPalettes.cyan;
exports.cyan = cyan;
var blue = presetPalettes.blue;
exports.blue = blue;
var geekblue = presetPalettes.geekblue;
exports.geekblue = geekblue;
var purple = presetPalettes.purple;
exports.purple = purple;
var magenta = presetPalettes.magenta;
exports.magenta = magenta;
var grey = presetPalettes.grey;
exports.grey = grey;


/***/ }),

/***/ "./node_modules/@ant-design/icons-svg/es/asn/LoadingOutlined.js":
/*!**********************************************************************!*\
  !*** ./node_modules/@ant-design/icons-svg/es/asn/LoadingOutlined.js ***!
  \**********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
// This icon file is generated automatically.
// tslint:disable
var LoadingOutlined = { "name": "loading", "theme": "outlined", "icon": { "tag": "svg", "attrs": { "viewBox": "0 0 1024 1024", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M988 548c-19.9 0-36-16.1-36-36 0-59.4-11.6-117-34.6-171.3a440.45 440.45 0 00-94.3-139.9 437.71 437.71 0 00-139.9-94.3C629 83.6 571.4 72 512 72c-19.9 0-36-16.1-36-36s16.1-36 36-36c69.1 0 136.2 13.5 199.3 40.3C772.3 66 827 103 874 150c47 47 83.9 101.8 109.7 162.7 26.7 63.1 40.2 130.2 40.2 199.3.1 19.9-16 36-35.9 36z" } }] } };
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (LoadingOutlined);


/***/ }),

/***/ "./node_modules/@ant-design/icons-svg/es/asn/PauseCircleOutlined.js":
/*!**************************************************************************!*\
  !*** ./node_modules/@ant-design/icons-svg/es/asn/PauseCircleOutlined.js ***!
  \**************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
// This icon file is generated automatically.
// tslint:disable
var PauseCircleOutlined = { "name": "pause-circle", "theme": "outlined", "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M512 64C264.6 64 64 264.6 64 512s200.6 448 448 448 448-200.6 448-448S759.4 64 512 64zm0 820c-205.4 0-372-166.6-372-372s166.6-372 372-372 372 166.6 372 372-166.6 372-372 372zm-88-532h-48c-4.4 0-8 3.6-8 8v304c0 4.4 3.6 8 8 8h48c4.4 0 8-3.6 8-8V360c0-4.4-3.6-8-8-8zm224 0h-48c-4.4 0-8 3.6-8 8v304c0 4.4 3.6 8 8 8h48c4.4 0 8-3.6 8-8V360c0-4.4-3.6-8-8-8z" } }] } };
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PauseCircleOutlined);


/***/ }),

/***/ "./node_modules/@ant-design/icons-svg/es/asn/PlayCircleOutlined.js":
/*!*************************************************************************!*\
  !*** ./node_modules/@ant-design/icons-svg/es/asn/PlayCircleOutlined.js ***!
  \*************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
// This icon file is generated automatically.
// tslint:disable
var PlayCircleOutlined = { "name": "play-circle", "theme": "outlined", "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M512 64C264.6 64 64 264.6 64 512s200.6 448 448 448 448-200.6 448-448S759.4 64 512 64zm0 820c-205.4 0-372-166.6-372-372s166.6-372 372-372 372 166.6 372 372-166.6 372-372 372z" } }, { "tag": "path", "attrs": { "d": "M719.4 499.1l-296.1-215A15.9 15.9 0 00398 297v430c0 13.1 14.8 20.5 25.3 12.9l296.1-215a15.9 15.9 0 000-25.8zm-257.6 134V390.9L628.5 512 461.8 633.1z" } }] } };
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PlayCircleOutlined);


/***/ }),

/***/ "./node_modules/@ant-design/icons-svg/lib/asn/BarsOutlined.js":
/*!********************************************************************!*\
  !*** ./node_modules/@ant-design/icons-svg/lib/asn/BarsOutlined.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";

// This icon file is generated automatically.
// tslint:disable
Object.defineProperty(exports, "__esModule", ({ value: true }));
var BarsOutlined = { "name": "bars", "theme": "outlined", "icon": { "tag": "svg", "attrs": { "viewBox": "0 0 1024 1024", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M912 192H328c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h584c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm0 284H328c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h584c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm0 284H328c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h584c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zM104 228a56 56 0 10112 0 56 56 0 10-112 0zm0 284a56 56 0 10112 0 56 56 0 10-112 0zm0 284a56 56 0 10112 0 56 56 0 10-112 0z" } }] } };
exports["default"] = BarsOutlined;


/***/ }),

/***/ "./node_modules/@ant-design/icons-svg/lib/asn/CaretDownFilled.js":
/*!***********************************************************************!*\
  !*** ./node_modules/@ant-design/icons-svg/lib/asn/CaretDownFilled.js ***!
  \***********************************************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";

// This icon file is generated automatically.
// tslint:disable
Object.defineProperty(exports, "__esModule", ({ value: true }));
var CaretDownFilled = { "name": "caret-down", "theme": "filled", "icon": { "tag": "svg", "attrs": { "viewBox": "0 0 1024 1024", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M840.4 300H183.6c-19.7 0-30.7 20.8-18.5 35l328.4 380.8c9.4 10.9 27.5 10.9 37 0L858.9 335c12.2-14.2 1.2-35-18.5-35z" } }] } };
exports["default"] = CaretDownFilled;


/***/ }),

/***/ "./node_modules/@ant-design/icons-svg/lib/asn/CheckOutlined.js":
/*!*********************************************************************!*\
  !*** ./node_modules/@ant-design/icons-svg/lib/asn/CheckOutlined.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";

// This icon file is generated automatically.
// tslint:disable
Object.defineProperty(exports, "__esModule", ({ value: true }));
var CheckOutlined = { "name": "check", "theme": "outlined", "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M912 190h-69.9c-9.8 0-19.1 4.5-25.1 12.2L404.7 724.5 207 474a32 32 0 00-25.1-12.2H112c-6.7 0-10.4 7.7-6.3 12.9l273.9 347c12.8 16.2 37.4 16.2 50.3 0l488.4-618.9c4.1-5.1.4-12.8-6.3-12.8z" } }] } };
exports["default"] = CheckOutlined;


/***/ }),

/***/ "./node_modules/@ant-design/icons-svg/lib/asn/CloseCircleFilled.js":
/*!*************************************************************************!*\
  !*** ./node_modules/@ant-design/icons-svg/lib/asn/CloseCircleFilled.js ***!
  \*************************************************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";

// This icon file is generated automatically.
// tslint:disable
Object.defineProperty(exports, "__esModule", ({ value: true }));
var CloseCircleFilled = { "name": "close-circle", "theme": "filled", "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M512 64C264.6 64 64 264.6 64 512s200.6 448 448 448 448-200.6 448-448S759.4 64 512 64zm165.4 618.2l-66-.3L512 563.4l-99.3 118.4-66.1.3c-4.4 0-8-3.5-8-8 0-1.9.7-3.7 1.9-5.2l130.1-155L340.5 359a8.32 8.32 0 01-1.9-5.2c0-4.4 3.6-8 8-8l66.1.3L512 464.6l99.3-118.4 66-.3c4.4 0 8 3.5 8 8 0 1.9-.7 3.7-1.9 5.2L553.5 514l130 155c1.2 1.5 1.9 3.3 1.9 5.2 0 4.4-3.6 8-8 8z" } }] } };
exports["default"] = CloseCircleFilled;


/***/ }),

/***/ "./node_modules/@ant-design/icons-svg/lib/asn/CloseOutlined.js":
/*!*********************************************************************!*\
  !*** ./node_modules/@ant-design/icons-svg/lib/asn/CloseOutlined.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";

// This icon file is generated automatically.
// tslint:disable
Object.defineProperty(exports, "__esModule", ({ value: true }));
var CloseOutlined = { "name": "close", "theme": "outlined", "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M563.8 512l262.5-312.9c4.4-5.2.7-13.1-6.1-13.1h-79.8c-4.7 0-9.2 2.1-12.3 5.7L511.6 449.8 295.1 191.7c-3-3.6-7.5-5.7-12.3-5.7H203c-6.8 0-10.5 7.9-6.1 13.1L459.4 512 196.9 824.9A7.95 7.95 0 00203 838h79.8c4.7 0 9.2-2.1 12.3-5.7l216.5-258.1 216.5 258.1c3 3.6 7.5 5.7 12.3 5.7h79.8c6.8 0 10.5-7.9 6.1-13.1L563.8 512z" } }] } };
exports["default"] = CloseOutlined;


/***/ }),

/***/ "./node_modules/@ant-design/icons-svg/lib/asn/DownOutlined.js":
/*!********************************************************************!*\
  !*** ./node_modules/@ant-design/icons-svg/lib/asn/DownOutlined.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";

// This icon file is generated automatically.
// tslint:disable
Object.defineProperty(exports, "__esModule", ({ value: true }));
var DownOutlined = { "name": "down", "theme": "outlined", "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M884 256h-75c-5.1 0-9.9 2.5-12.9 6.6L512 654.2 227.9 262.6c-3-4.1-7.8-6.6-12.9-6.6h-75c-6.5 0-10.3 7.4-6.5 12.7l352.6 486.1c12.8 17.6 39 17.6 51.7 0l352.6-486.1c3.9-5.3.1-12.7-6.4-12.7z" } }] } };
exports["default"] = DownOutlined;


/***/ }),

/***/ "./node_modules/@ant-design/icons-svg/lib/asn/FileOutlined.js":
/*!********************************************************************!*\
  !*** ./node_modules/@ant-design/icons-svg/lib/asn/FileOutlined.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";

// This icon file is generated automatically.
// tslint:disable
Object.defineProperty(exports, "__esModule", ({ value: true }));
var FileOutlined = { "name": "file", "theme": "outlined", "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M854.6 288.6L639.4 73.4c-6-6-14.1-9.4-22.6-9.4H192c-17.7 0-32 14.3-32 32v832c0 17.7 14.3 32 32 32h640c17.7 0 32-14.3 32-32V311.3c0-8.5-3.4-16.7-9.4-22.7zM790.2 326H602V137.8L790.2 326zm1.8 562H232V136h302v216a42 42 0 0042 42h216v494z" } }] } };
exports["default"] = FileOutlined;


/***/ }),

/***/ "./node_modules/@ant-design/icons-svg/lib/asn/FolderOpenOutlined.js":
/*!**************************************************************************!*\
  !*** ./node_modules/@ant-design/icons-svg/lib/asn/FolderOpenOutlined.js ***!
  \**************************************************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";

// This icon file is generated automatically.
// tslint:disable
Object.defineProperty(exports, "__esModule", ({ value: true }));
var FolderOpenOutlined = { "name": "folder-open", "theme": "outlined", "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M928 444H820V330.4c0-17.7-14.3-32-32-32H473L355.7 186.2a8.15 8.15 0 00-5.5-2.2H96c-17.7 0-32 14.3-32 32v592c0 17.7 14.3 32 32 32h698c13 0 24.8-7.9 29.7-20l134-332c1.5-3.8 2.3-7.9 2.3-12 0-17.7-14.3-32-32-32zM136 256h188.5l119.6 114.4H748V444H238c-13 0-24.8 7.9-29.7 20L136 643.2V256zm635.3 512H159l103.3-256h612.4L771.3 768z" } }] } };
exports["default"] = FolderOpenOutlined;


/***/ }),

/***/ "./node_modules/@ant-design/icons-svg/lib/asn/FolderOutlined.js":
/*!**********************************************************************!*\
  !*** ./node_modules/@ant-design/icons-svg/lib/asn/FolderOutlined.js ***!
  \**********************************************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";

// This icon file is generated automatically.
// tslint:disable
Object.defineProperty(exports, "__esModule", ({ value: true }));
var FolderOutlined = { "name": "folder", "theme": "outlined", "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M880 298.4H521L403.7 186.2a8.15 8.15 0 00-5.5-2.2H144c-17.7 0-32 14.3-32 32v592c0 17.7 14.3 32 32 32h736c17.7 0 32-14.3 32-32V330.4c0-17.7-14.3-32-32-32zM840 768H184V256h188.5l119.6 114.4H840V768z" } }] } };
exports["default"] = FolderOutlined;


/***/ }),

/***/ "./node_modules/@ant-design/icons-svg/lib/asn/LeftOutlined.js":
/*!********************************************************************!*\
  !*** ./node_modules/@ant-design/icons-svg/lib/asn/LeftOutlined.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";

// This icon file is generated automatically.
// tslint:disable
Object.defineProperty(exports, "__esModule", ({ value: true }));
var LeftOutlined = { "name": "left", "theme": "outlined", "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M724 218.3V141c0-6.7-7.7-10.4-12.9-6.3L260.3 486.8a31.86 31.86 0 000 50.3l450.8 352.1c5.3 4.1 12.9.4 12.9-6.3v-77.3c0-4.9-2.3-9.6-6.1-12.6l-360-281 360-281.1c3.8-3 6.1-7.7 6.1-12.6z" } }] } };
exports["default"] = LeftOutlined;


/***/ }),

/***/ "./node_modules/@ant-design/icons-svg/lib/asn/LoadingOutlined.js":
/*!***********************************************************************!*\
  !*** ./node_modules/@ant-design/icons-svg/lib/asn/LoadingOutlined.js ***!
  \***********************************************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";

// This icon file is generated automatically.
// tslint:disable
Object.defineProperty(exports, "__esModule", ({ value: true }));
var LoadingOutlined = { "name": "loading", "theme": "outlined", "icon": { "tag": "svg", "attrs": { "viewBox": "0 0 1024 1024", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M988 548c-19.9 0-36-16.1-36-36 0-59.4-11.6-117-34.6-171.3a440.45 440.45 0 00-94.3-139.9 437.71 437.71 0 00-139.9-94.3C629 83.6 571.4 72 512 72c-19.9 0-36-16.1-36-36s16.1-36 36-36c69.1 0 136.2 13.5 199.3 40.3C772.3 66 827 103 874 150c47 47 83.9 101.8 109.7 162.7 26.7 63.1 40.2 130.2 40.2 199.3.1 19.9-16 36-35.9 36z" } }] } };
exports["default"] = LoadingOutlined;


/***/ }),

/***/ "./node_modules/@ant-design/icons-svg/lib/asn/MinusSquareOutlined.js":
/*!***************************************************************************!*\
  !*** ./node_modules/@ant-design/icons-svg/lib/asn/MinusSquareOutlined.js ***!
  \***************************************************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";

// This icon file is generated automatically.
// tslint:disable
Object.defineProperty(exports, "__esModule", ({ value: true }));
var MinusSquareOutlined = { "name": "minus-square", "theme": "outlined", "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M328 544h368c4.4 0 8-3.6 8-8v-48c0-4.4-3.6-8-8-8H328c-4.4 0-8 3.6-8 8v48c0 4.4 3.6 8 8 8z" } }, { "tag": "path", "attrs": { "d": "M880 112H144c-17.7 0-32 14.3-32 32v736c0 17.7 14.3 32 32 32h736c17.7 0 32-14.3 32-32V144c0-17.7-14.3-32-32-32zm-40 728H184V184h656v656z" } }] } };
exports["default"] = MinusSquareOutlined;


/***/ }),

/***/ "./node_modules/@ant-design/icons-svg/lib/asn/PlusSquareOutlined.js":
/*!**************************************************************************!*\
  !*** ./node_modules/@ant-design/icons-svg/lib/asn/PlusSquareOutlined.js ***!
  \**************************************************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";

// This icon file is generated automatically.
// tslint:disable
Object.defineProperty(exports, "__esModule", ({ value: true }));
var PlusSquareOutlined = { "name": "plus-square", "theme": "outlined", "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M328 544h152v152c0 4.4 3.6 8 8 8h48c4.4 0 8-3.6 8-8V544h152c4.4 0 8-3.6 8-8v-48c0-4.4-3.6-8-8-8H544V328c0-4.4-3.6-8-8-8h-48c-4.4 0-8 3.6-8 8v152H328c-4.4 0-8 3.6-8 8v48c0 4.4 3.6 8 8 8z" } }, { "tag": "path", "attrs": { "d": "M880 112H144c-17.7 0-32 14.3-32 32v736c0 17.7 14.3 32 32 32h736c17.7 0 32-14.3 32-32V144c0-17.7-14.3-32-32-32zm-40 728H184V184h656v656z" } }] } };
exports["default"] = PlusSquareOutlined;


/***/ }),

/***/ "./node_modules/@ant-design/icons-svg/lib/asn/RightOutlined.js":
/*!*********************************************************************!*\
  !*** ./node_modules/@ant-design/icons-svg/lib/asn/RightOutlined.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";

// This icon file is generated automatically.
// tslint:disable
Object.defineProperty(exports, "__esModule", ({ value: true }));
var RightOutlined = { "name": "right", "theme": "outlined", "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M765.7 486.8L314.9 134.7A7.97 7.97 0 00302 141v77.3c0 4.9 2.3 9.6 6.1 12.6l360 281.1-360 281.1c-3.9 3-6.1 7.7-6.1 12.6V883c0 6.7 7.7 10.4 12.9 6.3l450.8-352.1a31.96 31.96 0 000-50.4z" } }] } };
exports["default"] = RightOutlined;


/***/ }),

/***/ "./node_modules/@ant-design/icons-svg/lib/asn/SearchOutlined.js":
/*!**********************************************************************!*\
  !*** ./node_modules/@ant-design/icons-svg/lib/asn/SearchOutlined.js ***!
  \**********************************************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";

// This icon file is generated automatically.
// tslint:disable
Object.defineProperty(exports, "__esModule", ({ value: true }));
var SearchOutlined = { "name": "search", "theme": "outlined", "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M909.6 854.5L649.9 594.8C690.2 542.7 712 479 712 412c0-80.2-31.3-155.4-87.9-212.1-56.6-56.7-132-87.9-212.1-87.9s-155.5 31.3-212.1 87.9C143.2 256.5 112 331.8 112 412c0 80.1 31.3 155.5 87.9 212.1C256.5 680.8 331.8 712 412 712c67 0 130.6-21.8 182.7-62l259.7 259.6a8.2 8.2 0 0011.6 0l43.6-43.5a8.2 8.2 0 000-11.6zM570.4 570.4C528 612.7 471.8 636 412 636s-116-23.3-158.4-65.6C211.3 528 188 471.8 188 412s23.3-116.1 65.6-158.4C296 211.3 352.2 188 412 188s116.1 23.2 158.4 65.6S636 352.2 636 412s-23.3 116.1-65.6 158.4z" } }] } };
exports["default"] = SearchOutlined;


/***/ }),

/***/ "./node_modules/@ant-design/icons/BarsOutlined.js":
/*!********************************************************!*\
  !*** ./node_modules/@ant-design/icons/BarsOutlined.js ***!
  \********************************************************/
/***/ ((module, exports, __webpack_require__) => {

"use strict";

  Object.defineProperty(exports, "__esModule", ({
    value: true
  }));
  exports["default"] = void 0;
  
  var _BarsOutlined = _interopRequireDefault(__webpack_require__(/*! ./lib/icons/BarsOutlined */ "./node_modules/@ant-design/icons/lib/icons/BarsOutlined.js"));
  
  function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }
  
  var _default = _BarsOutlined;
  exports["default"] = _default;
  module.exports = _default;

/***/ }),

/***/ "./node_modules/@ant-design/icons/CaretDownFilled.js":
/*!***********************************************************!*\
  !*** ./node_modules/@ant-design/icons/CaretDownFilled.js ***!
  \***********************************************************/
/***/ ((module, exports, __webpack_require__) => {

"use strict";

  Object.defineProperty(exports, "__esModule", ({
    value: true
  }));
  exports["default"] = void 0;
  
  var _CaretDownFilled = _interopRequireDefault(__webpack_require__(/*! ./lib/icons/CaretDownFilled */ "./node_modules/@ant-design/icons/lib/icons/CaretDownFilled.js"));
  
  function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }
  
  var _default = _CaretDownFilled;
  exports["default"] = _default;
  module.exports = _default;

/***/ }),

/***/ "./node_modules/@ant-design/icons/CheckOutlined.js":
/*!*********************************************************!*\
  !*** ./node_modules/@ant-design/icons/CheckOutlined.js ***!
  \*********************************************************/
/***/ ((module, exports, __webpack_require__) => {

"use strict";

  Object.defineProperty(exports, "__esModule", ({
    value: true
  }));
  exports["default"] = void 0;
  
  var _CheckOutlined = _interopRequireDefault(__webpack_require__(/*! ./lib/icons/CheckOutlined */ "./node_modules/@ant-design/icons/lib/icons/CheckOutlined.js"));
  
  function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }
  
  var _default = _CheckOutlined;
  exports["default"] = _default;
  module.exports = _default;

/***/ }),

/***/ "./node_modules/@ant-design/icons/CloseCircleFilled.js":
/*!*************************************************************!*\
  !*** ./node_modules/@ant-design/icons/CloseCircleFilled.js ***!
  \*************************************************************/
/***/ ((module, exports, __webpack_require__) => {

"use strict";

  Object.defineProperty(exports, "__esModule", ({
    value: true
  }));
  exports["default"] = void 0;
  
  var _CloseCircleFilled = _interopRequireDefault(__webpack_require__(/*! ./lib/icons/CloseCircleFilled */ "./node_modules/@ant-design/icons/lib/icons/CloseCircleFilled.js"));
  
  function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }
  
  var _default = _CloseCircleFilled;
  exports["default"] = _default;
  module.exports = _default;

/***/ }),

/***/ "./node_modules/@ant-design/icons/CloseOutlined.js":
/*!*********************************************************!*\
  !*** ./node_modules/@ant-design/icons/CloseOutlined.js ***!
  \*********************************************************/
/***/ ((module, exports, __webpack_require__) => {

"use strict";

  Object.defineProperty(exports, "__esModule", ({
    value: true
  }));
  exports["default"] = void 0;
  
  var _CloseOutlined = _interopRequireDefault(__webpack_require__(/*! ./lib/icons/CloseOutlined */ "./node_modules/@ant-design/icons/lib/icons/CloseOutlined.js"));
  
  function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }
  
  var _default = _CloseOutlined;
  exports["default"] = _default;
  module.exports = _default;

/***/ }),

/***/ "./node_modules/@ant-design/icons/DownOutlined.js":
/*!********************************************************!*\
  !*** ./node_modules/@ant-design/icons/DownOutlined.js ***!
  \********************************************************/
/***/ ((module, exports, __webpack_require__) => {

"use strict";

  Object.defineProperty(exports, "__esModule", ({
    value: true
  }));
  exports["default"] = void 0;
  
  var _DownOutlined = _interopRequireDefault(__webpack_require__(/*! ./lib/icons/DownOutlined */ "./node_modules/@ant-design/icons/lib/icons/DownOutlined.js"));
  
  function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }
  
  var _default = _DownOutlined;
  exports["default"] = _default;
  module.exports = _default;

/***/ }),

/***/ "./node_modules/@ant-design/icons/FileOutlined.js":
/*!********************************************************!*\
  !*** ./node_modules/@ant-design/icons/FileOutlined.js ***!
  \********************************************************/
/***/ ((module, exports, __webpack_require__) => {

"use strict";

  Object.defineProperty(exports, "__esModule", ({
    value: true
  }));
  exports["default"] = void 0;
  
  var _FileOutlined = _interopRequireDefault(__webpack_require__(/*! ./lib/icons/FileOutlined */ "./node_modules/@ant-design/icons/lib/icons/FileOutlined.js"));
  
  function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }
  
  var _default = _FileOutlined;
  exports["default"] = _default;
  module.exports = _default;

/***/ }),

/***/ "./node_modules/@ant-design/icons/FolderOpenOutlined.js":
/*!**************************************************************!*\
  !*** ./node_modules/@ant-design/icons/FolderOpenOutlined.js ***!
  \**************************************************************/
/***/ ((module, exports, __webpack_require__) => {

"use strict";

  Object.defineProperty(exports, "__esModule", ({
    value: true
  }));
  exports["default"] = void 0;
  
  var _FolderOpenOutlined = _interopRequireDefault(__webpack_require__(/*! ./lib/icons/FolderOpenOutlined */ "./node_modules/@ant-design/icons/lib/icons/FolderOpenOutlined.js"));
  
  function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }
  
  var _default = _FolderOpenOutlined;
  exports["default"] = _default;
  module.exports = _default;

/***/ }),

/***/ "./node_modules/@ant-design/icons/FolderOutlined.js":
/*!**********************************************************!*\
  !*** ./node_modules/@ant-design/icons/FolderOutlined.js ***!
  \**********************************************************/
/***/ ((module, exports, __webpack_require__) => {

"use strict";

  Object.defineProperty(exports, "__esModule", ({
    value: true
  }));
  exports["default"] = void 0;
  
  var _FolderOutlined = _interopRequireDefault(__webpack_require__(/*! ./lib/icons/FolderOutlined */ "./node_modules/@ant-design/icons/lib/icons/FolderOutlined.js"));
  
  function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }
  
  var _default = _FolderOutlined;
  exports["default"] = _default;
  module.exports = _default;

/***/ }),

/***/ "./node_modules/@ant-design/icons/LeftOutlined.js":
/*!********************************************************!*\
  !*** ./node_modules/@ant-design/icons/LeftOutlined.js ***!
  \********************************************************/
/***/ ((module, exports, __webpack_require__) => {

"use strict";

  Object.defineProperty(exports, "__esModule", ({
    value: true
  }));
  exports["default"] = void 0;
  
  var _LeftOutlined = _interopRequireDefault(__webpack_require__(/*! ./lib/icons/LeftOutlined */ "./node_modules/@ant-design/icons/lib/icons/LeftOutlined.js"));
  
  function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }
  
  var _default = _LeftOutlined;
  exports["default"] = _default;
  module.exports = _default;

/***/ }),

/***/ "./node_modules/@ant-design/icons/LoadingOutlined.js":
/*!***********************************************************!*\
  !*** ./node_modules/@ant-design/icons/LoadingOutlined.js ***!
  \***********************************************************/
/***/ ((module, exports, __webpack_require__) => {

"use strict";

  Object.defineProperty(exports, "__esModule", ({
    value: true
  }));
  exports["default"] = void 0;
  
  var _LoadingOutlined = _interopRequireDefault(__webpack_require__(/*! ./lib/icons/LoadingOutlined */ "./node_modules/@ant-design/icons/lib/icons/LoadingOutlined.js"));
  
  function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }
  
  var _default = _LoadingOutlined;
  exports["default"] = _default;
  module.exports = _default;

/***/ }),

/***/ "./node_modules/@ant-design/icons/MinusSquareOutlined.js":
/*!***************************************************************!*\
  !*** ./node_modules/@ant-design/icons/MinusSquareOutlined.js ***!
  \***************************************************************/
/***/ ((module, exports, __webpack_require__) => {

"use strict";

  Object.defineProperty(exports, "__esModule", ({
    value: true
  }));
  exports["default"] = void 0;
  
  var _MinusSquareOutlined = _interopRequireDefault(__webpack_require__(/*! ./lib/icons/MinusSquareOutlined */ "./node_modules/@ant-design/icons/lib/icons/MinusSquareOutlined.js"));
  
  function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }
  
  var _default = _MinusSquareOutlined;
  exports["default"] = _default;
  module.exports = _default;

/***/ }),

/***/ "./node_modules/@ant-design/icons/PlusSquareOutlined.js":
/*!**************************************************************!*\
  !*** ./node_modules/@ant-design/icons/PlusSquareOutlined.js ***!
  \**************************************************************/
/***/ ((module, exports, __webpack_require__) => {

"use strict";

  Object.defineProperty(exports, "__esModule", ({
    value: true
  }));
  exports["default"] = void 0;
  
  var _PlusSquareOutlined = _interopRequireDefault(__webpack_require__(/*! ./lib/icons/PlusSquareOutlined */ "./node_modules/@ant-design/icons/lib/icons/PlusSquareOutlined.js"));
  
  function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }
  
  var _default = _PlusSquareOutlined;
  exports["default"] = _default;
  module.exports = _default;

/***/ }),

/***/ "./node_modules/@ant-design/icons/RightOutlined.js":
/*!*********************************************************!*\
  !*** ./node_modules/@ant-design/icons/RightOutlined.js ***!
  \*********************************************************/
/***/ ((module, exports, __webpack_require__) => {

"use strict";

  Object.defineProperty(exports, "__esModule", ({
    value: true
  }));
  exports["default"] = void 0;
  
  var _RightOutlined = _interopRequireDefault(__webpack_require__(/*! ./lib/icons/RightOutlined */ "./node_modules/@ant-design/icons/lib/icons/RightOutlined.js"));
  
  function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }
  
  var _default = _RightOutlined;
  exports["default"] = _default;
  module.exports = _default;

/***/ }),

/***/ "./node_modules/@ant-design/icons/SearchOutlined.js":
/*!**********************************************************!*\
  !*** ./node_modules/@ant-design/icons/SearchOutlined.js ***!
  \**********************************************************/
/***/ ((module, exports, __webpack_require__) => {

"use strict";

  Object.defineProperty(exports, "__esModule", ({
    value: true
  }));
  exports["default"] = void 0;
  
  var _SearchOutlined = _interopRequireDefault(__webpack_require__(/*! ./lib/icons/SearchOutlined */ "./node_modules/@ant-design/icons/lib/icons/SearchOutlined.js"));
  
  function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }
  
  var _default = _SearchOutlined;
  exports["default"] = _default;
  module.exports = _default;

/***/ }),

/***/ "./node_modules/@ant-design/icons/es/components/AntdIcon.js":
/*!******************************************************************!*\
  !*** ./node_modules/@ant-design/icons/es/components/AntdIcon.js ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! classnames */ "./node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _IconBase__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./IconBase */ "./node_modules/@ant-design/icons/es/components/IconBase.js");
/* harmony import */ var _twoTonePrimaryColor__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./twoTonePrimaryColor */ "./node_modules/@ant-design/icons/es/components/twoTonePrimaryColor.js");
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../utils */ "./node_modules/@ant-design/icons/es/utils.js");
function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(n); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }





 // Initial setting
// should move it to antd main repo?

(0,_twoTonePrimaryColor__WEBPACK_IMPORTED_MODULE_2__.setTwoToneColor)('#1890ff');
var Icon = react__WEBPACK_IMPORTED_MODULE_0__.forwardRef(function (props, ref) {
  var className = props.className,
      icon = props.icon,
      spin = props.spin,
      rotate = props.rotate,
      tabIndex = props.tabIndex,
      onClick = props.onClick,
      twoToneColor = props.twoToneColor,
      restProps = _objectWithoutProperties(props, ["className", "icon", "spin", "rotate", "tabIndex", "onClick", "twoToneColor"]);

  var classString = classnames__WEBPACK_IMPORTED_MODULE_1___default()('anticon', _defineProperty({}, "anticon-".concat(icon.name), Boolean(icon.name)), className);
  var svgClassString = classnames__WEBPACK_IMPORTED_MODULE_1___default()({
    'anticon-spin': !!spin || icon.name === 'loading'
  });
  var iconTabIndex = tabIndex;

  if (iconTabIndex === undefined && onClick) {
    iconTabIndex = -1;
  }

  var svgStyle = rotate ? {
    msTransform: "rotate(".concat(rotate, "deg)"),
    transform: "rotate(".concat(rotate, "deg)")
  } : undefined;

  var _normalizeTwoToneColo = (0,_utils__WEBPACK_IMPORTED_MODULE_3__.normalizeTwoToneColors)(twoToneColor),
      _normalizeTwoToneColo2 = _slicedToArray(_normalizeTwoToneColo, 2),
      primaryColor = _normalizeTwoToneColo2[0],
      secondaryColor = _normalizeTwoToneColo2[1];

  return react__WEBPACK_IMPORTED_MODULE_0__.createElement("span", Object.assign({
    role: "img",
    "aria-label": icon.name
  }, restProps, {
    ref: ref,
    tabIndex: iconTabIndex,
    onClick: onClick,
    className: classString
  }), react__WEBPACK_IMPORTED_MODULE_0__.createElement(_IconBase__WEBPACK_IMPORTED_MODULE_4__["default"], {
    className: svgClassString,
    icon: icon,
    primaryColor: primaryColor,
    secondaryColor: secondaryColor,
    style: svgStyle
  }));
});
Icon.displayName = 'AntdIcon';
Icon.getTwoToneColor = _twoTonePrimaryColor__WEBPACK_IMPORTED_MODULE_2__.getTwoToneColor;
Icon.setTwoToneColor = _twoTonePrimaryColor__WEBPACK_IMPORTED_MODULE_2__.setTwoToneColor;
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Icon);

/***/ }),

/***/ "./node_modules/@ant-design/icons/es/components/IconBase.js":
/*!******************************************************************!*\
  !*** ./node_modules/@ant-design/icons/es/components/IconBase.js ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../utils */ "./node_modules/@ant-design/icons/es/utils.js");
function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }


var twoToneColorPalette = {
  primaryColor: '#333',
  secondaryColor: '#E6E6E6',
  calculated: false
};

function setTwoToneColors(_ref) {
  var primaryColor = _ref.primaryColor,
      secondaryColor = _ref.secondaryColor;
  twoToneColorPalette.primaryColor = primaryColor;
  twoToneColorPalette.secondaryColor = secondaryColor || (0,_utils__WEBPACK_IMPORTED_MODULE_0__.getSecondaryColor)(primaryColor);
  twoToneColorPalette.calculated = !!secondaryColor;
}

function getTwoToneColors() {
  return _objectSpread({}, twoToneColorPalette);
}

var IconBase = function IconBase(props) {
  var icon = props.icon,
      className = props.className,
      onClick = props.onClick,
      style = props.style,
      primaryColor = props.primaryColor,
      secondaryColor = props.secondaryColor,
      restProps = _objectWithoutProperties(props, ["icon", "className", "onClick", "style", "primaryColor", "secondaryColor"]);

  var colors = twoToneColorPalette;

  if (primaryColor) {
    colors = {
      primaryColor: primaryColor,
      secondaryColor: secondaryColor || (0,_utils__WEBPACK_IMPORTED_MODULE_0__.getSecondaryColor)(primaryColor)
    };
  }

  (0,_utils__WEBPACK_IMPORTED_MODULE_0__.useInsertStyles)();
  (0,_utils__WEBPACK_IMPORTED_MODULE_0__.warning)((0,_utils__WEBPACK_IMPORTED_MODULE_0__.isIconDefinition)(icon), "icon should be icon definiton, but got ".concat(icon));

  if (!(0,_utils__WEBPACK_IMPORTED_MODULE_0__.isIconDefinition)(icon)) {
    return null;
  }

  var target = icon;

  if (target && typeof target.icon === 'function') {
    target = _objectSpread({}, target, {
      icon: target.icon(colors.primaryColor, colors.secondaryColor)
    });
  }

  return (0,_utils__WEBPACK_IMPORTED_MODULE_0__.generate)(target.icon, "svg-".concat(target.name), _objectSpread({
    className: className,
    onClick: onClick,
    style: style,
    'data-icon': target.name,
    width: '1em',
    height: '1em',
    fill: 'currentColor',
    'aria-hidden': 'true'
  }, restProps));
};

IconBase.displayName = 'IconReact';
IconBase.getTwoToneColors = getTwoToneColors;
IconBase.setTwoToneColors = setTwoToneColors;
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (IconBase);

/***/ }),

/***/ "./node_modules/@ant-design/icons/es/components/twoTonePrimaryColor.js":
/*!*****************************************************************************!*\
  !*** ./node_modules/@ant-design/icons/es/components/twoTonePrimaryColor.js ***!
  \*****************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "getTwoToneColor": () => (/* binding */ getTwoToneColor),
/* harmony export */   "setTwoToneColor": () => (/* binding */ setTwoToneColor)
/* harmony export */ });
/* harmony import */ var _IconBase__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./IconBase */ "./node_modules/@ant-design/icons/es/components/IconBase.js");
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../utils */ "./node_modules/@ant-design/icons/es/utils.js");
function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(n); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }



function setTwoToneColor(twoToneColor) {
  var _normalizeTwoToneColo = (0,_utils__WEBPACK_IMPORTED_MODULE_0__.normalizeTwoToneColors)(twoToneColor),
      _normalizeTwoToneColo2 = _slicedToArray(_normalizeTwoToneColo, 2),
      primaryColor = _normalizeTwoToneColo2[0],
      secondaryColor = _normalizeTwoToneColo2[1];

  return _IconBase__WEBPACK_IMPORTED_MODULE_1__["default"].setTwoToneColors({
    primaryColor: primaryColor,
    secondaryColor: secondaryColor
  });
}
function getTwoToneColor() {
  var colors = _IconBase__WEBPACK_IMPORTED_MODULE_1__["default"].getTwoToneColors();

  if (!colors.calculated) {
    return colors.primaryColor;
  }

  return [colors.primaryColor, colors.secondaryColor];
}

/***/ }),

/***/ "./node_modules/@ant-design/icons/es/icons/LoadingOutlined.js":
/*!********************************************************************!*\
  !*** ./node_modules/@ant-design/icons/es/icons/LoadingOutlined.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var _ant_design_icons_svg_es_asn_LoadingOutlined__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @ant-design/icons-svg/es/asn/LoadingOutlined */ "./node_modules/@ant-design/icons-svg/es/asn/LoadingOutlined.js");
/* harmony import */ var _components_AntdIcon__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../components/AntdIcon */ "./node_modules/@ant-design/icons/es/components/AntdIcon.js");
// GENERATE BY ./scripts/generate.ts
// DON NOT EDIT IT MANUALLY




var LoadingOutlined = function LoadingOutlined(props, ref) {
  return react__WEBPACK_IMPORTED_MODULE_0__.createElement(_components_AntdIcon__WEBPACK_IMPORTED_MODULE_1__["default"], Object.assign({}, props, {
    ref: ref,
    icon: _ant_design_icons_svg_es_asn_LoadingOutlined__WEBPACK_IMPORTED_MODULE_2__["default"]
  }));
};

LoadingOutlined.displayName = 'LoadingOutlined';
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (react__WEBPACK_IMPORTED_MODULE_0__.forwardRef(LoadingOutlined));

/***/ }),

/***/ "./node_modules/@ant-design/icons/es/icons/PauseCircleOutlined.js":
/*!************************************************************************!*\
  !*** ./node_modules/@ant-design/icons/es/icons/PauseCircleOutlined.js ***!
  \************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var _ant_design_icons_svg_es_asn_PauseCircleOutlined__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @ant-design/icons-svg/es/asn/PauseCircleOutlined */ "./node_modules/@ant-design/icons-svg/es/asn/PauseCircleOutlined.js");
/* harmony import */ var _components_AntdIcon__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../components/AntdIcon */ "./node_modules/@ant-design/icons/es/components/AntdIcon.js");
// GENERATE BY ./scripts/generate.ts
// DON NOT EDIT IT MANUALLY




var PauseCircleOutlined = function PauseCircleOutlined(props, ref) {
  return react__WEBPACK_IMPORTED_MODULE_0__.createElement(_components_AntdIcon__WEBPACK_IMPORTED_MODULE_1__["default"], Object.assign({}, props, {
    ref: ref,
    icon: _ant_design_icons_svg_es_asn_PauseCircleOutlined__WEBPACK_IMPORTED_MODULE_2__["default"]
  }));
};

PauseCircleOutlined.displayName = 'PauseCircleOutlined';
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (react__WEBPACK_IMPORTED_MODULE_0__.forwardRef(PauseCircleOutlined));

/***/ }),

/***/ "./node_modules/@ant-design/icons/es/icons/PlayCircleOutlined.js":
/*!***********************************************************************!*\
  !*** ./node_modules/@ant-design/icons/es/icons/PlayCircleOutlined.js ***!
  \***********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var _ant_design_icons_svg_es_asn_PlayCircleOutlined__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @ant-design/icons-svg/es/asn/PlayCircleOutlined */ "./node_modules/@ant-design/icons-svg/es/asn/PlayCircleOutlined.js");
/* harmony import */ var _components_AntdIcon__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../components/AntdIcon */ "./node_modules/@ant-design/icons/es/components/AntdIcon.js");
// GENERATE BY ./scripts/generate.ts
// DON NOT EDIT IT MANUALLY




var PlayCircleOutlined = function PlayCircleOutlined(props, ref) {
  return react__WEBPACK_IMPORTED_MODULE_0__.createElement(_components_AntdIcon__WEBPACK_IMPORTED_MODULE_1__["default"], Object.assign({}, props, {
    ref: ref,
    icon: _ant_design_icons_svg_es_asn_PlayCircleOutlined__WEBPACK_IMPORTED_MODULE_2__["default"]
  }));
};

PlayCircleOutlined.displayName = 'PlayCircleOutlined';
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (react__WEBPACK_IMPORTED_MODULE_0__.forwardRef(PlayCircleOutlined));

/***/ }),

/***/ "./node_modules/@ant-design/icons/es/utils.js":
/*!****************************************************!*\
  !*** ./node_modules/@ant-design/icons/es/utils.js ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "generate": () => (/* binding */ generate),
/* harmony export */   "getSecondaryColor": () => (/* binding */ getSecondaryColor),
/* harmony export */   "iconStyles": () => (/* binding */ iconStyles),
/* harmony export */   "isIconDefinition": () => (/* binding */ isIconDefinition),
/* harmony export */   "normalizeAttrs": () => (/* binding */ normalizeAttrs),
/* harmony export */   "normalizeTwoToneColors": () => (/* binding */ normalizeTwoToneColors),
/* harmony export */   "svgBaseProps": () => (/* binding */ svgBaseProps),
/* harmony export */   "useInsertStyles": () => (/* binding */ useInsertStyles),
/* harmony export */   "warning": () => (/* binding */ warning)
/* harmony export */ });
/* harmony import */ var _ant_design_colors__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @ant-design/colors */ "./node_modules/@ant-design/colors/lib/index.js");
/* harmony import */ var _ant_design_colors__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_ant_design_colors__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var rc_util_es_warning__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! rc-util/es/warning */ "./node_modules/rc-util/es/warning.js");
/* harmony import */ var insert_css__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! insert-css */ "./node_modules/insert-css/index.js");
/* harmony import */ var insert_css__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(insert_css__WEBPACK_IMPORTED_MODULE_3__);
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }





function warning(valid, message) {
  (0,rc_util_es_warning__WEBPACK_IMPORTED_MODULE_2__["default"])(valid, "[@ant-design/icons] ".concat(message));
}
function isIconDefinition(target) {
  return _typeof(target) === 'object' && typeof target.name === 'string' && typeof target.theme === 'string' && (_typeof(target.icon) === 'object' || typeof target.icon === 'function');
}
function normalizeAttrs() {
  var attrs = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
  return Object.keys(attrs).reduce(function (acc, key) {
    var val = attrs[key];

    switch (key) {
      case 'class':
        acc.className = val;
        delete acc.class;
        break;

      default:
        acc[key] = val;
    }

    return acc;
  }, {});
}
function generate(node, key, rootProps) {
  if (!rootProps) {
    return react__WEBPACK_IMPORTED_MODULE_1__.createElement(node.tag, _objectSpread({
      key: key
    }, normalizeAttrs(node.attrs)), (node.children || []).map(function (child, index) {
      return generate(child, "".concat(key, "-").concat(node.tag, "-").concat(index));
    }));
  }

  return react__WEBPACK_IMPORTED_MODULE_1__.createElement(node.tag, _objectSpread({
    key: key
  }, normalizeAttrs(node.attrs), {}, rootProps), (node.children || []).map(function (child, index) {
    return generate(child, "".concat(key, "-").concat(node.tag, "-").concat(index));
  }));
}
function getSecondaryColor(primaryColor) {
  // choose the second color
  return (0,_ant_design_colors__WEBPACK_IMPORTED_MODULE_0__.generate)(primaryColor)[0];
}
function normalizeTwoToneColors(twoToneColor) {
  if (!twoToneColor) {
    return [];
  }

  return Array.isArray(twoToneColor) ? twoToneColor : [twoToneColor];
} // These props make sure that the SVG behaviours like general text.
// Reference: https://blog.prototypr.io/align-svg-icons-to-text-and-say-goodbye-to-font-icons-d44b3d7b26b4

var svgBaseProps = {
  width: '1em',
  height: '1em',
  fill: 'currentColor',
  'aria-hidden': 'true',
  focusable: 'false'
};
var iconStyles = "\n.anticon {\n  display: inline-block;\n  color: inherit;\n  font-style: normal;\n  line-height: 0;\n  text-align: center;\n  text-transform: none;\n  vertical-align: -0.125em;\n  text-rendering: optimizeLegibility;\n  -webkit-font-smoothing: antialiased;\n  -moz-osx-font-smoothing: grayscale;\n}\n\n.anticon > * {\n  line-height: 1;\n}\n\n.anticon svg {\n  display: inline-block;\n}\n\n.anticon::before {\n  display: none;\n}\n\n.anticon .anticon-icon {\n  display: block;\n}\n\n.anticon[tabindex] {\n  cursor: pointer;\n}\n\n.anticon-spin::before,\n.anticon-spin {\n  display: inline-block;\n  -webkit-animation: loadingCircle 1s infinite linear;\n  animation: loadingCircle 1s infinite linear;\n}\n\n@-webkit-keyframes loadingCircle {\n  100% {\n    -webkit-transform: rotate(360deg);\n    transform: rotate(360deg);\n  }\n}\n\n@keyframes loadingCircle {\n  100% {\n    -webkit-transform: rotate(360deg);\n    transform: rotate(360deg);\n  }\n}\n";
var cssInjectedFlag = false;
var useInsertStyles = function useInsertStyles() {
  var styleStr = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : iconStyles;
  (0,react__WEBPACK_IMPORTED_MODULE_1__.useEffect)(function () {
    if (!cssInjectedFlag) {
      (0,insert_css__WEBPACK_IMPORTED_MODULE_3__.insertCss)(styleStr, {
        prepend: true
      });
      cssInjectedFlag = true;
    }
  }, []);
};

/***/ }),

/***/ "./node_modules/@ant-design/icons/lib/components/AntdIcon.js":
/*!*******************************************************************!*\
  !*** ./node_modules/@ant-design/icons/lib/components/AntdIcon.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;

var React = _interopRequireWildcard(__webpack_require__(/*! react */ "./node_modules/react/index.js"));

var _classnames = _interopRequireDefault(__webpack_require__(/*! classnames */ "./node_modules/classnames/index.js"));

var _IconBase = _interopRequireDefault(__webpack_require__(/*! ./IconBase */ "./node_modules/@ant-design/icons/lib/components/IconBase.js"));

var _twoTonePrimaryColor = __webpack_require__(/*! ./twoTonePrimaryColor */ "./node_modules/@ant-design/icons/lib/components/twoTonePrimaryColor.js");

var _utils = __webpack_require__(/*! ../utils */ "./node_modules/@ant-design/icons/lib/utils.js");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function _getRequireWildcardCache() { return cache; }; return cache; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(n); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

// Initial setting
// should move it to antd main repo?
(0, _twoTonePrimaryColor.setTwoToneColor)('#1890ff');
var Icon = React.forwardRef(function (props, ref) {
  var className = props.className,
      icon = props.icon,
      spin = props.spin,
      rotate = props.rotate,
      tabIndex = props.tabIndex,
      onClick = props.onClick,
      twoToneColor = props.twoToneColor,
      restProps = _objectWithoutProperties(props, ["className", "icon", "spin", "rotate", "tabIndex", "onClick", "twoToneColor"]);

  var classString = (0, _classnames.default)('anticon', _defineProperty({}, "anticon-".concat(icon.name), Boolean(icon.name)), className);
  var svgClassString = (0, _classnames.default)({
    'anticon-spin': !!spin || icon.name === 'loading'
  });
  var iconTabIndex = tabIndex;

  if (iconTabIndex === undefined && onClick) {
    iconTabIndex = -1;
  }

  var svgStyle = rotate ? {
    msTransform: "rotate(".concat(rotate, "deg)"),
    transform: "rotate(".concat(rotate, "deg)")
  } : undefined;

  var _normalizeTwoToneColo = (0, _utils.normalizeTwoToneColors)(twoToneColor),
      _normalizeTwoToneColo2 = _slicedToArray(_normalizeTwoToneColo, 2),
      primaryColor = _normalizeTwoToneColo2[0],
      secondaryColor = _normalizeTwoToneColo2[1];

  return React.createElement("span", Object.assign({
    role: "img",
    "aria-label": icon.name
  }, restProps, {
    ref: ref,
    tabIndex: iconTabIndex,
    onClick: onClick,
    className: classString
  }), React.createElement(_IconBase.default, {
    className: svgClassString,
    icon: icon,
    primaryColor: primaryColor,
    secondaryColor: secondaryColor,
    style: svgStyle
  }));
});
Icon.displayName = 'AntdIcon';
Icon.getTwoToneColor = _twoTonePrimaryColor.getTwoToneColor;
Icon.setTwoToneColor = _twoTonePrimaryColor.setTwoToneColor;
var _default = Icon;
exports["default"] = _default;

/***/ }),

/***/ "./node_modules/@ant-design/icons/lib/components/IconBase.js":
/*!*******************************************************************!*\
  !*** ./node_modules/@ant-design/icons/lib/components/IconBase.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;

var _utils = __webpack_require__(/*! ../utils */ "./node_modules/@ant-design/icons/lib/utils.js");

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

var twoToneColorPalette = {
  primaryColor: '#333',
  secondaryColor: '#E6E6E6',
  calculated: false
};

function setTwoToneColors(_ref) {
  var primaryColor = _ref.primaryColor,
      secondaryColor = _ref.secondaryColor;
  twoToneColorPalette.primaryColor = primaryColor;
  twoToneColorPalette.secondaryColor = secondaryColor || (0, _utils.getSecondaryColor)(primaryColor);
  twoToneColorPalette.calculated = !!secondaryColor;
}

function getTwoToneColors() {
  return _objectSpread({}, twoToneColorPalette);
}

var IconBase = function IconBase(props) {
  var icon = props.icon,
      className = props.className,
      onClick = props.onClick,
      style = props.style,
      primaryColor = props.primaryColor,
      secondaryColor = props.secondaryColor,
      restProps = _objectWithoutProperties(props, ["icon", "className", "onClick", "style", "primaryColor", "secondaryColor"]);

  var colors = twoToneColorPalette;

  if (primaryColor) {
    colors = {
      primaryColor: primaryColor,
      secondaryColor: secondaryColor || (0, _utils.getSecondaryColor)(primaryColor)
    };
  }

  (0, _utils.useInsertStyles)();
  (0, _utils.warning)((0, _utils.isIconDefinition)(icon), "icon should be icon definiton, but got ".concat(icon));

  if (!(0, _utils.isIconDefinition)(icon)) {
    return null;
  }

  var target = icon;

  if (target && typeof target.icon === 'function') {
    target = _objectSpread({}, target, {
      icon: target.icon(colors.primaryColor, colors.secondaryColor)
    });
  }

  return (0, _utils.generate)(target.icon, "svg-".concat(target.name), _objectSpread({
    className: className,
    onClick: onClick,
    style: style,
    'data-icon': target.name,
    width: '1em',
    height: '1em',
    fill: 'currentColor',
    'aria-hidden': 'true'
  }, restProps));
};

IconBase.displayName = 'IconReact';
IconBase.getTwoToneColors = getTwoToneColors;
IconBase.setTwoToneColors = setTwoToneColors;
var _default = IconBase;
exports["default"] = _default;

/***/ }),

/***/ "./node_modules/@ant-design/icons/lib/components/twoTonePrimaryColor.js":
/*!******************************************************************************!*\
  !*** ./node_modules/@ant-design/icons/lib/components/twoTonePrimaryColor.js ***!
  \******************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.setTwoToneColor = setTwoToneColor;
exports.getTwoToneColor = getTwoToneColor;

var _IconBase = _interopRequireDefault(__webpack_require__(/*! ./IconBase */ "./node_modules/@ant-design/icons/lib/components/IconBase.js"));

var _utils = __webpack_require__(/*! ../utils */ "./node_modules/@ant-design/icons/lib/utils.js");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(n); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function setTwoToneColor(twoToneColor) {
  var _normalizeTwoToneColo = (0, _utils.normalizeTwoToneColors)(twoToneColor),
      _normalizeTwoToneColo2 = _slicedToArray(_normalizeTwoToneColo, 2),
      primaryColor = _normalizeTwoToneColo2[0],
      secondaryColor = _normalizeTwoToneColo2[1];

  return _IconBase.default.setTwoToneColors({
    primaryColor: primaryColor,
    secondaryColor: secondaryColor
  });
}

function getTwoToneColor() {
  var colors = _IconBase.default.getTwoToneColors();

  if (!colors.calculated) {
    return colors.primaryColor;
  }

  return [colors.primaryColor, colors.secondaryColor];
}

/***/ }),

/***/ "./node_modules/@ant-design/icons/lib/icons/BarsOutlined.js":
/*!******************************************************************!*\
  !*** ./node_modules/@ant-design/icons/lib/icons/BarsOutlined.js ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;

var React = _interopRequireWildcard(__webpack_require__(/*! react */ "./node_modules/react/index.js"));

var _BarsOutlined = _interopRequireDefault(__webpack_require__(/*! @ant-design/icons-svg/lib/asn/BarsOutlined */ "./node_modules/@ant-design/icons-svg/lib/asn/BarsOutlined.js"));

var _AntdIcon = _interopRequireDefault(__webpack_require__(/*! ../components/AntdIcon */ "./node_modules/@ant-design/icons/lib/components/AntdIcon.js"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function _getRequireWildcardCache() { return cache; }; return cache; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

// GENERATE BY ./scripts/generate.ts
// DON NOT EDIT IT MANUALLY
var BarsOutlined = function BarsOutlined(props, ref) {
  return React.createElement(_AntdIcon.default, Object.assign({}, props, {
    ref: ref,
    icon: _BarsOutlined.default
  }));
};

BarsOutlined.displayName = 'BarsOutlined';

var _default = React.forwardRef(BarsOutlined);

exports["default"] = _default;

/***/ }),

/***/ "./node_modules/@ant-design/icons/lib/icons/CaretDownFilled.js":
/*!*********************************************************************!*\
  !*** ./node_modules/@ant-design/icons/lib/icons/CaretDownFilled.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;

var React = _interopRequireWildcard(__webpack_require__(/*! react */ "./node_modules/react/index.js"));

var _CaretDownFilled = _interopRequireDefault(__webpack_require__(/*! @ant-design/icons-svg/lib/asn/CaretDownFilled */ "./node_modules/@ant-design/icons-svg/lib/asn/CaretDownFilled.js"));

var _AntdIcon = _interopRequireDefault(__webpack_require__(/*! ../components/AntdIcon */ "./node_modules/@ant-design/icons/lib/components/AntdIcon.js"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function _getRequireWildcardCache() { return cache; }; return cache; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

// GENERATE BY ./scripts/generate.ts
// DON NOT EDIT IT MANUALLY
var CaretDownFilled = function CaretDownFilled(props, ref) {
  return React.createElement(_AntdIcon.default, Object.assign({}, props, {
    ref: ref,
    icon: _CaretDownFilled.default
  }));
};

CaretDownFilled.displayName = 'CaretDownFilled';

var _default = React.forwardRef(CaretDownFilled);

exports["default"] = _default;

/***/ }),

/***/ "./node_modules/@ant-design/icons/lib/icons/CheckOutlined.js":
/*!*******************************************************************!*\
  !*** ./node_modules/@ant-design/icons/lib/icons/CheckOutlined.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;

var React = _interopRequireWildcard(__webpack_require__(/*! react */ "./node_modules/react/index.js"));

var _CheckOutlined = _interopRequireDefault(__webpack_require__(/*! @ant-design/icons-svg/lib/asn/CheckOutlined */ "./node_modules/@ant-design/icons-svg/lib/asn/CheckOutlined.js"));

var _AntdIcon = _interopRequireDefault(__webpack_require__(/*! ../components/AntdIcon */ "./node_modules/@ant-design/icons/lib/components/AntdIcon.js"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function _getRequireWildcardCache() { return cache; }; return cache; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

// GENERATE BY ./scripts/generate.ts
// DON NOT EDIT IT MANUALLY
var CheckOutlined = function CheckOutlined(props, ref) {
  return React.createElement(_AntdIcon.default, Object.assign({}, props, {
    ref: ref,
    icon: _CheckOutlined.default
  }));
};

CheckOutlined.displayName = 'CheckOutlined';

var _default = React.forwardRef(CheckOutlined);

exports["default"] = _default;

/***/ }),

/***/ "./node_modules/@ant-design/icons/lib/icons/CloseCircleFilled.js":
/*!***********************************************************************!*\
  !*** ./node_modules/@ant-design/icons/lib/icons/CloseCircleFilled.js ***!
  \***********************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;

var React = _interopRequireWildcard(__webpack_require__(/*! react */ "./node_modules/react/index.js"));

var _CloseCircleFilled = _interopRequireDefault(__webpack_require__(/*! @ant-design/icons-svg/lib/asn/CloseCircleFilled */ "./node_modules/@ant-design/icons-svg/lib/asn/CloseCircleFilled.js"));

var _AntdIcon = _interopRequireDefault(__webpack_require__(/*! ../components/AntdIcon */ "./node_modules/@ant-design/icons/lib/components/AntdIcon.js"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function _getRequireWildcardCache() { return cache; }; return cache; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

// GENERATE BY ./scripts/generate.ts
// DON NOT EDIT IT MANUALLY
var CloseCircleFilled = function CloseCircleFilled(props, ref) {
  return React.createElement(_AntdIcon.default, Object.assign({}, props, {
    ref: ref,
    icon: _CloseCircleFilled.default
  }));
};

CloseCircleFilled.displayName = 'CloseCircleFilled';

var _default = React.forwardRef(CloseCircleFilled);

exports["default"] = _default;

/***/ }),

/***/ "./node_modules/@ant-design/icons/lib/icons/CloseOutlined.js":
/*!*******************************************************************!*\
  !*** ./node_modules/@ant-design/icons/lib/icons/CloseOutlined.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;

var React = _interopRequireWildcard(__webpack_require__(/*! react */ "./node_modules/react/index.js"));

var _CloseOutlined = _interopRequireDefault(__webpack_require__(/*! @ant-design/icons-svg/lib/asn/CloseOutlined */ "./node_modules/@ant-design/icons-svg/lib/asn/CloseOutlined.js"));

var _AntdIcon = _interopRequireDefault(__webpack_require__(/*! ../components/AntdIcon */ "./node_modules/@ant-design/icons/lib/components/AntdIcon.js"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function _getRequireWildcardCache() { return cache; }; return cache; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

// GENERATE BY ./scripts/generate.ts
// DON NOT EDIT IT MANUALLY
var CloseOutlined = function CloseOutlined(props, ref) {
  return React.createElement(_AntdIcon.default, Object.assign({}, props, {
    ref: ref,
    icon: _CloseOutlined.default
  }));
};

CloseOutlined.displayName = 'CloseOutlined';

var _default = React.forwardRef(CloseOutlined);

exports["default"] = _default;

/***/ }),

/***/ "./node_modules/@ant-design/icons/lib/icons/DownOutlined.js":
/*!******************************************************************!*\
  !*** ./node_modules/@ant-design/icons/lib/icons/DownOutlined.js ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;

var React = _interopRequireWildcard(__webpack_require__(/*! react */ "./node_modules/react/index.js"));

var _DownOutlined = _interopRequireDefault(__webpack_require__(/*! @ant-design/icons-svg/lib/asn/DownOutlined */ "./node_modules/@ant-design/icons-svg/lib/asn/DownOutlined.js"));

var _AntdIcon = _interopRequireDefault(__webpack_require__(/*! ../components/AntdIcon */ "./node_modules/@ant-design/icons/lib/components/AntdIcon.js"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function _getRequireWildcardCache() { return cache; }; return cache; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

// GENERATE BY ./scripts/generate.ts
// DON NOT EDIT IT MANUALLY
var DownOutlined = function DownOutlined(props, ref) {
  return React.createElement(_AntdIcon.default, Object.assign({}, props, {
    ref: ref,
    icon: _DownOutlined.default
  }));
};

DownOutlined.displayName = 'DownOutlined';

var _default = React.forwardRef(DownOutlined);

exports["default"] = _default;

/***/ }),

/***/ "./node_modules/@ant-design/icons/lib/icons/FileOutlined.js":
/*!******************************************************************!*\
  !*** ./node_modules/@ant-design/icons/lib/icons/FileOutlined.js ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;

var React = _interopRequireWildcard(__webpack_require__(/*! react */ "./node_modules/react/index.js"));

var _FileOutlined = _interopRequireDefault(__webpack_require__(/*! @ant-design/icons-svg/lib/asn/FileOutlined */ "./node_modules/@ant-design/icons-svg/lib/asn/FileOutlined.js"));

var _AntdIcon = _interopRequireDefault(__webpack_require__(/*! ../components/AntdIcon */ "./node_modules/@ant-design/icons/lib/components/AntdIcon.js"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function _getRequireWildcardCache() { return cache; }; return cache; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

// GENERATE BY ./scripts/generate.ts
// DON NOT EDIT IT MANUALLY
var FileOutlined = function FileOutlined(props, ref) {
  return React.createElement(_AntdIcon.default, Object.assign({}, props, {
    ref: ref,
    icon: _FileOutlined.default
  }));
};

FileOutlined.displayName = 'FileOutlined';

var _default = React.forwardRef(FileOutlined);

exports["default"] = _default;

/***/ }),

/***/ "./node_modules/@ant-design/icons/lib/icons/FolderOpenOutlined.js":
/*!************************************************************************!*\
  !*** ./node_modules/@ant-design/icons/lib/icons/FolderOpenOutlined.js ***!
  \************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;

var React = _interopRequireWildcard(__webpack_require__(/*! react */ "./node_modules/react/index.js"));

var _FolderOpenOutlined = _interopRequireDefault(__webpack_require__(/*! @ant-design/icons-svg/lib/asn/FolderOpenOutlined */ "./node_modules/@ant-design/icons-svg/lib/asn/FolderOpenOutlined.js"));

var _AntdIcon = _interopRequireDefault(__webpack_require__(/*! ../components/AntdIcon */ "./node_modules/@ant-design/icons/lib/components/AntdIcon.js"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function _getRequireWildcardCache() { return cache; }; return cache; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

// GENERATE BY ./scripts/generate.ts
// DON NOT EDIT IT MANUALLY
var FolderOpenOutlined = function FolderOpenOutlined(props, ref) {
  return React.createElement(_AntdIcon.default, Object.assign({}, props, {
    ref: ref,
    icon: _FolderOpenOutlined.default
  }));
};

FolderOpenOutlined.displayName = 'FolderOpenOutlined';

var _default = React.forwardRef(FolderOpenOutlined);

exports["default"] = _default;

/***/ }),

/***/ "./node_modules/@ant-design/icons/lib/icons/FolderOutlined.js":
/*!********************************************************************!*\
  !*** ./node_modules/@ant-design/icons/lib/icons/FolderOutlined.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;

var React = _interopRequireWildcard(__webpack_require__(/*! react */ "./node_modules/react/index.js"));

var _FolderOutlined = _interopRequireDefault(__webpack_require__(/*! @ant-design/icons-svg/lib/asn/FolderOutlined */ "./node_modules/@ant-design/icons-svg/lib/asn/FolderOutlined.js"));

var _AntdIcon = _interopRequireDefault(__webpack_require__(/*! ../components/AntdIcon */ "./node_modules/@ant-design/icons/lib/components/AntdIcon.js"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function _getRequireWildcardCache() { return cache; }; return cache; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

// GENERATE BY ./scripts/generate.ts
// DON NOT EDIT IT MANUALLY
var FolderOutlined = function FolderOutlined(props, ref) {
  return React.createElement(_AntdIcon.default, Object.assign({}, props, {
    ref: ref,
    icon: _FolderOutlined.default
  }));
};

FolderOutlined.displayName = 'FolderOutlined';

var _default = React.forwardRef(FolderOutlined);

exports["default"] = _default;

/***/ }),

/***/ "./node_modules/@ant-design/icons/lib/icons/LeftOutlined.js":
/*!******************************************************************!*\
  !*** ./node_modules/@ant-design/icons/lib/icons/LeftOutlined.js ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;

var React = _interopRequireWildcard(__webpack_require__(/*! react */ "./node_modules/react/index.js"));

var _LeftOutlined = _interopRequireDefault(__webpack_require__(/*! @ant-design/icons-svg/lib/asn/LeftOutlined */ "./node_modules/@ant-design/icons-svg/lib/asn/LeftOutlined.js"));

var _AntdIcon = _interopRequireDefault(__webpack_require__(/*! ../components/AntdIcon */ "./node_modules/@ant-design/icons/lib/components/AntdIcon.js"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function _getRequireWildcardCache() { return cache; }; return cache; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

// GENERATE BY ./scripts/generate.ts
// DON NOT EDIT IT MANUALLY
var LeftOutlined = function LeftOutlined(props, ref) {
  return React.createElement(_AntdIcon.default, Object.assign({}, props, {
    ref: ref,
    icon: _LeftOutlined.default
  }));
};

LeftOutlined.displayName = 'LeftOutlined';

var _default = React.forwardRef(LeftOutlined);

exports["default"] = _default;

/***/ }),

/***/ "./node_modules/@ant-design/icons/lib/icons/LoadingOutlined.js":
/*!*********************************************************************!*\
  !*** ./node_modules/@ant-design/icons/lib/icons/LoadingOutlined.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;

var React = _interopRequireWildcard(__webpack_require__(/*! react */ "./node_modules/react/index.js"));

var _LoadingOutlined = _interopRequireDefault(__webpack_require__(/*! @ant-design/icons-svg/lib/asn/LoadingOutlined */ "./node_modules/@ant-design/icons-svg/lib/asn/LoadingOutlined.js"));

var _AntdIcon = _interopRequireDefault(__webpack_require__(/*! ../components/AntdIcon */ "./node_modules/@ant-design/icons/lib/components/AntdIcon.js"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function _getRequireWildcardCache() { return cache; }; return cache; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

// GENERATE BY ./scripts/generate.ts
// DON NOT EDIT IT MANUALLY
var LoadingOutlined = function LoadingOutlined(props, ref) {
  return React.createElement(_AntdIcon.default, Object.assign({}, props, {
    ref: ref,
    icon: _LoadingOutlined.default
  }));
};

LoadingOutlined.displayName = 'LoadingOutlined';

var _default = React.forwardRef(LoadingOutlined);

exports["default"] = _default;

/***/ }),

/***/ "./node_modules/@ant-design/icons/lib/icons/MinusSquareOutlined.js":
/*!*************************************************************************!*\
  !*** ./node_modules/@ant-design/icons/lib/icons/MinusSquareOutlined.js ***!
  \*************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;

var React = _interopRequireWildcard(__webpack_require__(/*! react */ "./node_modules/react/index.js"));

var _MinusSquareOutlined = _interopRequireDefault(__webpack_require__(/*! @ant-design/icons-svg/lib/asn/MinusSquareOutlined */ "./node_modules/@ant-design/icons-svg/lib/asn/MinusSquareOutlined.js"));

var _AntdIcon = _interopRequireDefault(__webpack_require__(/*! ../components/AntdIcon */ "./node_modules/@ant-design/icons/lib/components/AntdIcon.js"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function _getRequireWildcardCache() { return cache; }; return cache; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

// GENERATE BY ./scripts/generate.ts
// DON NOT EDIT IT MANUALLY
var MinusSquareOutlined = function MinusSquareOutlined(props, ref) {
  return React.createElement(_AntdIcon.default, Object.assign({}, props, {
    ref: ref,
    icon: _MinusSquareOutlined.default
  }));
};

MinusSquareOutlined.displayName = 'MinusSquareOutlined';

var _default = React.forwardRef(MinusSquareOutlined);

exports["default"] = _default;

/***/ }),

/***/ "./node_modules/@ant-design/icons/lib/icons/PlusSquareOutlined.js":
/*!************************************************************************!*\
  !*** ./node_modules/@ant-design/icons/lib/icons/PlusSquareOutlined.js ***!
  \************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;

var React = _interopRequireWildcard(__webpack_require__(/*! react */ "./node_modules/react/index.js"));

var _PlusSquareOutlined = _interopRequireDefault(__webpack_require__(/*! @ant-design/icons-svg/lib/asn/PlusSquareOutlined */ "./node_modules/@ant-design/icons-svg/lib/asn/PlusSquareOutlined.js"));

var _AntdIcon = _interopRequireDefault(__webpack_require__(/*! ../components/AntdIcon */ "./node_modules/@ant-design/icons/lib/components/AntdIcon.js"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function _getRequireWildcardCache() { return cache; }; return cache; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

// GENERATE BY ./scripts/generate.ts
// DON NOT EDIT IT MANUALLY
var PlusSquareOutlined = function PlusSquareOutlined(props, ref) {
  return React.createElement(_AntdIcon.default, Object.assign({}, props, {
    ref: ref,
    icon: _PlusSquareOutlined.default
  }));
};

PlusSquareOutlined.displayName = 'PlusSquareOutlined';

var _default = React.forwardRef(PlusSquareOutlined);

exports["default"] = _default;

/***/ }),

/***/ "./node_modules/@ant-design/icons/lib/icons/RightOutlined.js":
/*!*******************************************************************!*\
  !*** ./node_modules/@ant-design/icons/lib/icons/RightOutlined.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;

var React = _interopRequireWildcard(__webpack_require__(/*! react */ "./node_modules/react/index.js"));

var _RightOutlined = _interopRequireDefault(__webpack_require__(/*! @ant-design/icons-svg/lib/asn/RightOutlined */ "./node_modules/@ant-design/icons-svg/lib/asn/RightOutlined.js"));

var _AntdIcon = _interopRequireDefault(__webpack_require__(/*! ../components/AntdIcon */ "./node_modules/@ant-design/icons/lib/components/AntdIcon.js"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function _getRequireWildcardCache() { return cache; }; return cache; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

// GENERATE BY ./scripts/generate.ts
// DON NOT EDIT IT MANUALLY
var RightOutlined = function RightOutlined(props, ref) {
  return React.createElement(_AntdIcon.default, Object.assign({}, props, {
    ref: ref,
    icon: _RightOutlined.default
  }));
};

RightOutlined.displayName = 'RightOutlined';

var _default = React.forwardRef(RightOutlined);

exports["default"] = _default;

/***/ }),

/***/ "./node_modules/@ant-design/icons/lib/icons/SearchOutlined.js":
/*!********************************************************************!*\
  !*** ./node_modules/@ant-design/icons/lib/icons/SearchOutlined.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;

var React = _interopRequireWildcard(__webpack_require__(/*! react */ "./node_modules/react/index.js"));

var _SearchOutlined = _interopRequireDefault(__webpack_require__(/*! @ant-design/icons-svg/lib/asn/SearchOutlined */ "./node_modules/@ant-design/icons-svg/lib/asn/SearchOutlined.js"));

var _AntdIcon = _interopRequireDefault(__webpack_require__(/*! ../components/AntdIcon */ "./node_modules/@ant-design/icons/lib/components/AntdIcon.js"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function _getRequireWildcardCache() { return cache; }; return cache; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

// GENERATE BY ./scripts/generate.ts
// DON NOT EDIT IT MANUALLY
var SearchOutlined = function SearchOutlined(props, ref) {
  return React.createElement(_AntdIcon.default, Object.assign({}, props, {
    ref: ref,
    icon: _SearchOutlined.default
  }));
};

SearchOutlined.displayName = 'SearchOutlined';

var _default = React.forwardRef(SearchOutlined);

exports["default"] = _default;

/***/ }),

/***/ "./node_modules/@ant-design/icons/lib/utils.js":
/*!*****************************************************!*\
  !*** ./node_modules/@ant-design/icons/lib/utils.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.warning = warning;
exports.isIconDefinition = isIconDefinition;
exports.normalizeAttrs = normalizeAttrs;
exports.generate = generate;
exports.getSecondaryColor = getSecondaryColor;
exports.normalizeTwoToneColors = normalizeTwoToneColors;
exports.useInsertStyles = exports.iconStyles = exports.svgBaseProps = void 0;

var _colors = __webpack_require__(/*! @ant-design/colors */ "./node_modules/@ant-design/colors/lib/index.js");

var _react = _interopRequireWildcard(__webpack_require__(/*! react */ "./node_modules/react/index.js"));

var _warning = _interopRequireDefault(__webpack_require__(/*! rc-util/lib/warning */ "./node_modules/rc-util/lib/warning.js"));

var _insertCss = __webpack_require__(/*! insert-css */ "./node_modules/insert-css/index.js");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function _getRequireWildcardCache() { return cache; }; return cache; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function warning(valid, message) {
  (0, _warning.default)(valid, "[@ant-design/icons] ".concat(message));
}

function isIconDefinition(target) {
  return _typeof(target) === 'object' && typeof target.name === 'string' && typeof target.theme === 'string' && (_typeof(target.icon) === 'object' || typeof target.icon === 'function');
}

function normalizeAttrs() {
  var attrs = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
  return Object.keys(attrs).reduce(function (acc, key) {
    var val = attrs[key];

    switch (key) {
      case 'class':
        acc.className = val;
        delete acc.class;
        break;

      default:
        acc[key] = val;
    }

    return acc;
  }, {});
}

function generate(node, key, rootProps) {
  if (!rootProps) {
    return _react.default.createElement(node.tag, _objectSpread({
      key: key
    }, normalizeAttrs(node.attrs)), (node.children || []).map(function (child, index) {
      return generate(child, "".concat(key, "-").concat(node.tag, "-").concat(index));
    }));
  }

  return _react.default.createElement(node.tag, _objectSpread({
    key: key
  }, normalizeAttrs(node.attrs), {}, rootProps), (node.children || []).map(function (child, index) {
    return generate(child, "".concat(key, "-").concat(node.tag, "-").concat(index));
  }));
}

function getSecondaryColor(primaryColor) {
  // choose the second color
  return (0, _colors.generate)(primaryColor)[0];
}

function normalizeTwoToneColors(twoToneColor) {
  if (!twoToneColor) {
    return [];
  }

  return Array.isArray(twoToneColor) ? twoToneColor : [twoToneColor];
} // These props make sure that the SVG behaviours like general text.
// Reference: https://blog.prototypr.io/align-svg-icons-to-text-and-say-goodbye-to-font-icons-d44b3d7b26b4


var svgBaseProps = {
  width: '1em',
  height: '1em',
  fill: 'currentColor',
  'aria-hidden': 'true',
  focusable: 'false'
};
exports.svgBaseProps = svgBaseProps;
var iconStyles = "\n.anticon {\n  display: inline-block;\n  color: inherit;\n  font-style: normal;\n  line-height: 0;\n  text-align: center;\n  text-transform: none;\n  vertical-align: -0.125em;\n  text-rendering: optimizeLegibility;\n  -webkit-font-smoothing: antialiased;\n  -moz-osx-font-smoothing: grayscale;\n}\n\n.anticon > * {\n  line-height: 1;\n}\n\n.anticon svg {\n  display: inline-block;\n}\n\n.anticon::before {\n  display: none;\n}\n\n.anticon .anticon-icon {\n  display: block;\n}\n\n.anticon[tabindex] {\n  cursor: pointer;\n}\n\n.anticon-spin::before,\n.anticon-spin {\n  display: inline-block;\n  -webkit-animation: loadingCircle 1s infinite linear;\n  animation: loadingCircle 1s infinite linear;\n}\n\n@-webkit-keyframes loadingCircle {\n  100% {\n    -webkit-transform: rotate(360deg);\n    transform: rotate(360deg);\n  }\n}\n\n@keyframes loadingCircle {\n  100% {\n    -webkit-transform: rotate(360deg);\n    transform: rotate(360deg);\n  }\n}\n";
exports.iconStyles = iconStyles;
var cssInjectedFlag = false;

var useInsertStyles = function useInsertStyles() {
  var styleStr = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : iconStyles;
  (0, _react.useEffect)(function () {
    if (!cssInjectedFlag) {
      (0, _insertCss.insertCss)(styleStr, {
        prepend: true
      });
      cssInjectedFlag = true;
    }
  }, []);
};

exports.useInsertStyles = useInsertStyles;

/***/ }),

/***/ "./node_modules/@babel/runtime/helpers/inheritsLoose.js":
/*!**************************************************************!*\
  !*** ./node_modules/@babel/runtime/helpers/inheritsLoose.js ***!
  \**************************************************************/
/***/ ((module) => {

function _inheritsLoose(subClass, superClass) {
  subClass.prototype = Object.create(superClass.prototype);
  subClass.prototype.constructor = subClass;
  subClass.__proto__ = superClass;
}

module.exports = _inheritsLoose;

/***/ }),

/***/ "./node_modules/@babylonjs/core/Actions/abstractActionManager.js":
/*!***********************************************************************!*\
  !*** ./node_modules/@babylonjs/core/Actions/abstractActionManager.js ***!
  \***********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "AbstractActionManager": () => (/* binding */ AbstractActionManager)
/* harmony export */ });
/**
 * Abstract class used to decouple action Manager from scene and meshes.
 * Do not instantiate.
 * @see http://doc.babylonjs.com/how_to/how_to_use_actions
 */
var AbstractActionManager = /** @class */ (function () {
    function AbstractActionManager() {
        /** Gets the cursor to use when hovering items */
        this.hoverCursor = '';
        /** Gets the list of actions */
        this.actions = new Array();
        /**
         * Gets or sets a boolean indicating that the manager is recursive meaning that it can trigger action from children
         */
        this.isRecursive = false;
    }
    Object.defineProperty(AbstractActionManager, "HasTriggers", {
        /**
         * Does exist one action manager with at least one trigger
         **/
        get: function () {
            for (var t in AbstractActionManager.Triggers) {
                if (AbstractActionManager.Triggers.hasOwnProperty(t)) {
                    return true;
                }
            }
            return false;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(AbstractActionManager, "HasPickTriggers", {
        /**
         * Does exist one action manager with at least one pick trigger
         **/
        get: function () {
            for (var t in AbstractActionManager.Triggers) {
                if (AbstractActionManager.Triggers.hasOwnProperty(t)) {
                    var t_int = parseInt(t);
                    if (t_int >= 1 && t_int <= 7) {
                        return true;
                    }
                }
            }
            return false;
        },
        enumerable: true,
        configurable: true
    });
    /**
     * Does exist one action manager that handles actions of a given trigger
     * @param trigger defines the trigger to be tested
     * @return a boolean indicating whether the trigger is handeled by at least one action manager
    **/
    AbstractActionManager.HasSpecificTrigger = function (trigger) {
        for (var t in AbstractActionManager.Triggers) {
            if (AbstractActionManager.Triggers.hasOwnProperty(t)) {
                var t_int = parseInt(t);
                if (t_int === trigger) {
                    return true;
                }
            }
        }
        return false;
    };
    /** Gets the list of active triggers */
    AbstractActionManager.Triggers = {};
    return AbstractActionManager;
}());

//# sourceMappingURL=abstractActionManager.js.map

/***/ }),

/***/ "./node_modules/@babylonjs/core/Actions/action.js":
/*!********************************************************!*\
  !*** ./node_modules/@babylonjs/core/Actions/action.js ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Action": () => (/* binding */ Action)
/* harmony export */ });
/* harmony import */ var _Misc_observable__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../Misc/observable */ "./node_modules/@babylonjs/core/Misc/observable.js");
/* harmony import */ var _Maths_math_vector__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Maths/math.vector */ "./node_modules/@babylonjs/core/Maths/math.vector.js");
/* harmony import */ var _Maths_math_color__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Maths/math.color */ "./node_modules/@babylonjs/core/Maths/math.color.js");
/* harmony import */ var _Misc_typeStore__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../Misc/typeStore */ "./node_modules/@babylonjs/core/Misc/typeStore.js");




/**
 * The action to be carried out following a trigger
 * @see http://doc.babylonjs.com/how_to/how_to_use_actions#available-actions
 */
var Action = /** @class */ (function () {
    /**
     * Creates a new Action
     * @param triggerOptions the trigger, with or without parameters, for the action
     * @param condition an optional determinant of action
     */
    function Action(
    /** the trigger, with or without parameters, for the action */
    triggerOptions, condition) {
        this.triggerOptions = triggerOptions;
        /**
        * An event triggered prior to action being executed.
        */
        this.onBeforeExecuteObservable = new _Misc_observable__WEBPACK_IMPORTED_MODULE_0__.Observable();
        if (triggerOptions.parameter) {
            this.trigger = triggerOptions.trigger;
            this._triggerParameter = triggerOptions.parameter;
        }
        else if (triggerOptions.trigger) {
            this.trigger = triggerOptions.trigger;
        }
        else {
            this.trigger = triggerOptions;
        }
        this._nextActiveAction = this;
        this._condition = condition;
    }
    /**
     * Internal only
     * @hidden
     */
    Action.prototype._prepare = function () {
    };
    /**
     * Gets the trigger parameters
     * @returns the trigger parameters
     */
    Action.prototype.getTriggerParameter = function () {
        return this._triggerParameter;
    };
    /**
     * Internal only - executes current action event
     * @hidden
     */
    Action.prototype._executeCurrent = function (evt) {
        if (this._nextActiveAction._condition) {
            var condition = this._nextActiveAction._condition;
            var currentRenderId = this._actionManager.getScene().getRenderId();
            // We cache the current evaluation for the current frame
            if (condition._evaluationId === currentRenderId) {
                if (!condition._currentResult) {
                    return;
                }
            }
            else {
                condition._evaluationId = currentRenderId;
                if (!condition.isValid()) {
                    condition._currentResult = false;
                    return;
                }
                condition._currentResult = true;
            }
        }
        this.onBeforeExecuteObservable.notifyObservers(this);
        this._nextActiveAction.execute(evt);
        this.skipToNextActiveAction();
    };
    /**
     * Execute placeholder for child classes
     * @param evt optional action event
     */
    Action.prototype.execute = function (evt) {
    };
    /**
     * Skips to next active action
     */
    Action.prototype.skipToNextActiveAction = function () {
        if (this._nextActiveAction._child) {
            if (!this._nextActiveAction._child._actionManager) {
                this._nextActiveAction._child._actionManager = this._actionManager;
            }
            this._nextActiveAction = this._nextActiveAction._child;
        }
        else {
            this._nextActiveAction = this;
        }
    };
    /**
     * Adds action to chain of actions, may be a DoNothingAction
     * @param action defines the next action to execute
     * @returns The action passed in
     * @see https://www.babylonjs-playground.com/#1T30HR#0
     */
    Action.prototype.then = function (action) {
        this._child = action;
        action._actionManager = this._actionManager;
        action._prepare();
        return action;
    };
    /**
     * Internal only
     * @hidden
     */
    Action.prototype._getProperty = function (propertyPath) {
        return this._actionManager._getProperty(propertyPath);
    };
    /**
     * Internal only
     * @hidden
     */
    Action.prototype._getEffectiveTarget = function (target, propertyPath) {
        return this._actionManager._getEffectiveTarget(target, propertyPath);
    };
    /**
     * Serialize placeholder for child classes
     * @param parent of child
     * @returns the serialized object
     */
    Action.prototype.serialize = function (parent) {
    };
    /**
     * Internal only called by serialize
     * @hidden
     */
    Action.prototype._serialize = function (serializedAction, parent) {
        var serializationObject = {
            type: 1,
            children: [],
            name: serializedAction.name,
            properties: serializedAction.properties || []
        };
        // Serialize child
        if (this._child) {
            this._child.serialize(serializationObject);
        }
        // Check if "this" has a condition
        if (this._condition) {
            var serializedCondition = this._condition.serialize();
            serializedCondition.children.push(serializationObject);
            if (parent) {
                parent.children.push(serializedCondition);
            }
            return serializedCondition;
        }
        if (parent) {
            parent.children.push(serializationObject);
        }
        return serializationObject;
    };
    /**
     * Internal only
     * @hidden
     */
    Action._SerializeValueAsString = function (value) {
        if (typeof value === "number") {
            return value.toString();
        }
        if (typeof value === "boolean") {
            return value ? "true" : "false";
        }
        if (value instanceof _Maths_math_vector__WEBPACK_IMPORTED_MODULE_1__.Vector2) {
            return value.x + ", " + value.y;
        }
        if (value instanceof _Maths_math_vector__WEBPACK_IMPORTED_MODULE_1__.Vector3) {
            return value.x + ", " + value.y + ", " + value.z;
        }
        if (value instanceof _Maths_math_color__WEBPACK_IMPORTED_MODULE_2__.Color3) {
            return value.r + ", " + value.g + ", " + value.b;
        }
        if (value instanceof _Maths_math_color__WEBPACK_IMPORTED_MODULE_2__.Color4) {
            return value.r + ", " + value.g + ", " + value.b + ", " + value.a;
        }
        return value; // string
    };
    /**
     * Internal only
     * @hidden
     */
    Action._GetTargetProperty = function (target) {
        return {
            name: "target",
            targetType: target._isMesh ? "MeshProperties"
                : target._isLight ? "LightProperties"
                    : target._isCamera ? "CameraProperties"
                        : "SceneProperties",
            value: target._isScene ? "Scene" : target.name
        };
    };
    return Action;
}());

_Misc_typeStore__WEBPACK_IMPORTED_MODULE_3__._TypeStore.RegisteredTypes["BABYLON.Action"] = Action;
//# sourceMappingURL=action.js.map

/***/ }),

/***/ "./node_modules/@babylonjs/core/Actions/actionEvent.js":
/*!*************************************************************!*\
  !*** ./node_modules/@babylonjs/core/Actions/actionEvent.js ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ActionEvent": () => (/* binding */ ActionEvent)
/* harmony export */ });
/**
 * ActionEvent is the event being sent when an action is triggered.
 */
var ActionEvent = /** @class */ (function () {
    /**
     * Creates a new ActionEvent
     * @param source The mesh or sprite that triggered the action
     * @param pointerX The X mouse cursor position at the time of the event
     * @param pointerY The Y mouse cursor position at the time of the event
     * @param meshUnderPointer The mesh that is currently pointed at (can be null)
     * @param sourceEvent the original (browser) event that triggered the ActionEvent
     * @param additionalData additional data for the event
     */
    function ActionEvent(
    /** The mesh or sprite that triggered the action */
    source, 
    /** The X mouse cursor position at the time of the event */
    pointerX, 
    /** The Y mouse cursor position at the time of the event */
    pointerY, 
    /** The mesh that is currently pointed at (can be null) */
    meshUnderPointer, 
    /** the original (browser) event that triggered the ActionEvent */
    sourceEvent, 
    /** additional data for the event */
    additionalData) {
        this.source = source;
        this.pointerX = pointerX;
        this.pointerY = pointerY;
        this.meshUnderPointer = meshUnderPointer;
        this.sourceEvent = sourceEvent;
        this.additionalData = additionalData;
    }
    /**
     * Helper function to auto-create an ActionEvent from a source mesh.
     * @param source The source mesh that triggered the event
     * @param evt The original (browser) event
     * @param additionalData additional data for the event
     * @returns the new ActionEvent
     */
    ActionEvent.CreateNew = function (source, evt, additionalData) {
        var scene = source.getScene();
        return new ActionEvent(source, scene.pointerX, scene.pointerY, scene.meshUnderPointer || source, evt, additionalData);
    };
    /**
     * Helper function to auto-create an ActionEvent from a source sprite
     * @param source The source sprite that triggered the event
     * @param scene Scene associated with the sprite
     * @param evt The original (browser) event
     * @param additionalData additional data for the event
     * @returns the new ActionEvent
     */
    ActionEvent.CreateNewFromSprite = function (source, scene, evt, additionalData) {
        return new ActionEvent(source, scene.pointerX, scene.pointerY, scene.meshUnderPointer, evt, additionalData);
    };
    /**
     * Helper function to auto-create an ActionEvent from a scene. If triggered by a mesh use ActionEvent.CreateNew
     * @param scene the scene where the event occurred
     * @param evt The original (browser) event
     * @returns the new ActionEvent
     */
    ActionEvent.CreateNewFromScene = function (scene, evt) {
        return new ActionEvent(null, scene.pointerX, scene.pointerY, scene.meshUnderPointer, evt);
    };
    /**
     * Helper function to auto-create an ActionEvent from a primitive
     * @param prim defines the target primitive
     * @param pointerPos defines the pointer position
     * @param evt The original (browser) event
     * @param additionalData additional data for the event
     * @returns the new ActionEvent
     */
    ActionEvent.CreateNewFromPrimitive = function (prim, pointerPos, evt, additionalData) {
        return new ActionEvent(prim, pointerPos.x, pointerPos.y, null, evt, additionalData);
    };
    return ActionEvent;
}());

//# sourceMappingURL=actionEvent.js.map

/***/ }),

/***/ "./node_modules/@babylonjs/core/Actions/actionManager.js":
/*!***************************************************************!*\
  !*** ./node_modules/@babylonjs/core/Actions/actionManager.js ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ActionManager": () => (/* binding */ ActionManager)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _Maths_math_vector__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../Maths/math.vector */ "./node_modules/@babylonjs/core/Maths/math.vector.js");
/* harmony import */ var _Maths_math_color__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Maths/math.color */ "./node_modules/@babylonjs/core/Maths/math.color.js");
/* harmony import */ var _condition__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./condition */ "./node_modules/@babylonjs/core/Actions/condition.js");
/* harmony import */ var _action__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./action */ "./node_modules/@babylonjs/core/Actions/action.js");
/* harmony import */ var _directActions__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./directActions */ "./node_modules/@babylonjs/core/Actions/directActions.js");
/* harmony import */ var _Engines_engineStore__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../Engines/engineStore */ "./node_modules/@babylonjs/core/Engines/engineStore.js");
/* harmony import */ var _Misc_logger__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../Misc/logger */ "./node_modules/@babylonjs/core/Misc/logger.js");
/* harmony import */ var _Misc_deepCopier__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../Misc/deepCopier */ "./node_modules/@babylonjs/core/Misc/deepCopier.js");
/* harmony import */ var _Misc_typeStore__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../Misc/typeStore */ "./node_modules/@babylonjs/core/Misc/typeStore.js");
/* harmony import */ var _abstractActionManager__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./abstractActionManager */ "./node_modules/@babylonjs/core/Actions/abstractActionManager.js");











/**
 * Action Manager manages all events to be triggered on a given mesh or the global scene.
 * A single scene can have many Action Managers to handle predefined actions on specific meshes.
 * @see http://doc.babylonjs.com/how_to/how_to_use_actions
 */
var ActionManager = /** @class */ (function (_super) {
    (0,tslib__WEBPACK_IMPORTED_MODULE_10__.__extends)(ActionManager, _super);
    /**
     * Creates a new action manager
     * @param scene defines the hosting scene
     */
    function ActionManager(scene) {
        var _this = _super.call(this) || this;
        _this._scene = scene || _Engines_engineStore__WEBPACK_IMPORTED_MODULE_5__.EngineStore.LastCreatedScene;
        scene.actionManagers.push(_this);
        return _this;
    }
    // Methods
    /**
     * Releases all associated resources
     */
    ActionManager.prototype.dispose = function () {
        var index = this._scene.actionManagers.indexOf(this);
        for (var i = 0; i < this.actions.length; i++) {
            var action = this.actions[i];
            ActionManager.Triggers[action.trigger]--;
            if (ActionManager.Triggers[action.trigger] === 0) {
                delete ActionManager.Triggers[action.trigger];
            }
        }
        if (index > -1) {
            this._scene.actionManagers.splice(index, 1);
        }
    };
    /**
     * Gets hosting scene
     * @returns the hosting scene
     */
    ActionManager.prototype.getScene = function () {
        return this._scene;
    };
    /**
     * Does this action manager handles actions of any of the given triggers
     * @param triggers defines the triggers to be tested
     * @return a boolean indicating whether one (or more) of the triggers is handled
     */
    ActionManager.prototype.hasSpecificTriggers = function (triggers) {
        for (var index = 0; index < this.actions.length; index++) {
            var action = this.actions[index];
            if (triggers.indexOf(action.trigger) > -1) {
                return true;
            }
        }
        return false;
    };
    /**
     * Does this action manager handles actions of any of the given triggers. This function takes two arguments for
     * speed.
     * @param triggerA defines the trigger to be tested
     * @param triggerB defines the trigger to be tested
     * @return a boolean indicating whether one (or more) of the triggers is handled
     */
    ActionManager.prototype.hasSpecificTriggers2 = function (triggerA, triggerB) {
        for (var index = 0; index < this.actions.length; index++) {
            var action = this.actions[index];
            if (triggerA == action.trigger || triggerB == action.trigger) {
                return true;
            }
        }
        return false;
    };
    /**
     * Does this action manager handles actions of a given trigger
     * @param trigger defines the trigger to be tested
     * @param parameterPredicate defines an optional predicate to filter triggers by parameter
     * @return whether the trigger is handled
     */
    ActionManager.prototype.hasSpecificTrigger = function (trigger, parameterPredicate) {
        for (var index = 0; index < this.actions.length; index++) {
            var action = this.actions[index];
            if (action.trigger === trigger) {
                if (parameterPredicate) {
                    if (parameterPredicate(action.getTriggerParameter())) {
                        return true;
                    }
                }
                else {
                    return true;
                }
            }
        }
        return false;
    };
    Object.defineProperty(ActionManager.prototype, "hasPointerTriggers", {
        /**
         * Does this action manager has pointer triggers
         */
        get: function () {
            for (var index = 0; index < this.actions.length; index++) {
                var action = this.actions[index];
                if (action.trigger >= ActionManager.OnPickTrigger && action.trigger <= ActionManager.OnPointerOutTrigger) {
                    return true;
                }
            }
            return false;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(ActionManager.prototype, "hasPickTriggers", {
        /**
         * Does this action manager has pick triggers
         */
        get: function () {
            for (var index = 0; index < this.actions.length; index++) {
                var action = this.actions[index];
                if (action.trigger >= ActionManager.OnPickTrigger && action.trigger <= ActionManager.OnPickUpTrigger) {
                    return true;
                }
            }
            return false;
        },
        enumerable: true,
        configurable: true
    });
    /**
     * Registers an action to this action manager
     * @param action defines the action to be registered
     * @return the action amended (prepared) after registration
     */
    ActionManager.prototype.registerAction = function (action) {
        if (action.trigger === ActionManager.OnEveryFrameTrigger) {
            if (this.getScene().actionManager !== this) {
                _Misc_logger__WEBPACK_IMPORTED_MODULE_6__.Logger.Warn("OnEveryFrameTrigger can only be used with scene.actionManager");
                return null;
            }
        }
        this.actions.push(action);
        if (ActionManager.Triggers[action.trigger]) {
            ActionManager.Triggers[action.trigger]++;
        }
        else {
            ActionManager.Triggers[action.trigger] = 1;
        }
        action._actionManager = this;
        action._prepare();
        return action;
    };
    /**
     * Unregisters an action to this action manager
     * @param action defines the action to be unregistered
     * @return a boolean indicating whether the action has been unregistered
     */
    ActionManager.prototype.unregisterAction = function (action) {
        var index = this.actions.indexOf(action);
        if (index !== -1) {
            this.actions.splice(index, 1);
            ActionManager.Triggers[action.trigger] -= 1;
            if (ActionManager.Triggers[action.trigger] === 0) {
                delete ActionManager.Triggers[action.trigger];
            }
            delete action._actionManager;
            return true;
        }
        return false;
    };
    /**
     * Process a specific trigger
     * @param trigger defines the trigger to process
     * @param evt defines the event details to be processed
     */
    ActionManager.prototype.processTrigger = function (trigger, evt) {
        for (var index = 0; index < this.actions.length; index++) {
            var action = this.actions[index];
            if (action.trigger === trigger) {
                if (evt) {
                    if (trigger === ActionManager.OnKeyUpTrigger
                        || trigger === ActionManager.OnKeyDownTrigger) {
                        var parameter = action.getTriggerParameter();
                        if (parameter && parameter !== evt.sourceEvent.keyCode) {
                            if (!parameter.toLowerCase) {
                                continue;
                            }
                            var lowerCase = parameter.toLowerCase();
                            if (lowerCase !== evt.sourceEvent.key) {
                                var unicode = evt.sourceEvent.charCode ? evt.sourceEvent.charCode : evt.sourceEvent.keyCode;
                                var actualkey = String.fromCharCode(unicode).toLowerCase();
                                if (actualkey !== lowerCase) {
                                    continue;
                                }
                            }
                        }
                    }
                }
                action._executeCurrent(evt);
            }
        }
    };
    /** @hidden */
    ActionManager.prototype._getEffectiveTarget = function (target, propertyPath) {
        var properties = propertyPath.split(".");
        for (var index = 0; index < properties.length - 1; index++) {
            target = target[properties[index]];
        }
        return target;
    };
    /** @hidden */
    ActionManager.prototype._getProperty = function (propertyPath) {
        var properties = propertyPath.split(".");
        return properties[properties.length - 1];
    };
    /**
     * Serialize this manager to a JSON object
     * @param name defines the property name to store this manager
     * @returns a JSON representation of this manager
     */
    ActionManager.prototype.serialize = function (name) {
        var root = {
            children: new Array(),
            name: name,
            type: 3,
            properties: new Array() // Empty for root but required
        };
        for (var i = 0; i < this.actions.length; i++) {
            var triggerObject = {
                type: 0,
                children: new Array(),
                name: ActionManager.GetTriggerName(this.actions[i].trigger),
                properties: new Array()
            };
            var triggerOptions = this.actions[i].triggerOptions;
            if (triggerOptions && typeof triggerOptions !== "number") {
                if (triggerOptions.parameter instanceof Node) {
                    triggerObject.properties.push(_action__WEBPACK_IMPORTED_MODULE_3__.Action._GetTargetProperty(triggerOptions.parameter));
                }
                else {
                    var parameter = {};
                    _Misc_deepCopier__WEBPACK_IMPORTED_MODULE_7__.DeepCopier.DeepCopy(triggerOptions.parameter, parameter, ["mesh"]);
                    if (triggerOptions.parameter && triggerOptions.parameter.mesh) {
                        parameter._meshId = triggerOptions.parameter.mesh.id;
                    }
                    triggerObject.properties.push({ name: "parameter", targetType: null, value: parameter });
                }
            }
            // Serialize child action, recursively
            this.actions[i].serialize(triggerObject);
            // Add serialized trigger
            root.children.push(triggerObject);
        }
        return root;
    };
    /**
     * Creates a new ActionManager from a JSON data
     * @param parsedActions defines the JSON data to read from
     * @param object defines the hosting mesh
     * @param scene defines the hosting scene
     */
    ActionManager.Parse = function (parsedActions, object, scene) {
        var actionManager = new ActionManager(scene);
        if (object === null) {
            scene.actionManager = actionManager;
        }
        else {
            object.actionManager = actionManager;
        }
        // instanciate a new object
        var instanciate = function (name, params) {
            var internalClassType = _Misc_typeStore__WEBPACK_IMPORTED_MODULE_8__._TypeStore.GetClass("BABYLON." + name);
            if (internalClassType) {
                var newInstance = Object.create(internalClassType.prototype);
                newInstance.constructor.apply(newInstance, params);
                return newInstance;
            }
        };
        var parseParameter = function (name, value, target, propertyPath) {
            if (propertyPath === null) {
                // String, boolean or float
                var floatValue = parseFloat(value);
                if (value === "true" || value === "false") {
                    return value === "true";
                }
                else {
                    return isNaN(floatValue) ? value : floatValue;
                }
            }
            var effectiveTarget = propertyPath.split(".");
            var values = value.split(",");
            // Get effective Target
            for (var i = 0; i < effectiveTarget.length; i++) {
                target = target[effectiveTarget[i]];
            }
            // Return appropriate value with its type
            if (typeof (target) === "boolean") {
                return values[0] === "true";
            }
            if (typeof (target) === "string") {
                return values[0];
            }
            // Parameters with multiple values such as Vector3 etc.
            var split = new Array();
            for (var i = 0; i < values.length; i++) {
                split.push(parseFloat(values[i]));
            }
            if (target instanceof _Maths_math_vector__WEBPACK_IMPORTED_MODULE_0__.Vector3) {
                return _Maths_math_vector__WEBPACK_IMPORTED_MODULE_0__.Vector3.FromArray(split);
            }
            if (target instanceof _Maths_math_vector__WEBPACK_IMPORTED_MODULE_0__.Vector4) {
                return _Maths_math_vector__WEBPACK_IMPORTED_MODULE_0__.Vector4.FromArray(split);
            }
            if (target instanceof _Maths_math_color__WEBPACK_IMPORTED_MODULE_1__.Color3) {
                return _Maths_math_color__WEBPACK_IMPORTED_MODULE_1__.Color3.FromArray(split);
            }
            if (target instanceof _Maths_math_color__WEBPACK_IMPORTED_MODULE_1__.Color4) {
                return _Maths_math_color__WEBPACK_IMPORTED_MODULE_1__.Color4.FromArray(split);
            }
            return parseFloat(values[0]);
        };
        // traverse graph per trigger
        var traverse = function (parsedAction, trigger, condition, action, combineArray) {
            if (combineArray === void 0) { combineArray = null; }
            if (parsedAction.detached) {
                return;
            }
            var parameters = new Array();
            var target = null;
            var propertyPath = null;
            var combine = parsedAction.combine && parsedAction.combine.length > 0;
            // Parameters
            if (parsedAction.type === 2) {
                parameters.push(actionManager);
            }
            else {
                parameters.push(trigger);
            }
            if (combine) {
                var actions = new Array();
                for (var j = 0; j < parsedAction.combine.length; j++) {
                    traverse(parsedAction.combine[j], ActionManager.NothingTrigger, condition, action, actions);
                }
                parameters.push(actions);
            }
            else {
                for (var i = 0; i < parsedAction.properties.length; i++) {
                    var value = parsedAction.properties[i].value;
                    var name = parsedAction.properties[i].name;
                    var targetType = parsedAction.properties[i].targetType;
                    if (name === "target") {
                        if (targetType !== null && targetType === "SceneProperties") {
                            value = target = scene;
                        }
                        else {
                            value = target = scene.getNodeByName(value);
                        }
                    }
                    else if (name === "parent") {
                        value = scene.getNodeByName(value);
                    }
                    else if (name === "sound") {
                        // Can not externalize to component, so only checks for the presence off the API.
                        if (scene.getSoundByName) {
                            value = scene.getSoundByName(value);
                        }
                    }
                    else if (name !== "propertyPath") {
                        if (parsedAction.type === 2 && name === "operator") {
                            value = _condition__WEBPACK_IMPORTED_MODULE_2__.ValueCondition[value];
                        }
                        else {
                            value = parseParameter(name, value, target, name === "value" ? propertyPath : null);
                        }
                    }
                    else {
                        propertyPath = value;
                    }
                    parameters.push(value);
                }
            }
            if (combineArray === null) {
                parameters.push(condition);
            }
            else {
                parameters.push(null);
            }
            // If interpolate value action
            if (parsedAction.name === "InterpolateValueAction") {
                var param = parameters[parameters.length - 2];
                parameters[parameters.length - 1] = param;
                parameters[parameters.length - 2] = condition;
            }
            // Action or condition(s) and not CombineAction
            var newAction = instanciate(parsedAction.name, parameters);
            if (newAction instanceof _condition__WEBPACK_IMPORTED_MODULE_2__.Condition && condition !== null) {
                var nothing = new _directActions__WEBPACK_IMPORTED_MODULE_4__.DoNothingAction(trigger, condition);
                if (action) {
                    action.then(nothing);
                }
                else {
                    actionManager.registerAction(nothing);
                }
                action = nothing;
            }
            if (combineArray === null) {
                if (newAction instanceof _condition__WEBPACK_IMPORTED_MODULE_2__.Condition) {
                    condition = newAction;
                    newAction = action;
                }
                else {
                    condition = null;
                    if (action) {
                        action.then(newAction);
                    }
                    else {
                        actionManager.registerAction(newAction);
                    }
                }
            }
            else {
                combineArray.push(newAction);
            }
            for (var i = 0; i < parsedAction.children.length; i++) {
                traverse(parsedAction.children[i], trigger, condition, newAction, null);
            }
        };
        // triggers
        for (var i = 0; i < parsedActions.children.length; i++) {
            var triggerParams;
            var trigger = parsedActions.children[i];
            if (trigger.properties.length > 0) {
                var param = trigger.properties[0].value;
                var value = trigger.properties[0].targetType === null ? param : scene.getMeshByName(param);
                if (value._meshId) {
                    value.mesh = scene.getMeshByID(value._meshId);
                }
                triggerParams = { trigger: ActionManager[trigger.name], parameter: value };
            }
            else {
                triggerParams = ActionManager[trigger.name];
            }
            for (var j = 0; j < trigger.children.length; j++) {
                if (!trigger.detached) {
                    traverse(trigger.children[j], triggerParams, null, null);
                }
            }
        }
    };
    /**
     * Get a trigger name by index
     * @param trigger defines the trigger index
     * @returns a trigger name
     */
    ActionManager.GetTriggerName = function (trigger) {
        switch (trigger) {
            case 0: return "NothingTrigger";
            case 1: return "OnPickTrigger";
            case 2: return "OnLeftPickTrigger";
            case 3: return "OnRightPickTrigger";
            case 4: return "OnCenterPickTrigger";
            case 5: return "OnPickDownTrigger";
            case 6: return "OnPickUpTrigger";
            case 7: return "OnLongPressTrigger";
            case 8: return "OnPointerOverTrigger";
            case 9: return "OnPointerOutTrigger";
            case 10: return "OnEveryFrameTrigger";
            case 11: return "OnIntersectionEnterTrigger";
            case 12: return "OnIntersectionExitTrigger";
            case 13: return "OnKeyDownTrigger";
            case 14: return "OnKeyUpTrigger";
            case 15: return "OnPickOutTrigger";
            default: return "";
        }
    };
    /**
     * Nothing
     * @see http://doc.babylonjs.com/how_to/how_to_use_actions#triggers
     */
    ActionManager.NothingTrigger = 0;
    /**
     * On pick
     * @see http://doc.babylonjs.com/how_to/how_to_use_actions#triggers
     */
    ActionManager.OnPickTrigger = 1;
    /**
     * On left pick
     * @see http://doc.babylonjs.com/how_to/how_to_use_actions#triggers
     */
    ActionManager.OnLeftPickTrigger = 2;
    /**
     * On right pick
     * @see http://doc.babylonjs.com/how_to/how_to_use_actions#triggers
     */
    ActionManager.OnRightPickTrigger = 3;
    /**
     * On center pick
     * @see http://doc.babylonjs.com/how_to/how_to_use_actions#triggers
     */
    ActionManager.OnCenterPickTrigger = 4;
    /**
     * On pick down
     * @see http://doc.babylonjs.com/how_to/how_to_use_actions#triggers
     */
    ActionManager.OnPickDownTrigger = 5;
    /**
     * On double pick
     * @see http://doc.babylonjs.com/how_to/how_to_use_actions#triggers
     */
    ActionManager.OnDoublePickTrigger = 6;
    /**
     * On pick up
     * @see http://doc.babylonjs.com/how_to/how_to_use_actions#triggers
     */
    ActionManager.OnPickUpTrigger = 7;
    /**
     * On pick out.
     * This trigger will only be raised if you also declared a OnPickDown
     * @see http://doc.babylonjs.com/how_to/how_to_use_actions#triggers
     */
    ActionManager.OnPickOutTrigger = 16;
    /**
     * On long press
     * @see http://doc.babylonjs.com/how_to/how_to_use_actions#triggers
     */
    ActionManager.OnLongPressTrigger = 8;
    /**
     * On pointer over
     * @see http://doc.babylonjs.com/how_to/how_to_use_actions#triggers
     */
    ActionManager.OnPointerOverTrigger = 9;
    /**
     * On pointer out
     * @see http://doc.babylonjs.com/how_to/how_to_use_actions#triggers
     */
    ActionManager.OnPointerOutTrigger = 10;
    /**
     * On every frame
     * @see http://doc.babylonjs.com/how_to/how_to_use_actions#triggers
     */
    ActionManager.OnEveryFrameTrigger = 11;
    /**
     * On intersection enter
     * @see http://doc.babylonjs.com/how_to/how_to_use_actions#triggers
     */
    ActionManager.OnIntersectionEnterTrigger = 12;
    /**
     * On intersection exit
     * @see http://doc.babylonjs.com/how_to/how_to_use_actions#triggers
     */
    ActionManager.OnIntersectionExitTrigger = 13;
    /**
     * On key down
     * @see http://doc.babylonjs.com/how_to/how_to_use_actions#triggers
     */
    ActionManager.OnKeyDownTrigger = 14;
    /**
     * On key up
     * @see http://doc.babylonjs.com/how_to/how_to_use_actions#triggers
     */
    ActionManager.OnKeyUpTrigger = 15;
    return ActionManager;
}(_abstractActionManager__WEBPACK_IMPORTED_MODULE_9__.AbstractActionManager));

//# sourceMappingURL=actionManager.js.map

/***/ }),

/***/ "./node_modules/@babylonjs/core/Actions/condition.js":
/*!***********************************************************!*\
  !*** ./node_modules/@babylonjs/core/Actions/condition.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Condition": () => (/* binding */ Condition),
/* harmony export */   "PredicateCondition": () => (/* binding */ PredicateCondition),
/* harmony export */   "StateCondition": () => (/* binding */ StateCondition),
/* harmony export */   "ValueCondition": () => (/* binding */ ValueCondition)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _action__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./action */ "./node_modules/@babylonjs/core/Actions/action.js");
/* harmony import */ var _Misc_typeStore__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Misc/typeStore */ "./node_modules/@babylonjs/core/Misc/typeStore.js");



/**
 * A Condition applied to an Action
 */
var Condition = /** @class */ (function () {
    /**
     * Creates a new Condition
     * @param actionManager the manager of the action the condition is applied to
     */
    function Condition(actionManager) {
        this._actionManager = actionManager;
    }
    /**
     * Check if the current condition is valid
     * @returns a boolean
     */
    Condition.prototype.isValid = function () {
        return true;
    };
    /**
     * Internal only
     * @hidden
     */
    Condition.prototype._getProperty = function (propertyPath) {
        return this._actionManager._getProperty(propertyPath);
    };
    /**
     * Internal only
     * @hidden
     */
    Condition.prototype._getEffectiveTarget = function (target, propertyPath) {
        return this._actionManager._getEffectiveTarget(target, propertyPath);
    };
    /**
     * Serialize placeholder for child classes
     * @returns the serialized object
     */
    Condition.prototype.serialize = function () {
    };
    /**
     * Internal only
     * @hidden
     */
    Condition.prototype._serialize = function (serializedCondition) {
        return {
            type: 2,
            children: [],
            name: serializedCondition.name,
            properties: serializedCondition.properties
        };
    };
    return Condition;
}());

/**
 * Defines specific conditional operators as extensions of Condition
 */
var ValueCondition = /** @class */ (function (_super) {
    (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__extends)(ValueCondition, _super);
    /**
     * Creates a new ValueCondition
     * @param actionManager manager for the action the condition applies to
     * @param target for the action
     * @param propertyPath path to specify the property of the target the conditional operator uses
     * @param value the value compared by the conditional operator against the current value of the property
     * @param operator the conditional operator, default ValueCondition.IsEqual
     */
    function ValueCondition(actionManager, target, 
    /** path to specify the property of the target the conditional operator uses  */
    propertyPath, 
    /** the value compared by the conditional operator against the current value of the property */
    value, 
    /** the conditional operator, default ValueCondition.IsEqual */
    operator) {
        if (operator === void 0) { operator = ValueCondition.IsEqual; }
        var _this = _super.call(this, actionManager) || this;
        _this.propertyPath = propertyPath;
        _this.value = value;
        _this.operator = operator;
        _this._target = target;
        _this._effectiveTarget = _this._getEffectiveTarget(target, _this.propertyPath);
        _this._property = _this._getProperty(_this.propertyPath);
        return _this;
    }
    Object.defineProperty(ValueCondition, "IsEqual", {
        /**
         * returns the number for IsEqual
         */
        get: function () {
            return ValueCondition._IsEqual;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(ValueCondition, "IsDifferent", {
        /**
         * Returns the number for IsDifferent
         */
        get: function () {
            return ValueCondition._IsDifferent;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(ValueCondition, "IsGreater", {
        /**
         * Returns the number for IsGreater
         */
        get: function () {
            return ValueCondition._IsGreater;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(ValueCondition, "IsLesser", {
        /**
         * Returns the number for IsLesser
         */
        get: function () {
            return ValueCondition._IsLesser;
        },
        enumerable: true,
        configurable: true
    });
    /**
     * Compares the given value with the property value for the specified conditional operator
     * @returns the result of the comparison
     */
    ValueCondition.prototype.isValid = function () {
        switch (this.operator) {
            case ValueCondition.IsGreater:
                return this._effectiveTarget[this._property] > this.value;
            case ValueCondition.IsLesser:
                return this._effectiveTarget[this._property] < this.value;
            case ValueCondition.IsEqual:
            case ValueCondition.IsDifferent:
                var check;
                if (this.value.equals) {
                    check = this.value.equals(this._effectiveTarget[this._property]);
                }
                else {
                    check = this.value === this._effectiveTarget[this._property];
                }
                return this.operator === ValueCondition.IsEqual ? check : !check;
        }
        return false;
    };
    /**
     * Serialize the ValueCondition into a JSON compatible object
     * @returns serialization object
     */
    ValueCondition.prototype.serialize = function () {
        return this._serialize({
            name: "ValueCondition",
            properties: [
                _action__WEBPACK_IMPORTED_MODULE_0__.Action._GetTargetProperty(this._target),
                { name: "propertyPath", value: this.propertyPath },
                { name: "value", value: _action__WEBPACK_IMPORTED_MODULE_0__.Action._SerializeValueAsString(this.value) },
                { name: "operator", value: ValueCondition.GetOperatorName(this.operator) }
            ]
        });
    };
    /**
     * Gets the name of the conditional operator for the ValueCondition
     * @param operator the conditional operator
     * @returns the name
     */
    ValueCondition.GetOperatorName = function (operator) {
        switch (operator) {
            case ValueCondition._IsEqual: return "IsEqual";
            case ValueCondition._IsDifferent: return "IsDifferent";
            case ValueCondition._IsGreater: return "IsGreater";
            case ValueCondition._IsLesser: return "IsLesser";
            default: return "";
        }
    };
    /**
     * Internal only
     * @hidden
     */
    ValueCondition._IsEqual = 0;
    /**
     * Internal only
     * @hidden
     */
    ValueCondition._IsDifferent = 1;
    /**
     * Internal only
     * @hidden
     */
    ValueCondition._IsGreater = 2;
    /**
     * Internal only
     * @hidden
     */
    ValueCondition._IsLesser = 3;
    return ValueCondition;
}(Condition));

/**
 * Defines a predicate condition as an extension of Condition
 */
var PredicateCondition = /** @class */ (function (_super) {
    (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__extends)(PredicateCondition, _super);
    /**
     * Creates a new PredicateCondition
     * @param actionManager manager for the action the condition applies to
     * @param predicate defines the predicate function used to validate the condition
     */
    function PredicateCondition(actionManager, 
    /** defines the predicate function used to validate the condition */
    predicate) {
        var _this = _super.call(this, actionManager) || this;
        _this.predicate = predicate;
        return _this;
    }
    /**
     * @returns the validity of the predicate condition
     */
    PredicateCondition.prototype.isValid = function () {
        return this.predicate();
    };
    return PredicateCondition;
}(Condition));

/**
 * Defines a state condition as an extension of Condition
 */
var StateCondition = /** @class */ (function (_super) {
    (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__extends)(StateCondition, _super);
    /**
     * Creates a new StateCondition
     * @param actionManager manager for the action the condition applies to
     * @param target of the condition
     * @param value to compare with target state
     */
    function StateCondition(actionManager, target, 
    /** Value to compare with target state  */
    value) {
        var _this = _super.call(this, actionManager) || this;
        _this.value = value;
        _this._target = target;
        return _this;
    }
    /**
     * Gets a boolean indicating if the current condition is met
     * @returns the validity of the state
     */
    StateCondition.prototype.isValid = function () {
        return this._target.state === this.value;
    };
    /**
     * Serialize the StateCondition into a JSON compatible object
     * @returns serialization object
     */
    StateCondition.prototype.serialize = function () {
        return this._serialize({
            name: "StateCondition",
            properties: [
                _action__WEBPACK_IMPORTED_MODULE_0__.Action._GetTargetProperty(this._target),
                { name: "value", value: this.value }
            ]
        });
    };
    return StateCondition;
}(Condition));

_Misc_typeStore__WEBPACK_IMPORTED_MODULE_1__._TypeStore.RegisteredTypes["BABYLON.ValueCondition"] = ValueCondition;
_Misc_typeStore__WEBPACK_IMPORTED_MODULE_1__._TypeStore.RegisteredTypes["BABYLON.PredicateCondition"] = PredicateCondition;
_Misc_typeStore__WEBPACK_IMPORTED_MODULE_1__._TypeStore.RegisteredTypes["BABYLON.StateCondition"] = StateCondition;
//# sourceMappingURL=condition.js.map

/***/ }),

/***/ "./node_modules/@babylonjs/core/Actions/directActions.js":
/*!***************************************************************!*\
  !*** ./node_modules/@babylonjs/core/Actions/directActions.js ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "CombineAction": () => (/* binding */ CombineAction),
/* harmony export */   "DoNothingAction": () => (/* binding */ DoNothingAction),
/* harmony export */   "ExecuteCodeAction": () => (/* binding */ ExecuteCodeAction),
/* harmony export */   "IncrementValueAction": () => (/* binding */ IncrementValueAction),
/* harmony export */   "PlayAnimationAction": () => (/* binding */ PlayAnimationAction),
/* harmony export */   "SetParentAction": () => (/* binding */ SetParentAction),
/* harmony export */   "SetStateAction": () => (/* binding */ SetStateAction),
/* harmony export */   "SetValueAction": () => (/* binding */ SetValueAction),
/* harmony export */   "StopAnimationAction": () => (/* binding */ StopAnimationAction),
/* harmony export */   "SwitchBooleanAction": () => (/* binding */ SwitchBooleanAction)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _Misc_logger__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../Misc/logger */ "./node_modules/@babylonjs/core/Misc/logger.js");
/* harmony import */ var _Maths_math_vector__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Maths/math.vector */ "./node_modules/@babylonjs/core/Maths/math.vector.js");
/* harmony import */ var _action__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./action */ "./node_modules/@babylonjs/core/Actions/action.js");
/* harmony import */ var _Misc_typeStore__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../Misc/typeStore */ "./node_modules/@babylonjs/core/Misc/typeStore.js");





/**
 * This defines an action responsible to toggle a boolean once triggered.
 * @see http://doc.babylonjs.com/how_to/how_to_use_actions
 */
var SwitchBooleanAction = /** @class */ (function (_super) {
    (0,tslib__WEBPACK_IMPORTED_MODULE_4__.__extends)(SwitchBooleanAction, _super);
    /**
     * Instantiate the action
     * @param triggerOptions defines the trigger options
     * @param target defines the object containing the boolean
     * @param propertyPath defines the path to the boolean property in the target object
     * @param condition defines the trigger related conditions
     */
    function SwitchBooleanAction(triggerOptions, target, propertyPath, condition) {
        var _this = _super.call(this, triggerOptions, condition) || this;
        _this.propertyPath = propertyPath;
        _this._target = _this._effectiveTarget = target;
        return _this;
    }
    /** @hidden */
    SwitchBooleanAction.prototype._prepare = function () {
        this._effectiveTarget = this._getEffectiveTarget(this._effectiveTarget, this.propertyPath);
        this._property = this._getProperty(this.propertyPath);
    };
    /**
     * Execute the action toggle the boolean value.
     */
    SwitchBooleanAction.prototype.execute = function () {
        this._effectiveTarget[this._property] = !this._effectiveTarget[this._property];
    };
    /**
     * Serializes the actions and its related information.
     * @param parent defines the object to serialize in
     * @returns the serialized object
     */
    SwitchBooleanAction.prototype.serialize = function (parent) {
        return _super.prototype._serialize.call(this, {
            name: "SwitchBooleanAction",
            properties: [
                _action__WEBPACK_IMPORTED_MODULE_2__.Action._GetTargetProperty(this._target),
                { name: "propertyPath", value: this.propertyPath }
            ]
        }, parent);
    };
    return SwitchBooleanAction;
}(_action__WEBPACK_IMPORTED_MODULE_2__.Action));

/**
 * This defines an action responsible to set a the state field of the target
 *  to a desired value once triggered.
 * @see http://doc.babylonjs.com/how_to/how_to_use_actions
 */
var SetStateAction = /** @class */ (function (_super) {
    (0,tslib__WEBPACK_IMPORTED_MODULE_4__.__extends)(SetStateAction, _super);
    /**
     * Instantiate the action
     * @param triggerOptions defines the trigger options
     * @param target defines the object containing the state property
     * @param value defines the value to store in the state field
     * @param condition defines the trigger related conditions
     */
    function SetStateAction(triggerOptions, target, value, condition) {
        var _this = _super.call(this, triggerOptions, condition) || this;
        _this.value = value;
        _this._target = target;
        return _this;
    }
    /**
     * Execute the action and store the value on the target state property.
     */
    SetStateAction.prototype.execute = function () {
        this._target.state = this.value;
    };
    /**
     * Serializes the actions and its related information.
     * @param parent defines the object to serialize in
     * @returns the serialized object
     */
    SetStateAction.prototype.serialize = function (parent) {
        return _super.prototype._serialize.call(this, {
            name: "SetStateAction",
            properties: [
                _action__WEBPACK_IMPORTED_MODULE_2__.Action._GetTargetProperty(this._target),
                { name: "value", value: this.value }
            ]
        }, parent);
    };
    return SetStateAction;
}(_action__WEBPACK_IMPORTED_MODULE_2__.Action));

/**
 * This defines an action responsible to set a property of the target
 *  to a desired value once triggered.
 * @see http://doc.babylonjs.com/how_to/how_to_use_actions
 */
var SetValueAction = /** @class */ (function (_super) {
    (0,tslib__WEBPACK_IMPORTED_MODULE_4__.__extends)(SetValueAction, _super);
    /**
     * Instantiate the action
     * @param triggerOptions defines the trigger options
     * @param target defines the object containing the property
     * @param propertyPath defines the path of the property to set in the target
     * @param value defines the value to set in the property
     * @param condition defines the trigger related conditions
     */
    function SetValueAction(triggerOptions, target, propertyPath, value, condition) {
        var _this = _super.call(this, triggerOptions, condition) || this;
        _this.propertyPath = propertyPath;
        _this.value = value;
        _this._target = _this._effectiveTarget = target;
        return _this;
    }
    /** @hidden */
    SetValueAction.prototype._prepare = function () {
        this._effectiveTarget = this._getEffectiveTarget(this._effectiveTarget, this.propertyPath);
        this._property = this._getProperty(this.propertyPath);
    };
    /**
     * Execute the action and set the targetted property to the desired value.
     */
    SetValueAction.prototype.execute = function () {
        this._effectiveTarget[this._property] = this.value;
        if (this._target.markAsDirty) {
            this._target.markAsDirty(this._property);
        }
    };
    /**
     * Serializes the actions and its related information.
     * @param parent defines the object to serialize in
     * @returns the serialized object
     */
    SetValueAction.prototype.serialize = function (parent) {
        return _super.prototype._serialize.call(this, {
            name: "SetValueAction",
            properties: [
                _action__WEBPACK_IMPORTED_MODULE_2__.Action._GetTargetProperty(this._target),
                { name: "propertyPath", value: this.propertyPath },
                { name: "value", value: _action__WEBPACK_IMPORTED_MODULE_2__.Action._SerializeValueAsString(this.value) }
            ]
        }, parent);
    };
    return SetValueAction;
}(_action__WEBPACK_IMPORTED_MODULE_2__.Action));

/**
 * This defines an action responsible to increment the target value
 *  to a desired value once triggered.
 * @see http://doc.babylonjs.com/how_to/how_to_use_actions
 */
var IncrementValueAction = /** @class */ (function (_super) {
    (0,tslib__WEBPACK_IMPORTED_MODULE_4__.__extends)(IncrementValueAction, _super);
    /**
     * Instantiate the action
     * @param triggerOptions defines the trigger options
     * @param target defines the object containing the property
     * @param propertyPath defines the path of the property to increment in the target
     * @param value defines the value value we should increment the property by
     * @param condition defines the trigger related conditions
     */
    function IncrementValueAction(triggerOptions, target, propertyPath, value, condition) {
        var _this = _super.call(this, triggerOptions, condition) || this;
        _this.propertyPath = propertyPath;
        _this.value = value;
        _this._target = _this._effectiveTarget = target;
        return _this;
    }
    /** @hidden */
    IncrementValueAction.prototype._prepare = function () {
        this._effectiveTarget = this._getEffectiveTarget(this._effectiveTarget, this.propertyPath);
        this._property = this._getProperty(this.propertyPath);
        if (typeof this._effectiveTarget[this._property] !== "number") {
            _Misc_logger__WEBPACK_IMPORTED_MODULE_0__.Logger.Warn("Warning: IncrementValueAction can only be used with number values");
        }
    };
    /**
     * Execute the action and increment the target of the value amount.
     */
    IncrementValueAction.prototype.execute = function () {
        this._effectiveTarget[this._property] += this.value;
        if (this._target.markAsDirty) {
            this._target.markAsDirty(this._property);
        }
    };
    /**
     * Serializes the actions and its related information.
     * @param parent defines the object to serialize in
     * @returns the serialized object
     */
    IncrementValueAction.prototype.serialize = function (parent) {
        return _super.prototype._serialize.call(this, {
            name: "IncrementValueAction",
            properties: [
                _action__WEBPACK_IMPORTED_MODULE_2__.Action._GetTargetProperty(this._target),
                { name: "propertyPath", value: this.propertyPath },
                { name: "value", value: _action__WEBPACK_IMPORTED_MODULE_2__.Action._SerializeValueAsString(this.value) }
            ]
        }, parent);
    };
    return IncrementValueAction;
}(_action__WEBPACK_IMPORTED_MODULE_2__.Action));

/**
 * This defines an action responsible to start an animation once triggered.
 * @see http://doc.babylonjs.com/how_to/how_to_use_actions
 */
var PlayAnimationAction = /** @class */ (function (_super) {
    (0,tslib__WEBPACK_IMPORTED_MODULE_4__.__extends)(PlayAnimationAction, _super);
    /**
     * Instantiate the action
     * @param triggerOptions defines the trigger options
     * @param target defines the target animation or animation name
     * @param from defines from where the animation should start (animation frame)
     * @param end defines where the animation should stop (animation frame)
     * @param loop defines if the animation should loop or stop after the first play
     * @param condition defines the trigger related conditions
     */
    function PlayAnimationAction(triggerOptions, target, from, to, loop, condition) {
        var _this = _super.call(this, triggerOptions, condition) || this;
        _this.from = from;
        _this.to = to;
        _this.loop = loop;
        _this._target = target;
        return _this;
    }
    /** @hidden */
    PlayAnimationAction.prototype._prepare = function () {
    };
    /**
     * Execute the action and play the animation.
     */
    PlayAnimationAction.prototype.execute = function () {
        var scene = this._actionManager.getScene();
        scene.beginAnimation(this._target, this.from, this.to, this.loop);
    };
    /**
     * Serializes the actions and its related information.
     * @param parent defines the object to serialize in
     * @returns the serialized object
     */
    PlayAnimationAction.prototype.serialize = function (parent) {
        return _super.prototype._serialize.call(this, {
            name: "PlayAnimationAction",
            properties: [
                _action__WEBPACK_IMPORTED_MODULE_2__.Action._GetTargetProperty(this._target),
                { name: "from", value: String(this.from) },
                { name: "to", value: String(this.to) },
                { name: "loop", value: _action__WEBPACK_IMPORTED_MODULE_2__.Action._SerializeValueAsString(this.loop) || false }
            ]
        }, parent);
    };
    return PlayAnimationAction;
}(_action__WEBPACK_IMPORTED_MODULE_2__.Action));

/**
 * This defines an action responsible to stop an animation once triggered.
 * @see http://doc.babylonjs.com/how_to/how_to_use_actions
 */
var StopAnimationAction = /** @class */ (function (_super) {
    (0,tslib__WEBPACK_IMPORTED_MODULE_4__.__extends)(StopAnimationAction, _super);
    /**
     * Instantiate the action
     * @param triggerOptions defines the trigger options
     * @param target defines the target animation or animation name
     * @param condition defines the trigger related conditions
     */
    function StopAnimationAction(triggerOptions, target, condition) {
        var _this = _super.call(this, triggerOptions, condition) || this;
        _this._target = target;
        return _this;
    }
    /** @hidden */
    StopAnimationAction.prototype._prepare = function () {
    };
    /**
     * Execute the action and stop the animation.
     */
    StopAnimationAction.prototype.execute = function () {
        var scene = this._actionManager.getScene();
        scene.stopAnimation(this._target);
    };
    /**
     * Serializes the actions and its related information.
     * @param parent defines the object to serialize in
     * @returns the serialized object
     */
    StopAnimationAction.prototype.serialize = function (parent) {
        return _super.prototype._serialize.call(this, {
            name: "StopAnimationAction",
            properties: [_action__WEBPACK_IMPORTED_MODULE_2__.Action._GetTargetProperty(this._target)]
        }, parent);
    };
    return StopAnimationAction;
}(_action__WEBPACK_IMPORTED_MODULE_2__.Action));

/**
 * This defines an action responsible that does nothing once triggered.
 * @see http://doc.babylonjs.com/how_to/how_to_use_actions
 */
var DoNothingAction = /** @class */ (function (_super) {
    (0,tslib__WEBPACK_IMPORTED_MODULE_4__.__extends)(DoNothingAction, _super);
    /**
     * Instantiate the action
     * @param triggerOptions defines the trigger options
     * @param condition defines the trigger related conditions
     */
    function DoNothingAction(triggerOptions, condition) {
        if (triggerOptions === void 0) { triggerOptions = 0; }
        return _super.call(this, triggerOptions, condition) || this;
    }
    /**
     * Execute the action and do nothing.
     */
    DoNothingAction.prototype.execute = function () {
    };
    /**
     * Serializes the actions and its related information.
     * @param parent defines the object to serialize in
     * @returns the serialized object
     */
    DoNothingAction.prototype.serialize = function (parent) {
        return _super.prototype._serialize.call(this, {
            name: "DoNothingAction",
            properties: []
        }, parent);
    };
    return DoNothingAction;
}(_action__WEBPACK_IMPORTED_MODULE_2__.Action));

/**
 * This defines an action responsible to trigger several actions once triggered.
 * @see http://doc.babylonjs.com/how_to/how_to_use_actions
 */
var CombineAction = /** @class */ (function (_super) {
    (0,tslib__WEBPACK_IMPORTED_MODULE_4__.__extends)(CombineAction, _super);
    /**
     * Instantiate the action
     * @param triggerOptions defines the trigger options
     * @param children defines the list of aggregated animations to run
     * @param condition defines the trigger related conditions
     */
    function CombineAction(triggerOptions, children, condition) {
        var _this = _super.call(this, triggerOptions, condition) || this;
        _this.children = children;
        return _this;
    }
    /** @hidden */
    CombineAction.prototype._prepare = function () {
        for (var index = 0; index < this.children.length; index++) {
            this.children[index]._actionManager = this._actionManager;
            this.children[index]._prepare();
        }
    };
    /**
     * Execute the action and executes all the aggregated actions.
     */
    CombineAction.prototype.execute = function (evt) {
        for (var index = 0; index < this.children.length; index++) {
            this.children[index].execute(evt);
        }
    };
    /**
     * Serializes the actions and its related information.
     * @param parent defines the object to serialize in
     * @returns the serialized object
     */
    CombineAction.prototype.serialize = function (parent) {
        var serializationObject = _super.prototype._serialize.call(this, {
            name: "CombineAction",
            properties: [],
            combine: []
        }, parent);
        for (var i = 0; i < this.children.length; i++) {
            serializationObject.combine.push(this.children[i].serialize(null));
        }
        return serializationObject;
    };
    return CombineAction;
}(_action__WEBPACK_IMPORTED_MODULE_2__.Action));

/**
 * This defines an action responsible to run code (external event) once triggered.
 * @see http://doc.babylonjs.com/how_to/how_to_use_actions
 */
var ExecuteCodeAction = /** @class */ (function (_super) {
    (0,tslib__WEBPACK_IMPORTED_MODULE_4__.__extends)(ExecuteCodeAction, _super);
    /**
     * Instantiate the action
     * @param triggerOptions defines the trigger options
     * @param func defines the callback function to run
     * @param condition defines the trigger related conditions
     */
    function ExecuteCodeAction(triggerOptions, func, condition) {
        var _this = _super.call(this, triggerOptions, condition) || this;
        _this.func = func;
        return _this;
    }
    /**
     * Execute the action and run the attached code.
     */
    ExecuteCodeAction.prototype.execute = function (evt) {
        this.func(evt);
    };
    return ExecuteCodeAction;
}(_action__WEBPACK_IMPORTED_MODULE_2__.Action));

/**
 * This defines an action responsible to set the parent property of the target once triggered.
 * @see http://doc.babylonjs.com/how_to/how_to_use_actions
 */
var SetParentAction = /** @class */ (function (_super) {
    (0,tslib__WEBPACK_IMPORTED_MODULE_4__.__extends)(SetParentAction, _super);
    /**
     * Instantiate the action
     * @param triggerOptions defines the trigger options
     * @param target defines the target containing the parent property
     * @param parent defines from where the animation should start (animation frame)
     * @param condition defines the trigger related conditions
     */
    function SetParentAction(triggerOptions, target, parent, condition) {
        var _this = _super.call(this, triggerOptions, condition) || this;
        _this._target = target;
        _this._parent = parent;
        return _this;
    }
    /** @hidden */
    SetParentAction.prototype._prepare = function () {
    };
    /**
     * Execute the action and set the parent property.
     */
    SetParentAction.prototype.execute = function () {
        if (this._target.parent === this._parent) {
            return;
        }
        var invertParentWorldMatrix = this._parent.getWorldMatrix().clone();
        invertParentWorldMatrix.invert();
        this._target.position = _Maths_math_vector__WEBPACK_IMPORTED_MODULE_1__.Vector3.TransformCoordinates(this._target.position, invertParentWorldMatrix);
        this._target.parent = this._parent;
    };
    /**
     * Serializes the actions and its related information.
     * @param parent defines the object to serialize in
     * @returns the serialized object
     */
    SetParentAction.prototype.serialize = function (parent) {
        return _super.prototype._serialize.call(this, {
            name: "SetParentAction",
            properties: [
                _action__WEBPACK_IMPORTED_MODULE_2__.Action._GetTargetProperty(this._target),
                _action__WEBPACK_IMPORTED_MODULE_2__.Action._GetTargetProperty(this._parent),
            ]
        }, parent);
    };
    return SetParentAction;
}(_action__WEBPACK_IMPORTED_MODULE_2__.Action));

_Misc_typeStore__WEBPACK_IMPORTED_MODULE_3__._TypeStore.RegisteredTypes["BABYLON.SetParentAction"] = SetParentAction;
_Misc_typeStore__WEBPACK_IMPORTED_MODULE_3__._TypeStore.RegisteredTypes["BABYLON.ExecuteCodeAction"] = ExecuteCodeAction;
_Misc_typeStore__WEBPACK_IMPORTED_MODULE_3__._TypeStore.RegisteredTypes["BABYLON.DoNothingAction"] = DoNothingAction;
_Misc_typeStore__WEBPACK_IMPORTED_MODULE_3__._TypeStore.RegisteredTypes["BABYLON.StopAnimationAction"] = StopAnimationAction;
_Misc_typeStore__WEBPACK_IMPORTED_MODULE_3__._TypeStore.RegisteredTypes["BABYLON.PlayAnimationAction"] = PlayAnimationAction;
_Misc_typeStore__WEBPACK_IMPORTED_MODULE_3__._TypeStore.RegisteredTypes["BABYLON.IncrementValueAction"] = IncrementValueAction;
_Misc_typeStore__WEBPACK_IMPORTED_MODULE_3__._TypeStore.RegisteredTypes["BABYLON.SetValueAction"] = SetValueAction;
_Misc_typeStore__WEBPACK_IMPORTED_MODULE_3__._TypeStore.RegisteredTypes["BABYLON.SetStateAction"] = SetStateAction;
_Misc_typeStore__WEBPACK_IMPORTED_MODULE_3__._TypeStore.RegisteredTypes["BABYLON.SetParentAction"] = SetParentAction;
//# sourceMappingURL=directActions.js.map

/***/ }),

/***/ "./node_modules/@babylonjs/core/Actions/directAudioActions.js":
/*!********************************************************************!*\
  !*** ./node_modules/@babylonjs/core/Actions/directAudioActions.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "PlaySoundAction": () => (/* binding */ PlaySoundAction),
/* harmony export */   "StopSoundAction": () => (/* binding */ StopSoundAction)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _action__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./action */ "./node_modules/@babylonjs/core/Actions/action.js");
/* harmony import */ var _Misc_typeStore__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Misc/typeStore */ "./node_modules/@babylonjs/core/Misc/typeStore.js");



/**
 * This defines an action helpful to play a defined sound on a triggered action.
 */
var PlaySoundAction = /** @class */ (function (_super) {
    (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__extends)(PlaySoundAction, _super);
    /**
     * Instantiate the action
     * @param triggerOptions defines the trigger options
     * @param sound defines the sound to play
     * @param condition defines the trigger related conditions
     */
    function PlaySoundAction(triggerOptions, sound, condition) {
        var _this = _super.call(this, triggerOptions, condition) || this;
        _this._sound = sound;
        return _this;
    }
    /** @hidden */
    PlaySoundAction.prototype._prepare = function () {
    };
    /**
     * Execute the action and play the sound.
     */
    PlaySoundAction.prototype.execute = function () {
        if (this._sound !== undefined) {
            this._sound.play();
        }
    };
    /**
     * Serializes the actions and its related information.
     * @param parent defines the object to serialize in
     * @returns the serialized object
     */
    PlaySoundAction.prototype.serialize = function (parent) {
        return _super.prototype._serialize.call(this, {
            name: "PlaySoundAction",
            properties: [{ name: "sound", value: this._sound.name }]
        }, parent);
    };
    return PlaySoundAction;
}(_action__WEBPACK_IMPORTED_MODULE_0__.Action));

/**
 * This defines an action helpful to stop a defined sound on a triggered action.
 */
var StopSoundAction = /** @class */ (function (_super) {
    (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__extends)(StopSoundAction, _super);
    /**
     * Instantiate the action
     * @param triggerOptions defines the trigger options
     * @param sound defines the sound to stop
     * @param condition defines the trigger related conditions
     */
    function StopSoundAction(triggerOptions, sound, condition) {
        var _this = _super.call(this, triggerOptions, condition) || this;
        _this._sound = sound;
        return _this;
    }
    /** @hidden */
    StopSoundAction.prototype._prepare = function () {
    };
    /**
     * Execute the action and stop the sound.
     */
    StopSoundAction.prototype.execute = function () {
        if (this._sound !== undefined) {
            this._sound.stop();
        }
    };
    /**
     * Serializes the actions and its related information.
     * @param parent defines the object to serialize in
     * @returns the serialized object
     */
    StopSoundAction.prototype.serialize = function (parent) {
        return _super.prototype._serialize.call(this, {
            name: "StopSoundAction",
            properties: [{ name: "sound", value: this._sound.name }]
        }, parent);
    };
    return StopSoundAction;
}(_action__WEBPACK_IMPORTED_MODULE_0__.Action));

_Misc_typeStore__WEBPACK_IMPORTED_MODULE_1__._TypeStore.RegisteredTypes["BABYLON.PlaySoundAction"] = StopSoundAction;
_Misc_typeStore__WEBPACK_IMPORTED_MODULE_1__._TypeStore.RegisteredTypes["BABYLON.StopSoundAction"] = StopSoundAction;
//# sourceMappingURL=directAudioActions.js.map

/***/ }),

/***/ "./node_modules/@babylonjs/core/Actions/index.js":
/*!*******************************************************!*\
  !*** ./node_modules/@babylonjs/core/Actions/index.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "AbstractActionManager": () => (/* reexport safe */ _abstractActionManager__WEBPACK_IMPORTED_MODULE_0__.AbstractActionManager),
/* harmony export */   "Action": () => (/* reexport safe */ _action__WEBPACK_IMPORTED_MODULE_1__.Action),
/* harmony export */   "ActionEvent": () => (/* reexport safe */ _actionEvent__WEBPACK_IMPORTED_MODULE_2__.ActionEvent),
/* harmony export */   "ActionManager": () => (/* reexport safe */ _actionManager__WEBPACK_IMPORTED_MODULE_3__.ActionManager),
/* harmony export */   "CombineAction": () => (/* reexport safe */ _directActions__WEBPACK_IMPORTED_MODULE_5__.CombineAction),
/* harmony export */   "Condition": () => (/* reexport safe */ _condition__WEBPACK_IMPORTED_MODULE_4__.Condition),
/* harmony export */   "DoNothingAction": () => (/* reexport safe */ _directActions__WEBPACK_IMPORTED_MODULE_5__.DoNothingAction),
/* harmony export */   "ExecuteCodeAction": () => (/* reexport safe */ _directActions__WEBPACK_IMPORTED_MODULE_5__.ExecuteCodeAction),
/* harmony export */   "IncrementValueAction": () => (/* reexport safe */ _directActions__WEBPACK_IMPORTED_MODULE_5__.IncrementValueAction),
/* harmony export */   "InterpolateValueAction": () => (/* reexport safe */ _interpolateValueAction__WEBPACK_IMPORTED_MODULE_7__.InterpolateValueAction),
/* harmony export */   "PlayAnimationAction": () => (/* reexport safe */ _directActions__WEBPACK_IMPORTED_MODULE_5__.PlayAnimationAction),
/* harmony export */   "PlaySoundAction": () => (/* reexport safe */ _directAudioActions__WEBPACK_IMPORTED_MODULE_6__.PlaySoundAction),
/* harmony export */   "PredicateCondition": () => (/* reexport safe */ _condition__WEBPACK_IMPORTED_MODULE_4__.PredicateCondition),
/* harmony export */   "SetParentAction": () => (/* reexport safe */ _directActions__WEBPACK_IMPORTED_MODULE_5__.SetParentAction),
/* harmony export */   "SetStateAction": () => (/* reexport safe */ _directActions__WEBPACK_IMPORTED_MODULE_5__.SetStateAction),
/* harmony export */   "SetValueAction": () => (/* reexport safe */ _directActions__WEBPACK_IMPORTED_MODULE_5__.SetValueAction),
/* harmony export */   "StateCondition": () => (/* reexport safe */ _condition__WEBPACK_IMPORTED_MODULE_4__.StateCondition),
/* harmony export */   "StopAnimationAction": () => (/* reexport safe */ _directActions__WEBPACK_IMPORTED_MODULE_5__.StopAnimationAction),
/* harmony export */   "StopSoundAction": () => (/* reexport safe */ _directAudioActions__WEBPACK_IMPORTED_MODULE_6__.StopSoundAction),
/* harmony export */   "SwitchBooleanAction": () => (/* reexport safe */ _directActions__WEBPACK_IMPORTED_MODULE_5__.SwitchBooleanAction),
/* harmony export */   "ValueCondition": () => (/* reexport safe */ _condition__WEBPACK_IMPORTED_MODULE_4__.ValueCondition)
/* harmony export */ });
/* harmony import */ var _abstractActionManager__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./abstractActionManager */ "./node_modules/@babylonjs/core/Actions/abstractActionManager.js");
/* harmony import */ var _action__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./action */ "./node_modules/@babylonjs/core/Actions/action.js");
/* harmony import */ var _actionEvent__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./actionEvent */ "./node_modules/@babylonjs/core/Actions/actionEvent.js");
/* harmony import */ var _actionManager__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./actionManager */ "./node_modules/@babylonjs/core/Actions/actionManager.js");
/* harmony import */ var _condition__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./condition */ "./node_modules/@babylonjs/core/Actions/condition.js");
/* harmony import */ var _directActions__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./directActions */ "./node_modules/@babylonjs/core/Actions/directActions.js");
/* harmony import */ var _directAudioActions__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./directAudioActions */ "./node_modules/@babylonjs/core/Actions/directAudioActions.js");
/* harmony import */ var _interpolateValueAction__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./interpolateValueAction */ "./node_modules/@babylonjs/core/Actions/interpolateValueAction.js");








//# sourceMappingURL=index.js.map

/***/ }),

/***/ "./node_modules/@babylonjs/core/Actions/interpolateValueAction.js":
/*!************************************************************************!*\
  !*** ./node_modules/@babylonjs/core/Actions/interpolateValueAction.js ***!
  \************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "InterpolateValueAction": () => (/* binding */ InterpolateValueAction)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _action__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./action */ "./node_modules/@babylonjs/core/Actions/action.js");
/* harmony import */ var _Misc_logger__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Misc/logger */ "./node_modules/@babylonjs/core/Misc/logger.js");
/* harmony import */ var _Misc_observable__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Misc/observable */ "./node_modules/@babylonjs/core/Misc/observable.js");
/* harmony import */ var _Maths_math_color__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../Maths/math.color */ "./node_modules/@babylonjs/core/Maths/math.color.js");
/* harmony import */ var _Maths_math_vector__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../Maths/math.vector */ "./node_modules/@babylonjs/core/Maths/math.vector.js");
/* harmony import */ var _Animations_animation__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../Animations/animation */ "./node_modules/@babylonjs/core/Animations/animation.js");
/* harmony import */ var _Misc_typeStore__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../Misc/typeStore */ "./node_modules/@babylonjs/core/Misc/typeStore.js");








/**
 * This defines an action responsible to change the value of a property
 * by interpolating between its current value and the newly set one once triggered.
 * @see http://doc.babylonjs.com/how_to/how_to_use_actions
 */
var InterpolateValueAction = /** @class */ (function (_super) {
    (0,tslib__WEBPACK_IMPORTED_MODULE_7__.__extends)(InterpolateValueAction, _super);
    /**
     * Instantiate the action
     * @param triggerOptions defines the trigger options
     * @param target defines the object containing the value to interpolate
     * @param propertyPath defines the path to the property in the target object
     * @param value defines the target value at the end of the interpolation
     * @param duration deines the time it will take for the property to interpolate to the value.
     * @param condition defines the trigger related conditions
     * @param stopOtherAnimations defines if the other scene animations should be stopped when the action has been triggered
     * @param onInterpolationDone defines a callback raised once the interpolation animation has been done
     */
    function InterpolateValueAction(triggerOptions, target, propertyPath, value, duration, condition, stopOtherAnimations, onInterpolationDone) {
        if (duration === void 0) { duration = 1000; }
        var _this = _super.call(this, triggerOptions, condition) || this;
        /**
         * Defines the time it will take for the property to interpolate to the value.
         */
        _this.duration = 1000;
        /**
         * Observable triggered once the interpolation animation has been done.
         */
        _this.onInterpolationDoneObservable = new _Misc_observable__WEBPACK_IMPORTED_MODULE_2__.Observable();
        _this.propertyPath = propertyPath;
        _this.value = value;
        _this.duration = duration;
        _this.stopOtherAnimations = stopOtherAnimations;
        _this.onInterpolationDone = onInterpolationDone;
        _this._target = _this._effectiveTarget = target;
        return _this;
    }
    /** @hidden */
    InterpolateValueAction.prototype._prepare = function () {
        this._effectiveTarget = this._getEffectiveTarget(this._effectiveTarget, this.propertyPath);
        this._property = this._getProperty(this.propertyPath);
    };
    /**
     * Execute the action starts the value interpolation.
     */
    InterpolateValueAction.prototype.execute = function () {
        var _this = this;
        var scene = this._actionManager.getScene();
        var keys = [
            {
                frame: 0,
                value: this._effectiveTarget[this._property]
            }, {
                frame: 100,
                value: this.value
            }
        ];
        var dataType;
        if (typeof this.value === "number") {
            dataType = _Animations_animation__WEBPACK_IMPORTED_MODULE_5__.Animation.ANIMATIONTYPE_FLOAT;
        }
        else if (this.value instanceof _Maths_math_color__WEBPACK_IMPORTED_MODULE_3__.Color3) {
            dataType = _Animations_animation__WEBPACK_IMPORTED_MODULE_5__.Animation.ANIMATIONTYPE_COLOR3;
        }
        else if (this.value instanceof _Maths_math_vector__WEBPACK_IMPORTED_MODULE_4__.Vector3) {
            dataType = _Animations_animation__WEBPACK_IMPORTED_MODULE_5__.Animation.ANIMATIONTYPE_VECTOR3;
        }
        else if (this.value instanceof _Maths_math_vector__WEBPACK_IMPORTED_MODULE_4__.Matrix) {
            dataType = _Animations_animation__WEBPACK_IMPORTED_MODULE_5__.Animation.ANIMATIONTYPE_MATRIX;
        }
        else if (this.value instanceof _Maths_math_vector__WEBPACK_IMPORTED_MODULE_4__.Quaternion) {
            dataType = _Animations_animation__WEBPACK_IMPORTED_MODULE_5__.Animation.ANIMATIONTYPE_QUATERNION;
        }
        else {
            _Misc_logger__WEBPACK_IMPORTED_MODULE_1__.Logger.Warn("InterpolateValueAction: Unsupported type (" + typeof this.value + ")");
            return;
        }
        var animation = new _Animations_animation__WEBPACK_IMPORTED_MODULE_5__.Animation("InterpolateValueAction", this._property, 100 * (1000.0 / this.duration), dataType, _Animations_animation__WEBPACK_IMPORTED_MODULE_5__.Animation.ANIMATIONLOOPMODE_CONSTANT);
        animation.setKeys(keys);
        if (this.stopOtherAnimations) {
            scene.stopAnimation(this._effectiveTarget);
        }
        var wrapper = function () {
            _this.onInterpolationDoneObservable.notifyObservers(_this);
            if (_this.onInterpolationDone) {
                _this.onInterpolationDone();
            }
        };
        scene.beginDirectAnimation(this._effectiveTarget, [animation], 0, 100, false, 1, wrapper);
    };
    /**
     * Serializes the actions and its related information.
     * @param parent defines the object to serialize in
     * @returns the serialized object
     */
    InterpolateValueAction.prototype.serialize = function (parent) {
        return _super.prototype._serialize.call(this, {
            name: "InterpolateValueAction",
            properties: [
                _action__WEBPACK_IMPORTED_MODULE_0__.Action._GetTargetProperty(this._target),
                { name: "propertyPath", value: this.propertyPath },
                { name: "value", value: _action__WEBPACK_IMPORTED_MODULE_0__.Action._SerializeValueAsString(this.value) },
                { name: "duration", value: _action__WEBPACK_IMPORTED_MODULE_0__.Action._SerializeValueAsString(this.duration) },
                { name: "stopOtherAnimations", value: _action__WEBPACK_IMPORTED_MODULE_0__.Action._SerializeValueAsString(this.stopOtherAnimations) || false }
            ]
        }, parent);
    };
    return InterpolateValueAction;
}(_action__WEBPACK_IMPORTED_MODULE_0__.Action));

_Misc_typeStore__WEBPACK_IMPORTED_MODULE_6__._TypeStore.RegisteredTypes["BABYLON.InterpolateValueAction"] = InterpolateValueAction;
//# sourceMappingURL=interpolateValueAction.js.map

/***/ }),

/***/ "./node_modules/@babylonjs/core/Animations/animatable.js":
/*!***************************************************************!*\
  !*** ./node_modules/@babylonjs/core/Animations/animatable.js ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Animatable": () => (/* binding */ Animatable)
/* harmony export */ });
/* harmony import */ var _animation__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./animation */ "./node_modules/@babylonjs/core/Animations/animation.js");
/* harmony import */ var _runtimeAnimation__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./runtimeAnimation */ "./node_modules/@babylonjs/core/Animations/runtimeAnimation.js");
/* harmony import */ var _Misc_observable__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Misc/observable */ "./node_modules/@babylonjs/core/Misc/observable.js");
/* harmony import */ var _scene__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../scene */ "./node_modules/@babylonjs/core/scene.js");
/* harmony import */ var _Maths_math_vector__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../Maths/math.vector */ "./node_modules/@babylonjs/core/Maths/math.vector.js");
/* harmony import */ var _Misc_precisionDate__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../Misc/precisionDate */ "./node_modules/@babylonjs/core/Misc/precisionDate.js");
/* harmony import */ var _Bones_bone__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../Bones/bone */ "./node_modules/@babylonjs/core/Bones/bone.js");







/**
 * Class used to store an actual running animation
 */
var Animatable = /** @class */ (function () {
    /**
     * Creates a new Animatable
     * @param scene defines the hosting scene
     * @param target defines the target object
     * @param fromFrame defines the starting frame number (default is 0)
     * @param toFrame defines the ending frame number (default is 100)
     * @param loopAnimation defines if the animation must loop (default is false)
     * @param speedRatio defines the factor to apply to animation speed (default is 1)
     * @param onAnimationEnd defines a callback to call when animation ends if it is not looping
     * @param animations defines a group of animation to add to the new Animatable
     * @param onAnimationLoop defines a callback to call when animation loops
     */
    function Animatable(scene, 
    /** defines the target object */
    target, 
    /** defines the starting frame number (default is 0) */
    fromFrame, 
    /** defines the ending frame number (default is 100) */
    toFrame, 
    /** defines if the animation must loop (default is false)  */
    loopAnimation, speedRatio, 
    /** defines a callback to call when animation ends if it is not looping */
    onAnimationEnd, animations, 
    /** defines a callback to call when animation loops */
    onAnimationLoop) {
        if (fromFrame === void 0) { fromFrame = 0; }
        if (toFrame === void 0) { toFrame = 100; }
        if (loopAnimation === void 0) { loopAnimation = false; }
        if (speedRatio === void 0) { speedRatio = 1.0; }
        this.target = target;
        this.fromFrame = fromFrame;
        this.toFrame = toFrame;
        this.loopAnimation = loopAnimation;
        this.onAnimationEnd = onAnimationEnd;
        this.onAnimationLoop = onAnimationLoop;
        this._localDelayOffset = null;
        this._pausedDelay = null;
        this._runtimeAnimations = new Array();
        this._paused = false;
        this._speedRatio = 1;
        this._weight = -1.0;
        this._syncRoot = null;
        /**
         * Gets or sets a boolean indicating if the animatable must be disposed and removed at the end of the animation.
         * This will only apply for non looping animation (default is true)
         */
        this.disposeOnEnd = true;
        /**
         * Gets a boolean indicating if the animation has started
         */
        this.animationStarted = false;
        /**
         * Observer raised when the animation ends
         */
        this.onAnimationEndObservable = new _Misc_observable__WEBPACK_IMPORTED_MODULE_2__.Observable();
        /**
         * Observer raised when the animation loops
         */
        this.onAnimationLoopObservable = new _Misc_observable__WEBPACK_IMPORTED_MODULE_2__.Observable();
        this._scene = scene;
        if (animations) {
            this.appendAnimations(target, animations);
        }
        this._speedRatio = speedRatio;
        scene._activeAnimatables.push(this);
    }
    Object.defineProperty(Animatable.prototype, "syncRoot", {
        /**
         * Gets the root Animatable used to synchronize and normalize animations
         */
        get: function () {
            return this._syncRoot;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(Animatable.prototype, "masterFrame", {
        /**
         * Gets the current frame of the first RuntimeAnimation
         * Used to synchronize Animatables
         */
        get: function () {
            if (this._runtimeAnimations.length === 0) {
                return 0;
            }
            return this._runtimeAnimations[0].currentFrame;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(Animatable.prototype, "weight", {
        /**
         * Gets or sets the animatable weight (-1.0 by default meaning not weighted)
         */
        get: function () {
            return this._weight;
        },
        set: function (value) {
            if (value === -1) { // -1 is ok and means no weight
                this._weight = -1;
                return;
            }
            // Else weight must be in [0, 1] range
            this._weight = Math.min(Math.max(value, 0), 1.0);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(Animatable.prototype, "speedRatio", {
        /**
         * Gets or sets the speed ratio to apply to the animatable (1.0 by default)
         */
        get: function () {
            return this._speedRatio;
        },
        set: function (value) {
            for (var index = 0; index < this._runtimeAnimations.length; index++) {
                var animation = this._runtimeAnimations[index];
                animation._prepareForSpeedRatioChange(value);
            }
            this._speedRatio = value;
        },
        enumerable: true,
        configurable: true
    });
    // Methods
    /**
     * Synchronize and normalize current Animatable with a source Animatable
     * This is useful when using animation weights and when animations are not of the same length
     * @param root defines the root Animatable to synchronize with
     * @returns the current Animatable
     */
    Animatable.prototype.syncWith = function (root) {
        this._syncRoot = root;
        if (root) {
            // Make sure this animatable will animate after the root
            var index = this._scene._activeAnimatables.indexOf(this);
            if (index > -1) {
                this._scene._activeAnimatables.splice(index, 1);
                this._scene._activeAnimatables.push(this);
            }
        }
        return this;
    };
    /**
     * Gets the list of runtime animations
     * @returns an array of RuntimeAnimation
     */
    Animatable.prototype.getAnimations = function () {
        return this._runtimeAnimations;
    };
    /**
     * Adds more animations to the current animatable
     * @param target defines the target of the animations
     * @param animations defines the new animations to add
     */
    Animatable.prototype.appendAnimations = function (target, animations) {
        var _this = this;
        for (var index = 0; index < animations.length; index++) {
            var animation = animations[index];
            var newRuntimeAnimation = new _runtimeAnimation__WEBPACK_IMPORTED_MODULE_1__.RuntimeAnimation(target, animation, this._scene, this);
            newRuntimeAnimation._onLoop = function () {
                _this.onAnimationLoopObservable.notifyObservers(_this);
                if (_this.onAnimationLoop) {
                    _this.onAnimationLoop();
                }
            };
            this._runtimeAnimations.push(newRuntimeAnimation);
        }
    };
    /**
     * Gets the source animation for a specific property
     * @param property defines the propertyu to look for
     * @returns null or the source animation for the given property
     */
    Animatable.prototype.getAnimationByTargetProperty = function (property) {
        var runtimeAnimations = this._runtimeAnimations;
        for (var index = 0; index < runtimeAnimations.length; index++) {
            if (runtimeAnimations[index].animation.targetProperty === property) {
                return runtimeAnimations[index].animation;
            }
        }
        return null;
    };
    /**
     * Gets the runtime animation for a specific property
     * @param property defines the propertyu to look for
     * @returns null or the runtime animation for the given property
     */
    Animatable.prototype.getRuntimeAnimationByTargetProperty = function (property) {
        var runtimeAnimations = this._runtimeAnimations;
        for (var index = 0; index < runtimeAnimations.length; index++) {
            if (runtimeAnimations[index].animation.targetProperty === property) {
                return runtimeAnimations[index];
            }
        }
        return null;
    };
    /**
     * Resets the animatable to its original state
     */
    Animatable.prototype.reset = function () {
        var runtimeAnimations = this._runtimeAnimations;
        for (var index = 0; index < runtimeAnimations.length; index++) {
            runtimeAnimations[index].reset(true);
        }
        this._localDelayOffset = null;
        this._pausedDelay = null;
    };
    /**
     * Allows the animatable to blend with current running animations
     * @see http://doc.babylonjs.com/babylon101/animations#animation-blending
     * @param blendingSpeed defines the blending speed to use
     */
    Animatable.prototype.enableBlending = function (blendingSpeed) {
        var runtimeAnimations = this._runtimeAnimations;
        for (var index = 0; index < runtimeAnimations.length; index++) {
            runtimeAnimations[index].animation.enableBlending = true;
            runtimeAnimations[index].animation.blendingSpeed = blendingSpeed;
        }
    };
    /**
     * Disable animation blending
     * @see http://doc.babylonjs.com/babylon101/animations#animation-blending
     */
    Animatable.prototype.disableBlending = function () {
        var runtimeAnimations = this._runtimeAnimations;
        for (var index = 0; index < runtimeAnimations.length; index++) {
            runtimeAnimations[index].animation.enableBlending = false;
        }
    };
    /**
     * Jump directly to a given frame
     * @param frame defines the frame to jump to
     */
    Animatable.prototype.goToFrame = function (frame) {
        var runtimeAnimations = this._runtimeAnimations;
        if (runtimeAnimations[0]) {
            var fps = runtimeAnimations[0].animation.framePerSecond;
            var currentFrame = runtimeAnimations[0].currentFrame;
            var adjustTime = frame - currentFrame;
            var delay = this.speedRatio !== 0 ? adjustTime * 1000 / (fps * this.speedRatio) : 0;
            if (this._localDelayOffset === null) {
                this._localDelayOffset = 0;
            }
            this._localDelayOffset -= delay;
        }
        for (var index = 0; index < runtimeAnimations.length; index++) {
            runtimeAnimations[index].goToFrame(frame);
        }
    };
    /**
     * Pause the animation
     */
    Animatable.prototype.pause = function () {
        if (this._paused) {
            return;
        }
        this._paused = true;
    };
    /**
     * Restart the animation
     */
    Animatable.prototype.restart = function () {
        this._paused = false;
    };
    Animatable.prototype._raiseOnAnimationEnd = function () {
        if (this.onAnimationEnd) {
            this.onAnimationEnd();
        }
        this.onAnimationEndObservable.notifyObservers(this);
    };
    /**
     * Stop and delete the current animation
     * @param animationName defines a string used to only stop some of the runtime animations instead of all
     * @param targetMask - a function that determines if the animation should be stopped based on its target (all animations will be stopped if both this and animationName are empty)
     */
    Animatable.prototype.stop = function (animationName, targetMask) {
        if (animationName || targetMask) {
            var idx = this._scene._activeAnimatables.indexOf(this);
            if (idx > -1) {
                var runtimeAnimations = this._runtimeAnimations;
                for (var index = runtimeAnimations.length - 1; index >= 0; index--) {
                    var runtimeAnimation = runtimeAnimations[index];
                    if (animationName && runtimeAnimation.animation.name != animationName) {
                        continue;
                    }
                    if (targetMask && !targetMask(runtimeAnimation.target)) {
                        continue;
                    }
                    runtimeAnimation.dispose();
                    runtimeAnimations.splice(index, 1);
                }
                if (runtimeAnimations.length == 0) {
                    this._scene._activeAnimatables.splice(idx, 1);
                    this._raiseOnAnimationEnd();
                }
            }
        }
        else {
            var index = this._scene._activeAnimatables.indexOf(this);
            if (index > -1) {
                this._scene._activeAnimatables.splice(index, 1);
                var runtimeAnimations = this._runtimeAnimations;
                for (var index = 0; index < runtimeAnimations.length; index++) {
                    runtimeAnimations[index].dispose();
                }
                this._raiseOnAnimationEnd();
            }
        }
    };
    /**
     * Wait asynchronously for the animation to end
     * @returns a promise which will be fullfilled when the animation ends
     */
    Animatable.prototype.waitAsync = function () {
        var _this = this;
        return new Promise(function (resolve, reject) {
            _this.onAnimationEndObservable.add(function () {
                resolve(_this);
            }, undefined, undefined, _this, true);
        });
    };
    /** @hidden */
    Animatable.prototype._animate = function (delay) {
        if (this._paused) {
            this.animationStarted = false;
            if (this._pausedDelay === null) {
                this._pausedDelay = delay;
            }
            return true;
        }
        if (this._localDelayOffset === null) {
            this._localDelayOffset = delay;
            this._pausedDelay = null;
        }
        else if (this._pausedDelay !== null) {
            this._localDelayOffset += delay - this._pausedDelay;
            this._pausedDelay = null;
        }
        if (this._weight === 0) { // We consider that an animation with a weight === 0 is "actively" paused
            return true;
        }
        // Animating
        var running = false;
        var runtimeAnimations = this._runtimeAnimations;
        var index;
        for (index = 0; index < runtimeAnimations.length; index++) {
            var animation = runtimeAnimations[index];
            var isRunning = animation.animate(delay - this._localDelayOffset, this.fromFrame, this.toFrame, this.loopAnimation, this._speedRatio, this._weight);
            running = running || isRunning;
        }
        this.animationStarted = running;
        if (!running) {
            if (this.disposeOnEnd) {
                // Remove from active animatables
                index = this._scene._activeAnimatables.indexOf(this);
                this._scene._activeAnimatables.splice(index, 1);
                // Dispose all runtime animations
                for (index = 0; index < runtimeAnimations.length; index++) {
                    runtimeAnimations[index].dispose();
                }
            }
            this._raiseOnAnimationEnd();
            if (this.disposeOnEnd) {
                this.onAnimationEnd = null;
                this.onAnimationLoop = null;
                this.onAnimationLoopObservable.clear();
                this.onAnimationEndObservable.clear();
            }
        }
        return running;
    };
    return Animatable;
}());

_scene__WEBPACK_IMPORTED_MODULE_3__.Scene.prototype._animate = function () {
    if (!this.animationsEnabled) {
        return;
    }
    // Getting time
    var now = _Misc_precisionDate__WEBPACK_IMPORTED_MODULE_5__.PrecisionDate.Now;
    if (!this._animationTimeLast) {
        if (this._pendingData.length > 0) {
            return;
        }
        this._animationTimeLast = now;
    }
    this.deltaTime = this.useConstantAnimationDeltaTime ? 16.0 : (now - this._animationTimeLast) * this.animationTimeScale;
    this._animationTimeLast = now;
    var animatables = this._activeAnimatables;
    if (animatables.length === 0) {
        return;
    }
    this._animationTime += this.deltaTime;
    var animationTime = this._animationTime;
    for (var index = 0; index < animatables.length; index++) {
        var animatable = animatables[index];
        if (!animatable._animate(animationTime) && animatable.disposeOnEnd) {
            index--; // Array was updated
        }
    }
    // Late animation bindings
    this._processLateAnimationBindings();
};
_scene__WEBPACK_IMPORTED_MODULE_3__.Scene.prototype.beginWeightedAnimation = function (target, from, to, weight, loop, speedRatio, onAnimationEnd, animatable, targetMask, onAnimationLoop) {
    if (weight === void 0) { weight = 1.0; }
    if (speedRatio === void 0) { speedRatio = 1.0; }
    var returnedAnimatable = this.beginAnimation(target, from, to, loop, speedRatio, onAnimationEnd, animatable, false, targetMask, onAnimationLoop);
    returnedAnimatable.weight = weight;
    return returnedAnimatable;
};
_scene__WEBPACK_IMPORTED_MODULE_3__.Scene.prototype.beginAnimation = function (target, from, to, loop, speedRatio, onAnimationEnd, animatable, stopCurrent, targetMask, onAnimationLoop) {
    if (speedRatio === void 0) { speedRatio = 1.0; }
    if (stopCurrent === void 0) { stopCurrent = true; }
    if (from > to && speedRatio > 0) {
        speedRatio *= -1;
    }
    if (stopCurrent) {
        this.stopAnimation(target, undefined, targetMask);
    }
    if (!animatable) {
        animatable = new Animatable(this, target, from, to, loop, speedRatio, onAnimationEnd, undefined, onAnimationLoop);
    }
    var shouldRunTargetAnimations = targetMask ? targetMask(target) : true;
    // Local animations
    if (target.animations && shouldRunTargetAnimations) {
        animatable.appendAnimations(target, target.animations);
    }
    // Children animations
    if (target.getAnimatables) {
        var animatables = target.getAnimatables();
        for (var index = 0; index < animatables.length; index++) {
            this.beginAnimation(animatables[index], from, to, loop, speedRatio, onAnimationEnd, animatable, stopCurrent, targetMask, onAnimationLoop);
        }
    }
    animatable.reset();
    return animatable;
};
_scene__WEBPACK_IMPORTED_MODULE_3__.Scene.prototype.beginHierarchyAnimation = function (target, directDescendantsOnly, from, to, loop, speedRatio, onAnimationEnd, animatable, stopCurrent, targetMask, onAnimationLoop) {
    if (speedRatio === void 0) { speedRatio = 1.0; }
    if (stopCurrent === void 0) { stopCurrent = true; }
    var children = target.getDescendants(directDescendantsOnly);
    var result = [];
    result.push(this.beginAnimation(target, from, to, loop, speedRatio, onAnimationEnd, animatable, stopCurrent, targetMask));
    for (var _i = 0, children_1 = children; _i < children_1.length; _i++) {
        var child = children_1[_i];
        result.push(this.beginAnimation(child, from, to, loop, speedRatio, onAnimationEnd, animatable, stopCurrent, targetMask));
    }
    return result;
};
_scene__WEBPACK_IMPORTED_MODULE_3__.Scene.prototype.beginDirectAnimation = function (target, animations, from, to, loop, speedRatio, onAnimationEnd, onAnimationLoop) {
    if (speedRatio === undefined) {
        speedRatio = 1.0;
    }
    if (from > to && speedRatio > 0) {
        speedRatio *= -1;
    }
    var animatable = new Animatable(this, target, from, to, loop, speedRatio, onAnimationEnd, animations, onAnimationLoop);
    return animatable;
};
_scene__WEBPACK_IMPORTED_MODULE_3__.Scene.prototype.beginDirectHierarchyAnimation = function (target, directDescendantsOnly, animations, from, to, loop, speedRatio, onAnimationEnd, onAnimationLoop) {
    var children = target.getDescendants(directDescendantsOnly);
    var result = [];
    result.push(this.beginDirectAnimation(target, animations, from, to, loop, speedRatio, onAnimationEnd, onAnimationLoop));
    for (var _i = 0, children_2 = children; _i < children_2.length; _i++) {
        var child = children_2[_i];
        result.push(this.beginDirectAnimation(child, animations, from, to, loop, speedRatio, onAnimationEnd, onAnimationLoop));
    }
    return result;
};
_scene__WEBPACK_IMPORTED_MODULE_3__.Scene.prototype.getAnimatableByTarget = function (target) {
    for (var index = 0; index < this._activeAnimatables.length; index++) {
        if (this._activeAnimatables[index].target === target) {
            return this._activeAnimatables[index];
        }
    }
    return null;
};
_scene__WEBPACK_IMPORTED_MODULE_3__.Scene.prototype.getAllAnimatablesByTarget = function (target) {
    var result = [];
    for (var index = 0; index < this._activeAnimatables.length; index++) {
        if (this._activeAnimatables[index].target === target) {
            result.push(this._activeAnimatables[index]);
        }
    }
    return result;
};
/**
 * Will stop the animation of the given target
 * @param target - the target
 * @param animationName - the name of the animation to stop (all animations will be stopped if both this and targetMask are empty)
 * @param targetMask - a function that determines if the animation should be stopped based on its target (all animations will be stopped if both this and animationName are empty)
 */
_scene__WEBPACK_IMPORTED_MODULE_3__.Scene.prototype.stopAnimation = function (target, animationName, targetMask) {
    var animatables = this.getAllAnimatablesByTarget(target);
    for (var _i = 0, animatables_1 = animatables; _i < animatables_1.length; _i++) {
        var animatable = animatables_1[_i];
        animatable.stop(animationName, targetMask);
    }
};
/**
 * Stops and removes all animations that have been applied to the scene
 */
_scene__WEBPACK_IMPORTED_MODULE_3__.Scene.prototype.stopAllAnimations = function () {
    if (this._activeAnimatables) {
        for (var i = 0; i < this._activeAnimatables.length; i++) {
            this._activeAnimatables[i].stop();
        }
        this._activeAnimatables = [];
    }
    for (var _i = 0, _a = this.animationGroups; _i < _a.length; _i++) {
        var group = _a[_i];
        group.stop();
    }
};
_scene__WEBPACK_IMPORTED_MODULE_3__.Scene.prototype._registerTargetForLateAnimationBinding = function (runtimeAnimation, originalValue) {
    var target = runtimeAnimation.target;
    this._registeredForLateAnimationBindings.pushNoDuplicate(target);
    if (!target._lateAnimationHolders) {
        target._lateAnimationHolders = {};
    }
    if (!target._lateAnimationHolders[runtimeAnimation.targetPath]) {
        target._lateAnimationHolders[runtimeAnimation.targetPath] = {
            totalWeight: 0,
            animations: [],
            originalValue: originalValue
        };
    }
    target._lateAnimationHolders[runtimeAnimation.targetPath].animations.push(runtimeAnimation);
    target._lateAnimationHolders[runtimeAnimation.targetPath].totalWeight += runtimeAnimation.weight;
};
_scene__WEBPACK_IMPORTED_MODULE_3__.Scene.prototype._processLateAnimationBindingsForMatrices = function (holder) {
    var normalizer = 1.0;
    var finalPosition = _Maths_math_vector__WEBPACK_IMPORTED_MODULE_4__.TmpVectors.Vector3[0];
    var finalScaling = _Maths_math_vector__WEBPACK_IMPORTED_MODULE_4__.TmpVectors.Vector3[1];
    var finalQuaternion = _Maths_math_vector__WEBPACK_IMPORTED_MODULE_4__.TmpVectors.Quaternion[0];
    var startIndex = 0;
    var originalAnimation = holder.animations[0];
    var originalValue = holder.originalValue;
    var scale = 1;
    if (holder.totalWeight < 1.0) {
        // We need to mix the original value in
        originalValue.decompose(finalScaling, finalQuaternion, finalPosition);
        scale = 1.0 - holder.totalWeight;
    }
    else {
        startIndex = 1;
        // We need to normalize the weights
        normalizer = holder.totalWeight;
        originalAnimation.currentValue.decompose(finalScaling, finalQuaternion, finalPosition);
        scale = originalAnimation.weight / normalizer;
        if (scale == 1) {
            return originalAnimation.currentValue;
        }
    }
    finalScaling.scaleInPlace(scale);
    finalPosition.scaleInPlace(scale);
    finalQuaternion.scaleInPlace(scale);
    for (var animIndex = startIndex; animIndex < holder.animations.length; animIndex++) {
        var runtimeAnimation = holder.animations[animIndex];
        var scale = runtimeAnimation.weight / normalizer;
        var currentPosition = _Maths_math_vector__WEBPACK_IMPORTED_MODULE_4__.TmpVectors.Vector3[2];
        var currentScaling = _Maths_math_vector__WEBPACK_IMPORTED_MODULE_4__.TmpVectors.Vector3[3];
        var currentQuaternion = _Maths_math_vector__WEBPACK_IMPORTED_MODULE_4__.TmpVectors.Quaternion[1];
        runtimeAnimation.currentValue.decompose(currentScaling, currentQuaternion, currentPosition);
        currentScaling.scaleAndAddToRef(scale, finalScaling);
        currentQuaternion.scaleAndAddToRef(scale, finalQuaternion);
        currentPosition.scaleAndAddToRef(scale, finalPosition);
    }
    var workValue = originalAnimation._animationState.workValue;
    _Maths_math_vector__WEBPACK_IMPORTED_MODULE_4__.Matrix.ComposeToRef(finalScaling, finalQuaternion, finalPosition, workValue);
    return workValue;
};
_scene__WEBPACK_IMPORTED_MODULE_3__.Scene.prototype._processLateAnimationBindingsForQuaternions = function (holder, refQuaternion) {
    var originalAnimation = holder.animations[0];
    var originalValue = holder.originalValue;
    if (holder.animations.length === 1) {
        _Maths_math_vector__WEBPACK_IMPORTED_MODULE_4__.Quaternion.SlerpToRef(originalValue, originalAnimation.currentValue, Math.min(1.0, holder.totalWeight), refQuaternion);
        return refQuaternion;
    }
    var normalizer = 1.0;
    var quaternions;
    var weights;
    if (holder.totalWeight < 1.0) {
        var scale = 1.0 - holder.totalWeight;
        quaternions = [];
        weights = [];
        quaternions.push(originalValue);
        weights.push(scale);
    }
    else {
        if (holder.animations.length === 2) { // Slerp as soon as we can
            _Maths_math_vector__WEBPACK_IMPORTED_MODULE_4__.Quaternion.SlerpToRef(holder.animations[0].currentValue, holder.animations[1].currentValue, holder.animations[1].weight / holder.totalWeight, refQuaternion);
            return refQuaternion;
        }
        quaternions = [];
        weights = [];
        normalizer = holder.totalWeight;
    }
    for (var animIndex = 0; animIndex < holder.animations.length; animIndex++) {
        var runtimeAnimation = holder.animations[animIndex];
        quaternions.push(runtimeAnimation.currentValue);
        weights.push(runtimeAnimation.weight / normalizer);
    }
    // https://gamedev.stackexchange.com/questions/62354/method-for-interpolation-between-3-quaternions
    var cumulativeAmount = 0;
    var cumulativeQuaternion = null;
    for (var index = 0; index < quaternions.length;) {
        if (!cumulativeQuaternion) {
            _Maths_math_vector__WEBPACK_IMPORTED_MODULE_4__.Quaternion.SlerpToRef(quaternions[index], quaternions[index + 1], weights[index + 1] / (weights[index] + weights[index + 1]), refQuaternion);
            cumulativeQuaternion = refQuaternion;
            cumulativeAmount = weights[index] + weights[index + 1];
            index += 2;
            continue;
        }
        cumulativeAmount += weights[index];
        _Maths_math_vector__WEBPACK_IMPORTED_MODULE_4__.Quaternion.SlerpToRef(cumulativeQuaternion, quaternions[index], weights[index] / cumulativeAmount, cumulativeQuaternion);
        index++;
    }
    return cumulativeQuaternion;
};
_scene__WEBPACK_IMPORTED_MODULE_3__.Scene.prototype._processLateAnimationBindings = function () {
    if (!this._registeredForLateAnimationBindings.length) {
        return;
    }
    for (var index = 0; index < this._registeredForLateAnimationBindings.length; index++) {
        var target = this._registeredForLateAnimationBindings.data[index];
        for (var path in target._lateAnimationHolders) {
            var holder = target._lateAnimationHolders[path];
            var originalAnimation = holder.animations[0];
            var originalValue = holder.originalValue;
            var matrixDecomposeMode = _animation__WEBPACK_IMPORTED_MODULE_0__.Animation.AllowMatrixDecomposeForInterpolation && originalValue.m; // ie. data is matrix
            var finalValue = target[path];
            if (matrixDecomposeMode) {
                finalValue = this._processLateAnimationBindingsForMatrices(holder);
            }
            else {
                var quaternionMode = originalValue.w !== undefined;
                if (quaternionMode) {
                    finalValue = this._processLateAnimationBindingsForQuaternions(holder, finalValue || _Maths_math_vector__WEBPACK_IMPORTED_MODULE_4__.Quaternion.Identity());
                }
                else {
                    var startIndex = 0;
                    var normalizer = 1.0;
                    if (holder.totalWeight < 1.0) {
                        // We need to mix the original value in
                        if (originalValue.scale) {
                            finalValue = originalValue.scale(1.0 - holder.totalWeight);
                        }
                        else {
                            finalValue = originalValue * (1.0 - holder.totalWeight);
                        }
                    }
                    else {
                        // We need to normalize the weights
                        normalizer = holder.totalWeight;
                        var scale_1 = originalAnimation.weight / normalizer;
                        if (scale_1 !== 1) {
                            if (originalAnimation.currentValue.scale) {
                                finalValue = originalAnimation.currentValue.scale(scale_1);
                            }
                            else {
                                finalValue = originalAnimation.currentValue * scale_1;
                            }
                        }
                        else {
                            finalValue = originalAnimation.currentValue;
                        }
                        startIndex = 1;
                    }
                    for (var animIndex = startIndex; animIndex < holder.animations.length; animIndex++) {
                        var runtimeAnimation = holder.animations[animIndex];
                        var scale = runtimeAnimation.weight / normalizer;
                        if (runtimeAnimation.currentValue.scaleAndAddToRef) {
                            runtimeAnimation.currentValue.scaleAndAddToRef(scale, finalValue);
                        }
                        else {
                            finalValue += runtimeAnimation.currentValue * scale;
                        }
                    }
                }
            }
            target[path] = finalValue;
        }
        target._lateAnimationHolders = {};
    }
    this._registeredForLateAnimationBindings.reset();
};
_Bones_bone__WEBPACK_IMPORTED_MODULE_6__.Bone.prototype.copyAnimationRange = function (source, rangeName, frameOffset, rescaleAsRequired, skelDimensionsRatio) {
    if (rescaleAsRequired === void 0) { rescaleAsRequired = false; }
    if (skelDimensionsRatio === void 0) { skelDimensionsRatio = null; }
    // all animation may be coming from a library skeleton, so may need to create animation
    if (this.animations.length === 0) {
        this.animations.push(new _animation__WEBPACK_IMPORTED_MODULE_0__.Animation(this.name, "_matrix", source.animations[0].framePerSecond, _animation__WEBPACK_IMPORTED_MODULE_0__.Animation.ANIMATIONTYPE_MATRIX, 0));
        this.animations[0].setKeys([]);
    }
    // get animation info / verify there is such a range from the source bone
    var sourceRange = source.animations[0].getRange(rangeName);
    if (!sourceRange) {
        return false;
    }
    var from = sourceRange.from;
    var to = sourceRange.to;
    var sourceKeys = source.animations[0].getKeys();
    // rescaling prep
    var sourceBoneLength = source.length;
    var sourceParent = source.getParent();
    var parent = this.getParent();
    var parentScalingReqd = rescaleAsRequired && sourceParent && sourceBoneLength && this.length && sourceBoneLength !== this.length;
    var parentRatio = parentScalingReqd && parent && sourceParent ? parent.length / sourceParent.length : 1;
    var dimensionsScalingReqd = rescaleAsRequired && !parent && skelDimensionsRatio && (skelDimensionsRatio.x !== 1 || skelDimensionsRatio.y !== 1 || skelDimensionsRatio.z !== 1);
    var destKeys = this.animations[0].getKeys();
    // loop vars declaration
    var orig;
    var origTranslation;
    var mat;
    for (var key = 0, nKeys = sourceKeys.length; key < nKeys; key++) {
        orig = sourceKeys[key];
        if (orig.frame >= from && orig.frame <= to) {
            if (rescaleAsRequired) {
                mat = orig.value.clone();
                // scale based on parent ratio, when bone has parent
                if (parentScalingReqd) {
                    origTranslation = mat.getTranslation();
                    mat.setTranslation(origTranslation.scaleInPlace(parentRatio));
                    // scale based on skeleton dimension ratio when root bone, and value is passed
                }
                else if (dimensionsScalingReqd && skelDimensionsRatio) {
                    origTranslation = mat.getTranslation();
                    mat.setTranslation(origTranslation.multiplyInPlace(skelDimensionsRatio));
                    // use original when root bone, and no data for skelDimensionsRatio
                }
                else {
                    mat = orig.value;
                }
            }
            else {
                mat = orig.value;
            }
            destKeys.push({ frame: orig.frame + frameOffset, value: mat });
        }
    }
    this.animations[0].createRange(rangeName, from + frameOffset, to + frameOffset);
    return true;
};
//# sourceMappingURL=animatable.js.map

/***/ }),

/***/ "./node_modules/@babylonjs/core/Animations/animation.js":
/*!**************************************************************!*\
  !*** ./node_modules/@babylonjs/core/Animations/animation.js ***!
  \**************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Animation": () => (/* binding */ Animation),
/* harmony export */   "_IAnimationState": () => (/* binding */ _IAnimationState)
/* harmony export */ });
/* harmony import */ var _Maths_math_vector__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../Maths/math.vector */ "./node_modules/@babylonjs/core/Maths/math.vector.js");
/* harmony import */ var _Maths_math_color__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Maths/math.color */ "./node_modules/@babylonjs/core/Maths/math.color.js");
/* harmony import */ var _Maths_math_scalar__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Maths/math.scalar */ "./node_modules/@babylonjs/core/Maths/math.scalar.js");
/* harmony import */ var _Misc_decorators__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../Misc/decorators */ "./node_modules/@babylonjs/core/Misc/decorators.js");
/* harmony import */ var _Misc_typeStore__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../Misc/typeStore */ "./node_modules/@babylonjs/core/Misc/typeStore.js");
/* harmony import */ var _animationKey__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./animationKey */ "./node_modules/@babylonjs/core/Animations/animationKey.js");
/* harmony import */ var _animationRange__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./animationRange */ "./node_modules/@babylonjs/core/Animations/animationRange.js");
/* harmony import */ var _node__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../node */ "./node_modules/@babylonjs/core/node.js");
/* harmony import */ var _Maths_math_size__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../Maths/math.size */ "./node_modules/@babylonjs/core/Maths/math.size.js");









/**
 * @hidden
 */
var _IAnimationState = /** @class */ (function () {
    function _IAnimationState() {
    }
    return _IAnimationState;
}());

/**
 * Class used to store any kind of animation
 */
var Animation = /** @class */ (function () {
    /**
     * Initializes the animation
     * @param name Name of the animation
     * @param targetProperty Property to animate
     * @param framePerSecond The frames per second of the animation
     * @param dataType The data type of the animation
     * @param loopMode The loop mode of the animation
     * @param enableBlending Specifies if blending should be enabled
     */
    function Animation(
    /**Name of the animation */
    name, 
    /**Property to animate */
    targetProperty, 
    /**The frames per second of the animation */
    framePerSecond, 
    /**The data type of the animation */
    dataType, 
    /**The loop mode of the animation */
    loopMode, 
    /**Specifies if blending should be enabled */
    enableBlending) {
        this.name = name;
        this.targetProperty = targetProperty;
        this.framePerSecond = framePerSecond;
        this.dataType = dataType;
        this.loopMode = loopMode;
        this.enableBlending = enableBlending;
        /**
         * @hidden Internal use only
         */
        this._runtimeAnimations = new Array();
        /**
         * The set of event that will be linked to this animation
         */
        this._events = new Array();
        /**
         * Stores the blending speed of the animation
         */
        this.blendingSpeed = 0.01;
        /**
         * Stores the animation ranges for the animation
         */
        this._ranges = {};
        this.targetPropertyPath = targetProperty.split(".");
        this.dataType = dataType;
        this.loopMode = loopMode === undefined ? Animation.ANIMATIONLOOPMODE_CYCLE : loopMode;
    }
    /**
     * @hidden Internal use
     */
    Animation._PrepareAnimation = function (name, targetProperty, framePerSecond, totalFrame, from, to, loopMode, easingFunction) {
        var dataType = undefined;
        if (!isNaN(parseFloat(from)) && isFinite(from)) {
            dataType = Animation.ANIMATIONTYPE_FLOAT;
        }
        else if (from instanceof _Maths_math_vector__WEBPACK_IMPORTED_MODULE_0__.Quaternion) {
            dataType = Animation.ANIMATIONTYPE_QUATERNION;
        }
        else if (from instanceof _Maths_math_vector__WEBPACK_IMPORTED_MODULE_0__.Vector3) {
            dataType = Animation.ANIMATIONTYPE_VECTOR3;
        }
        else if (from instanceof _Maths_math_vector__WEBPACK_IMPORTED_MODULE_0__.Vector2) {
            dataType = Animation.ANIMATIONTYPE_VECTOR2;
        }
        else if (from instanceof _Maths_math_color__WEBPACK_IMPORTED_MODULE_1__.Color3) {
            dataType = Animation.ANIMATIONTYPE_COLOR3;
        }
        else if (from instanceof _Maths_math_color__WEBPACK_IMPORTED_MODULE_1__.Color4) {
            dataType = Animation.ANIMATIONTYPE_COLOR4;
        }
        else if (from instanceof _Maths_math_size__WEBPACK_IMPORTED_MODULE_8__.Size) {
            dataType = Animation.ANIMATIONTYPE_SIZE;
        }
        if (dataType == undefined) {
            return null;
        }
        var animation = new Animation(name, targetProperty, framePerSecond, dataType, loopMode);
        var keys = [{ frame: 0, value: from }, { frame: totalFrame, value: to }];
        animation.setKeys(keys);
        if (easingFunction !== undefined) {
            animation.setEasingFunction(easingFunction);
        }
        return animation;
    };
    /**
     * Sets up an animation
     * @param property The property to animate
     * @param animationType The animation type to apply
     * @param framePerSecond The frames per second of the animation
     * @param easingFunction The easing function used in the animation
     * @returns The created animation
     */
    Animation.CreateAnimation = function (property, animationType, framePerSecond, easingFunction) {
        var animation = new Animation(property + "Animation", property, framePerSecond, animationType, Animation.ANIMATIONLOOPMODE_CONSTANT);
        animation.setEasingFunction(easingFunction);
        return animation;
    };
    /**
     * Create and start an animation on a node
     * @param name defines the name of the global animation that will be run on all nodes
     * @param node defines the root node where the animation will take place
     * @param targetProperty defines property to animate
     * @param framePerSecond defines the number of frame per second yo use
     * @param totalFrame defines the number of frames in total
     * @param from defines the initial value
     * @param to defines the final value
     * @param loopMode defines which loop mode you want to use (off by default)
     * @param easingFunction defines the easing function to use (linear by default)
     * @param onAnimationEnd defines the callback to call when animation end
     * @returns the animatable created for this animation
     */
    Animation.CreateAndStartAnimation = function (name, node, targetProperty, framePerSecond, totalFrame, from, to, loopMode, easingFunction, onAnimationEnd) {
        var animation = Animation._PrepareAnimation(name, targetProperty, framePerSecond, totalFrame, from, to, loopMode, easingFunction);
        if (!animation) {
            return null;
        }
        return node.getScene().beginDirectAnimation(node, [animation], 0, totalFrame, (animation.loopMode === 1), 1.0, onAnimationEnd);
    };
    /**
     * Create and start an animation on a node and its descendants
     * @param name defines the name of the global animation that will be run on all nodes
     * @param node defines the root node where the animation will take place
     * @param directDescendantsOnly if true only direct descendants will be used, if false direct and also indirect (children of children, an so on in a recursive manner) descendants will be used
     * @param targetProperty defines property to animate
     * @param framePerSecond defines the number of frame per second to use
     * @param totalFrame defines the number of frames in total
     * @param from defines the initial value
     * @param to defines the final value
     * @param loopMode defines which loop mode you want to use (off by default)
     * @param easingFunction defines the easing function to use (linear by default)
     * @param onAnimationEnd defines the callback to call when an animation ends (will be called once per node)
     * @returns the list of animatables created for all nodes
     * @example https://www.babylonjs-playground.com/#MH0VLI
     */
    Animation.CreateAndStartHierarchyAnimation = function (name, node, directDescendantsOnly, targetProperty, framePerSecond, totalFrame, from, to, loopMode, easingFunction, onAnimationEnd) {
        var animation = Animation._PrepareAnimation(name, targetProperty, framePerSecond, totalFrame, from, to, loopMode, easingFunction);
        if (!animation) {
            return null;
        }
        var scene = node.getScene();
        return scene.beginDirectHierarchyAnimation(node, directDescendantsOnly, [animation], 0, totalFrame, (animation.loopMode === 1), 1.0, onAnimationEnd);
    };
    /**
     * Creates a new animation, merges it with the existing animations and starts it
     * @param name Name of the animation
     * @param node Node which contains the scene that begins the animations
     * @param targetProperty Specifies which property to animate
     * @param framePerSecond The frames per second of the animation
     * @param totalFrame The total number of frames
     * @param from The frame at the beginning of the animation
     * @param to The frame at the end of the animation
     * @param loopMode Specifies the loop mode of the animation
     * @param easingFunction (Optional) The easing function of the animation, which allow custom mathematical formulas for animations
     * @param onAnimationEnd Callback to run once the animation is complete
     * @returns Nullable animation
     */
    Animation.CreateMergeAndStartAnimation = function (name, node, targetProperty, framePerSecond, totalFrame, from, to, loopMode, easingFunction, onAnimationEnd) {
        var animation = Animation._PrepareAnimation(name, targetProperty, framePerSecond, totalFrame, from, to, loopMode, easingFunction);
        if (!animation) {
            return null;
        }
        node.animations.push(animation);
        return node.getScene().beginAnimation(node, 0, totalFrame, (animation.loopMode === 1), 1.0, onAnimationEnd);
    };
    /**
     * Transition property of an host to the target Value
     * @param property The property to transition
     * @param targetValue The target Value of the property
     * @param host The object where the property to animate belongs
     * @param scene Scene used to run the animation
     * @param frameRate Framerate (in frame/s) to use
     * @param transition The transition type we want to use
     * @param duration The duration of the animation, in milliseconds
     * @param onAnimationEnd Callback trigger at the end of the animation
     * @returns Nullable animation
     */
    Animation.TransitionTo = function (property, targetValue, host, scene, frameRate, transition, duration, onAnimationEnd) {
        if (onAnimationEnd === void 0) { onAnimationEnd = null; }
        if (duration <= 0) {
            host[property] = targetValue;
            if (onAnimationEnd) {
                onAnimationEnd();
            }
            return null;
        }
        var endFrame = frameRate * (duration / 1000);
        transition.setKeys([{
                frame: 0,
                value: host[property].clone ? host[property].clone() : host[property]
            },
            {
                frame: endFrame,
                value: targetValue
            }]);
        if (!host.animations) {
            host.animations = [];
        }
        host.animations.push(transition);
        var animation = scene.beginAnimation(host, 0, endFrame, false);
        animation.onAnimationEnd = onAnimationEnd;
        return animation;
    };
    Object.defineProperty(Animation.prototype, "runtimeAnimations", {
        /**
         * Return the array of runtime animations currently using this animation
         */
        get: function () {
            return this._runtimeAnimations;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(Animation.prototype, "hasRunningRuntimeAnimations", {
        /**
         * Specifies if any of the runtime animations are currently running
         */
        get: function () {
            for (var _i = 0, _a = this._runtimeAnimations; _i < _a.length; _i++) {
                var runtimeAnimation = _a[_i];
                if (!runtimeAnimation.isStopped) {
                    return true;
                }
            }
            return false;
        },
        enumerable: true,
        configurable: true
    });
    // Methods
    /**
     * Converts the animation to a string
     * @param fullDetails support for multiple levels of logging within scene loading
     * @returns String form of the animation
     */
    Animation.prototype.toString = function (fullDetails) {
        var ret = "Name: " + this.name + ", property: " + this.targetProperty;
        ret += ", datatype: " + (["Float", "Vector3", "Quaternion", "Matrix", "Color3", "Vector2"])[this.dataType];
        ret += ", nKeys: " + (this._keys ? this._keys.length : "none");
        ret += ", nRanges: " + (this._ranges ? Object.keys(this._ranges).length : "none");
        if (fullDetails) {
            ret += ", Ranges: {";
            var first = true;
            for (var name in this._ranges) {
                if (first) {
                    ret += ", ";
                    first = false;
                }
                ret += name;
            }
            ret += "}";
        }
        return ret;
    };
    /**
     * Add an event to this animation
     * @param event Event to add
     */
    Animation.prototype.addEvent = function (event) {
        this._events.push(event);
    };
    /**
     * Remove all events found at the given frame
     * @param frame The frame to remove events from
     */
    Animation.prototype.removeEvents = function (frame) {
        for (var index = 0; index < this._events.length; index++) {
            if (this._events[index].frame === frame) {
                this._events.splice(index, 1);
                index--;
            }
        }
    };
    /**
     * Retrieves all the events from the animation
     * @returns Events from the animation
     */
    Animation.prototype.getEvents = function () {
        return this._events;
    };
    /**
     * Creates an animation range
     * @param name Name of the animation range
     * @param from Starting frame of the animation range
     * @param to Ending frame of the animation
     */
    Animation.prototype.createRange = function (name, from, to) {
        // check name not already in use; could happen for bones after serialized
        if (!this._ranges[name]) {
            this._ranges[name] = new _animationRange__WEBPACK_IMPORTED_MODULE_6__.AnimationRange(name, from, to);
        }
    };
    /**
     * Deletes an animation range by name
     * @param name Name of the animation range to delete
     * @param deleteFrames Specifies if the key frames for the range should also be deleted (true) or not (false)
     */
    Animation.prototype.deleteRange = function (name, deleteFrames) {
        if (deleteFrames === void 0) { deleteFrames = true; }
        var range = this._ranges[name];
        if (!range) {
            return;
        }
        if (deleteFrames) {
            var from = range.from;
            var to = range.to;
            // this loop MUST go high to low for multiple splices to work
            for (var key = this._keys.length - 1; key >= 0; key--) {
                if (this._keys[key].frame >= from && this._keys[key].frame <= to) {
                    this._keys.splice(key, 1);
                }
            }
        }
        this._ranges[name] = null; // said much faster than 'delete this._range[name]'
    };
    /**
     * Gets the animation range by name, or null if not defined
     * @param name Name of the animation range
     * @returns Nullable animation range
     */
    Animation.prototype.getRange = function (name) {
        return this._ranges[name];
    };
    /**
     * Gets the key frames from the animation
     * @returns The key frames of the animation
     */
    Animation.prototype.getKeys = function () {
        return this._keys;
    };
    /**
     * Gets the highest frame rate of the animation
     * @returns Highest frame rate of the animation
     */
    Animation.prototype.getHighestFrame = function () {
        var ret = 0;
        for (var key = 0, nKeys = this._keys.length; key < nKeys; key++) {
            if (ret < this._keys[key].frame) {
                ret = this._keys[key].frame;
            }
        }
        return ret;
    };
    /**
     * Gets the easing function of the animation
     * @returns Easing function of the animation
     */
    Animation.prototype.getEasingFunction = function () {
        return this._easingFunction;
    };
    /**
     * Sets the easing function of the animation
     * @param easingFunction A custom mathematical formula for animation
     */
    Animation.prototype.setEasingFunction = function (easingFunction) {
        this._easingFunction = easingFunction;
    };
    /**
     * Interpolates a scalar linearly
     * @param startValue Start value of the animation curve
     * @param endValue End value of the animation curve
     * @param gradient Scalar amount to interpolate
     * @returns Interpolated scalar value
     */
    Animation.prototype.floatInterpolateFunction = function (startValue, endValue, gradient) {
        return _Maths_math_scalar__WEBPACK_IMPORTED_MODULE_2__.Scalar.Lerp(startValue, endValue, gradient);
    };
    /**
     * Interpolates a scalar cubically
     * @param startValue Start value of the animation curve
     * @param outTangent End tangent of the animation
     * @param endValue End value of the animation curve
     * @param inTangent Start tangent of the animation curve
     * @param gradient Scalar amount to interpolate
     * @returns Interpolated scalar value
     */
    Animation.prototype.floatInterpolateFunctionWithTangents = function (startValue, outTangent, endValue, inTangent, gradient) {
        return _Maths_math_scalar__WEBPACK_IMPORTED_MODULE_2__.Scalar.Hermite(startValue, outTangent, endValue, inTangent, gradient);
    };
    /**
     * Interpolates a quaternion using a spherical linear interpolation
     * @param startValue Start value of the animation curve
     * @param endValue End value of the animation curve
     * @param gradient Scalar amount to interpolate
     * @returns Interpolated quaternion value
     */
    Animation.prototype.quaternionInterpolateFunction = function (startValue, endValue, gradient) {
        return _Maths_math_vector__WEBPACK_IMPORTED_MODULE_0__.Quaternion.Slerp(startValue, endValue, gradient);
    };
    /**
     * Interpolates a quaternion cubically
     * @param startValue Start value of the animation curve
     * @param outTangent End tangent of the animation curve
     * @param endValue End value of the animation curve
     * @param inTangent Start tangent of the animation curve
     * @param gradient Scalar amount to interpolate
     * @returns Interpolated quaternion value
     */
    Animation.prototype.quaternionInterpolateFunctionWithTangents = function (startValue, outTangent, endValue, inTangent, gradient) {
        return _Maths_math_vector__WEBPACK_IMPORTED_MODULE_0__.Quaternion.Hermite(startValue, outTangent, endValue, inTangent, gradient).normalize();
    };
    /**
     * Interpolates a Vector3 linearl
     * @param startValue Start value of the animation curve
     * @param endValue End value of the animation curve
     * @param gradient Scalar amount to interpolate
     * @returns Interpolated scalar value
     */
    Animation.prototype.vector3InterpolateFunction = function (startValue, endValue, gradient) {
        return _Maths_math_vector__WEBPACK_IMPORTED_MODULE_0__.Vector3.Lerp(startValue, endValue, gradient);
    };
    /**
     * Interpolates a Vector3 cubically
     * @param startValue Start value of the animation curve
     * @param outTangent End tangent of the animation
     * @param endValue End value of the animation curve
     * @param inTangent Start tangent of the animation curve
     * @param gradient Scalar amount to interpolate
     * @returns InterpolatedVector3 value
     */
    Animation.prototype.vector3InterpolateFunctionWithTangents = function (startValue, outTangent, endValue, inTangent, gradient) {
        return _Maths_math_vector__WEBPACK_IMPORTED_MODULE_0__.Vector3.Hermite(startValue, outTangent, endValue, inTangent, gradient);
    };
    /**
     * Interpolates a Vector2 linearly
     * @param startValue Start value of the animation curve
     * @param endValue End value of the animation curve
     * @param gradient Scalar amount to interpolate
     * @returns Interpolated Vector2 value
     */
    Animation.prototype.vector2InterpolateFunction = function (startValue, endValue, gradient) {
        return _Maths_math_vector__WEBPACK_IMPORTED_MODULE_0__.Vector2.Lerp(startValue, endValue, gradient);
    };
    /**
     * Interpolates a Vector2 cubically
     * @param startValue Start value of the animation curve
     * @param outTangent End tangent of the animation
     * @param endValue End value of the animation curve
     * @param inTangent Start tangent of the animation curve
     * @param gradient Scalar amount to interpolate
     * @returns Interpolated Vector2 value
     */
    Animation.prototype.vector2InterpolateFunctionWithTangents = function (startValue, outTangent, endValue, inTangent, gradient) {
        return _Maths_math_vector__WEBPACK_IMPORTED_MODULE_0__.Vector2.Hermite(startValue, outTangent, endValue, inTangent, gradient);
    };
    /**
     * Interpolates a size linearly
     * @param startValue Start value of the animation curve
     * @param endValue End value of the animation curve
     * @param gradient Scalar amount to interpolate
     * @returns Interpolated Size value
     */
    Animation.prototype.sizeInterpolateFunction = function (startValue, endValue, gradient) {
        return _Maths_math_size__WEBPACK_IMPORTED_MODULE_8__.Size.Lerp(startValue, endValue, gradient);
    };
    /**
     * Interpolates a Color3 linearly
     * @param startValue Start value of the animation curve
     * @param endValue End value of the animation curve
     * @param gradient Scalar amount to interpolate
     * @returns Interpolated Color3 value
     */
    Animation.prototype.color3InterpolateFunction = function (startValue, endValue, gradient) {
        return _Maths_math_color__WEBPACK_IMPORTED_MODULE_1__.Color3.Lerp(startValue, endValue, gradient);
    };
    /**
     * Interpolates a Color4 linearly
     * @param startValue Start value of the animation curve
     * @param endValue End value of the animation curve
     * @param gradient Scalar amount to interpolate
     * @returns Interpolated Color3 value
     */
    Animation.prototype.color4InterpolateFunction = function (startValue, endValue, gradient) {
        return _Maths_math_color__WEBPACK_IMPORTED_MODULE_1__.Color4.Lerp(startValue, endValue, gradient);
    };
    /**
     * @hidden Internal use only
     */
    Animation.prototype._getKeyValue = function (value) {
        if (typeof value === "function") {
            return value();
        }
        return value;
    };
    /**
     * @hidden Internal use only
     */
    Animation.prototype._interpolate = function (currentFrame, state) {
        if (state.loopMode === Animation.ANIMATIONLOOPMODE_CONSTANT && state.repeatCount > 0) {
            return state.highLimitValue.clone ? state.highLimitValue.clone() : state.highLimitValue;
        }
        var keys = this._keys;
        if (keys.length === 1) {
            return this._getKeyValue(keys[0].value);
        }
        var startKeyIndex = state.key;
        if (keys[startKeyIndex].frame >= currentFrame) {
            while (startKeyIndex - 1 >= 0 && keys[startKeyIndex].frame >= currentFrame) {
                startKeyIndex--;
            }
        }
        for (var key = startKeyIndex; key < keys.length; key++) {
            var endKey = keys[key + 1];
            if (endKey.frame >= currentFrame) {
                state.key = key;
                var startKey = keys[key];
                var startValue = this._getKeyValue(startKey.value);
                if (startKey.interpolation === _animationKey__WEBPACK_IMPORTED_MODULE_5__.AnimationKeyInterpolation.STEP) {
                    return startValue;
                }
                var endValue = this._getKeyValue(endKey.value);
                var useTangent = startKey.outTangent !== undefined && endKey.inTangent !== undefined;
                var frameDelta = endKey.frame - startKey.frame;
                // gradient : percent of currentFrame between the frame inf and the frame sup
                var gradient = (currentFrame - startKey.frame) / frameDelta;
                // check for easingFunction and correction of gradient
                var easingFunction = this.getEasingFunction();
                if (easingFunction != null) {
                    gradient = easingFunction.ease(gradient);
                }
                switch (this.dataType) {
                    // Float
                    case Animation.ANIMATIONTYPE_FLOAT:
                        var floatValue = useTangent ? this.floatInterpolateFunctionWithTangents(startValue, startKey.outTangent * frameDelta, endValue, endKey.inTangent * frameDelta, gradient) : this.floatInterpolateFunction(startValue, endValue, gradient);
                        switch (state.loopMode) {
                            case Animation.ANIMATIONLOOPMODE_CYCLE:
                            case Animation.ANIMATIONLOOPMODE_CONSTANT:
                                return floatValue;
                            case Animation.ANIMATIONLOOPMODE_RELATIVE:
                                return state.offsetValue * state.repeatCount + floatValue;
                        }
                        break;
                    // Quaternion
                    case Animation.ANIMATIONTYPE_QUATERNION:
                        var quatValue = useTangent ? this.quaternionInterpolateFunctionWithTangents(startValue, startKey.outTangent.scale(frameDelta), endValue, endKey.inTangent.scale(frameDelta), gradient) : this.quaternionInterpolateFunction(startValue, endValue, gradient);
                        switch (state.loopMode) {
                            case Animation.ANIMATIONLOOPMODE_CYCLE:
                            case Animation.ANIMATIONLOOPMODE_CONSTANT:
                                return quatValue;
                            case Animation.ANIMATIONLOOPMODE_RELATIVE:
                                return quatValue.addInPlace(state.offsetValue.scale(state.repeatCount));
                        }
                        return quatValue;
                    // Vector3
                    case Animation.ANIMATIONTYPE_VECTOR3:
                        var vec3Value = useTangent ? this.vector3InterpolateFunctionWithTangents(startValue, startKey.outTangent.scale(frameDelta), endValue, endKey.inTangent.scale(frameDelta), gradient) : this.vector3InterpolateFunction(startValue, endValue, gradient);
                        switch (state.loopMode) {
                            case Animation.ANIMATIONLOOPMODE_CYCLE:
                            case Animation.ANIMATIONLOOPMODE_CONSTANT:
                                return vec3Value;
                            case Animation.ANIMATIONLOOPMODE_RELATIVE:
                                return vec3Value.add(state.offsetValue.scale(state.repeatCount));
                        }
                    // Vector2
                    case Animation.ANIMATIONTYPE_VECTOR2:
                        var vec2Value = useTangent ? this.vector2InterpolateFunctionWithTangents(startValue, startKey.outTangent.scale(frameDelta), endValue, endKey.inTangent.scale(frameDelta), gradient) : this.vector2InterpolateFunction(startValue, endValue, gradient);
                        switch (state.loopMode) {
                            case Animation.ANIMATIONLOOPMODE_CYCLE:
                            case Animation.ANIMATIONLOOPMODE_CONSTANT:
                                return vec2Value;
                            case Animation.ANIMATIONLOOPMODE_RELATIVE:
                                return vec2Value.add(state.offsetValue.scale(state.repeatCount));
                        }
                    // Size
                    case Animation.ANIMATIONTYPE_SIZE:
                        switch (state.loopMode) {
                            case Animation.ANIMATIONLOOPMODE_CYCLE:
                            case Animation.ANIMATIONLOOPMODE_CONSTANT:
                                return this.sizeInterpolateFunction(startValue, endValue, gradient);
                            case Animation.ANIMATIONLOOPMODE_RELATIVE:
                                return this.sizeInterpolateFunction(startValue, endValue, gradient).add(state.offsetValue.scale(state.repeatCount));
                        }
                    // Color3
                    case Animation.ANIMATIONTYPE_COLOR3:
                        switch (state.loopMode) {
                            case Animation.ANIMATIONLOOPMODE_CYCLE:
                            case Animation.ANIMATIONLOOPMODE_CONSTANT:
                                return this.color3InterpolateFunction(startValue, endValue, gradient);
                            case Animation.ANIMATIONLOOPMODE_RELATIVE:
                                return this.color3InterpolateFunction(startValue, endValue, gradient).add(state.offsetValue.scale(state.repeatCount));
                        }
                    // Color4
                    case Animation.ANIMATIONTYPE_COLOR4:
                        switch (state.loopMode) {
                            case Animation.ANIMATIONLOOPMODE_CYCLE:
                            case Animation.ANIMATIONLOOPMODE_CONSTANT:
                                return this.color4InterpolateFunction(startValue, endValue, gradient);
                            case Animation.ANIMATIONLOOPMODE_RELATIVE:
                                return this.color4InterpolateFunction(startValue, endValue, gradient).add(state.offsetValue.scale(state.repeatCount));
                        }
                    // Matrix
                    case Animation.ANIMATIONTYPE_MATRIX:
                        switch (state.loopMode) {
                            case Animation.ANIMATIONLOOPMODE_CYCLE:
                            case Animation.ANIMATIONLOOPMODE_CONSTANT:
                                if (Animation.AllowMatricesInterpolation) {
                                    return this.matrixInterpolateFunction(startValue, endValue, gradient, state.workValue);
                                }
                            case Animation.ANIMATIONLOOPMODE_RELATIVE:
                                return startValue;
                        }
                    default:
                        break;
                }
                break;
            }
        }
        return this._getKeyValue(keys[keys.length - 1].value);
    };
    /**
     * Defines the function to use to interpolate matrices
     * @param startValue defines the start matrix
     * @param endValue defines the end matrix
     * @param gradient defines the gradient between both matrices
     * @param result defines an optional target matrix where to store the interpolation
     * @returns the interpolated matrix
     */
    Animation.prototype.matrixInterpolateFunction = function (startValue, endValue, gradient, result) {
        if (Animation.AllowMatrixDecomposeForInterpolation) {
            if (result) {
                _Maths_math_vector__WEBPACK_IMPORTED_MODULE_0__.Matrix.DecomposeLerpToRef(startValue, endValue, gradient, result);
                return result;
            }
            return _Maths_math_vector__WEBPACK_IMPORTED_MODULE_0__.Matrix.DecomposeLerp(startValue, endValue, gradient);
        }
        if (result) {
            _Maths_math_vector__WEBPACK_IMPORTED_MODULE_0__.Matrix.LerpToRef(startValue, endValue, gradient, result);
            return result;
        }
        return _Maths_math_vector__WEBPACK_IMPORTED_MODULE_0__.Matrix.Lerp(startValue, endValue, gradient);
    };
    /**
     * Makes a copy of the animation
     * @returns Cloned animation
     */
    Animation.prototype.clone = function () {
        var clone = new Animation(this.name, this.targetPropertyPath.join("."), this.framePerSecond, this.dataType, this.loopMode);
        clone.enableBlending = this.enableBlending;
        clone.blendingSpeed = this.blendingSpeed;
        if (this._keys) {
            clone.setKeys(this._keys);
        }
        if (this._ranges) {
            clone._ranges = {};
            for (var name in this._ranges) {
                var range = this._ranges[name];
                if (!range) {
                    continue;
                }
                clone._ranges[name] = range.clone();
            }
        }
        return clone;
    };
    /**
     * Sets the key frames of the animation
     * @param values The animation key frames to set
     */
    Animation.prototype.setKeys = function (values) {
        this._keys = values.slice(0);
    };
    /**
     * Serializes the animation to an object
     * @returns Serialized object
     */
    Animation.prototype.serialize = function () {
        var serializationObject = {};
        serializationObject.name = this.name;
        serializationObject.property = this.targetProperty;
        serializationObject.framePerSecond = this.framePerSecond;
        serializationObject.dataType = this.dataType;
        serializationObject.loopBehavior = this.loopMode;
        serializationObject.enableBlending = this.enableBlending;
        serializationObject.blendingSpeed = this.blendingSpeed;
        var dataType = this.dataType;
        serializationObject.keys = [];
        var keys = this.getKeys();
        for (var index = 0; index < keys.length; index++) {
            var animationKey = keys[index];
            var key = {};
            key.frame = animationKey.frame;
            switch (dataType) {
                case Animation.ANIMATIONTYPE_FLOAT:
                    key.values = [animationKey.value];
                    break;
                case Animation.ANIMATIONTYPE_QUATERNION:
                case Animation.ANIMATIONTYPE_MATRIX:
                case Animation.ANIMATIONTYPE_VECTOR3:
                case Animation.ANIMATIONTYPE_COLOR3:
                case Animation.ANIMATIONTYPE_COLOR4:
                    key.values = animationKey.value.asArray();
                    break;
            }
            serializationObject.keys.push(key);
        }
        serializationObject.ranges = [];
        for (var name in this._ranges) {
            var source = this._ranges[name];
            if (!source) {
                continue;
            }
            var range = {};
            range.name = name;
            range.from = source.from;
            range.to = source.to;
            serializationObject.ranges.push(range);
        }
        return serializationObject;
    };
    /** @hidden */
    Animation._UniversalLerp = function (left, right, amount) {
        var constructor = left.constructor;
        if (constructor.Lerp) { // Lerp supported
            return constructor.Lerp(left, right, amount);
        }
        else if (constructor.Slerp) { // Slerp supported
            return constructor.Slerp(left, right, amount);
        }
        else if (left.toFixed) { // Number
            return left * (1.0 - amount) + amount * right;
        }
        else { // Blending not supported
            return right;
        }
    };
    /**
     * Parses an animation object and creates an animation
     * @param parsedAnimation Parsed animation object
     * @returns Animation object
     */
    Animation.Parse = function (parsedAnimation) {
        var animation = new Animation(parsedAnimation.name, parsedAnimation.property, parsedAnimation.framePerSecond, parsedAnimation.dataType, parsedAnimation.loopBehavior);
        var dataType = parsedAnimation.dataType;
        var keys = [];
        var data;
        var index;
        if (parsedAnimation.enableBlending) {
            animation.enableBlending = parsedAnimation.enableBlending;
        }
        if (parsedAnimation.blendingSpeed) {
            animation.blendingSpeed = parsedAnimation.blendingSpeed;
        }
        for (index = 0; index < parsedAnimation.keys.length; index++) {
            var key = parsedAnimation.keys[index];
            var inTangent;
            var outTangent;
            switch (dataType) {
                case Animation.ANIMATIONTYPE_FLOAT:
                    data = key.values[0];
                    if (key.values.length >= 1) {
                        inTangent = key.values[1];
                    }
                    if (key.values.length >= 2) {
                        outTangent = key.values[2];
                    }
                    break;
                case Animation.ANIMATIONTYPE_QUATERNION:
                    data = _Maths_math_vector__WEBPACK_IMPORTED_MODULE_0__.Quaternion.FromArray(key.values);
                    if (key.values.length >= 8) {
                        var _inTangent = _Maths_math_vector__WEBPACK_IMPORTED_MODULE_0__.Quaternion.FromArray(key.values.slice(4, 8));
                        if (!_inTangent.equals(_Maths_math_vector__WEBPACK_IMPORTED_MODULE_0__.Quaternion.Zero())) {
                            inTangent = _inTangent;
                        }
                    }
                    if (key.values.length >= 12) {
                        var _outTangent = _Maths_math_vector__WEBPACK_IMPORTED_MODULE_0__.Quaternion.FromArray(key.values.slice(8, 12));
                        if (!_outTangent.equals(_Maths_math_vector__WEBPACK_IMPORTED_MODULE_0__.Quaternion.Zero())) {
                            outTangent = _outTangent;
                        }
                    }
                    break;
                case Animation.ANIMATIONTYPE_MATRIX:
                    data = _Maths_math_vector__WEBPACK_IMPORTED_MODULE_0__.Matrix.FromArray(key.values);
                    break;
                case Animation.ANIMATIONTYPE_COLOR3:
                    data = _Maths_math_color__WEBPACK_IMPORTED_MODULE_1__.Color3.FromArray(key.values);
                    break;
                case Animation.ANIMATIONTYPE_COLOR4:
                    data = _Maths_math_color__WEBPACK_IMPORTED_MODULE_1__.Color4.FromArray(key.values);
                    break;
                case Animation.ANIMATIONTYPE_VECTOR3:
                default:
                    data = _Maths_math_vector__WEBPACK_IMPORTED_MODULE_0__.Vector3.FromArray(key.values);
                    break;
            }
            var keyData = {};
            keyData.frame = key.frame;
            keyData.value = data;
            if (inTangent != undefined) {
                keyData.inTangent = inTangent;
            }
            if (outTangent != undefined) {
                keyData.outTangent = outTangent;
            }
            keys.push(keyData);
        }
        animation.setKeys(keys);
        if (parsedAnimation.ranges) {
            for (index = 0; index < parsedAnimation.ranges.length; index++) {
                data = parsedAnimation.ranges[index];
                animation.createRange(data.name, data.from, data.to);
            }
        }
        return animation;
    };
    /**
     * Appends the serialized animations from the source animations
     * @param source Source containing the animations
     * @param destination Target to store the animations
     */
    Animation.AppendSerializedAnimations = function (source, destination) {
        _Misc_decorators__WEBPACK_IMPORTED_MODULE_3__.SerializationHelper.AppendSerializedAnimations(source, destination);
    };
    /**
     * Use matrix interpolation instead of using direct key value when animating matrices
     */
    Animation.AllowMatricesInterpolation = false;
    /**
     * When matrix interpolation is enabled, this boolean forces the system to use Matrix.DecomposeLerp instead of Matrix.Lerp. Interpolation is more precise but slower
     */
    Animation.AllowMatrixDecomposeForInterpolation = true;
    // Statics
    /**
     * Float animation type
     */
    Animation.ANIMATIONTYPE_FLOAT = 0;
    /**
     * Vector3 animation type
     */
    Animation.ANIMATIONTYPE_VECTOR3 = 1;
    /**
     * Quaternion animation type
     */
    Animation.ANIMATIONTYPE_QUATERNION = 2;
    /**
     * Matrix animation type
     */
    Animation.ANIMATIONTYPE_MATRIX = 3;
    /**
     * Color3 animation type
     */
    Animation.ANIMATIONTYPE_COLOR3 = 4;
    /**
     * Color3 animation type
     */
    Animation.ANIMATIONTYPE_COLOR4 = 7;
    /**
     * Vector2 animation type
     */
    Animation.ANIMATIONTYPE_VECTOR2 = 5;
    /**
     * Size animation type
     */
    Animation.ANIMATIONTYPE_SIZE = 6;
    /**
     * Relative Loop Mode
     */
    Animation.ANIMATIONLOOPMODE_RELATIVE = 0;
    /**
     * Cycle Loop Mode
     */
    Animation.ANIMATIONLOOPMODE_CYCLE = 1;
    /**
     * Constant Loop Mode
     */
    Animation.ANIMATIONLOOPMODE_CONSTANT = 2;
    return Animation;
}());

_Misc_typeStore__WEBPACK_IMPORTED_MODULE_4__._TypeStore.RegisteredTypes["BABYLON.Animation"] = Animation;
_node__WEBPACK_IMPORTED_MODULE_7__.Node._AnimationRangeFactory = function (name, from, to) { return new _animationRange__WEBPACK_IMPORTED_MODULE_6__.AnimationRange(name, from, to); };
//# sourceMappingURL=animation.js.map

/***/ }),

/***/ "./node_modules/@babylonjs/core/Animations/animationEvent.js":
/*!*******************************************************************!*\
  !*** ./node_modules/@babylonjs/core/Animations/animationEvent.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "AnimationEvent": () => (/* binding */ AnimationEvent)
/* harmony export */ });
/**
 * Composed of a frame, and an action function
 */
var AnimationEvent = /** @class */ (function () {
    /**
     * Initializes the animation event
     * @param frame The frame for which the event is triggered
     * @param action The event to perform when triggered
     * @param onlyOnce Specifies if the event should be triggered only once
     */
    function AnimationEvent(
    /** The frame for which the event is triggered **/
    frame, 
    /** The event to perform when triggered **/
    action, 
    /** Specifies if the event should be triggered only once**/
    onlyOnce) {
        this.frame = frame;
        this.action = action;
        this.onlyOnce = onlyOnce;
        /**
         * Specifies if the animation event is done
         */
        this.isDone = false;
    }
    /** @hidden */
    AnimationEvent.prototype._clone = function () {
        return new AnimationEvent(this.frame, this.action, this.onlyOnce);
    };
    return AnimationEvent;
}());

//# sourceMappingURL=animationEvent.js.map

/***/ }),

/***/ "./node_modules/@babylonjs/core/Animations/animationGroup.js":
/*!*******************************************************************!*\
  !*** ./node_modules/@babylonjs/core/Animations/animationGroup.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "AnimationGroup": () => (/* binding */ AnimationGroup),
/* harmony export */   "TargetedAnimation": () => (/* binding */ TargetedAnimation)
/* harmony export */ });
/* harmony import */ var _animation__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./animation */ "./node_modules/@babylonjs/core/Animations/animation.js");
/* harmony import */ var _Misc_observable__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Misc/observable */ "./node_modules/@babylonjs/core/Misc/observable.js");
/* harmony import */ var _Engines_engineStore__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Engines/engineStore */ "./node_modules/@babylonjs/core/Engines/engineStore.js");
/* harmony import */ var _animatable__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./animatable */ "./node_modules/@babylonjs/core/Animations/animatable.js");




/**
 * This class defines the direct association between an animation and a target
 */
var TargetedAnimation = /** @class */ (function () {
    function TargetedAnimation() {
    }
    /**
     * Serialize the object
     * @returns the JSON object representing the current entity
     */
    TargetedAnimation.prototype.serialize = function () {
        var serializationObject = {};
        serializationObject.animation = this.animation.serialize();
        serializationObject.targetId = this.target.id;
        return serializationObject;
    };
    return TargetedAnimation;
}());

/**
 * Use this class to create coordinated animations on multiple targets
 */
var AnimationGroup = /** @class */ (function () {
    /**
     * Instantiates a new Animation Group.
     * This helps managing several animations at once.
     * @see http://doc.babylonjs.com/how_to/group
     * @param name Defines the name of the group
     * @param scene Defines the scene the group belongs to
     */
    function AnimationGroup(
    /** The name of the animation group */
    name, scene) {
        if (scene === void 0) { scene = null; }
        this.name = name;
        this._targetedAnimations = new Array();
        this._animatables = new Array();
        this._from = Number.MAX_VALUE;
        this._to = -Number.MAX_VALUE;
        this._speedRatio = 1;
        this._loopAnimation = false;
        /**
         * This observable will notify when one animation have ended
         */
        this.onAnimationEndObservable = new _Misc_observable__WEBPACK_IMPORTED_MODULE_1__.Observable();
        /**
         * Observer raised when one animation loops
         */
        this.onAnimationLoopObservable = new _Misc_observable__WEBPACK_IMPORTED_MODULE_1__.Observable();
        /**
         * Observer raised when all animations have looped
         */
        this.onAnimationGroupLoopObservable = new _Misc_observable__WEBPACK_IMPORTED_MODULE_1__.Observable();
        /**
         * This observable will notify when all animations have ended.
         */
        this.onAnimationGroupEndObservable = new _Misc_observable__WEBPACK_IMPORTED_MODULE_1__.Observable();
        /**
         * This observable will notify when all animations have paused.
         */
        this.onAnimationGroupPauseObservable = new _Misc_observable__WEBPACK_IMPORTED_MODULE_1__.Observable();
        /**
         * This observable will notify when all animations are playing.
         */
        this.onAnimationGroupPlayObservable = new _Misc_observable__WEBPACK_IMPORTED_MODULE_1__.Observable();
        this._scene = scene || _Engines_engineStore__WEBPACK_IMPORTED_MODULE_2__.EngineStore.LastCreatedScene;
        this.uniqueId = this._scene.getUniqueId();
        this._scene.animationGroups.push(this);
    }
    Object.defineProperty(AnimationGroup.prototype, "from", {
        /**
         * Gets the first frame
         */
        get: function () {
            return this._from;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(AnimationGroup.prototype, "to", {
        /**
         * Gets the last frame
         */
        get: function () {
            return this._to;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(AnimationGroup.prototype, "isStarted", {
        /**
         * Define if the animations are started
         */
        get: function () {
            return this._isStarted;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(AnimationGroup.prototype, "isPlaying", {
        /**
         * Gets a value indicating that the current group is playing
         */
        get: function () {
            return this._isStarted && !this._isPaused;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(AnimationGroup.prototype, "speedRatio", {
        /**
         * Gets or sets the speed ratio to use for all animations
         */
        get: function () {
            return this._speedRatio;
        },
        /**
         * Gets or sets the speed ratio to use for all animations
         */
        set: function (value) {
            if (this._speedRatio === value) {
                return;
            }
            this._speedRatio = value;
            for (var index = 0; index < this._animatables.length; index++) {
                var animatable = this._animatables[index];
                animatable.speedRatio = this._speedRatio;
            }
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(AnimationGroup.prototype, "loopAnimation", {
        /**
         * Gets or sets if all animations should loop or not
         */
        get: function () {
            return this._loopAnimation;
        },
        set: function (value) {
            if (this._loopAnimation === value) {
                return;
            }
            this._loopAnimation = value;
            for (var index = 0; index < this._animatables.length; index++) {
                var animatable = this._animatables[index];
                animatable.loopAnimation = this._loopAnimation;
            }
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(AnimationGroup.prototype, "targetedAnimations", {
        /**
         * Gets the targeted animations for this animation group
         */
        get: function () {
            return this._targetedAnimations;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(AnimationGroup.prototype, "animatables", {
        /**
         * returning the list of animatables controlled by this animation group.
         */
        get: function () {
            return this._animatables;
        },
        enumerable: true,
        configurable: true
    });
    /**
     * Add an animation (with its target) in the group
     * @param animation defines the animation we want to add
     * @param target defines the target of the animation
     * @returns the TargetedAnimation object
     */
    AnimationGroup.prototype.addTargetedAnimation = function (animation, target) {
        var targetedAnimation = new TargetedAnimation();
        targetedAnimation.animation = animation;
        targetedAnimation.target = target;
        var keys = animation.getKeys();
        if (this._from > keys[0].frame) {
            this._from = keys[0].frame;
        }
        if (this._to < keys[keys.length - 1].frame) {
            this._to = keys[keys.length - 1].frame;
        }
        this._targetedAnimations.push(targetedAnimation);
        return targetedAnimation;
    };
    /**
     * This function will normalize every animation in the group to make sure they all go from beginFrame to endFrame
     * It can add constant keys at begin or end
     * @param beginFrame defines the new begin frame for all animations or the smallest begin frame of all animations if null (defaults to null)
     * @param endFrame defines the new end frame for all animations or the largest end frame of all animations if null (defaults to null)
     * @returns the animation group
     */
    AnimationGroup.prototype.normalize = function (beginFrame, endFrame) {
        if (beginFrame === void 0) { beginFrame = null; }
        if (endFrame === void 0) { endFrame = null; }
        if (beginFrame == null) {
            beginFrame = this._from;
        }
        if (endFrame == null) {
            endFrame = this._to;
        }
        for (var index = 0; index < this._targetedAnimations.length; index++) {
            var targetedAnimation = this._targetedAnimations[index];
            var keys = targetedAnimation.animation.getKeys();
            var startKey = keys[0];
            var endKey = keys[keys.length - 1];
            if (startKey.frame > beginFrame) {
                var newKey = {
                    frame: beginFrame,
                    value: startKey.value,
                    inTangent: startKey.inTangent,
                    outTangent: startKey.outTangent,
                    interpolation: startKey.interpolation
                };
                keys.splice(0, 0, newKey);
            }
            if (endKey.frame < endFrame) {
                var newKey = {
                    frame: endFrame,
                    value: endKey.value,
                    inTangent: endKey.outTangent,
                    outTangent: endKey.outTangent,
                    interpolation: endKey.interpolation
                };
                keys.push(newKey);
            }
        }
        this._from = beginFrame;
        this._to = endFrame;
        return this;
    };
    AnimationGroup.prototype._processLoop = function (animatable, targetedAnimation, index) {
        var _this = this;
        animatable.onAnimationLoop = function () {
            _this.onAnimationLoopObservable.notifyObservers(targetedAnimation);
            if (_this._animationLoopFlags[index]) {
                return;
            }
            _this._animationLoopFlags[index] = true;
            _this._animationLoopCount++;
            if (_this._animationLoopCount === _this._targetedAnimations.length) {
                _this.onAnimationGroupLoopObservable.notifyObservers(_this);
                _this._animationLoopCount = 0;
                _this._animationLoopFlags = [];
            }
        };
    };
    /**
     * Start all animations on given targets
     * @param loop defines if animations must loop
     * @param speedRatio defines the ratio to apply to animation speed (1 by default)
     * @param from defines the from key (optional)
     * @param to defines the to key (optional)
     * @returns the current animation group
     */
    AnimationGroup.prototype.start = function (loop, speedRatio, from, to) {
        var _this = this;
        if (loop === void 0) { loop = false; }
        if (speedRatio === void 0) { speedRatio = 1; }
        if (this._isStarted || this._targetedAnimations.length === 0) {
            return this;
        }
        this._loopAnimation = loop;
        this._animationLoopCount = 0;
        this._animationLoopFlags = [];
        var _loop_1 = function () {
            var targetedAnimation = this_1._targetedAnimations[index];
            var animatable = this_1._scene.beginDirectAnimation(targetedAnimation.target, [targetedAnimation.animation], from !== undefined ? from : this_1._from, to !== undefined ? to : this_1._to, loop, speedRatio);
            animatable.onAnimationEnd = function () {
                _this.onAnimationEndObservable.notifyObservers(targetedAnimation);
                _this._checkAnimationGroupEnded(animatable);
            };
            this_1._processLoop(animatable, targetedAnimation, index);
            this_1._animatables.push(animatable);
        };
        var this_1 = this;
        for (var index = 0; index < this._targetedAnimations.length; index++) {
            _loop_1();
        }
        this._speedRatio = speedRatio;
        if (from !== undefined && to !== undefined) {
            if (from < to && this._speedRatio < 0) {
                var temp = to;
                to = from;
                from = temp;
            }
            else if (from > to && this._speedRatio > 0) {
                this._speedRatio = -speedRatio;
            }
        }
        this._isStarted = true;
        this._isPaused = false;
        this.onAnimationGroupPlayObservable.notifyObservers(this);
        return this;
    };
    /**
     * Pause all animations
     * @returns the animation group
     */
    AnimationGroup.prototype.pause = function () {
        if (!this._isStarted) {
            return this;
        }
        this._isPaused = true;
        for (var index = 0; index < this._animatables.length; index++) {
            var animatable = this._animatables[index];
            animatable.pause();
        }
        this.onAnimationGroupPauseObservable.notifyObservers(this);
        return this;
    };
    /**
     * Play all animations to initial state
     * This function will start() the animations if they were not started or will restart() them if they were paused
     * @param loop defines if animations must loop
     * @returns the animation group
     */
    AnimationGroup.prototype.play = function (loop) {
        // only if all animatables are ready and exist
        if (this.isStarted && this._animatables.length === this._targetedAnimations.length) {
            if (loop !== undefined) {
                this.loopAnimation = loop;
            }
            this.restart();
        }
        else {
            this.stop();
            this.start(loop, this._speedRatio);
        }
        this._isPaused = false;
        return this;
    };
    /**
     * Reset all animations to initial state
     * @returns the animation group
     */
    AnimationGroup.prototype.reset = function () {
        if (!this._isStarted) {
            return this;
        }
        for (var index = 0; index < this._animatables.length; index++) {
            var animatable = this._animatables[index];
            animatable.reset();
        }
        return this;
    };
    /**
     * Restart animations from key 0
     * @returns the animation group
     */
    AnimationGroup.prototype.restart = function () {
        if (!this._isStarted) {
            return this;
        }
        for (var index = 0; index < this._animatables.length; index++) {
            var animatable = this._animatables[index];
            animatable.restart();
        }
        this.onAnimationGroupPlayObservable.notifyObservers(this);
        return this;
    };
    /**
     * Stop all animations
     * @returns the animation group
     */
    AnimationGroup.prototype.stop = function () {
        if (!this._isStarted) {
            return this;
        }
        var list = this._animatables.slice();
        for (var index = 0; index < list.length; index++) {
            list[index].stop();
        }
        this._isStarted = false;
        return this;
    };
    /**
     * Set animation weight for all animatables
     * @param weight defines the weight to use
     * @return the animationGroup
     * @see http://doc.babylonjs.com/babylon101/animations#animation-weights
     */
    AnimationGroup.prototype.setWeightForAllAnimatables = function (weight) {
        for (var index = 0; index < this._animatables.length; index++) {
            var animatable = this._animatables[index];
            animatable.weight = weight;
        }
        return this;
    };
    /**
     * Synchronize and normalize all animatables with a source animatable
     * @param root defines the root animatable to synchronize with
     * @return the animationGroup
     * @see http://doc.babylonjs.com/babylon101/animations#animation-weights
     */
    AnimationGroup.prototype.syncAllAnimationsWith = function (root) {
        for (var index = 0; index < this._animatables.length; index++) {
            var animatable = this._animatables[index];
            animatable.syncWith(root);
        }
        return this;
    };
    /**
     * Goes to a specific frame in this animation group
     * @param frame the frame number to go to
     * @return the animationGroup
     */
    AnimationGroup.prototype.goToFrame = function (frame) {
        if (!this._isStarted) {
            return this;
        }
        for (var index = 0; index < this._animatables.length; index++) {
            var animatable = this._animatables[index];
            animatable.goToFrame(frame);
        }
        return this;
    };
    /**
     * Dispose all associated resources
     */
    AnimationGroup.prototype.dispose = function () {
        this._targetedAnimations = [];
        this._animatables = [];
        var index = this._scene.animationGroups.indexOf(this);
        if (index > -1) {
            this._scene.animationGroups.splice(index, 1);
        }
        this.onAnimationEndObservable.clear();
        this.onAnimationGroupEndObservable.clear();
        this.onAnimationGroupPauseObservable.clear();
        this.onAnimationGroupPlayObservable.clear();
        this.onAnimationLoopObservable.clear();
        this.onAnimationGroupLoopObservable.clear();
    };
    AnimationGroup.prototype._checkAnimationGroupEnded = function (animatable) {
        // animatable should be taken out of the array
        var idx = this._animatables.indexOf(animatable);
        if (idx > -1) {
            this._animatables.splice(idx, 1);
        }
        // all animatables were removed? animation group ended!
        if (this._animatables.length === 0) {
            this._isStarted = false;
            this.onAnimationGroupEndObservable.notifyObservers(this);
        }
    };
    /**
     * Clone the current animation group and returns a copy
     * @param newName defines the name of the new group
     * @param targetConverter defines an optional function used to convert current animation targets to new ones
     * @returns the new aniamtion group
     */
    AnimationGroup.prototype.clone = function (newName, targetConverter) {
        var newGroup = new AnimationGroup(newName || this.name, this._scene);
        for (var _i = 0, _a = this._targetedAnimations; _i < _a.length; _i++) {
            var targetAnimation = _a[_i];
            newGroup.addTargetedAnimation(targetAnimation.animation.clone(), targetConverter ? targetConverter(targetAnimation.target) : targetAnimation.target);
        }
        return newGroup;
    };
    /**
     * Serializes the animationGroup to an object
     * @returns Serialized object
     */
    AnimationGroup.prototype.serialize = function () {
        var serializationObject = {};
        serializationObject.name = this.name;
        serializationObject.from = this.from;
        serializationObject.to = this.to;
        serializationObject.targetedAnimations = [];
        for (var targetedAnimationIndex = 0; targetedAnimationIndex < this.targetedAnimations.length; targetedAnimationIndex++) {
            var targetedAnimation = this.targetedAnimations[targetedAnimationIndex];
            serializationObject.targetedAnimations[targetedAnimationIndex] = targetedAnimation.serialize();
        }
        return serializationObject;
    };
    // Statics
    /**
     * Returns a new AnimationGroup object parsed from the source provided.
     * @param parsedAnimationGroup defines the source
     * @param scene defines the scene that will receive the animationGroup
     * @returns a new AnimationGroup
     */
    AnimationGroup.Parse = function (parsedAnimationGroup, scene) {
        var animationGroup = new AnimationGroup(parsedAnimationGroup.name, scene);
        for (var i = 0; i < parsedAnimationGroup.targetedAnimations.length; i++) {
            var targetedAnimation = parsedAnimationGroup.targetedAnimations[i];
            var animation = _animation__WEBPACK_IMPORTED_MODULE_0__.Animation.Parse(targetedAnimation.animation);
            var id = targetedAnimation.targetId;
            if (targetedAnimation.animation.property === "influence") { // morph target animation
                var morphTarget = scene.getMorphTargetById(id);
                if (morphTarget) {
                    animationGroup.addTargetedAnimation(animation, morphTarget);
                }
            }
            else {
                var targetNode = scene.getNodeByID(id);
                if (targetNode != null) {
                    animationGroup.addTargetedAnimation(animation, targetNode);
                }
            }
        }
        if (parsedAnimationGroup.from !== null && parsedAnimationGroup.to !== null) {
            animationGroup.normalize(parsedAnimationGroup.from, parsedAnimationGroup.to);
        }
        return animationGroup;
    };
    /**
     * Returns the string "AnimationGroup"
     * @returns "AnimationGroup"
     */
    AnimationGroup.prototype.getClassName = function () {
        return "AnimationGroup";
    };
    /**
     * Creates a detailled string about the object
     * @param fullDetails defines if the output string will support multiple levels of logging within scene loading
     * @returns a string representing the object
     */
    AnimationGroup.prototype.toString = function (fullDetails) {
        var ret = "Name: " + this.name;
        ret += ", type: " + this.getClassName();
        if (fullDetails) {
            ret += ", from: " + this._from;
            ret += ", to: " + this._to;
            ret += ", isStarted: " + this._isStarted;
            ret += ", speedRatio: " + this._speedRatio;
            ret += ", targetedAnimations length: " + this._targetedAnimations.length;
            ret += ", animatables length: " + this._animatables;
        }
        return ret;
    };
    return AnimationGroup;
}());

//# sourceMappingURL=animationGroup.js.map

/***/ }),

/***/ "./node_modules/@babylonjs/core/Animations/animationKey.js":
/*!*****************************************************************!*\
  !*** ./node_modules/@babylonjs/core/Animations/animationKey.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "AnimationKeyInterpolation": () => (/* binding */ AnimationKeyInterpolation)
/* harmony export */ });
/**
 * Enum for the animation key frame interpolation type
 */
var AnimationKeyInterpolation;
(function (AnimationKeyInterpolation) {
    /**
     * Do not interpolate between keys and use the start key value only. Tangents are ignored
     */
    AnimationKeyInterpolation[AnimationKeyInterpolation["STEP"] = 1] = "STEP";
})(AnimationKeyInterpolation || (AnimationKeyInterpolation = {}));
//# sourceMappingURL=animationKey.js.map

/***/ }),

/***/ "./node_modules/@babylonjs/core/Animations/animationPropertiesOverride.js":
/*!********************************************************************************!*\
  !*** ./node_modules/@babylonjs/core/Animations/animationPropertiesOverride.js ***!
  \********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "AnimationPropertiesOverride": () => (/* binding */ AnimationPropertiesOverride)
/* harmony export */ });
/* harmony import */ var _Animations_animation__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../Animations/animation */ "./node_modules/@babylonjs/core/Animations/animation.js");

/**
 * Class used to override all child animations of a given target
 */
var AnimationPropertiesOverride = /** @class */ (function () {
    function AnimationPropertiesOverride() {
        /**
         * Gets or sets a value indicating if animation blending must be used
         */
        this.enableBlending = false;
        /**
         * Gets or sets the blending speed to use when enableBlending is true
         */
        this.blendingSpeed = 0.01;
        /**
         * Gets or sets the default loop mode to use
         */
        this.loopMode = _Animations_animation__WEBPACK_IMPORTED_MODULE_0__.Animation.ANIMATIONLOOPMODE_CYCLE;
    }
    return AnimationPropertiesOverride;
}());

//# sourceMappingURL=animationPropertiesOverride.js.map

/***/ }),

/***/ "./node_modules/@babylonjs/core/Animations/animationRange.js":
/*!*******************************************************************!*\
  !*** ./node_modules/@babylonjs/core/Animations/animationRange.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "AnimationRange": () => (/* binding */ AnimationRange)
/* harmony export */ });
/**
 * Represents the range of an animation
 */
var AnimationRange = /** @class */ (function () {
    /**
     * Initializes the range of an animation
     * @param name The name of the animation range
     * @param from The starting frame of the animation
     * @param to The ending frame of the animation
     */
    function AnimationRange(
    /**The name of the animation range**/
    name, 
    /**The starting frame of the animation */
    from, 
    /**The ending frame of the animation*/
    to) {
        this.name = name;
        this.from = from;
        this.to = to;
    }
    /**
     * Makes a copy of the animation range
     * @returns A copy of the animation range
     */
    AnimationRange.prototype.clone = function () {
        return new AnimationRange(this.name, this.from, this.to);
    };
    return AnimationRange;
}());

//# sourceMappingURL=animationRange.js.map

/***/ }),

/***/ "./node_modules/@babylonjs/core/Animations/easing.js":
/*!***********************************************************!*\
  !*** ./node_modules/@babylonjs/core/Animations/easing.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "BackEase": () => (/* binding */ BackEase),
/* harmony export */   "BezierCurveEase": () => (/* binding */ BezierCurveEase),
/* harmony export */   "BounceEase": () => (/* binding */ BounceEase),
/* harmony export */   "CircleEase": () => (/* binding */ CircleEase),
/* harmony export */   "CubicEase": () => (/* binding */ CubicEase),
/* harmony export */   "EasingFunction": () => (/* binding */ EasingFunction),
/* harmony export */   "ElasticEase": () => (/* binding */ ElasticEase),
/* harmony export */   "ExponentialEase": () => (/* binding */ ExponentialEase),
/* harmony export */   "PowerEase": () => (/* binding */ PowerEase),
/* harmony export */   "QuadraticEase": () => (/* binding */ QuadraticEase),
/* harmony export */   "QuarticEase": () => (/* binding */ QuarticEase),
/* harmony export */   "QuinticEase": () => (/* binding */ QuinticEase),
/* harmony export */   "SineEase": () => (/* binding */ SineEase)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _Maths_math_path__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../Maths/math.path */ "./node_modules/@babylonjs/core/Maths/math.path.js");


/**
 * Base class used for every default easing function.
 * @see http://doc.babylonjs.com/babylon101/animations#easing-functions
 */
var EasingFunction = /** @class */ (function () {
    function EasingFunction() {
        this._easingMode = EasingFunction.EASINGMODE_EASEIN;
    }
    /**
     * Sets the easing mode of the current function.
     * @param easingMode Defines the willing mode (EASINGMODE_EASEIN, EASINGMODE_EASEOUT or EASINGMODE_EASEINOUT)
     */
    EasingFunction.prototype.setEasingMode = function (easingMode) {
        var n = Math.min(Math.max(easingMode, 0), 2);
        this._easingMode = n;
    };
    /**
     * Gets the current easing mode.
     * @returns the easing mode
     */
    EasingFunction.prototype.getEasingMode = function () {
        return this._easingMode;
    };
    /**
     * @hidden
     */
    EasingFunction.prototype.easeInCore = function (gradient) {
        throw new Error('You must implement this method');
    };
    /**
     * Given an input gradient between 0 and 1, this returns the corresponding value
     * of the easing function.
     * @param gradient Defines the value between 0 and 1 we want the easing value for
     * @returns the corresponding value on the curve defined by the easing function
     */
    EasingFunction.prototype.ease = function (gradient) {
        switch (this._easingMode) {
            case EasingFunction.EASINGMODE_EASEIN:
                return this.easeInCore(gradient);
            case EasingFunction.EASINGMODE_EASEOUT:
                return (1 - this.easeInCore(1 - gradient));
        }
        if (gradient >= 0.5) {
            return (((1 - this.easeInCore((1 - gradient) * 2)) * 0.5) + 0.5);
        }
        return (this.easeInCore(gradient * 2) * 0.5);
    };
    /**
     * Interpolation follows the mathematical formula associated with the easing function.
     */
    EasingFunction.EASINGMODE_EASEIN = 0;
    /**
     * Interpolation follows 100% interpolation minus the output of the formula associated with the easing function.
     */
    EasingFunction.EASINGMODE_EASEOUT = 1;
    /**
     * Interpolation uses EaseIn for the first half of the animation and EaseOut for the second half.
     */
    EasingFunction.EASINGMODE_EASEINOUT = 2;
    return EasingFunction;
}());

/**
 * Easing function with a circle shape (see link below).
 * @see https://easings.net/#easeInCirc
 * @see http://doc.babylonjs.com/babylon101/animations#easing-functions
 */
var CircleEase = /** @class */ (function (_super) {
    (0,tslib__WEBPACK_IMPORTED_MODULE_1__.__extends)(CircleEase, _super);
    function CircleEase() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    /** @hidden */
    CircleEase.prototype.easeInCore = function (gradient) {
        gradient = Math.max(0, Math.min(1, gradient));
        return (1.0 - Math.sqrt(1.0 - (gradient * gradient)));
    };
    return CircleEase;
}(EasingFunction));

/**
 * Easing function with a ease back shape (see link below).
 * @see https://easings.net/#easeInBack
 * @see http://doc.babylonjs.com/babylon101/animations#easing-functions
 */
var BackEase = /** @class */ (function (_super) {
    (0,tslib__WEBPACK_IMPORTED_MODULE_1__.__extends)(BackEase, _super);
    /**
     * Instantiates a back ease easing
     * @see https://easings.net/#easeInBack
     * @param amplitude Defines the amplitude of the function
     */
    function BackEase(
    /** Defines the amplitude of the function */
    amplitude) {
        if (amplitude === void 0) { amplitude = 1; }
        var _this = _super.call(this) || this;
        _this.amplitude = amplitude;
        return _this;
    }
    /** @hidden */
    BackEase.prototype.easeInCore = function (gradient) {
        var num = Math.max(0, this.amplitude);
        return (Math.pow(gradient, 3.0) - ((gradient * num) * Math.sin(3.1415926535897931 * gradient)));
    };
    return BackEase;
}(EasingFunction));

/**
 * Easing function with a bouncing shape (see link below).
 * @see https://easings.net/#easeInBounce
 * @see http://doc.babylonjs.com/babylon101/animations#easing-functions
 */
var BounceEase = /** @class */ (function (_super) {
    (0,tslib__WEBPACK_IMPORTED_MODULE_1__.__extends)(BounceEase, _super);
    /**
     * Instantiates a bounce easing
     * @see https://easings.net/#easeInBounce
     * @param bounces Defines the number of bounces
     * @param bounciness Defines the amplitude of the bounce
     */
    function BounceEase(
    /** Defines the number of bounces */
    bounces, 
    /** Defines the amplitude of the bounce */
    bounciness) {
        if (bounces === void 0) { bounces = 3; }
        if (bounciness === void 0) { bounciness = 2; }
        var _this = _super.call(this) || this;
        _this.bounces = bounces;
        _this.bounciness = bounciness;
        return _this;
    }
    /** @hidden */
    BounceEase.prototype.easeInCore = function (gradient) {
        var y = Math.max(0.0, this.bounces);
        var bounciness = this.bounciness;
        if (bounciness <= 1.0) {
            bounciness = 1.001;
        }
        var num9 = Math.pow(bounciness, y);
        var num5 = 1.0 - bounciness;
        var num4 = ((1.0 - num9) / num5) + (num9 * 0.5);
        var num15 = gradient * num4;
        var num65 = Math.log((-num15 * (1.0 - bounciness)) + 1.0) / Math.log(bounciness);
        var num3 = Math.floor(num65);
        var num13 = num3 + 1.0;
        var num8 = (1.0 - Math.pow(bounciness, num3)) / (num5 * num4);
        var num12 = (1.0 - Math.pow(bounciness, num13)) / (num5 * num4);
        var num7 = (num8 + num12) * 0.5;
        var num6 = gradient - num7;
        var num2 = num7 - num8;
        return (((-Math.pow(1.0 / bounciness, y - num3) / (num2 * num2)) * (num6 - num2)) * (num6 + num2));
    };
    return BounceEase;
}(EasingFunction));

/**
 * Easing function with a power of 3 shape (see link below).
 * @see https://easings.net/#easeInCubic
 * @see http://doc.babylonjs.com/babylon101/animations#easing-functions
 */
var CubicEase = /** @class */ (function (_super) {
    (0,tslib__WEBPACK_IMPORTED_MODULE_1__.__extends)(CubicEase, _super);
    function CubicEase() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    /** @hidden */
    CubicEase.prototype.easeInCore = function (gradient) {
        return (gradient * gradient * gradient);
    };
    return CubicEase;
}(EasingFunction));

/**
 * Easing function with an elastic shape (see link below).
 * @see https://easings.net/#easeInElastic
 * @see http://doc.babylonjs.com/babylon101/animations#easing-functions
 */
var ElasticEase = /** @class */ (function (_super) {
    (0,tslib__WEBPACK_IMPORTED_MODULE_1__.__extends)(ElasticEase, _super);
    /**
     * Instantiates an elastic easing function
     * @see https://easings.net/#easeInElastic
     * @param oscillations Defines the number of oscillations
     * @param springiness Defines the amplitude of the oscillations
     */
    function ElasticEase(
    /** Defines the number of oscillations*/
    oscillations, 
    /** Defines the amplitude of the oscillations*/
    springiness) {
        if (oscillations === void 0) { oscillations = 3; }
        if (springiness === void 0) { springiness = 3; }
        var _this = _super.call(this) || this;
        _this.oscillations = oscillations;
        _this.springiness = springiness;
        return _this;
    }
    /** @hidden */
    ElasticEase.prototype.easeInCore = function (gradient) {
        var num2;
        var num3 = Math.max(0.0, this.oscillations);
        var num = Math.max(0.0, this.springiness);
        if (num == 0) {
            num2 = gradient;
        }
        else {
            num2 = (Math.exp(num * gradient) - 1.0) / (Math.exp(num) - 1.0);
        }
        return (num2 * Math.sin(((6.2831853071795862 * num3) + 1.5707963267948966) * gradient));
    };
    return ElasticEase;
}(EasingFunction));

/**
 * Easing function with an exponential shape (see link below).
 * @see https://easings.net/#easeInExpo
 * @see http://doc.babylonjs.com/babylon101/animations#easing-functions
 */
var ExponentialEase = /** @class */ (function (_super) {
    (0,tslib__WEBPACK_IMPORTED_MODULE_1__.__extends)(ExponentialEase, _super);
    /**
     * Instantiates an exponential easing function
     * @see https://easings.net/#easeInExpo
     * @param exponent Defines the exponent of the function
     */
    function ExponentialEase(
    /** Defines the exponent of the function */
    exponent) {
        if (exponent === void 0) { exponent = 2; }
        var _this = _super.call(this) || this;
        _this.exponent = exponent;
        return _this;
    }
    /** @hidden */
    ExponentialEase.prototype.easeInCore = function (gradient) {
        if (this.exponent <= 0) {
            return gradient;
        }
        return ((Math.exp(this.exponent * gradient) - 1.0) / (Math.exp(this.exponent) - 1.0));
    };
    return ExponentialEase;
}(EasingFunction));

/**
 * Easing function with a power shape (see link below).
 * @see https://easings.net/#easeInQuad
 * @see http://doc.babylonjs.com/babylon101/animations#easing-functions
 */
var PowerEase = /** @class */ (function (_super) {
    (0,tslib__WEBPACK_IMPORTED_MODULE_1__.__extends)(PowerEase, _super);
    /**
     * Instantiates an power base easing function
     * @see https://easings.net/#easeInQuad
     * @param power Defines the power of the function
     */
    function PowerEase(
    /** Defines the power of the function */
    power) {
        if (power === void 0) { power = 2; }
        var _this = _super.call(this) || this;
        _this.power = power;
        return _this;
    }
    /** @hidden */
    PowerEase.prototype.easeInCore = function (gradient) {
        var y = Math.max(0.0, this.power);
        return Math.pow(gradient, y);
    };
    return PowerEase;
}(EasingFunction));

/**
 * Easing function with a power of 2 shape (see link below).
 * @see https://easings.net/#easeInQuad
 * @see http://doc.babylonjs.com/babylon101/animations#easing-functions
 */
var QuadraticEase = /** @class */ (function (_super) {
    (0,tslib__WEBPACK_IMPORTED_MODULE_1__.__extends)(QuadraticEase, _super);
    function QuadraticEase() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    /** @hidden */
    QuadraticEase.prototype.easeInCore = function (gradient) {
        return (gradient * gradient);
    };
    return QuadraticEase;
}(EasingFunction));

/**
 * Easing function with a power of 4 shape (see link below).
 * @see https://easings.net/#easeInQuart
 * @see http://doc.babylonjs.com/babylon101/animations#easing-functions
 */
var QuarticEase = /** @class */ (function (_super) {
    (0,tslib__WEBPACK_IMPORTED_MODULE_1__.__extends)(QuarticEase, _super);
    function QuarticEase() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    /** @hidden */
    QuarticEase.prototype.easeInCore = function (gradient) {
        return (gradient * gradient * gradient * gradient);
    };
    return QuarticEase;
}(EasingFunction));

/**
 * Easing function with a power of 5 shape (see link below).
 * @see https://easings.net/#easeInQuint
 * @see http://doc.babylonjs.com/babylon101/animations#easing-functions
 */
var QuinticEase = /** @class */ (function (_super) {
    (0,tslib__WEBPACK_IMPORTED_MODULE_1__.__extends)(QuinticEase, _super);
    function QuinticEase() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    /** @hidden */
    QuinticEase.prototype.easeInCore = function (gradient) {
        return (gradient * gradient * gradient * gradient * gradient);
    };
    return QuinticEase;
}(EasingFunction));

/**
 * Easing function with a sin shape (see link below).
 * @see https://easings.net/#easeInSine
 * @see http://doc.babylonjs.com/babylon101/animations#easing-functions
 */
var SineEase = /** @class */ (function (_super) {
    (0,tslib__WEBPACK_IMPORTED_MODULE_1__.__extends)(SineEase, _super);
    function SineEase() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    /** @hidden */
    SineEase.prototype.easeInCore = function (gradient) {
        return (1.0 - Math.sin(1.5707963267948966 * (1.0 - gradient)));
    };
    return SineEase;
}(EasingFunction));

/**
 * Easing function with a bezier shape (see link below).
 * @see http://cubic-bezier.com/#.17,.67,.83,.67
 * @see http://doc.babylonjs.com/babylon101/animations#easing-functions
 */
var BezierCurveEase = /** @class */ (function (_super) {
    (0,tslib__WEBPACK_IMPORTED_MODULE_1__.__extends)(BezierCurveEase, _super);
    /**
     * Instantiates a bezier function
     * @see http://cubic-bezier.com/#.17,.67,.83,.67
     * @param x1 Defines the x component of the start tangent in the bezier curve
     * @param y1 Defines the y component of the start tangent in the bezier curve
     * @param x2 Defines the x component of the end tangent in the bezier curve
     * @param y2 Defines the y component of the end tangent in the bezier curve
     */
    function BezierCurveEase(
    /** Defines the x component of the start tangent in the bezier curve */
    x1, 
    /** Defines the y component of the start tangent in the bezier curve */
    y1, 
    /** Defines the x component of the end tangent in the bezier curve */
    x2, 
    /** Defines the y component of the end tangent in the bezier curve */
    y2) {
        if (x1 === void 0) { x1 = 0; }
        if (y1 === void 0) { y1 = 0; }
        if (x2 === void 0) { x2 = 1; }
        if (y2 === void 0) { y2 = 1; }
        var _this = _super.call(this) || this;
        _this.x1 = x1;
        _this.y1 = y1;
        _this.x2 = x2;
        _this.y2 = y2;
        return _this;
    }
    /** @hidden */
    BezierCurveEase.prototype.easeInCore = function (gradient) {
        return _Maths_math_path__WEBPACK_IMPORTED_MODULE_0__.BezierCurve.Interpolate(gradient, this.x1, this.y1, this.x2, this.y2);
    };
    return BezierCurveEase;
}(EasingFunction));

//# sourceMappingURL=easing.js.map

/***/ }),

/***/ "./node_modules/@babylonjs/core/Animations/index.js":
/*!**********************************************************!*\
  !*** ./node_modules/@babylonjs/core/Animations/index.js ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Animatable": () => (/* reexport safe */ _animatable__WEBPACK_IMPORTED_MODULE_0__.Animatable),
/* harmony export */   "Animation": () => (/* reexport safe */ _animation__WEBPACK_IMPORTED_MODULE_1__.Animation),
/* harmony export */   "AnimationEvent": () => (/* reexport safe */ _animationEvent__WEBPACK_IMPORTED_MODULE_6__.AnimationEvent),
/* harmony export */   "AnimationGroup": () => (/* reexport safe */ _animationGroup__WEBPACK_IMPORTED_MODULE_2__.AnimationGroup),
/* harmony export */   "AnimationKeyInterpolation": () => (/* reexport safe */ _animationKey__WEBPACK_IMPORTED_MODULE_7__.AnimationKeyInterpolation),
/* harmony export */   "AnimationPropertiesOverride": () => (/* reexport safe */ _animationPropertiesOverride__WEBPACK_IMPORTED_MODULE_3__.AnimationPropertiesOverride),
/* harmony export */   "AnimationRange": () => (/* reexport safe */ _animationRange__WEBPACK_IMPORTED_MODULE_8__.AnimationRange),
/* harmony export */   "BackEase": () => (/* reexport safe */ _easing__WEBPACK_IMPORTED_MODULE_4__.BackEase),
/* harmony export */   "BezierCurveEase": () => (/* reexport safe */ _easing__WEBPACK_IMPORTED_MODULE_4__.BezierCurveEase),
/* harmony export */   "BounceEase": () => (/* reexport safe */ _easing__WEBPACK_IMPORTED_MODULE_4__.BounceEase),
/* harmony export */   "CircleEase": () => (/* reexport safe */ _easing__WEBPACK_IMPORTED_MODULE_4__.CircleEase),
/* harmony export */   "CubicEase": () => (/* reexport safe */ _easing__WEBPACK_IMPORTED_MODULE_4__.CubicEase),
/* harmony export */   "EasingFunction": () => (/* reexport safe */ _easing__WEBPACK_IMPORTED_MODULE_4__.EasingFunction),
/* harmony export */   "ElasticEase": () => (/* reexport safe */ _easing__WEBPACK_IMPORTED_MODULE_4__.ElasticEase),
/* harmony export */   "ExponentialEase": () => (/* reexport safe */ _easing__WEBPACK_IMPORTED_MODULE_4__.ExponentialEase),
/* harmony export */   "PowerEase": () => (/* reexport safe */ _easing__WEBPACK_IMPORTED_MODULE_4__.PowerEase),
/* harmony export */   "QuadraticEase": () => (/* reexport safe */ _easing__WEBPACK_IMPORTED_MODULE_4__.QuadraticEase),
/* harmony export */   "QuarticEase": () => (/* reexport safe */ _easing__WEBPACK_IMPORTED_MODULE_4__.QuarticEase),
/* harmony export */   "QuinticEase": () => (/* reexport safe */ _easing__WEBPACK_IMPORTED_MODULE_4__.QuinticEase),
/* harmony export */   "RuntimeAnimation": () => (/* reexport safe */ _runtimeAnimation__WEBPACK_IMPORTED_MODULE_5__.RuntimeAnimation),
/* harmony export */   "SineEase": () => (/* reexport safe */ _easing__WEBPACK_IMPORTED_MODULE_4__.SineEase),
/* harmony export */   "TargetedAnimation": () => (/* reexport safe */ _animationGroup__WEBPACK_IMPORTED_MODULE_2__.TargetedAnimation),
/* harmony export */   "_IAnimationState": () => (/* reexport safe */ _animation__WEBPACK_IMPORTED_MODULE_1__._IAnimationState)
/* harmony export */ });
/* harmony import */ var _animatable__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./animatable */ "./node_modules/@babylonjs/core/Animations/animatable.js");
/* harmony import */ var _animation__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./animation */ "./node_modules/@babylonjs/core/Animations/animation.js");
/* harmony import */ var _animationGroup__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./animationGroup */ "./node_modules/@babylonjs/core/Animations/animationGroup.js");
/* harmony import */ var _animationPropertiesOverride__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./animationPropertiesOverride */ "./node_modules/@babylonjs/core/Animations/animationPropertiesOverride.js");
/* harmony import */ var _easing__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./easing */ "./node_modules/@babylonjs/core/Animations/easing.js");
/* harmony import */ var _runtimeAnimation__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./runtimeAnimation */ "./node_modules/@babylonjs/core/Animations/runtimeAnimation.js");
/* harmony import */ var _animationEvent__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./animationEvent */ "./node_modules/@babylonjs/core/Animations/animationEvent.js");
/* harmony import */ var _animationKey__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./animationKey */ "./node_modules/@babylonjs/core/Animations/animationKey.js");
/* harmony import */ var _animationRange__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./animationRange */ "./node_modules/@babylonjs/core/Animations/animationRange.js");










//# sourceMappingURL=index.js.map

/***/ }),

/***/ "./node_modules/@babylonjs/core/Animations/runtimeAnimation.js":
/*!*********************************************************************!*\
  !*** ./node_modules/@babylonjs/core/Animations/runtimeAnimation.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "RuntimeAnimation": () => (/* binding */ RuntimeAnimation)
/* harmony export */ });
/* harmony import */ var _Maths_math_vector__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../Maths/math.vector */ "./node_modules/@babylonjs/core/Maths/math.vector.js");
/* harmony import */ var _Maths_math_color__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Maths/math.color */ "./node_modules/@babylonjs/core/Maths/math.color.js");
/* harmony import */ var _animation__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./animation */ "./node_modules/@babylonjs/core/Animations/animation.js");
/* harmony import */ var _Maths_math_size__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../Maths/math.size */ "./node_modules/@babylonjs/core/Maths/math.size.js");




// Static values to help the garbage collector
// Quaternion
var _staticOffsetValueQuaternion = Object.freeze(new _Maths_math_vector__WEBPACK_IMPORTED_MODULE_0__.Quaternion(0, 0, 0, 0));
// Vector3
var _staticOffsetValueVector3 = Object.freeze(_Maths_math_vector__WEBPACK_IMPORTED_MODULE_0__.Vector3.Zero());
// Vector2
var _staticOffsetValueVector2 = Object.freeze(_Maths_math_vector__WEBPACK_IMPORTED_MODULE_0__.Vector2.Zero());
// Size
var _staticOffsetValueSize = Object.freeze(_Maths_math_size__WEBPACK_IMPORTED_MODULE_3__.Size.Zero());
// Color3
var _staticOffsetValueColor3 = Object.freeze(_Maths_math_color__WEBPACK_IMPORTED_MODULE_1__.Color3.Black());
/**
 * Defines a runtime animation
 */
var RuntimeAnimation = /** @class */ (function () {
    /**
     * Create a new RuntimeAnimation object
     * @param target defines the target of the animation
     * @param animation defines the source animation object
     * @param scene defines the hosting scene
     * @param host defines the initiating Animatable
     */
    function RuntimeAnimation(target, animation, scene, host) {
        var _this = this;
        this._events = new Array();
        /**
         * The current frame of the runtime animation
         */
        this._currentFrame = 0;
        /**
         * The original value of the runtime animation
         */
        this._originalValue = new Array();
        /**
         * The original blend value of the runtime animation
         */
        this._originalBlendValue = null;
        /**
         * The offsets cache of the runtime animation
         */
        this._offsetsCache = {};
        /**
         * The high limits cache of the runtime animation
         */
        this._highLimitsCache = {};
        /**
         * Specifies if the runtime animation has been stopped
         */
        this._stopped = false;
        /**
         * The blending factor of the runtime animation
         */
        this._blendingFactor = 0;
        /**
         * The current value of the runtime animation
         */
        this._currentValue = null;
        this._currentActiveTarget = null;
        this._directTarget = null;
        /**
         * The target path of the runtime animation
         */
        this._targetPath = "";
        /**
         * The weight of the runtime animation
         */
        this._weight = 1.0;
        /**
         * The ratio offset of the runtime animation
         */
        this._ratioOffset = 0;
        /**
         * The previous delay of the runtime animation
         */
        this._previousDelay = 0;
        /**
         * The previous ratio of the runtime animation
         */
        this._previousRatio = 0;
        this._targetIsArray = false;
        this._animation = animation;
        this._target = target;
        this._scene = scene;
        this._host = host;
        this._activeTargets = [];
        animation._runtimeAnimations.push(this);
        // State
        this._animationState = {
            key: 0,
            repeatCount: 0,
            loopMode: this._getCorrectLoopMode()
        };
        if (this._animation.dataType === _animation__WEBPACK_IMPORTED_MODULE_2__.Animation.ANIMATIONTYPE_MATRIX) {
            this._animationState.workValue = _Maths_math_vector__WEBPACK_IMPORTED_MODULE_0__.Matrix.Zero();
        }
        // Limits
        this._keys = this._animation.getKeys();
        this._minFrame = this._keys[0].frame;
        this._maxFrame = this._keys[this._keys.length - 1].frame;
        this._minValue = this._keys[0].value;
        this._maxValue = this._keys[this._keys.length - 1].value;
        // Add a start key at frame 0 if missing
        if (this._minFrame !== 0) {
            var newKey = { frame: 0, value: this._minValue };
            this._keys.splice(0, 0, newKey);
        }
        // Check data
        if (this._target instanceof Array) {
            var index = 0;
            for (var _i = 0, _a = this._target; _i < _a.length; _i++) {
                var target_1 = _a[_i];
                this._preparePath(target_1, index);
                this._getOriginalValues(index);
                index++;
            }
            this._targetIsArray = true;
        }
        else {
            this._preparePath(this._target);
            this._getOriginalValues();
            this._targetIsArray = false;
            this._directTarget = this._activeTargets[0];
        }
        // Cloning events locally
        var events = animation.getEvents();
        if (events && events.length > 0) {
            events.forEach(function (e) {
                _this._events.push(e._clone());
            });
        }
        this._enableBlending = target && target.animationPropertiesOverride ? target.animationPropertiesOverride.enableBlending : this._animation.enableBlending;
    }
    Object.defineProperty(RuntimeAnimation.prototype, "currentFrame", {
        /**
         * Gets the current frame of the runtime animation
         */
        get: function () {
            return this._currentFrame;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(RuntimeAnimation.prototype, "weight", {
        /**
         * Gets the weight of the runtime animation
         */
        get: function () {
            return this._weight;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(RuntimeAnimation.prototype, "currentValue", {
        /**
         * Gets the current value of the runtime animation
         */
        get: function () {
            return this._currentValue;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(RuntimeAnimation.prototype, "targetPath", {
        /**
         * Gets the target path of the runtime animation
         */
        get: function () {
            return this._targetPath;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(RuntimeAnimation.prototype, "target", {
        /**
         * Gets the actual target of the runtime animation
         */
        get: function () {
            return this._currentActiveTarget;
        },
        enumerable: true,
        configurable: true
    });
    RuntimeAnimation.prototype._preparePath = function (target, targetIndex) {
        if (targetIndex === void 0) { targetIndex = 0; }
        var targetPropertyPath = this._animation.targetPropertyPath;
        if (targetPropertyPath.length > 1) {
            var property = target[targetPropertyPath[0]];
            for (var index = 1; index < targetPropertyPath.length - 1; index++) {
                property = property[targetPropertyPath[index]];
            }
            this._targetPath = targetPropertyPath[targetPropertyPath.length - 1];
            this._activeTargets[targetIndex] = property;
        }
        else {
            this._targetPath = targetPropertyPath[0];
            this._activeTargets[targetIndex] = target;
        }
    };
    Object.defineProperty(RuntimeAnimation.prototype, "animation", {
        /**
         * Gets the animation from the runtime animation
         */
        get: function () {
            return this._animation;
        },
        enumerable: true,
        configurable: true
    });
    /**
     * Resets the runtime animation to the beginning
     * @param restoreOriginal defines whether to restore the target property to the original value
     */
    RuntimeAnimation.prototype.reset = function (restoreOriginal) {
        if (restoreOriginal === void 0) { restoreOriginal = false; }
        if (restoreOriginal) {
            if (this._target instanceof Array) {
                var index = 0;
                for (var _i = 0, _a = this._target; _i < _a.length; _i++) {
                    var target = _a[_i];
                    if (this._originalValue[index] !== undefined) {
                        this._setValue(target, this._activeTargets[index], this._originalValue[index], -1, index);
                    }
                    index++;
                }
            }
            else {
                if (this._originalValue[0] !== undefined) {
                    this._setValue(this._target, this._directTarget, this._originalValue[0], -1, 0);
                }
            }
        }
        this._offsetsCache = {};
        this._highLimitsCache = {};
        this._currentFrame = 0;
        this._blendingFactor = 0;
        // Events
        for (var index = 0; index < this._events.length; index++) {
            this._events[index].isDone = false;
        }
    };
    /**
     * Specifies if the runtime animation is stopped
     * @returns Boolean specifying if the runtime animation is stopped
     */
    RuntimeAnimation.prototype.isStopped = function () {
        return this._stopped;
    };
    /**
     * Disposes of the runtime animation
     */
    RuntimeAnimation.prototype.dispose = function () {
        var index = this._animation.runtimeAnimations.indexOf(this);
        if (index > -1) {
            this._animation.runtimeAnimations.splice(index, 1);
        }
    };
    /**
     * Apply the interpolated value to the target
     * @param currentValue defines the value computed by the animation
     * @param weight defines the weight to apply to this value (Defaults to 1.0)
     */
    RuntimeAnimation.prototype.setValue = function (currentValue, weight) {
        if (this._targetIsArray) {
            for (var index = 0; index < this._target.length; index++) {
                var target = this._target[index];
                this._setValue(target, this._activeTargets[index], currentValue, weight, index);
            }
            return;
        }
        this._setValue(this._target, this._directTarget, currentValue, weight, 0);
    };
    RuntimeAnimation.prototype._getOriginalValues = function (targetIndex) {
        if (targetIndex === void 0) { targetIndex = 0; }
        var originalValue;
        var target = this._activeTargets[targetIndex];
        if (target.getRestPose && this._targetPath === "_matrix") { // For bones
            originalValue = target.getRestPose();
        }
        else {
            originalValue = target[this._targetPath];
        }
        if (originalValue && originalValue.clone) {
            this._originalValue[targetIndex] = originalValue.clone();
        }
        else {
            this._originalValue[targetIndex] = originalValue;
        }
    };
    RuntimeAnimation.prototype._setValue = function (target, destination, currentValue, weight, targetIndex) {
        // Set value
        this._currentActiveTarget = destination;
        this._weight = weight;
        if (this._enableBlending && this._blendingFactor <= 1.0) {
            if (!this._originalBlendValue) {
                var originalValue = destination[this._targetPath];
                if (originalValue.clone) {
                    this._originalBlendValue = originalValue.clone();
                }
                else {
                    this._originalBlendValue = originalValue;
                }
            }
            if (this._originalBlendValue.m) { // Matrix
                if (_animation__WEBPACK_IMPORTED_MODULE_2__.Animation.AllowMatrixDecomposeForInterpolation) {
                    if (this._currentValue) {
                        _Maths_math_vector__WEBPACK_IMPORTED_MODULE_0__.Matrix.DecomposeLerpToRef(this._originalBlendValue, currentValue, this._blendingFactor, this._currentValue);
                    }
                    else {
                        this._currentValue = _Maths_math_vector__WEBPACK_IMPORTED_MODULE_0__.Matrix.DecomposeLerp(this._originalBlendValue, currentValue, this._blendingFactor);
                    }
                }
                else {
                    if (this._currentValue) {
                        _Maths_math_vector__WEBPACK_IMPORTED_MODULE_0__.Matrix.LerpToRef(this._originalBlendValue, currentValue, this._blendingFactor, this._currentValue);
                    }
                    else {
                        this._currentValue = _Maths_math_vector__WEBPACK_IMPORTED_MODULE_0__.Matrix.Lerp(this._originalBlendValue, currentValue, this._blendingFactor);
                    }
                }
            }
            else {
                this._currentValue = _animation__WEBPACK_IMPORTED_MODULE_2__.Animation._UniversalLerp(this._originalBlendValue, currentValue, this._blendingFactor);
            }
            var blendingSpeed = target && target.animationPropertiesOverride ? target.animationPropertiesOverride.blendingSpeed : this._animation.blendingSpeed;
            this._blendingFactor += blendingSpeed;
        }
        else {
            this._currentValue = currentValue;
        }
        if (weight !== -1.0) {
            this._scene._registerTargetForLateAnimationBinding(this, this._originalValue[targetIndex]);
        }
        else {
            destination[this._targetPath] = this._currentValue;
        }
        if (target.markAsDirty) {
            target.markAsDirty(this._animation.targetProperty);
        }
    };
    /**
     * Gets the loop pmode of the runtime animation
     * @returns Loop Mode
     */
    RuntimeAnimation.prototype._getCorrectLoopMode = function () {
        if (this._target && this._target.animationPropertiesOverride) {
            return this._target.animationPropertiesOverride.loopMode;
        }
        return this._animation.loopMode;
    };
    /**
     * Move the current animation to a given frame
     * @param frame defines the frame to move to
     */
    RuntimeAnimation.prototype.goToFrame = function (frame) {
        var keys = this._animation.getKeys();
        if (frame < keys[0].frame) {
            frame = keys[0].frame;
        }
        else if (frame > keys[keys.length - 1].frame) {
            frame = keys[keys.length - 1].frame;
        }
        // Need to reset animation events
        var events = this._events;
        if (events.length) {
            for (var index = 0; index < events.length; index++) {
                if (!events[index].onlyOnce) {
                    // reset events in the future
                    events[index].isDone = events[index].frame < frame;
                }
            }
        }
        this._currentFrame = frame;
        var currentValue = this._animation._interpolate(frame, this._animationState);
        this.setValue(currentValue, -1);
    };
    /**
     * @hidden Internal use only
     */
    RuntimeAnimation.prototype._prepareForSpeedRatioChange = function (newSpeedRatio) {
        var newRatio = this._previousDelay * (this._animation.framePerSecond * newSpeedRatio) / 1000.0;
        this._ratioOffset = this._previousRatio - newRatio;
    };
    /**
     * Execute the current animation
     * @param delay defines the delay to add to the current frame
     * @param from defines the lower bound of the animation range
     * @param to defines the upper bound of the animation range
     * @param loop defines if the current animation must loop
     * @param speedRatio defines the current speed ratio
     * @param weight defines the weight of the animation (default is -1 so no weight)
     * @param onLoop optional callback called when animation loops
     * @returns a boolean indicating if the animation is running
     */
    RuntimeAnimation.prototype.animate = function (delay, from, to, loop, speedRatio, weight) {
        if (weight === void 0) { weight = -1.0; }
        var animation = this._animation;
        var targetPropertyPath = animation.targetPropertyPath;
        if (!targetPropertyPath || targetPropertyPath.length < 1) {
            this._stopped = true;
            return false;
        }
        var returnValue = true;
        // Check limits
        if (from < this._minFrame || from > this._maxFrame) {
            from = this._minFrame;
        }
        if (to < this._minFrame || to > this._maxFrame) {
            to = this._maxFrame;
        }
        var range = to - from;
        var offsetValue;
        // Compute ratio which represents the frame delta between from and to
        var ratio = (delay * (animation.framePerSecond * speedRatio) / 1000.0) + this._ratioOffset;
        var highLimitValue = 0;
        this._previousDelay = delay;
        this._previousRatio = ratio;
        if (!loop && (to >= from && ratio >= range)) { // If we are out of range and not looping get back to caller
            returnValue = false;
            highLimitValue = animation._getKeyValue(this._maxValue);
        }
        else if (!loop && (from >= to && ratio <= range)) {
            returnValue = false;
            highLimitValue = animation._getKeyValue(this._minValue);
        }
        else if (this._animationState.loopMode !== _animation__WEBPACK_IMPORTED_MODULE_2__.Animation.ANIMATIONLOOPMODE_CYCLE) {
            var keyOffset = to.toString() + from.toString();
            if (!this._offsetsCache[keyOffset]) {
                this._animationState.repeatCount = 0;
                this._animationState.loopMode = _animation__WEBPACK_IMPORTED_MODULE_2__.Animation.ANIMATIONLOOPMODE_CYCLE;
                var fromValue = animation._interpolate(from, this._animationState);
                var toValue = animation._interpolate(to, this._animationState);
                this._animationState.loopMode = this._getCorrectLoopMode();
                switch (animation.dataType) {
                    // Float
                    case _animation__WEBPACK_IMPORTED_MODULE_2__.Animation.ANIMATIONTYPE_FLOAT:
                        this._offsetsCache[keyOffset] = toValue - fromValue;
                        break;
                    // Quaternion
                    case _animation__WEBPACK_IMPORTED_MODULE_2__.Animation.ANIMATIONTYPE_QUATERNION:
                        this._offsetsCache[keyOffset] = toValue.subtract(fromValue);
                        break;
                    // Vector3
                    case _animation__WEBPACK_IMPORTED_MODULE_2__.Animation.ANIMATIONTYPE_VECTOR3:
                        this._offsetsCache[keyOffset] = toValue.subtract(fromValue);
                    // Vector2
                    case _animation__WEBPACK_IMPORTED_MODULE_2__.Animation.ANIMATIONTYPE_VECTOR2:
                        this._offsetsCache[keyOffset] = toValue.subtract(fromValue);
                    // Size
                    case _animation__WEBPACK_IMPORTED_MODULE_2__.Animation.ANIMATIONTYPE_SIZE:
                        this._offsetsCache[keyOffset] = toValue.subtract(fromValue);
                    // Color3
                    case _animation__WEBPACK_IMPORTED_MODULE_2__.Animation.ANIMATIONTYPE_COLOR3:
                        this._offsetsCache[keyOffset] = toValue.subtract(fromValue);
                    default:
                        break;
                }
                this._highLimitsCache[keyOffset] = toValue;
            }
            highLimitValue = this._highLimitsCache[keyOffset];
            offsetValue = this._offsetsCache[keyOffset];
        }
        if (offsetValue === undefined) {
            switch (animation.dataType) {
                // Float
                case _animation__WEBPACK_IMPORTED_MODULE_2__.Animation.ANIMATIONTYPE_FLOAT:
                    offsetValue = 0;
                    break;
                // Quaternion
                case _animation__WEBPACK_IMPORTED_MODULE_2__.Animation.ANIMATIONTYPE_QUATERNION:
                    offsetValue = _staticOffsetValueQuaternion;
                    break;
                // Vector3
                case _animation__WEBPACK_IMPORTED_MODULE_2__.Animation.ANIMATIONTYPE_VECTOR3:
                    offsetValue = _staticOffsetValueVector3;
                    break;
                // Vector2
                case _animation__WEBPACK_IMPORTED_MODULE_2__.Animation.ANIMATIONTYPE_VECTOR2:
                    offsetValue = _staticOffsetValueVector2;
                    break;
                // Size
                case _animation__WEBPACK_IMPORTED_MODULE_2__.Animation.ANIMATIONTYPE_SIZE:
                    offsetValue = _staticOffsetValueSize;
                    break;
                // Color3
                case _animation__WEBPACK_IMPORTED_MODULE_2__.Animation.ANIMATIONTYPE_COLOR3:
                    offsetValue = _staticOffsetValueColor3;
            }
        }
        // Compute value
        var currentFrame;
        if (this._host && this._host.syncRoot) {
            var syncRoot = this._host.syncRoot;
            var hostNormalizedFrame = (syncRoot.masterFrame - syncRoot.fromFrame) / (syncRoot.toFrame - syncRoot.fromFrame);
            currentFrame = from + (to - from) * hostNormalizedFrame;
        }
        else {
            currentFrame = (returnValue && range !== 0) ? from + ratio % range : to;
        }
        // Reset events if looping
        var events = this._events;
        if (range > 0 && this.currentFrame > currentFrame ||
            range < 0 && this.currentFrame < currentFrame) {
            this._onLoop();
            // Need to reset animation events
            if (events.length) {
                for (var index = 0; index < events.length; index++) {
                    if (!events[index].onlyOnce) {
                        // reset event, the animation is looping
                        events[index].isDone = false;
                    }
                }
            }
        }
        this._currentFrame = currentFrame;
        this._animationState.repeatCount = range === 0 ? 0 : (ratio / range) >> 0;
        this._animationState.highLimitValue = highLimitValue;
        this._animationState.offsetValue = offsetValue;
        var currentValue = animation._interpolate(currentFrame, this._animationState);
        // Set value
        this.setValue(currentValue, weight);
        // Check events
        if (events.length) {
            for (var index = 0; index < events.length; index++) {
                // Make sure current frame has passed event frame and that event frame is within the current range
                // Also, handle both forward and reverse animations
                if ((range > 0 && currentFrame >= events[index].frame && events[index].frame >= from) ||
                    (range < 0 && currentFrame <= events[index].frame && events[index].frame <= from)) {
                    var event = events[index];
                    if (!event.isDone) {
                        // If event should be done only once, remove it.
                        if (event.onlyOnce) {
                            events.splice(index, 1);
                            index--;
                        }
                        event.isDone = true;
                        event.action(currentFrame);
                    } // Don't do anything if the event has already be done.
                }
            }
        }
        if (!returnValue) {
            this._stopped = true;
        }
        return returnValue;
    };
    return RuntimeAnimation;
}());

//# sourceMappingURL=runtimeAnimation.js.map

/***/ }),

/***/ "./node_modules/@babylonjs/core/Audio/analyser.js":
/*!********************************************************!*\
  !*** ./node_modules/@babylonjs/core/Audio/analyser.js ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Analyser": () => (/* binding */ Analyser)
/* harmony export */ });
/* harmony import */ var _Engines_engine__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../Engines/engine */ "./node_modules/@babylonjs/core/Engines/engine.js");

/**
 * Class used to work with sound analyzer using fast fourier transform (FFT)
 * @see http://doc.babylonjs.com/how_to/playing_sounds_and_music
 */
var Analyser = /** @class */ (function () {
    /**
     * Creates a new analyser
     * @param scene defines hosting scene
     */
    function Analyser(scene) {
        /**
         * Gets or sets the smoothing
         * @ignorenaming
         */
        this.SMOOTHING = 0.75;
        /**
         * Gets or sets the FFT table size
         * @ignorenaming
         */
        this.FFT_SIZE = 512;
        /**
         * Gets or sets the bar graph amplitude
         * @ignorenaming
         */
        this.BARGRAPHAMPLITUDE = 256;
        /**
         * Gets or sets the position of the debug canvas
         * @ignorenaming
         */
        this.DEBUGCANVASPOS = { x: 20, y: 20 };
        /**
         * Gets or sets the debug canvas size
         * @ignorenaming
         */
        this.DEBUGCANVASSIZE = { width: 320, height: 200 };
        this._scene = scene;
        this._audioEngine = _Engines_engine__WEBPACK_IMPORTED_MODULE_0__.Engine.audioEngine;
        if (this._audioEngine.canUseWebAudio && this._audioEngine.audioContext) {
            this._webAudioAnalyser = this._audioEngine.audioContext.createAnalyser();
            this._webAudioAnalyser.minDecibels = -140;
            this._webAudioAnalyser.maxDecibels = 0;
            this._byteFreqs = new Uint8Array(this._webAudioAnalyser.frequencyBinCount);
            this._byteTime = new Uint8Array(this._webAudioAnalyser.frequencyBinCount);
            this._floatFreqs = new Float32Array(this._webAudioAnalyser.frequencyBinCount);
        }
    }
    /**
     * Get the number of data values you will have to play with for the visualization
     * @see https://developer.mozilla.org/en-US/docs/Web/API/AnalyserNode/frequencyBinCount
     * @returns a number
     */
    Analyser.prototype.getFrequencyBinCount = function () {
        if (this._audioEngine.canUseWebAudio) {
            return this._webAudioAnalyser.frequencyBinCount;
        }
        else {
            return 0;
        }
    };
    /**
     * Gets the current frequency data as a byte array
     * @see https://developer.mozilla.org/en-US/docs/Web/API/AnalyserNode/getByteFrequencyData
     * @returns a Uint8Array
     */
    Analyser.prototype.getByteFrequencyData = function () {
        if (this._audioEngine.canUseWebAudio) {
            this._webAudioAnalyser.smoothingTimeConstant = this.SMOOTHING;
            this._webAudioAnalyser.fftSize = this.FFT_SIZE;
            this._webAudioAnalyser.getByteFrequencyData(this._byteFreqs);
        }
        return this._byteFreqs;
    };
    /**
     * Gets the current waveform as a byte array
     * @see https://developer.mozilla.org/en-US/docs/Web/API/AnalyserNode/getByteTimeDomainData
     * @returns a Uint8Array
     */
    Analyser.prototype.getByteTimeDomainData = function () {
        if (this._audioEngine.canUseWebAudio) {
            this._webAudioAnalyser.smoothingTimeConstant = this.SMOOTHING;
            this._webAudioAnalyser.fftSize = this.FFT_SIZE;
            this._webAudioAnalyser.getByteTimeDomainData(this._byteTime);
        }
        return this._byteTime;
    };
    /**
     * Gets the current frequency data as a float array
     * @see https://developer.mozilla.org/en-US/docs/Web/API/AnalyserNode/getByteFrequencyData
     * @returns a Float32Array
     */
    Analyser.prototype.getFloatFrequencyData = function () {
        if (this._audioEngine.canUseWebAudio) {
            this._webAudioAnalyser.smoothingTimeConstant = this.SMOOTHING;
            this._webAudioAnalyser.fftSize = this.FFT_SIZE;
            this._webAudioAnalyser.getFloatFrequencyData(this._floatFreqs);
        }
        return this._floatFreqs;
    };
    /**
     * Renders the debug canvas
     */
    Analyser.prototype.drawDebugCanvas = function () {
        var _this = this;
        if (this._audioEngine.canUseWebAudio) {
            if (!this._debugCanvas) {
                this._debugCanvas = document.createElement("canvas");
                this._debugCanvas.width = this.DEBUGCANVASSIZE.width;
                this._debugCanvas.height = this.DEBUGCANVASSIZE.height;
                this._debugCanvas.style.position = "absolute";
                this._debugCanvas.style.top = this.DEBUGCANVASPOS.y + "px";
                this._debugCanvas.style.left = this.DEBUGCANVASPOS.x + "px";
                this._debugCanvasContext = this._debugCanvas.getContext("2d");
                document.body.appendChild(this._debugCanvas);
                this._registerFunc = function () {
                    _this.drawDebugCanvas();
                };
                this._scene.registerBeforeRender(this._registerFunc);
            }
            if (this._registerFunc && this._debugCanvasContext) {
                var workingArray = this.getByteFrequencyData();
                this._debugCanvasContext.fillStyle = 'rgb(0, 0, 0)';
                this._debugCanvasContext.fillRect(0, 0, this.DEBUGCANVASSIZE.width, this.DEBUGCANVASSIZE.height);
                // Draw the frequency domain chart.
                for (var i = 0; i < this.getFrequencyBinCount(); i++) {
                    var value = workingArray[i];
                    var percent = value / this.BARGRAPHAMPLITUDE;
                    var height = this.DEBUGCANVASSIZE.height * percent;
                    var offset = this.DEBUGCANVASSIZE.height - height - 1;
                    var barWidth = this.DEBUGCANVASSIZE.width / this.getFrequencyBinCount();
                    var hue = i / this.getFrequencyBinCount() * 360;
                    this._debugCanvasContext.fillStyle = 'hsl(' + hue + ', 100%, 50%)';
                    this._debugCanvasContext.fillRect(i * barWidth, offset, barWidth, height);
                }
            }
        }
    };
    /**
     * Stops rendering the debug canvas and removes it
     */
    Analyser.prototype.stopDebugCanvas = function () {
        if (this._debugCanvas) {
            if (this._registerFunc) {
                this._scene.unregisterBeforeRender(this._registerFunc);
                this._registerFunc = null;
            }
            document.body.removeChild(this._debugCanvas);
            this._debugCanvas = null;
            this._debugCanvasContext = null;
        }
    };
    /**
     * Connects two audio nodes
     * @param inputAudioNode defines first node to connect
     * @param outputAudioNode defines second node to connect
     */
    Analyser.prototype.connectAudioNodes = function (inputAudioNode, outputAudioNode) {
        if (this._audioEngine.canUseWebAudio) {
            inputAudioNode.connect(this._webAudioAnalyser);
            this._webAudioAnalyser.connect(outputAudioNode);
        }
    };
    /**
     * Releases all associated resources
     */
    Analyser.prototype.dispose = function () {
        if (this._audioEngine.canUseWebAudio) {
            this._webAudioAnalyser.disconnect();
        }
    };
    return Analyser;
}());

//# sourceMappingURL=analyser.js.map

/***/ }),

/***/ "./node_modules/@babylonjs/core/Audio/audioEngine.js":
/*!***********************************************************!*\
  !*** ./node_modules/@babylonjs/core/Audio/audioEngine.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "AudioEngine": () => (/* binding */ AudioEngine)
/* harmony export */ });
/* harmony import */ var _Misc_observable__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../Misc/observable */ "./node_modules/@babylonjs/core/Misc/observable.js");
/* harmony import */ var _Misc_logger__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Misc/logger */ "./node_modules/@babylonjs/core/Misc/logger.js");
/* harmony import */ var _Engines_engine__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Engines/engine */ "./node_modules/@babylonjs/core/Engines/engine.js");



// Sets the default audio engine to Babylon.js
_Engines_engine__WEBPACK_IMPORTED_MODULE_2__.Engine.AudioEngineFactory = function (hostElement) { return new AudioEngine(hostElement); };
/**
 * This represents the default audio engine used in babylon.
 * It is responsible to play, synchronize and analyse sounds throughout the  application.
 * @see http://doc.babylonjs.com/how_to/playing_sounds_and_music
 */
var AudioEngine = /** @class */ (function () {
    /**
     * Instantiates a new audio engine.
     *
     * There should be only one per page as some browsers restrict the number
     * of audio contexts you can create.
     * @param hostElement defines the host element where to display the mute icon if necessary
     */
    function AudioEngine(hostElement) {
        var _this = this;
        if (hostElement === void 0) { hostElement = null; }
        this._audioContext = null;
        this._audioContextInitialized = false;
        this._muteButton = null;
        /**
         * Gets whether the current host supports Web Audio and thus could create AudioContexts.
         */
        this.canUseWebAudio = false;
        /**
         * Defines if Babylon should emit a warning if WebAudio is not supported.
         * @ignoreNaming
         */
        this.WarnedWebAudioUnsupported = false;
        /**
         * Gets whether or not mp3 are supported by your browser.
         */
        this.isMP3supported = false;
        /**
         * Gets whether or not ogg are supported by your browser.
         */
        this.isOGGsupported = false;
        /**
         * Gets whether audio has been unlocked on the device.
         * Some Browsers have strong restrictions about Audio and won t autoplay unless
         * a user interaction has happened.
         */
        this.unlocked = true;
        /**
         * Defines if the audio engine relies on a custom unlocked button.
         * In this case, the embedded button will not be displayed.
         */
        this.useCustomUnlockedButton = false;
        /**
         * Event raised when audio has been unlocked on the browser.
         */
        this.onAudioUnlockedObservable = new _Misc_observable__WEBPACK_IMPORTED_MODULE_0__.Observable();
        /**
         * Event raised when audio has been locked on the browser.
         */
        this.onAudioLockedObservable = new _Misc_observable__WEBPACK_IMPORTED_MODULE_0__.Observable();
        this._tryToRun = false;
        this._onResize = function () {
            _this._moveButtonToTopLeft();
        };
        if (typeof window.AudioContext !== 'undefined' || typeof window.webkitAudioContext !== 'undefined') {
            window.AudioContext = window.AudioContext || window.webkitAudioContext;
            this.canUseWebAudio = true;
        }
        var audioElem = document.createElement('audio');
        this._hostElement = hostElement;
        try {
            if (audioElem && !!audioElem.canPlayType && audioElem.canPlayType('audio/mpeg; codecs="mp3"').replace(/^no$/, '')) {
                this.isMP3supported = true;
            }
        }
        catch (e) {
            // protect error during capability check.
        }
        try {
            if (audioElem && !!audioElem.canPlayType && audioElem.canPlayType('audio/ogg; codecs="vorbis"').replace(/^no$/, '')) {
                this.isOGGsupported = true;
            }
        }
        catch (e) {
            // protect error during capability check.
        }
    }
    Object.defineProperty(AudioEngine.prototype, "audioContext", {
        /**
         * Gets the current AudioContext if available.
         */
        get: function () {
            if (!this._audioContextInitialized) {
                this._initializeAudioContext();
            }
            else {
                if (!this.unlocked && !this._muteButton) {
                    this._displayMuteButton();
                }
            }
            return this._audioContext;
        },
        enumerable: true,
        configurable: true
    });
    /**
     * Flags the audio engine in Locked state.
     * This happens due to new browser policies preventing audio to autoplay.
     */
    AudioEngine.prototype.lock = function () {
        this._triggerSuspendedState();
    };
    /**
     * Unlocks the audio engine once a user action has been done on the dom.
     * This is helpful to resume play once browser policies have been satisfied.
     */
    AudioEngine.prototype.unlock = function () {
        this._triggerRunningState();
    };
    AudioEngine.prototype._resumeAudioContext = function () {
        var result;
        if (this._audioContext.resume) {
            result = this._audioContext.resume();
        }
        return result || Promise.resolve();
    };
    AudioEngine.prototype._initializeAudioContext = function () {
        try {
            if (this.canUseWebAudio) {
                this._audioContext = new AudioContext();
                // create a global volume gain node
                this.masterGain = this._audioContext.createGain();
                this.masterGain.gain.value = 1;
                this.masterGain.connect(this._audioContext.destination);
                this._audioContextInitialized = true;
                if (this._audioContext.state === "running") {
                    // Do not wait for the promise to unlock.
                    this._triggerRunningState();
                }
            }
        }
        catch (e) {
            this.canUseWebAudio = false;
            _Misc_logger__WEBPACK_IMPORTED_MODULE_1__.Logger.Error("Web Audio: " + e.message);
        }
    };
    AudioEngine.prototype._triggerRunningState = function () {
        var _this = this;
        if (this._tryToRun) {
            return;
        }
        this._tryToRun = true;
        this._resumeAudioContext()
            .then(function () {
            _this._tryToRun = false;
            if (_this._muteButton) {
                _this._hideMuteButton();
            }
        }).catch(function () {
            _this._tryToRun = false;
            _this.unlocked = false;
        });
        // Notify users that the audio stack is unlocked/unmuted
        this.unlocked = true;
        this.onAudioUnlockedObservable.notifyObservers(this);
    };
    AudioEngine.prototype._triggerSuspendedState = function () {
        this.unlocked = false;
        this.onAudioLockedObservable.notifyObservers(this);
        this._displayMuteButton();
    };
    AudioEngine.prototype._displayMuteButton = function () {
        var _this = this;
        if (this.useCustomUnlockedButton || this._muteButton) {
            return;
        }
        this._muteButton = document.createElement("BUTTON");
        this._muteButton.className = "babylonUnmuteIcon";
        this._muteButton.id = "babylonUnmuteIconBtn";
        this._muteButton.title = "Unmute";
        var imageUrl = !window.SVGSVGElement ? "https://cdn.babylonjs.com/Assets/audio.png" : "data:image/svg+xml;charset=UTF-8,%3Csvg%20version%3D%221.1%22%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2239%22%20height%3D%2232%22%20viewBox%3D%220%200%2039%2032%22%3E%3Cpath%20fill%3D%22white%22%20d%3D%22M9.625%2018.938l-0.031%200.016h-4.953q-0.016%200-0.031-0.016v-12.453q0-0.016%200.031-0.016h4.953q0.031%200%200.031%200.016v12.453zM12.125%207.688l8.719-8.703v27.453l-8.719-8.719-0.016-0.047v-9.938zM23.359%207.875l1.406-1.406%204.219%204.203%204.203-4.203%201.422%201.406-4.219%204.219%204.219%204.203-1.484%201.359-4.141-4.156-4.219%204.219-1.406-1.422%204.219-4.203z%22%3E%3C%2Fpath%3E%3C%2Fsvg%3E";
        var css = ".babylonUnmuteIcon { position: absolute; left: 20px; top: 20px; height: 40px; width: 60px; background-color: rgba(51,51,51,0.7); background-image: url(" + imageUrl + ");  background-size: 80%; background-repeat:no-repeat; background-position: center; background-position-y: 4px; border: none; outline: none; transition: transform 0.125s ease-out; cursor: pointer; z-index: 9999; } .babylonUnmuteIcon:hover { transform: scale(1.05) } .babylonUnmuteIcon:active { background-color: rgba(51,51,51,1) }";
        var style = document.createElement('style');
        style.appendChild(document.createTextNode(css));
        document.getElementsByTagName('head')[0].appendChild(style);
        document.body.appendChild(this._muteButton);
        this._moveButtonToTopLeft();
        this._muteButton.addEventListener('touchend', function () {
            _this._triggerRunningState();
        }, true);
        this._muteButton.addEventListener('click', function () {
            _this._triggerRunningState();
        }, true);
        window.addEventListener("resize", this._onResize);
    };
    AudioEngine.prototype._moveButtonToTopLeft = function () {
        if (this._hostElement && this._muteButton) {
            this._muteButton.style.top = this._hostElement.offsetTop + 20 + "px";
            this._muteButton.style.left = this._hostElement.offsetLeft + 20 + "px";
        }
    };
    AudioEngine.prototype._hideMuteButton = function () {
        if (this._muteButton) {
            document.body.removeChild(this._muteButton);
            this._muteButton = null;
        }
    };
    /**
     * Destroy and release the resources associated with the audio ccontext.
     */
    AudioEngine.prototype.dispose = function () {
        if (this.canUseWebAudio && this._audioContextInitialized) {
            if (this._connectedAnalyser && this._audioContext) {
                this._connectedAnalyser.stopDebugCanvas();
                this._connectedAnalyser.dispose();
                this.masterGain.disconnect();
                this.masterGain.connect(this._audioContext.destination);
                this._connectedAnalyser = null;
            }
            this.masterGain.gain.value = 1;
        }
        this.WarnedWebAudioUnsupported = false;
        this._hideMuteButton();
        window.removeEventListener("resize", this._onResize);
        this.onAudioUnlockedObservable.clear();
        this.onAudioLockedObservable.clear();
    };
    /**
     * Gets the global volume sets on the master gain.
     * @returns the global volume if set or -1 otherwise
     */
    AudioEngine.prototype.getGlobalVolume = function () {
        if (this.canUseWebAudio && this._audioContextInitialized) {
            return this.masterGain.gain.value;
        }
        else {
            return -1;
        }
    };
    /**
     * Sets the global volume of your experience (sets on the master gain).
     * @param newVolume Defines the new global volume of the application
     */
    AudioEngine.prototype.setGlobalVolume = function (newVolume) {
        if (this.canUseWebAudio && this._audioContextInitialized) {
            this.masterGain.gain.value = newVolume;
        }
    };
    /**
     * Connect the audio engine to an audio analyser allowing some amazing
     * synchornization between the sounds/music and your visualization (VuMeter for instance).
     * @see http://doc.babylonjs.com/how_to/playing_sounds_and_music#using-the-analyser
     * @param analyser The analyser to connect to the engine
     */
    AudioEngine.prototype.connectToAnalyser = function (analyser) {
        if (this._connectedAnalyser) {
            this._connectedAnalyser.stopDebugCanvas();
        }
        if (this.canUseWebAudio && this._audioContextInitialized && this._audioContext) {
            this._connectedAnalyser = analyser;
            this.masterGain.disconnect();
            this._connectedAnalyser.connectAudioNodes(this.masterGain, this._audioContext.destination);
        }
    };
    return AudioEngine;
}());

//# sourceMappingURL=audioEngine.js.map

/***/ }),

/***/ "./node_modules/@babylonjs/core/Audio/audioSceneComponent.js":
/*!*******************************************************************!*\
  !*** ./node_modules/@babylonjs/core/Audio/audioSceneComponent.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "AudioSceneComponent": () => (/* binding */ AudioSceneComponent)
/* harmony export */ });
/* harmony import */ var _sound__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./sound */ "./node_modules/@babylonjs/core/Audio/sound.js");
/* harmony import */ var _soundTrack__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./soundTrack */ "./node_modules/@babylonjs/core/Audio/soundTrack.js");
/* harmony import */ var _Engines_engine__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Engines/engine */ "./node_modules/@babylonjs/core/Engines/engine.js");
/* harmony import */ var _Maths_math_vector__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../Maths/math.vector */ "./node_modules/@babylonjs/core/Maths/math.vector.js");
/* harmony import */ var _sceneComponent__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../sceneComponent */ "./node_modules/@babylonjs/core/sceneComponent.js");
/* harmony import */ var _scene__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../scene */ "./node_modules/@babylonjs/core/scene.js");
/* harmony import */ var _abstractScene__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../abstractScene */ "./node_modules/@babylonjs/core/abstractScene.js");
/* harmony import */ var _audioEngine__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./audioEngine */ "./node_modules/@babylonjs/core/Audio/audioEngine.js");
/* harmony import */ var _Misc_precisionDate__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../Misc/precisionDate */ "./node_modules/@babylonjs/core/Misc/precisionDate.js");









// Adds the parser to the scene parsers.
_abstractScene__WEBPACK_IMPORTED_MODULE_6__.AbstractScene.AddParser(_sceneComponent__WEBPACK_IMPORTED_MODULE_4__.SceneComponentConstants.NAME_AUDIO, function (parsedData, scene, container, rootUrl) {
    // TODO: add sound
    var loadedSounds = [];
    var loadedSound;
    container.sounds = container.sounds || [];
    if (parsedData.sounds !== undefined && parsedData.sounds !== null) {
        for (var index = 0, cache = parsedData.sounds.length; index < cache; index++) {
            var parsedSound = parsedData.sounds[index];
            if (_Engines_engine__WEBPACK_IMPORTED_MODULE_2__.Engine.audioEngine.canUseWebAudio) {
                if (!parsedSound.url) {
                    parsedSound.url = parsedSound.name;
                }
                if (!loadedSounds[parsedSound.url]) {
                    loadedSound = _sound__WEBPACK_IMPORTED_MODULE_0__.Sound.Parse(parsedSound, scene, rootUrl);
                    loadedSounds[parsedSound.url] = loadedSound;
                    container.sounds.push(loadedSound);
                }
                else {
                    container.sounds.push(_sound__WEBPACK_IMPORTED_MODULE_0__.Sound.Parse(parsedSound, scene, rootUrl, loadedSounds[parsedSound.url]));
                }
            }
            else {
                container.sounds.push(new _sound__WEBPACK_IMPORTED_MODULE_0__.Sound(parsedSound.name, null, scene));
            }
        }
    }
    loadedSounds = [];
});
Object.defineProperty(_scene__WEBPACK_IMPORTED_MODULE_5__.Scene.prototype, "mainSoundTrack", {
    get: function () {
        var compo = this._getComponent(_sceneComponent__WEBPACK_IMPORTED_MODULE_4__.SceneComponentConstants.NAME_AUDIO);
        if (!compo) {
            compo = new AudioSceneComponent(this);
            this._addComponent(compo);
        }
        if (!this._mainSoundTrack) {
            this._mainSoundTrack = new _soundTrack__WEBPACK_IMPORTED_MODULE_1__.SoundTrack(this, { mainTrack: true });
        }
        return this._mainSoundTrack;
    },
    enumerable: true,
    configurable: true
});
_scene__WEBPACK_IMPORTED_MODULE_5__.Scene.prototype.getSoundByName = function (name) {
    var index;
    for (index = 0; index < this.mainSoundTrack.soundCollection.length; index++) {
        if (this.mainSoundTrack.soundCollection[index].name === name) {
            return this.mainSoundTrack.soundCollection[index];
        }
    }
    if (this.soundTracks) {
        for (var sdIndex = 0; sdIndex < this.soundTracks.length; sdIndex++) {
            for (index = 0; index < this.soundTracks[sdIndex].soundCollection.length; index++) {
                if (this.soundTracks[sdIndex].soundCollection[index].name === name) {
                    return this.soundTracks[sdIndex].soundCollection[index];
                }
            }
        }
    }
    return null;
};
Object.defineProperty(_scene__WEBPACK_IMPORTED_MODULE_5__.Scene.prototype, "audioEnabled", {
    get: function () {
        var compo = this._getComponent(_sceneComponent__WEBPACK_IMPORTED_MODULE_4__.SceneComponentConstants.NAME_AUDIO);
        if (!compo) {
            compo = new AudioSceneComponent(this);
            this._addComponent(compo);
        }
        return compo.audioEnabled;
    },
    set: function (value) {
        var compo = this._getComponent(_sceneComponent__WEBPACK_IMPORTED_MODULE_4__.SceneComponentConstants.NAME_AUDIO);
        if (!compo) {
            compo = new AudioSceneComponent(this);
            this._addComponent(compo);
        }
        if (value) {
            compo.enableAudio();
        }
        else {
            compo.disableAudio();
        }
    },
    enumerable: true,
    configurable: true
});
Object.defineProperty(_scene__WEBPACK_IMPORTED_MODULE_5__.Scene.prototype, "headphone", {
    get: function () {
        var compo = this._getComponent(_sceneComponent__WEBPACK_IMPORTED_MODULE_4__.SceneComponentConstants.NAME_AUDIO);
        if (!compo) {
            compo = new AudioSceneComponent(this);
            this._addComponent(compo);
        }
        return compo.headphone;
    },
    set: function (value) {
        var compo = this._getComponent(_sceneComponent__WEBPACK_IMPORTED_MODULE_4__.SceneComponentConstants.NAME_AUDIO);
        if (!compo) {
            compo = new AudioSceneComponent(this);
            this._addComponent(compo);
        }
        if (value) {
            compo.switchAudioModeForHeadphones();
        }
        else {
            compo.switchAudioModeForNormalSpeakers();
        }
    },
    enumerable: true,
    configurable: true
});
Object.defineProperty(_scene__WEBPACK_IMPORTED_MODULE_5__.Scene.prototype, "audioListenerPositionProvider", {
    get: function () {
        var compo = this._getComponent(_sceneComponent__WEBPACK_IMPORTED_MODULE_4__.SceneComponentConstants.NAME_AUDIO);
        if (!compo) {
            compo = new AudioSceneComponent(this);
            this._addComponent(compo);
        }
        return compo.audioListenerPositionProvider;
    },
    set: function (value) {
        var compo = this._getComponent(_sceneComponent__WEBPACK_IMPORTED_MODULE_4__.SceneComponentConstants.NAME_AUDIO);
        if (!compo) {
            compo = new AudioSceneComponent(this);
            this._addComponent(compo);
        }
        if (typeof value !== 'function') {
            throw new Error('The value passed to [Scene.audioListenerPositionProvider] must be a function that returns a Vector3');
        }
        else {
            compo.audioListenerPositionProvider = value;
        }
    },
    enumerable: true,
    configurable: true
});
Object.defineProperty(_scene__WEBPACK_IMPORTED_MODULE_5__.Scene.prototype, "audioPositioningRefreshRate", {
    get: function () {
        var compo = this._getComponent(_sceneComponent__WEBPACK_IMPORTED_MODULE_4__.SceneComponentConstants.NAME_AUDIO);
        if (!compo) {
            compo = new AudioSceneComponent(this);
            this._addComponent(compo);
        }
        return compo.audioPositioningRefreshRate;
    },
    set: function (value) {
        var compo = this._getComponent(_sceneComponent__WEBPACK_IMPORTED_MODULE_4__.SceneComponentConstants.NAME_AUDIO);
        if (!compo) {
            compo = new AudioSceneComponent(this);
            this._addComponent(compo);
        }
        compo.audioPositioningRefreshRate = value;
    },
    enumerable: true,
    configurable: true
});
/**
 * Defines the sound scene component responsible to manage any sounds
 * in a given scene.
 */
var AudioSceneComponent = /** @class */ (function () {
    /**
     * Creates a new instance of the component for the given scene
     * @param scene Defines the scene to register the component in
     */
    function AudioSceneComponent(scene) {
        /**
         * The component name helpfull to identify the component in the list of scene components.
         */
        this.name = _sceneComponent__WEBPACK_IMPORTED_MODULE_4__.SceneComponentConstants.NAME_AUDIO;
        this._audioEnabled = true;
        this._headphone = false;
        /**
         * Gets or sets a refresh rate when using 3D audio positioning
         */
        this.audioPositioningRefreshRate = 500;
        this._audioListenerPositionProvider = null;
        this._cachedCameraDirection = new _Maths_math_vector__WEBPACK_IMPORTED_MODULE_3__.Vector3();
        this._cachedCameraPosition = new _Maths_math_vector__WEBPACK_IMPORTED_MODULE_3__.Vector3();
        this._lastCheck = 0;
        this.scene = scene;
        scene.soundTracks = new Array();
        scene.sounds = new Array();
    }
    Object.defineProperty(AudioSceneComponent.prototype, "audioEnabled", {
        /**
         * Gets whether audio is enabled or not.
         * Please use related enable/disable method to switch state.
         */
        get: function () {
            return this._audioEnabled;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(AudioSceneComponent.prototype, "headphone", {
        /**
         * Gets whether audio is outputing to headphone or not.
         * Please use the according Switch methods to change output.
         */
        get: function () {
            return this._headphone;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(AudioSceneComponent.prototype, "audioListenerPositionProvider", {
        /**
         * Gets the current audio listener position provider
         */
        get: function () {
            return this._audioListenerPositionProvider;
        },
        /**
         * Sets a custom listener position for all sounds in the scene
         * By default, this is the position of the first active camera
         */
        set: function (value) {
            this._audioListenerPositionProvider = value;
        },
        enumerable: true,
        configurable: true
    });
    /**
     * Registers the component in a given scene
     */
    AudioSceneComponent.prototype.register = function () {
        this.scene._afterRenderStage.registerStep(_sceneComponent__WEBPACK_IMPORTED_MODULE_4__.SceneComponentConstants.STEP_AFTERRENDER_AUDIO, this, this._afterRender);
    };
    /**
     * Rebuilds the elements related to this component in case of
     * context lost for instance.
     */
    AudioSceneComponent.prototype.rebuild = function () {
        // Nothing to do here. (Not rendering related)
    };
    /**
     * Serializes the component data to the specified json object
     * @param serializationObject The object to serialize to
     */
    AudioSceneComponent.prototype.serialize = function (serializationObject) {
        serializationObject.sounds = [];
        if (this.scene.soundTracks) {
            for (var index = 0; index < this.scene.soundTracks.length; index++) {
                var soundtrack = this.scene.soundTracks[index];
                for (var soundId = 0; soundId < soundtrack.soundCollection.length; soundId++) {
                    serializationObject.sounds.push(soundtrack.soundCollection[soundId].serialize());
                }
            }
        }
    };
    /**
     * Adds all the elements from the container to the scene
     * @param container the container holding the elements
     */
    AudioSceneComponent.prototype.addFromContainer = function (container) {
        var _this = this;
        if (!container.sounds) {
            return;
        }
        container.sounds.forEach(function (sound) {
            sound.play();
            sound.autoplay = true;
            _this.scene.mainSoundTrack.AddSound(sound);
        });
    };
    /**
     * Removes all the elements in the container from the scene
     * @param container contains the elements to remove
     * @param dispose if the removed element should be disposed (default: false)
     */
    AudioSceneComponent.prototype.removeFromContainer = function (container, dispose) {
        var _this = this;
        if (dispose === void 0) { dispose = false; }
        if (!container.sounds) {
            return;
        }
        container.sounds.forEach(function (sound) {
            sound.stop();
            sound.autoplay = false;
            _this.scene.mainSoundTrack.RemoveSound(sound);
            if (dispose) {
                sound.dispose();
            }
        });
    };
    /**
     * Disposes the component and the associated ressources.
     */
    AudioSceneComponent.prototype.dispose = function () {
        var scene = this.scene;
        if (scene._mainSoundTrack) {
            scene.mainSoundTrack.dispose();
        }
        if (scene.soundTracks) {
            for (var scIndex = 0; scIndex < scene.soundTracks.length; scIndex++) {
                scene.soundTracks[scIndex].dispose();
            }
        }
    };
    /**
     * Disables audio in the associated scene.
     */
    AudioSceneComponent.prototype.disableAudio = function () {
        var scene = this.scene;
        this._audioEnabled = false;
        if (_Engines_engine__WEBPACK_IMPORTED_MODULE_2__.Engine.audioEngine && _Engines_engine__WEBPACK_IMPORTED_MODULE_2__.Engine.audioEngine.audioContext) {
            _Engines_engine__WEBPACK_IMPORTED_MODULE_2__.Engine.audioEngine.audioContext.suspend();
        }
        var i;
        for (i = 0; i < scene.mainSoundTrack.soundCollection.length; i++) {
            scene.mainSoundTrack.soundCollection[i].pause();
        }
        if (scene.soundTracks) {
            for (i = 0; i < scene.soundTracks.length; i++) {
                for (var j = 0; j < scene.soundTracks[i].soundCollection.length; j++) {
                    scene.soundTracks[i].soundCollection[j].pause();
                }
            }
        }
    };
    /**
     * Enables audio in the associated scene.
     */
    AudioSceneComponent.prototype.enableAudio = function () {
        var scene = this.scene;
        this._audioEnabled = true;
        if (_Engines_engine__WEBPACK_IMPORTED_MODULE_2__.Engine.audioEngine && _Engines_engine__WEBPACK_IMPORTED_MODULE_2__.Engine.audioEngine.audioContext) {
            _Engines_engine__WEBPACK_IMPORTED_MODULE_2__.Engine.audioEngine.audioContext.resume();
        }
        var i;
        for (i = 0; i < scene.mainSoundTrack.soundCollection.length; i++) {
            if (scene.mainSoundTrack.soundCollection[i].isPaused) {
                scene.mainSoundTrack.soundCollection[i].play();
            }
        }
        if (scene.soundTracks) {
            for (i = 0; i < scene.soundTracks.length; i++) {
                for (var j = 0; j < scene.soundTracks[i].soundCollection.length; j++) {
                    if (scene.soundTracks[i].soundCollection[j].isPaused) {
                        scene.soundTracks[i].soundCollection[j].play();
                    }
                }
            }
        }
    };
    /**
     * Switch audio to headphone output.
     */
    AudioSceneComponent.prototype.switchAudioModeForHeadphones = function () {
        var scene = this.scene;
        this._headphone = true;
        scene.mainSoundTrack.switchPanningModelToHRTF();
        if (scene.soundTracks) {
            for (var i = 0; i < scene.soundTracks.length; i++) {
                scene.soundTracks[i].switchPanningModelToHRTF();
            }
        }
    };
    /**
     * Switch audio to normal speakers.
     */
    AudioSceneComponent.prototype.switchAudioModeForNormalSpeakers = function () {
        var scene = this.scene;
        this._headphone = false;
        scene.mainSoundTrack.switchPanningModelToEqualPower();
        if (scene.soundTracks) {
            for (var i = 0; i < scene.soundTracks.length; i++) {
                scene.soundTracks[i].switchPanningModelToEqualPower();
            }
        }
    };
    AudioSceneComponent.prototype._afterRender = function () {
        var now = _Misc_precisionDate__WEBPACK_IMPORTED_MODULE_8__.PrecisionDate.Now;
        if (this._lastCheck && now - this._lastCheck < this.audioPositioningRefreshRate) {
            return;
        }
        this._lastCheck = now;
        var scene = this.scene;
        if (!this._audioEnabled || !scene._mainSoundTrack || !scene.soundTracks || (scene._mainSoundTrack.soundCollection.length === 0 && scene.soundTracks.length === 1)) {
            return;
        }
        var audioEngine = _Engines_engine__WEBPACK_IMPORTED_MODULE_2__.Engine.audioEngine;
        if (audioEngine.audioContext) {
            // A custom listener position provider was set
            // Use the users provided position instead of camera's
            if (this._audioListenerPositionProvider) {
                var position = this._audioListenerPositionProvider();
                // Make sure all coordinates were provided
                position.x = position.x || 0;
                position.y = position.y || 0;
                position.z = position.z || 0;
                // Set the listener position
                audioEngine.audioContext.listener.setPosition(position.x, position.y, position.z);
            }
            else {
                var listeningCamera;
                if (scene.activeCameras.length > 0) {
                    listeningCamera = scene.activeCameras[0];
                }
                else {
                    listeningCamera = scene.activeCamera;
                }
                // Check if there is a listening camera
                if (listeningCamera) {
                    // Set the listener position to the listening camera global position
                    if (!this._cachedCameraPosition.equals(listeningCamera.globalPosition)) {
                        this._cachedCameraPosition.copyFrom(listeningCamera.globalPosition);
                        audioEngine.audioContext.listener.setPosition(listeningCamera.globalPosition.x, listeningCamera.globalPosition.y, listeningCamera.globalPosition.z);
                    }
                    // for VR cameras
                    if (listeningCamera.rigCameras && listeningCamera.rigCameras.length > 0) {
                        listeningCamera = listeningCamera.rigCameras[0];
                    }
                    var mat = _Maths_math_vector__WEBPACK_IMPORTED_MODULE_3__.Matrix.Invert(listeningCamera.getViewMatrix());
                    var cameraDirection = _Maths_math_vector__WEBPACK_IMPORTED_MODULE_3__.Vector3.TransformNormal(new _Maths_math_vector__WEBPACK_IMPORTED_MODULE_3__.Vector3(0, 0, -1), mat);
                    cameraDirection.normalize();
                    // To avoid some errors on GearVR
                    if (!isNaN(cameraDirection.x) && !isNaN(cameraDirection.y) && !isNaN(cameraDirection.z)) {
                        if (!this._cachedCameraDirection.equals(cameraDirection)) {
                            this._cachedCameraDirection.copyFrom(cameraDirection);
                            audioEngine.audioContext.listener.setOrientation(cameraDirection.x, cameraDirection.y, cameraDirection.z, 0, 1, 0);
                        }
                    }
                }
                // Otherwise set the listener position to 0, 0 ,0
                else {
                    // Set the listener position
                    audioEngine.audioContext.listener.setPosition(0, 0, 0);
                }
            }
            var i;
            for (i = 0; i < scene.mainSoundTrack.soundCollection.length; i++) {
                var sound = scene.mainSoundTrack.soundCollection[i];
                if (sound.useCustomAttenuation) {
                    sound.updateDistanceFromListener();
                }
            }
            if (scene.soundTracks) {
                for (i = 0; i < scene.soundTracks.length; i++) {
                    for (var j = 0; j < scene.soundTracks[i].soundCollection.length; j++) {
                        sound = scene.soundTracks[i].soundCollection[j];
                        if (sound.useCustomAttenuation) {
                            sound.updateDistanceFromListener();
                        }
                    }
                }
            }
        }
    };
    return AudioSceneComponent;
}());

_sound__WEBPACK_IMPORTED_MODULE_0__.Sound._SceneComponentInitialization = function (scene) {
    var compo = scene._getComponent(_sceneComponent__WEBPACK_IMPORTED_MODULE_4__.SceneComponentConstants.NAME_AUDIO);
    if (!compo) {
        compo = new AudioSceneComponent(scene);
        scene._addComponent(compo);
    }
};
//# sourceMappingURL=audioSceneComponent.js.map

/***/ }),

/***/ "./node_modules/@babylonjs/core/Audio/index.js":
/*!*****************************************************!*\
  !*** ./node_modules/@babylonjs/core/Audio/index.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Analyser": () => (/* reexport safe */ _analyser__WEBPACK_IMPORTED_MODULE_0__.Analyser),
/* harmony export */   "AudioEngine": () => (/* reexport safe */ _audioEngine__WEBPACK_IMPORTED_MODULE_1__.AudioEngine),
/* harmony export */   "AudioSceneComponent": () => (/* reexport safe */ _audioSceneComponent__WEBPACK_IMPORTED_MODULE_2__.AudioSceneComponent),
/* harmony export */   "Sound": () => (/* reexport safe */ _sound__WEBPACK_IMPORTED_MODULE_3__.Sound),
/* harmony export */   "SoundTrack": () => (/* reexport safe */ _soundTrack__WEBPACK_IMPORTED_MODULE_4__.SoundTrack),
/* harmony export */   "WeightedSound": () => (/* reexport safe */ _weightedsound__WEBPACK_IMPORTED_MODULE_5__.WeightedSound)
/* harmony export */ });
/* harmony import */ var _analyser__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./analyser */ "./node_modules/@babylonjs/core/Audio/analyser.js");
/* harmony import */ var _audioEngine__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./audioEngine */ "./node_modules/@babylonjs/core/Audio/audioEngine.js");
/* harmony import */ var _audioSceneComponent__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./audioSceneComponent */ "./node_modules/@babylonjs/core/Audio/audioSceneComponent.js");
/* harmony import */ var _sound__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./sound */ "./node_modules/@babylonjs/core/Audio/sound.js");
/* harmony import */ var _soundTrack__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./soundTrack */ "./node_modules/@babylonjs/core/Audio/soundTrack.js");
/* harmony import */ var _weightedsound__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./weightedsound */ "./node_modules/@babylonjs/core/Audio/weightedsound.js");






//# sourceMappingURL=index.js.map

/***/ }),

/***/ "./node_modules/@babylonjs/core/Audio/sound.js":
/*!*****************************************************!*\
  !*** ./node_modules/@babylonjs/core/Audio/sound.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Sound": () => (/* binding */ Sound)
/* harmony export */ });
/* harmony import */ var _Misc_tools__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../Misc/tools */ "./node_modules/@babylonjs/core/Misc/tools.js");
/* harmony import */ var _Misc_observable__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Misc/observable */ "./node_modules/@babylonjs/core/Misc/observable.js");
/* harmony import */ var _Maths_math_vector__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Maths/math.vector */ "./node_modules/@babylonjs/core/Maths/math.vector.js");
/* harmony import */ var _Engines_engine__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../Engines/engine */ "./node_modules/@babylonjs/core/Engines/engine.js");
/* harmony import */ var _Misc_logger__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../Misc/logger */ "./node_modules/@babylonjs/core/Misc/logger.js");
/* harmony import */ var _Misc_devTools__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../Misc/devTools */ "./node_modules/@babylonjs/core/Misc/devTools.js");






/**
 * Defines a sound that can be played in the application.
 * The sound can either be an ambient track or a simple sound played in reaction to a user action.
 * @see http://doc.babylonjs.com/how_to/playing_sounds_and_music
 */
var Sound = /** @class */ (function () {
    /**
    * Create a sound and attach it to a scene
    * @param name Name of your sound
    * @param urlOrArrayBuffer Url to the sound to load async or ArrayBuffer, it also works with MediaStreams
    * @param scene defines the scene the sound belongs to
    * @param readyToPlayCallback Provide a callback function if you'd like to load your code once the sound is ready to be played
    * @param options Objects to provide with the current available options: autoplay, loop, volume, spatialSound, maxDistance, rolloffFactor, refDistance, distanceModel, panningModel, streaming
    */
    function Sound(name, urlOrArrayBuffer, scene, readyToPlayCallback, options) {
        var _this = this;
        if (readyToPlayCallback === void 0) { readyToPlayCallback = null; }
        /**
         * Does the sound autoplay once loaded.
         */
        this.autoplay = false;
        /**
         * Does the sound loop after it finishes playing once.
         */
        this.loop = false;
        /**
         * Does the sound use a custom attenuation curve to simulate the falloff
         * happening when the source gets further away from the camera.
         * @see http://doc.babylonjs.com/how_to/playing_sounds_and_music#creating-your-own-custom-attenuation-function
         */
        this.useCustomAttenuation = false;
        /**
         * Is this sound currently played.
         */
        this.isPlaying = false;
        /**
         * Is this sound currently paused.
         */
        this.isPaused = false;
        /**
         * Does this sound enables spatial sound.
         * @see http://doc.babylonjs.com/how_to/playing_sounds_and_music#creating-a-spatial-3d-sound
         */
        this.spatialSound = false;
        /**
         * Define the reference distance the sound should be heard perfectly.
         * @see http://doc.babylonjs.com/how_to/playing_sounds_and_music#creating-a-spatial-3d-sound
         */
        this.refDistance = 1;
        /**
         * Define the roll off factor of spatial sounds.
         * @see http://doc.babylonjs.com/how_to/playing_sounds_and_music#creating-a-spatial-3d-sound
         */
        this.rolloffFactor = 1;
        /**
         * Define the max distance the sound should be heard (intensity just became 0 at this point).
         * @see http://doc.babylonjs.com/how_to/playing_sounds_and_music#creating-a-spatial-3d-sound
         */
        this.maxDistance = 100;
        /**
         * Define the distance attenuation model the sound will follow.
         * @see http://doc.babylonjs.com/how_to/playing_sounds_and_music#creating-a-spatial-3d-sound
         */
        this.distanceModel = "linear";
        /**
         * Observable event when the current playing sound finishes.
         */
        this.onEndedObservable = new _Misc_observable__WEBPACK_IMPORTED_MODULE_1__.Observable();
        this._panningModel = "equalpower";
        this._playbackRate = 1;
        this._streaming = false;
        this._startTime = 0;
        this._startOffset = 0;
        this._position = _Maths_math_vector__WEBPACK_IMPORTED_MODULE_2__.Vector3.Zero();
        /** @hidden */
        this._positionInEmitterSpace = false;
        this._localDirection = new _Maths_math_vector__WEBPACK_IMPORTED_MODULE_2__.Vector3(1, 0, 0);
        this._volume = 1;
        this._isReadyToPlay = false;
        this._isDirectional = false;
        // Used if you'd like to create a directional sound.
        // If not set, the sound will be omnidirectional
        this._coneInnerAngle = 360;
        this._coneOuterAngle = 360;
        this._coneOuterGain = 0;
        this._isOutputConnected = false;
        this._urlType = "Unknown";
        this.name = name;
        this._scene = scene;
        Sound._SceneComponentInitialization(scene);
        this._readyToPlayCallback = readyToPlayCallback;
        // Default custom attenuation function is a linear attenuation
        this._customAttenuationFunction = function (currentVolume, currentDistance, maxDistance, refDistance, rolloffFactor) {
            if (currentDistance < maxDistance) {
                return currentVolume * (1 - currentDistance / maxDistance);
            }
            else {
                return 0;
            }
        };
        if (options) {
            this.autoplay = options.autoplay || false;
            this.loop = options.loop || false;
            // if volume === 0, we need another way to check this option
            if (options.volume !== undefined) {
                this._volume = options.volume;
            }
            this.spatialSound = options.spatialSound || false;
            this.maxDistance = options.maxDistance || 100;
            this.useCustomAttenuation = options.useCustomAttenuation || false;
            this.rolloffFactor = options.rolloffFactor || 1;
            this.refDistance = options.refDistance || 1;
            this.distanceModel = options.distanceModel || "linear";
            this._playbackRate = options.playbackRate || 1;
            this._streaming = options.streaming || false;
            this._length = options.length;
            this._offset = options.offset;
        }
        if (_Engines_engine__WEBPACK_IMPORTED_MODULE_3__.Engine.audioEngine.canUseWebAudio && _Engines_engine__WEBPACK_IMPORTED_MODULE_3__.Engine.audioEngine.audioContext) {
            this._soundGain = _Engines_engine__WEBPACK_IMPORTED_MODULE_3__.Engine.audioEngine.audioContext.createGain();
            this._soundGain.gain.value = this._volume;
            this._inputAudioNode = this._soundGain;
            this._outputAudioNode = this._soundGain;
            if (this.spatialSound) {
                this._createSpatialParameters();
            }
            this._scene.mainSoundTrack.AddSound(this);
            var validParameter = true;
            // if no parameter is passed, you need to call setAudioBuffer yourself to prepare the sound
            if (urlOrArrayBuffer) {
                try {
                    if (typeof (urlOrArrayBuffer) === "string") {
                        this._urlType = "String";
                    }
                    else if (urlOrArrayBuffer instanceof ArrayBuffer) {
                        this._urlType = "ArrayBuffer";
                    }
                    else if (urlOrArrayBuffer instanceof MediaStream) {
                        this._urlType = "MediaStream";
                    }
                    else if (Array.isArray(urlOrArrayBuffer)) {
                        this._urlType = "Array";
                    }
                    var urls = [];
                    var codecSupportedFound = false;
                    switch (this._urlType) {
                        case "MediaStream":
                            this._streaming = true;
                            this._isReadyToPlay = true;
                            this._streamingSource = _Engines_engine__WEBPACK_IMPORTED_MODULE_3__.Engine.audioEngine.audioContext.createMediaStreamSource(urlOrArrayBuffer);
                            if (this.autoplay) {
                                this.play(0, this._offset, this._length);
                            }
                            if (this._readyToPlayCallback) {
                                this._readyToPlayCallback();
                            }
                            break;
                        case "ArrayBuffer":
                            if (urlOrArrayBuffer.byteLength > 0) {
                                codecSupportedFound = true;
                                this._soundLoaded(urlOrArrayBuffer);
                            }
                            break;
                        case "String":
                            urls.push(urlOrArrayBuffer);
                        case "Array":
                            if (urls.length === 0) {
                                urls = urlOrArrayBuffer;
                            }
                            // If we found a supported format, we load it immediately and stop the loop
                            for (var i = 0; i < urls.length; i++) {
                                var url = urls[i];
                                codecSupportedFound = (options && options.skipCodecCheck) ||
                                    (url.indexOf(".mp3", url.length - 4) !== -1 && _Engines_engine__WEBPACK_IMPORTED_MODULE_3__.Engine.audioEngine.isMP3supported) ||
                                    (url.indexOf(".ogg", url.length - 4) !== -1 && _Engines_engine__WEBPACK_IMPORTED_MODULE_3__.Engine.audioEngine.isOGGsupported) ||
                                    (url.indexOf(".wav", url.length - 4) !== -1) ||
                                    (url.indexOf("blob:") !== -1);
                                if (codecSupportedFound) {
                                    // Loading sound using XHR2
                                    if (!this._streaming) {
                                        this._scene._loadFile(url, function (data) {
                                            _this._soundLoaded(data);
                                        }, undefined, true, true, function (exception) {
                                            if (exception) {
                                                _Misc_logger__WEBPACK_IMPORTED_MODULE_4__.Logger.Error("XHR " + exception.status + " error on: " + url + ".");
                                            }
                                            _Misc_logger__WEBPACK_IMPORTED_MODULE_4__.Logger.Error("Sound creation aborted.");
                                            _this._scene.mainSoundTrack.RemoveSound(_this);
                                        });
                                    }
                                    // Streaming sound using HTML5 Audio tag
                                    else {
                                        this._htmlAudioElement = new Audio(url);
                                        this._htmlAudioElement.controls = false;
                                        this._htmlAudioElement.loop = this.loop;
                                        _Misc_tools__WEBPACK_IMPORTED_MODULE_0__.Tools.SetCorsBehavior(url, this._htmlAudioElement);
                                        this._htmlAudioElement.preload = "auto";
                                        this._htmlAudioElement.addEventListener("canplaythrough", function () {
                                            _this._isReadyToPlay = true;
                                            if (_this.autoplay) {
                                                _this.play(0, _this._offset, _this._length);
                                            }
                                            if (_this._readyToPlayCallback) {
                                                _this._readyToPlayCallback();
                                            }
                                        });
                                        document.body.appendChild(this._htmlAudioElement);
                                        this._htmlAudioElement.load();
                                    }
                                    break;
                                }
                            }
                            break;
                        default:
                            validParameter = false;
                            break;
                    }
                    if (!validParameter) {
                        _Misc_logger__WEBPACK_IMPORTED_MODULE_4__.Logger.Error("Parameter must be a URL to the sound, an Array of URLs (.mp3 & .ogg) or an ArrayBuffer of the sound.");
                    }
                    else {
                        if (!codecSupportedFound) {
                            this._isReadyToPlay = true;
                            // Simulating a ready to play event to avoid breaking code path
                            if (this._readyToPlayCallback) {
                                window.setTimeout(function () {
                                    if (_this._readyToPlayCallback) {
                                        _this._readyToPlayCallback();
                                    }
                                }, 1000);
                            }
                        }
                    }
                }
                catch (ex) {
                    _Misc_logger__WEBPACK_IMPORTED_MODULE_4__.Logger.Error("Unexpected error. Sound creation aborted.");
                    this._scene.mainSoundTrack.RemoveSound(this);
                }
            }
        }
        else {
            // Adding an empty sound to avoid breaking audio calls for non Web Audio browsers
            this._scene.mainSoundTrack.AddSound(this);
            if (!_Engines_engine__WEBPACK_IMPORTED_MODULE_3__.Engine.audioEngine.WarnedWebAudioUnsupported) {
                _Misc_logger__WEBPACK_IMPORTED_MODULE_4__.Logger.Error("Web Audio is not supported by your browser.");
                _Engines_engine__WEBPACK_IMPORTED_MODULE_3__.Engine.audioEngine.WarnedWebAudioUnsupported = true;
            }
            // Simulating a ready to play event to avoid breaking code for non web audio browsers
            if (this._readyToPlayCallback) {
                window.setTimeout(function () {
                    if (_this._readyToPlayCallback) {
                        _this._readyToPlayCallback();
                    }
                }, 1000);
            }
        }
    }
    /**
     * Release the sound and its associated resources
     */
    Sound.prototype.dispose = function () {
        if (_Engines_engine__WEBPACK_IMPORTED_MODULE_3__.Engine.audioEngine.canUseWebAudio) {
            if (this.isPlaying) {
                this.stop();
            }
            this._isReadyToPlay = false;
            if (this.soundTrackId === -1) {
                this._scene.mainSoundTrack.RemoveSound(this);
            }
            else if (this._scene.soundTracks) {
                this._scene.soundTracks[this.soundTrackId].RemoveSound(this);
            }
            if (this._soundGain) {
                this._soundGain.disconnect();
                this._soundGain = null;
            }
            if (this._soundPanner) {
                this._soundPanner.disconnect();
                this._soundPanner = null;
            }
            if (this._soundSource) {
                this._soundSource.disconnect();
                this._soundSource = null;
            }
            this._audioBuffer = null;
            if (this._htmlAudioElement) {
                this._htmlAudioElement.pause();
                this._htmlAudioElement.src = "";
                document.body.removeChild(this._htmlAudioElement);
            }
            if (this._streamingSource) {
                this._streamingSource.disconnect();
            }
            if (this._connectedTransformNode && this._registerFunc) {
                this._connectedTransformNode.unregisterAfterWorldMatrixUpdate(this._registerFunc);
                this._connectedTransformNode = null;
            }
        }
    };
    /**
     * Gets if the sounds is ready to be played or not.
     * @returns true if ready, otherwise false
     */
    Sound.prototype.isReady = function () {
        return this._isReadyToPlay;
    };
    Sound.prototype._soundLoaded = function (audioData) {
        var _this = this;
        if (!_Engines_engine__WEBPACK_IMPORTED_MODULE_3__.Engine.audioEngine.audioContext) {
            return;
        }
        _Engines_engine__WEBPACK_IMPORTED_MODULE_3__.Engine.audioEngine.audioContext.decodeAudioData(audioData, function (buffer) {
            _this._audioBuffer = buffer;
            _this._isReadyToPlay = true;
            if (_this.autoplay) {
                _this.play(0, _this._offset, _this._length);
            }
            if (_this._readyToPlayCallback) {
                _this._readyToPlayCallback();
            }
        }, function (err) { _Misc_logger__WEBPACK_IMPORTED_MODULE_4__.Logger.Error("Error while decoding audio data for: " + _this.name + " / Error: " + err); });
    };
    /**
     * Sets the data of the sound from an audiobuffer
     * @param audioBuffer The audioBuffer containing the data
     */
    Sound.prototype.setAudioBuffer = function (audioBuffer) {
        if (_Engines_engine__WEBPACK_IMPORTED_MODULE_3__.Engine.audioEngine.canUseWebAudio) {
            this._audioBuffer = audioBuffer;
            this._isReadyToPlay = true;
        }
    };
    /**
     * Updates the current sounds options such as maxdistance, loop...
     * @param options A JSON object containing values named as the object properties
     */
    Sound.prototype.updateOptions = function (options) {
        if (options) {
            this.loop = options.loop || this.loop;
            this.maxDistance = options.maxDistance || this.maxDistance;
            this.useCustomAttenuation = options.useCustomAttenuation || this.useCustomAttenuation;
            this.rolloffFactor = options.rolloffFactor || this.rolloffFactor;
            this.refDistance = options.refDistance || this.refDistance;
            this.distanceModel = options.distanceModel || this.distanceModel;
            this._playbackRate = options.playbackRate || this._playbackRate;
            this._length = options.length ? options.length / 1000 : undefined;
            this._offset = options.offset ? options.offset / 1000 : undefined;
            this._updateSpatialParameters();
            if (this.isPlaying) {
                if (this._streaming && this._htmlAudioElement) {
                    this._htmlAudioElement.playbackRate = this._playbackRate;
                }
                else {
                    if (this._soundSource) {
                        this._soundSource.playbackRate.value = this._playbackRate;
                    }
                }
            }
        }
    };
    Sound.prototype._createSpatialParameters = function () {
        if (_Engines_engine__WEBPACK_IMPORTED_MODULE_3__.Engine.audioEngine.canUseWebAudio && _Engines_engine__WEBPACK_IMPORTED_MODULE_3__.Engine.audioEngine.audioContext) {
            if (this._scene.headphone) {
                this._panningModel = "HRTF";
            }
            this._soundPanner = _Engines_engine__WEBPACK_IMPORTED_MODULE_3__.Engine.audioEngine.audioContext.createPanner();
            this._updateSpatialParameters();
            this._soundPanner.connect(this._outputAudioNode);
            this._inputAudioNode = this._soundPanner;
        }
    };
    Sound.prototype._updateSpatialParameters = function () {
        if (this.spatialSound && this._soundPanner) {
            if (this.useCustomAttenuation) {
                // Tricks to disable in a way embedded Web Audio attenuation
                this._soundPanner.distanceModel = "linear";
                this._soundPanner.maxDistance = Number.MAX_VALUE;
                this._soundPanner.refDistance = 1;
                this._soundPanner.rolloffFactor = 1;
                this._soundPanner.panningModel = this._panningModel;
            }
            else {
                this._soundPanner.distanceModel = this.distanceModel;
                this._soundPanner.maxDistance = this.maxDistance;
                this._soundPanner.refDistance = this.refDistance;
                this._soundPanner.rolloffFactor = this.rolloffFactor;
                this._soundPanner.panningModel = this._panningModel;
            }
        }
    };
    /**
     * Switch the panning model to HRTF:
     * Renders a stereo output of higher quality than equalpower — it uses a convolution with measured impulse responses from human subjects.
     * @see http://doc.babylonjs.com/how_to/playing_sounds_and_music#creating-a-spatial-3d-sound
     */
    Sound.prototype.switchPanningModelToHRTF = function () {
        this._panningModel = "HRTF";
        this._switchPanningModel();
    };
    /**
     * Switch the panning model to Equal Power:
     * Represents the equal-power panning algorithm, generally regarded as simple and efficient. equalpower is the default value.
     * @see http://doc.babylonjs.com/how_to/playing_sounds_and_music#creating-a-spatial-3d-sound
     */
    Sound.prototype.switchPanningModelToEqualPower = function () {
        this._panningModel = "equalpower";
        this._switchPanningModel();
    };
    Sound.prototype._switchPanningModel = function () {
        if (_Engines_engine__WEBPACK_IMPORTED_MODULE_3__.Engine.audioEngine.canUseWebAudio && this.spatialSound && this._soundPanner) {
            this._soundPanner.panningModel = this._panningModel;
        }
    };
    /**
     * Connect this sound to a sound track audio node like gain...
     * @param soundTrackAudioNode the sound track audio node to connect to
     */
    Sound.prototype.connectToSoundTrackAudioNode = function (soundTrackAudioNode) {
        if (_Engines_engine__WEBPACK_IMPORTED_MODULE_3__.Engine.audioEngine.canUseWebAudio) {
            if (this._isOutputConnected) {
                this._outputAudioNode.disconnect();
            }
            this._outputAudioNode.connect(soundTrackAudioNode);
            this._isOutputConnected = true;
        }
    };
    /**
    * Transform this sound into a directional source
    * @param coneInnerAngle Size of the inner cone in degree
    * @param coneOuterAngle Size of the outer cone in degree
    * @param coneOuterGain Volume of the sound outside the outer cone (between 0.0 and 1.0)
    */
    Sound.prototype.setDirectionalCone = function (coneInnerAngle, coneOuterAngle, coneOuterGain) {
        if (coneOuterAngle < coneInnerAngle) {
            _Misc_logger__WEBPACK_IMPORTED_MODULE_4__.Logger.Error("setDirectionalCone(): outer angle of the cone must be superior or equal to the inner angle.");
            return;
        }
        this._coneInnerAngle = coneInnerAngle;
        this._coneOuterAngle = coneOuterAngle;
        this._coneOuterGain = coneOuterGain;
        this._isDirectional = true;
        if (this.isPlaying && this.loop) {
            this.stop();
            this.play(0, this._offset, this._length);
        }
    };
    Object.defineProperty(Sound.prototype, "directionalConeInnerAngle", {
        /**
         * Gets or sets the inner angle for the directional cone.
         */
        get: function () {
            return this._coneInnerAngle;
        },
        /**
         * Gets or sets the inner angle for the directional cone.
         */
        set: function (value) {
            if (value != this._coneInnerAngle) {
                if (this._coneOuterAngle < value) {
                    _Misc_logger__WEBPACK_IMPORTED_MODULE_4__.Logger.Error("directionalConeInnerAngle: outer angle of the cone must be superior or equal to the inner angle.");
                    return;
                }
                this._coneInnerAngle = value;
                if (_Engines_engine__WEBPACK_IMPORTED_MODULE_3__.Engine.audioEngine.canUseWebAudio && this.spatialSound && this._soundPanner) {
                    this._soundPanner.coneInnerAngle = this._coneInnerAngle;
                }
            }
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(Sound.prototype, "directionalConeOuterAngle", {
        /**
         * Gets or sets the outer angle for the directional cone.
         */
        get: function () {
            return this._coneOuterAngle;
        },
        /**
         * Gets or sets the outer angle for the directional cone.
         */
        set: function (value) {
            if (value != this._coneOuterAngle) {
                if (value < this._coneInnerAngle) {
                    _Misc_logger__WEBPACK_IMPORTED_MODULE_4__.Logger.Error("directionalConeOuterAngle: outer angle of the cone must be superior or equal to the inner angle.");
                    return;
                }
                this._coneOuterAngle = value;
                if (_Engines_engine__WEBPACK_IMPORTED_MODULE_3__.Engine.audioEngine.canUseWebAudio && this.spatialSound && this._soundPanner) {
                    this._soundPanner.coneOuterAngle = this._coneOuterAngle;
                }
            }
        },
        enumerable: true,
        configurable: true
    });
    /**
     * Sets the position of the emitter if spatial sound is enabled
     * @param newPosition Defines the new posisiton
     */
    Sound.prototype.setPosition = function (newPosition) {
        this._position = newPosition;
        if (_Engines_engine__WEBPACK_IMPORTED_MODULE_3__.Engine.audioEngine.canUseWebAudio && this.spatialSound && this._soundPanner && !isNaN(this._position.x) && !isNaN(this._position.y) && !isNaN(this._position.z)) {
            this._soundPanner.setPosition(this._position.x, this._position.y, this._position.z);
        }
    };
    /**
     * Sets the local direction of the emitter if spatial sound is enabled
     * @param newLocalDirection Defines the new local direction
     */
    Sound.prototype.setLocalDirectionToMesh = function (newLocalDirection) {
        this._localDirection = newLocalDirection;
        if (_Engines_engine__WEBPACK_IMPORTED_MODULE_3__.Engine.audioEngine.canUseWebAudio && this._connectedTransformNode && this.isPlaying) {
            this._updateDirection();
        }
    };
    Sound.prototype._updateDirection = function () {
        if (!this._connectedTransformNode || !this._soundPanner) {
            return;
        }
        var mat = this._connectedTransformNode.getWorldMatrix();
        var direction = _Maths_math_vector__WEBPACK_IMPORTED_MODULE_2__.Vector3.TransformNormal(this._localDirection, mat);
        direction.normalize();
        this._soundPanner.setOrientation(direction.x, direction.y, direction.z);
    };
    /** @hidden */
    Sound.prototype.updateDistanceFromListener = function () {
        if (_Engines_engine__WEBPACK_IMPORTED_MODULE_3__.Engine.audioEngine.canUseWebAudio && this._connectedTransformNode && this.useCustomAttenuation && this._soundGain && this._scene.activeCamera) {
            var distance = this._connectedTransformNode.getDistanceToCamera(this._scene.activeCamera);
            this._soundGain.gain.value = this._customAttenuationFunction(this._volume, distance, this.maxDistance, this.refDistance, this.rolloffFactor);
        }
    };
    /**
     * Sets a new custom attenuation function for the sound.
     * @param callback Defines the function used for the attenuation
     * @see http://doc.babylonjs.com/how_to/playing_sounds_and_music#creating-your-own-custom-attenuation-function
     */
    Sound.prototype.setAttenuationFunction = function (callback) {
        this._customAttenuationFunction = callback;
    };
    /**
    * Play the sound
    * @param time (optional) Start the sound after X seconds. Start immediately (0) by default.
    * @param offset (optional) Start the sound at a specific time in seconds
    * @param length (optional) Sound duration (in seconds)
    */
    Sound.prototype.play = function (time, offset, length) {
        var _this = this;
        if (this._isReadyToPlay && this._scene.audioEnabled && _Engines_engine__WEBPACK_IMPORTED_MODULE_3__.Engine.audioEngine.audioContext) {
            try {
                if (this._startOffset < 0) {
                    time = -this._startOffset;
                    this._startOffset = 0;
                }
                var startTime = time ? _Engines_engine__WEBPACK_IMPORTED_MODULE_3__.Engine.audioEngine.audioContext.currentTime + time : _Engines_engine__WEBPACK_IMPORTED_MODULE_3__.Engine.audioEngine.audioContext.currentTime;
                if (!this._soundSource || !this._streamingSource) {
                    if (this.spatialSound && this._soundPanner) {
                        if (!isNaN(this._position.x) && !isNaN(this._position.y) && !isNaN(this._position.z)) {
                            this._soundPanner.setPosition(this._position.x, this._position.y, this._position.z);
                        }
                        if (this._isDirectional) {
                            this._soundPanner.coneInnerAngle = this._coneInnerAngle;
                            this._soundPanner.coneOuterAngle = this._coneOuterAngle;
                            this._soundPanner.coneOuterGain = this._coneOuterGain;
                            if (this._connectedTransformNode) {
                                this._updateDirection();
                            }
                            else {
                                this._soundPanner.setOrientation(this._localDirection.x, this._localDirection.y, this._localDirection.z);
                            }
                        }
                    }
                }
                if (this._streaming) {
                    if (!this._streamingSource) {
                        this._streamingSource = _Engines_engine__WEBPACK_IMPORTED_MODULE_3__.Engine.audioEngine.audioContext.createMediaElementSource(this._htmlAudioElement);
                        this._htmlAudioElement.onended = function () { _this._onended(); };
                        this._htmlAudioElement.playbackRate = this._playbackRate;
                    }
                    this._streamingSource.disconnect();
                    this._streamingSource.connect(this._inputAudioNode);
                    if (this._htmlAudioElement) {
                        // required to manage properly the new suspended default state of Chrome
                        // When the option 'streaming: true' is used, we need first to wait for
                        // the audio engine to be unlocked by a user gesture before trying to play
                        // an HTML Audio elememt
                        var tryToPlay = function () {
                            if (_Engines_engine__WEBPACK_IMPORTED_MODULE_3__.Engine.audioEngine.unlocked) {
                                var playPromise = _this._htmlAudioElement.play();
                                // In browsers that don’t yet support this functionality,
                                // playPromise won’t be defined.
                                if (playPromise !== undefined) {
                                    playPromise.catch(function (error) {
                                        // Automatic playback failed.
                                        // Waiting for the audio engine to be unlocked by user click on unmute
                                        _Engines_engine__WEBPACK_IMPORTED_MODULE_3__.Engine.audioEngine.lock();
                                        if (_this.loop || _this.autoplay) {
                                            _Engines_engine__WEBPACK_IMPORTED_MODULE_3__.Engine.audioEngine.onAudioUnlockedObservable.addOnce(function () { tryToPlay(); });
                                        }
                                    });
                                }
                            }
                            else {
                                if (_this.loop || _this.autoplay) {
                                    _Engines_engine__WEBPACK_IMPORTED_MODULE_3__.Engine.audioEngine.onAudioUnlockedObservable.addOnce(function () { tryToPlay(); });
                                }
                            }
                        };
                        tryToPlay();
                    }
                }
                else {
                    var tryToPlay = function () {
                        if (_Engines_engine__WEBPACK_IMPORTED_MODULE_3__.Engine.audioEngine.audioContext) {
                            length = length || _this._length;
                            offset = offset || _this._offset;
                            _this._soundSource = _Engines_engine__WEBPACK_IMPORTED_MODULE_3__.Engine.audioEngine.audioContext.createBufferSource();
                            _this._soundSource.buffer = _this._audioBuffer;
                            _this._soundSource.connect(_this._inputAudioNode);
                            _this._soundSource.loop = _this.loop;
                            if (offset !== undefined) {
                                _this._soundSource.loopStart = offset;
                            }
                            if (length !== undefined) {
                                _this._soundSource.loopEnd = (offset | 0) + length;
                            }
                            _this._soundSource.playbackRate.value = _this._playbackRate;
                            _this._soundSource.onended = function () { _this._onended(); };
                            startTime = time ? _Engines_engine__WEBPACK_IMPORTED_MODULE_3__.Engine.audioEngine.audioContext.currentTime + time : _Engines_engine__WEBPACK_IMPORTED_MODULE_3__.Engine.audioEngine.audioContext.currentTime;
                            var actualOffset = _this.isPaused ? _this._startOffset % _this._soundSource.buffer.duration : offset ? offset : 0;
                            _this._soundSource.start(startTime, actualOffset, _this.loop ? undefined : length);
                        }
                    };
                    if (_Engines_engine__WEBPACK_IMPORTED_MODULE_3__.Engine.audioEngine.audioContext.state === "suspended") {
                        // Wait a bit for FF as context seems late to be ready.
                        setTimeout(function () {
                            if (_Engines_engine__WEBPACK_IMPORTED_MODULE_3__.Engine.audioEngine.audioContext.state === "suspended") {
                                // Automatic playback failed.
                                // Waiting for the audio engine to be unlocked by user click on unmute
                                _Engines_engine__WEBPACK_IMPORTED_MODULE_3__.Engine.audioEngine.lock();
                                if (_this.loop || _this.autoplay) {
                                    _Engines_engine__WEBPACK_IMPORTED_MODULE_3__.Engine.audioEngine.onAudioUnlockedObservable.addOnce(function () { tryToPlay(); });
                                }
                            }
                            else {
                                tryToPlay();
                            }
                        }, 500);
                    }
                    else {
                        tryToPlay();
                    }
                }
                this._startTime = startTime;
                this.isPlaying = true;
                this.isPaused = false;
            }
            catch (ex) {
                _Misc_logger__WEBPACK_IMPORTED_MODULE_4__.Logger.Error("Error while trying to play audio: " + this.name + ", " + ex.message);
            }
        }
    };
    Sound.prototype._onended = function () {
        this.isPlaying = false;
        if (this.onended) {
            this.onended();
        }
        this.onEndedObservable.notifyObservers(this);
    };
    /**
    * Stop the sound
    * @param time (optional) Stop the sound after X seconds. Stop immediately (0) by default.
    */
    Sound.prototype.stop = function (time) {
        var _this = this;
        if (this.isPlaying) {
            if (this._streaming) {
                if (this._htmlAudioElement) {
                    this._htmlAudioElement.pause();
                    // Test needed for Firefox or it will generate an Invalid State Error
                    if (this._htmlAudioElement.currentTime > 0) {
                        this._htmlAudioElement.currentTime = 0;
                    }
                }
                else {
                    this._streamingSource.disconnect();
                }
                this.isPlaying = false;
            }
            else if (_Engines_engine__WEBPACK_IMPORTED_MODULE_3__.Engine.audioEngine.audioContext && this._soundSource) {
                var stopTime = time ? _Engines_engine__WEBPACK_IMPORTED_MODULE_3__.Engine.audioEngine.audioContext.currentTime + time : _Engines_engine__WEBPACK_IMPORTED_MODULE_3__.Engine.audioEngine.audioContext.currentTime;
                this._soundSource.stop(stopTime);
                this._soundSource.onended = function () { _this.isPlaying = false; };
                if (!this.isPaused) {
                    this._startOffset = 0;
                }
            }
        }
    };
    /**
     * Put the sound in pause
     */
    Sound.prototype.pause = function () {
        if (this.isPlaying) {
            this.isPaused = true;
            if (this._streaming) {
                if (this._htmlAudioElement) {
                    this._htmlAudioElement.pause();
                }
                else {
                    this._streamingSource.disconnect();
                }
            }
            else if (_Engines_engine__WEBPACK_IMPORTED_MODULE_3__.Engine.audioEngine.audioContext) {
                this.stop(0);
                this._startOffset += _Engines_engine__WEBPACK_IMPORTED_MODULE_3__.Engine.audioEngine.audioContext.currentTime - this._startTime;
            }
        }
    };
    /**
     * Sets a dedicated volume for this sounds
     * @param newVolume Define the new volume of the sound
     * @param time Define time for gradual change to new volume
     */
    Sound.prototype.setVolume = function (newVolume, time) {
        if (_Engines_engine__WEBPACK_IMPORTED_MODULE_3__.Engine.audioEngine.canUseWebAudio && this._soundGain) {
            if (time && _Engines_engine__WEBPACK_IMPORTED_MODULE_3__.Engine.audioEngine.audioContext) {
                this._soundGain.gain.cancelScheduledValues(_Engines_engine__WEBPACK_IMPORTED_MODULE_3__.Engine.audioEngine.audioContext.currentTime);
                this._soundGain.gain.setValueAtTime(this._soundGain.gain.value, _Engines_engine__WEBPACK_IMPORTED_MODULE_3__.Engine.audioEngine.audioContext.currentTime);
                this._soundGain.gain.linearRampToValueAtTime(newVolume, _Engines_engine__WEBPACK_IMPORTED_MODULE_3__.Engine.audioEngine.audioContext.currentTime + time);
            }
            else {
                this._soundGain.gain.value = newVolume;
            }
        }
        this._volume = newVolume;
    };
    /**
     * Set the sound play back rate
     * @param newPlaybackRate Define the playback rate the sound should be played at
     */
    Sound.prototype.setPlaybackRate = function (newPlaybackRate) {
        this._playbackRate = newPlaybackRate;
        if (this.isPlaying) {
            if (this._streaming && this._htmlAudioElement) {
                this._htmlAudioElement.playbackRate = this._playbackRate;
            }
            else if (this._soundSource) {
                this._soundSource.playbackRate.value = this._playbackRate;
            }
        }
    };
    /**
     * Gets the volume of the sound.
     * @returns the volume of the sound
     */
    Sound.prototype.getVolume = function () {
        return this._volume;
    };
    /**
     * Attach the sound to a dedicated mesh
     * @param transformNode The transform node to connect the sound with
     * @see http://doc.babylonjs.com/how_to/playing_sounds_and_music#attaching-a-sound-to-a-mesh
     */
    Sound.prototype.attachToMesh = function (transformNode) {
        var _this = this;
        if (this._connectedTransformNode && this._registerFunc) {
            this._connectedTransformNode.unregisterAfterWorldMatrixUpdate(this._registerFunc);
            this._registerFunc = null;
        }
        this._connectedTransformNode = transformNode;
        if (!this.spatialSound) {
            this.spatialSound = true;
            this._createSpatialParameters();
            if (this.isPlaying && this.loop) {
                this.stop();
                this.play(0, this._offset, this._length);
            }
        }
        this._onRegisterAfterWorldMatrixUpdate(this._connectedTransformNode);
        this._registerFunc = function (transformNode) { return _this._onRegisterAfterWorldMatrixUpdate(transformNode); };
        this._connectedTransformNode.registerAfterWorldMatrixUpdate(this._registerFunc);
    };
    /**
     * Detach the sound from the previously attached mesh
     * @see http://doc.babylonjs.com/how_to/playing_sounds_and_music#attaching-a-sound-to-a-mesh
     */
    Sound.prototype.detachFromMesh = function () {
        if (this._connectedTransformNode && this._registerFunc) {
            this._connectedTransformNode.unregisterAfterWorldMatrixUpdate(this._registerFunc);
            this._registerFunc = null;
            this._connectedTransformNode = null;
        }
    };
    Sound.prototype._onRegisterAfterWorldMatrixUpdate = function (node) {
        if (!node.getBoundingInfo) {
            return;
        }
        var mesh = node;
        if (this._positionInEmitterSpace) {
            mesh.worldMatrixFromCache.invertToRef(_Maths_math_vector__WEBPACK_IMPORTED_MODULE_2__.TmpVectors.Matrix[0]);
            this.setPosition(_Maths_math_vector__WEBPACK_IMPORTED_MODULE_2__.TmpVectors.Matrix[0].getTranslation());
        }
        else {
            var boundingInfo = mesh.getBoundingInfo();
            this.setPosition(boundingInfo.boundingSphere.centerWorld);
        }
        if (_Engines_engine__WEBPACK_IMPORTED_MODULE_3__.Engine.audioEngine.canUseWebAudio && this._isDirectional && this.isPlaying) {
            this._updateDirection();
        }
    };
    /**
     * Clone the current sound in the scene.
     * @returns the new sound clone
     */
    Sound.prototype.clone = function () {
        var _this = this;
        if (!this._streaming) {
            var setBufferAndRun = function () {
                if (_this._isReadyToPlay) {
                    clonedSound._audioBuffer = _this.getAudioBuffer();
                    clonedSound._isReadyToPlay = true;
                    if (clonedSound.autoplay) {
                        clonedSound.play(0, _this._offset, _this._length);
                    }
                }
                else {
                    window.setTimeout(setBufferAndRun, 300);
                }
            };
            var currentOptions = {
                autoplay: this.autoplay, loop: this.loop,
                volume: this._volume, spatialSound: this.spatialSound, maxDistance: this.maxDistance,
                useCustomAttenuation: this.useCustomAttenuation, rolloffFactor: this.rolloffFactor,
                refDistance: this.refDistance, distanceModel: this.distanceModel
            };
            var clonedSound = new Sound(this.name + "_cloned", new ArrayBuffer(0), this._scene, null, currentOptions);
            if (this.useCustomAttenuation) {
                clonedSound.setAttenuationFunction(this._customAttenuationFunction);
            }
            clonedSound.setPosition(this._position);
            clonedSound.setPlaybackRate(this._playbackRate);
            setBufferAndRun();
            return clonedSound;
        }
        // Can't clone a streaming sound
        else {
            return null;
        }
    };
    /**
     * Gets the current underlying audio buffer containing the data
     * @returns the audio buffer
     */
    Sound.prototype.getAudioBuffer = function () {
        return this._audioBuffer;
    };
    /**
     * Serializes the Sound in a JSON representation
     * @returns the JSON representation of the sound
     */
    Sound.prototype.serialize = function () {
        var serializationObject = {
            name: this.name,
            url: this.name,
            autoplay: this.autoplay,
            loop: this.loop,
            volume: this._volume,
            spatialSound: this.spatialSound,
            maxDistance: this.maxDistance,
            rolloffFactor: this.rolloffFactor,
            refDistance: this.refDistance,
            distanceModel: this.distanceModel,
            playbackRate: this._playbackRate,
            panningModel: this._panningModel,
            soundTrackId: this.soundTrackId
        };
        if (this.spatialSound) {
            if (this._connectedTransformNode) {
                serializationObject.connectedMeshId = this._connectedTransformNode.id;
            }
            serializationObject.position = this._position.asArray();
            serializationObject.refDistance = this.refDistance;
            serializationObject.distanceModel = this.distanceModel;
            serializationObject.isDirectional = this._isDirectional;
            serializationObject.localDirectionToMesh = this._localDirection.asArray();
            serializationObject.coneInnerAngle = this._coneInnerAngle;
            serializationObject.coneOuterAngle = this._coneOuterAngle;
            serializationObject.coneOuterGain = this._coneOuterGain;
        }
        return serializationObject;
    };
    /**
     * Parse a JSON representation of a sound to innstantiate in a given scene
     * @param parsedSound Define the JSON representation of the sound (usually coming from the serialize method)
     * @param scene Define the scene the new parsed sound should be created in
     * @param rootUrl Define the rooturl of the load in case we need to fetch relative dependencies
     * @param sourceSound Define a cound place holder if do not need to instantiate a new one
     * @returns the newly parsed sound
     */
    Sound.Parse = function (parsedSound, scene, rootUrl, sourceSound) {
        var soundName = parsedSound.name;
        var soundUrl;
        if (parsedSound.url) {
            soundUrl = rootUrl + parsedSound.url;
        }
        else {
            soundUrl = rootUrl + soundName;
        }
        var options = {
            autoplay: parsedSound.autoplay, loop: parsedSound.loop, volume: parsedSound.volume,
            spatialSound: parsedSound.spatialSound, maxDistance: parsedSound.maxDistance,
            rolloffFactor: parsedSound.rolloffFactor,
            refDistance: parsedSound.refDistance,
            distanceModel: parsedSound.distanceModel,
            playbackRate: parsedSound.playbackRate
        };
        var newSound;
        if (!sourceSound) {
            newSound = new Sound(soundName, soundUrl, scene, function () { scene._removePendingData(newSound); }, options);
            scene._addPendingData(newSound);
        }
        else {
            var setBufferAndRun = function () {
                if (sourceSound._isReadyToPlay) {
                    newSound._audioBuffer = sourceSound.getAudioBuffer();
                    newSound._isReadyToPlay = true;
                    if (newSound.autoplay) {
                        newSound.play(0, newSound._offset, newSound._length);
                    }
                }
                else {
                    window.setTimeout(setBufferAndRun, 300);
                }
            };
            newSound = new Sound(soundName, new ArrayBuffer(0), scene, null, options);
            setBufferAndRun();
        }
        if (parsedSound.position) {
            var soundPosition = _Maths_math_vector__WEBPACK_IMPORTED_MODULE_2__.Vector3.FromArray(parsedSound.position);
            newSound.setPosition(soundPosition);
        }
        if (parsedSound.isDirectional) {
            newSound.setDirectionalCone(parsedSound.coneInnerAngle || 360, parsedSound.coneOuterAngle || 360, parsedSound.coneOuterGain || 0);
            if (parsedSound.localDirectionToMesh) {
                var localDirectionToMesh = _Maths_math_vector__WEBPACK_IMPORTED_MODULE_2__.Vector3.FromArray(parsedSound.localDirectionToMesh);
                newSound.setLocalDirectionToMesh(localDirectionToMesh);
            }
        }
        if (parsedSound.connectedMeshId) {
            var connectedMesh = scene.getMeshByID(parsedSound.connectedMeshId);
            if (connectedMesh) {
                newSound.attachToMesh(connectedMesh);
            }
        }
        return newSound;
    };
    /** @hidden */
    Sound._SceneComponentInitialization = function (_) {
        throw _Misc_devTools__WEBPACK_IMPORTED_MODULE_5__._DevTools.WarnImport("AudioSceneComponent");
    };
    return Sound;
}());

//# sourceMappingURL=sound.js.map

/***/ }),

/***/ "./node_modules/@babylonjs/core/Audio/soundTrack.js":
/*!**********************************************************!*\
  !*** ./node_modules/@babylonjs/core/Audio/soundTrack.js ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "SoundTrack": () => (/* binding */ SoundTrack)
/* harmony export */ });
/* harmony import */ var _Engines_engine__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../Engines/engine */ "./node_modules/@babylonjs/core/Engines/engine.js");

/**
 * It could be useful to isolate your music & sounds on several tracks to better manage volume on a grouped instance of sounds.
 * It will be also used in a future release to apply effects on a specific track.
 * @see http://doc.babylonjs.com/how_to/playing_sounds_and_music#using-sound-tracks
 */
var SoundTrack = /** @class */ (function () {
    /**
     * Creates a new sound track.
     * @see http://doc.babylonjs.com/how_to/playing_sounds_and_music#using-sound-tracks
     * @param scene Define the scene the sound track belongs to
     * @param options
     */
    function SoundTrack(scene, options) {
        if (options === void 0) { options = {}; }
        /**
         * The unique identifier of the sound track in the scene.
         */
        this.id = -1;
        this._isInitialized = false;
        this._scene = scene;
        this.soundCollection = new Array();
        this._options = options;
        if (!this._options.mainTrack && this._scene.soundTracks) {
            this._scene.soundTracks.push(this);
            this.id = this._scene.soundTracks.length - 1;
        }
    }
    SoundTrack.prototype._initializeSoundTrackAudioGraph = function () {
        if (_Engines_engine__WEBPACK_IMPORTED_MODULE_0__.Engine.audioEngine.canUseWebAudio && _Engines_engine__WEBPACK_IMPORTED_MODULE_0__.Engine.audioEngine.audioContext) {
            this._outputAudioNode = _Engines_engine__WEBPACK_IMPORTED_MODULE_0__.Engine.audioEngine.audioContext.createGain();
            this._outputAudioNode.connect(_Engines_engine__WEBPACK_IMPORTED_MODULE_0__.Engine.audioEngine.masterGain);
            if (this._options) {
                if (this._options.volume) {
                    this._outputAudioNode.gain.value = this._options.volume;
                }
            }
            this._isInitialized = true;
        }
    };
    /**
     * Release the sound track and its associated resources
     */
    SoundTrack.prototype.dispose = function () {
        if (_Engines_engine__WEBPACK_IMPORTED_MODULE_0__.Engine.audioEngine && _Engines_engine__WEBPACK_IMPORTED_MODULE_0__.Engine.audioEngine.canUseWebAudio) {
            if (this._connectedAnalyser) {
                this._connectedAnalyser.stopDebugCanvas();
            }
            while (this.soundCollection.length) {
                this.soundCollection[0].dispose();
            }
            if (this._outputAudioNode) {
                this._outputAudioNode.disconnect();
            }
            this._outputAudioNode = null;
        }
    };
    /**
     * Adds a sound to this sound track
     * @param sound define the cound to add
     * @ignoreNaming
     */
    SoundTrack.prototype.AddSound = function (sound) {
        if (!this._isInitialized) {
            this._initializeSoundTrackAudioGraph();
        }
        if (_Engines_engine__WEBPACK_IMPORTED_MODULE_0__.Engine.audioEngine.canUseWebAudio && this._outputAudioNode) {
            sound.connectToSoundTrackAudioNode(this._outputAudioNode);
        }
        if (sound.soundTrackId) {
            if (sound.soundTrackId === -1) {
                this._scene.mainSoundTrack.RemoveSound(sound);
            }
            else if (this._scene.soundTracks) {
                this._scene.soundTracks[sound.soundTrackId].RemoveSound(sound);
            }
        }
        this.soundCollection.push(sound);
        sound.soundTrackId = this.id;
    };
    /**
     * Removes a sound to this sound track
     * @param sound define the cound to remove
     * @ignoreNaming
     */
    SoundTrack.prototype.RemoveSound = function (sound) {
        var index = this.soundCollection.indexOf(sound);
        if (index !== -1) {
            this.soundCollection.splice(index, 1);
        }
    };
    /**
     * Set a global volume for the full sound track.
     * @param newVolume Define the new volume of the sound track
     */
    SoundTrack.prototype.setVolume = function (newVolume) {
        if (_Engines_engine__WEBPACK_IMPORTED_MODULE_0__.Engine.audioEngine.canUseWebAudio && this._outputAudioNode) {
            this._outputAudioNode.gain.value = newVolume;
        }
    };
    /**
     * Switch the panning model to HRTF:
     * Renders a stereo output of higher quality than equalpower — it uses a convolution with measured impulse responses from human subjects.
     * @see http://doc.babylonjs.com/how_to/playing_sounds_and_music#creating-a-spatial-3d-sound
     */
    SoundTrack.prototype.switchPanningModelToHRTF = function () {
        if (_Engines_engine__WEBPACK_IMPORTED_MODULE_0__.Engine.audioEngine.canUseWebAudio) {
            for (var i = 0; i < this.soundCollection.length; i++) {
                this.soundCollection[i].switchPanningModelToHRTF();
            }
        }
    };
    /**
     * Switch the panning model to Equal Power:
     * Represents the equal-power panning algorithm, generally regarded as simple and efficient. equalpower is the default value.
     * @see http://doc.babylonjs.com/how_to/playing_sounds_and_music#creating-a-spatial-3d-sound
     */
    SoundTrack.prototype.switchPanningModelToEqualPower = function () {
        if (_Engines_engine__WEBPACK_IMPORTED_MODULE_0__.Engine.audioEngine.canUseWebAudio) {
            for (var i = 0; i < this.soundCollection.length; i++) {
                this.soundCollection[i].switchPanningModelToEqualPower();
            }
        }
    };
    /**
     * Connect the sound track to an audio analyser allowing some amazing
     * synchornization between the sounds/music and your visualization (VuMeter for instance).
     * @see http://doc.babylonjs.com/how_to/playing_sounds_and_music#using-the-analyser
     * @param analyser The analyser to connect to the engine
     */
    SoundTrack.prototype.connectToAnalyser = function (analyser) {
        if (this._connectedAnalyser) {
            this._connectedAnalyser.stopDebugCanvas();
        }
        this._connectedAnalyser = analyser;
        if (_Engines_engine__WEBPACK_IMPORTED_MODULE_0__.Engine.audioEngine.canUseWebAudio && this._outputAudioNode) {
            this._outputAudioNode.disconnect();
            this._connectedAnalyser.connectAudioNodes(this._outputAudioNode, _Engines_engine__WEBPACK_IMPORTED_MODULE_0__.Engine.audioEngine.masterGain);
        }
    };
    return SoundTrack;
}());

//# sourceMappingURL=soundTrack.js.map

/***/ }),

/***/ "./node_modules/@babylonjs/core/Audio/weightedsound.js":
/*!*************************************************************!*\
  !*** ./node_modules/@babylonjs/core/Audio/weightedsound.js ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "WeightedSound": () => (/* binding */ WeightedSound)
/* harmony export */ });
/* harmony import */ var _Misc_logger__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../Misc/logger */ "./node_modules/@babylonjs/core/Misc/logger.js");

/**
 * Wraps one or more Sound objects and selects one with random weight for playback.
 */
var WeightedSound = /** @class */ (function () {
    /**
     * Creates a new WeightedSound from the list of sounds given.
     * @param loop When true a Sound will be selected and played when the current playing Sound completes.
     * @param sounds Array of Sounds that will be selected from.
     * @param weights Array of number values for selection weights; length must equal sounds, values will be normalized to 1
     */
    function WeightedSound(loop, sounds, weights) {
        var _this = this;
        /** When true a Sound will be selected and played when the current playing Sound completes. */
        this.loop = false;
        this._coneInnerAngle = 360;
        this._coneOuterAngle = 360;
        this._volume = 1;
        /** A Sound is currently playing. */
        this.isPlaying = false;
        /** A Sound is currently paused. */
        this.isPaused = false;
        this._sounds = [];
        this._weights = [];
        if (sounds.length !== weights.length) {
            throw new Error('Sounds length does not equal weights length');
        }
        this.loop = loop;
        this._weights = weights;
        // Normalize the weights
        var weightSum = 0;
        for (var _i = 0, weights_1 = weights; _i < weights_1.length; _i++) {
            var weight = weights_1[_i];
            weightSum += weight;
        }
        var invWeightSum = weightSum > 0 ? 1 / weightSum : 0;
        for (var i = 0; i < this._weights.length; i++) {
            this._weights[i] *= invWeightSum;
        }
        this._sounds = sounds;
        for (var _a = 0, _b = this._sounds; _a < _b.length; _a++) {
            var sound = _b[_a];
            sound.onEndedObservable.add(function () { _this._onended(); });
        }
    }
    Object.defineProperty(WeightedSound.prototype, "directionalConeInnerAngle", {
        /**
         * The size of cone in degrees for a directional sound in which there will be no attenuation.
         */
        get: function () {
            return this._coneInnerAngle;
        },
        /**
         * The size of cone in degress for a directional sound in which there will be no attenuation.
         */
        set: function (value) {
            if (value !== this._coneInnerAngle) {
                if (this._coneOuterAngle < value) {
                    _Misc_logger__WEBPACK_IMPORTED_MODULE_0__.Logger.Error("directionalConeInnerAngle: outer angle of the cone must be superior or equal to the inner angle.");
                    return;
                }
                this._coneInnerAngle = value;
                for (var _i = 0, _a = this._sounds; _i < _a.length; _i++) {
                    var sound = _a[_i];
                    sound.directionalConeInnerAngle = value;
                }
            }
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(WeightedSound.prototype, "directionalConeOuterAngle", {
        /**
         * Size of cone in degrees for a directional sound outside of which there will be no sound.
         * Listener angles between innerAngle and outerAngle will falloff linearly.
         */
        get: function () {
            return this._coneOuterAngle;
        },
        /**
         * Size of cone in degrees for a directional sound outside of which there will be no sound.
         * Listener angles between innerAngle and outerAngle will falloff linearly.
         */
        set: function (value) {
            if (value !== this._coneOuterAngle) {
                if (value < this._coneInnerAngle) {
                    _Misc_logger__WEBPACK_IMPORTED_MODULE_0__.Logger.Error("directionalConeOuterAngle: outer angle of the cone must be superior or equal to the inner angle.");
                    return;
                }
                this._coneOuterAngle = value;
                for (var _i = 0, _a = this._sounds; _i < _a.length; _i++) {
                    var sound = _a[_i];
                    sound.directionalConeOuterAngle = value;
                }
            }
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(WeightedSound.prototype, "volume", {
        /**
         * Playback volume.
         */
        get: function () {
            return this._volume;
        },
        /**
         * Playback volume.
         */
        set: function (value) {
            if (value !== this._volume) {
                for (var _i = 0, _a = this._sounds; _i < _a.length; _i++) {
                    var sound = _a[_i];
                    sound.setVolume(value);
                }
            }
        },
        enumerable: true,
        configurable: true
    });
    WeightedSound.prototype._onended = function () {
        if (this._currentIndex !== undefined) {
            this._sounds[this._currentIndex].autoplay = false;
        }
        if (this.loop && this.isPlaying) {
            this.play();
        }
        else {
            this.isPlaying = false;
        }
    };
    /**
     * Suspend playback
     */
    WeightedSound.prototype.pause = function () {
        this.isPaused = true;
        if (this._currentIndex !== undefined) {
            this._sounds[this._currentIndex].pause();
        }
    };
    /**
     * Stop playback
     */
    WeightedSound.prototype.stop = function () {
        this.isPlaying = false;
        if (this._currentIndex !== undefined) {
            this._sounds[this._currentIndex].stop();
        }
    };
    /**
     * Start playback.
     * @param startOffset Position the clip head at a specific time in seconds.
     */
    WeightedSound.prototype.play = function (startOffset) {
        if (!this.isPaused) {
            this.stop();
            var randomValue = Math.random();
            var total = 0;
            for (var i = 0; i < this._weights.length; i++) {
                total += this._weights[i];
                if (randomValue <= total) {
                    this._currentIndex = i;
                    break;
                }
            }
        }
        var sound = this._sounds[this._currentIndex];
        if (sound.isReady()) {
            sound.play(0, this.isPaused ? undefined : startOffset);
        }
        else {
            sound.autoplay = true;
        }
        this.isPlaying = true;
        this.isPaused = false;
    };
    return WeightedSound;
}());

//# sourceMappingURL=weightedsound.js.map

/***/ }),

/***/ "./node_modules/@babylonjs/core/Behaviors/Cameras/autoRotationBehavior.js":
/*!********************************************************************************!*\
  !*** ./node_modules/@babylonjs/core/Behaviors/Cameras/autoRotationBehavior.js ***!
  \********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "AutoRotationBehavior": () => (/* binding */ AutoRotationBehavior)
/* harmony export */ });
/* harmony import */ var _Events_pointerEvents__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../Events/pointerEvents */ "./node_modules/@babylonjs/core/Events/pointerEvents.js");
/* harmony import */ var _Misc_precisionDate__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../Misc/precisionDate */ "./node_modules/@babylonjs/core/Misc/precisionDate.js");


/**
 * The autoRotation behavior (AutoRotationBehavior) is designed to create a smooth rotation of an ArcRotateCamera when there is no user interaction.
 * @see http://doc.babylonjs.com/how_to/camera_behaviors#autorotation-behavior
 */
var AutoRotationBehavior = /** @class */ (function () {
    function AutoRotationBehavior() {
        this._zoomStopsAnimation = false;
        this._idleRotationSpeed = 0.05;
        this._idleRotationWaitTime = 2000;
        this._idleRotationSpinupTime = 2000;
        this._isPointerDown = false;
        this._lastFrameTime = null;
        this._lastInteractionTime = -Infinity;
        this._cameraRotationSpeed = 0;
        this._lastFrameRadius = 0;
    }
    Object.defineProperty(AutoRotationBehavior.prototype, "name", {
        /**
         * Gets the name of the behavior.
         */
        get: function () {
            return "AutoRotation";
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(AutoRotationBehavior.prototype, "zoomStopsAnimation", {
        /**
        * Gets the flag that indicates if user zooming should stop animation.
        */
        get: function () {
            return this._zoomStopsAnimation;
        },
        /**
        * Sets the flag that indicates if user zooming should stop animation.
        */
        set: function (flag) {
            this._zoomStopsAnimation = flag;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(AutoRotationBehavior.prototype, "idleRotationSpeed", {
        /**
        * Gets the default speed at which the camera rotates around the model.
        */
        get: function () {
            return this._idleRotationSpeed;
        },
        /**
        * Sets the default speed at which the camera rotates around the model.
        */
        set: function (speed) {
            this._idleRotationSpeed = speed;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(AutoRotationBehavior.prototype, "idleRotationWaitTime", {
        /**
        * Gets the time (milliseconds) to wait after user interaction before the camera starts rotating.
        */
        get: function () {
            return this._idleRotationWaitTime;
        },
        /**
        * Sets the time (in milliseconds) to wait after user interaction before the camera starts rotating.
        */
        set: function (time) {
            this._idleRotationWaitTime = time;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(AutoRotationBehavior.prototype, "idleRotationSpinupTime", {
        /**
        * Gets the time (milliseconds) to take to spin up to the full idle rotation speed.
        */
        get: function () {
            return this._idleRotationSpinupTime;
        },
        /**
        * Sets the time (milliseconds) to take to spin up to the full idle rotation speed.
        */
        set: function (time) {
            this._idleRotationSpinupTime = time;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(AutoRotationBehavior.prototype, "rotationInProgress", {
        /**
         * Gets a value indicating if the camera is currently rotating because of this behavior
         */
        get: function () {
            return Math.abs(this._cameraRotationSpeed) > 0;
        },
        enumerable: true,
        configurable: true
    });
    /**
     * Initializes the behavior.
     */
    AutoRotationBehavior.prototype.init = function () {
        // Do notihng
    };
    /**
     * Attaches the behavior to its arc rotate camera.
     * @param camera Defines the camera to attach the behavior to
     */
    AutoRotationBehavior.prototype.attach = function (camera) {
        var _this = this;
        this._attachedCamera = camera;
        var scene = this._attachedCamera.getScene();
        this._onPrePointerObservableObserver = scene.onPrePointerObservable.add(function (pointerInfoPre) {
            if (pointerInfoPre.type === _Events_pointerEvents__WEBPACK_IMPORTED_MODULE_0__.PointerEventTypes.POINTERDOWN) {
                _this._isPointerDown = true;
                return;
            }
            if (pointerInfoPre.type === _Events_pointerEvents__WEBPACK_IMPORTED_MODULE_0__.PointerEventTypes.POINTERUP) {
                _this._isPointerDown = false;
            }
        });
        this._onAfterCheckInputsObserver = camera.onAfterCheckInputsObservable.add(function () {
            var now = _Misc_precisionDate__WEBPACK_IMPORTED_MODULE_1__.PrecisionDate.Now;
            var dt = 0;
            if (_this._lastFrameTime != null) {
                dt = now - _this._lastFrameTime;
            }
            _this._lastFrameTime = now;
            // Stop the animation if there is user interaction and the animation should stop for this interaction
            _this._applyUserInteraction();
            var timeToRotation = now - _this._lastInteractionTime - _this._idleRotationWaitTime;
            var scale = Math.max(Math.min(timeToRotation / (_this._idleRotationSpinupTime), 1), 0);
            _this._cameraRotationSpeed = _this._idleRotationSpeed * scale;
            // Step camera rotation by rotation speed
            if (_this._attachedCamera) {
                _this._attachedCamera.alpha -= _this._cameraRotationSpeed * (dt / 1000);
            }
        });
    };
    /**
     * Detaches the behavior from its current arc rotate camera.
     */
    AutoRotationBehavior.prototype.detach = function () {
        if (!this._attachedCamera) {
            return;
        }
        var scene = this._attachedCamera.getScene();
        if (this._onPrePointerObservableObserver) {
            scene.onPrePointerObservable.remove(this._onPrePointerObservableObserver);
        }
        this._attachedCamera.onAfterCheckInputsObservable.remove(this._onAfterCheckInputsObserver);
        this._attachedCamera = null;
    };
    /**
     * Returns true if user is scrolling.
     * @return true if user is scrolling.
     */
    AutoRotationBehavior.prototype._userIsZooming = function () {
        if (!this._attachedCamera) {
            return false;
        }
        return this._attachedCamera.inertialRadiusOffset !== 0;
    };
    AutoRotationBehavior.prototype._shouldAnimationStopForInteraction = function () {
        if (!this._attachedCamera) {
            return false;
        }
        var zoomHasHitLimit = false;
        if (this._lastFrameRadius === this._attachedCamera.radius && this._attachedCamera.inertialRadiusOffset !== 0) {
            zoomHasHitLimit = true;
        }
        // Update the record of previous radius - works as an approx. indicator of hitting radius limits
        this._lastFrameRadius = this._attachedCamera.radius;
        return this._zoomStopsAnimation ? zoomHasHitLimit : this._userIsZooming();
    };
    /**
     *  Applies any current user interaction to the camera. Takes into account maximum alpha rotation.
     */
    AutoRotationBehavior.prototype._applyUserInteraction = function () {
        if (this._userIsMoving() && !this._shouldAnimationStopForInteraction()) {
            this._lastInteractionTime = _Misc_precisionDate__WEBPACK_IMPORTED_MODULE_1__.PrecisionDate.Now;
        }
    };
    // Tools
    AutoRotationBehavior.prototype._userIsMoving = function () {
        if (!this._attachedCamera) {
            return false;
        }
        return this._attachedCamera.inertialAlphaOffset !== 0 ||
            this._attachedCamera.inertialBetaOffset !== 0 ||
            this._attachedCamera.inertialRadiusOffset !== 0 ||
            this._attachedCamera.inertialPanningX !== 0 ||
            this._attachedCamera.inertialPanningY !== 0 ||
            this._isPointerDown;
    };
    return AutoRotationBehavior;
}());

//# sourceMappingURL=autoRotationBehavior.js.map

/***/ }),

/***/ "./node_modules/@babylonjs/core/Behaviors/Cameras/bouncingBehavior.js":
/*!****************************************************************************!*\
  !*** ./node_modules/@babylonjs/core/Behaviors/Cameras/bouncingBehavior.js ***!
  \****************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "BouncingBehavior": () => (/* binding */ BouncingBehavior)
/* harmony export */ });
/* harmony import */ var _Animations_easing__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../Animations/easing */ "./node_modules/@babylonjs/core/Animations/easing.js");
/* harmony import */ var _Animations_animation__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../Animations/animation */ "./node_modules/@babylonjs/core/Animations/animation.js");


/**
 * Add a bouncing effect to an ArcRotateCamera when reaching a specified minimum and maximum radius
 * @see http://doc.babylonjs.com/how_to/camera_behaviors#bouncing-behavior
 */
var BouncingBehavior = /** @class */ (function () {
    function BouncingBehavior() {
        /**
         * The duration of the animation, in milliseconds
         */
        this.transitionDuration = 450;
        /**
         * Length of the distance animated by the transition when lower radius is reached
         */
        this.lowerRadiusTransitionRange = 2;
        /**
         * Length of the distance animated by the transition when upper radius is reached
         */
        this.upperRadiusTransitionRange = -2;
        this._autoTransitionRange = false;
        // Animations
        this._radiusIsAnimating = false;
        this._radiusBounceTransition = null;
        this._animatables = new Array();
    }
    Object.defineProperty(BouncingBehavior.prototype, "name", {
        /**
         * Gets the name of the behavior.
         */
        get: function () {
            return "Bouncing";
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(BouncingBehavior.prototype, "autoTransitionRange", {
        /**
         * Gets a value indicating if the lowerRadiusTransitionRange and upperRadiusTransitionRange are defined automatically
         */
        get: function () {
            return this._autoTransitionRange;
        },
        /**
         * Sets a value indicating if the lowerRadiusTransitionRange and upperRadiusTransitionRange are defined automatically
         * Transition ranges will be set to 5% of the bounding box diagonal in world space
         */
        set: function (value) {
            var _this = this;
            if (this._autoTransitionRange === value) {
                return;
            }
            this._autoTransitionRange = value;
            var camera = this._attachedCamera;
            if (!camera) {
                return;
            }
            if (value) {
                this._onMeshTargetChangedObserver = camera.onMeshTargetChangedObservable.add(function (mesh) {
                    if (!mesh) {
                        return;
                    }
                    mesh.computeWorldMatrix(true);
                    var diagonal = mesh.getBoundingInfo().diagonalLength;
                    _this.lowerRadiusTransitionRange = diagonal * 0.05;
                    _this.upperRadiusTransitionRange = diagonal * 0.05;
                });
            }
            else if (this._onMeshTargetChangedObserver) {
                camera.onMeshTargetChangedObservable.remove(this._onMeshTargetChangedObserver);
            }
        },
        enumerable: true,
        configurable: true
    });
    /**
     * Initializes the behavior.
     */
    BouncingBehavior.prototype.init = function () {
        // Do notihng
    };
    /**
     * Attaches the behavior to its arc rotate camera.
     * @param camera Defines the camera to attach the behavior to
     */
    BouncingBehavior.prototype.attach = function (camera) {
        var _this = this;
        this._attachedCamera = camera;
        this._onAfterCheckInputsObserver = camera.onAfterCheckInputsObservable.add(function () {
            if (!_this._attachedCamera) {
                return;
            }
            // Add the bounce animation to the lower radius limit
            if (_this._isRadiusAtLimit(_this._attachedCamera.lowerRadiusLimit)) {
                _this._applyBoundRadiusAnimation(_this.lowerRadiusTransitionRange);
            }
            // Add the bounce animation to the upper radius limit
            if (_this._isRadiusAtLimit(_this._attachedCamera.upperRadiusLimit)) {
                _this._applyBoundRadiusAnimation(_this.upperRadiusTransitionRange);
            }
        });
    };
    /**
     * Detaches the behavior from its current arc rotate camera.
     */
    BouncingBehavior.prototype.detach = function () {
        if (!this._attachedCamera) {
            return;
        }
        if (this._onAfterCheckInputsObserver) {
            this._attachedCamera.onAfterCheckInputsObservable.remove(this._onAfterCheckInputsObserver);
        }
        if (this._onMeshTargetChangedObserver) {
            this._attachedCamera.onMeshTargetChangedObservable.remove(this._onMeshTargetChangedObserver);
        }
        this._attachedCamera = null;
    };
    /**
     * Checks if the camera radius is at the specified limit. Takes into account animation locks.
     * @param radiusLimit The limit to check against.
     * @return Bool to indicate if at limit.
     */
    BouncingBehavior.prototype._isRadiusAtLimit = function (radiusLimit) {
        if (!this._attachedCamera) {
            return false;
        }
        if (this._attachedCamera.radius === radiusLimit && !this._radiusIsAnimating) {
            return true;
        }
        return false;
    };
    /**
     * Applies an animation to the radius of the camera, extending by the radiusDelta.
     * @param radiusDelta The delta by which to animate to. Can be negative.
     */
    BouncingBehavior.prototype._applyBoundRadiusAnimation = function (radiusDelta) {
        var _this = this;
        if (!this._attachedCamera) {
            return;
        }
        if (!this._radiusBounceTransition) {
            BouncingBehavior.EasingFunction.setEasingMode(BouncingBehavior.EasingMode);
            this._radiusBounceTransition = _Animations_animation__WEBPACK_IMPORTED_MODULE_1__.Animation.CreateAnimation("radius", _Animations_animation__WEBPACK_IMPORTED_MODULE_1__.Animation.ANIMATIONTYPE_FLOAT, 60, BouncingBehavior.EasingFunction);
        }
        // Prevent zoom until bounce has completed
        this._cachedWheelPrecision = this._attachedCamera.wheelPrecision;
        this._attachedCamera.wheelPrecision = Infinity;
        this._attachedCamera.inertialRadiusOffset = 0;
        // Animate to the radius limit
        this.stopAllAnimations();
        this._radiusIsAnimating = true;
        var animatable = _Animations_animation__WEBPACK_IMPORTED_MODULE_1__.Animation.TransitionTo("radius", this._attachedCamera.radius + radiusDelta, this._attachedCamera, this._attachedCamera.getScene(), 60, this._radiusBounceTransition, this.transitionDuration, function () { return _this._clearAnimationLocks(); });
        if (animatable) {
            this._animatables.push(animatable);
        }
    };
    /**
     * Removes all animation locks. Allows new animations to be added to any of the camera properties.
     */
    BouncingBehavior.prototype._clearAnimationLocks = function () {
        this._radiusIsAnimating = false;
        if (this._attachedCamera) {
            this._attachedCamera.wheelPrecision = this._cachedWheelPrecision;
        }
    };
    /**
     * Stops and removes all animations that have been applied to the camera
     */
    BouncingBehavior.prototype.stopAllAnimations = function () {
        if (this._attachedCamera) {
            this._attachedCamera.animations = [];
        }
        while (this._animatables.length) {
            this._animatables[0].onAnimationEnd = null;
            this._animatables[0].stop();
            this._animatables.shift();
        }
    };
    /**
     * The easing function used by animations
     */
    BouncingBehavior.EasingFunction = new _Animations_easing__WEBPACK_IMPORTED_MODULE_0__.BackEase(0.3);
    /**
     * The easing mode used by animations
     */
    BouncingBehavior.EasingMode = _Animations_easing__WEBPACK_IMPORTED_MODULE_0__.EasingFunction.EASINGMODE_EASEOUT;
    return BouncingBehavior;
}());

//# sourceMappingURL=bouncingBehavior.js.map

/***/ }),

/***/ "./node_modules/@babylonjs/core/Behaviors/Cameras/framingBehavior.js":
/*!***************************************************************************!*\
  !*** ./node_modules/@babylonjs/core/Behaviors/Cameras/framingBehavior.js ***!
  \***************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "FramingBehavior": () => (/* binding */ FramingBehavior)
/* harmony export */ });
/* harmony import */ var _Animations_easing__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../Animations/easing */ "./node_modules/@babylonjs/core/Animations/easing.js");
/* harmony import */ var _Events_pointerEvents__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../Events/pointerEvents */ "./node_modules/@babylonjs/core/Events/pointerEvents.js");
/* harmony import */ var _Misc_precisionDate__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../Misc/precisionDate */ "./node_modules/@babylonjs/core/Misc/precisionDate.js");
/* harmony import */ var _Maths_math_vector__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../Maths/math.vector */ "./node_modules/@babylonjs/core/Maths/math.vector.js");
/* harmony import */ var _Animations_animation__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../Animations/animation */ "./node_modules/@babylonjs/core/Animations/animation.js");





/**
 * The framing behavior (FramingBehavior) is designed to automatically position an ArcRotateCamera when its target is set to a mesh. It is also useful if you want to prevent the camera to go under a virtual horizontal plane.
 * @see http://doc.babylonjs.com/how_to/camera_behaviors#framing-behavior
 */
var FramingBehavior = /** @class */ (function () {
    function FramingBehavior() {
        this._mode = FramingBehavior.FitFrustumSidesMode;
        this._radiusScale = 1.0;
        this._positionScale = 0.5;
        this._defaultElevation = 0.3;
        this._elevationReturnTime = 1500;
        this._elevationReturnWaitTime = 1000;
        this._zoomStopsAnimation = false;
        this._framingTime = 1500;
        /**
         * Define if the behavior should automatically change the configured
         * camera limits and sensibilities.
         */
        this.autoCorrectCameraLimitsAndSensibility = true;
        this._isPointerDown = false;
        this._lastInteractionTime = -Infinity;
        // Framing control
        this._animatables = new Array();
        this._betaIsAnimating = false;
    }
    Object.defineProperty(FramingBehavior.prototype, "name", {
        /**
         * Gets the name of the behavior.
         */
        get: function () {
            return "Framing";
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(FramingBehavior.prototype, "mode", {
        /**
         * Gets current mode used by the behavior.
         */
        get: function () {
            return this._mode;
        },
        /**
         * Sets the current mode used by the behavior
         */
        set: function (mode) {
            this._mode = mode;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(FramingBehavior.prototype, "radiusScale", {
        /**
         * Gets the scale applied to the radius
         */
        get: function () {
            return this._radiusScale;
        },
        /**
         * Sets the scale applied to the radius (1 by default)
         */
        set: function (radius) {
            this._radiusScale = radius;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(FramingBehavior.prototype, "positionScale", {
        /**
         * Gets the scale to apply on Y axis to position camera focus. 0.5 by default which means the center of the bounding box.
         */
        get: function () {
            return this._positionScale;
        },
        /**
         * Sets the scale to apply on Y axis to position camera focus. 0.5 by default which means the center of the bounding box.
         */
        set: function (scale) {
            this._positionScale = scale;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(FramingBehavior.prototype, "defaultElevation", {
        /**
        * Gets the angle above/below the horizontal plane to return to when the return to default elevation idle
        * behaviour is triggered, in radians.
        */
        get: function () {
            return this._defaultElevation;
        },
        /**
        * Sets the angle above/below the horizontal plane to return to when the return to default elevation idle
        * behaviour is triggered, in radians.
        */
        set: function (elevation) {
            this._defaultElevation = elevation;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(FramingBehavior.prototype, "elevationReturnTime", {
        /**
         * Gets the time (in milliseconds) taken to return to the default beta position.
         * Negative value indicates camera should not return to default.
         */
        get: function () {
            return this._elevationReturnTime;
        },
        /**
         * Sets the time (in milliseconds) taken to return to the default beta position.
         * Negative value indicates camera should not return to default.
         */
        set: function (speed) {
            this._elevationReturnTime = speed;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(FramingBehavior.prototype, "elevationReturnWaitTime", {
        /**
         * Gets the delay (in milliseconds) taken before the camera returns to the default beta position.
         */
        get: function () {
            return this._elevationReturnWaitTime;
        },
        /**
         * Sets the delay (in milliseconds) taken before the camera returns to the default beta position.
         */
        set: function (time) {
            this._elevationReturnWaitTime = time;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(FramingBehavior.prototype, "zoomStopsAnimation", {
        /**
        * Gets the flag that indicates if user zooming should stop animation.
        */
        get: function () {
            return this._zoomStopsAnimation;
        },
        /**
        * Sets the flag that indicates if user zooming should stop animation.
        */
        set: function (flag) {
            this._zoomStopsAnimation = flag;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(FramingBehavior.prototype, "framingTime", {
        /**
         * Gets the transition time when framing the mesh, in milliseconds
        */
        get: function () {
            return this._framingTime;
        },
        /**
         * Sets the transition time when framing the mesh, in milliseconds
        */
        set: function (time) {
            this._framingTime = time;
        },
        enumerable: true,
        configurable: true
    });
    /**
     * Initializes the behavior.
     */
    FramingBehavior.prototype.init = function () {
        // Do notihng
    };
    /**
     * Attaches the behavior to its arc rotate camera.
     * @param camera Defines the camera to attach the behavior to
     */
    FramingBehavior.prototype.attach = function (camera) {
        var _this = this;
        this._attachedCamera = camera;
        var scene = this._attachedCamera.getScene();
        FramingBehavior.EasingFunction.setEasingMode(FramingBehavior.EasingMode);
        this._onPrePointerObservableObserver = scene.onPrePointerObservable.add(function (pointerInfoPre) {
            if (pointerInfoPre.type === _Events_pointerEvents__WEBPACK_IMPORTED_MODULE_1__.PointerEventTypes.POINTERDOWN) {
                _this._isPointerDown = true;
                return;
            }
            if (pointerInfoPre.type === _Events_pointerEvents__WEBPACK_IMPORTED_MODULE_1__.PointerEventTypes.POINTERUP) {
                _this._isPointerDown = false;
            }
        });
        this._onMeshTargetChangedObserver = camera.onMeshTargetChangedObservable.add(function (mesh) {
            if (mesh) {
                _this.zoomOnMesh(mesh);
            }
        });
        this._onAfterCheckInputsObserver = camera.onAfterCheckInputsObservable.add(function () {
            // Stop the animation if there is user interaction and the animation should stop for this interaction
            _this._applyUserInteraction();
            // Maintain the camera above the ground. If the user pulls the camera beneath the ground plane, lift it
            // back to the default position after a given timeout
            _this._maintainCameraAboveGround();
        });
    };
    /**
     * Detaches the behavior from its current arc rotate camera.
     */
    FramingBehavior.prototype.detach = function () {
        if (!this._attachedCamera) {
            return;
        }
        var scene = this._attachedCamera.getScene();
        if (this._onPrePointerObservableObserver) {
            scene.onPrePointerObservable.remove(this._onPrePointerObservableObserver);
        }
        if (this._onAfterCheckInputsObserver) {
            this._attachedCamera.onAfterCheckInputsObservable.remove(this._onAfterCheckInputsObserver);
        }
        if (this._onMeshTargetChangedObserver) {
            this._attachedCamera.onMeshTargetChangedObservable.remove(this._onMeshTargetChangedObserver);
        }
        this._attachedCamera = null;
    };
    /**
     * Targets the given mesh and updates zoom level accordingly.
     * @param mesh  The mesh to target.
     * @param focusOnOriginXZ Determines if the camera should focus on 0 in the X and Z axis instead of the mesh
     * @param onAnimationEnd Callback triggered at the end of the framing animation
     */
    FramingBehavior.prototype.zoomOnMesh = function (mesh, focusOnOriginXZ, onAnimationEnd) {
        if (focusOnOriginXZ === void 0) { focusOnOriginXZ = false; }
        if (onAnimationEnd === void 0) { onAnimationEnd = null; }
        mesh.computeWorldMatrix(true);
        var boundingBox = mesh.getBoundingInfo().boundingBox;
        this.zoomOnBoundingInfo(boundingBox.minimumWorld, boundingBox.maximumWorld, focusOnOriginXZ, onAnimationEnd);
    };
    /**
     * Targets the given mesh with its children and updates zoom level accordingly.
     * @param mesh  The mesh to target.
     * @param focusOnOriginXZ Determines if the camera should focus on 0 in the X and Z axis instead of the mesh
     * @param onAnimationEnd Callback triggered at the end of the framing animation
     */
    FramingBehavior.prototype.zoomOnMeshHierarchy = function (mesh, focusOnOriginXZ, onAnimationEnd) {
        if (focusOnOriginXZ === void 0) { focusOnOriginXZ = false; }
        if (onAnimationEnd === void 0) { onAnimationEnd = null; }
        mesh.computeWorldMatrix(true);
        var boundingBox = mesh.getHierarchyBoundingVectors(true);
        this.zoomOnBoundingInfo(boundingBox.min, boundingBox.max, focusOnOriginXZ, onAnimationEnd);
    };
    /**
     * Targets the given meshes with their children and updates zoom level accordingly.
     * @param meshes  The mesh to target.
     * @param focusOnOriginXZ Determines if the camera should focus on 0 in the X and Z axis instead of the mesh
     * @param onAnimationEnd Callback triggered at the end of the framing animation
     */
    FramingBehavior.prototype.zoomOnMeshesHierarchy = function (meshes, focusOnOriginXZ, onAnimationEnd) {
        if (focusOnOriginXZ === void 0) { focusOnOriginXZ = false; }
        if (onAnimationEnd === void 0) { onAnimationEnd = null; }
        var min = new _Maths_math_vector__WEBPACK_IMPORTED_MODULE_3__.Vector3(Number.MAX_VALUE, Number.MAX_VALUE, Number.MAX_VALUE);
        var max = new _Maths_math_vector__WEBPACK_IMPORTED_MODULE_3__.Vector3(-Number.MAX_VALUE, -Number.MAX_VALUE, -Number.MAX_VALUE);
        for (var i = 0; i < meshes.length; i++) {
            var boundingInfo = meshes[i].getHierarchyBoundingVectors(true);
            _Maths_math_vector__WEBPACK_IMPORTED_MODULE_3__.Vector3.CheckExtends(boundingInfo.min, min, max);
            _Maths_math_vector__WEBPACK_IMPORTED_MODULE_3__.Vector3.CheckExtends(boundingInfo.max, min, max);
        }
        this.zoomOnBoundingInfo(min, max, focusOnOriginXZ, onAnimationEnd);
    };
    /**
     * Targets the bounding box info defined by its extends and updates zoom level accordingly.
     * @param minimumWorld Determines the smaller position of the bounding box extend
     * @param maximumWorld Determines the bigger position of the bounding box extend
     * @param focusOnOriginXZ Determines if the camera should focus on 0 in the X and Z axis instead of the mesh
     * @param onAnimationEnd Callback triggered at the end of the framing animation
     */
    FramingBehavior.prototype.zoomOnBoundingInfo = function (minimumWorld, maximumWorld, focusOnOriginXZ, onAnimationEnd) {
        var _this = this;
        if (focusOnOriginXZ === void 0) { focusOnOriginXZ = false; }
        if (onAnimationEnd === void 0) { onAnimationEnd = null; }
        var zoomTarget;
        if (!this._attachedCamera) {
            return;
        }
        // Find target by interpolating from bottom of bounding box in world-space to top via framingPositionY
        var bottom = minimumWorld.y;
        var top = maximumWorld.y;
        var zoomTargetY = bottom + (top - bottom) * this._positionScale;
        var radiusWorld = maximumWorld.subtract(minimumWorld).scale(0.5);
        if (focusOnOriginXZ) {
            zoomTarget = new _Maths_math_vector__WEBPACK_IMPORTED_MODULE_3__.Vector3(0, zoomTargetY, 0);
        }
        else {
            var centerWorld = minimumWorld.add(radiusWorld);
            zoomTarget = new _Maths_math_vector__WEBPACK_IMPORTED_MODULE_3__.Vector3(centerWorld.x, zoomTargetY, centerWorld.z);
        }
        if (!this._vectorTransition) {
            this._vectorTransition = _Animations_animation__WEBPACK_IMPORTED_MODULE_4__.Animation.CreateAnimation("target", _Animations_animation__WEBPACK_IMPORTED_MODULE_4__.Animation.ANIMATIONTYPE_VECTOR3, 60, FramingBehavior.EasingFunction);
        }
        this._betaIsAnimating = true;
        var animatable = _Animations_animation__WEBPACK_IMPORTED_MODULE_4__.Animation.TransitionTo("target", zoomTarget, this._attachedCamera, this._attachedCamera.getScene(), 60, this._vectorTransition, this._framingTime);
        if (animatable) {
            this._animatables.push(animatable);
        }
        // sets the radius and lower radius bounds
        // Small delta ensures camera is not always at lower zoom limit.
        var radius = 0;
        if (this._mode === FramingBehavior.FitFrustumSidesMode) {
            var position = this._calculateLowerRadiusFromModelBoundingSphere(minimumWorld, maximumWorld);
            if (this.autoCorrectCameraLimitsAndSensibility) {
                this._attachedCamera.lowerRadiusLimit = radiusWorld.length() + this._attachedCamera.minZ;
            }
            radius = position;
        }
        else if (this._mode === FramingBehavior.IgnoreBoundsSizeMode) {
            radius = this._calculateLowerRadiusFromModelBoundingSphere(minimumWorld, maximumWorld);
            if (this.autoCorrectCameraLimitsAndSensibility && this._attachedCamera.lowerRadiusLimit === null) {
                this._attachedCamera.lowerRadiusLimit = this._attachedCamera.minZ;
            }
        }
        // Set sensibilities
        if (this.autoCorrectCameraLimitsAndSensibility) {
            var extend = maximumWorld.subtract(minimumWorld).length();
            this._attachedCamera.panningSensibility = 5000 / extend;
            this._attachedCamera.wheelPrecision = 100 / radius;
        }
        // transition to new radius
        if (!this._radiusTransition) {
            this._radiusTransition = _Animations_animation__WEBPACK_IMPORTED_MODULE_4__.Animation.CreateAnimation("radius", _Animations_animation__WEBPACK_IMPORTED_MODULE_4__.Animation.ANIMATIONTYPE_FLOAT, 60, FramingBehavior.EasingFunction);
        }
        animatable = _Animations_animation__WEBPACK_IMPORTED_MODULE_4__.Animation.TransitionTo("radius", radius, this._attachedCamera, this._attachedCamera.getScene(), 60, this._radiusTransition, this._framingTime, function () {
            _this.stopAllAnimations();
            if (onAnimationEnd) {
                onAnimationEnd();
            }
            if (_this._attachedCamera && _this._attachedCamera.useInputToRestoreState) {
                _this._attachedCamera.storeState();
            }
        });
        if (animatable) {
            this._animatables.push(animatable);
        }
    };
    /**
     * Calculates the lowest radius for the camera based on the bounding box of the mesh.
     * @param mesh The mesh on which to base the calculation. mesh boundingInfo used to estimate necessary
     *			  frustum width.
     * @return The minimum distance from the primary mesh's center point at which the camera must be kept in order
     *		 to fully enclose the mesh in the viewing frustum.
     */
    FramingBehavior.prototype._calculateLowerRadiusFromModelBoundingSphere = function (minimumWorld, maximumWorld) {
        var size = maximumWorld.subtract(minimumWorld);
        var boxVectorGlobalDiagonal = size.length();
        var frustumSlope = this._getFrustumSlope();
        // Formula for setting distance
        // (Good explanation: http://stackoverflow.com/questions/2866350/move-camera-to-fit-3d-scene)
        var radiusWithoutFraming = boxVectorGlobalDiagonal * 0.5;
        // Horizon distance
        var radius = radiusWithoutFraming * this._radiusScale;
        var distanceForHorizontalFrustum = radius * Math.sqrt(1.0 + 1.0 / (frustumSlope.x * frustumSlope.x));
        var distanceForVerticalFrustum = radius * Math.sqrt(1.0 + 1.0 / (frustumSlope.y * frustumSlope.y));
        var distance = Math.max(distanceForHorizontalFrustum, distanceForVerticalFrustum);
        var camera = this._attachedCamera;
        if (!camera) {
            return 0;
        }
        if (camera.lowerRadiusLimit && this._mode === FramingBehavior.IgnoreBoundsSizeMode) {
            // Don't exceed the requested limit
            distance = distance < camera.lowerRadiusLimit ? camera.lowerRadiusLimit : distance;
        }
        // Don't exceed the upper radius limit
        if (camera.upperRadiusLimit) {
            distance = distance > camera.upperRadiusLimit ? camera.upperRadiusLimit : distance;
        }
        return distance;
    };
    /**
     * Keeps the camera above the ground plane. If the user pulls the camera below the ground plane, the camera
     * is automatically returned to its default position (expected to be above ground plane).
     */
    FramingBehavior.prototype._maintainCameraAboveGround = function () {
        var _this = this;
        if (this._elevationReturnTime < 0) {
            return;
        }
        var timeSinceInteraction = _Misc_precisionDate__WEBPACK_IMPORTED_MODULE_2__.PrecisionDate.Now - this._lastInteractionTime;
        var defaultBeta = Math.PI * 0.5 - this._defaultElevation;
        var limitBeta = Math.PI * 0.5;
        // Bring the camera back up if below the ground plane
        if (this._attachedCamera && !this._betaIsAnimating && this._attachedCamera.beta > limitBeta && timeSinceInteraction >= this._elevationReturnWaitTime) {
            this._betaIsAnimating = true;
            //Transition to new position
            this.stopAllAnimations();
            if (!this._betaTransition) {
                this._betaTransition = _Animations_animation__WEBPACK_IMPORTED_MODULE_4__.Animation.CreateAnimation("beta", _Animations_animation__WEBPACK_IMPORTED_MODULE_4__.Animation.ANIMATIONTYPE_FLOAT, 60, FramingBehavior.EasingFunction);
            }
            var animatabe = _Animations_animation__WEBPACK_IMPORTED_MODULE_4__.Animation.TransitionTo("beta", defaultBeta, this._attachedCamera, this._attachedCamera.getScene(), 60, this._betaTransition, this._elevationReturnTime, function () {
                _this._clearAnimationLocks();
                _this.stopAllAnimations();
            });
            if (animatabe) {
                this._animatables.push(animatabe);
            }
        }
    };
    /**
     * Returns the frustum slope based on the canvas ratio and camera FOV
     * @returns The frustum slope represented as a Vector2 with X and Y slopes
     */
    FramingBehavior.prototype._getFrustumSlope = function () {
        // Calculate the viewport ratio
        // Aspect Ratio is Height/Width.
        var camera = this._attachedCamera;
        if (!camera) {
            return _Maths_math_vector__WEBPACK_IMPORTED_MODULE_3__.Vector2.Zero();
        }
        var engine = camera.getScene().getEngine();
        var aspectRatio = engine.getAspectRatio(camera);
        // Camera FOV is the vertical field of view (top-bottom) in radians.
        // Slope of the frustum top/bottom planes in view space, relative to the forward vector.
        var frustumSlopeY = Math.tan(camera.fov / 2);
        // Slope of the frustum left/right planes in view space, relative to the forward vector.
        // Provides the amount that one side (e.g. left) of the frustum gets wider for every unit
        // along the forward vector.
        var frustumSlopeX = frustumSlopeY * aspectRatio;
        return new _Maths_math_vector__WEBPACK_IMPORTED_MODULE_3__.Vector2(frustumSlopeX, frustumSlopeY);
    };
    /**
     * Removes all animation locks. Allows new animations to be added to any of the arcCamera properties.
     */
    FramingBehavior.prototype._clearAnimationLocks = function () {
        this._betaIsAnimating = false;
    };
    /**
     *  Applies any current user interaction to the camera. Takes into account maximum alpha rotation.
     */
    FramingBehavior.prototype._applyUserInteraction = function () {
        if (this.isUserIsMoving) {
            this._lastInteractionTime = _Misc_precisionDate__WEBPACK_IMPORTED_MODULE_2__.PrecisionDate.Now;
            this.stopAllAnimations();
            this._clearAnimationLocks();
        }
    };
    /**
     * Stops and removes all animations that have been applied to the camera
     */
    FramingBehavior.prototype.stopAllAnimations = function () {
        if (this._attachedCamera) {
            this._attachedCamera.animations = [];
        }
        while (this._animatables.length) {
            if (this._animatables[0]) {
                this._animatables[0].onAnimationEnd = null;
                this._animatables[0].stop();
            }
            this._animatables.shift();
        }
    };
    Object.defineProperty(FramingBehavior.prototype, "isUserIsMoving", {
        /**
         * Gets a value indicating if the user is moving the camera
         */
        get: function () {
            if (!this._attachedCamera) {
                return false;
            }
            return this._attachedCamera.inertialAlphaOffset !== 0 ||
                this._attachedCamera.inertialBetaOffset !== 0 ||
                this._attachedCamera.inertialRadiusOffset !== 0 ||
                this._attachedCamera.inertialPanningX !== 0 ||
                this._attachedCamera.inertialPanningY !== 0 ||
                this._isPointerDown;
        },
        enumerable: true,
        configurable: true
    });
    /**
     * The easing function used by animations
     */
    FramingBehavior.EasingFunction = new _Animations_easing__WEBPACK_IMPORTED_MODULE_0__.ExponentialEase();
    /**
     * The easing mode used by animations
     */
    FramingBehavior.EasingMode = _Animations_easing__WEBPACK_IMPORTED_MODULE_0__.EasingFunction.EASINGMODE_EASEINOUT;
    // Statics
    /**
     * The camera can move all the way towards the mesh.
     */
    FramingBehavior.IgnoreBoundsSizeMode = 0;
    /**
     * The camera is not allowed to zoom closer to the mesh than the point at which the adjusted bounding sphere touches the frustum sides
     */
    FramingBehavior.FitFrustumSidesMode = 1;
    return FramingBehavior;
}());

//# sourceMappingURL=framingBehavior.js.map

/***/ }),

/***/ "./node_modules/@babylonjs/core/Behaviors/Cameras/index.js":
/*!*****************************************************************!*\
  !*** ./node_modules/@babylonjs/core/Behaviors/Cameras/index.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "AutoRotationBehavior": () => (/* reexport safe */ _autoRotationBehavior__WEBPACK_IMPORTED_MODULE_0__.AutoRotationBehavior),
/* harmony export */   "BouncingBehavior": () => (/* reexport safe */ _bouncingBehavior__WEBPACK_IMPORTED_MODULE_1__.BouncingBehavior),
/* harmony export */   "FramingBehavior": () => (/* reexport safe */ _framingBehavior__WEBPACK_IMPORTED_MODULE_2__.FramingBehavior)
/* harmony export */ });
/* harmony import */ var _autoRotationBehavior__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./autoRotationBehavior */ "./node_modules/@babylonjs/core/Behaviors/Cameras/autoRotationBehavior.js");
/* harmony import */ var _bouncingBehavior__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./bouncingBehavior */ "./node_modules/@babylonjs/core/Behaviors/Cameras/bouncingBehavior.js");
/* harmony import */ var _framingBehavior__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./framingBehavior */ "./node_modules/@babylonjs/core/Behaviors/Cameras/framingBehavior.js");



//# sourceMappingURL=index.js.map

/***/ }),

/***/ "./node_modules/@babylonjs/core/Behaviors/Meshes/attachToBoxBehavior.js":
/*!******************************************************************************!*\
  !*** ./node_modules/@babylonjs/core/Behaviors/Meshes/attachToBoxBehavior.js ***!
  \******************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "AttachToBoxBehavior": () => (/* binding */ AttachToBoxBehavior)
/* harmony export */ });
/* harmony import */ var _Maths_math_vector__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../Maths/math.vector */ "./node_modules/@babylonjs/core/Maths/math.vector.js");

/**
 * @hidden
 */
var FaceDirectionInfo = /** @class */ (function () {
    function FaceDirectionInfo(direction, rotatedDirection, diff, ignore) {
        if (rotatedDirection === void 0) { rotatedDirection = new _Maths_math_vector__WEBPACK_IMPORTED_MODULE_0__.Vector3(); }
        if (diff === void 0) { diff = 0; }
        if (ignore === void 0) { ignore = false; }
        this.direction = direction;
        this.rotatedDirection = rotatedDirection;
        this.diff = diff;
        this.ignore = ignore;
    }
    return FaceDirectionInfo;
}());
/**
 * A behavior that when attached to a mesh will will place a specified node on the meshes face pointing towards the camera
 */
var AttachToBoxBehavior = /** @class */ (function () {
    /**
     * Creates the AttachToBoxBehavior, used to attach UI to the closest face of the box to a camera
     * @param ui The transform node that should be attched to the mesh
     */
    function AttachToBoxBehavior(ui) {
        this.ui = ui;
        /**
         *  The name of the behavior
         */
        this.name = "AttachToBoxBehavior";
        /**
         * The distance away from the face of the mesh that the UI should be attached to (default: 0.15)
         */
        this.distanceAwayFromFace = 0.15;
        /**
         * The distance from the bottom of the face that the UI should be attached to (default: 0.15)
         */
        this.distanceAwayFromBottomOfFace = 0.15;
        this._faceVectors = [new FaceDirectionInfo(_Maths_math_vector__WEBPACK_IMPORTED_MODULE_0__.Vector3.Up()), new FaceDirectionInfo(_Maths_math_vector__WEBPACK_IMPORTED_MODULE_0__.Vector3.Down()), new FaceDirectionInfo(_Maths_math_vector__WEBPACK_IMPORTED_MODULE_0__.Vector3.Left()), new FaceDirectionInfo(_Maths_math_vector__WEBPACK_IMPORTED_MODULE_0__.Vector3.Right()), new FaceDirectionInfo(_Maths_math_vector__WEBPACK_IMPORTED_MODULE_0__.Vector3.Forward()), new FaceDirectionInfo(_Maths_math_vector__WEBPACK_IMPORTED_MODULE_0__.Vector3.Forward().scaleInPlace(-1))];
        this._tmpMatrix = new _Maths_math_vector__WEBPACK_IMPORTED_MODULE_0__.Matrix();
        this._tmpVector = new _Maths_math_vector__WEBPACK_IMPORTED_MODULE_0__.Vector3();
        this._zeroVector = _Maths_math_vector__WEBPACK_IMPORTED_MODULE_0__.Vector3.Zero();
        this._lookAtTmpMatrix = new _Maths_math_vector__WEBPACK_IMPORTED_MODULE_0__.Matrix();
        /* Does nothing */
    }
    /**
     *  Initializes the behavior
     */
    AttachToBoxBehavior.prototype.init = function () {
        /* Does nothing */
    };
    AttachToBoxBehavior.prototype._closestFace = function (targetDirection) {
        var _this = this;
        // Go over each face and calculate the angle between the face's normal and targetDirection
        this._faceVectors.forEach(function (v) {
            if (!_this._target.rotationQuaternion) {
                _this._target.rotationQuaternion = _Maths_math_vector__WEBPACK_IMPORTED_MODULE_0__.Quaternion.RotationYawPitchRoll(_this._target.rotation.y, _this._target.rotation.x, _this._target.rotation.z);
            }
            _this._target.rotationQuaternion.toRotationMatrix(_this._tmpMatrix);
            _Maths_math_vector__WEBPACK_IMPORTED_MODULE_0__.Vector3.TransformCoordinatesToRef(v.direction, _this._tmpMatrix, v.rotatedDirection);
            v.diff = _Maths_math_vector__WEBPACK_IMPORTED_MODULE_0__.Vector3.GetAngleBetweenVectors(v.rotatedDirection, targetDirection, _Maths_math_vector__WEBPACK_IMPORTED_MODULE_0__.Vector3.Cross(v.rotatedDirection, targetDirection));
        });
        // Return the face information of the one with the normal closeset to target direction
        return this._faceVectors.reduce(function (min, p) {
            if (min.ignore) {
                return p;
            }
            else if (p.ignore) {
                return min;
            }
            else {
                return min.diff < p.diff ? min : p;
            }
        }, this._faceVectors[0]);
    };
    AttachToBoxBehavior.prototype._lookAtToRef = function (pos, up, ref) {
        if (up === void 0) { up = new _Maths_math_vector__WEBPACK_IMPORTED_MODULE_0__.Vector3(0, 1, 0); }
        _Maths_math_vector__WEBPACK_IMPORTED_MODULE_0__.Matrix.LookAtLHToRef(this._zeroVector, pos, up, this._lookAtTmpMatrix);
        this._lookAtTmpMatrix.invert();
        _Maths_math_vector__WEBPACK_IMPORTED_MODULE_0__.Quaternion.FromRotationMatrixToRef(this._lookAtTmpMatrix, ref);
    };
    /**
     * Attaches the AttachToBoxBehavior to the passed in mesh
     * @param target The mesh that the specified node will be attached to
     */
    AttachToBoxBehavior.prototype.attach = function (target) {
        var _this = this;
        this._target = target;
        this._scene = this._target.getScene();
        // Every frame, update the app bars position
        this._onRenderObserver = this._scene.onBeforeRenderObservable.add(function () {
            if (!_this._scene.activeCamera) {
                return;
            }
            // Find the face closest to the cameras position
            var cameraPos = _this._scene.activeCamera.position;
            if (_this._scene.activeCamera.devicePosition) {
                cameraPos = _this._scene.activeCamera.devicePosition;
            }
            var facing = _this._closestFace(cameraPos.subtract(target.position));
            if (_this._scene.activeCamera.leftCamera) {
                _this._scene.activeCamera.leftCamera.computeWorldMatrix().getRotationMatrixToRef(_this._tmpMatrix);
            }
            else {
                _this._scene.activeCamera.computeWorldMatrix().getRotationMatrixToRef(_this._tmpMatrix);
            }
            // Get camera up direction
            _Maths_math_vector__WEBPACK_IMPORTED_MODULE_0__.Vector3.TransformCoordinatesToRef(_Maths_math_vector__WEBPACK_IMPORTED_MODULE_0__.Vector3.Up(), _this._tmpMatrix, _this._tmpVector);
            // Ignore faces to not select a parrelel face for the up vector of the UI
            _this._faceVectors.forEach(function (v) {
                if (facing.direction.x && v.direction.x) {
                    v.ignore = true;
                }
                if (facing.direction.y && v.direction.y) {
                    v.ignore = true;
                }
                if (facing.direction.z && v.direction.z) {
                    v.ignore = true;
                }
            });
            var facingUp = _this._closestFace(_this._tmpVector);
            // Unignore faces
            _this._faceVectors.forEach(function (v) {
                v.ignore = false;
            });
            // Position the app bar on that face
            _this.ui.position.copyFrom(target.position);
            if (facing.direction.x) {
                facing.rotatedDirection.scaleToRef((target.scaling.x / 2) + _this.distanceAwayFromFace, _this._tmpVector);
                _this.ui.position.addInPlace(_this._tmpVector);
            }
            if (facing.direction.y) {
                facing.rotatedDirection.scaleToRef((target.scaling.y / 2) + _this.distanceAwayFromFace, _this._tmpVector);
                _this.ui.position.addInPlace(_this._tmpVector);
            }
            if (facing.direction.z) {
                facing.rotatedDirection.scaleToRef((target.scaling.z / 2) + _this.distanceAwayFromFace, _this._tmpVector);
                _this.ui.position.addInPlace(_this._tmpVector);
            }
            // Rotate to be oriented properly to the camera
            if (!_this.ui.rotationQuaternion) {
                _this.ui.rotationQuaternion = _Maths_math_vector__WEBPACK_IMPORTED_MODULE_0__.Quaternion.RotationYawPitchRoll(_this.ui.rotation.y, _this.ui.rotation.x, _this.ui.rotation.z);
            }
            facing.rotatedDirection.scaleToRef(-1, _this._tmpVector);
            _this._lookAtToRef(_this._tmpVector, facingUp.rotatedDirection, _this.ui.rotationQuaternion);
            // Place ui the correct distance from the bottom of the mesh
            if (facingUp.direction.x) {
                _this.ui.up.scaleToRef(_this.distanceAwayFromBottomOfFace - target.scaling.x / 2, _this._tmpVector);
            }
            if (facingUp.direction.y) {
                _this.ui.up.scaleToRef(_this.distanceAwayFromBottomOfFace - target.scaling.y / 2, _this._tmpVector);
            }
            if (facingUp.direction.z) {
                _this.ui.up.scaleToRef(_this.distanceAwayFromBottomOfFace - target.scaling.z / 2, _this._tmpVector);
            }
            _this.ui.position.addInPlace(_this._tmpVector);
        });
    };
    /**
     *  Detaches the behavior from the mesh
     */
    AttachToBoxBehavior.prototype.detach = function () {
        this._scene.onBeforeRenderObservable.remove(this._onRenderObserver);
    };
    return AttachToBoxBehavior;
}());

//# sourceMappingURL=attachToBoxBehavior.js.map

/***/ }),

/***/ "./node_modules/@babylonjs/core/Behaviors/Meshes/fadeInOutBehavior.js":
/*!****************************************************************************!*\
  !*** ./node_modules/@babylonjs/core/Behaviors/Meshes/fadeInOutBehavior.js ***!
  \****************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "FadeInOutBehavior": () => (/* binding */ FadeInOutBehavior)
/* harmony export */ });
/**
 * A behavior that when attached to a mesh will allow the mesh to fade in and out
 */
var FadeInOutBehavior = /** @class */ (function () {
    /**
     * Instatiates the FadeInOutBehavior
     */
    function FadeInOutBehavior() {
        var _this = this;
        /**
         * Time in milliseconds to delay before fading in (Default: 0)
         */
        this.delay = 0;
        /**
         * Time in milliseconds for the mesh to fade in (Default: 300)
         */
        this.fadeInTime = 300;
        this._millisecondsPerFrame = 1000 / 60;
        this._hovered = false;
        this._hoverValue = 0;
        this._ownerNode = null;
        this._update = function () {
            if (_this._ownerNode) {
                _this._hoverValue += _this._hovered ? _this._millisecondsPerFrame : -_this._millisecondsPerFrame;
                _this._setAllVisibility(_this._ownerNode, (_this._hoverValue - _this.delay) / _this.fadeInTime);
                if (_this._ownerNode.visibility > 1) {
                    _this._setAllVisibility(_this._ownerNode, 1);
                    _this._hoverValue = _this.fadeInTime + _this.delay;
                    return;
                }
                else if (_this._ownerNode.visibility < 0) {
                    _this._setAllVisibility(_this._ownerNode, 0);
                    if (_this._hoverValue < 0) {
                        _this._hoverValue = 0;
                        return;
                    }
                }
                setTimeout(_this._update, _this._millisecondsPerFrame);
            }
        };
    }
    Object.defineProperty(FadeInOutBehavior.prototype, "name", {
        /**
         *  The name of the behavior
         */
        get: function () {
            return "FadeInOut";
        },
        enumerable: true,
        configurable: true
    });
    /**
     *  Initializes the behavior
     */
    FadeInOutBehavior.prototype.init = function () {
    };
    /**
     * Attaches the fade behavior on the passed in mesh
     * @param ownerNode The mesh that will be faded in/out once attached
     */
    FadeInOutBehavior.prototype.attach = function (ownerNode) {
        this._ownerNode = ownerNode;
        this._setAllVisibility(this._ownerNode, 0);
    };
    /**
     *  Detaches the behavior from the mesh
     */
    FadeInOutBehavior.prototype.detach = function () {
        this._ownerNode = null;
    };
    /**
     * Triggers the mesh to begin fading in or out
     * @param value if the object should fade in or out (true to fade in)
     */
    FadeInOutBehavior.prototype.fadeIn = function (value) {
        this._hovered = value;
        this._update();
    };
    FadeInOutBehavior.prototype._setAllVisibility = function (mesh, value) {
        var _this = this;
        mesh.visibility = value;
        mesh.getChildMeshes().forEach(function (c) {
            _this._setAllVisibility(c, value);
        });
    };
    return FadeInOutBehavior;
}());

//# sourceMappingURL=fadeInOutBehavior.js.map

/***/ }),

/***/ "./node_modules/@babylonjs/core/Behaviors/Meshes/index.js":
/*!****************************************************************!*\
  !*** ./node_modules/@babylonjs/core/Behaviors/Meshes/index.js ***!
  \****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "AttachToBoxBehavior": () => (/* reexport safe */ _attachToBoxBehavior__WEBPACK_IMPORTED_MODULE_0__.AttachToBoxBehavior),
/* harmony export */   "FadeInOutBehavior": () => (/* reexport safe */ _fadeInOutBehavior__WEBPACK_IMPORTED_MODULE_1__.FadeInOutBehavior),
/* harmony export */   "MultiPointerScaleBehavior": () => (/* reexport safe */ _multiPointerScaleBehavior__WEBPACK_IMPORTED_MODULE_2__.MultiPointerScaleBehavior),
/* harmony export */   "PointerDragBehavior": () => (/* reexport safe */ _pointerDragBehavior__WEBPACK_IMPORTED_MODULE_3__.PointerDragBehavior),
/* harmony export */   "SixDofDragBehavior": () => (/* reexport safe */ _sixDofDragBehavior__WEBPACK_IMPORTED_MODULE_4__.SixDofDragBehavior)
/* harmony export */ });
/* harmony import */ var _attachToBoxBehavior__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./attachToBoxBehavior */ "./node_modules/@babylonjs/core/Behaviors/Meshes/attachToBoxBehavior.js");
/* harmony import */ var _fadeInOutBehavior__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./fadeInOutBehavior */ "./node_modules/@babylonjs/core/Behaviors/Meshes/fadeInOutBehavior.js");
/* harmony import */ var _multiPointerScaleBehavior__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./multiPointerScaleBehavior */ "./node_modules/@babylonjs/core/Behaviors/Meshes/multiPointerScaleBehavior.js");
/* harmony import */ var _pointerDragBehavior__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./pointerDragBehavior */ "./node_modules/@babylonjs/core/Behaviors/Meshes/pointerDragBehavior.js");
/* harmony import */ var _sixDofDragBehavior__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./sixDofDragBehavior */ "./node_modules/@babylonjs/core/Behaviors/Meshes/sixDofDragBehavior.js");





//# sourceMappingURL=index.js.map

/***/ }),

/***/ "./node_modules/@babylonjs/core/Behaviors/Meshes/multiPointerScaleBehavior.js":
/*!************************************************************************************!*\
  !*** ./node_modules/@babylonjs/core/Behaviors/Meshes/multiPointerScaleBehavior.js ***!
  \************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "MultiPointerScaleBehavior": () => (/* binding */ MultiPointerScaleBehavior)
/* harmony export */ });
/* harmony import */ var _pointerDragBehavior__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./pointerDragBehavior */ "./node_modules/@babylonjs/core/Behaviors/Meshes/pointerDragBehavior.js");
/* harmony import */ var _Maths_math_vector__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../Maths/math.vector */ "./node_modules/@babylonjs/core/Maths/math.vector.js");


/**
 * A behavior that when attached to a mesh will allow the mesh to be scaled
 */
var MultiPointerScaleBehavior = /** @class */ (function () {
    /**
     * Instantiate a new behavior that when attached to a mesh will allow the mesh to be scaled
     */
    function MultiPointerScaleBehavior() {
        this._startDistance = 0;
        this._initialScale = new _Maths_math_vector__WEBPACK_IMPORTED_MODULE_1__.Vector3(0, 0, 0);
        this._targetScale = new _Maths_math_vector__WEBPACK_IMPORTED_MODULE_1__.Vector3(0, 0, 0);
        this._sceneRenderObserver = null;
        this._dragBehaviorA = new _pointerDragBehavior__WEBPACK_IMPORTED_MODULE_0__.PointerDragBehavior({});
        this._dragBehaviorA.moveAttached = false;
        this._dragBehaviorB = new _pointerDragBehavior__WEBPACK_IMPORTED_MODULE_0__.PointerDragBehavior({});
        this._dragBehaviorB.moveAttached = false;
    }
    Object.defineProperty(MultiPointerScaleBehavior.prototype, "name", {
        /**
         *  The name of the behavior
         */
        get: function () {
            return "MultiPointerScale";
        },
        enumerable: true,
        configurable: true
    });
    /**
     *  Initializes the behavior
     */
    MultiPointerScaleBehavior.prototype.init = function () { };
    MultiPointerScaleBehavior.prototype._getCurrentDistance = function () {
        return this._dragBehaviorA.lastDragPosition.subtract(this._dragBehaviorB.lastDragPosition).length();
    };
    /**
     * Attaches the scale behavior the passed in mesh
     * @param ownerNode The mesh that will be scaled around once attached
     */
    MultiPointerScaleBehavior.prototype.attach = function (ownerNode) {
        var _this = this;
        this._ownerNode = ownerNode;
        // Create 2 drag behaviors such that each will only be triggered by a separate pointer
        this._dragBehaviorA.onDragStartObservable.add(function (e) {
            if (_this._dragBehaviorA.dragging && _this._dragBehaviorB.dragging) {
                if (_this._dragBehaviorA.currentDraggingPointerID == _this._dragBehaviorB.currentDraggingPointerID) {
                    _this._dragBehaviorA.releaseDrag();
                }
                else {
                    _this._initialScale.copyFrom(ownerNode.scaling);
                    _this._startDistance = _this._getCurrentDistance();
                }
            }
        });
        this._dragBehaviorB.onDragStartObservable.add(function (e) {
            if (_this._dragBehaviorA.dragging && _this._dragBehaviorB.dragging) {
                if (_this._dragBehaviorA.currentDraggingPointerID == _this._dragBehaviorB.currentDraggingPointerID) {
                    _this._dragBehaviorB.releaseDrag();
                }
                else {
                    _this._initialScale.copyFrom(ownerNode.scaling);
                    _this._startDistance = _this._getCurrentDistance();
                }
            }
        });
        // Once both drag behaviors are active scale based on the distance between the two pointers
        [this._dragBehaviorA, this._dragBehaviorB].forEach(function (behavior) {
            behavior.onDragObservable.add(function () {
                if (_this._dragBehaviorA.dragging && _this._dragBehaviorB.dragging) {
                    var ratio = _this._getCurrentDistance() / _this._startDistance;
                    _this._initialScale.scaleToRef(ratio, _this._targetScale);
                }
            });
        });
        ownerNode.addBehavior(this._dragBehaviorA);
        ownerNode.addBehavior(this._dragBehaviorB);
        // On every frame move towards target scaling to avoid jitter caused by vr controllers
        this._sceneRenderObserver = ownerNode.getScene().onBeforeRenderObservable.add(function () {
            if (_this._dragBehaviorA.dragging && _this._dragBehaviorB.dragging) {
                var change = _this._targetScale.subtract(ownerNode.scaling).scaleInPlace(0.1);
                if (change.length() > 0.01) {
                    ownerNode.scaling.addInPlace(change);
                }
            }
        });
    };
    /**
     *  Detaches the behavior from the mesh
     */
    MultiPointerScaleBehavior.prototype.detach = function () {
        var _this = this;
        this._ownerNode.getScene().onBeforeRenderObservable.remove(this._sceneRenderObserver);
        [this._dragBehaviorA, this._dragBehaviorB].forEach(function (behavior) {
            behavior.onDragStartObservable.clear();
            behavior.onDragObservable.clear();
            _this._ownerNode.removeBehavior(behavior);
        });
    };
    return MultiPointerScaleBehavior;
}());

//# sourceMappingURL=multiPointerScaleBehavior.js.map

/***/ }),

/***/ "./node_modules/@babylonjs/core/Behaviors/Meshes/pointerDragBehavior.js":
/*!******************************************************************************!*\
  !*** ./node_modules/@babylonjs/core/Behaviors/Meshes/pointerDragBehavior.js ***!
  \******************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "PointerDragBehavior": () => (/* binding */ PointerDragBehavior)
/* harmony export */ });
/* harmony import */ var _Meshes_mesh__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../Meshes/mesh */ "./node_modules/@babylonjs/core/Meshes/mesh.js");
/* harmony import */ var _scene__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../scene */ "./node_modules/@babylonjs/core/scene.js");
/* harmony import */ var _Misc_observable__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../Misc/observable */ "./node_modules/@babylonjs/core/Misc/observable.js");
/* harmony import */ var _Maths_math_vector__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../Maths/math.vector */ "./node_modules/@babylonjs/core/Maths/math.vector.js");
/* harmony import */ var _Events_pointerEvents__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../Events/pointerEvents */ "./node_modules/@babylonjs/core/Events/pointerEvents.js");
/* harmony import */ var _Culling_ray__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../Culling/ray */ "./node_modules/@babylonjs/core/Culling/ray.js");
/* harmony import */ var _Misc_pivotTools__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../Misc/pivotTools */ "./node_modules/@babylonjs/core/Misc/pivotTools.js");
/* harmony import */ var _Meshes_Builders_planeBuilder__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../Meshes/Builders/planeBuilder */ "./node_modules/@babylonjs/core/Meshes/Builders/planeBuilder.js");








/**
 * A behavior that when attached to a mesh will allow the mesh to be dragged around the screen based on pointer events
 */
var PointerDragBehavior = /** @class */ (function () {
    /**
     * Creates a pointer drag behavior that can be attached to a mesh
     * @param options The drag axis or normal of the plane that will be dragged across. If no options are specified the drag plane will always face the ray's origin (eg. camera)
     */
    function PointerDragBehavior(options) {
        this._useAlternatePickedPointAboveMaxDragAngleDragSpeed = -1.1;
        /**
         * The maximum tolerated angle between the drag plane and dragging pointer rays to trigger pointer events. Set to 0 to allow any angle (default: 0)
         */
        this.maxDragAngle = 0;
        /**
         * @hidden
         */
        this._useAlternatePickedPointAboveMaxDragAngle = false;
        /**
         * The id of the pointer that is currently interacting with the behavior (-1 when no pointer is active)
         */
        this.currentDraggingPointerID = -1;
        /**
         * If the behavior is currently in a dragging state
         */
        this.dragging = false;
        /**
         * The distance towards the target drag position to move each frame. This can be useful to avoid jitter. Set this to 1 for no delay. (Default: 0.2)
         */
        this.dragDeltaRatio = 0.2;
        /**
         * If the drag plane orientation should be updated during the dragging (Default: true)
         */
        this.updateDragPlane = true;
        // Debug mode will display drag planes to help visualize behavior
        this._debugMode = false;
        this._moving = false;
        /**
         *  Fires each time the attached mesh is dragged with the pointer
         *  * delta between last drag position and current drag position in world space
         *  * dragDistance along the drag axis
         *  * dragPlaneNormal normal of the current drag plane used during the drag
         *  * dragPlanePoint in world space where the drag intersects the drag plane
         */
        this.onDragObservable = new _Misc_observable__WEBPACK_IMPORTED_MODULE_2__.Observable();
        /**
         *  Fires each time a drag begins (eg. mouse down on mesh)
         */
        this.onDragStartObservable = new _Misc_observable__WEBPACK_IMPORTED_MODULE_2__.Observable();
        /**
         *  Fires each time a drag ends (eg. mouse release after drag)
         */
        this.onDragEndObservable = new _Misc_observable__WEBPACK_IMPORTED_MODULE_2__.Observable();
        /**
         *  If the attached mesh should be moved when dragged
         */
        this.moveAttached = true;
        /**
         *  If the drag behavior will react to drag events (Default: true)
         */
        this.enabled = true;
        /**
         * If pointer events should start and release the drag (Default: true)
         */
        this.startAndReleaseDragOnPointerEvents = true;
        /**
         * If camera controls should be detached during the drag
         */
        this.detachCameraControls = true;
        /**
         * If set, the drag plane/axis will be rotated based on the attached mesh's world rotation (Default: true)
         */
        this.useObjectOrientationForDragging = true;
        /**
         * Predicate to determine if it is valid to move the object to a new position when it is moved
         */
        this.validateDrag = function (targetPosition) { return true; };
        this._tmpVector = new _Maths_math_vector__WEBPACK_IMPORTED_MODULE_3__.Vector3(0, 0, 0);
        this._alternatePickedPoint = new _Maths_math_vector__WEBPACK_IMPORTED_MODULE_3__.Vector3(0, 0, 0);
        this._worldDragAxis = new _Maths_math_vector__WEBPACK_IMPORTED_MODULE_3__.Vector3(0, 0, 0);
        this._targetPosition = new _Maths_math_vector__WEBPACK_IMPORTED_MODULE_3__.Vector3(0, 0, 0);
        this._attachedElement = null;
        this._startDragRay = new _Culling_ray__WEBPACK_IMPORTED_MODULE_5__.Ray(new _Maths_math_vector__WEBPACK_IMPORTED_MODULE_3__.Vector3(), new _Maths_math_vector__WEBPACK_IMPORTED_MODULE_3__.Vector3());
        this._lastPointerRay = {};
        this._dragDelta = new _Maths_math_vector__WEBPACK_IMPORTED_MODULE_3__.Vector3();
        // Variables to avoid instantiation in the below method
        this._pointA = new _Maths_math_vector__WEBPACK_IMPORTED_MODULE_3__.Vector3(0, 0, 0);
        this._pointB = new _Maths_math_vector__WEBPACK_IMPORTED_MODULE_3__.Vector3(0, 0, 0);
        this._pointC = new _Maths_math_vector__WEBPACK_IMPORTED_MODULE_3__.Vector3(0, 0, 0);
        this._lineA = new _Maths_math_vector__WEBPACK_IMPORTED_MODULE_3__.Vector3(0, 0, 0);
        this._lineB = new _Maths_math_vector__WEBPACK_IMPORTED_MODULE_3__.Vector3(0, 0, 0);
        this._localAxis = new _Maths_math_vector__WEBPACK_IMPORTED_MODULE_3__.Vector3(0, 0, 0);
        this._lookAt = new _Maths_math_vector__WEBPACK_IMPORTED_MODULE_3__.Vector3(0, 0, 0);
        this._options = options ? options : {};
        var optionCount = 0;
        if (this._options.dragAxis) {
            optionCount++;
        }
        if (this._options.dragPlaneNormal) {
            optionCount++;
        }
        if (optionCount > 1) {
            throw "Multiple drag modes specified in dragBehavior options. Only one expected";
        }
    }
    Object.defineProperty(PointerDragBehavior.prototype, "options", {
        /**
         * Gets the options used by the behavior
         */
        get: function () {
            return this._options;
        },
        /**
         * Sets the options used by the behavior
         */
        set: function (options) {
            this._options = options;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(PointerDragBehavior.prototype, "name", {
        /**
         *  The name of the behavior
         */
        get: function () {
            return "PointerDrag";
        },
        enumerable: true,
        configurable: true
    });
    /**
     *  Initializes the behavior
     */
    PointerDragBehavior.prototype.init = function () { };
    /**
     * Attaches the drag behavior the passed in mesh
     * @param ownerNode The mesh that will be dragged around once attached
     * @param predicate Predicate to use for pick filtering
     */
    PointerDragBehavior.prototype.attach = function (ownerNode, predicate) {
        var _this = this;
        this._scene = ownerNode.getScene();
        this.attachedNode = ownerNode;
        // Initialize drag plane to not interfere with existing scene
        if (!PointerDragBehavior._planeScene) {
            if (this._debugMode) {
                PointerDragBehavior._planeScene = this._scene;
            }
            else {
                PointerDragBehavior._planeScene = new _scene__WEBPACK_IMPORTED_MODULE_1__.Scene(this._scene.getEngine(), { virtual: true });
                PointerDragBehavior._planeScene.detachControl();
                this._scene.onDisposeObservable.addOnce(function () {
                    PointerDragBehavior._planeScene.dispose();
                    PointerDragBehavior._planeScene = null;
                });
            }
        }
        this._dragPlane = _Meshes_mesh__WEBPACK_IMPORTED_MODULE_0__.Mesh.CreatePlane("pointerDragPlane", this._debugMode ? 1 : 10000, PointerDragBehavior._planeScene, false, _Meshes_mesh__WEBPACK_IMPORTED_MODULE_0__.Mesh.DOUBLESIDE);
        // State of the drag
        this.lastDragPosition = new _Maths_math_vector__WEBPACK_IMPORTED_MODULE_3__.Vector3(0, 0, 0);
        var pickPredicate = !!predicate ? predicate : function (m) {
            return _this.attachedNode == m || m.isDescendantOf(_this.attachedNode);
        };
        this._pointerObserver = this._scene.onPointerObservable.add(function (pointerInfo, eventState) {
            if (!_this.enabled) {
                return;
            }
            if (pointerInfo.type == _Events_pointerEvents__WEBPACK_IMPORTED_MODULE_4__.PointerEventTypes.POINTERDOWN) {
                if (_this.startAndReleaseDragOnPointerEvents && !_this.dragging && pointerInfo.pickInfo && pointerInfo.pickInfo.hit && pointerInfo.pickInfo.pickedMesh && pointerInfo.pickInfo.pickedPoint && pointerInfo.pickInfo.ray && pickPredicate(pointerInfo.pickInfo.pickedMesh)) {
                    _this._startDrag(pointerInfo.event.pointerId, pointerInfo.pickInfo.ray, pointerInfo.pickInfo.pickedPoint);
                }
            }
            else if (pointerInfo.type == _Events_pointerEvents__WEBPACK_IMPORTED_MODULE_4__.PointerEventTypes.POINTERUP) {
                if (_this.startAndReleaseDragOnPointerEvents && _this.currentDraggingPointerID == pointerInfo.event.pointerId) {
                    _this.releaseDrag();
                }
            }
            else if (pointerInfo.type == _Events_pointerEvents__WEBPACK_IMPORTED_MODULE_4__.PointerEventTypes.POINTERMOVE) {
                var pointerId = pointerInfo.event.pointerId;
                // If drag was started with anyMouseID specified, set pointerID to the next mouse that moved
                if (_this.currentDraggingPointerID === PointerDragBehavior._AnyMouseID && pointerId !== PointerDragBehavior._AnyMouseID && pointerInfo.event.pointerType == "mouse") {
                    if (_this._lastPointerRay[_this.currentDraggingPointerID]) {
                        _this._lastPointerRay[pointerId] = _this._lastPointerRay[_this.currentDraggingPointerID];
                        delete _this._lastPointerRay[_this.currentDraggingPointerID];
                    }
                    _this.currentDraggingPointerID = pointerId;
                }
                // Keep track of last pointer ray, this is used simulating the start of a drag in startDrag()
                if (!_this._lastPointerRay[pointerId]) {
                    _this._lastPointerRay[pointerId] = new _Culling_ray__WEBPACK_IMPORTED_MODULE_5__.Ray(new _Maths_math_vector__WEBPACK_IMPORTED_MODULE_3__.Vector3(), new _Maths_math_vector__WEBPACK_IMPORTED_MODULE_3__.Vector3());
                }
                if (pointerInfo.pickInfo && pointerInfo.pickInfo.ray) {
                    _this._lastPointerRay[pointerId].origin.copyFrom(pointerInfo.pickInfo.ray.origin);
                    _this._lastPointerRay[pointerId].direction.copyFrom(pointerInfo.pickInfo.ray.direction);
                    if (_this.currentDraggingPointerID == pointerId && _this.dragging) {
                        _this._moveDrag(pointerInfo.pickInfo.ray);
                    }
                }
            }
        });
        this._beforeRenderObserver = this._scene.onBeforeRenderObservable.add(function () {
            if (_this._moving && _this.moveAttached) {
                _Misc_pivotTools__WEBPACK_IMPORTED_MODULE_6__.PivotTools._RemoveAndStorePivotPoint(_this.attachedNode);
                // Slowly move mesh to avoid jitter
                _this._targetPosition.subtractToRef((_this.attachedNode).absolutePosition, _this._tmpVector);
                _this._tmpVector.scaleInPlace(_this.dragDeltaRatio);
                (_this.attachedNode).getAbsolutePosition().addToRef(_this._tmpVector, _this._tmpVector);
                if (_this.validateDrag(_this._tmpVector)) {
                    (_this.attachedNode).setAbsolutePosition(_this._tmpVector);
                }
                _Misc_pivotTools__WEBPACK_IMPORTED_MODULE_6__.PivotTools._RestorePivotPoint(_this.attachedNode);
            }
        });
    };
    /**
     * Force relase the drag action by code.
     */
    PointerDragBehavior.prototype.releaseDrag = function () {
        if (this.dragging) {
            this.onDragEndObservable.notifyObservers({ dragPlanePoint: this.lastDragPosition, pointerId: this.currentDraggingPointerID });
            this.dragging = false;
        }
        this.currentDraggingPointerID = -1;
        this._moving = false;
        // Reattach camera controls
        if (this.detachCameraControls && this._attachedElement && this._scene.activeCamera && !this._scene.activeCamera.leftCamera) {
            this._scene.activeCamera.attachControl(this._attachedElement, this._scene.activeCamera.inputs ? this._scene.activeCamera.inputs.noPreventDefault : true);
        }
    };
    /**
     * Simulates the start of a pointer drag event on the behavior
     * @param pointerId pointerID of the pointer that should be simulated (Default: Any mouse pointer ID)
     * @param fromRay initial ray of the pointer to be simulated (Default: Ray from camera to attached mesh)
     * @param startPickedPoint picked point of the pointer to be simulated (Default: attached mesh position)
     */
    PointerDragBehavior.prototype.startDrag = function (pointerId, fromRay, startPickedPoint) {
        if (pointerId === void 0) { pointerId = PointerDragBehavior._AnyMouseID; }
        this._startDrag(pointerId, fromRay, startPickedPoint);
        var lastRay = this._lastPointerRay[pointerId];
        if (pointerId === PointerDragBehavior._AnyMouseID) {
            lastRay = this._lastPointerRay[Object.keys(this._lastPointerRay)[0]];
        }
        if (lastRay) {
            // if there was a last pointer ray drag the object there
            this._moveDrag(lastRay);
        }
    };
    PointerDragBehavior.prototype._startDrag = function (pointerId, fromRay, startPickedPoint) {
        if (!this._scene.activeCamera || this.dragging || !this.attachedNode) {
            return;
        }
        _Misc_pivotTools__WEBPACK_IMPORTED_MODULE_6__.PivotTools._RemoveAndStorePivotPoint(this.attachedNode);
        // Create start ray from the camera to the object
        if (fromRay) {
            this._startDragRay.direction.copyFrom(fromRay.direction);
            this._startDragRay.origin.copyFrom(fromRay.origin);
        }
        else {
            this._startDragRay.origin.copyFrom(this._scene.activeCamera.position);
            this.attachedNode.getWorldMatrix().getTranslationToRef(this._tmpVector);
            this._tmpVector.subtractToRef(this._scene.activeCamera.position, this._startDragRay.direction);
        }
        this._updateDragPlanePosition(this._startDragRay, startPickedPoint ? startPickedPoint : this._tmpVector);
        var pickedPoint = this._pickWithRayOnDragPlane(this._startDragRay);
        if (pickedPoint) {
            this.dragging = true;
            this.currentDraggingPointerID = pointerId;
            this.lastDragPosition.copyFrom(pickedPoint);
            this.onDragStartObservable.notifyObservers({ dragPlanePoint: pickedPoint, pointerId: this.currentDraggingPointerID });
            this._targetPosition.copyFrom((this.attachedNode).absolutePosition);
            // Detatch camera controls
            if (this.detachCameraControls && this._scene.activeCamera && this._scene.activeCamera.inputs && !this._scene.activeCamera.leftCamera) {
                if (this._scene.activeCamera.inputs.attachedElement) {
                    this._attachedElement = this._scene.activeCamera.inputs.attachedElement;
                    this._scene.activeCamera.detachControl(this._scene.activeCamera.inputs.attachedElement);
                }
                else {
                    this._attachedElement = null;
                }
            }
        }
        _Misc_pivotTools__WEBPACK_IMPORTED_MODULE_6__.PivotTools._RestorePivotPoint(this.attachedNode);
    };
    PointerDragBehavior.prototype._moveDrag = function (ray) {
        this._moving = true;
        var pickedPoint = this._pickWithRayOnDragPlane(ray);
        if (pickedPoint) {
            if (this.updateDragPlane) {
                this._updateDragPlanePosition(ray, pickedPoint);
            }
            var dragLength = 0;
            // depending on the drag mode option drag accordingly
            if (this._options.dragAxis) {
                // Convert local drag axis to world if useObjectOrientationForDragging
                this.useObjectOrientationForDragging ? _Maths_math_vector__WEBPACK_IMPORTED_MODULE_3__.Vector3.TransformCoordinatesToRef(this._options.dragAxis, this.attachedNode.getWorldMatrix().getRotationMatrix(), this._worldDragAxis) : this._worldDragAxis.copyFrom(this._options.dragAxis);
                // Project delta drag from the drag plane onto the drag axis
                pickedPoint.subtractToRef(this.lastDragPosition, this._tmpVector);
                dragLength = _Maths_math_vector__WEBPACK_IMPORTED_MODULE_3__.Vector3.Dot(this._tmpVector, this._worldDragAxis);
                this._worldDragAxis.scaleToRef(dragLength, this._dragDelta);
            }
            else {
                dragLength = this._dragDelta.length();
                pickedPoint.subtractToRef(this.lastDragPosition, this._dragDelta);
            }
            this._targetPosition.addInPlace(this._dragDelta);
            this.onDragObservable.notifyObservers({ dragDistance: dragLength, delta: this._dragDelta, dragPlanePoint: pickedPoint, dragPlaneNormal: this._dragPlane.forward, pointerId: this.currentDraggingPointerID });
            this.lastDragPosition.copyFrom(pickedPoint);
        }
    };
    PointerDragBehavior.prototype._pickWithRayOnDragPlane = function (ray) {
        var _this = this;
        if (!ray) {
            return null;
        }
        // Calculate angle between plane normal and ray
        var angle = Math.acos(_Maths_math_vector__WEBPACK_IMPORTED_MODULE_3__.Vector3.Dot(this._dragPlane.forward, ray.direction));
        // Correct if ray is casted from oposite side
        if (angle > Math.PI / 2) {
            angle = Math.PI - angle;
        }
        // If the angle is too perpendicular to the plane pick another point on the plane where it is looking
        if (this.maxDragAngle > 0 && angle > this.maxDragAngle) {
            if (this._useAlternatePickedPointAboveMaxDragAngle) {
                // Invert ray direction along the towards object axis
                this._tmpVector.copyFrom(ray.direction);
                (this.attachedNode).absolutePosition.subtractToRef(ray.origin, this._alternatePickedPoint);
                this._alternatePickedPoint.normalize();
                this._alternatePickedPoint.scaleInPlace(this._useAlternatePickedPointAboveMaxDragAngleDragSpeed * _Maths_math_vector__WEBPACK_IMPORTED_MODULE_3__.Vector3.Dot(this._alternatePickedPoint, this._tmpVector));
                this._tmpVector.addInPlace(this._alternatePickedPoint);
                // Project resulting vector onto the drag plane and add it to the attached nodes absolute position to get a picked point
                var dot = _Maths_math_vector__WEBPACK_IMPORTED_MODULE_3__.Vector3.Dot(this._dragPlane.forward, this._tmpVector);
                this._dragPlane.forward.scaleToRef(-dot, this._alternatePickedPoint);
                this._alternatePickedPoint.addInPlace(this._tmpVector);
                this._alternatePickedPoint.addInPlace((this.attachedNode).absolutePosition);
                return this._alternatePickedPoint;
            }
            else {
                return null;
            }
        }
        var pickResult = PointerDragBehavior._planeScene.pickWithRay(ray, function (m) { return m == _this._dragPlane; });
        if (pickResult && pickResult.hit && pickResult.pickedMesh && pickResult.pickedPoint) {
            return pickResult.pickedPoint;
        }
        else {
            return null;
        }
    };
    // Position the drag plane based on the attached mesh position, for single axis rotate the plane along the axis to face the camera
    PointerDragBehavior.prototype._updateDragPlanePosition = function (ray, dragPlanePosition) {
        this._pointA.copyFrom(dragPlanePosition);
        if (this._options.dragAxis) {
            this.useObjectOrientationForDragging ? _Maths_math_vector__WEBPACK_IMPORTED_MODULE_3__.Vector3.TransformCoordinatesToRef(this._options.dragAxis, this.attachedNode.getWorldMatrix().getRotationMatrix(), this._localAxis) : this._localAxis.copyFrom(this._options.dragAxis);
            // Calculate plane normal in direction of camera but perpendicular to drag axis
            this._pointA.addToRef(this._localAxis, this._pointB); // towards drag axis
            ray.origin.subtractToRef(this._pointA, this._pointC);
            this._pointA.addToRef(this._pointC.normalize(), this._pointC); // towards camera
            // Get perpendicular line from direction to camera and drag axis
            this._pointB.subtractToRef(this._pointA, this._lineA);
            this._pointC.subtractToRef(this._pointA, this._lineB);
            _Maths_math_vector__WEBPACK_IMPORTED_MODULE_3__.Vector3.CrossToRef(this._lineA, this._lineB, this._lookAt);
            // Get perpendicular line from previous result and drag axis to adjust lineB to be perpendiculat to camera
            _Maths_math_vector__WEBPACK_IMPORTED_MODULE_3__.Vector3.CrossToRef(this._lineA, this._lookAt, this._lookAt);
            this._lookAt.normalize();
            this._dragPlane.position.copyFrom(this._pointA);
            this._pointA.addToRef(this._lookAt, this._lookAt);
            this._dragPlane.lookAt(this._lookAt);
        }
        else if (this._options.dragPlaneNormal) {
            this.useObjectOrientationForDragging ? _Maths_math_vector__WEBPACK_IMPORTED_MODULE_3__.Vector3.TransformCoordinatesToRef(this._options.dragPlaneNormal, this.attachedNode.getWorldMatrix().getRotationMatrix(), this._localAxis) : this._localAxis.copyFrom(this._options.dragPlaneNormal);
            this._dragPlane.position.copyFrom(this._pointA);
            this._pointA.addToRef(this._localAxis, this._lookAt);
            this._dragPlane.lookAt(this._lookAt);
        }
        else {
            this._dragPlane.position.copyFrom(this._pointA);
            this._dragPlane.lookAt(ray.origin);
        }
        // Update the position of the drag plane so it doesn't get out of sync with the node (eg. when moving back and forth quickly)
        this._dragPlane.position.copyFrom(this.attachedNode.absolutePosition);
        this._dragPlane.computeWorldMatrix(true);
    };
    /**
     *  Detaches the behavior from the mesh
     */
    PointerDragBehavior.prototype.detach = function () {
        if (this._pointerObserver) {
            this._scene.onPointerObservable.remove(this._pointerObserver);
        }
        if (this._beforeRenderObserver) {
            this._scene.onBeforeRenderObservable.remove(this._beforeRenderObserver);
        }
        this.releaseDrag();
    };
    PointerDragBehavior._AnyMouseID = -2;
    return PointerDragBehavior;
}());

//# sourceMappingURL=pointerDragBehavior.js.map

/***/ }),

/***/ "./node_modules/@babylonjs/core/Behaviors/Meshes/sixDofDragBehavior.js":
/*!*****************************************************************************!*\
  !*** ./node_modules/@babylonjs/core/Behaviors/Meshes/sixDofDragBehavior.js ***!
  \*****************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "SixDofDragBehavior": () => (/* binding */ SixDofDragBehavior)
/* harmony export */ });
/* harmony import */ var _Meshes_abstractMesh__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../Meshes/abstractMesh */ "./node_modules/@babylonjs/core/Meshes/abstractMesh.js");
/* harmony import */ var _scene__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../scene */ "./node_modules/@babylonjs/core/scene.js");
/* harmony import */ var _Events_pointerEvents__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../Events/pointerEvents */ "./node_modules/@babylonjs/core/Events/pointerEvents.js");
/* harmony import */ var _Maths_math_vector__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../Maths/math.vector */ "./node_modules/@babylonjs/core/Maths/math.vector.js");
/* harmony import */ var _Misc_observable__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../Misc/observable */ "./node_modules/@babylonjs/core/Misc/observable.js");
/* harmony import */ var _Cameras_camera__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../Cameras/camera */ "./node_modules/@babylonjs/core/Cameras/camera.js");
/* harmony import */ var _Misc_pivotTools__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../Misc/pivotTools */ "./node_modules/@babylonjs/core/Misc/pivotTools.js");







/**
 * A behavior that when attached to a mesh will allow the mesh to be dragged around based on directions and origin of the pointer's ray
 */
var SixDofDragBehavior = /** @class */ (function () {
    /**
     * Instantiates a behavior that when attached to a mesh will allow the mesh to be dragged around based on directions and origin of the pointer's ray
     */
    function SixDofDragBehavior() {
        this._sceneRenderObserver = null;
        this._targetPosition = new _Maths_math_vector__WEBPACK_IMPORTED_MODULE_3__.Vector3(0, 0, 0);
        this._moving = false;
        this._startingOrientation = new _Maths_math_vector__WEBPACK_IMPORTED_MODULE_3__.Quaternion();
        /**
         * How much faster the object should move when the controller is moving towards it. This is useful to bring objects that are far away from the user to them faster. Set this to 0 to avoid any speed increase. (Default: 3)
         */
        this.zDragFactor = 3;
        /**
         * If the object should rotate to face the drag origin
         */
        this.rotateDraggedObject = true;
        /**
         * If the behavior is currently in a dragging state
         */
        this.dragging = false;
        /**
         * The distance towards the target drag position to move each frame. This can be useful to avoid jitter. Set this to 1 for no delay. (Default: 0.2)
         */
        this.dragDeltaRatio = 0.2;
        /**
         * The id of the pointer that is currently interacting with the behavior (-1 when no pointer is active)
         */
        this.currentDraggingPointerID = -1;
        /**
         * If camera controls should be detached during the drag
         */
        this.detachCameraControls = true;
        /**
         * Fires each time a drag starts
         */
        this.onDragStartObservable = new _Misc_observable__WEBPACK_IMPORTED_MODULE_4__.Observable();
        /**
         *  Fires each time a drag ends (eg. mouse release after drag)
         */
        this.onDragEndObservable = new _Misc_observable__WEBPACK_IMPORTED_MODULE_4__.Observable();
    }
    Object.defineProperty(SixDofDragBehavior.prototype, "name", {
        /**
         *  The name of the behavior
         */
        get: function () {
            return "SixDofDrag";
        },
        enumerable: true,
        configurable: true
    });
    /**
     *  Initializes the behavior
     */
    SixDofDragBehavior.prototype.init = function () { };
    Object.defineProperty(SixDofDragBehavior.prototype, "_pointerCamera", {
        /**
         * In the case of multiplea active cameras, the cameraToUseForPointers should be used if set instead of active camera
         */
        get: function () {
            if (this._scene.cameraToUseForPointers) {
                return this._scene.cameraToUseForPointers;
            }
            else {
                return this._scene.activeCamera;
            }
        },
        enumerable: true,
        configurable: true
    });
    /**
     * Attaches the scale behavior the passed in mesh
     * @param ownerNode The mesh that will be scaled around once attached
     */
    SixDofDragBehavior.prototype.attach = function (ownerNode) {
        var _this = this;
        this._ownerNode = ownerNode;
        this._scene = this._ownerNode.getScene();
        if (!SixDofDragBehavior._virtualScene) {
            SixDofDragBehavior._virtualScene = new _scene__WEBPACK_IMPORTED_MODULE_1__.Scene(this._scene.getEngine());
            SixDofDragBehavior._virtualScene.detachControl();
            this._scene.getEngine().scenes.pop();
        }
        var pickedMesh = null;
        var lastSixDofOriginPosition = new _Maths_math_vector__WEBPACK_IMPORTED_MODULE_3__.Vector3(0, 0, 0);
        // Setup virtual meshes to be used for dragging without dirtying the existing scene
        this._virtualOriginMesh = new _Meshes_abstractMesh__WEBPACK_IMPORTED_MODULE_0__.AbstractMesh("", SixDofDragBehavior._virtualScene);
        this._virtualOriginMesh.rotationQuaternion = new _Maths_math_vector__WEBPACK_IMPORTED_MODULE_3__.Quaternion();
        this._virtualDragMesh = new _Meshes_abstractMesh__WEBPACK_IMPORTED_MODULE_0__.AbstractMesh("", SixDofDragBehavior._virtualScene);
        this._virtualDragMesh.rotationQuaternion = new _Maths_math_vector__WEBPACK_IMPORTED_MODULE_3__.Quaternion();
        var pickPredicate = function (m) {
            return _this._ownerNode == m || m.isDescendantOf(_this._ownerNode);
        };
        var attachedElement = null;
        this._pointerObserver = this._scene.onPointerObservable.add(function (pointerInfo, eventState) {
            if (pointerInfo.type == _Events_pointerEvents__WEBPACK_IMPORTED_MODULE_2__.PointerEventTypes.POINTERDOWN) {
                if (!_this.dragging && pointerInfo.pickInfo && pointerInfo.pickInfo.hit && pointerInfo.pickInfo.pickedMesh && pointerInfo.pickInfo.ray && pickPredicate(pointerInfo.pickInfo.pickedMesh)) {
                    if (_this._pointerCamera && _this._pointerCamera.cameraRigMode == _Cameras_camera__WEBPACK_IMPORTED_MODULE_5__.Camera.RIG_MODE_NONE) {
                        pointerInfo.pickInfo.ray.origin.copyFrom(_this._pointerCamera.globalPosition);
                    }
                    pickedMesh = _this._ownerNode;
                    _Misc_pivotTools__WEBPACK_IMPORTED_MODULE_6__.PivotTools._RemoveAndStorePivotPoint(pickedMesh);
                    lastSixDofOriginPosition.copyFrom(pointerInfo.pickInfo.ray.origin);
                    // Set position and orientation of the controller
                    _this._virtualOriginMesh.position.copyFrom(pointerInfo.pickInfo.ray.origin);
                    _this._virtualOriginMesh.lookAt(pointerInfo.pickInfo.ray.origin.add(pointerInfo.pickInfo.ray.direction));
                    // Attach the virtual drag mesh to the virtual origin mesh so it can be dragged
                    _this._virtualOriginMesh.removeChild(_this._virtualDragMesh);
                    pickedMesh.computeWorldMatrix();
                    _this._virtualDragMesh.position.copyFrom(pickedMesh.absolutePosition);
                    if (!pickedMesh.rotationQuaternion) {
                        pickedMesh.rotationQuaternion = _Maths_math_vector__WEBPACK_IMPORTED_MODULE_3__.Quaternion.RotationYawPitchRoll(pickedMesh.rotation.y, pickedMesh.rotation.x, pickedMesh.rotation.z);
                    }
                    var oldParent = pickedMesh.parent;
                    pickedMesh.setParent(null);
                    _this._virtualDragMesh.rotationQuaternion.copyFrom(pickedMesh.rotationQuaternion);
                    pickedMesh.setParent(oldParent);
                    _this._virtualOriginMesh.addChild(_this._virtualDragMesh);
                    // Update state
                    _this._targetPosition.copyFrom(_this._virtualDragMesh.absolutePosition);
                    _this.dragging = true;
                    _this.currentDraggingPointerID = pointerInfo.event.pointerId;
                    // Detatch camera controls
                    if (_this.detachCameraControls && _this._pointerCamera && !_this._pointerCamera.leftCamera) {
                        if (_this._pointerCamera.inputs.attachedElement) {
                            attachedElement = _this._pointerCamera.inputs.attachedElement;
                            _this._pointerCamera.detachControl(_this._pointerCamera.inputs.attachedElement);
                        }
                        else {
                            attachedElement = null;
                        }
                    }
                    _Misc_pivotTools__WEBPACK_IMPORTED_MODULE_6__.PivotTools._RestorePivotPoint(pickedMesh);
                    _this.onDragStartObservable.notifyObservers({});
                }
            }
            else if (pointerInfo.type == _Events_pointerEvents__WEBPACK_IMPORTED_MODULE_2__.PointerEventTypes.POINTERUP) {
                if (_this.currentDraggingPointerID == pointerInfo.event.pointerId) {
                    _this.dragging = false;
                    _this._moving = false;
                    _this.currentDraggingPointerID = -1;
                    pickedMesh = null;
                    _this._virtualOriginMesh.removeChild(_this._virtualDragMesh);
                    // Reattach camera controls
                    if (_this.detachCameraControls && attachedElement && _this._pointerCamera && !_this._pointerCamera.leftCamera) {
                        _this._pointerCamera.attachControl(attachedElement, true);
                    }
                    _this.onDragEndObservable.notifyObservers({});
                }
            }
            else if (pointerInfo.type == _Events_pointerEvents__WEBPACK_IMPORTED_MODULE_2__.PointerEventTypes.POINTERMOVE) {
                if (_this.currentDraggingPointerID == pointerInfo.event.pointerId && _this.dragging && pointerInfo.pickInfo && pointerInfo.pickInfo.ray && pickedMesh) {
                    var zDragFactor = _this.zDragFactor;
                    if (_this._pointerCamera && _this._pointerCamera.cameraRigMode == _Cameras_camera__WEBPACK_IMPORTED_MODULE_5__.Camera.RIG_MODE_NONE) {
                        pointerInfo.pickInfo.ray.origin.copyFrom(_this._pointerCamera.globalPosition);
                        zDragFactor = 0;
                    }
                    // Calculate controller drag distance in controller space
                    var originDragDifference = pointerInfo.pickInfo.ray.origin.subtract(lastSixDofOriginPosition);
                    lastSixDofOriginPosition.copyFrom(pointerInfo.pickInfo.ray.origin);
                    var localOriginDragDifference = -_Maths_math_vector__WEBPACK_IMPORTED_MODULE_3__.Vector3.Dot(originDragDifference, pointerInfo.pickInfo.ray.direction);
                    _this._virtualOriginMesh.addChild(_this._virtualDragMesh);
                    // Determine how much the controller moved to/away towards the dragged object and use this to move the object further when its further away
                    _this._virtualDragMesh.position.z -= _this._virtualDragMesh.position.z < 1 ? localOriginDragDifference * _this.zDragFactor : localOriginDragDifference * zDragFactor * _this._virtualDragMesh.position.z;
                    if (_this._virtualDragMesh.position.z < 0) {
                        _this._virtualDragMesh.position.z = 0;
                    }
                    // Update the controller position
                    _this._virtualOriginMesh.position.copyFrom(pointerInfo.pickInfo.ray.origin);
                    _this._virtualOriginMesh.lookAt(pointerInfo.pickInfo.ray.origin.add(pointerInfo.pickInfo.ray.direction));
                    _this._virtualOriginMesh.removeChild(_this._virtualDragMesh);
                    // Move the virtualObjectsPosition into the picked mesh's space if needed
                    _this._targetPosition.copyFrom(_this._virtualDragMesh.absolutePosition);
                    if (pickedMesh.parent) {
                        _Maths_math_vector__WEBPACK_IMPORTED_MODULE_3__.Vector3.TransformCoordinatesToRef(_this._targetPosition, _Maths_math_vector__WEBPACK_IMPORTED_MODULE_3__.Matrix.Invert(pickedMesh.parent.getWorldMatrix()), _this._targetPosition);
                    }
                    if (!_this._moving) {
                        _this._startingOrientation.copyFrom(_this._virtualDragMesh.rotationQuaternion);
                    }
                    _this._moving = true;
                }
            }
        });
        var tmpQuaternion = new _Maths_math_vector__WEBPACK_IMPORTED_MODULE_3__.Quaternion();
        // On every frame move towards target scaling to avoid jitter caused by vr controllers
        this._sceneRenderObserver = ownerNode.getScene().onBeforeRenderObservable.add(function () {
            if (_this.dragging && _this._moving && pickedMesh) {
                _Misc_pivotTools__WEBPACK_IMPORTED_MODULE_6__.PivotTools._RemoveAndStorePivotPoint(pickedMesh);
                // Slowly move mesh to avoid jitter
                pickedMesh.position.addInPlace(_this._targetPosition.subtract(pickedMesh.position).scale(_this.dragDeltaRatio));
                if (_this.rotateDraggedObject) {
                    // Get change in rotation
                    tmpQuaternion.copyFrom(_this._startingOrientation);
                    tmpQuaternion.x = -tmpQuaternion.x;
                    tmpQuaternion.y = -tmpQuaternion.y;
                    tmpQuaternion.z = -tmpQuaternion.z;
                    _this._virtualDragMesh.rotationQuaternion.multiplyToRef(tmpQuaternion, tmpQuaternion);
                    // Convert change in rotation to only y axis rotation
                    _Maths_math_vector__WEBPACK_IMPORTED_MODULE_3__.Quaternion.RotationYawPitchRollToRef(tmpQuaternion.toEulerAngles("xyz").y, 0, 0, tmpQuaternion);
                    tmpQuaternion.multiplyToRef(_this._startingOrientation, tmpQuaternion);
                    // Slowly move mesh to avoid jitter
                    var oldParent = pickedMesh.parent;
                    // Only rotate the mesh if it's parent has uniform scaling
                    if (!oldParent || (oldParent.scaling && !oldParent.scaling.isNonUniformWithinEpsilon(0.001))) {
                        pickedMesh.setParent(null);
                        _Maths_math_vector__WEBPACK_IMPORTED_MODULE_3__.Quaternion.SlerpToRef(pickedMesh.rotationQuaternion, tmpQuaternion, _this.dragDeltaRatio, pickedMesh.rotationQuaternion);
                        pickedMesh.setParent(oldParent);
                    }
                }
                _Misc_pivotTools__WEBPACK_IMPORTED_MODULE_6__.PivotTools._RestorePivotPoint(pickedMesh);
            }
        });
    };
    /**
     *  Detaches the behavior from the mesh
     */
    SixDofDragBehavior.prototype.detach = function () {
        if (this._scene) {
            this._scene.onPointerObservable.remove(this._pointerObserver);
        }
        if (this._ownerNode) {
            this._ownerNode.getScene().onBeforeRenderObservable.remove(this._sceneRenderObserver);
        }
        if (this._virtualOriginMesh) {
            this._virtualOriginMesh.dispose();
        }
        if (this._virtualDragMesh) {
            this._virtualDragMesh.dispose();
        }
        this.onDragEndObservable.clear();
        this.onDragStartObservable.clear();
    };
    return SixDofDragBehavior;
}());

//# sourceMappingURL=sixDofDragBehavior.js.map

/***/ }),

/***/ "./node_modules/@babylonjs/core/Behaviors/index.js":
/*!*********************************************************!*\
  !*** ./node_modules/@babylonjs/core/Behaviors/index.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "AttachToBoxBehavior": () => (/* reexport safe */ _Meshes_index__WEBPACK_IMPORTED_MODULE_1__.AttachToBoxBehavior),
/* harmony export */   "AutoRotationBehavior": () => (/* reexport safe */ _Cameras_index__WEBPACK_IMPORTED_MODULE_0__.AutoRotationBehavior),
/* harmony export */   "BouncingBehavior": () => (/* reexport safe */ _Cameras_index__WEBPACK_IMPORTED_MODULE_0__.BouncingBehavior),
/* harmony export */   "FadeInOutBehavior": () => (/* reexport safe */ _Meshes_index__WEBPACK_IMPORTED_MODULE_1__.FadeInOutBehavior),
/* harmony export */   "FramingBehavior": () => (/* reexport safe */ _Cameras_index__WEBPACK_IMPORTED_MODULE_0__.FramingBehavior),
/* harmony export */   "MultiPointerScaleBehavior": () => (/* reexport safe */ _Meshes_index__WEBPACK_IMPORTED_MODULE_1__.MultiPointerScaleBehavior),
/* harmony export */   "PointerDragBehavior": () => (/* reexport safe */ _Meshes_index__WEBPACK_IMPORTED_MODULE_1__.PointerDragBehavior),
/* harmony export */   "SixDofDragBehavior": () => (/* reexport safe */ _Meshes_index__WEBPACK_IMPORTED_MODULE_1__.SixDofDragBehavior)
/* harmony export */ });
/* harmony import */ var _Cameras_index__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Cameras/index */ "./node_modules/@babylonjs/core/Behaviors/Cameras/index.js");
/* harmony import */ var _Meshes_index__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Meshes/index */ "./node_modules/@babylonjs/core/Behaviors/Meshes/index.js");


//# sourceMappingURL=index.js.map

/***/ }),

/***/ "./node_modules/@babylonjs/core/Bones/bone.js":
/*!****************************************************!*\
  !*** ./node_modules/@babylonjs/core/Bones/bone.js ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Bone": () => (/* binding */ Bone)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _Maths_math_vector__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../Maths/math.vector */ "./node_modules/@babylonjs/core/Maths/math.vector.js");
/* harmony import */ var _Misc_arrayTools__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Misc/arrayTools */ "./node_modules/@babylonjs/core/Misc/arrayTools.js");
/* harmony import */ var _node__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../node */ "./node_modules/@babylonjs/core/node.js");
/* harmony import */ var _Maths_math_axis__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../Maths/math.axis */ "./node_modules/@babylonjs/core/Maths/math.axis.js");





/**
 * Class used to store bone information
 * @see http://doc.babylonjs.com/how_to/how_to_use_bones_and_skeletons
 */
var Bone = /** @class */ (function (_super) {
    (0,tslib__WEBPACK_IMPORTED_MODULE_4__.__extends)(Bone, _super);
    /**
     * Create a new bone
     * @param name defines the bone name
     * @param skeleton defines the parent skeleton
     * @param parentBone defines the parent (can be null if the bone is the root)
     * @param localMatrix defines the local matrix
     * @param restPose defines the rest pose matrix
     * @param baseMatrix defines the base matrix
     * @param index defines index of the bone in the hiearchy
     */
    function Bone(
    /**
     * defines the bone name
     */
    name, skeleton, parentBone, localMatrix, restPose, baseMatrix, index) {
        if (parentBone === void 0) { parentBone = null; }
        if (localMatrix === void 0) { localMatrix = null; }
        if (restPose === void 0) { restPose = null; }
        if (baseMatrix === void 0) { baseMatrix = null; }
        if (index === void 0) { index = null; }
        var _this = _super.call(this, name, skeleton.getScene()) || this;
        _this.name = name;
        /**
         * Gets the list of child bones
         */
        _this.children = new Array();
        /** Gets the animations associated with this bone */
        _this.animations = new Array();
        /**
         * @hidden Internal only
         * Set this value to map this bone to a different index in the transform matrices
         * Set this value to -1 to exclude the bone from the transform matrices
         */
        _this._index = null;
        _this._absoluteTransform = new _Maths_math_vector__WEBPACK_IMPORTED_MODULE_0__.Matrix();
        _this._invertedAbsoluteTransform = new _Maths_math_vector__WEBPACK_IMPORTED_MODULE_0__.Matrix();
        _this._scalingDeterminant = 1;
        _this._worldTransform = new _Maths_math_vector__WEBPACK_IMPORTED_MODULE_0__.Matrix();
        _this._needToDecompose = true;
        _this._needToCompose = false;
        /** @hidden */
        _this._linkedTransformNode = null;
        /** @hidden */
        _this._waitingTransformNodeId = null;
        _this._skeleton = skeleton;
        _this._localMatrix = localMatrix ? localMatrix.clone() : _Maths_math_vector__WEBPACK_IMPORTED_MODULE_0__.Matrix.Identity();
        _this._restPose = restPose ? restPose : _this._localMatrix.clone();
        _this._baseMatrix = baseMatrix ? baseMatrix : _this._localMatrix.clone();
        _this._index = index;
        skeleton.bones.push(_this);
        _this.setParent(parentBone, false);
        if (baseMatrix || localMatrix) {
            _this._updateDifferenceMatrix();
        }
        return _this;
    }
    Object.defineProperty(Bone.prototype, "_matrix", {
        /** @hidden */
        get: function () {
            this._compose();
            return this._localMatrix;
        },
        /** @hidden */
        set: function (value) {
            this._localMatrix.copyFrom(value);
            this._needToDecompose = true;
        },
        enumerable: true,
        configurable: true
    });
    /**
     * Gets the current object class name.
     * @return the class name
     */
    Bone.prototype.getClassName = function () {
        return "Bone";
    };
    // Members
    /**
     * Gets the parent skeleton
     * @returns a skeleton
     */
    Bone.prototype.getSkeleton = function () {
        return this._skeleton;
    };
    /**
     * Gets parent bone
     * @returns a bone or null if the bone is the root of the bone hierarchy
     */
    Bone.prototype.getParent = function () {
        return this._parent;
    };
    /**
     * Returns an array containing the root bones
     * @returns an array containing the root bones
     */
    Bone.prototype.getChildren = function () {
        return this.children;
    };
    /**
     * Gets the node index in matrix array generated for rendering
     * @returns the node index
     */
    Bone.prototype.getIndex = function () {
        return this._index === null ? this.getSkeleton().bones.indexOf(this) : this._index;
    };
    /**
     * Sets the parent bone
     * @param parent defines the parent (can be null if the bone is the root)
     * @param updateDifferenceMatrix defines if the difference matrix must be updated
     */
    Bone.prototype.setParent = function (parent, updateDifferenceMatrix) {
        if (updateDifferenceMatrix === void 0) { updateDifferenceMatrix = true; }
        if (this._parent === parent) {
            return;
        }
        if (this._parent) {
            var index = this._parent.children.indexOf(this);
            if (index !== -1) {
                this._parent.children.splice(index, 1);
            }
        }
        this._parent = parent;
        if (this._parent) {
            this._parent.children.push(this);
        }
        if (updateDifferenceMatrix) {
            this._updateDifferenceMatrix();
        }
        this.markAsDirty();
    };
    /**
     * Gets the local matrix
     * @returns a matrix
     */
    Bone.prototype.getLocalMatrix = function () {
        this._compose();
        return this._localMatrix;
    };
    /**
     * Gets the base matrix (initial matrix which remains unchanged)
     * @returns a matrix
     */
    Bone.prototype.getBaseMatrix = function () {
        return this._baseMatrix;
    };
    /**
     * Gets the rest pose matrix
     * @returns a matrix
     */
    Bone.prototype.getRestPose = function () {
        return this._restPose;
    };
    /**
     * Gets a matrix used to store world matrix (ie. the matrix sent to shaders)
     */
    Bone.prototype.getWorldMatrix = function () {
        return this._worldTransform;
    };
    /**
     * Sets the local matrix to rest pose matrix
     */
    Bone.prototype.returnToRest = function () {
        this.updateMatrix(this._restPose.clone());
    };
    /**
     * Gets the inverse of the absolute transform matrix.
     * This matrix will be multiplied by local matrix to get the difference matrix (ie. the difference between original state and current state)
     * @returns a matrix
     */
    Bone.prototype.getInvertedAbsoluteTransform = function () {
        return this._invertedAbsoluteTransform;
    };
    /**
     * Gets the absolute transform matrix (ie base matrix * parent world matrix)
     * @returns a matrix
     */
    Bone.prototype.getAbsoluteTransform = function () {
        return this._absoluteTransform;
    };
    /**
     * Links with the given transform node.
     * The local matrix of this bone is copied from the transform node every frame.
     * @param transformNode defines the transform node to link to
     */
    Bone.prototype.linkTransformNode = function (transformNode) {
        if (this._linkedTransformNode) {
            this._skeleton._numBonesWithLinkedTransformNode--;
        }
        this._linkedTransformNode = transformNode;
        if (this._linkedTransformNode) {
            this._skeleton._numBonesWithLinkedTransformNode++;
        }
    };
    // Properties (matches AbstractMesh properties)
    /**
     * Gets the node used to drive the bone's transformation
     * @returns a transform node or null
     */
    Bone.prototype.getTransformNode = function () {
        return this._linkedTransformNode;
    };
    Object.defineProperty(Bone.prototype, "position", {
        /** Gets or sets current position (in local space) */
        get: function () {
            this._decompose();
            return this._localPosition;
        },
        set: function (newPosition) {
            this._decompose();
            this._localPosition.copyFrom(newPosition);
            this._markAsDirtyAndCompose();
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(Bone.prototype, "rotation", {
        /** Gets or sets current rotation (in local space) */
        get: function () {
            return this.getRotation();
        },
        set: function (newRotation) {
            this.setRotation(newRotation);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(Bone.prototype, "rotationQuaternion", {
        /** Gets or sets current rotation quaternion (in local space) */
        get: function () {
            this._decompose();
            return this._localRotation;
        },
        set: function (newRotation) {
            this.setRotationQuaternion(newRotation);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(Bone.prototype, "scaling", {
        /** Gets or sets current scaling (in local space) */
        get: function () {
            return this.getScale();
        },
        set: function (newScaling) {
            this.setScale(newScaling);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(Bone.prototype, "animationPropertiesOverride", {
        /**
         * Gets the animation properties override
         */
        get: function () {
            return this._skeleton.animationPropertiesOverride;
        },
        enumerable: true,
        configurable: true
    });
    // Methods
    Bone.prototype._decompose = function () {
        if (!this._needToDecompose) {
            return;
        }
        this._needToDecompose = false;
        if (!this._localScaling) {
            this._localScaling = _Maths_math_vector__WEBPACK_IMPORTED_MODULE_0__.Vector3.Zero();
            this._localRotation = _Maths_math_vector__WEBPACK_IMPORTED_MODULE_0__.Quaternion.Zero();
            this._localPosition = _Maths_math_vector__WEBPACK_IMPORTED_MODULE_0__.Vector3.Zero();
        }
        this._localMatrix.decompose(this._localScaling, this._localRotation, this._localPosition);
    };
    Bone.prototype._compose = function () {
        if (!this._needToCompose) {
            return;
        }
        if (!this._localScaling) {
            this._needToCompose = false;
            return;
        }
        this._needToCompose = false;
        _Maths_math_vector__WEBPACK_IMPORTED_MODULE_0__.Matrix.ComposeToRef(this._localScaling, this._localRotation, this._localPosition, this._localMatrix);
    };
    /**
     * Update the base and local matrices
     * @param matrix defines the new base or local matrix
     * @param updateDifferenceMatrix defines if the difference matrix must be updated
     * @param updateLocalMatrix defines if the local matrix should be updated
     */
    Bone.prototype.updateMatrix = function (matrix, updateDifferenceMatrix, updateLocalMatrix) {
        if (updateDifferenceMatrix === void 0) { updateDifferenceMatrix = true; }
        if (updateLocalMatrix === void 0) { updateLocalMatrix = true; }
        this._baseMatrix.copyFrom(matrix);
        if (updateDifferenceMatrix) {
            this._updateDifferenceMatrix();
        }
        if (updateLocalMatrix) {
            this._localMatrix.copyFrom(matrix);
            this._markAsDirtyAndDecompose();
        }
        else {
            this.markAsDirty();
        }
    };
    /** @hidden */
    Bone.prototype._updateDifferenceMatrix = function (rootMatrix, updateChildren) {
        if (updateChildren === void 0) { updateChildren = true; }
        if (!rootMatrix) {
            rootMatrix = this._baseMatrix;
        }
        if (this._parent) {
            rootMatrix.multiplyToRef(this._parent._absoluteTransform, this._absoluteTransform);
        }
        else {
            this._absoluteTransform.copyFrom(rootMatrix);
        }
        this._absoluteTransform.invertToRef(this._invertedAbsoluteTransform);
        if (updateChildren) {
            for (var index = 0; index < this.children.length; index++) {
                this.children[index]._updateDifferenceMatrix();
            }
        }
        this._scalingDeterminant = (this._absoluteTransform.determinant() < 0 ? -1 : 1);
    };
    /**
     * Flag the bone as dirty (Forcing it to update everything)
     */
    Bone.prototype.markAsDirty = function () {
        this._currentRenderId++;
        this._childUpdateId++;
        this._skeleton._markAsDirty();
    };
    /** @hidden */
    Bone.prototype._markAsDirtyAndCompose = function () {
        this.markAsDirty();
        this._needToCompose = true;
    };
    Bone.prototype._markAsDirtyAndDecompose = function () {
        this.markAsDirty();
        this._needToDecompose = true;
    };
    /**
     * Translate the bone in local or world space
     * @param vec The amount to translate the bone
     * @param space The space that the translation is in
     * @param mesh The mesh that this bone is attached to. This is only used in world space
     */
    Bone.prototype.translate = function (vec, space, mesh) {
        if (space === void 0) { space = _Maths_math_axis__WEBPACK_IMPORTED_MODULE_3__.Space.LOCAL; }
        var lm = this.getLocalMatrix();
        if (space == _Maths_math_axis__WEBPACK_IMPORTED_MODULE_3__.Space.LOCAL) {
            lm.addAtIndex(12, vec.x);
            lm.addAtIndex(13, vec.y);
            lm.addAtIndex(14, vec.z);
        }
        else {
            var wm = null;
            //mesh.getWorldMatrix() needs to be called before skeleton.computeAbsoluteTransforms()
            if (mesh) {
                wm = mesh.getWorldMatrix();
            }
            this._skeleton.computeAbsoluteTransforms();
            var tmat = Bone._tmpMats[0];
            var tvec = Bone._tmpVecs[0];
            if (this._parent) {
                if (mesh && wm) {
                    tmat.copyFrom(this._parent.getAbsoluteTransform());
                    tmat.multiplyToRef(wm, tmat);
                }
                else {
                    tmat.copyFrom(this._parent.getAbsoluteTransform());
                }
            }
            tmat.setTranslationFromFloats(0, 0, 0);
            tmat.invert();
            _Maths_math_vector__WEBPACK_IMPORTED_MODULE_0__.Vector3.TransformCoordinatesToRef(vec, tmat, tvec);
            lm.addAtIndex(12, tvec.x);
            lm.addAtIndex(13, tvec.y);
            lm.addAtIndex(14, tvec.z);
        }
        this._markAsDirtyAndDecompose();
    };
    /**
     * Set the postion of the bone in local or world space
     * @param position The position to set the bone
     * @param space The space that the position is in
     * @param mesh The mesh that this bone is attached to.  This is only used in world space
     */
    Bone.prototype.setPosition = function (position, space, mesh) {
        if (space === void 0) { space = _Maths_math_axis__WEBPACK_IMPORTED_MODULE_3__.Space.LOCAL; }
        var lm = this.getLocalMatrix();
        if (space == _Maths_math_axis__WEBPACK_IMPORTED_MODULE_3__.Space.LOCAL) {
            lm.setTranslationFromFloats(position.x, position.y, position.z);
        }
        else {
            var wm = null;
            //mesh.getWorldMatrix() needs to be called before skeleton.computeAbsoluteTransforms()
            if (mesh) {
                wm = mesh.getWorldMatrix();
            }
            this._skeleton.computeAbsoluteTransforms();
            var tmat = Bone._tmpMats[0];
            var vec = Bone._tmpVecs[0];
            if (this._parent) {
                if (mesh && wm) {
                    tmat.copyFrom(this._parent.getAbsoluteTransform());
                    tmat.multiplyToRef(wm, tmat);
                }
                else {
                    tmat.copyFrom(this._parent.getAbsoluteTransform());
                }
            }
            tmat.invert();
            _Maths_math_vector__WEBPACK_IMPORTED_MODULE_0__.Vector3.TransformCoordinatesToRef(position, tmat, vec);
            lm.setTranslationFromFloats(vec.x, vec.y, vec.z);
        }
        this._markAsDirtyAndDecompose();
    };
    /**
     * Set the absolute position of the bone (world space)
     * @param position The position to set the bone
     * @param mesh The mesh that this bone is attached to
     */
    Bone.prototype.setAbsolutePosition = function (position, mesh) {
        this.setPosition(position, _Maths_math_axis__WEBPACK_IMPORTED_MODULE_3__.Space.WORLD, mesh);
    };
    /**
     * Scale the bone on the x, y and z axes (in local space)
     * @param x The amount to scale the bone on the x axis
     * @param y The amount to scale the bone on the y axis
     * @param z The amount to scale the bone on the z axis
     * @param scaleChildren sets this to true if children of the bone should be scaled as well (false by default)
     */
    Bone.prototype.scale = function (x, y, z, scaleChildren) {
        if (scaleChildren === void 0) { scaleChildren = false; }
        var locMat = this.getLocalMatrix();
        // Apply new scaling on top of current local matrix
        var scaleMat = Bone._tmpMats[0];
        _Maths_math_vector__WEBPACK_IMPORTED_MODULE_0__.Matrix.ScalingToRef(x, y, z, scaleMat);
        scaleMat.multiplyToRef(locMat, locMat);
        // Invert scaling matrix and apply the inverse to all children
        scaleMat.invert();
        for (var _i = 0, _a = this.children; _i < _a.length; _i++) {
            var child = _a[_i];
            var cm = child.getLocalMatrix();
            cm.multiplyToRef(scaleMat, cm);
            cm.multiplyAtIndex(12, x);
            cm.multiplyAtIndex(13, y);
            cm.multiplyAtIndex(14, z);
            child._markAsDirtyAndDecompose();
        }
        this._markAsDirtyAndDecompose();
        if (scaleChildren) {
            for (var _b = 0, _c = this.children; _b < _c.length; _b++) {
                var child = _c[_b];
                child.scale(x, y, z, scaleChildren);
            }
        }
    };
    /**
     * Set the bone scaling in local space
     * @param scale defines the scaling vector
     */
    Bone.prototype.setScale = function (scale) {
        this._decompose();
        this._localScaling.copyFrom(scale);
        this._markAsDirtyAndCompose();
    };
    /**
     * Gets the current scaling in local space
     * @returns the current scaling vector
     */
    Bone.prototype.getScale = function () {
        this._decompose();
        return this._localScaling;
    };
    /**
     * Gets the current scaling in local space and stores it in a target vector
     * @param result defines the target vector
     */
    Bone.prototype.getScaleToRef = function (result) {
        this._decompose();
        result.copyFrom(this._localScaling);
    };
    /**
     * Set the yaw, pitch, and roll of the bone in local or world space
     * @param yaw The rotation of the bone on the y axis
     * @param pitch The rotation of the bone on the x axis
     * @param roll The rotation of the bone on the z axis
     * @param space The space that the axes of rotation are in
     * @param mesh The mesh that this bone is attached to.  This is only used in world space
     */
    Bone.prototype.setYawPitchRoll = function (yaw, pitch, roll, space, mesh) {
        if (space === void 0) { space = _Maths_math_axis__WEBPACK_IMPORTED_MODULE_3__.Space.LOCAL; }
        if (space === _Maths_math_axis__WEBPACK_IMPORTED_MODULE_3__.Space.LOCAL) {
            var quat = Bone._tmpQuat;
            _Maths_math_vector__WEBPACK_IMPORTED_MODULE_0__.Quaternion.RotationYawPitchRollToRef(yaw, pitch, roll, quat);
            this.setRotationQuaternion(quat, space, mesh);
            return;
        }
        var rotMatInv = Bone._tmpMats[0];
        if (!this._getNegativeRotationToRef(rotMatInv, mesh)) {
            return;
        }
        var rotMat = Bone._tmpMats[1];
        _Maths_math_vector__WEBPACK_IMPORTED_MODULE_0__.Matrix.RotationYawPitchRollToRef(yaw, pitch, roll, rotMat);
        rotMatInv.multiplyToRef(rotMat, rotMat);
        this._rotateWithMatrix(rotMat, space, mesh);
    };
    /**
     * Add a rotation to the bone on an axis in local or world space
     * @param axis The axis to rotate the bone on
     * @param amount The amount to rotate the bone
     * @param space The space that the axis is in
     * @param mesh The mesh that this bone is attached to. This is only used in world space
     */
    Bone.prototype.rotate = function (axis, amount, space, mesh) {
        if (space === void 0) { space = _Maths_math_axis__WEBPACK_IMPORTED_MODULE_3__.Space.LOCAL; }
        var rmat = Bone._tmpMats[0];
        rmat.setTranslationFromFloats(0, 0, 0);
        _Maths_math_vector__WEBPACK_IMPORTED_MODULE_0__.Matrix.RotationAxisToRef(axis, amount, rmat);
        this._rotateWithMatrix(rmat, space, mesh);
    };
    /**
     * Set the rotation of the bone to a particular axis angle in local or world space
     * @param axis The axis to rotate the bone on
     * @param angle The angle that the bone should be rotated to
     * @param space The space that the axis is in
     * @param mesh The mesh that this bone is attached to.  This is only used in world space
     */
    Bone.prototype.setAxisAngle = function (axis, angle, space, mesh) {
        if (space === void 0) { space = _Maths_math_axis__WEBPACK_IMPORTED_MODULE_3__.Space.LOCAL; }
        if (space === _Maths_math_axis__WEBPACK_IMPORTED_MODULE_3__.Space.LOCAL) {
            var quat = Bone._tmpQuat;
            _Maths_math_vector__WEBPACK_IMPORTED_MODULE_0__.Quaternion.RotationAxisToRef(axis, angle, quat);
            this.setRotationQuaternion(quat, space, mesh);
            return;
        }
        var rotMatInv = Bone._tmpMats[0];
        if (!this._getNegativeRotationToRef(rotMatInv, mesh)) {
            return;
        }
        var rotMat = Bone._tmpMats[1];
        _Maths_math_vector__WEBPACK_IMPORTED_MODULE_0__.Matrix.RotationAxisToRef(axis, angle, rotMat);
        rotMatInv.multiplyToRef(rotMat, rotMat);
        this._rotateWithMatrix(rotMat, space, mesh);
    };
    /**
     * Set the euler rotation of the bone in local of world space
     * @param rotation The euler rotation that the bone should be set to
     * @param space The space that the rotation is in
     * @param mesh The mesh that this bone is attached to. This is only used in world space
     */
    Bone.prototype.setRotation = function (rotation, space, mesh) {
        if (space === void 0) { space = _Maths_math_axis__WEBPACK_IMPORTED_MODULE_3__.Space.LOCAL; }
        this.setYawPitchRoll(rotation.y, rotation.x, rotation.z, space, mesh);
    };
    /**
     * Set the quaternion rotation of the bone in local of world space
     * @param quat The quaternion rotation that the bone should be set to
     * @param space The space that the rotation is in
     * @param mesh The mesh that this bone is attached to. This is only used in world space
     */
    Bone.prototype.setRotationQuaternion = function (quat, space, mesh) {
        if (space === void 0) { space = _Maths_math_axis__WEBPACK_IMPORTED_MODULE_3__.Space.LOCAL; }
        if (space === _Maths_math_axis__WEBPACK_IMPORTED_MODULE_3__.Space.LOCAL) {
            this._decompose();
            this._localRotation.copyFrom(quat);
            this._markAsDirtyAndCompose();
            return;
        }
        var rotMatInv = Bone._tmpMats[0];
        if (!this._getNegativeRotationToRef(rotMatInv, mesh)) {
            return;
        }
        var rotMat = Bone._tmpMats[1];
        _Maths_math_vector__WEBPACK_IMPORTED_MODULE_0__.Matrix.FromQuaternionToRef(quat, rotMat);
        rotMatInv.multiplyToRef(rotMat, rotMat);
        this._rotateWithMatrix(rotMat, space, mesh);
    };
    /**
     * Set the rotation matrix of the bone in local of world space
     * @param rotMat The rotation matrix that the bone should be set to
     * @param space The space that the rotation is in
     * @param mesh The mesh that this bone is attached to. This is only used in world space
     */
    Bone.prototype.setRotationMatrix = function (rotMat, space, mesh) {
        if (space === void 0) { space = _Maths_math_axis__WEBPACK_IMPORTED_MODULE_3__.Space.LOCAL; }
        if (space === _Maths_math_axis__WEBPACK_IMPORTED_MODULE_3__.Space.LOCAL) {
            var quat = Bone._tmpQuat;
            _Maths_math_vector__WEBPACK_IMPORTED_MODULE_0__.Quaternion.FromRotationMatrixToRef(rotMat, quat);
            this.setRotationQuaternion(quat, space, mesh);
            return;
        }
        var rotMatInv = Bone._tmpMats[0];
        if (!this._getNegativeRotationToRef(rotMatInv, mesh)) {
            return;
        }
        var rotMat2 = Bone._tmpMats[1];
        rotMat2.copyFrom(rotMat);
        rotMatInv.multiplyToRef(rotMat, rotMat2);
        this._rotateWithMatrix(rotMat2, space, mesh);
    };
    Bone.prototype._rotateWithMatrix = function (rmat, space, mesh) {
        if (space === void 0) { space = _Maths_math_axis__WEBPACK_IMPORTED_MODULE_3__.Space.LOCAL; }
        var lmat = this.getLocalMatrix();
        var lx = lmat.m[12];
        var ly = lmat.m[13];
        var lz = lmat.m[14];
        var parent = this.getParent();
        var parentScale = Bone._tmpMats[3];
        var parentScaleInv = Bone._tmpMats[4];
        if (parent && space == _Maths_math_axis__WEBPACK_IMPORTED_MODULE_3__.Space.WORLD) {
            if (mesh) {
                parentScale.copyFrom(mesh.getWorldMatrix());
                parent.getAbsoluteTransform().multiplyToRef(parentScale, parentScale);
            }
            else {
                parentScale.copyFrom(parent.getAbsoluteTransform());
            }
            parentScaleInv.copyFrom(parentScale);
            parentScaleInv.invert();
            lmat.multiplyToRef(parentScale, lmat);
            lmat.multiplyToRef(rmat, lmat);
            lmat.multiplyToRef(parentScaleInv, lmat);
        }
        else {
            if (space == _Maths_math_axis__WEBPACK_IMPORTED_MODULE_3__.Space.WORLD && mesh) {
                parentScale.copyFrom(mesh.getWorldMatrix());
                parentScaleInv.copyFrom(parentScale);
                parentScaleInv.invert();
                lmat.multiplyToRef(parentScale, lmat);
                lmat.multiplyToRef(rmat, lmat);
                lmat.multiplyToRef(parentScaleInv, lmat);
            }
            else {
                lmat.multiplyToRef(rmat, lmat);
            }
        }
        lmat.setTranslationFromFloats(lx, ly, lz);
        this.computeAbsoluteTransforms();
        this._markAsDirtyAndDecompose();
    };
    Bone.prototype._getNegativeRotationToRef = function (rotMatInv, mesh) {
        var scaleMatrix = Bone._tmpMats[2];
        rotMatInv.copyFrom(this.getAbsoluteTransform());
        if (mesh) {
            rotMatInv.multiplyToRef(mesh.getWorldMatrix(), rotMatInv);
            _Maths_math_vector__WEBPACK_IMPORTED_MODULE_0__.Matrix.ScalingToRef(mesh.scaling.x, mesh.scaling.y, mesh.scaling.z, scaleMatrix);
        }
        rotMatInv.invert();
        if (isNaN(rotMatInv.m[0])) {
            // Matrix failed to invert.
            // This can happen if scale is zero for example.
            return false;
        }
        scaleMatrix.multiplyAtIndex(0, this._scalingDeterminant);
        rotMatInv.multiplyToRef(scaleMatrix, rotMatInv);
        return true;
    };
    /**
     * Get the position of the bone in local or world space
     * @param space The space that the returned position is in
     * @param mesh The mesh that this bone is attached to. This is only used in world space
     * @returns The position of the bone
     */
    Bone.prototype.getPosition = function (space, mesh) {
        if (space === void 0) { space = _Maths_math_axis__WEBPACK_IMPORTED_MODULE_3__.Space.LOCAL; }
        if (mesh === void 0) { mesh = null; }
        var pos = _Maths_math_vector__WEBPACK_IMPORTED_MODULE_0__.Vector3.Zero();
        this.getPositionToRef(space, mesh, pos);
        return pos;
    };
    /**
     * Copy the position of the bone to a vector3 in local or world space
     * @param space The space that the returned position is in
     * @param mesh The mesh that this bone is attached to. This is only used in world space
     * @param result The vector3 to copy the position to
     */
    Bone.prototype.getPositionToRef = function (space, mesh, result) {
        if (space === void 0) { space = _Maths_math_axis__WEBPACK_IMPORTED_MODULE_3__.Space.LOCAL; }
        if (space == _Maths_math_axis__WEBPACK_IMPORTED_MODULE_3__.Space.LOCAL) {
            var lm = this.getLocalMatrix();
            result.x = lm.m[12];
            result.y = lm.m[13];
            result.z = lm.m[14];
        }
        else {
            var wm = null;
            //mesh.getWorldMatrix() needs to be called before skeleton.computeAbsoluteTransforms()
            if (mesh) {
                wm = mesh.getWorldMatrix();
            }
            this._skeleton.computeAbsoluteTransforms();
            var tmat = Bone._tmpMats[0];
            if (mesh && wm) {
                tmat.copyFrom(this.getAbsoluteTransform());
                tmat.multiplyToRef(wm, tmat);
            }
            else {
                tmat = this.getAbsoluteTransform();
            }
            result.x = tmat.m[12];
            result.y = tmat.m[13];
            result.z = tmat.m[14];
        }
    };
    /**
     * Get the absolute position of the bone (world space)
     * @param mesh The mesh that this bone is attached to
     * @returns The absolute position of the bone
     */
    Bone.prototype.getAbsolutePosition = function (mesh) {
        if (mesh === void 0) { mesh = null; }
        var pos = _Maths_math_vector__WEBPACK_IMPORTED_MODULE_0__.Vector3.Zero();
        this.getPositionToRef(_Maths_math_axis__WEBPACK_IMPORTED_MODULE_3__.Space.WORLD, mesh, pos);
        return pos;
    };
    /**
     * Copy the absolute position of the bone (world space) to the result param
     * @param mesh The mesh that this bone is attached to
     * @param result The vector3 to copy the absolute position to
     */
    Bone.prototype.getAbsolutePositionToRef = function (mesh, result) {
        this.getPositionToRef(_Maths_math_axis__WEBPACK_IMPORTED_MODULE_3__.Space.WORLD, mesh, result);
    };
    /**
     * Compute the absolute transforms of this bone and its children
     */
    Bone.prototype.computeAbsoluteTransforms = function () {
        this._compose();
        if (this._parent) {
            this._localMatrix.multiplyToRef(this._parent._absoluteTransform, this._absoluteTransform);
        }
        else {
            this._absoluteTransform.copyFrom(this._localMatrix);
            var poseMatrix = this._skeleton.getPoseMatrix();
            if (poseMatrix) {
                this._absoluteTransform.multiplyToRef(poseMatrix, this._absoluteTransform);
            }
        }
        var children = this.children;
        var len = children.length;
        for (var i = 0; i < len; i++) {
            children[i].computeAbsoluteTransforms();
        }
    };
    /**
     * Get the world direction from an axis that is in the local space of the bone
     * @param localAxis The local direction that is used to compute the world direction
     * @param mesh The mesh that this bone is attached to
     * @returns The world direction
     */
    Bone.prototype.getDirection = function (localAxis, mesh) {
        if (mesh === void 0) { mesh = null; }
        var result = _Maths_math_vector__WEBPACK_IMPORTED_MODULE_0__.Vector3.Zero();
        this.getDirectionToRef(localAxis, mesh, result);
        return result;
    };
    /**
     * Copy the world direction to a vector3 from an axis that is in the local space of the bone
     * @param localAxis The local direction that is used to compute the world direction
     * @param mesh The mesh that this bone is attached to
     * @param result The vector3 that the world direction will be copied to
     */
    Bone.prototype.getDirectionToRef = function (localAxis, mesh, result) {
        if (mesh === void 0) { mesh = null; }
        var wm = null;
        //mesh.getWorldMatrix() needs to be called before skeleton.computeAbsoluteTransforms()
        if (mesh) {
            wm = mesh.getWorldMatrix();
        }
        this._skeleton.computeAbsoluteTransforms();
        var mat = Bone._tmpMats[0];
        mat.copyFrom(this.getAbsoluteTransform());
        if (mesh && wm) {
            mat.multiplyToRef(wm, mat);
        }
        _Maths_math_vector__WEBPACK_IMPORTED_MODULE_0__.Vector3.TransformNormalToRef(localAxis, mat, result);
        result.normalize();
    };
    /**
     * Get the euler rotation of the bone in local or world space
     * @param space The space that the rotation should be in
     * @param mesh The mesh that this bone is attached to.  This is only used in world space
     * @returns The euler rotation
     */
    Bone.prototype.getRotation = function (space, mesh) {
        if (space === void 0) { space = _Maths_math_axis__WEBPACK_IMPORTED_MODULE_3__.Space.LOCAL; }
        if (mesh === void 0) { mesh = null; }
        var result = _Maths_math_vector__WEBPACK_IMPORTED_MODULE_0__.Vector3.Zero();
        this.getRotationToRef(space, mesh, result);
        return result;
    };
    /**
     * Copy the euler rotation of the bone to a vector3.  The rotation can be in either local or world space
     * @param space The space that the rotation should be in
     * @param mesh The mesh that this bone is attached to.  This is only used in world space
     * @param result The vector3 that the rotation should be copied to
     */
    Bone.prototype.getRotationToRef = function (space, mesh, result) {
        if (space === void 0) { space = _Maths_math_axis__WEBPACK_IMPORTED_MODULE_3__.Space.LOCAL; }
        if (mesh === void 0) { mesh = null; }
        var quat = Bone._tmpQuat;
        this.getRotationQuaternionToRef(space, mesh, quat);
        quat.toEulerAnglesToRef(result);
    };
    /**
     * Get the quaternion rotation of the bone in either local or world space
     * @param space The space that the rotation should be in
     * @param mesh The mesh that this bone is attached to.  This is only used in world space
     * @returns The quaternion rotation
     */
    Bone.prototype.getRotationQuaternion = function (space, mesh) {
        if (space === void 0) { space = _Maths_math_axis__WEBPACK_IMPORTED_MODULE_3__.Space.LOCAL; }
        if (mesh === void 0) { mesh = null; }
        var result = _Maths_math_vector__WEBPACK_IMPORTED_MODULE_0__.Quaternion.Identity();
        this.getRotationQuaternionToRef(space, mesh, result);
        return result;
    };
    /**
     * Copy the quaternion rotation of the bone to a quaternion.  The rotation can be in either local or world space
     * @param space The space that the rotation should be in
     * @param mesh The mesh that this bone is attached to.  This is only used in world space
     * @param result The quaternion that the rotation should be copied to
     */
    Bone.prototype.getRotationQuaternionToRef = function (space, mesh, result) {
        if (space === void 0) { space = _Maths_math_axis__WEBPACK_IMPORTED_MODULE_3__.Space.LOCAL; }
        if (mesh === void 0) { mesh = null; }
        if (space == _Maths_math_axis__WEBPACK_IMPORTED_MODULE_3__.Space.LOCAL) {
            this._decompose();
            result.copyFrom(this._localRotation);
        }
        else {
            var mat = Bone._tmpMats[0];
            var amat = this.getAbsoluteTransform();
            if (mesh) {
                amat.multiplyToRef(mesh.getWorldMatrix(), mat);
            }
            else {
                mat.copyFrom(amat);
            }
            mat.multiplyAtIndex(0, this._scalingDeterminant);
            mat.multiplyAtIndex(1, this._scalingDeterminant);
            mat.multiplyAtIndex(2, this._scalingDeterminant);
            mat.decompose(undefined, result, undefined);
        }
    };
    /**
     * Get the rotation matrix of the bone in local or world space
     * @param space The space that the rotation should be in
     * @param mesh The mesh that this bone is attached to.  This is only used in world space
     * @returns The rotation matrix
     */
    Bone.prototype.getRotationMatrix = function (space, mesh) {
        if (space === void 0) { space = _Maths_math_axis__WEBPACK_IMPORTED_MODULE_3__.Space.LOCAL; }
        var result = _Maths_math_vector__WEBPACK_IMPORTED_MODULE_0__.Matrix.Identity();
        this.getRotationMatrixToRef(space, mesh, result);
        return result;
    };
    /**
     * Copy the rotation matrix of the bone to a matrix.  The rotation can be in either local or world space
     * @param space The space that the rotation should be in
     * @param mesh The mesh that this bone is attached to.  This is only used in world space
     * @param result The quaternion that the rotation should be copied to
     */
    Bone.prototype.getRotationMatrixToRef = function (space, mesh, result) {
        if (space === void 0) { space = _Maths_math_axis__WEBPACK_IMPORTED_MODULE_3__.Space.LOCAL; }
        if (space == _Maths_math_axis__WEBPACK_IMPORTED_MODULE_3__.Space.LOCAL) {
            this.getLocalMatrix().getRotationMatrixToRef(result);
        }
        else {
            var mat = Bone._tmpMats[0];
            var amat = this.getAbsoluteTransform();
            if (mesh) {
                amat.multiplyToRef(mesh.getWorldMatrix(), mat);
            }
            else {
                mat.copyFrom(amat);
            }
            mat.multiplyAtIndex(0, this._scalingDeterminant);
            mat.multiplyAtIndex(1, this._scalingDeterminant);
            mat.multiplyAtIndex(2, this._scalingDeterminant);
            mat.getRotationMatrixToRef(result);
        }
    };
    /**
     * Get the world position of a point that is in the local space of the bone
     * @param position The local position
     * @param mesh The mesh that this bone is attached to
     * @returns The world position
     */
    Bone.prototype.getAbsolutePositionFromLocal = function (position, mesh) {
        if (mesh === void 0) { mesh = null; }
        var result = _Maths_math_vector__WEBPACK_IMPORTED_MODULE_0__.Vector3.Zero();
        this.getAbsolutePositionFromLocalToRef(position, mesh, result);
        return result;
    };
    /**
     * Get the world position of a point that is in the local space of the bone and copy it to the result param
     * @param position The local position
     * @param mesh The mesh that this bone is attached to
     * @param result The vector3 that the world position should be copied to
     */
    Bone.prototype.getAbsolutePositionFromLocalToRef = function (position, mesh, result) {
        if (mesh === void 0) { mesh = null; }
        var wm = null;
        //mesh.getWorldMatrix() needs to be called before skeleton.computeAbsoluteTransforms()
        if (mesh) {
            wm = mesh.getWorldMatrix();
        }
        this._skeleton.computeAbsoluteTransforms();
        var tmat = Bone._tmpMats[0];
        if (mesh && wm) {
            tmat.copyFrom(this.getAbsoluteTransform());
            tmat.multiplyToRef(wm, tmat);
        }
        else {
            tmat = this.getAbsoluteTransform();
        }
        _Maths_math_vector__WEBPACK_IMPORTED_MODULE_0__.Vector3.TransformCoordinatesToRef(position, tmat, result);
    };
    /**
     * Get the local position of a point that is in world space
     * @param position The world position
     * @param mesh The mesh that this bone is attached to
     * @returns The local position
     */
    Bone.prototype.getLocalPositionFromAbsolute = function (position, mesh) {
        if (mesh === void 0) { mesh = null; }
        var result = _Maths_math_vector__WEBPACK_IMPORTED_MODULE_0__.Vector3.Zero();
        this.getLocalPositionFromAbsoluteToRef(position, mesh, result);
        return result;
    };
    /**
     * Get the local position of a point that is in world space and copy it to the result param
     * @param position The world position
     * @param mesh The mesh that this bone is attached to
     * @param result The vector3 that the local position should be copied to
     */
    Bone.prototype.getLocalPositionFromAbsoluteToRef = function (position, mesh, result) {
        if (mesh === void 0) { mesh = null; }
        var wm = null;
        //mesh.getWorldMatrix() needs to be called before skeleton.computeAbsoluteTransforms()
        if (mesh) {
            wm = mesh.getWorldMatrix();
        }
        this._skeleton.computeAbsoluteTransforms();
        var tmat = Bone._tmpMats[0];
        tmat.copyFrom(this.getAbsoluteTransform());
        if (mesh && wm) {
            tmat.multiplyToRef(wm, tmat);
        }
        tmat.invert();
        _Maths_math_vector__WEBPACK_IMPORTED_MODULE_0__.Vector3.TransformCoordinatesToRef(position, tmat, result);
    };
    Bone._tmpVecs = _Misc_arrayTools__WEBPACK_IMPORTED_MODULE_1__.ArrayTools.BuildArray(2, _Maths_math_vector__WEBPACK_IMPORTED_MODULE_0__.Vector3.Zero);
    Bone._tmpQuat = _Maths_math_vector__WEBPACK_IMPORTED_MODULE_0__.Quaternion.Identity();
    Bone._tmpMats = _Misc_arrayTools__WEBPACK_IMPORTED_MODULE_1__.ArrayTools.BuildArray(5, _Maths_math_vector__WEBPACK_IMPORTED_MODULE_0__.Matrix.Identity);
    return Bone;
}(_node__WEBPACK_IMPORTED_MODULE_2__.Node));

//# sourceMappingURL=bone.js.map

/***/ }),

/***/ "./node_modules/@babylonjs/core/Bones/boneIKController.js":
/*!****************************************************************!*\
  !*** ./node_modules/@babylonjs/core/Bones/boneIKController.js ***!
  \****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "BoneIKController": () => (/* binding */ BoneIKController)
/* harmony export */ });
/* harmony import */ var _Maths_math_vector__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../Maths/math.vector */ "./node_modules/@babylonjs/core/Maths/math.vector.js");
/* harmony import */ var _Maths_math_axis__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Maths/math.axis */ "./node_modules/@babylonjs/core/Maths/math.axis.js");


/**
 * Class used to apply inverse kinematics to bones
 * @see http://doc.babylonjs.com/how_to/how_to_use_bones_and_skeletons#boneikcontroller
 */
var BoneIKController = /** @class */ (function () {
    /**
     * Creates a new BoneIKController
     * @param mesh defines the mesh to control
     * @param bone defines the bone to control
     * @param options defines options to set up the controller
     */
    function BoneIKController(mesh, bone, options) {
        /**
         * Gets or sets the target position
         */
        this.targetPosition = _Maths_math_vector__WEBPACK_IMPORTED_MODULE_0__.Vector3.Zero();
        /**
         * Gets or sets the pole target position
         */
        this.poleTargetPosition = _Maths_math_vector__WEBPACK_IMPORTED_MODULE_0__.Vector3.Zero();
        /**
         * Gets or sets the pole target local offset
         */
        this.poleTargetLocalOffset = _Maths_math_vector__WEBPACK_IMPORTED_MODULE_0__.Vector3.Zero();
        /**
         * Gets or sets the pole angle
         */
        this.poleAngle = 0;
        /**
         * The amount to slerp (spherical linear interpolation) to the target.  Set this to a value between 0 and 1 (a value of 1 disables slerp)
         */
        this.slerpAmount = 1;
        this._bone1Quat = _Maths_math_vector__WEBPACK_IMPORTED_MODULE_0__.Quaternion.Identity();
        this._bone1Mat = _Maths_math_vector__WEBPACK_IMPORTED_MODULE_0__.Matrix.Identity();
        this._bone2Ang = Math.PI;
        this._maxAngle = Math.PI;
        this._rightHandedSystem = false;
        this._bendAxis = _Maths_math_vector__WEBPACK_IMPORTED_MODULE_0__.Vector3.Right();
        this._slerping = false;
        this._adjustRoll = 0;
        this._bone2 = bone;
        this._bone1 = bone.getParent();
        if (!this._bone1) {
            return;
        }
        this.mesh = mesh;
        var bonePos = bone.getPosition();
        if (bone.getAbsoluteTransform().determinant() > 0) {
            this._rightHandedSystem = true;
            this._bendAxis.x = 0;
            this._bendAxis.y = 0;
            this._bendAxis.z = -1;
            if (bonePos.x > bonePos.y && bonePos.x > bonePos.z) {
                this._adjustRoll = Math.PI * .5;
                this._bendAxis.z = 1;
            }
        }
        if (this._bone1.length) {
            var boneScale1 = this._bone1.getScale();
            var boneScale2 = this._bone2.getScale();
            this._bone1Length = this._bone1.length * boneScale1.y * this.mesh.scaling.y;
            this._bone2Length = this._bone2.length * boneScale2.y * this.mesh.scaling.y;
        }
        else if (this._bone1.children[0]) {
            mesh.computeWorldMatrix(true);
            var pos1 = this._bone2.children[0].getAbsolutePosition(mesh);
            var pos2 = this._bone2.getAbsolutePosition(mesh);
            var pos3 = this._bone1.getAbsolutePosition(mesh);
            this._bone1Length = _Maths_math_vector__WEBPACK_IMPORTED_MODULE_0__.Vector3.Distance(pos1, pos2);
            this._bone2Length = _Maths_math_vector__WEBPACK_IMPORTED_MODULE_0__.Vector3.Distance(pos2, pos3);
        }
        this._bone1.getRotationMatrixToRef(_Maths_math_axis__WEBPACK_IMPORTED_MODULE_1__.Space.WORLD, mesh, this._bone1Mat);
        this.maxAngle = Math.PI;
        if (options) {
            if (options.targetMesh) {
                this.targetMesh = options.targetMesh;
                this.targetMesh.computeWorldMatrix(true);
            }
            if (options.poleTargetMesh) {
                this.poleTargetMesh = options.poleTargetMesh;
                this.poleTargetMesh.computeWorldMatrix(true);
            }
            else if (options.poleTargetBone) {
                this.poleTargetBone = options.poleTargetBone;
            }
            else if (this._bone1.getParent()) {
                this.poleTargetBone = this._bone1.getParent();
            }
            if (options.poleTargetLocalOffset) {
                this.poleTargetLocalOffset.copyFrom(options.poleTargetLocalOffset);
            }
            if (options.poleAngle) {
                this.poleAngle = options.poleAngle;
            }
            if (options.bendAxis) {
                this._bendAxis.copyFrom(options.bendAxis);
            }
            if (options.maxAngle) {
                this.maxAngle = options.maxAngle;
            }
            if (options.slerpAmount) {
                this.slerpAmount = options.slerpAmount;
            }
        }
    }
    Object.defineProperty(BoneIKController.prototype, "maxAngle", {
        /**
         * Gets or sets maximum allowed angle
         */
        get: function () {
            return this._maxAngle;
        },
        set: function (value) {
            this._setMaxAngle(value);
        },
        enumerable: true,
        configurable: true
    });
    BoneIKController.prototype._setMaxAngle = function (ang) {
        if (ang < 0) {
            ang = 0;
        }
        if (ang > Math.PI || ang == undefined) {
            ang = Math.PI;
        }
        this._maxAngle = ang;
        var a = this._bone1Length;
        var b = this._bone2Length;
        this._maxReach = Math.sqrt(a * a + b * b - 2 * a * b * Math.cos(ang));
    };
    /**
     * Force the controller to update the bones
     */
    BoneIKController.prototype.update = function () {
        var bone1 = this._bone1;
        if (!bone1) {
            return;
        }
        var target = this.targetPosition;
        var poleTarget = this.poleTargetPosition;
        var mat1 = BoneIKController._tmpMats[0];
        var mat2 = BoneIKController._tmpMats[1];
        if (this.targetMesh) {
            target.copyFrom(this.targetMesh.getAbsolutePosition());
        }
        if (this.poleTargetBone) {
            this.poleTargetBone.getAbsolutePositionFromLocalToRef(this.poleTargetLocalOffset, this.mesh, poleTarget);
        }
        else if (this.poleTargetMesh) {
            _Maths_math_vector__WEBPACK_IMPORTED_MODULE_0__.Vector3.TransformCoordinatesToRef(this.poleTargetLocalOffset, this.poleTargetMesh.getWorldMatrix(), poleTarget);
        }
        var bonePos = BoneIKController._tmpVecs[0];
        var zaxis = BoneIKController._tmpVecs[1];
        var xaxis = BoneIKController._tmpVecs[2];
        var yaxis = BoneIKController._tmpVecs[3];
        var upAxis = BoneIKController._tmpVecs[4];
        var _tmpQuat = BoneIKController._tmpQuat;
        bone1.getAbsolutePositionToRef(this.mesh, bonePos);
        poleTarget.subtractToRef(bonePos, upAxis);
        if (upAxis.x == 0 && upAxis.y == 0 && upAxis.z == 0) {
            upAxis.y = 1;
        }
        else {
            upAxis.normalize();
        }
        target.subtractToRef(bonePos, yaxis);
        yaxis.normalize();
        _Maths_math_vector__WEBPACK_IMPORTED_MODULE_0__.Vector3.CrossToRef(yaxis, upAxis, zaxis);
        zaxis.normalize();
        _Maths_math_vector__WEBPACK_IMPORTED_MODULE_0__.Vector3.CrossToRef(yaxis, zaxis, xaxis);
        xaxis.normalize();
        _Maths_math_vector__WEBPACK_IMPORTED_MODULE_0__.Matrix.FromXYZAxesToRef(xaxis, yaxis, zaxis, mat1);
        var a = this._bone1Length;
        var b = this._bone2Length;
        var c = _Maths_math_vector__WEBPACK_IMPORTED_MODULE_0__.Vector3.Distance(bonePos, target);
        if (this._maxReach > 0) {
            c = Math.min(this._maxReach, c);
        }
        var acosa = (b * b + c * c - a * a) / (2 * b * c);
        var acosb = (c * c + a * a - b * b) / (2 * c * a);
        if (acosa > 1) {
            acosa = 1;
        }
        if (acosb > 1) {
            acosb = 1;
        }
        if (acosa < -1) {
            acosa = -1;
        }
        if (acosb < -1) {
            acosb = -1;
        }
        var angA = Math.acos(acosa);
        var angB = Math.acos(acosb);
        var angC = -angA - angB;
        if (this._rightHandedSystem) {
            _Maths_math_vector__WEBPACK_IMPORTED_MODULE_0__.Matrix.RotationYawPitchRollToRef(0, 0, this._adjustRoll, mat2);
            mat2.multiplyToRef(mat1, mat1);
            _Maths_math_vector__WEBPACK_IMPORTED_MODULE_0__.Matrix.RotationAxisToRef(this._bendAxis, angB, mat2);
            mat2.multiplyToRef(mat1, mat1);
        }
        else {
            var _tmpVec = BoneIKController._tmpVecs[5];
            _tmpVec.copyFrom(this._bendAxis);
            _tmpVec.x *= -1;
            _Maths_math_vector__WEBPACK_IMPORTED_MODULE_0__.Matrix.RotationAxisToRef(_tmpVec, -angB, mat2);
            mat2.multiplyToRef(mat1, mat1);
        }
        if (this.poleAngle) {
            _Maths_math_vector__WEBPACK_IMPORTED_MODULE_0__.Matrix.RotationAxisToRef(yaxis, this.poleAngle, mat2);
            mat1.multiplyToRef(mat2, mat1);
        }
        if (this._bone1) {
            if (this.slerpAmount < 1) {
                if (!this._slerping) {
                    _Maths_math_vector__WEBPACK_IMPORTED_MODULE_0__.Quaternion.FromRotationMatrixToRef(this._bone1Mat, this._bone1Quat);
                }
                _Maths_math_vector__WEBPACK_IMPORTED_MODULE_0__.Quaternion.FromRotationMatrixToRef(mat1, _tmpQuat);
                _Maths_math_vector__WEBPACK_IMPORTED_MODULE_0__.Quaternion.SlerpToRef(this._bone1Quat, _tmpQuat, this.slerpAmount, this._bone1Quat);
                angC = this._bone2Ang * (1.0 - this.slerpAmount) + angC * this.slerpAmount;
                this._bone1.setRotationQuaternion(this._bone1Quat, _Maths_math_axis__WEBPACK_IMPORTED_MODULE_1__.Space.WORLD, this.mesh);
                this._slerping = true;
            }
            else {
                this._bone1.setRotationMatrix(mat1, _Maths_math_axis__WEBPACK_IMPORTED_MODULE_1__.Space.WORLD, this.mesh);
                this._bone1Mat.copyFrom(mat1);
                this._slerping = false;
            }
        }
        this._bone2.setAxisAngle(this._bendAxis, angC, _Maths_math_axis__WEBPACK_IMPORTED_MODULE_1__.Space.LOCAL);
        this._bone2Ang = angC;
    };
    BoneIKController._tmpVecs = [_Maths_math_vector__WEBPACK_IMPORTED_MODULE_0__.Vector3.Zero(), _Maths_math_vector__WEBPACK_IMPORTED_MODULE_0__.Vector3.Zero(), _Maths_math_vector__WEBPACK_IMPORTED_MODULE_0__.Vector3.Zero(), _Maths_math_vector__WEBPACK_IMPORTED_MODULE_0__.Vector3.Zero(), _Maths_math_vector__WEBPACK_IMPORTED_MODULE_0__.Vector3.Zero(), _Maths_math_vector__WEBPACK_IMPORTED_MODULE_0__.Vector3.Zero()];
    BoneIKController._tmpQuat = _Maths_math_vector__WEBPACK_IMPORTED_MODULE_0__.Quaternion.Identity();
    BoneIKController._tmpMats = [_Maths_math_vector__WEBPACK_IMPORTED_MODULE_0__.Matrix.Identity(), _Maths_math_vector__WEBPACK_IMPORTED_MODULE_0__.Matrix.Identity()];
    return BoneIKController;
}());

//# sourceMappingURL=boneIKController.js.map

/***/ }),

/***/ "./node_modules/@babylonjs/core/Bones/boneLookController.js":
/*!******************************************************************!*\
  !*** ./node_modules/@babylonjs/core/Bones/boneLookController.js ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "BoneLookController": () => (/* binding */ BoneLookController)
/* harmony export */ });
/* harmony import */ var _Misc_arrayTools__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../Misc/arrayTools */ "./node_modules/@babylonjs/core/Misc/arrayTools.js");
/* harmony import */ var _Maths_math_vector__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Maths/math.vector */ "./node_modules/@babylonjs/core/Maths/math.vector.js");
/* harmony import */ var _Maths_math_axis__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Maths/math.axis */ "./node_modules/@babylonjs/core/Maths/math.axis.js");



/**
 * Class used to make a bone look toward a point in space
 * @see http://doc.babylonjs.com/how_to/how_to_use_bones_and_skeletons#bonelookcontroller
 */
var BoneLookController = /** @class */ (function () {
    /**
     * Create a BoneLookController
     * @param mesh the mesh that the bone belongs to
     * @param bone the bone that will be looking to the target
     * @param target the target Vector3 to look at
     * @param options optional settings:
     * * maxYaw: the maximum angle the bone will yaw to
     * * minYaw: the minimum angle the bone will yaw to
     * * maxPitch: the maximum angle the bone will pitch to
     * * minPitch: the minimum angle the bone will yaw to
     * * slerpAmount: set the between 0 and 1 to make the bone slerp to the target.
     * * upAxis: the up axis of the coordinate system
     * * upAxisSpace: the space that the up axis is in - Space.BONE, Space.LOCAL (default), or Space.WORLD.
     * * yawAxis: set yawAxis if the bone does not yaw on the y axis
     * * pitchAxis: set pitchAxis if the bone does not pitch on the x axis
     * * adjustYaw: used to make an adjustment to the yaw of the bone
     * * adjustPitch: used to make an adjustment to the pitch of the bone
     * * adjustRoll: used to make an adjustment to the roll of the bone
     **/
    function BoneLookController(mesh, bone, target, options) {
        /**
         * The up axis of the coordinate system that is used when the bone is rotated
         */
        this.upAxis = _Maths_math_vector__WEBPACK_IMPORTED_MODULE_1__.Vector3.Up();
        /**
         * The space that the up axis is in - Space.BONE, Space.LOCAL (default), or Space.WORLD
         */
        this.upAxisSpace = _Maths_math_axis__WEBPACK_IMPORTED_MODULE_2__.Space.LOCAL;
        /**
         * Used to make an adjustment to the yaw of the bone
         */
        this.adjustYaw = 0;
        /**
         * Used to make an adjustment to the pitch of the bone
         */
        this.adjustPitch = 0;
        /**
         * Used to make an adjustment to the roll of the bone
         */
        this.adjustRoll = 0;
        /**
         * The amount to slerp (spherical linear interpolation) to the target.  Set this to a value between 0 and 1 (a value of 1 disables slerp)
         */
        this.slerpAmount = 1;
        this._boneQuat = _Maths_math_vector__WEBPACK_IMPORTED_MODULE_1__.Quaternion.Identity();
        this._slerping = false;
        this._firstFrameSkipped = false;
        this._fowardAxis = _Maths_math_vector__WEBPACK_IMPORTED_MODULE_1__.Vector3.Forward();
        this.mesh = mesh;
        this.bone = bone;
        this.target = target;
        if (options) {
            if (options.adjustYaw) {
                this.adjustYaw = options.adjustYaw;
            }
            if (options.adjustPitch) {
                this.adjustPitch = options.adjustPitch;
            }
            if (options.adjustRoll) {
                this.adjustRoll = options.adjustRoll;
            }
            if (options.maxYaw != null) {
                this.maxYaw = options.maxYaw;
            }
            else {
                this.maxYaw = Math.PI;
            }
            if (options.minYaw != null) {
                this.minYaw = options.minYaw;
            }
            else {
                this.minYaw = -Math.PI;
            }
            if (options.maxPitch != null) {
                this.maxPitch = options.maxPitch;
            }
            else {
                this.maxPitch = Math.PI;
            }
            if (options.minPitch != null) {
                this.minPitch = options.minPitch;
            }
            else {
                this.minPitch = -Math.PI;
            }
            if (options.slerpAmount != null) {
                this.slerpAmount = options.slerpAmount;
            }
            if (options.upAxis != null) {
                this.upAxis = options.upAxis;
            }
            if (options.upAxisSpace != null) {
                this.upAxisSpace = options.upAxisSpace;
            }
            if (options.yawAxis != null || options.pitchAxis != null) {
                var newYawAxis = _Maths_math_axis__WEBPACK_IMPORTED_MODULE_2__.Axis.Y;
                var newPitchAxis = _Maths_math_axis__WEBPACK_IMPORTED_MODULE_2__.Axis.X;
                if (options.yawAxis != null) {
                    newYawAxis = options.yawAxis.clone();
                    newYawAxis.normalize();
                }
                if (options.pitchAxis != null) {
                    newPitchAxis = options.pitchAxis.clone();
                    newPitchAxis.normalize();
                }
                var newRollAxis = _Maths_math_vector__WEBPACK_IMPORTED_MODULE_1__.Vector3.Cross(newPitchAxis, newYawAxis);
                this._transformYawPitch = _Maths_math_vector__WEBPACK_IMPORTED_MODULE_1__.Matrix.Identity();
                _Maths_math_vector__WEBPACK_IMPORTED_MODULE_1__.Matrix.FromXYZAxesToRef(newPitchAxis, newYawAxis, newRollAxis, this._transformYawPitch);
                this._transformYawPitchInv = this._transformYawPitch.clone();
                this._transformYawPitch.invert();
            }
        }
        if (!bone.getParent() && this.upAxisSpace == _Maths_math_axis__WEBPACK_IMPORTED_MODULE_2__.Space.BONE) {
            this.upAxisSpace = _Maths_math_axis__WEBPACK_IMPORTED_MODULE_2__.Space.LOCAL;
        }
    }
    Object.defineProperty(BoneLookController.prototype, "minYaw", {
        /**
         * Gets or sets the minimum yaw angle that the bone can look to
         */
        get: function () {
            return this._minYaw;
        },
        set: function (value) {
            this._minYaw = value;
            this._minYawSin = Math.sin(value);
            this._minYawCos = Math.cos(value);
            if (this._maxYaw != null) {
                this._midYawConstraint = this._getAngleDiff(this._minYaw, this._maxYaw) * .5 + this._minYaw;
                this._yawRange = this._maxYaw - this._minYaw;
            }
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(BoneLookController.prototype, "maxYaw", {
        /**
         * Gets or sets the maximum yaw angle that the bone can look to
         */
        get: function () {
            return this._maxYaw;
        },
        set: function (value) {
            this._maxYaw = value;
            this._maxYawSin = Math.sin(value);
            this._maxYawCos = Math.cos(value);
            if (this._minYaw != null) {
                this._midYawConstraint = this._getAngleDiff(this._minYaw, this._maxYaw) * .5 + this._minYaw;
                this._yawRange = this._maxYaw - this._minYaw;
            }
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(BoneLookController.prototype, "minPitch", {
        /**
         * Gets or sets the minimum pitch angle that the bone can look to
         */
        get: function () {
            return this._minPitch;
        },
        set: function (value) {
            this._minPitch = value;
            this._minPitchTan = Math.tan(value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(BoneLookController.prototype, "maxPitch", {
        /**
         * Gets or sets the maximum pitch angle that the bone can look to
         */
        get: function () {
            return this._maxPitch;
        },
        set: function (value) {
            this._maxPitch = value;
            this._maxPitchTan = Math.tan(value);
        },
        enumerable: true,
        configurable: true
    });
    /**
     * Update the bone to look at the target.  This should be called before the scene is rendered (use scene.registerBeforeRender())
     */
    BoneLookController.prototype.update = function () {
        //skip the first frame when slerping so that the mesh rotation is correct
        if (this.slerpAmount < 1 && !this._firstFrameSkipped) {
            this._firstFrameSkipped = true;
            return;
        }
        var bone = this.bone;
        var bonePos = BoneLookController._tmpVecs[0];
        bone.getAbsolutePositionToRef(this.mesh, bonePos);
        var target = this.target;
        var _tmpMat1 = BoneLookController._tmpMats[0];
        var _tmpMat2 = BoneLookController._tmpMats[1];
        var mesh = this.mesh;
        var parentBone = bone.getParent();
        var upAxis = BoneLookController._tmpVecs[1];
        upAxis.copyFrom(this.upAxis);
        if (this.upAxisSpace == _Maths_math_axis__WEBPACK_IMPORTED_MODULE_2__.Space.BONE && parentBone) {
            if (this._transformYawPitch) {
                _Maths_math_vector__WEBPACK_IMPORTED_MODULE_1__.Vector3.TransformCoordinatesToRef(upAxis, this._transformYawPitchInv, upAxis);
            }
            parentBone.getDirectionToRef(upAxis, this.mesh, upAxis);
        }
        else if (this.upAxisSpace == _Maths_math_axis__WEBPACK_IMPORTED_MODULE_2__.Space.LOCAL) {
            mesh.getDirectionToRef(upAxis, upAxis);
            if (mesh.scaling.x != 1 || mesh.scaling.y != 1 || mesh.scaling.z != 1) {
                upAxis.normalize();
            }
        }
        var checkYaw = false;
        var checkPitch = false;
        if (this._maxYaw != Math.PI || this._minYaw != -Math.PI) {
            checkYaw = true;
        }
        if (this._maxPitch != Math.PI || this._minPitch != -Math.PI) {
            checkPitch = true;
        }
        if (checkYaw || checkPitch) {
            var spaceMat = BoneLookController._tmpMats[2];
            var spaceMatInv = BoneLookController._tmpMats[3];
            if (this.upAxisSpace == _Maths_math_axis__WEBPACK_IMPORTED_MODULE_2__.Space.BONE && upAxis.y == 1 && parentBone) {
                parentBone.getRotationMatrixToRef(_Maths_math_axis__WEBPACK_IMPORTED_MODULE_2__.Space.WORLD, this.mesh, spaceMat);
            }
            else if (this.upAxisSpace == _Maths_math_axis__WEBPACK_IMPORTED_MODULE_2__.Space.LOCAL && upAxis.y == 1 && !parentBone) {
                spaceMat.copyFrom(mesh.getWorldMatrix());
            }
            else {
                var forwardAxis = BoneLookController._tmpVecs[2];
                forwardAxis.copyFrom(this._fowardAxis);
                if (this._transformYawPitch) {
                    _Maths_math_vector__WEBPACK_IMPORTED_MODULE_1__.Vector3.TransformCoordinatesToRef(forwardAxis, this._transformYawPitchInv, forwardAxis);
                }
                if (parentBone) {
                    parentBone.getDirectionToRef(forwardAxis, this.mesh, forwardAxis);
                }
                else {
                    mesh.getDirectionToRef(forwardAxis, forwardAxis);
                }
                var rightAxis = _Maths_math_vector__WEBPACK_IMPORTED_MODULE_1__.Vector3.Cross(upAxis, forwardAxis);
                rightAxis.normalize();
                var forwardAxis = _Maths_math_vector__WEBPACK_IMPORTED_MODULE_1__.Vector3.Cross(rightAxis, upAxis);
                _Maths_math_vector__WEBPACK_IMPORTED_MODULE_1__.Matrix.FromXYZAxesToRef(rightAxis, upAxis, forwardAxis, spaceMat);
            }
            spaceMat.invertToRef(spaceMatInv);
            var xzlen = null;
            if (checkPitch) {
                var localTarget = BoneLookController._tmpVecs[3];
                target.subtractToRef(bonePos, localTarget);
                _Maths_math_vector__WEBPACK_IMPORTED_MODULE_1__.Vector3.TransformCoordinatesToRef(localTarget, spaceMatInv, localTarget);
                xzlen = Math.sqrt(localTarget.x * localTarget.x + localTarget.z * localTarget.z);
                var pitch = Math.atan2(localTarget.y, xzlen);
                var newPitch = pitch;
                if (pitch > this._maxPitch) {
                    localTarget.y = this._maxPitchTan * xzlen;
                    newPitch = this._maxPitch;
                }
                else if (pitch < this._minPitch) {
                    localTarget.y = this._minPitchTan * xzlen;
                    newPitch = this._minPitch;
                }
                if (pitch != newPitch) {
                    _Maths_math_vector__WEBPACK_IMPORTED_MODULE_1__.Vector3.TransformCoordinatesToRef(localTarget, spaceMat, localTarget);
                    localTarget.addInPlace(bonePos);
                    target = localTarget;
                }
            }
            if (checkYaw) {
                var localTarget = BoneLookController._tmpVecs[4];
                target.subtractToRef(bonePos, localTarget);
                _Maths_math_vector__WEBPACK_IMPORTED_MODULE_1__.Vector3.TransformCoordinatesToRef(localTarget, spaceMatInv, localTarget);
                var yaw = Math.atan2(localTarget.x, localTarget.z);
                var newYaw = yaw;
                if (yaw > this._maxYaw || yaw < this._minYaw) {
                    if (xzlen == null) {
                        xzlen = Math.sqrt(localTarget.x * localTarget.x + localTarget.z * localTarget.z);
                    }
                    if (this._yawRange > Math.PI) {
                        if (this._isAngleBetween(yaw, this._maxYaw, this._midYawConstraint)) {
                            localTarget.z = this._maxYawCos * xzlen;
                            localTarget.x = this._maxYawSin * xzlen;
                            newYaw = this._maxYaw;
                        }
                        else if (this._isAngleBetween(yaw, this._midYawConstraint, this._minYaw)) {
                            localTarget.z = this._minYawCos * xzlen;
                            localTarget.x = this._minYawSin * xzlen;
                            newYaw = this._minYaw;
                        }
                    }
                    else {
                        if (yaw > this._maxYaw) {
                            localTarget.z = this._maxYawCos * xzlen;
                            localTarget.x = this._maxYawSin * xzlen;
                            newYaw = this._maxYaw;
                        }
                        else if (yaw < this._minYaw) {
                            localTarget.z = this._minYawCos * xzlen;
                            localTarget.x = this._minYawSin * xzlen;
                            newYaw = this._minYaw;
                        }
                    }
                }
                if (this._slerping && this._yawRange > Math.PI) {
                    //are we going to be crossing into the min/max region?
                    var boneFwd = BoneLookController._tmpVecs[8];
                    boneFwd.copyFrom(_Maths_math_axis__WEBPACK_IMPORTED_MODULE_2__.Axis.Z);
                    if (this._transformYawPitch) {
                        _Maths_math_vector__WEBPACK_IMPORTED_MODULE_1__.Vector3.TransformCoordinatesToRef(boneFwd, this._transformYawPitchInv, boneFwd);
                    }
                    var boneRotMat = BoneLookController._tmpMats[4];
                    this._boneQuat.toRotationMatrix(boneRotMat);
                    this.mesh.getWorldMatrix().multiplyToRef(boneRotMat, boneRotMat);
                    _Maths_math_vector__WEBPACK_IMPORTED_MODULE_1__.Vector3.TransformCoordinatesToRef(boneFwd, boneRotMat, boneFwd);
                    _Maths_math_vector__WEBPACK_IMPORTED_MODULE_1__.Vector3.TransformCoordinatesToRef(boneFwd, spaceMatInv, boneFwd);
                    var boneYaw = Math.atan2(boneFwd.x, boneFwd.z);
                    var angBtwTar = this._getAngleBetween(boneYaw, yaw);
                    var angBtwMidYaw = this._getAngleBetween(boneYaw, this._midYawConstraint);
                    if (angBtwTar > angBtwMidYaw) {
                        if (xzlen == null) {
                            xzlen = Math.sqrt(localTarget.x * localTarget.x + localTarget.z * localTarget.z);
                        }
                        var angBtwMax = this._getAngleBetween(boneYaw, this._maxYaw);
                        var angBtwMin = this._getAngleBetween(boneYaw, this._minYaw);
                        if (angBtwMin < angBtwMax) {
                            newYaw = boneYaw + Math.PI * .75;
                            localTarget.z = Math.cos(newYaw) * xzlen;
                            localTarget.x = Math.sin(newYaw) * xzlen;
                        }
                        else {
                            newYaw = boneYaw - Math.PI * .75;
                            localTarget.z = Math.cos(newYaw) * xzlen;
                            localTarget.x = Math.sin(newYaw) * xzlen;
                        }
                    }
                }
                if (yaw != newYaw) {
                    _Maths_math_vector__WEBPACK_IMPORTED_MODULE_1__.Vector3.TransformCoordinatesToRef(localTarget, spaceMat, localTarget);
                    localTarget.addInPlace(bonePos);
                    target = localTarget;
                }
            }
        }
        var zaxis = BoneLookController._tmpVecs[5];
        var xaxis = BoneLookController._tmpVecs[6];
        var yaxis = BoneLookController._tmpVecs[7];
        var _tmpQuat = BoneLookController._tmpQuat;
        target.subtractToRef(bonePos, zaxis);
        zaxis.normalize();
        _Maths_math_vector__WEBPACK_IMPORTED_MODULE_1__.Vector3.CrossToRef(upAxis, zaxis, xaxis);
        xaxis.normalize();
        _Maths_math_vector__WEBPACK_IMPORTED_MODULE_1__.Vector3.CrossToRef(zaxis, xaxis, yaxis);
        yaxis.normalize();
        _Maths_math_vector__WEBPACK_IMPORTED_MODULE_1__.Matrix.FromXYZAxesToRef(xaxis, yaxis, zaxis, _tmpMat1);
        if (xaxis.x === 0 && xaxis.y === 0 && xaxis.z === 0) {
            return;
        }
        if (yaxis.x === 0 && yaxis.y === 0 && yaxis.z === 0) {
            return;
        }
        if (zaxis.x === 0 && zaxis.y === 0 && zaxis.z === 0) {
            return;
        }
        if (this.adjustYaw || this.adjustPitch || this.adjustRoll) {
            _Maths_math_vector__WEBPACK_IMPORTED_MODULE_1__.Matrix.RotationYawPitchRollToRef(this.adjustYaw, this.adjustPitch, this.adjustRoll, _tmpMat2);
            _tmpMat2.multiplyToRef(_tmpMat1, _tmpMat1);
        }
        if (this.slerpAmount < 1) {
            if (!this._slerping) {
                this.bone.getRotationQuaternionToRef(_Maths_math_axis__WEBPACK_IMPORTED_MODULE_2__.Space.WORLD, this.mesh, this._boneQuat);
            }
            if (this._transformYawPitch) {
                this._transformYawPitch.multiplyToRef(_tmpMat1, _tmpMat1);
            }
            _Maths_math_vector__WEBPACK_IMPORTED_MODULE_1__.Quaternion.FromRotationMatrixToRef(_tmpMat1, _tmpQuat);
            _Maths_math_vector__WEBPACK_IMPORTED_MODULE_1__.Quaternion.SlerpToRef(this._boneQuat, _tmpQuat, this.slerpAmount, this._boneQuat);
            this.bone.setRotationQuaternion(this._boneQuat, _Maths_math_axis__WEBPACK_IMPORTED_MODULE_2__.Space.WORLD, this.mesh);
            this._slerping = true;
        }
        else {
            if (this._transformYawPitch) {
                this._transformYawPitch.multiplyToRef(_tmpMat1, _tmpMat1);
            }
            this.bone.setRotationMatrix(_tmpMat1, _Maths_math_axis__WEBPACK_IMPORTED_MODULE_2__.Space.WORLD, this.mesh);
            this._slerping = false;
        }
    };
    BoneLookController.prototype._getAngleDiff = function (ang1, ang2) {
        var angDiff = ang2 - ang1;
        angDiff %= Math.PI * 2;
        if (angDiff > Math.PI) {
            angDiff -= Math.PI * 2;
        }
        else if (angDiff < -Math.PI) {
            angDiff += Math.PI * 2;
        }
        return angDiff;
    };
    BoneLookController.prototype._getAngleBetween = function (ang1, ang2) {
        ang1 %= (2 * Math.PI);
        ang1 = (ang1 < 0) ? ang1 + (2 * Math.PI) : ang1;
        ang2 %= (2 * Math.PI);
        ang2 = (ang2 < 0) ? ang2 + (2 * Math.PI) : ang2;
        var ab = 0;
        if (ang1 < ang2) {
            ab = ang2 - ang1;
        }
        else {
            ab = ang1 - ang2;
        }
        if (ab > Math.PI) {
            ab = Math.PI * 2 - ab;
        }
        return ab;
    };
    BoneLookController.prototype._isAngleBetween = function (ang, ang1, ang2) {
        ang %= (2 * Math.PI);
        ang = (ang < 0) ? ang + (2 * Math.PI) : ang;
        ang1 %= (2 * Math.PI);
        ang1 = (ang1 < 0) ? ang1 + (2 * Math.PI) : ang1;
        ang2 %= (2 * Math.PI);
        ang2 = (ang2 < 0) ? ang2 + (2 * Math.PI) : ang2;
        if (ang1 < ang2) {
            if (ang > ang1 && ang < ang2) {
                return true;
            }
        }
        else {
            if (ang > ang2 && ang < ang1) {
                return true;
            }
        }
        return false;
    };
    BoneLookController._tmpVecs = _Misc_arrayTools__WEBPACK_IMPORTED_MODULE_0__.ArrayTools.BuildArray(10, _Maths_math_vector__WEBPACK_IMPORTED_MODULE_1__.Vector3.Zero);
    BoneLookController._tmpQuat = _Maths_math_vector__WEBPACK_IMPORTED_MODULE_1__.Quaternion.Identity();
    BoneLookController._tmpMats = _Misc_arrayTools__WEBPACK_IMPORTED_MODULE_0__.ArrayTools.BuildArray(5, _Maths_math_vector__WEBPACK_IMPORTED_MODULE_1__.Matrix.Identity);
    return BoneLookController;
}());

//# sourceMappingURL=boneLookController.js.map

/***/ }),

/***/ "./node_modules/@babylonjs/core/Bones/index.js":
/*!*****************************************************!*\
  !*** ./node_modules/@babylonjs/core/Bones/index.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Bone": () => (/* reexport safe */ _bone__WEBPACK_IMPORTED_MODULE_0__.Bone),
/* harmony export */   "BoneIKController": () => (/* reexport safe */ _boneIKController__WEBPACK_IMPORTED_MODULE_1__.BoneIKController),
/* harmony export */   "BoneLookController": () => (/* reexport safe */ _boneLookController__WEBPACK_IMPORTED_MODULE_2__.BoneLookController),
/* harmony export */   "Skeleton": () => (/* reexport safe */ _skeleton__WEBPACK_IMPORTED_MODULE_3__.Skeleton)
/* harmony export */ });
/* harmony import */ var _bone__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./bone */ "./node_modules/@babylonjs/core/Bones/bone.js");
/* harmony import */ var _boneIKController__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./boneIKController */ "./node_modules/@babylonjs/core/Bones/boneIKController.js");
/* harmony import */ var _boneLookController__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./boneLookController */ "./node_modules/@babylonjs/core/Bones/boneLookController.js");
/* harmony import */ var _skeleton__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./skeleton */ "./node_modules/@babylonjs/core/Bones/skeleton.js");




//# sourceMappingURL=index.js.map

/***/ }),

/***/ "./node_modules/@babylonjs/core/Bones/skeleton.js":
/*!********************************************************!*\
  !*** ./node_modules/@babylonjs/core/Bones/skeleton.js ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Skeleton": () => (/* binding */ Skeleton)
/* harmony export */ });
/* harmony import */ var _bone__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./bone */ "./node_modules/@babylonjs/core/Bones/bone.js");
/* harmony import */ var _Misc_observable__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Misc/observable */ "./node_modules/@babylonjs/core/Misc/observable.js");
/* harmony import */ var _Maths_math_vector__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Maths/math.vector */ "./node_modules/@babylonjs/core/Maths/math.vector.js");
/* harmony import */ var _Materials_Textures_rawTexture__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../Materials/Textures/rawTexture */ "./node_modules/@babylonjs/core/Materials/Textures/rawTexture.js");
/* harmony import */ var _Animations_animation__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../Animations/animation */ "./node_modules/@babylonjs/core/Animations/animation.js");
/* harmony import */ var _Animations_animationRange__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../Animations/animationRange */ "./node_modules/@babylonjs/core/Animations/animationRange.js");
/* harmony import */ var _Engines_engineStore__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../Engines/engineStore */ "./node_modules/@babylonjs/core/Engines/engineStore.js");
/* harmony import */ var _Misc_logger__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../Misc/logger */ "./node_modules/@babylonjs/core/Misc/logger.js");
/* harmony import */ var _Misc_deepCopier__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../Misc/deepCopier */ "./node_modules/@babylonjs/core/Misc/deepCopier.js");









/**
 * Class used to handle skinning animations
 * @see http://doc.babylonjs.com/how_to/how_to_use_bones_and_skeletons
 */
var Skeleton = /** @class */ (function () {
    /**
     * Creates a new skeleton
     * @param name defines the skeleton name
     * @param id defines the skeleton Id
     * @param scene defines the hosting scene
     */
    function Skeleton(
    /** defines the skeleton name */
    name, 
    /** defines the skeleton Id */
    id, scene) {
        this.name = name;
        this.id = id;
        /**
         * Defines the list of child bones
         */
        this.bones = new Array();
        /**
         * Defines a boolean indicating if the root matrix is provided by meshes or by the current skeleton (this is the default value)
         */
        this.needInitialSkinMatrix = false;
        /**
         * Defines a mesh that override the matrix used to get the world matrix (null by default).
         */
        this.overrideMesh = null;
        this._isDirty = true;
        this._meshesWithPoseMatrix = new Array();
        this._identity = _Maths_math_vector__WEBPACK_IMPORTED_MODULE_2__.Matrix.Identity();
        this._ranges = {};
        this._lastAbsoluteTransformsUpdateId = -1;
        this._canUseTextureForBones = false;
        this._uniqueId = 0;
        /** @hidden */
        this._numBonesWithLinkedTransformNode = 0;
        /** @hidden */
        this._hasWaitingData = null;
        /**
         * Specifies if the skeleton should be serialized
         */
        this.doNotSerialize = false;
        this._useTextureToStoreBoneMatrices = true;
        this._animationPropertiesOverride = null;
        // Events
        /**
         * An observable triggered before computing the skeleton's matrices
         */
        this.onBeforeComputeObservable = new _Misc_observable__WEBPACK_IMPORTED_MODULE_1__.Observable();
        this.bones = [];
        this._scene = scene || _Engines_engineStore__WEBPACK_IMPORTED_MODULE_6__.EngineStore.LastCreatedScene;
        this._uniqueId = this._scene.getUniqueId();
        this._scene.addSkeleton(this);
        //make sure it will recalculate the matrix next time prepare is called.
        this._isDirty = true;
        var engineCaps = this._scene.getEngine().getCaps();
        this._canUseTextureForBones = engineCaps.textureFloat && engineCaps.maxVertexTextureImageUnits > 0;
    }
    Object.defineProperty(Skeleton.prototype, "useTextureToStoreBoneMatrices", {
        /**
         * Gets or sets a boolean indicating that bone matrices should be stored as a texture instead of using shader uniforms (default is true).
         * Please note that this option is not available if the hardware does not support it
         */
        get: function () {
            return this._useTextureToStoreBoneMatrices;
        },
        set: function (value) {
            this._useTextureToStoreBoneMatrices = value;
            this._markAsDirty();
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(Skeleton.prototype, "animationPropertiesOverride", {
        /**
         * Gets or sets the animation properties override
         */
        get: function () {
            if (!this._animationPropertiesOverride) {
                return this._scene.animationPropertiesOverride;
            }
            return this._animationPropertiesOverride;
        },
        set: function (value) {
            this._animationPropertiesOverride = value;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(Skeleton.prototype, "isUsingTextureForMatrices", {
        /**
         * Gets a boolean indicating that the skeleton effectively stores matrices into a texture
         */
        get: function () {
            return this.useTextureToStoreBoneMatrices && this._canUseTextureForBones;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(Skeleton.prototype, "uniqueId", {
        /**
         * Gets the unique ID of this skeleton
         */
        get: function () {
            return this._uniqueId;
        },
        enumerable: true,
        configurable: true
    });
    /**
     * Gets the current object class name.
     * @return the class name
     */
    Skeleton.prototype.getClassName = function () {
        return "Skeleton";
    };
    /**
     * Returns an array containing the root bones
     * @returns an array containing the root bones
     */
    Skeleton.prototype.getChildren = function () {
        return this.bones.filter(function (b) { return !b.getParent(); });
    };
    // Members
    /**
     * Gets the list of transform matrices to send to shaders (one matrix per bone)
     * @param mesh defines the mesh to use to get the root matrix (if needInitialSkinMatrix === true)
     * @returns a Float32Array containing matrices data
     */
    Skeleton.prototype.getTransformMatrices = function (mesh) {
        if (this.needInitialSkinMatrix && mesh._bonesTransformMatrices) {
            return mesh._bonesTransformMatrices;
        }
        if (!this._transformMatrices) {
            this.prepare();
        }
        return this._transformMatrices;
    };
    /**
     * Gets the list of transform matrices to send to shaders inside a texture (one matrix per bone)
     * @param mesh defines the mesh to use to get the root matrix (if needInitialSkinMatrix === true)
     * @returns a raw texture containing the data
     */
    Skeleton.prototype.getTransformMatrixTexture = function (mesh) {
        if (this.needInitialSkinMatrix && mesh._transformMatrixTexture) {
            return mesh._transformMatrixTexture;
        }
        return this._transformMatrixTexture;
    };
    /**
     * Gets the current hosting scene
     * @returns a scene object
     */
    Skeleton.prototype.getScene = function () {
        return this._scene;
    };
    // Methods
    /**
     * Gets a string representing the current skeleton data
     * @param fullDetails defines a boolean indicating if we want a verbose version
     * @returns a string representing the current skeleton data
     */
    Skeleton.prototype.toString = function (fullDetails) {
        var ret = "Name: " + this.name + ", nBones: " + this.bones.length;
        ret += ", nAnimationRanges: " + (this._ranges ? Object.keys(this._ranges).length : "none");
        if (fullDetails) {
            ret += ", Ranges: {";
            var first = true;
            for (var name_1 in this._ranges) {
                if (first) {
                    ret += ", ";
                    first = false;
                }
                ret += name_1;
            }
            ret += "}";
        }
        return ret;
    };
    /**
    * Get bone's index searching by name
    * @param name defines bone's name to search for
    * @return the indice of the bone. Returns -1 if not found
    */
    Skeleton.prototype.getBoneIndexByName = function (name) {
        for (var boneIndex = 0, cache = this.bones.length; boneIndex < cache; boneIndex++) {
            if (this.bones[boneIndex].name === name) {
                return boneIndex;
            }
        }
        return -1;
    };
    /**
     * Creater a new animation range
     * @param name defines the name of the range
     * @param from defines the start key
     * @param to defines the end key
     */
    Skeleton.prototype.createAnimationRange = function (name, from, to) {
        // check name not already in use
        if (!this._ranges[name]) {
            this._ranges[name] = new _Animations_animationRange__WEBPACK_IMPORTED_MODULE_5__.AnimationRange(name, from, to);
            for (var i = 0, nBones = this.bones.length; i < nBones; i++) {
                if (this.bones[i].animations[0]) {
                    this.bones[i].animations[0].createRange(name, from, to);
                }
            }
        }
    };
    /**
     * Delete a specific animation range
     * @param name defines the name of the range
     * @param deleteFrames defines if frames must be removed as well
     */
    Skeleton.prototype.deleteAnimationRange = function (name, deleteFrames) {
        if (deleteFrames === void 0) { deleteFrames = true; }
        for (var i = 0, nBones = this.bones.length; i < nBones; i++) {
            if (this.bones[i].animations[0]) {
                this.bones[i].animations[0].deleteRange(name, deleteFrames);
            }
        }
        this._ranges[name] = null; // said much faster than 'delete this._range[name]'
    };
    /**
     * Gets a specific animation range
     * @param name defines the name of the range to look for
     * @returns the requested animation range or null if not found
     */
    Skeleton.prototype.getAnimationRange = function (name) {
        return this._ranges[name];
    };
    /**
     * Gets the list of all animation ranges defined on this skeleton
     * @returns an array
     */
    Skeleton.prototype.getAnimationRanges = function () {
        var animationRanges = [];
        var name;
        for (name in this._ranges) {
            animationRanges.push(this._ranges[name]);
        }
        return animationRanges;
    };
    /**
     * Copy animation range from a source skeleton.
     * This is not for a complete retargeting, only between very similar skeleton's with only possible bone length differences
     * @param source defines the source skeleton
     * @param name defines the name of the range to copy
     * @param rescaleAsRequired defines if rescaling must be applied if required
     * @returns true if operation was successful
     */
    Skeleton.prototype.copyAnimationRange = function (source, name, rescaleAsRequired) {
        if (rescaleAsRequired === void 0) { rescaleAsRequired = false; }
        if (this._ranges[name] || !source.getAnimationRange(name)) {
            return false;
        }
        var ret = true;
        var frameOffset = this._getHighestAnimationFrame() + 1;
        // make a dictionary of source skeleton's bones, so exact same order or doublely nested loop is not required
        var boneDict = {};
        var sourceBones = source.bones;
        var nBones;
        var i;
        for (i = 0, nBones = sourceBones.length; i < nBones; i++) {
            boneDict[sourceBones[i].name] = sourceBones[i];
        }
        if (this.bones.length !== sourceBones.length) {
            _Misc_logger__WEBPACK_IMPORTED_MODULE_7__.Logger.Warn("copyAnimationRange: this rig has " + this.bones.length + " bones, while source as " + sourceBones.length);
            ret = false;
        }
        var skelDimensionsRatio = (rescaleAsRequired && this.dimensionsAtRest && source.dimensionsAtRest) ? this.dimensionsAtRest.divide(source.dimensionsAtRest) : null;
        for (i = 0, nBones = this.bones.length; i < nBones; i++) {
            var boneName = this.bones[i].name;
            var sourceBone = boneDict[boneName];
            if (sourceBone) {
                ret = ret && this.bones[i].copyAnimationRange(sourceBone, name, frameOffset, rescaleAsRequired, skelDimensionsRatio);
            }
            else {
                _Misc_logger__WEBPACK_IMPORTED_MODULE_7__.Logger.Warn("copyAnimationRange: not same rig, missing source bone " + boneName);
                ret = false;
            }
        }
        // do not call createAnimationRange(), since it also is done to bones, which was already done
        var range = source.getAnimationRange(name);
        if (range) {
            this._ranges[name] = new _Animations_animationRange__WEBPACK_IMPORTED_MODULE_5__.AnimationRange(name, range.from + frameOffset, range.to + frameOffset);
        }
        return ret;
    };
    /**
     * Forces the skeleton to go to rest pose
     */
    Skeleton.prototype.returnToRest = function () {
        for (var index = 0; index < this.bones.length; index++) {
            this.bones[index].returnToRest();
        }
    };
    Skeleton.prototype._getHighestAnimationFrame = function () {
        var ret = 0;
        for (var i = 0, nBones = this.bones.length; i < nBones; i++) {
            if (this.bones[i].animations[0]) {
                var highest = this.bones[i].animations[0].getHighestFrame();
                if (ret < highest) {
                    ret = highest;
                }
            }
        }
        return ret;
    };
    /**
     * Begin a specific animation range
     * @param name defines the name of the range to start
     * @param loop defines if looping must be turned on (false by default)
     * @param speedRatio defines the speed ratio to apply (1 by default)
     * @param onAnimationEnd defines a callback which will be called when animation will end
     * @returns a new animatable
     */
    Skeleton.prototype.beginAnimation = function (name, loop, speedRatio, onAnimationEnd) {
        var range = this.getAnimationRange(name);
        if (!range) {
            return null;
        }
        return this._scene.beginAnimation(this, range.from, range.to, loop, speedRatio, onAnimationEnd);
    };
    /** @hidden */
    Skeleton.prototype._markAsDirty = function () {
        this._isDirty = true;
    };
    /** @hidden */
    Skeleton.prototype._registerMeshWithPoseMatrix = function (mesh) {
        this._meshesWithPoseMatrix.push(mesh);
    };
    /** @hidden */
    Skeleton.prototype._unregisterMeshWithPoseMatrix = function (mesh) {
        var index = this._meshesWithPoseMatrix.indexOf(mesh);
        if (index > -1) {
            this._meshesWithPoseMatrix.splice(index, 1);
        }
    };
    Skeleton.prototype._computeTransformMatrices = function (targetMatrix, initialSkinMatrix) {
        this.onBeforeComputeObservable.notifyObservers(this);
        for (var index = 0; index < this.bones.length; index++) {
            var bone = this.bones[index];
            bone._childUpdateId++;
            var parentBone = bone.getParent();
            if (parentBone) {
                bone.getLocalMatrix().multiplyToRef(parentBone.getWorldMatrix(), bone.getWorldMatrix());
            }
            else {
                if (initialSkinMatrix) {
                    bone.getLocalMatrix().multiplyToRef(initialSkinMatrix, bone.getWorldMatrix());
                }
                else {
                    bone.getWorldMatrix().copyFrom(bone.getLocalMatrix());
                }
            }
            if (bone._index !== -1) {
                var mappedIndex = bone._index === null ? index : bone._index;
                bone.getInvertedAbsoluteTransform().multiplyToArray(bone.getWorldMatrix(), targetMatrix, mappedIndex * 16);
            }
        }
        this._identity.copyToArray(targetMatrix, this.bones.length * 16);
    };
    /**
     * Build all resources required to render a skeleton
     */
    Skeleton.prototype.prepare = function () {
        // Update the local matrix of bones with linked transform nodes.
        if (this._numBonesWithLinkedTransformNode > 0) {
            for (var _i = 0, _a = this.bones; _i < _a.length; _i++) {
                var bone_1 = _a[_i];
                if (bone_1._linkedTransformNode) {
                    // Computing the world matrix also computes the local matrix.
                    bone_1._linkedTransformNode.computeWorldMatrix();
                    bone_1._matrix = bone_1._linkedTransformNode._localMatrix;
                    bone_1.markAsDirty();
                }
            }
        }
        if (!this._isDirty) {
            return;
        }
        if (this.needInitialSkinMatrix) {
            for (var index = 0; index < this._meshesWithPoseMatrix.length; index++) {
                var mesh = this._meshesWithPoseMatrix[index];
                var poseMatrix = mesh.getPoseMatrix();
                if (!mesh._bonesTransformMatrices || mesh._bonesTransformMatrices.length !== 16 * (this.bones.length + 1)) {
                    mesh._bonesTransformMatrices = new Float32Array(16 * (this.bones.length + 1));
                }
                if (this._synchronizedWithMesh !== mesh) {
                    this._synchronizedWithMesh = mesh;
                    // Prepare bones
                    for (var boneIndex = 0; boneIndex < this.bones.length; boneIndex++) {
                        var bone = this.bones[boneIndex];
                        if (!bone.getParent()) {
                            var matrix = bone.getBaseMatrix();
                            matrix.multiplyToRef(poseMatrix, _Maths_math_vector__WEBPACK_IMPORTED_MODULE_2__.TmpVectors.Matrix[1]);
                            bone._updateDifferenceMatrix(_Maths_math_vector__WEBPACK_IMPORTED_MODULE_2__.TmpVectors.Matrix[1]);
                        }
                    }
                    if (this.isUsingTextureForMatrices) {
                        var textureWidth = (this.bones.length + 1) * 4;
                        if (!mesh._transformMatrixTexture || mesh._transformMatrixTexture.getSize().width !== textureWidth) {
                            if (mesh._transformMatrixTexture) {
                                mesh._transformMatrixTexture.dispose();
                            }
                            mesh._transformMatrixTexture = _Materials_Textures_rawTexture__WEBPACK_IMPORTED_MODULE_3__.RawTexture.CreateRGBATexture(mesh._bonesTransformMatrices, (this.bones.length + 1) * 4, 1, this._scene, false, false, 1, 1);
                        }
                    }
                }
                this._computeTransformMatrices(mesh._bonesTransformMatrices, poseMatrix);
                if (this.isUsingTextureForMatrices && mesh._transformMatrixTexture) {
                    mesh._transformMatrixTexture.update(mesh._bonesTransformMatrices);
                }
            }
        }
        else {
            if (!this._transformMatrices || this._transformMatrices.length !== 16 * (this.bones.length + 1)) {
                this._transformMatrices = new Float32Array(16 * (this.bones.length + 1));
                if (this.isUsingTextureForMatrices) {
                    if (this._transformMatrixTexture) {
                        this._transformMatrixTexture.dispose();
                    }
                    this._transformMatrixTexture = _Materials_Textures_rawTexture__WEBPACK_IMPORTED_MODULE_3__.RawTexture.CreateRGBATexture(this._transformMatrices, (this.bones.length + 1) * 4, 1, this._scene, false, false, 1, 1);
                }
            }
            this._computeTransformMatrices(this._transformMatrices, null);
            if (this.isUsingTextureForMatrices && this._transformMatrixTexture) {
                this._transformMatrixTexture.update(this._transformMatrices);
            }
        }
        this._isDirty = false;
        this._scene._activeBones.addCount(this.bones.length, false);
    };
    /**
     * Gets the list of animatables currently running for this skeleton
     * @returns an array of animatables
     */
    Skeleton.prototype.getAnimatables = function () {
        if (!this._animatables || this._animatables.length !== this.bones.length) {
            this._animatables = [];
            for (var index = 0; index < this.bones.length; index++) {
                this._animatables.push(this.bones[index]);
            }
        }
        return this._animatables;
    };
    /**
     * Clone the current skeleton
     * @param name defines the name of the new skeleton
     * @param id defines the id of the new skeleton
     * @returns the new skeleton
     */
    Skeleton.prototype.clone = function (name, id) {
        var result = new Skeleton(name, id || name, this._scene);
        result.needInitialSkinMatrix = this.needInitialSkinMatrix;
        result.overrideMesh = this.overrideMesh;
        for (var index = 0; index < this.bones.length; index++) {
            var source = this.bones[index];
            var parentBone = null;
            var parent_1 = source.getParent();
            if (parent_1) {
                var parentIndex = this.bones.indexOf(parent_1);
                parentBone = result.bones[parentIndex];
            }
            var bone = new _bone__WEBPACK_IMPORTED_MODULE_0__.Bone(source.name, result, parentBone, source.getBaseMatrix().clone(), source.getRestPose().clone());
            bone._index = source._index;
            if (source._linkedTransformNode) {
                bone.linkTransformNode(source._linkedTransformNode);
            }
            _Misc_deepCopier__WEBPACK_IMPORTED_MODULE_8__.DeepCopier.DeepCopy(source.animations, bone.animations);
        }
        if (this._ranges) {
            result._ranges = {};
            for (var rangeName in this._ranges) {
                var range = this._ranges[rangeName];
                if (range) {
                    result._ranges[rangeName] = range.clone();
                }
            }
        }
        this._isDirty = true;
        return result;
    };
    /**
     * Enable animation blending for this skeleton
     * @param blendingSpeed defines the blending speed to apply
     * @see http://doc.babylonjs.com/babylon101/animations#animation-blending
     */
    Skeleton.prototype.enableBlending = function (blendingSpeed) {
        if (blendingSpeed === void 0) { blendingSpeed = 0.01; }
        this.bones.forEach(function (bone) {
            bone.animations.forEach(function (animation) {
                animation.enableBlending = true;
                animation.blendingSpeed = blendingSpeed;
            });
        });
    };
    /**
     * Releases all resources associated with the current skeleton
     */
    Skeleton.prototype.dispose = function () {
        this._meshesWithPoseMatrix = [];
        // Animations
        this.getScene().stopAnimation(this);
        // Remove from scene
        this.getScene().removeSkeleton(this);
        if (this._transformMatrixTexture) {
            this._transformMatrixTexture.dispose();
            this._transformMatrixTexture = null;
        }
    };
    /**
     * Serialize the skeleton in a JSON object
     * @returns a JSON object
     */
    Skeleton.prototype.serialize = function () {
        var serializationObject = {};
        serializationObject.name = this.name;
        serializationObject.id = this.id;
        if (this.dimensionsAtRest) {
            serializationObject.dimensionsAtRest = this.dimensionsAtRest.asArray();
        }
        serializationObject.bones = [];
        serializationObject.needInitialSkinMatrix = this.needInitialSkinMatrix;
        for (var index = 0; index < this.bones.length; index++) {
            var bone = this.bones[index];
            var parent_2 = bone.getParent();
            var serializedBone = {
                parentBoneIndex: parent_2 ? this.bones.indexOf(parent_2) : -1,
                name: bone.name,
                matrix: bone.getBaseMatrix().toArray(),
                rest: bone.getRestPose().toArray()
            };
            serializationObject.bones.push(serializedBone);
            if (bone.length) {
                serializedBone.length = bone.length;
            }
            if (bone.metadata) {
                serializedBone.metadata = bone.metadata;
            }
            if (bone.animations && bone.animations.length > 0) {
                serializedBone.animation = bone.animations[0].serialize();
            }
            serializationObject.ranges = [];
            for (var name in this._ranges) {
                var source = this._ranges[name];
                if (!source) {
                    continue;
                }
                var range = {};
                range.name = name;
                range.from = source.from;
                range.to = source.to;
                serializationObject.ranges.push(range);
            }
        }
        return serializationObject;
    };
    /**
     * Creates a new skeleton from serialized data
     * @param parsedSkeleton defines the serialized data
     * @param scene defines the hosting scene
     * @returns a new skeleton
     */
    Skeleton.Parse = function (parsedSkeleton, scene) {
        var skeleton = new Skeleton(parsedSkeleton.name, parsedSkeleton.id, scene);
        if (parsedSkeleton.dimensionsAtRest) {
            skeleton.dimensionsAtRest = _Maths_math_vector__WEBPACK_IMPORTED_MODULE_2__.Vector3.FromArray(parsedSkeleton.dimensionsAtRest);
        }
        skeleton.needInitialSkinMatrix = parsedSkeleton.needInitialSkinMatrix;
        var index;
        for (index = 0; index < parsedSkeleton.bones.length; index++) {
            var parsedBone = parsedSkeleton.bones[index];
            var parentBone = null;
            if (parsedBone.parentBoneIndex > -1) {
                parentBone = skeleton.bones[parsedBone.parentBoneIndex];
            }
            var rest = parsedBone.rest ? _Maths_math_vector__WEBPACK_IMPORTED_MODULE_2__.Matrix.FromArray(parsedBone.rest) : null;
            var bone = new _bone__WEBPACK_IMPORTED_MODULE_0__.Bone(parsedBone.name, skeleton, parentBone, _Maths_math_vector__WEBPACK_IMPORTED_MODULE_2__.Matrix.FromArray(parsedBone.matrix), rest);
            if (parsedBone.id !== undefined && parsedBone.id !== null) {
                bone.id = parsedBone.id;
            }
            if (parsedBone.length) {
                bone.length = parsedBone.length;
            }
            if (parsedBone.metadata) {
                bone.metadata = parsedBone.metadata;
            }
            if (parsedBone.animation) {
                bone.animations.push(_Animations_animation__WEBPACK_IMPORTED_MODULE_4__.Animation.Parse(parsedBone.animation));
            }
            if (parsedBone.linkedTransformNodeId !== undefined && parsedBone.linkedTransformNodeId !== null) {
                skeleton._hasWaitingData = true;
                bone._waitingTransformNodeId = parsedBone.linkedTransformNodeId;
            }
        }
        // placed after bones, so createAnimationRange can cascade down
        if (parsedSkeleton.ranges) {
            for (index = 0; index < parsedSkeleton.ranges.length; index++) {
                var data = parsedSkeleton.ranges[index];
                skeleton.createAnimationRange(data.name, data.from, data.to);
            }
        }
        return skeleton;
    };
    /**
     * Compute all node absolute transforms
     * @param forceUpdate defines if computation must be done even if cache is up to date
     */
    Skeleton.prototype.computeAbsoluteTransforms = function (forceUpdate) {
        if (forceUpdate === void 0) { forceUpdate = false; }
        var renderId = this._scene.getRenderId();
        if (this._lastAbsoluteTransformsUpdateId != renderId || forceUpdate) {
            this.bones[0].computeAbsoluteTransforms();
            this._lastAbsoluteTransformsUpdateId = renderId;
        }
    };
    /**
     * Gets the root pose matrix
     * @returns a matrix
     */
    Skeleton.prototype.getPoseMatrix = function () {
        var poseMatrix = null;
        if (this._meshesWithPoseMatrix.length > 0) {
            poseMatrix = this._meshesWithPoseMatrix[0].getPoseMatrix();
        }
        return poseMatrix;
    };
    /**
     * Sorts bones per internal index
     */
    Skeleton.prototype.sortBones = function () {
        var bones = new Array();
        var visited = new Array(this.bones.length);
        for (var index = 0; index < this.bones.length; index++) {
            this._sortBones(index, bones, visited);
        }
        this.bones = bones;
    };
    Skeleton.prototype._sortBones = function (index, bones, visited) {
        if (visited[index]) {
            return;
        }
        visited[index] = true;
        var bone = this.bones[index];
        if (bone._index === undefined) {
            bone._index = index;
        }
        var parentBone = bone.getParent();
        if (parentBone) {
            this._sortBones(this.bones.indexOf(parentBone), bones, visited);
        }
        bones.push(bone);
    };
    return Skeleton;
}());

//# sourceMappingURL=skeleton.js.map

/***/ }),

/***/ "./node_modules/@babylonjs/core/Cameras/Inputs/BaseCameraPointersInput.js":
/*!********************************************************************************!*\
  !*** ./node_modules/@babylonjs/core/Cameras/Inputs/BaseCameraPointersInput.js ***!
  \********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "BaseCameraPointersInput": () => (/* binding */ BaseCameraPointersInput)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _Misc_decorators__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../Misc/decorators */ "./node_modules/@babylonjs/core/Misc/decorators.js");
/* harmony import */ var _Misc_tools__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../Misc/tools */ "./node_modules/@babylonjs/core/Misc/tools.js");
/* harmony import */ var _Events_pointerEvents__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../Events/pointerEvents */ "./node_modules/@babylonjs/core/Events/pointerEvents.js");




/**
 * Base class for Camera Pointer Inputs.
 * See FollowCameraPointersInput in src/Cameras/Inputs/followCameraPointersInput.ts
 * for example usage.
 */
var BaseCameraPointersInput = /** @class */ (function () {
    function BaseCameraPointersInput() {
        /**
         * Defines the buttons associated with the input to handle camera move.
         */
        this.buttons = [0, 1, 2];
    }
    /**
     * Attach the input controls to a specific dom element to get the input from.
     * @param element Defines the element the controls should be listened from
     * @param noPreventDefault Defines whether event caught by the controls should call preventdefault() (https://developer.mozilla.org/en-US/docs/Web/API/Event/preventDefault)
     */
    BaseCameraPointersInput.prototype.attachControl = function (element, noPreventDefault) {
        var _this = this;
        var engine = this.camera.getEngine();
        var previousPinchSquaredDistance = 0;
        var previousMultiTouchPanPosition = null;
        this.pointA = null;
        this.pointB = null;
        this._altKey = false;
        this._ctrlKey = false;
        this._metaKey = false;
        this._shiftKey = false;
        this._buttonsPressed = 0;
        this._pointerInput = function (p, s) {
            var evt = p.event;
            var isTouch = evt.pointerType === "touch";
            if (engine.isInVRExclusivePointerMode) {
                return;
            }
            if (p.type !== _Events_pointerEvents__WEBPACK_IMPORTED_MODULE_2__.PointerEventTypes.POINTERMOVE &&
                _this.buttons.indexOf(evt.button) === -1) {
                return;
            }
            var srcElement = (evt.srcElement || evt.target);
            _this._altKey = evt.altKey;
            _this._ctrlKey = evt.ctrlKey;
            _this._metaKey = evt.metaKey;
            _this._shiftKey = evt.shiftKey;
            _this._buttonsPressed = evt.buttons;
            if (engine.isPointerLock) {
                var offsetX = evt.movementX ||
                    evt.mozMovementX ||
                    evt.webkitMovementX ||
                    evt.msMovementX ||
                    0;
                var offsetY = evt.movementY ||
                    evt.mozMovementY ||
                    evt.webkitMovementY ||
                    evt.msMovementY ||
                    0;
                _this.onTouch(null, offsetX, offsetY);
                _this.pointA = null;
                _this.pointB = null;
            }
            else if (p.type === _Events_pointerEvents__WEBPACK_IMPORTED_MODULE_2__.PointerEventTypes.POINTERDOWN && srcElement) {
                try {
                    srcElement.setPointerCapture(evt.pointerId);
                }
                catch (e) {
                    //Nothing to do with the error. Execution will continue.
                }
                if (_this.pointA === null) {
                    _this.pointA = { x: evt.clientX,
                        y: evt.clientY,
                        pointerId: evt.pointerId,
                        type: evt.pointerType };
                }
                else if (_this.pointB === null) {
                    _this.pointB = { x: evt.clientX,
                        y: evt.clientY,
                        pointerId: evt.pointerId,
                        type: evt.pointerType };
                }
                _this.onButtonDown(evt);
                if (!noPreventDefault) {
                    evt.preventDefault();
                    element.focus();
                }
            }
            else if (p.type === _Events_pointerEvents__WEBPACK_IMPORTED_MODULE_2__.PointerEventTypes.POINTERDOUBLETAP) {
                _this.onDoubleTap(evt.pointerType);
            }
            else if (p.type === _Events_pointerEvents__WEBPACK_IMPORTED_MODULE_2__.PointerEventTypes.POINTERUP && srcElement) {
                try {
                    srcElement.releasePointerCapture(evt.pointerId);
                }
                catch (e) {
                    //Nothing to do with the error.
                }
                if (!isTouch) {
                    _this.pointB = null; // Mouse and pen are mono pointer
                }
                //would be better to use pointers.remove(evt.pointerId) for multitouch gestures,
                //but emptying completely pointers collection is required to fix a bug on iPhone :
                //when changing orientation while pinching camera,
                //one pointer stay pressed forever if we don't release all pointers
                //will be ok to put back pointers.remove(evt.pointerId); when iPhone bug corrected
                if (engine._badOS) {
                    _this.pointA = _this.pointB = null;
                }
                else {
                    //only remove the impacted pointer in case of multitouch allowing on most
                    //platforms switching from rotate to zoom and pan seamlessly.
                    if (_this.pointB && _this.pointA && _this.pointA.pointerId == evt.pointerId) {
                        _this.pointA = _this.pointB;
                        _this.pointB = null;
                    }
                    else if (_this.pointA && _this.pointB &&
                        _this.pointB.pointerId == evt.pointerId) {
                        _this.pointB = null;
                    }
                    else {
                        _this.pointA = _this.pointB = null;
                    }
                }
                if (previousPinchSquaredDistance !== 0 || previousMultiTouchPanPosition) {
                    // Previous pinch data is populated but a button has been lifted
                    // so pinch has ended.
                    _this.onMultiTouch(_this.pointA, _this.pointB, previousPinchSquaredDistance, 0, // pinchSquaredDistance
                    previousMultiTouchPanPosition, null // multiTouchPanPosition
                    );
                    previousPinchSquaredDistance = 0;
                    previousMultiTouchPanPosition = null;
                }
                _this.onButtonUp(evt);
                if (!noPreventDefault) {
                    evt.preventDefault();
                }
            }
            else if (p.type === _Events_pointerEvents__WEBPACK_IMPORTED_MODULE_2__.PointerEventTypes.POINTERMOVE) {
                if (!noPreventDefault) {
                    evt.preventDefault();
                }
                // One button down
                if (_this.pointA && _this.pointB === null) {
                    var offsetX = evt.clientX - _this.pointA.x;
                    var offsetY = evt.clientY - _this.pointA.y;
                    _this.onTouch(_this.pointA, offsetX, offsetY);
                    _this.pointA.x = evt.clientX;
                    _this.pointA.y = evt.clientY;
                }
                // Two buttons down: pinch
                else if (_this.pointA && _this.pointB) {
                    var ed = (_this.pointA.pointerId === evt.pointerId) ?
                        _this.pointA : _this.pointB;
                    ed.x = evt.clientX;
                    ed.y = evt.clientY;
                    var distX = _this.pointA.x - _this.pointB.x;
                    var distY = _this.pointA.y - _this.pointB.y;
                    var pinchSquaredDistance = (distX * distX) + (distY * distY);
                    var multiTouchPanPosition = { x: (_this.pointA.x + _this.pointB.x) / 2,
                        y: (_this.pointA.y + _this.pointB.y) / 2,
                        pointerId: evt.pointerId,
                        type: p.type };
                    _this.onMultiTouch(_this.pointA, _this.pointB, previousPinchSquaredDistance, pinchSquaredDistance, previousMultiTouchPanPosition, multiTouchPanPosition);
                    previousMultiTouchPanPosition = multiTouchPanPosition;
                    previousPinchSquaredDistance = pinchSquaredDistance;
                }
            }
        };
        this._observer = this.camera.getScene().onPointerObservable.add(this._pointerInput, _Events_pointerEvents__WEBPACK_IMPORTED_MODULE_2__.PointerEventTypes.POINTERDOWN | _Events_pointerEvents__WEBPACK_IMPORTED_MODULE_2__.PointerEventTypes.POINTERUP |
            _Events_pointerEvents__WEBPACK_IMPORTED_MODULE_2__.PointerEventTypes.POINTERMOVE);
        this._onLostFocus = function () {
            _this.pointA = _this.pointB = null;
            previousPinchSquaredDistance = 0;
            previousMultiTouchPanPosition = null;
            _this.onLostFocus();
        };
        element.addEventListener("contextmenu", this.onContextMenu.bind(this), false);
        var hostWindow = this.camera.getScene().getEngine().getHostWindow();
        if (hostWindow) {
            _Misc_tools__WEBPACK_IMPORTED_MODULE_1__.Tools.RegisterTopRootEvents(hostWindow, [
                { name: "blur", handler: this._onLostFocus }
            ]);
        }
    };
    /**
     * Detach the current controls from the specified dom element.
     * @param element Defines the element to stop listening the inputs from
     */
    BaseCameraPointersInput.prototype.detachControl = function (element) {
        if (this._onLostFocus) {
            var hostWindow = this.camera.getScene().getEngine().getHostWindow();
            if (hostWindow) {
                _Misc_tools__WEBPACK_IMPORTED_MODULE_1__.Tools.UnregisterTopRootEvents(hostWindow, [
                    { name: "blur", handler: this._onLostFocus }
                ]);
            }
        }
        if (element && this._observer) {
            this.camera.getScene().onPointerObservable.remove(this._observer);
            this._observer = null;
            if (this.onContextMenu) {
                element.removeEventListener("contextmenu", this.onContextMenu);
            }
            this._onLostFocus = null;
        }
        this._altKey = false;
        this._ctrlKey = false;
        this._metaKey = false;
        this._shiftKey = false;
        this._buttonsPressed = 0;
    };
    /**
     * Gets the class name of the current input.
     * @returns the class name
     */
    BaseCameraPointersInput.prototype.getClassName = function () {
        return "BaseCameraPointersInput";
    };
    /**
     * Get the friendly name associated with the input class.
     * @returns the input friendly name
     */
    BaseCameraPointersInput.prototype.getSimpleName = function () {
        return "pointers";
    };
    /**
     * Called on pointer POINTERDOUBLETAP event.
     * Override this method to provide functionality on POINTERDOUBLETAP event.
     */
    BaseCameraPointersInput.prototype.onDoubleTap = function (type) {
    };
    /**
     * Called on pointer POINTERMOVE event if only a single touch is active.
     * Override this method to provide functionality.
     */
    BaseCameraPointersInput.prototype.onTouch = function (point, offsetX, offsetY) {
    };
    /**
     * Called on pointer POINTERMOVE event if multiple touches are active.
     * Override this method to provide functionality.
     */
    BaseCameraPointersInput.prototype.onMultiTouch = function (pointA, pointB, previousPinchSquaredDistance, pinchSquaredDistance, previousMultiTouchPanPosition, multiTouchPanPosition) {
    };
    /**
     * Called on JS contextmenu event.
     * Override this method to provide functionality.
     */
    BaseCameraPointersInput.prototype.onContextMenu = function (evt) {
        evt.preventDefault();
    };
    /**
     * Called each time a new POINTERDOWN event occurs. Ie, for each button
     * press.
     * Override this method to provide functionality.
     */
    BaseCameraPointersInput.prototype.onButtonDown = function (evt) {
    };
    /**
     * Called each time a new POINTERUP event occurs. Ie, for each button
     * release.
     * Override this method to provide functionality.
     */
    BaseCameraPointersInput.prototype.onButtonUp = function (evt) {
    };
    /**
     * Called when window becomes inactive.
     * Override this method to provide functionality.
     */
    BaseCameraPointersInput.prototype.onLostFocus = function () {
    };
    (0,tslib__WEBPACK_IMPORTED_MODULE_3__.__decorate)([
        (0,_Misc_decorators__WEBPACK_IMPORTED_MODULE_0__.serialize)()
    ], BaseCameraPointersInput.prototype, "buttons", void 0);
    return BaseCameraPointersInput;
}());

//# sourceMappingURL=BaseCameraPointersInput.js.map

/***/ }),

/***/ "./node_modules/@babylonjs/core/Cameras/Inputs/arcRotateCameraGamepadInput.js":
/*!************************************************************************************!*\
  !*** ./node_modules/@babylonjs/core/Cameras/Inputs/arcRotateCameraGamepadInput.js ***!
  \************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ArcRotateCameraGamepadInput": () => (/* binding */ ArcRotateCameraGamepadInput)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _Misc_decorators__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../Misc/decorators */ "./node_modules/@babylonjs/core/Misc/decorators.js");
/* harmony import */ var _Cameras_cameraInputsManager__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../Cameras/cameraInputsManager */ "./node_modules/@babylonjs/core/Cameras/cameraInputsManager.js");
/* harmony import */ var _Gamepads_gamepad__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../Gamepads/gamepad */ "./node_modules/@babylonjs/core/Gamepads/gamepad.js");




/**
 * Manage the gamepad inputs to control an arc rotate camera.
 * @see http://doc.babylonjs.com/how_to/customizing_camera_inputs
 */
var ArcRotateCameraGamepadInput = /** @class */ (function () {
    function ArcRotateCameraGamepadInput() {
        /**
         * Defines the gamepad rotation sensiblity.
         * This is the threshold from when rotation starts to be accounted for to prevent jittering.
         */
        this.gamepadRotationSensibility = 80;
        /**
         * Defines the gamepad move sensiblity.
         * This is the threshold from when moving starts to be accounted for for to prevent jittering.
         */
        this.gamepadMoveSensibility = 40;
        this._yAxisScale = 1.0;
    }
    Object.defineProperty(ArcRotateCameraGamepadInput.prototype, "invertYAxis", {
        /**
         * Gets or sets a boolean indicating that Yaxis (for right stick) should be inverted
         */
        get: function () {
            return this._yAxisScale !== 1.0;
        },
        set: function (value) {
            this._yAxisScale = value ? -1.0 : 1.0;
        },
        enumerable: true,
        configurable: true
    });
    /**
     * Attach the input controls to a specific dom element to get the input from.
     * @param element Defines the element the controls should be listened from
     * @param noPreventDefault Defines whether event caught by the controls should call preventdefault() (https://developer.mozilla.org/en-US/docs/Web/API/Event/preventDefault)
     */
    ArcRotateCameraGamepadInput.prototype.attachControl = function (element, noPreventDefault) {
        var _this = this;
        var manager = this.camera.getScene().gamepadManager;
        this._onGamepadConnectedObserver = manager.onGamepadConnectedObservable.add(function (gamepad) {
            if (gamepad.type !== _Gamepads_gamepad__WEBPACK_IMPORTED_MODULE_2__.Gamepad.POSE_ENABLED) {
                // prioritize XBOX gamepads.
                if (!_this.gamepad || gamepad.type === _Gamepads_gamepad__WEBPACK_IMPORTED_MODULE_2__.Gamepad.XBOX) {
                    _this.gamepad = gamepad;
                }
            }
        });
        this._onGamepadDisconnectedObserver = manager.onGamepadDisconnectedObservable.add(function (gamepad) {
            if (_this.gamepad === gamepad) {
                _this.gamepad = null;
            }
        });
        this.gamepad = manager.getGamepadByType(_Gamepads_gamepad__WEBPACK_IMPORTED_MODULE_2__.Gamepad.XBOX);
    };
    /**
     * Detach the current controls from the specified dom element.
     * @param element Defines the element to stop listening the inputs from
     */
    ArcRotateCameraGamepadInput.prototype.detachControl = function (element) {
        this.camera.getScene().gamepadManager.onGamepadConnectedObservable.remove(this._onGamepadConnectedObserver);
        this.camera.getScene().gamepadManager.onGamepadDisconnectedObservable.remove(this._onGamepadDisconnectedObserver);
        this.gamepad = null;
    };
    /**
     * Update the current camera state depending on the inputs that have been used this frame.
     * This is a dynamically created lambda to avoid the performance penalty of looping for inputs in the render loop.
     */
    ArcRotateCameraGamepadInput.prototype.checkInputs = function () {
        if (this.gamepad) {
            var camera = this.camera;
            var RSValues = this.gamepad.rightStick;
            if (RSValues) {
                if (RSValues.x != 0) {
                    var normalizedRX = RSValues.x / this.gamepadRotationSensibility;
                    if (normalizedRX != 0 && Math.abs(normalizedRX) > 0.005) {
                        camera.inertialAlphaOffset += normalizedRX;
                    }
                }
                if (RSValues.y != 0) {
                    var normalizedRY = (RSValues.y / this.gamepadRotationSensibility) * this._yAxisScale;
                    if (normalizedRY != 0 && Math.abs(normalizedRY) > 0.005) {
                        camera.inertialBetaOffset += normalizedRY;
                    }
                }
            }
            var LSValues = this.gamepad.leftStick;
            if (LSValues && LSValues.y != 0) {
                var normalizedLY = LSValues.y / this.gamepadMoveSensibility;
                if (normalizedLY != 0 && Math.abs(normalizedLY) > 0.005) {
                    this.camera.inertialRadiusOffset -= normalizedLY;
                }
            }
        }
    };
    /**
     * Gets the class name of the current intput.
     * @returns the class name
     */
    ArcRotateCameraGamepadInput.prototype.getClassName = function () {
        return "ArcRotateCameraGamepadInput";
    };
    /**
     * Get the friendly name associated with the input class.
     * @returns the input friendly name
     */
    ArcRotateCameraGamepadInput.prototype.getSimpleName = function () {
        return "gamepad";
    };
    (0,tslib__WEBPACK_IMPORTED_MODULE_3__.__decorate)([
        (0,_Misc_decorators__WEBPACK_IMPORTED_MODULE_0__.serialize)()
    ], ArcRotateCameraGamepadInput.prototype, "gamepadRotationSensibility", void 0);
    (0,tslib__WEBPACK_IMPORTED_MODULE_3__.__decorate)([
        (0,_Misc_decorators__WEBPACK_IMPORTED_MODULE_0__.serialize)()
    ], ArcRotateCameraGamepadInput.prototype, "gamepadMoveSensibility", void 0);
    return ArcRotateCameraGamepadInput;
}());

_Cameras_cameraInputsManager__WEBPACK_IMPORTED_MODULE_1__.CameraInputTypes.ArcRotateCameraGamepadInput = ArcRotateCameraGamepadInput;
//# sourceMappingURL=arcRotateCameraGamepadInput.js.map

/***/ }),

/***/ "./node_modules/@babylonjs/core/Cameras/Inputs/arcRotateCameraKeyboardMoveInput.js":
/*!*****************************************************************************************!*\
  !*** ./node_modules/@babylonjs/core/Cameras/Inputs/arcRotateCameraKeyboardMoveInput.js ***!
  \*****************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ArcRotateCameraKeyboardMoveInput": () => (/* binding */ ArcRotateCameraKeyboardMoveInput)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _Misc_decorators__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../Misc/decorators */ "./node_modules/@babylonjs/core/Misc/decorators.js");
/* harmony import */ var _Cameras_cameraInputsManager__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../Cameras/cameraInputsManager */ "./node_modules/@babylonjs/core/Cameras/cameraInputsManager.js");
/* harmony import */ var _Events_keyboardEvents__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../Events/keyboardEvents */ "./node_modules/@babylonjs/core/Events/keyboardEvents.js");




/**
 * Manage the keyboard inputs to control the movement of an arc rotate camera.
 * @see http://doc.babylonjs.com/how_to/customizing_camera_inputs
 */
var ArcRotateCameraKeyboardMoveInput = /** @class */ (function () {
    function ArcRotateCameraKeyboardMoveInput() {
        /**
         * Defines the list of key codes associated with the up action (increase alpha)
         */
        this.keysUp = [38];
        /**
         * Defines the list of key codes associated with the down action (decrease alpha)
         */
        this.keysDown = [40];
        /**
         * Defines the list of key codes associated with the left action (increase beta)
         */
        this.keysLeft = [37];
        /**
         * Defines the list of key codes associated with the right action (decrease beta)
         */
        this.keysRight = [39];
        /**
         * Defines the list of key codes associated with the reset action.
         * Those keys reset the camera to its last stored state (with the method camera.storeState())
         */
        this.keysReset = [220];
        /**
         * Defines the panning sensibility of the inputs.
         * (How fast is the camera panning)
         */
        this.panningSensibility = 50.0;
        /**
         * Defines the zooming sensibility of the inputs.
         * (How fast is the camera zooming)
         */
        this.zoomingSensibility = 25.0;
        /**
         * Defines whether maintaining the alt key down switch the movement mode from
         * orientation to zoom.
         */
        this.useAltToZoom = true;
        /**
         * Rotation speed of the camera
         */
        this.angularSpeed = 0.01;
        this._keys = new Array();
    }
    /**
     * Attach the input controls to a specific dom element to get the input from.
     * @param element Defines the element the controls should be listened from
     * @param noPreventDefault Defines whether event caught by the controls should call preventdefault() (https://developer.mozilla.org/en-US/docs/Web/API/Event/preventDefault)
     */
    ArcRotateCameraKeyboardMoveInput.prototype.attachControl = function (element, noPreventDefault) {
        var _this = this;
        if (this._onCanvasBlurObserver) {
            return;
        }
        this._scene = this.camera.getScene();
        this._engine = this._scene.getEngine();
        this._onCanvasBlurObserver = this._engine.onCanvasBlurObservable.add(function () {
            _this._keys = [];
        });
        this._onKeyboardObserver = this._scene.onKeyboardObservable.add(function (info) {
            var evt = info.event;
            if (!evt.metaKey) {
                if (info.type === _Events_keyboardEvents__WEBPACK_IMPORTED_MODULE_2__.KeyboardEventTypes.KEYDOWN) {
                    _this._ctrlPressed = evt.ctrlKey;
                    _this._altPressed = evt.altKey;
                    if (_this.keysUp.indexOf(evt.keyCode) !== -1 ||
                        _this.keysDown.indexOf(evt.keyCode) !== -1 ||
                        _this.keysLeft.indexOf(evt.keyCode) !== -1 ||
                        _this.keysRight.indexOf(evt.keyCode) !== -1 ||
                        _this.keysReset.indexOf(evt.keyCode) !== -1) {
                        var index = _this._keys.indexOf(evt.keyCode);
                        if (index === -1) {
                            _this._keys.push(evt.keyCode);
                        }
                        if (evt.preventDefault) {
                            if (!noPreventDefault) {
                                evt.preventDefault();
                            }
                        }
                    }
                }
                else {
                    if (_this.keysUp.indexOf(evt.keyCode) !== -1 ||
                        _this.keysDown.indexOf(evt.keyCode) !== -1 ||
                        _this.keysLeft.indexOf(evt.keyCode) !== -1 ||
                        _this.keysRight.indexOf(evt.keyCode) !== -1 ||
                        _this.keysReset.indexOf(evt.keyCode) !== -1) {
                        var index = _this._keys.indexOf(evt.keyCode);
                        if (index >= 0) {
                            _this._keys.splice(index, 1);
                        }
                        if (evt.preventDefault) {
                            if (!noPreventDefault) {
                                evt.preventDefault();
                            }
                        }
                    }
                }
            }
        });
    };
    /**
     * Detach the current controls from the specified dom element.
     * @param element Defines the element to stop listening the inputs from
     */
    ArcRotateCameraKeyboardMoveInput.prototype.detachControl = function (element) {
        if (this._scene) {
            if (this._onKeyboardObserver) {
                this._scene.onKeyboardObservable.remove(this._onKeyboardObserver);
            }
            if (this._onCanvasBlurObserver) {
                this._engine.onCanvasBlurObservable.remove(this._onCanvasBlurObserver);
            }
            this._onKeyboardObserver = null;
            this._onCanvasBlurObserver = null;
        }
        this._keys = [];
    };
    /**
     * Update the current camera state depending on the inputs that have been used this frame.
     * This is a dynamically created lambda to avoid the performance penalty of looping for inputs in the render loop.
     */
    ArcRotateCameraKeyboardMoveInput.prototype.checkInputs = function () {
        if (this._onKeyboardObserver) {
            var camera = this.camera;
            for (var index = 0; index < this._keys.length; index++) {
                var keyCode = this._keys[index];
                if (this.keysLeft.indexOf(keyCode) !== -1) {
                    if (this._ctrlPressed && this.camera._useCtrlForPanning) {
                        camera.inertialPanningX -= 1 / this.panningSensibility;
                    }
                    else {
                        camera.inertialAlphaOffset -= this.angularSpeed;
                    }
                }
                else if (this.keysUp.indexOf(keyCode) !== -1) {
                    if (this._ctrlPressed && this.camera._useCtrlForPanning) {
                        camera.inertialPanningY += 1 / this.panningSensibility;
                    }
                    else if (this._altPressed && this.useAltToZoom) {
                        camera.inertialRadiusOffset += 1 / this.zoomingSensibility;
                    }
                    else {
                        camera.inertialBetaOffset -= this.angularSpeed;
                    }
                }
                else if (this.keysRight.indexOf(keyCode) !== -1) {
                    if (this._ctrlPressed && this.camera._useCtrlForPanning) {
                        camera.inertialPanningX += 1 / this.panningSensibility;
                    }
                    else {
                        camera.inertialAlphaOffset += this.angularSpeed;
                    }
                }
                else if (this.keysDown.indexOf(keyCode) !== -1) {
                    if (this._ctrlPressed && this.camera._useCtrlForPanning) {
                        camera.inertialPanningY -= 1 / this.panningSensibility;
                    }
                    else if (this._altPressed && this.useAltToZoom) {
                        camera.inertialRadiusOffset -= 1 / this.zoomingSensibility;
                    }
                    else {
                        camera.inertialBetaOffset += this.angularSpeed;
                    }
                }
                else if (this.keysReset.indexOf(keyCode) !== -1) {
                    if (camera.useInputToRestoreState) {
                        camera.restoreState();
                    }
                }
            }
        }
    };
    /**
     * Gets the class name of the current intput.
     * @returns the class name
     */
    ArcRotateCameraKeyboardMoveInput.prototype.getClassName = function () {
        return "ArcRotateCameraKeyboardMoveInput";
    };
    /**
     * Get the friendly name associated with the input class.
     * @returns the input friendly name
     */
    ArcRotateCameraKeyboardMoveInput.prototype.getSimpleName = function () {
        return "keyboard";
    };
    (0,tslib__WEBPACK_IMPORTED_MODULE_3__.__decorate)([
        (0,_Misc_decorators__WEBPACK_IMPORTED_MODULE_0__.serialize)()
    ], ArcRotateCameraKeyboardMoveInput.prototype, "keysUp", void 0);
    (0,tslib__WEBPACK_IMPORTED_MODULE_3__.__decorate)([
        (0,_Misc_decorators__WEBPACK_IMPORTED_MODULE_0__.serialize)()
    ], ArcRotateCameraKeyboardMoveInput.prototype, "keysDown", void 0);
    (0,tslib__WEBPACK_IMPORTED_MODULE_3__.__decorate)([
        (0,_Misc_decorators__WEBPACK_IMPORTED_MODULE_0__.serialize)()
    ], ArcRotateCameraKeyboardMoveInput.prototype, "keysLeft", void 0);
    (0,tslib__WEBPACK_IMPORTED_MODULE_3__.__decorate)([
        (0,_Misc_decorators__WEBPACK_IMPORTED_MODULE_0__.serialize)()
    ], ArcRotateCameraKeyboardMoveInput.prototype, "keysRight", void 0);
    (0,tslib__WEBPACK_IMPORTED_MODULE_3__.__decorate)([
        (0,_Misc_decorators__WEBPACK_IMPORTED_MODULE_0__.serialize)()
    ], ArcRotateCameraKeyboardMoveInput.prototype, "keysReset", void 0);
    (0,tslib__WEBPACK_IMPORTED_MODULE_3__.__decorate)([
        (0,_Misc_decorators__WEBPACK_IMPORTED_MODULE_0__.serialize)()
    ], ArcRotateCameraKeyboardMoveInput.prototype, "panningSensibility", void 0);
    (0,tslib__WEBPACK_IMPORTED_MODULE_3__.__decorate)([
        (0,_Misc_decorators__WEBPACK_IMPORTED_MODULE_0__.serialize)()
    ], ArcRotateCameraKeyboardMoveInput.prototype, "zoomingSensibility", void 0);
    (0,tslib__WEBPACK_IMPORTED_MODULE_3__.__decorate)([
        (0,_Misc_decorators__WEBPACK_IMPORTED_MODULE_0__.serialize)()
    ], ArcRotateCameraKeyboardMoveInput.prototype, "useAltToZoom", void 0);
    (0,tslib__WEBPACK_IMPORTED_MODULE_3__.__decorate)([
        (0,_Misc_decorators__WEBPACK_IMPORTED_MODULE_0__.serialize)()
    ], ArcRotateCameraKeyboardMoveInput.prototype, "angularSpeed", void 0);
    return ArcRotateCameraKeyboardMoveInput;
}());

_Cameras_cameraInputsManager__WEBPACK_IMPORTED_MODULE_1__.CameraInputTypes.ArcRotateCameraKeyboardMoveInput = ArcRotateCameraKeyboardMoveInput;
//# sourceMappingURL=arcRotateCameraKeyboardMoveInput.js.map

/***/ }),

/***/ "./node_modules/@babylonjs/core/Cameras/Inputs/arcRotateCameraMouseWheelInput.js":
/*!***************************************************************************************!*\
  !*** ./node_modules/@babylonjs/core/Cameras/Inputs/arcRotateCameraMouseWheelInput.js ***!
  \***************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ArcRotateCameraMouseWheelInput": () => (/* binding */ ArcRotateCameraMouseWheelInput)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _Misc_decorators__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../Misc/decorators */ "./node_modules/@babylonjs/core/Misc/decorators.js");
/* harmony import */ var _Cameras_cameraInputsManager__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../Cameras/cameraInputsManager */ "./node_modules/@babylonjs/core/Cameras/cameraInputsManager.js");
/* harmony import */ var _Events_pointerEvents__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../Events/pointerEvents */ "./node_modules/@babylonjs/core/Events/pointerEvents.js");
/* harmony import */ var _Maths_math_scalar__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../Maths/math.scalar */ "./node_modules/@babylonjs/core/Maths/math.scalar.js");





/**
 * Manage the mouse wheel inputs to control an arc rotate camera.
 * @see http://doc.babylonjs.com/how_to/customizing_camera_inputs
 */
var ArcRotateCameraMouseWheelInput = /** @class */ (function () {
    function ArcRotateCameraMouseWheelInput() {
        /**
         * Gets or Set the mouse wheel precision or how fast is the camera zooming.
         */
        this.wheelPrecision = 3.0;
        /**
         * wheelDeltaPercentage will be used instead of wheelPrecision if different from 0.
         * It defines the percentage of current camera.radius to use as delta when wheel is used.
         */
        this.wheelDeltaPercentage = 0;
    }
    ArcRotateCameraMouseWheelInput.prototype.computeDeltaFromMouseWheelLegacyEvent = function (mouseWheelDelta, radius) {
        var delta = 0;
        var wheelDelta = (mouseWheelDelta * 0.01 * this.wheelDeltaPercentage) * radius;
        if (mouseWheelDelta > 0) {
            delta = wheelDelta / (1.0 + this.wheelDeltaPercentage);
        }
        else {
            delta = wheelDelta * (1.0 + this.wheelDeltaPercentage);
        }
        return delta;
    };
    /**
     * Attach the input controls to a specific dom element to get the input from.
     * @param element Defines the element the controls should be listened from
     * @param noPreventDefault Defines whether event caught by the controls should call preventdefault() (https://developer.mozilla.org/en-US/docs/Web/API/Event/preventDefault)
     */
    ArcRotateCameraMouseWheelInput.prototype.attachControl = function (element, noPreventDefault) {
        var _this = this;
        this._wheel = function (p, s) {
            //sanity check - this should be a PointerWheel event.
            if (p.type !== _Events_pointerEvents__WEBPACK_IMPORTED_MODULE_2__.PointerEventTypes.POINTERWHEEL) {
                return;
            }
            var event = p.event;
            var delta = 0;
            var mouseWheelLegacyEvent = event;
            var wheelDelta = 0;
            if (mouseWheelLegacyEvent.wheelDelta) {
                wheelDelta = mouseWheelLegacyEvent.wheelDelta;
            }
            else {
                wheelDelta = -(event.deltaY || event.detail) * 60;
            }
            if (_this.wheelDeltaPercentage) {
                delta = _this.computeDeltaFromMouseWheelLegacyEvent(wheelDelta, _this.camera.radius);
                // If zooming in, estimate the target radius and use that to compute the delta for inertia
                // this will stop multiple scroll events zooming in from adding too much inertia
                if (delta > 0) {
                    var estimatedTargetRadius = _this.camera.radius;
                    var targetInertia = _this.camera.inertialRadiusOffset + delta;
                    for (var i = 0; i < 20 && Math.abs(targetInertia) > 0.001; i++) {
                        estimatedTargetRadius -= targetInertia;
                        targetInertia *= _this.camera.inertia;
                    }
                    estimatedTargetRadius = _Maths_math_scalar__WEBPACK_IMPORTED_MODULE_3__.Scalar.Clamp(estimatedTargetRadius, 0, Number.MAX_VALUE);
                    delta = _this.computeDeltaFromMouseWheelLegacyEvent(wheelDelta, estimatedTargetRadius);
                }
            }
            else {
                delta = wheelDelta / (_this.wheelPrecision * 40);
            }
            if (delta) {
                _this.camera.inertialRadiusOffset += delta;
            }
            if (event.preventDefault) {
                if (!noPreventDefault) {
                    event.preventDefault();
                }
            }
        };
        this._observer = this.camera.getScene().onPointerObservable.add(this._wheel, _Events_pointerEvents__WEBPACK_IMPORTED_MODULE_2__.PointerEventTypes.POINTERWHEEL);
    };
    /**
     * Detach the current controls from the specified dom element.
     * @param element Defines the element to stop listening the inputs from
     */
    ArcRotateCameraMouseWheelInput.prototype.detachControl = function (element) {
        if (this._observer && element) {
            this.camera.getScene().onPointerObservable.remove(this._observer);
            this._observer = null;
            this._wheel = null;
        }
    };
    /**
     * Gets the class name of the current intput.
     * @returns the class name
     */
    ArcRotateCameraMouseWheelInput.prototype.getClassName = function () {
        return "ArcRotateCameraMouseWheelInput";
    };
    /**
     * Get the friendly name associated with the input class.
     * @returns the input friendly name
     */
    ArcRotateCameraMouseWheelInput.prototype.getSimpleName = function () {
        return "mousewheel";
    };
    (0,tslib__WEBPACK_IMPORTED_MODULE_4__.__decorate)([
        (0,_Misc_decorators__WEBPACK_IMPORTED_MODULE_0__.serialize)()
    ], ArcRotateCameraMouseWheelInput.prototype, "wheelPrecision", void 0);
    (0,tslib__WEBPACK_IMPORTED_MODULE_4__.__decorate)([
        (0,_Misc_decorators__WEBPACK_IMPORTED_MODULE_0__.serialize)()
    ], ArcRotateCameraMouseWheelInput.prototype, "wheelDeltaPercentage", void 0);
    return ArcRotateCameraMouseWheelInput;
}());

_Cameras_cameraInputsManager__WEBPACK_IMPORTED_MODULE_1__.CameraInputTypes.ArcRotateCameraMouseWheelInput = ArcRotateCameraMouseWheelInput;
//# sourceMappingURL=arcRotateCameraMouseWheelInput.js.map

/***/ }),

/***/ "./node_modules/@babylonjs/core/Cameras/Inputs/arcRotateCameraPointersInput.js":
/*!*************************************************************************************!*\
  !*** ./node_modules/@babylonjs/core/Cameras/Inputs/arcRotateCameraPointersInput.js ***!
  \*************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ArcRotateCameraPointersInput": () => (/* binding */ ArcRotateCameraPointersInput)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _Misc_decorators__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../Misc/decorators */ "./node_modules/@babylonjs/core/Misc/decorators.js");
/* harmony import */ var _Cameras_cameraInputsManager__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../Cameras/cameraInputsManager */ "./node_modules/@babylonjs/core/Cameras/cameraInputsManager.js");
/* harmony import */ var _Cameras_Inputs_BaseCameraPointersInput__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../Cameras/Inputs/BaseCameraPointersInput */ "./node_modules/@babylonjs/core/Cameras/Inputs/BaseCameraPointersInput.js");




/**
 * Manage the pointers inputs to control an arc rotate camera.
 * @see http://doc.babylonjs.com/how_to/customizing_camera_inputs
 */
var ArcRotateCameraPointersInput = /** @class */ (function (_super) {
    (0,tslib__WEBPACK_IMPORTED_MODULE_3__.__extends)(ArcRotateCameraPointersInput, _super);
    function ArcRotateCameraPointersInput() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        /**
         * Defines the buttons associated with the input to handle camera move.
         */
        _this.buttons = [0, 1, 2];
        /**
         * Defines the pointer angular sensibility  along the X axis or how fast is
         * the camera rotating.
         */
        _this.angularSensibilityX = 1000.0;
        /**
         * Defines the pointer angular sensibility along the Y axis or how fast is
         * the camera rotating.
         */
        _this.angularSensibilityY = 1000.0;
        /**
         * Defines the pointer pinch precision or how fast is the camera zooming.
         */
        _this.pinchPrecision = 12.0;
        /**
         * pinchDeltaPercentage will be used instead of pinchPrecision if different
         * from 0.
         * It defines the percentage of current camera.radius to use as delta when
         * pinch zoom is used.
         */
        _this.pinchDeltaPercentage = 0;
        /**
         * When useNaturalPinchZoom is true, multi touch zoom will zoom in such
         * that any object in the plane at the camera's target point will scale
         * perfectly with finger motion.
         * Overrides pinchDeltaPercentage and pinchPrecision.
         */
        _this.useNaturalPinchZoom = false;
        /**
         * Defines the pointer panning sensibility or how fast is the camera moving.
         */
        _this.panningSensibility = 1000.0;
        /**
         * Defines whether panning (2 fingers swipe) is enabled through multitouch.
         */
        _this.multiTouchPanning = true;
        /**
         * Defines whether panning is enabled for both pan (2 fingers swipe) and
         * zoom (pinch) through multitouch.
         */
        _this.multiTouchPanAndZoom = true;
        /**
         * Revers pinch action direction.
         */
        _this.pinchInwards = true;
        _this._isPanClick = false;
        _this._twoFingerActivityCount = 0;
        _this._isPinching = false;
        return _this;
    }
    /**
     * Gets the class name of the current input.
     * @returns the class name
     */
    ArcRotateCameraPointersInput.prototype.getClassName = function () {
        return "ArcRotateCameraPointersInput";
    };
    /**
     * Called on pointer POINTERMOVE event if only a single touch is active.
     */
    ArcRotateCameraPointersInput.prototype.onTouch = function (point, offsetX, offsetY) {
        if (this.panningSensibility !== 0 &&
            ((this._ctrlKey && this.camera._useCtrlForPanning) || this._isPanClick)) {
            this.camera.inertialPanningX += -offsetX / this.panningSensibility;
            this.camera.inertialPanningY += offsetY / this.panningSensibility;
        }
        else {
            this.camera.inertialAlphaOffset -= offsetX / this.angularSensibilityX;
            this.camera.inertialBetaOffset -= offsetY / this.angularSensibilityY;
        }
    };
    /**
     * Called on pointer POINTERDOUBLETAP event.
     */
    ArcRotateCameraPointersInput.prototype.onDoubleTap = function (type) {
        if (this.camera.useInputToRestoreState) {
            this.camera.restoreState();
        }
    };
    /**
     * Called on pointer POINTERMOVE event if multiple touches are active.
     */
    ArcRotateCameraPointersInput.prototype.onMultiTouch = function (pointA, pointB, previousPinchSquaredDistance, pinchSquaredDistance, previousMultiTouchPanPosition, multiTouchPanPosition) {
        if (previousPinchSquaredDistance === 0 && previousMultiTouchPanPosition === null) {
            // First time this method is called for new pinch.
            // Next time this is called there will be a
            // previousPinchSquaredDistance and pinchSquaredDistance to compare.
            return;
        }
        if (pinchSquaredDistance === 0 && multiTouchPanPosition === null) {
            // Last time this method is called at the end of a pinch.
            return;
        }
        var direction = this.pinchInwards ? 1 : -1;
        if (this.multiTouchPanAndZoom) {
            if (this.useNaturalPinchZoom) {
                this.camera.radius = this.camera.radius *
                    Math.sqrt(previousPinchSquaredDistance) / Math.sqrt(pinchSquaredDistance);
            }
            else if (this.pinchDeltaPercentage) {
                this.camera.inertialRadiusOffset +=
                    (pinchSquaredDistance - previousPinchSquaredDistance) * 0.001 *
                        this.camera.radius * this.pinchDeltaPercentage;
            }
            else {
                this.camera.inertialRadiusOffset +=
                    (pinchSquaredDistance - previousPinchSquaredDistance) /
                        (this.pinchPrecision * direction *
                            (this.angularSensibilityX + this.angularSensibilityY) / 2);
            }
            if (this.panningSensibility !== 0 &&
                previousMultiTouchPanPosition && multiTouchPanPosition) {
                var moveDeltaX = multiTouchPanPosition.x - previousMultiTouchPanPosition.x;
                var moveDeltaY = multiTouchPanPosition.y - previousMultiTouchPanPosition.y;
                this.camera.inertialPanningX += -moveDeltaX / this.panningSensibility;
                this.camera.inertialPanningY += moveDeltaY / this.panningSensibility;
            }
        }
        else {
            this._twoFingerActivityCount++;
            var previousPinchDistance = Math.sqrt(previousPinchSquaredDistance);
            var pinchDistance = Math.sqrt(pinchSquaredDistance);
            if (this._isPinching ||
                (this._twoFingerActivityCount < 20 &&
                    Math.abs(pinchDistance - previousPinchDistance) >
                        this.camera.pinchToPanMaxDistance)) {
                // Since pinch has not been active long, assume we intend to zoom.
                if (this.pinchDeltaPercentage) {
                    this.camera.inertialRadiusOffset +=
                        (pinchSquaredDistance - previousPinchSquaredDistance) * 0.001 *
                            this.camera.radius * this.pinchDeltaPercentage;
                }
                else {
                    this.camera.inertialRadiusOffset +=
                        (pinchSquaredDistance - previousPinchSquaredDistance) /
                            (this.pinchPrecision * direction *
                                (this.angularSensibilityX + this.angularSensibilityY) / 2);
                }
                // Since we are pinching, remain pinching on next iteration.
                this._isPinching = true;
            }
            else {
                // Pause between pinch starting and moving implies not a zoom event.
                // Pan instead.
                if (this.panningSensibility !== 0 && this.multiTouchPanning &&
                    multiTouchPanPosition && previousMultiTouchPanPosition) {
                    var moveDeltaX = multiTouchPanPosition.x - previousMultiTouchPanPosition.x;
                    var moveDeltaY = multiTouchPanPosition.y - previousMultiTouchPanPosition.y;
                    this.camera.inertialPanningX += -moveDeltaX / this.panningSensibility;
                    this.camera.inertialPanningY += moveDeltaY / this.panningSensibility;
                }
            }
        }
    };
    /**
     * Called each time a new POINTERDOWN event occurs. Ie, for each button
     * press.
     */
    ArcRotateCameraPointersInput.prototype.onButtonDown = function (evt) {
        this._isPanClick = evt.button === this.camera._panningMouseButton;
    };
    /**
     * Called each time a new POINTERUP event occurs. Ie, for each button
     * release.
     */
    ArcRotateCameraPointersInput.prototype.onButtonUp = function (evt) {
        this._twoFingerActivityCount = 0;
        this._isPinching = false;
    };
    /**
     * Called when window becomes inactive.
     */
    ArcRotateCameraPointersInput.prototype.onLostFocus = function () {
        this._isPanClick = false;
        this._twoFingerActivityCount = 0;
        this._isPinching = false;
    };
    (0,tslib__WEBPACK_IMPORTED_MODULE_3__.__decorate)([
        (0,_Misc_decorators__WEBPACK_IMPORTED_MODULE_0__.serialize)()
    ], ArcRotateCameraPointersInput.prototype, "buttons", void 0);
    (0,tslib__WEBPACK_IMPORTED_MODULE_3__.__decorate)([
        (0,_Misc_decorators__WEBPACK_IMPORTED_MODULE_0__.serialize)()
    ], ArcRotateCameraPointersInput.prototype, "angularSensibilityX", void 0);
    (0,tslib__WEBPACK_IMPORTED_MODULE_3__.__decorate)([
        (0,_Misc_decorators__WEBPACK_IMPORTED_MODULE_0__.serialize)()
    ], ArcRotateCameraPointersInput.prototype, "angularSensibilityY", void 0);
    (0,tslib__WEBPACK_IMPORTED_MODULE_3__.__decorate)([
        (0,_Misc_decorators__WEBPACK_IMPORTED_MODULE_0__.serialize)()
    ], ArcRotateCameraPointersInput.prototype, "pinchPrecision", void 0);
    (0,tslib__WEBPACK_IMPORTED_MODULE_3__.__decorate)([
        (0,_Misc_decorators__WEBPACK_IMPORTED_MODULE_0__.serialize)()
    ], ArcRotateCameraPointersInput.prototype, "pinchDeltaPercentage", void 0);
    (0,tslib__WEBPACK_IMPORTED_MODULE_3__.__decorate)([
        (0,_Misc_decorators__WEBPACK_IMPORTED_MODULE_0__.serialize)()
    ], ArcRotateCameraPointersInput.prototype, "useNaturalPinchZoom", void 0);
    (0,tslib__WEBPACK_IMPORTED_MODULE_3__.__decorate)([
        (0,_Misc_decorators__WEBPACK_IMPORTED_MODULE_0__.serialize)()
    ], ArcRotateCameraPointersInput.prototype, "panningSensibility", void 0);
    (0,tslib__WEBPACK_IMPORTED_MODULE_3__.__decorate)([
        (0,_Misc_decorators__WEBPACK_IMPORTED_MODULE_0__.serialize)()
    ], ArcRotateCameraPointersInput.prototype, "multiTouchPanning", void 0);
    (0,tslib__WEBPACK_IMPORTED_MODULE_3__.__decorate)([
        (0,_Misc_decorators__WEBPACK_IMPORTED_MODULE_0__.serialize)()
    ], ArcRotateCameraPointersInput.prototype, "multiTouchPanAndZoom", void 0);
    return ArcRotateCameraPointersInput;
}(_Cameras_Inputs_BaseCameraPointersInput__WEBPACK_IMPORTED_MODULE_2__.BaseCameraPointersInput));

_Cameras_cameraInputsManager__WEBPACK_IMPORTED_MODULE_1__.CameraInputTypes.ArcRotateCameraPointersInput =
    ArcRotateCameraPointersInput;
//# sourceMappingURL=arcRotateCameraPointersInput.js.map

/***/ }),

/***/ "./node_modules/@babylonjs/core/Cameras/Inputs/arcRotateCameraVRDeviceOrientationInput.js":
/*!************************************************************************************************!*\
  !*** ./node_modules/@babylonjs/core/Cameras/Inputs/arcRotateCameraVRDeviceOrientationInput.js ***!
  \************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ArcRotateCameraVRDeviceOrientationInput": () => (/* binding */ ArcRotateCameraVRDeviceOrientationInput)
/* harmony export */ });
/* harmony import */ var _Cameras_cameraInputsManager__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../Cameras/cameraInputsManager */ "./node_modules/@babylonjs/core/Cameras/cameraInputsManager.js");
/* harmony import */ var _Cameras_arcRotateCameraInputsManager__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../Cameras/arcRotateCameraInputsManager */ "./node_modules/@babylonjs/core/Cameras/arcRotateCameraInputsManager.js");
/* harmony import */ var _Misc_tools__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../Misc/tools */ "./node_modules/@babylonjs/core/Misc/tools.js");



/**
 * Add orientation input support to the input manager.
 * @returns the current input manager
 */
_Cameras_arcRotateCameraInputsManager__WEBPACK_IMPORTED_MODULE_1__.ArcRotateCameraInputsManager.prototype.addVRDeviceOrientation = function () {
    this.add(new ArcRotateCameraVRDeviceOrientationInput());
    return this;
};
/**
 * Manage the device orientation inputs (gyroscope) to control an arc rotate camera.
 * @see http://doc.babylonjs.com/how_to/customizing_camera_inputs
 */
var ArcRotateCameraVRDeviceOrientationInput = /** @class */ (function () {
    /**
     * Instantiate a new ArcRotateCameraVRDeviceOrientationInput.
     */
    function ArcRotateCameraVRDeviceOrientationInput() {
        /**
         * Defines a correction factor applied on the alpha value retrieved from the orientation events.
         */
        this.alphaCorrection = 1;
        /**
         * Defines a correction factor applied on the gamma value retrieved from the orientation events.
         */
        this.gammaCorrection = 1;
        this._alpha = 0;
        this._gamma = 0;
        this._dirty = false;
        this._deviceOrientationHandler = this._onOrientationEvent.bind(this);
    }
    /**
     * Attach the input controls to a specific dom element to get the input from.
     * @param element Defines the element the controls should be listened from
     * @param noPreventDefault Defines whether event caught by the controls should call preventdefault() (https://developer.mozilla.org/en-US/docs/Web/API/Event/preventDefault)
     */
    ArcRotateCameraVRDeviceOrientationInput.prototype.attachControl = function (element, noPreventDefault) {
        var _this = this;
        this.camera.attachControl(element, noPreventDefault);
        var hostWindow = this.camera.getScene().getEngine().getHostWindow();
        if (hostWindow) {
            // check iOS 13+ support
            if (typeof (DeviceOrientationEvent) !== "undefined" && typeof DeviceOrientationEvent.requestPermission === 'function') {
                DeviceOrientationEvent.requestPermission()
                    .then(function (response) {
                    if (response === 'granted') {
                        hostWindow.addEventListener("deviceorientation", _this._deviceOrientationHandler);
                    }
                    else {
                        _Misc_tools__WEBPACK_IMPORTED_MODULE_2__.Tools.Warn("Permission not granted.");
                    }
                })
                    .catch(function (error) {
                    _Misc_tools__WEBPACK_IMPORTED_MODULE_2__.Tools.Error(error);
                });
            }
            else {
                hostWindow.addEventListener("deviceorientation", this._deviceOrientationHandler);
            }
        }
    };
    /** @hidden */
    ArcRotateCameraVRDeviceOrientationInput.prototype._onOrientationEvent = function (evt) {
        if (evt.alpha !== null) {
            this._alpha = (+evt.alpha | 0) * this.alphaCorrection;
        }
        if (evt.gamma !== null) {
            this._gamma = (+evt.gamma | 0) * this.gammaCorrection;
        }
        this._dirty = true;
    };
    /**
     * Update the current camera state depending on the inputs that have been used this frame.
     * This is a dynamically created lambda to avoid the performance penalty of looping for inputs in the render loop.
     */
    ArcRotateCameraVRDeviceOrientationInput.prototype.checkInputs = function () {
        if (this._dirty) {
            this._dirty = false;
            if (this._gamma < 0) {
                this._gamma = 180 + this._gamma;
            }
            this.camera.alpha = (-this._alpha / 180.0 * Math.PI) % Math.PI * 2;
            this.camera.beta = (this._gamma / 180.0 * Math.PI);
        }
    };
    /**
     * Detach the current controls from the specified dom element.
     * @param element Defines the element to stop listening the inputs from
     */
    ArcRotateCameraVRDeviceOrientationInput.prototype.detachControl = function (element) {
        window.removeEventListener("deviceorientation", this._deviceOrientationHandler);
    };
    /**
     * Gets the class name of the current intput.
     * @returns the class name
     */
    ArcRotateCameraVRDeviceOrientationInput.prototype.getClassName = function () {
        return "ArcRotateCameraVRDeviceOrientationInput";
    };
    /**
     * Get the friendly name associated with the input class.
     * @returns the input friendly name
     */
    ArcRotateCameraVRDeviceOrientationInput.prototype.getSimpleName = function () {
        return "VRDeviceOrientation";
    };
    return ArcRotateCameraVRDeviceOrientationInput;
}());

_Cameras_cameraInputsManager__WEBPACK_IMPORTED_MODULE_0__.CameraInputTypes.ArcRotateCameraVRDeviceOrientationInput = ArcRotateCameraVRDeviceOrientationInput;
//# sourceMappingURL=arcRotateCameraVRDeviceOrientationInput.js.map

/***/ }),

/***/ "./node_modules/@babylonjs/core/Cameras/Inputs/flyCameraKeyboardInput.js":
/*!*******************************************************************************!*\
  !*** ./node_modules/@babylonjs/core/Cameras/Inputs/flyCameraKeyboardInput.js ***!
  \*******************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "FlyCameraKeyboardInput": () => (/* binding */ FlyCameraKeyboardInput)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _Misc_decorators__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../Misc/decorators */ "./node_modules/@babylonjs/core/Misc/decorators.js");
/* harmony import */ var _Cameras_cameraInputsManager__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../Cameras/cameraInputsManager */ "./node_modules/@babylonjs/core/Cameras/cameraInputsManager.js");
/* harmony import */ var _Events_keyboardEvents__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../Events/keyboardEvents */ "./node_modules/@babylonjs/core/Events/keyboardEvents.js");
/* harmony import */ var _Maths_math_vector__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../Maths/math.vector */ "./node_modules/@babylonjs/core/Maths/math.vector.js");





/**
 * Listen to keyboard events to control the camera.
 * @see http://doc.babylonjs.com/how_to/customizing_camera_inputs
 */
var FlyCameraKeyboardInput = /** @class */ (function () {
    function FlyCameraKeyboardInput() {
        /**
         * The list of keyboard keys used to control the forward move of the camera.
         */
        this.keysForward = [87];
        /**
         * The list of keyboard keys used to control the backward move of the camera.
         */
        this.keysBackward = [83];
        /**
         * The list of keyboard keys used to control the forward move of the camera.
         */
        this.keysUp = [69];
        /**
         * The list of keyboard keys used to control the backward move of the camera.
         */
        this.keysDown = [81];
        /**
         * The list of keyboard keys used to control the right strafe move of the camera.
         */
        this.keysRight = [68];
        /**
         * The list of keyboard keys used to control the left strafe move of the camera.
         */
        this.keysLeft = [65];
        this._keys = new Array();
    }
    /**
     * Attach the input controls to a specific dom element to get the input from.
     * @param element Defines the element the controls should be listened from
     * @param noPreventDefault Defines whether event caught by the controls should call preventdefault() (https://developer.mozilla.org/en-US/docs/Web/API/Event/preventDefault)
     */
    FlyCameraKeyboardInput.prototype.attachControl = function (element, noPreventDefault) {
        var _this = this;
        if (this._onCanvasBlurObserver) {
            return;
        }
        this._scene = this.camera.getScene();
        this._engine = this._scene.getEngine();
        this._onCanvasBlurObserver = this._engine.onCanvasBlurObservable.add(function () {
            _this._keys = [];
        });
        this._onKeyboardObserver = this._scene.onKeyboardObservable.add(function (info) {
            var evt = info.event;
            if (info.type === _Events_keyboardEvents__WEBPACK_IMPORTED_MODULE_2__.KeyboardEventTypes.KEYDOWN) {
                if (_this.keysForward.indexOf(evt.keyCode) !== -1 ||
                    _this.keysBackward.indexOf(evt.keyCode) !== -1 ||
                    _this.keysUp.indexOf(evt.keyCode) !== -1 ||
                    _this.keysDown.indexOf(evt.keyCode) !== -1 ||
                    _this.keysLeft.indexOf(evt.keyCode) !== -1 ||
                    _this.keysRight.indexOf(evt.keyCode) !== -1) {
                    var index = _this._keys.indexOf(evt.keyCode);
                    if (index === -1) {
                        _this._keys.push(evt.keyCode);
                    }
                    if (!noPreventDefault) {
                        evt.preventDefault();
                    }
                }
            }
            else {
                if (_this.keysForward.indexOf(evt.keyCode) !== -1 ||
                    _this.keysBackward.indexOf(evt.keyCode) !== -1 ||
                    _this.keysUp.indexOf(evt.keyCode) !== -1 ||
                    _this.keysDown.indexOf(evt.keyCode) !== -1 ||
                    _this.keysLeft.indexOf(evt.keyCode) !== -1 ||
                    _this.keysRight.indexOf(evt.keyCode) !== -1) {
                    var index = _this._keys.indexOf(evt.keyCode);
                    if (index >= 0) {
                        _this._keys.splice(index, 1);
                    }
                    if (!noPreventDefault) {
                        evt.preventDefault();
                    }
                }
            }
        });
    };
    /**
     * Detach the current controls from the specified dom element.
     * @param element Defines the element to stop listening the inputs from
     */
    FlyCameraKeyboardInput.prototype.detachControl = function (element) {
        if (this._scene) {
            if (this._onKeyboardObserver) {
                this._scene.onKeyboardObservable.remove(this._onKeyboardObserver);
            }
            if (this._onCanvasBlurObserver) {
                this._engine.onCanvasBlurObservable.remove(this._onCanvasBlurObserver);
            }
            this._onKeyboardObserver = null;
            this._onCanvasBlurObserver = null;
        }
        this._keys = [];
    };
    /**
     * Gets the class name of the current intput.
     * @returns the class name
     */
    FlyCameraKeyboardInput.prototype.getClassName = function () {
        return "FlyCameraKeyboardInput";
    };
    /** @hidden */
    FlyCameraKeyboardInput.prototype._onLostFocus = function (e) {
        this._keys = [];
    };
    /**
     * Get the friendly name associated with the input class.
     * @returns the input friendly name
     */
    FlyCameraKeyboardInput.prototype.getSimpleName = function () {
        return "keyboard";
    };
    /**
     * Update the current camera state depending on the inputs that have been used this frame.
     * This is a dynamically created lambda to avoid the performance penalty of looping for inputs in the render loop.
     */
    FlyCameraKeyboardInput.prototype.checkInputs = function () {
        if (this._onKeyboardObserver) {
            var camera = this.camera;
            // Keyboard
            for (var index = 0; index < this._keys.length; index++) {
                var keyCode = this._keys[index];
                var speed = camera._computeLocalCameraSpeed();
                if (this.keysForward.indexOf(keyCode) !== -1) {
                    camera._localDirection.copyFromFloats(0, 0, speed);
                }
                else if (this.keysBackward.indexOf(keyCode) !== -1) {
                    camera._localDirection.copyFromFloats(0, 0, -speed);
                }
                else if (this.keysUp.indexOf(keyCode) !== -1) {
                    camera._localDirection.copyFromFloats(0, speed, 0);
                }
                else if (this.keysDown.indexOf(keyCode) !== -1) {
                    camera._localDirection.copyFromFloats(0, -speed, 0);
                }
                else if (this.keysRight.indexOf(keyCode) !== -1) {
                    camera._localDirection.copyFromFloats(speed, 0, 0);
                }
                else if (this.keysLeft.indexOf(keyCode) !== -1) {
                    camera._localDirection.copyFromFloats(-speed, 0, 0);
                }
                if (camera.getScene().useRightHandedSystem) {
                    camera._localDirection.z *= -1;
                }
                camera.getViewMatrix().invertToRef(camera._cameraTransformMatrix);
                _Maths_math_vector__WEBPACK_IMPORTED_MODULE_3__.Vector3.TransformNormalToRef(camera._localDirection, camera._cameraTransformMatrix, camera._transformedDirection);
                camera.cameraDirection.addInPlace(camera._transformedDirection);
            }
        }
    };
    (0,tslib__WEBPACK_IMPORTED_MODULE_4__.__decorate)([
        (0,_Misc_decorators__WEBPACK_IMPORTED_MODULE_0__.serialize)()
    ], FlyCameraKeyboardInput.prototype, "keysForward", void 0);
    (0,tslib__WEBPACK_IMPORTED_MODULE_4__.__decorate)([
        (0,_Misc_decorators__WEBPACK_IMPORTED_MODULE_0__.serialize)()
    ], FlyCameraKeyboardInput.prototype, "keysBackward", void 0);
    (0,tslib__WEBPACK_IMPORTED_MODULE_4__.__decorate)([
        (0,_Misc_decorators__WEBPACK_IMPORTED_MODULE_0__.serialize)()
    ], FlyCameraKeyboardInput.prototype, "keysUp", void 0);
    (0,tslib__WEBPACK_IMPORTED_MODULE_4__.__decorate)([
        (0,_Misc_decorators__WEBPACK_IMPORTED_MODULE_0__.serialize)()
    ], FlyCameraKeyboardInput.prototype, "keysDown", void 0);
    (0,tslib__WEBPACK_IMPORTED_MODULE_4__.__decorate)([
        (0,_Misc_decorators__WEBPACK_IMPORTED_MODULE_0__.serialize)()
    ], FlyCameraKeyboardInput.prototype, "keysRight", void 0);
    (0,tslib__WEBPACK_IMPORTED_MODULE_4__.__decorate)([
        (0,_Misc_decorators__WEBPACK_IMPORTED_MODULE_0__.serialize)()
    ], FlyCameraKeyboardInput.prototype, "keysLeft", void 0);
    return FlyCameraKeyboardInput;
}());

_Cameras_cameraInputsManager__WEBPACK_IMPORTED_MODULE_1__.CameraInputTypes.FlyCameraKeyboardInput = FlyCameraKeyboardInput;
//# sourceMappingURL=flyCameraKeyboardInput.js.map

/***/ }),

/***/ "./node_modules/@babylonjs/core/Cameras/Inputs/flyCameraMouseInput.js":
/*!****************************************************************************!*\
  !*** ./node_modules/@babylonjs/core/Cameras/Inputs/flyCameraMouseInput.js ***!
  \****************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "FlyCameraMouseInput": () => (/* binding */ FlyCameraMouseInput)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _Misc_decorators__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../Misc/decorators */ "./node_modules/@babylonjs/core/Misc/decorators.js");
/* harmony import */ var _Cameras_cameraInputsManager__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../Cameras/cameraInputsManager */ "./node_modules/@babylonjs/core/Cameras/cameraInputsManager.js");
/* harmony import */ var _Events_pointerEvents__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../Events/pointerEvents */ "./node_modules/@babylonjs/core/Events/pointerEvents.js");
/* harmony import */ var _Maths_math_vector__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../Maths/math.vector */ "./node_modules/@babylonjs/core/Maths/math.vector.js");
/* harmony import */ var _Maths_math_axis__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../Maths/math.axis */ "./node_modules/@babylonjs/core/Maths/math.axis.js");






/**
 * Listen to mouse events to control the camera.
 * @see http://doc.babylonjs.com/how_to/customizing_camera_inputs
 */
var FlyCameraMouseInput = /** @class */ (function () {
    /**
     * Listen to mouse events to control the camera.
     * @param touchEnabled Define if touch is enabled. (Default is true.)
     * @see http://doc.babylonjs.com/how_to/customizing_camera_inputs
     */
    function FlyCameraMouseInput(touchEnabled) {
        if (touchEnabled === void 0) { touchEnabled = true; }
        /**
         * Defines the buttons associated with the input to handle camera rotation.
         */
        this.buttons = [0, 1, 2];
        /**
         * Assign buttons for Yaw control.
         */
        this.buttonsYaw = [-1, 0, 1];
        /**
        * Assign buttons for Pitch control.
        */
        this.buttonsPitch = [-1, 0, 1];
        /**
        * Assign buttons for Roll control.
        */
        this.buttonsRoll = [2];
        /**
         * Detect if any button is being pressed while mouse is moved.
         * -1 = Mouse locked.
         * 0 = Left button.
         * 1 = Middle Button.
         * 2 = Right Button.
         */
        this.activeButton = -1;
        /**
         * Defines the pointer's angular sensibility, to control the camera rotation speed.
         * Higher values reduce its sensitivity.
         */
        this.angularSensibility = 1000.0;
        this.previousPosition = null;
    }
    /**
     * Attach the mouse control to the HTML DOM element.
     * @param element Defines the element that listens to the input events.
     * @param noPreventDefault Defines whether events caught by the controls should call preventdefault().
     */
    FlyCameraMouseInput.prototype.attachControl = function (element, noPreventDefault) {
        var _this = this;
        this.element = element;
        this.noPreventDefault = noPreventDefault;
        this._observer = this.camera.getScene().onPointerObservable.add(function (p, s) {
            _this._pointerInput(p, s);
        }, _Events_pointerEvents__WEBPACK_IMPORTED_MODULE_2__.PointerEventTypes.POINTERDOWN | _Events_pointerEvents__WEBPACK_IMPORTED_MODULE_2__.PointerEventTypes.POINTERUP | _Events_pointerEvents__WEBPACK_IMPORTED_MODULE_2__.PointerEventTypes.POINTERMOVE);
        // Correct Roll by rate, if enabled.
        this._rollObserver = this.camera.getScene().onBeforeRenderObservable.add(function () {
            if (_this.camera.rollCorrect) {
                _this.camera.restoreRoll(_this.camera.rollCorrect);
            }
        });
        // Helper function to keep 'this'.
        this._mousemoveCallback = function (e) {
            _this._onMouseMove(e);
        };
        element.addEventListener("mousemove", this._mousemoveCallback, false);
    };
    /**
     * Detach the current controls from the specified dom element.
     * @param element Defines the element to stop listening the inputs from
     */
    FlyCameraMouseInput.prototype.detachControl = function (element) {
        if (this._observer && element) {
            this.camera.getScene().onPointerObservable.remove(this._observer);
            this.camera.getScene().onBeforeRenderObservable.remove(this._rollObserver);
            if (this._mousemoveCallback) {
                element.removeEventListener("mousemove", this._mousemoveCallback);
            }
            this._observer = null;
            this._rollObserver = null;
            this.previousPosition = null;
            this.noPreventDefault = undefined;
        }
    };
    /**
     * Gets the class name of the current input.
     * @returns the class name.
     */
    FlyCameraMouseInput.prototype.getClassName = function () {
        return "FlyCameraMouseInput";
    };
    /**
     * Get the friendly name associated with the input class.
     * @returns the input's friendly name.
     */
    FlyCameraMouseInput.prototype.getSimpleName = function () {
        return "mouse";
    };
    // Track mouse movement, when the pointer is not locked.
    FlyCameraMouseInput.prototype._pointerInput = function (p, s) {
        var e = p.event;
        var camera = this.camera;
        var engine = camera.getEngine();
        if (engine.isInVRExclusivePointerMode) {
            return;
        }
        if (!this.touchEnabled && e.pointerType === "touch") {
            return;
        }
        // Mouse is moved but an unknown mouse button is pressed.
        if (p.type !== _Events_pointerEvents__WEBPACK_IMPORTED_MODULE_2__.PointerEventTypes.POINTERMOVE && this.buttons.indexOf(e.button) === -1) {
            return;
        }
        var srcElement = (e.srcElement || e.target);
        // Mouse down.
        if (p.type === _Events_pointerEvents__WEBPACK_IMPORTED_MODULE_2__.PointerEventTypes.POINTERDOWN && srcElement) {
            try {
                srcElement.setPointerCapture(e.pointerId);
            }
            catch (e) {
                // Nothing to do with the error. Execution continues.
            }
            this.previousPosition = {
                x: e.clientX,
                y: e.clientY
            };
            this.activeButton = e.button;
            if (!this.noPreventDefault) {
                e.preventDefault();
                this.element.focus();
            }
        }
        else 
        // Mouse up.
        if (p.type === _Events_pointerEvents__WEBPACK_IMPORTED_MODULE_2__.PointerEventTypes.POINTERUP && srcElement) {
            try {
                srcElement.releasePointerCapture(e.pointerId);
            }
            catch (e) {
                // Nothing to do with the error. Execution continues.
            }
            this.activeButton = -1;
            this.previousPosition = null;
            if (!this.noPreventDefault) {
                e.preventDefault();
            }
        }
        else 
        // Mouse move.
        if (p.type === _Events_pointerEvents__WEBPACK_IMPORTED_MODULE_2__.PointerEventTypes.POINTERMOVE) {
            if (!this.previousPosition || engine.isPointerLock) {
                return;
            }
            var offsetX = e.clientX - this.previousPosition.x;
            var offsetY = e.clientY - this.previousPosition.y;
            this.rotateCamera(offsetX, offsetY);
            this.previousPosition = {
                x: e.clientX,
                y: e.clientY
            };
            if (!this.noPreventDefault) {
                e.preventDefault();
            }
        }
    };
    // Track mouse movement, when pointer is locked.
    FlyCameraMouseInput.prototype._onMouseMove = function (e) {
        var camera = this.camera;
        var engine = camera.getEngine();
        if (!engine.isPointerLock || engine.isInVRExclusivePointerMode) {
            return;
        }
        var offsetX = e.movementX || e.mozMovementX || e.webkitMovementX || e.msMovementX || 0;
        var offsetY = e.movementY || e.mozMovementY || e.webkitMovementY || e.msMovementY || 0;
        this.rotateCamera(offsetX, offsetY);
        this.previousPosition = null;
        if (!this.noPreventDefault) {
            e.preventDefault();
        }
    };
    /**
     * Rotate camera by mouse offset.
     */
    FlyCameraMouseInput.prototype.rotateCamera = function (offsetX, offsetY) {
        var _this = this;
        var camera = this.camera;
        var scene = this.camera.getScene();
        if (scene.useRightHandedSystem) {
            offsetX *= -1;
        }
        if (camera.parent && camera.parent._getWorldMatrixDeterminant() < 0) {
            offsetX *= -1;
        }
        var x = offsetX / this.angularSensibility;
        var y = offsetY / this.angularSensibility;
        // Initialize to current rotation.
        var currentRotation = _Maths_math_vector__WEBPACK_IMPORTED_MODULE_3__.Quaternion.RotationYawPitchRoll(camera.rotation.y, camera.rotation.x, camera.rotation.z);
        var rotationChange;
        // Pitch.
        if (this.buttonsPitch.some(function (v) { return v === _this.activeButton; })) {
            // Apply change in Radians to vector Angle.
            rotationChange = _Maths_math_vector__WEBPACK_IMPORTED_MODULE_3__.Quaternion.RotationAxis(_Maths_math_axis__WEBPACK_IMPORTED_MODULE_4__.Axis.X, y);
            // Apply Pitch to quaternion.
            currentRotation.multiplyInPlace(rotationChange);
        }
        // Yaw.
        if (this.buttonsYaw.some(function (v) { return v === _this.activeButton; })) {
            // Apply change in Radians to vector Angle.
            rotationChange = _Maths_math_vector__WEBPACK_IMPORTED_MODULE_3__.Quaternion.RotationAxis(_Maths_math_axis__WEBPACK_IMPORTED_MODULE_4__.Axis.Y, x);
            // Apply Yaw to quaternion.
            currentRotation.multiplyInPlace(rotationChange);
            // Add Roll, if banked turning is enabled, within Roll limit.
            var limit = (camera.bankedTurnLimit) + camera._trackRoll; // Defaults to 90° plus manual roll.
            if (camera.bankedTurn && -limit < camera.rotation.z && camera.rotation.z < limit) {
                var bankingDelta = camera.bankedTurnMultiplier * -x;
                // Apply change in Radians to vector Angle.
                rotationChange = _Maths_math_vector__WEBPACK_IMPORTED_MODULE_3__.Quaternion.RotationAxis(_Maths_math_axis__WEBPACK_IMPORTED_MODULE_4__.Axis.Z, bankingDelta);
                // Apply Yaw to quaternion.
                currentRotation.multiplyInPlace(rotationChange);
            }
        }
        // Roll.
        if (this.buttonsRoll.some(function (v) { return v === _this.activeButton; })) {
            // Apply change in Radians to vector Angle.
            rotationChange = _Maths_math_vector__WEBPACK_IMPORTED_MODULE_3__.Quaternion.RotationAxis(_Maths_math_axis__WEBPACK_IMPORTED_MODULE_4__.Axis.Z, -x);
            // Track Rolling.
            camera._trackRoll -= x;
            // Apply Pitch to quaternion.
            currentRotation.multiplyInPlace(rotationChange);
        }
        // Apply rotationQuaternion to Euler camera.rotation.
        currentRotation.toEulerAnglesToRef(camera.rotation);
    };
    (0,tslib__WEBPACK_IMPORTED_MODULE_5__.__decorate)([
        (0,_Misc_decorators__WEBPACK_IMPORTED_MODULE_0__.serialize)()
    ], FlyCameraMouseInput.prototype, "buttons", void 0);
    (0,tslib__WEBPACK_IMPORTED_MODULE_5__.__decorate)([
        (0,_Misc_decorators__WEBPACK_IMPORTED_MODULE_0__.serialize)()
    ], FlyCameraMouseInput.prototype, "angularSensibility", void 0);
    return FlyCameraMouseInput;
}());

_Cameras_cameraInputsManager__WEBPACK_IMPORTED_MODULE_1__.CameraInputTypes.FlyCameraMouseInput = FlyCameraMouseInput;
//# sourceMappingURL=flyCameraMouseInput.js.map

/***/ }),

/***/ "./node_modules/@babylonjs/core/Cameras/Inputs/followCameraKeyboardMoveInput.js":
/*!**************************************************************************************!*\
  !*** ./node_modules/@babylonjs/core/Cameras/Inputs/followCameraKeyboardMoveInput.js ***!
  \**************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "FollowCameraKeyboardMoveInput": () => (/* binding */ FollowCameraKeyboardMoveInput)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _Cameras_cameraInputsManager__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../Cameras/cameraInputsManager */ "./node_modules/@babylonjs/core/Cameras/cameraInputsManager.js");
/* harmony import */ var _Misc_decorators__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../Misc/decorators */ "./node_modules/@babylonjs/core/Misc/decorators.js");
/* harmony import */ var _Events_keyboardEvents__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../Events/keyboardEvents */ "./node_modules/@babylonjs/core/Events/keyboardEvents.js");




/**
 * Manage the keyboard inputs to control the movement of a follow camera.
 * @see http://doc.babylonjs.com/how_to/customizing_camera_inputs
 */
var FollowCameraKeyboardMoveInput = /** @class */ (function () {
    function FollowCameraKeyboardMoveInput() {
        /**
         * Defines the list of key codes associated with the up action (increase heightOffset)
         */
        this.keysHeightOffsetIncr = [38];
        /**
         * Defines the list of key codes associated with the down action (decrease heightOffset)
         */
        this.keysHeightOffsetDecr = [40];
        /**
         * Defines whether the Alt modifier key is required to move up/down (alter heightOffset)
         */
        this.keysHeightOffsetModifierAlt = false;
        /**
         * Defines whether the Ctrl modifier key is required to move up/down (alter heightOffset)
         */
        this.keysHeightOffsetModifierCtrl = false;
        /**
         * Defines whether the Shift modifier key is required to move up/down (alter heightOffset)
         */
        this.keysHeightOffsetModifierShift = false;
        /**
         * Defines the list of key codes associated with the left action (increase rotationOffset)
         */
        this.keysRotationOffsetIncr = [37];
        /**
         * Defines the list of key codes associated with the right action (decrease rotationOffset)
         */
        this.keysRotationOffsetDecr = [39];
        /**
         * Defines whether the Alt modifier key is required to move left/right (alter rotationOffset)
         */
        this.keysRotationOffsetModifierAlt = false;
        /**
         * Defines whether the Ctrl modifier key is required to move left/right (alter rotationOffset)
         */
        this.keysRotationOffsetModifierCtrl = false;
        /**
         * Defines whether the Shift modifier key is required to move left/right (alter rotationOffset)
         */
        this.keysRotationOffsetModifierShift = false;
        /**
         * Defines the list of key codes associated with the zoom-in action (decrease radius)
         */
        this.keysRadiusIncr = [40];
        /**
         * Defines the list of key codes associated with the zoom-out action (increase radius)
         */
        this.keysRadiusDecr = [38];
        /**
         * Defines whether the Alt modifier key is required to zoom in/out (alter radius value)
         */
        this.keysRadiusModifierAlt = true;
        /**
         * Defines whether the Ctrl modifier key is required to zoom in/out (alter radius value)
         */
        this.keysRadiusModifierCtrl = false;
        /**
         * Defines whether the Shift modifier key is required to zoom in/out (alter radius value)
         */
        this.keysRadiusModifierShift = false;
        /**
         * Defines the rate of change of heightOffset.
         */
        this.heightSensibility = 1;
        /**
         * Defines the rate of change of rotationOffset.
         */
        this.rotationSensibility = 1;
        /**
         * Defines the rate of change of radius.
         */
        this.radiusSensibility = 1;
        this._keys = new Array();
    }
    /**
     * Attach the input controls to a specific dom element to get the input from.
     * @param element Defines the element the controls should be listened from
     * @param noPreventDefault Defines whether event caught by the controls should call preventdefault() (https://developer.mozilla.org/en-US/docs/Web/API/Event/preventDefault)
     */
    FollowCameraKeyboardMoveInput.prototype.attachControl = function (element, noPreventDefault) {
        var _this = this;
        if (this._onCanvasBlurObserver) {
            return;
        }
        this._scene = this.camera.getScene();
        this._engine = this._scene.getEngine();
        this._onCanvasBlurObserver = this._engine.onCanvasBlurObservable.add(function () {
            _this._keys = [];
        });
        this._onKeyboardObserver = this._scene.onKeyboardObservable.add(function (info) {
            var evt = info.event;
            if (!evt.metaKey) {
                if (info.type === _Events_keyboardEvents__WEBPACK_IMPORTED_MODULE_2__.KeyboardEventTypes.KEYDOWN) {
                    _this._ctrlPressed = evt.ctrlKey;
                    _this._altPressed = evt.altKey;
                    _this._shiftPressed = evt.shiftKey;
                    if (_this.keysHeightOffsetIncr.indexOf(evt.keyCode) !== -1 ||
                        _this.keysHeightOffsetDecr.indexOf(evt.keyCode) !== -1 ||
                        _this.keysRotationOffsetIncr.indexOf(evt.keyCode) !== -1 ||
                        _this.keysRotationOffsetDecr.indexOf(evt.keyCode) !== -1 ||
                        _this.keysRadiusIncr.indexOf(evt.keyCode) !== -1 ||
                        _this.keysRadiusDecr.indexOf(evt.keyCode) !== -1) {
                        var index = _this._keys.indexOf(evt.keyCode);
                        if (index === -1) {
                            _this._keys.push(evt.keyCode);
                        }
                        if (evt.preventDefault) {
                            if (!noPreventDefault) {
                                evt.preventDefault();
                            }
                        }
                    }
                }
                else {
                    if (_this.keysHeightOffsetIncr.indexOf(evt.keyCode) !== -1 ||
                        _this.keysHeightOffsetDecr.indexOf(evt.keyCode) !== -1 ||
                        _this.keysRotationOffsetIncr.indexOf(evt.keyCode) !== -1 ||
                        _this.keysRotationOffsetDecr.indexOf(evt.keyCode) !== -1 ||
                        _this.keysRadiusIncr.indexOf(evt.keyCode) !== -1 ||
                        _this.keysRadiusDecr.indexOf(evt.keyCode) !== -1) {
                        var index = _this._keys.indexOf(evt.keyCode);
                        if (index >= 0) {
                            _this._keys.splice(index, 1);
                        }
                        if (evt.preventDefault) {
                            if (!noPreventDefault) {
                                evt.preventDefault();
                            }
                        }
                    }
                }
            }
        });
    };
    /**
     * Detach the current controls from the specified dom element.
     * @param element Defines the element to stop listening the inputs from
     */
    FollowCameraKeyboardMoveInput.prototype.detachControl = function (element) {
        if (this._scene) {
            if (this._onKeyboardObserver) {
                this._scene.onKeyboardObservable.remove(this._onKeyboardObserver);
            }
            if (this._onCanvasBlurObserver) {
                this._engine.onCanvasBlurObservable.remove(this._onCanvasBlurObserver);
            }
            this._onKeyboardObserver = null;
            this._onCanvasBlurObserver = null;
        }
        this._keys = [];
    };
    /**
     * Update the current camera state depending on the inputs that have been used this frame.
     * This is a dynamically created lambda to avoid the performance penalty of looping for inputs in the render loop.
     */
    FollowCameraKeyboardMoveInput.prototype.checkInputs = function () {
        var _this = this;
        if (this._onKeyboardObserver) {
            this._keys.forEach(function (keyCode) {
                if (_this.keysHeightOffsetIncr.indexOf(keyCode) !== -1 &&
                    _this._modifierHeightOffset()) {
                    _this.camera.heightOffset += _this.heightSensibility;
                }
                else if (_this.keysHeightOffsetDecr.indexOf(keyCode) !== -1 &&
                    _this._modifierHeightOffset()) {
                    _this.camera.heightOffset -= _this.heightSensibility;
                }
                else if (_this.keysRotationOffsetIncr.indexOf(keyCode) !== -1 &&
                    _this._modifierRotationOffset()) {
                    _this.camera.rotationOffset += _this.rotationSensibility;
                    _this.camera.rotationOffset %= 360;
                }
                else if (_this.keysRotationOffsetDecr.indexOf(keyCode) !== -1 &&
                    _this._modifierRotationOffset()) {
                    _this.camera.rotationOffset -= _this.rotationSensibility;
                    _this.camera.rotationOffset %= 360;
                }
                else if (_this.keysRadiusIncr.indexOf(keyCode) !== -1 &&
                    _this._modifierRadius()) {
                    _this.camera.radius += _this.radiusSensibility;
                }
                else if (_this.keysRadiusDecr.indexOf(keyCode) !== -1 &&
                    _this._modifierRadius()) {
                    _this.camera.radius -= _this.radiusSensibility;
                }
            });
        }
    };
    /**
     * Gets the class name of the current input.
     * @returns the class name
     */
    FollowCameraKeyboardMoveInput.prototype.getClassName = function () {
        return "FollowCameraKeyboardMoveInput";
    };
    /**
     * Get the friendly name associated with the input class.
     * @returns the input friendly name
     */
    FollowCameraKeyboardMoveInput.prototype.getSimpleName = function () {
        return "keyboard";
    };
    /**
     * Check if the pressed modifier keys (Alt/Ctrl/Shift) match those configured to
     * allow modification of the heightOffset value.
     */
    FollowCameraKeyboardMoveInput.prototype._modifierHeightOffset = function () {
        return (this.keysHeightOffsetModifierAlt === this._altPressed &&
            this.keysHeightOffsetModifierCtrl === this._ctrlPressed &&
            this.keysHeightOffsetModifierShift === this._shiftPressed);
    };
    /**
     * Check if the pressed modifier keys (Alt/Ctrl/Shift) match those configured to
     * allow modification of the rotationOffset value.
     */
    FollowCameraKeyboardMoveInput.prototype._modifierRotationOffset = function () {
        return (this.keysRotationOffsetModifierAlt === this._altPressed &&
            this.keysRotationOffsetModifierCtrl === this._ctrlPressed &&
            this.keysRotationOffsetModifierShift === this._shiftPressed);
    };
    /**
     * Check if the pressed modifier keys (Alt/Ctrl/Shift) match those configured to
     * allow modification of the radius value.
     */
    FollowCameraKeyboardMoveInput.prototype._modifierRadius = function () {
        return (this.keysRadiusModifierAlt === this._altPressed &&
            this.keysRadiusModifierCtrl === this._ctrlPressed &&
            this.keysRadiusModifierShift === this._shiftPressed);
    };
    (0,tslib__WEBPACK_IMPORTED_MODULE_3__.__decorate)([
        (0,_Misc_decorators__WEBPACK_IMPORTED_MODULE_1__.serialize)()
    ], FollowCameraKeyboardMoveInput.prototype, "keysHeightOffsetIncr", void 0);
    (0,tslib__WEBPACK_IMPORTED_MODULE_3__.__decorate)([
        (0,_Misc_decorators__WEBPACK_IMPORTED_MODULE_1__.serialize)()
    ], FollowCameraKeyboardMoveInput.prototype, "keysHeightOffsetDecr", void 0);
    (0,tslib__WEBPACK_IMPORTED_MODULE_3__.__decorate)([
        (0,_Misc_decorators__WEBPACK_IMPORTED_MODULE_1__.serialize)()
    ], FollowCameraKeyboardMoveInput.prototype, "keysHeightOffsetModifierAlt", void 0);
    (0,tslib__WEBPACK_IMPORTED_MODULE_3__.__decorate)([
        (0,_Misc_decorators__WEBPACK_IMPORTED_MODULE_1__.serialize)()
    ], FollowCameraKeyboardMoveInput.prototype, "keysHeightOffsetModifierCtrl", void 0);
    (0,tslib__WEBPACK_IMPORTED_MODULE_3__.__decorate)([
        (0,_Misc_decorators__WEBPACK_IMPORTED_MODULE_1__.serialize)()
    ], FollowCameraKeyboardMoveInput.prototype, "keysHeightOffsetModifierShift", void 0);
    (0,tslib__WEBPACK_IMPORTED_MODULE_3__.__decorate)([
        (0,_Misc_decorators__WEBPACK_IMPORTED_MODULE_1__.serialize)()
    ], FollowCameraKeyboardMoveInput.prototype, "keysRotationOffsetIncr", void 0);
    (0,tslib__WEBPACK_IMPORTED_MODULE_3__.__decorate)([
        (0,_Misc_decorators__WEBPACK_IMPORTED_MODULE_1__.serialize)()
    ], FollowCameraKeyboardMoveInput.prototype, "keysRotationOffsetDecr", void 0);
    (0,tslib__WEBPACK_IMPORTED_MODULE_3__.__decorate)([
        (0,_Misc_decorators__WEBPACK_IMPORTED_MODULE_1__.serialize)()
    ], FollowCameraKeyboardMoveInput.prototype, "keysRotationOffsetModifierAlt", void 0);
    (0,tslib__WEBPACK_IMPORTED_MODULE_3__.__decorate)([
        (0,_Misc_decorators__WEBPACK_IMPORTED_MODULE_1__.serialize)()
    ], FollowCameraKeyboardMoveInput.prototype, "keysRotationOffsetModifierCtrl", void 0);
    (0,tslib__WEBPACK_IMPORTED_MODULE_3__.__decorate)([
        (0,_Misc_decorators__WEBPACK_IMPORTED_MODULE_1__.serialize)()
    ], FollowCameraKeyboardMoveInput.prototype, "keysRotationOffsetModifierShift", void 0);
    (0,tslib__WEBPACK_IMPORTED_MODULE_3__.__decorate)([
        (0,_Misc_decorators__WEBPACK_IMPORTED_MODULE_1__.serialize)()
    ], FollowCameraKeyboardMoveInput.prototype, "keysRadiusIncr", void 0);
    (0,tslib__WEBPACK_IMPORTED_MODULE_3__.__decorate)([
        (0,_Misc_decorators__WEBPACK_IMPORTED_MODULE_1__.serialize)()
    ], FollowCameraKeyboardMoveInput.prototype, "keysRadiusDecr", void 0);
    (0,tslib__WEBPACK_IMPORTED_MODULE_3__.__decorate)([
        (0,_Misc_decorators__WEBPACK_IMPORTED_MODULE_1__.serialize)()
    ], FollowCameraKeyboardMoveInput.prototype, "keysRadiusModifierAlt", void 0);
    (0,tslib__WEBPACK_IMPORTED_MODULE_3__.__decorate)([
        (0,_Misc_decorators__WEBPACK_IMPORTED_MODULE_1__.serialize)()
    ], FollowCameraKeyboardMoveInput.prototype, "keysRadiusModifierCtrl", void 0);
    (0,tslib__WEBPACK_IMPORTED_MODULE_3__.__decorate)([
        (0,_Misc_decorators__WEBPACK_IMPORTED_MODULE_1__.serialize)()
    ], FollowCameraKeyboardMoveInput.prototype, "keysRadiusModifierShift", void 0);
    (0,tslib__WEBPACK_IMPORTED_MODULE_3__.__decorate)([
        (0,_Misc_decorators__WEBPACK_IMPORTED_MODULE_1__.serialize)()
    ], FollowCameraKeyboardMoveInput.prototype, "heightSensibility", void 0);
    (0,tslib__WEBPACK_IMPORTED_MODULE_3__.__decorate)([
        (0,_Misc_decorators__WEBPACK_IMPORTED_MODULE_1__.serialize)()
    ], FollowCameraKeyboardMoveInput.prototype, "rotationSensibility", void 0);
    (0,tslib__WEBPACK_IMPORTED_MODULE_3__.__decorate)([
        (0,_Misc_decorators__WEBPACK_IMPORTED_MODULE_1__.serialize)()
    ], FollowCameraKeyboardMoveInput.prototype, "radiusSensibility", void 0);
    return FollowCameraKeyboardMoveInput;
}());

_Cameras_cameraInputsManager__WEBPACK_IMPORTED_MODULE_0__.CameraInputTypes.FollowCameraKeyboardMoveInput = FollowCameraKeyboardMoveInput;
//# sourceMappingURL=followCameraKeyboardMoveInput.js.map

/***/ }),

/***/ "./node_modules/@babylonjs/core/Cameras/Inputs/followCameraMouseWheelInput.js":
/*!************************************************************************************!*\
  !*** ./node_modules/@babylonjs/core/Cameras/Inputs/followCameraMouseWheelInput.js ***!
  \************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "FollowCameraMouseWheelInput": () => (/* binding */ FollowCameraMouseWheelInput)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _Misc_decorators__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../Misc/decorators */ "./node_modules/@babylonjs/core/Misc/decorators.js");
/* harmony import */ var _Cameras_cameraInputsManager__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../Cameras/cameraInputsManager */ "./node_modules/@babylonjs/core/Cameras/cameraInputsManager.js");
/* harmony import */ var _Events_pointerEvents__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../Events/pointerEvents */ "./node_modules/@babylonjs/core/Events/pointerEvents.js");




/**
 * Manage the mouse wheel inputs to control a follow camera.
 * @see http://doc.babylonjs.com/how_to/customizing_camera_inputs
 */
var FollowCameraMouseWheelInput = /** @class */ (function () {
    function FollowCameraMouseWheelInput() {
        /**
         * Moue wheel controls zoom. (Mouse wheel modifies camera.radius value.)
         */
        this.axisControlRadius = true;
        /**
         * Moue wheel controls height. (Mouse wheel modifies camera.heightOffset value.)
         */
        this.axisControlHeight = false;
        /**
         * Moue wheel controls angle. (Mouse wheel modifies camera.rotationOffset value.)
         */
        this.axisControlRotation = false;
        /**
         * Gets or Set the mouse wheel precision or how fast is the camera moves in
         * relation to mouseWheel events.
         */
        this.wheelPrecision = 3.0;
        /**
         * wheelDeltaPercentage will be used instead of wheelPrecision if different from 0.
         * It defines the percentage of current camera.radius to use as delta when wheel is used.
         */
        this.wheelDeltaPercentage = 0;
    }
    /**
     * Attach the input controls to a specific dom element to get the input from.
     * @param element Defines the element the controls should be listened from
     * @param noPreventDefault Defines whether event caught by the controls should call preventdefault() (https://developer.mozilla.org/en-US/docs/Web/API/Event/preventDefault)
     */
    FollowCameraMouseWheelInput.prototype.attachControl = function (element, noPreventDefault) {
        var _this = this;
        this._wheel = function (p, s) {
            // sanity check - this should be a PointerWheel event.
            if (p.type !== _Events_pointerEvents__WEBPACK_IMPORTED_MODULE_2__.PointerEventTypes.POINTERWHEEL) {
                return;
            }
            var event = p.event;
            var delta = 0;
            // Chrome, Safari: event.deltaY
            // IE: event.wheelDelta
            // Firefox: event.detail (inverted)
            var wheelDelta = Math.max(-1, Math.min(1, (event.deltaY || event.wheelDelta || -event.detail)));
            if (_this.wheelDeltaPercentage) {
                console.assert((_this.axisControlRadius +
                    _this.axisControlHeight +
                    _this.axisControlRotation) <= 1, "wheelDeltaPercentage only usable when mouse wheel " +
                    "controlls ONE axis. " +
                    "Currently enabled: " +
                    "axisControlRadius: " + _this.axisControlRadius +
                    ", axisControlHeightOffset: " + _this.axisControlHeight +
                    ", axisControlRotationOffset: " + _this.axisControlRotation);
                if (_this.axisControlRadius) {
                    delta =
                        wheelDelta * 0.01 * _this.wheelDeltaPercentage *
                            _this.camera.radius;
                }
                else if (_this.axisControlHeight) {
                    delta =
                        wheelDelta * 0.01 * _this.wheelDeltaPercentage *
                            _this.camera.heightOffset;
                }
                else if (_this.axisControlRotation) {
                    delta =
                        wheelDelta * 0.01 * _this.wheelDeltaPercentage *
                            _this.camera.rotationOffset;
                }
            }
            else {
                delta = wheelDelta * _this.wheelPrecision;
            }
            if (delta) {
                if (_this.axisControlRadius) {
                    _this.camera.radius += delta;
                }
                else if (_this.axisControlHeight) {
                    _this.camera.heightOffset -= delta;
                }
                else if (_this.axisControlRotation) {
                    _this.camera.rotationOffset -= delta;
                }
            }
            if (event.preventDefault) {
                if (!noPreventDefault) {
                    event.preventDefault();
                }
            }
        };
        this._observer = this.camera.getScene().onPointerObservable.add(this._wheel, _Events_pointerEvents__WEBPACK_IMPORTED_MODULE_2__.PointerEventTypes.POINTERWHEEL);
    };
    /**
     * Detach the current controls from the specified dom element.
     * @param element Defines the element to stop listening the inputs from
     */
    FollowCameraMouseWheelInput.prototype.detachControl = function (element) {
        if (this._observer && element) {
            this.camera.getScene().onPointerObservable.remove(this._observer);
            this._observer = null;
            this._wheel = null;
        }
    };
    /**
     * Gets the class name of the current intput.
     * @returns the class name
     */
    FollowCameraMouseWheelInput.prototype.getClassName = function () {
        return "ArcRotateCameraMouseWheelInput";
    };
    /**
     * Get the friendly name associated with the input class.
     * @returns the input friendly name
     */
    FollowCameraMouseWheelInput.prototype.getSimpleName = function () {
        return "mousewheel";
    };
    (0,tslib__WEBPACK_IMPORTED_MODULE_3__.__decorate)([
        (0,_Misc_decorators__WEBPACK_IMPORTED_MODULE_0__.serialize)()
    ], FollowCameraMouseWheelInput.prototype, "axisControlRadius", void 0);
    (0,tslib__WEBPACK_IMPORTED_MODULE_3__.__decorate)([
        (0,_Misc_decorators__WEBPACK_IMPORTED_MODULE_0__.serialize)()
    ], FollowCameraMouseWheelInput.prototype, "axisControlHeight", void 0);
    (0,tslib__WEBPACK_IMPORTED_MODULE_3__.__decorate)([
        (0,_Misc_decorators__WEBPACK_IMPORTED_MODULE_0__.serialize)()
    ], FollowCameraMouseWheelInput.prototype, "axisControlRotation", void 0);
    (0,tslib__WEBPACK_IMPORTED_MODULE_3__.__decorate)([
        (0,_Misc_decorators__WEBPACK_IMPORTED_MODULE_0__.serialize)()
    ], FollowCameraMouseWheelInput.prototype, "wheelPrecision", void 0);
    (0,tslib__WEBPACK_IMPORTED_MODULE_3__.__decorate)([
        (0,_Misc_decorators__WEBPACK_IMPORTED_MODULE_0__.serialize)()
    ], FollowCameraMouseWheelInput.prototype, "wheelDeltaPercentage", void 0);
    return FollowCameraMouseWheelInput;
}());

_Cameras_cameraInputsManager__WEBPACK_IMPORTED_MODULE_1__.CameraInputTypes.FollowCameraMouseWheelInput = FollowCameraMouseWheelInput;
//# sourceMappingURL=followCameraMouseWheelInput.js.map

/***/ }),

/***/ "./node_modules/@babylonjs/core/Cameras/Inputs/followCameraPointersInput.js":
/*!**********************************************************************************!*\
  !*** ./node_modules/@babylonjs/core/Cameras/Inputs/followCameraPointersInput.js ***!
  \**********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "FollowCameraPointersInput": () => (/* binding */ FollowCameraPointersInput)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _Misc_decorators__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../Misc/decorators */ "./node_modules/@babylonjs/core/Misc/decorators.js");
/* harmony import */ var _Cameras_cameraInputsManager__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../Cameras/cameraInputsManager */ "./node_modules/@babylonjs/core/Cameras/cameraInputsManager.js");
/* harmony import */ var _Cameras_Inputs_BaseCameraPointersInput__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../Cameras/Inputs/BaseCameraPointersInput */ "./node_modules/@babylonjs/core/Cameras/Inputs/BaseCameraPointersInput.js");




/**
 * Manage the pointers inputs to control an follow camera.
 * @see http://doc.babylonjs.com/how_to/customizing_camera_inputs
 */
var FollowCameraPointersInput = /** @class */ (function (_super) {
    (0,tslib__WEBPACK_IMPORTED_MODULE_3__.__extends)(FollowCameraPointersInput, _super);
    function FollowCameraPointersInput() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        /**
         * Defines the pointer angular sensibility along the X axis or how fast is
         * the camera rotating.
         * A negative number will reverse the axis direction.
         */
        _this.angularSensibilityX = 1;
        /**
         * Defines the pointer angular sensibility along the Y axis or how fast is
         * the camera rotating.
         * A negative number will reverse the axis direction.
         */
        _this.angularSensibilityY = 1;
        /**
         * Defines the pointer pinch precision or how fast is the camera zooming.
         * A negative number will reverse the axis direction.
         */
        _this.pinchPrecision = 10000.0;
        /**
         * pinchDeltaPercentage will be used instead of pinchPrecision if different
         * from 0.
         * It defines the percentage of current camera.radius to use as delta when
         * pinch zoom is used.
         */
        _this.pinchDeltaPercentage = 0;
        /**
         * Pointer X axis controls zoom. (X axis modifies camera.radius value.)
         */
        _this.axisXControlRadius = false;
        /**
         * Pointer X axis controls height. (X axis modifies camera.heightOffset value.)
         */
        _this.axisXControlHeight = false;
        /**
         * Pointer X axis controls angle. (X axis modifies camera.rotationOffset value.)
         */
        _this.axisXControlRotation = true;
        /**
         * Pointer Y axis controls zoom. (Y axis modifies camera.radius value.)
         */
        _this.axisYControlRadius = false;
        /**
         * Pointer Y axis controls height. (Y axis modifies camera.heightOffset value.)
         */
        _this.axisYControlHeight = true;
        /**
         * Pointer Y axis controls angle. (Y axis modifies camera.rotationOffset value.)
         */
        _this.axisYControlRotation = false;
        /**
         * Pinch controls zoom. (Pinch modifies camera.radius value.)
         */
        _this.axisPinchControlRadius = true;
        /**
         * Pinch controls height. (Pinch modifies camera.heightOffset value.)
         */
        _this.axisPinchControlHeight = false;
        /**
         * Pinch controls angle. (Pinch modifies camera.rotationOffset value.)
         */
        _this.axisPinchControlRotation = false;
        /**
         * Log error messages if basic misconfiguration has occurred.
         */
        _this.warningEnable = true;
        /* Check for obvious misconfiguration. */
        _this._warningCounter = 0;
        return _this;
    }
    /**
     * Gets the class name of the current input.
     * @returns the class name
     */
    FollowCameraPointersInput.prototype.getClassName = function () {
        return "FollowCameraPointersInput";
    };
    FollowCameraPointersInput.prototype.onTouch = function (pointA, offsetX, offsetY) {
        this._warning();
        if (this.axisXControlRotation) {
            this.camera.rotationOffset += offsetX / this.angularSensibilityX;
        }
        else if (this.axisYControlRotation) {
            this.camera.rotationOffset += offsetY / this.angularSensibilityX;
        }
        if (this.axisXControlHeight) {
            this.camera.heightOffset += offsetX / this.angularSensibilityY;
        }
        else if (this.axisYControlHeight) {
            this.camera.heightOffset += offsetY / this.angularSensibilityY;
        }
        if (this.axisXControlRadius) {
            this.camera.radius -= offsetX / this.angularSensibilityY;
        }
        else if (this.axisYControlRadius) {
            this.camera.radius -= offsetY / this.angularSensibilityY;
        }
    };
    FollowCameraPointersInput.prototype.onMultiTouch = function (pointA, pointB, previousPinchSquaredDistance, pinchSquaredDistance, previousMultiTouchPanPosition, multiTouchPanPosition) {
        if (previousPinchSquaredDistance === 0 && previousMultiTouchPanPosition === null) {
            // First time this method is called for new pinch.
            // Next time this is called there will be a
            // previousPinchSquaredDistance and pinchSquaredDistance to compare.
            return;
        }
        if (pinchSquaredDistance === 0 && multiTouchPanPosition === null) {
            // Last time this method is called at the end of a pinch.
            return;
        }
        var pinchDelta = (pinchSquaredDistance - previousPinchSquaredDistance) /
            (this.pinchPrecision * (this.angularSensibilityX + this.angularSensibilityY) / 2);
        if (this.pinchDeltaPercentage) {
            pinchDelta *= 0.01 * this.pinchDeltaPercentage;
            if (this.axisPinchControlRotation) {
                this.camera.rotationOffset += pinchDelta * this.camera.rotationOffset;
            }
            if (this.axisPinchControlHeight) {
                this.camera.heightOffset += pinchDelta * this.camera.heightOffset;
            }
            if (this.axisPinchControlRadius) {
                this.camera.radius -= pinchDelta * this.camera.radius;
            }
        }
        else {
            if (this.axisPinchControlRotation) {
                this.camera.rotationOffset += pinchDelta;
            }
            if (this.axisPinchControlHeight) {
                this.camera.heightOffset += pinchDelta;
            }
            if (this.axisPinchControlRadius) {
                this.camera.radius -= pinchDelta;
            }
        }
    };
    FollowCameraPointersInput.prototype._warning = function () {
        if (!this.warningEnable || this._warningCounter++ % 100 !== 0) {
            return;
        }
        var warn = "It probably only makes sense to control ONE camera " +
            "property with each pointer axis. Set 'warningEnable = false' " +
            "if you are sure. Currently enabled: ";
        console.assert((this.axisXControlRotation +
            this.axisXControlHeight +
            this.axisXControlRadius) <= 1, warn +
            "axisXControlRotation: " + this.axisXControlRotation +
            ", axisXControlHeight: " + this.axisXControlHeight +
            ", axisXControlRadius: " + this.axisXControlRadius);
        console.assert((this.axisYControlRotation +
            this.axisYControlHeight +
            this.axisYControlRadius) <= 1, warn +
            "axisYControlRotation: " + this.axisYControlRotation +
            ", axisYControlHeight: " + this.axisYControlHeight +
            ", axisYControlRadius: " + this.axisYControlRadius);
        console.assert((this.axisPinchControlRotation +
            this.axisPinchControlHeight +
            this.axisPinchControlRadius) <= 1, warn +
            "axisPinchControlRotation: " + this.axisPinchControlRotation +
            ", axisPinchControlHeight: " + this.axisPinchControlHeight +
            ", axisPinchControlRadius: " + this.axisPinchControlRadius);
    };
    (0,tslib__WEBPACK_IMPORTED_MODULE_3__.__decorate)([
        (0,_Misc_decorators__WEBPACK_IMPORTED_MODULE_0__.serialize)()
    ], FollowCameraPointersInput.prototype, "angularSensibilityX", void 0);
    (0,tslib__WEBPACK_IMPORTED_MODULE_3__.__decorate)([
        (0,_Misc_decorators__WEBPACK_IMPORTED_MODULE_0__.serialize)()
    ], FollowCameraPointersInput.prototype, "angularSensibilityY", void 0);
    (0,tslib__WEBPACK_IMPORTED_MODULE_3__.__decorate)([
        (0,_Misc_decorators__WEBPACK_IMPORTED_MODULE_0__.serialize)()
    ], FollowCameraPointersInput.prototype, "pinchPrecision", void 0);
    (0,tslib__WEBPACK_IMPORTED_MODULE_3__.__decorate)([
        (0,_Misc_decorators__WEBPACK_IMPORTED_MODULE_0__.serialize)()
    ], FollowCameraPointersInput.prototype, "pinchDeltaPercentage", void 0);
    (0,tslib__WEBPACK_IMPORTED_MODULE_3__.__decorate)([
        (0,_Misc_decorators__WEBPACK_IMPORTED_MODULE_0__.serialize)()
    ], FollowCameraPointersInput.prototype, "axisXControlRadius", void 0);
    (0,tslib__WEBPACK_IMPORTED_MODULE_3__.__decorate)([
        (0,_Misc_decorators__WEBPACK_IMPORTED_MODULE_0__.serialize)()
    ], FollowCameraPointersInput.prototype, "axisXControlHeight", void 0);
    (0,tslib__WEBPACK_IMPORTED_MODULE_3__.__decorate)([
        (0,_Misc_decorators__WEBPACK_IMPORTED_MODULE_0__.serialize)()
    ], FollowCameraPointersInput.prototype, "axisXControlRotation", void 0);
    (0,tslib__WEBPACK_IMPORTED_MODULE_3__.__decorate)([
        (0,_Misc_decorators__WEBPACK_IMPORTED_MODULE_0__.serialize)()
    ], FollowCameraPointersInput.prototype, "axisYControlRadius", void 0);
    (0,tslib__WEBPACK_IMPORTED_MODULE_3__.__decorate)([
        (0,_Misc_decorators__WEBPACK_IMPORTED_MODULE_0__.serialize)()
    ], FollowCameraPointersInput.prototype, "axisYControlHeight", void 0);
    (0,tslib__WEBPACK_IMPORTED_MODULE_3__.__decorate)([
        (0,_Misc_decorators__WEBPACK_IMPORTED_MODULE_0__.serialize)()
    ], FollowCameraPointersInput.prototype, "axisYControlRotation", void 0);
    (0,tslib__WEBPACK_IMPORTED_MODULE_3__.__decorate)([
        (0,_Misc_decorators__WEBPACK_IMPORTED_MODULE_0__.serialize)()
    ], FollowCameraPointersInput.prototype, "axisPinchControlRadius", void 0);
    (0,tslib__WEBPACK_IMPORTED_MODULE_3__.__decorate)([
        (0,_Misc_decorators__WEBPACK_IMPORTED_MODULE_0__.serialize)()
    ], FollowCameraPointersInput.prototype, "axisPinchControlHeight", void 0);
    (0,tslib__WEBPACK_IMPORTED_MODULE_3__.__decorate)([
        (0,_Misc_decorators__WEBPACK_IMPORTED_MODULE_0__.serialize)()
    ], FollowCameraPointersInput.prototype, "axisPinchControlRotation", void 0);
    return FollowCameraPointersInput;
}(_Cameras_Inputs_BaseCameraPointersInput__WEBPACK_IMPORTED_MODULE_2__.BaseCameraPointersInput));

_Cameras_cameraInputsManager__WEBPACK_IMPORTED_MODULE_1__.CameraInputTypes.FollowCameraPointersInput = FollowCameraPointersInput;
//# sourceMappingURL=followCameraPointersInput.js.map

/***/ }),

/***/ "./node_modules/@babylonjs/core/Cameras/Inputs/freeCameraDeviceOrientationInput.js":
/*!*****************************************************************************************!*\
  !*** ./node_modules/@babylonjs/core/Cameras/Inputs/freeCameraDeviceOrientationInput.js ***!
  \*****************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "FreeCameraDeviceOrientationInput": () => (/* binding */ FreeCameraDeviceOrientationInput)
/* harmony export */ });
/* harmony import */ var _Cameras_cameraInputsManager__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../Cameras/cameraInputsManager */ "./node_modules/@babylonjs/core/Cameras/cameraInputsManager.js");
/* harmony import */ var _Maths_math_vector__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../Maths/math.vector */ "./node_modules/@babylonjs/core/Maths/math.vector.js");
/* harmony import */ var _Misc_tools__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../Misc/tools */ "./node_modules/@babylonjs/core/Misc/tools.js");
/* harmony import */ var _Cameras_freeCameraInputsManager__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../Cameras/freeCameraInputsManager */ "./node_modules/@babylonjs/core/Cameras/freeCameraInputsManager.js");
/* harmony import */ var _Misc_observable__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../Misc/observable */ "./node_modules/@babylonjs/core/Misc/observable.js");





/**
 * Add orientation input support to the input manager.
 * @returns the current input manager
 */
_Cameras_freeCameraInputsManager__WEBPACK_IMPORTED_MODULE_3__.FreeCameraInputsManager.prototype.addDeviceOrientation = function () {
    if (!this._deviceOrientationInput) {
        this._deviceOrientationInput = new FreeCameraDeviceOrientationInput();
        this.add(this._deviceOrientationInput);
    }
    return this;
};
/**
 * Takes information about the orientation of the device as reported by the deviceorientation event to orient the camera.
 * Screen rotation is taken into account.
 * @see http://doc.babylonjs.com/how_to/customizing_camera_inputs
 */
var FreeCameraDeviceOrientationInput = /** @class */ (function () {
    /**
     * Instantiates a new input
     * @see http://doc.babylonjs.com/how_to/customizing_camera_inputs
     */
    function FreeCameraDeviceOrientationInput() {
        var _this = this;
        this._screenOrientationAngle = 0;
        this._screenQuaternion = new _Maths_math_vector__WEBPACK_IMPORTED_MODULE_1__.Quaternion();
        this._alpha = 0;
        this._beta = 0;
        this._gamma = 0;
        /**
         * @hidden
         */
        this._onDeviceOrientationChangedObservable = new _Misc_observable__WEBPACK_IMPORTED_MODULE_4__.Observable();
        this._orientationChanged = function () {
            _this._screenOrientationAngle = (window.orientation !== undefined ? +window.orientation : (window.screen.orientation && (window.screen.orientation)['angle'] ? (window.screen.orientation).angle : 0));
            _this._screenOrientationAngle = -_Misc_tools__WEBPACK_IMPORTED_MODULE_2__.Tools.ToRadians(_this._screenOrientationAngle / 2);
            _this._screenQuaternion.copyFromFloats(0, Math.sin(_this._screenOrientationAngle), 0, Math.cos(_this._screenOrientationAngle));
        };
        this._deviceOrientation = function (evt) {
            _this._alpha = evt.alpha !== null ? evt.alpha : 0;
            _this._beta = evt.beta !== null ? evt.beta : 0;
            _this._gamma = evt.gamma !== null ? evt.gamma : 0;
            if (evt.alpha !== null) {
                _this._onDeviceOrientationChangedObservable.notifyObservers();
            }
        };
        this._constantTranform = new _Maths_math_vector__WEBPACK_IMPORTED_MODULE_1__.Quaternion(-Math.sqrt(0.5), 0, 0, Math.sqrt(0.5));
        this._orientationChanged();
    }
    /**
     * Can be used to detect if a device orientation sensor is available on a device
     * @param timeout amount of time in milliseconds to wait for a response from the sensor (default: infinite)
     * @returns a promise that will resolve on orientation change
     */
    FreeCameraDeviceOrientationInput.WaitForOrientationChangeAsync = function (timeout) {
        return new Promise(function (res, rej) {
            var gotValue = false;
            var eventHandler = function () {
                window.removeEventListener("deviceorientation", eventHandler);
                gotValue = true;
                res();
            };
            // If timeout is populated reject the promise
            if (timeout) {
                setTimeout(function () {
                    if (!gotValue) {
                        window.removeEventListener("deviceorientation", eventHandler);
                        rej("WaitForOrientationChangeAsync timed out");
                    }
                }, timeout);
            }
            if (typeof (DeviceOrientationEvent) !== "undefined" && typeof DeviceOrientationEvent.requestPermission === 'function') {
                DeviceOrientationEvent.requestPermission()
                    .then(function (response) {
                    if (response == 'granted') {
                        window.addEventListener("deviceorientation", eventHandler);
                    }
                    else {
                        _Misc_tools__WEBPACK_IMPORTED_MODULE_2__.Tools.Warn("Permission not granted.");
                    }
                })
                    .catch(function (error) {
                    _Misc_tools__WEBPACK_IMPORTED_MODULE_2__.Tools.Error(error);
                });
            }
            else {
                window.addEventListener("deviceorientation", eventHandler);
            }
        });
    };
    Object.defineProperty(FreeCameraDeviceOrientationInput.prototype, "camera", {
        /**
         * Define the camera controlled by the input.
         */
        get: function () {
            return this._camera;
        },
        set: function (camera) {
            var _this = this;
            this._camera = camera;
            if (this._camera != null && !this._camera.rotationQuaternion) {
                this._camera.rotationQuaternion = new _Maths_math_vector__WEBPACK_IMPORTED_MODULE_1__.Quaternion();
            }
            if (this._camera) {
                this._camera.onDisposeObservable.add(function () {
                    _this._onDeviceOrientationChangedObservable.clear();
                });
            }
        },
        enumerable: true,
        configurable: true
    });
    /**
     * Attach the input controls to a specific dom element to get the input from.
     * @param element Defines the element the controls should be listened from
     * @param noPreventDefault Defines whether event caught by the controls should call preventdefault() (https://developer.mozilla.org/en-US/docs/Web/API/Event/preventDefault)
     */
    FreeCameraDeviceOrientationInput.prototype.attachControl = function (element, noPreventDefault) {
        var _this = this;
        var hostWindow = this.camera.getScene().getEngine().getHostWindow();
        if (hostWindow) {
            var eventHandler_1 = function () {
                hostWindow.addEventListener("orientationchange", _this._orientationChanged);
                hostWindow.addEventListener("deviceorientation", _this._deviceOrientation);
                //In certain cases, the attach control is called AFTER orientation was changed,
                //So this is needed.
                _this._orientationChanged();
            };
            if (typeof (DeviceOrientationEvent) !== "undefined" && typeof DeviceOrientationEvent.requestPermission === 'function') {
                DeviceOrientationEvent.requestPermission()
                    .then(function (response) {
                    if (response === 'granted') {
                        eventHandler_1();
                    }
                    else {
                        _Misc_tools__WEBPACK_IMPORTED_MODULE_2__.Tools.Warn("Permission not granted.");
                    }
                })
                    .catch(function (error) {
                    _Misc_tools__WEBPACK_IMPORTED_MODULE_2__.Tools.Error(error);
                });
            }
            else {
                eventHandler_1();
            }
        }
    };
    /**
     * Detach the current controls from the specified dom element.
     * @param element Defines the element to stop listening the inputs from
     */
    FreeCameraDeviceOrientationInput.prototype.detachControl = function (element) {
        window.removeEventListener("orientationchange", this._orientationChanged);
        window.removeEventListener("deviceorientation", this._deviceOrientation);
        this._alpha = 0;
    };
    /**
     * Update the current camera state depending on the inputs that have been used this frame.
     * This is a dynamically created lambda to avoid the performance penalty of looping for inputs in the render loop.
     */
    FreeCameraDeviceOrientationInput.prototype.checkInputs = function () {
        //if no device orientation provided, don't update the rotation.
        //Only testing against alpha under the assumption thatnorientation will never be so exact when set.
        if (!this._alpha) {
            return;
        }
        _Maths_math_vector__WEBPACK_IMPORTED_MODULE_1__.Quaternion.RotationYawPitchRollToRef(_Misc_tools__WEBPACK_IMPORTED_MODULE_2__.Tools.ToRadians(this._alpha), _Misc_tools__WEBPACK_IMPORTED_MODULE_2__.Tools.ToRadians(this._beta), -_Misc_tools__WEBPACK_IMPORTED_MODULE_2__.Tools.ToRadians(this._gamma), this.camera.rotationQuaternion);
        this._camera.rotationQuaternion.multiplyInPlace(this._screenQuaternion);
        this._camera.rotationQuaternion.multiplyInPlace(this._constantTranform);
        //Mirror on XY Plane
        this._camera.rotationQuaternion.z *= -1;
        this._camera.rotationQuaternion.w *= -1;
    };
    /**
     * Gets the class name of the current intput.
     * @returns the class name
     */
    FreeCameraDeviceOrientationInput.prototype.getClassName = function () {
        return "FreeCameraDeviceOrientationInput";
    };
    /**
     * Get the friendly name associated with the input class.
     * @returns the input friendly name
     */
    FreeCameraDeviceOrientationInput.prototype.getSimpleName = function () {
        return "deviceOrientation";
    };
    return FreeCameraDeviceOrientationInput;
}());

_Cameras_cameraInputsManager__WEBPACK_IMPORTED_MODULE_0__.CameraInputTypes.FreeCameraDeviceOrientationInput = FreeCameraDeviceOrientationInput;
//# sourceMappingURL=freeCameraDeviceOrientationInput.js.map

/***/ }),

/***/ "./node_modules/@babylonjs/core/Cameras/Inputs/freeCameraGamepadInput.js":
/*!*******************************************************************************!*\
  !*** ./node_modules/@babylonjs/core/Cameras/Inputs/freeCameraGamepadInput.js ***!
  \*******************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "FreeCameraGamepadInput": () => (/* binding */ FreeCameraGamepadInput)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _Misc_decorators__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../Misc/decorators */ "./node_modules/@babylonjs/core/Misc/decorators.js");
/* harmony import */ var _Cameras_cameraInputsManager__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../Cameras/cameraInputsManager */ "./node_modules/@babylonjs/core/Cameras/cameraInputsManager.js");
/* harmony import */ var _Maths_math_vector__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../Maths/math.vector */ "./node_modules/@babylonjs/core/Maths/math.vector.js");
/* harmony import */ var _Gamepads_gamepad__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../Gamepads/gamepad */ "./node_modules/@babylonjs/core/Gamepads/gamepad.js");





/**
 * Manage the gamepad inputs to control a free camera.
 * @see http://doc.babylonjs.com/how_to/customizing_camera_inputs
 */
var FreeCameraGamepadInput = /** @class */ (function () {
    function FreeCameraGamepadInput() {
        /**
         * Defines the gamepad rotation sensiblity.
         * This is the threshold from when rotation starts to be accounted for to prevent jittering.
         */
        this.gamepadAngularSensibility = 200;
        /**
         * Defines the gamepad move sensiblity.
         * This is the threshold from when moving starts to be accounted for for to prevent jittering.
         */
        this.gamepadMoveSensibility = 40;
        this._yAxisScale = 1.0;
        this._cameraTransform = _Maths_math_vector__WEBPACK_IMPORTED_MODULE_2__.Matrix.Identity();
        this._deltaTransform = _Maths_math_vector__WEBPACK_IMPORTED_MODULE_2__.Vector3.Zero();
        this._vector3 = _Maths_math_vector__WEBPACK_IMPORTED_MODULE_2__.Vector3.Zero();
        this._vector2 = _Maths_math_vector__WEBPACK_IMPORTED_MODULE_2__.Vector2.Zero();
    }
    Object.defineProperty(FreeCameraGamepadInput.prototype, "invertYAxis", {
        /**
         * Gets or sets a boolean indicating that Yaxis (for right stick) should be inverted
         */
        get: function () {
            return this._yAxisScale !== 1.0;
        },
        set: function (value) {
            this._yAxisScale = value ? -1.0 : 1.0;
        },
        enumerable: true,
        configurable: true
    });
    /**
     * Attach the input controls to a specific dom element to get the input from.
     * @param element Defines the element the controls should be listened from
     * @param noPreventDefault Defines whether event caught by the controls should call preventdefault() (https://developer.mozilla.org/en-US/docs/Web/API/Event/preventDefault)
     */
    FreeCameraGamepadInput.prototype.attachControl = function (element, noPreventDefault) {
        var _this = this;
        var manager = this.camera.getScene().gamepadManager;
        this._onGamepadConnectedObserver = manager.onGamepadConnectedObservable.add(function (gamepad) {
            if (gamepad.type !== _Gamepads_gamepad__WEBPACK_IMPORTED_MODULE_3__.Gamepad.POSE_ENABLED) {
                // prioritize XBOX gamepads.
                if (!_this.gamepad || gamepad.type === _Gamepads_gamepad__WEBPACK_IMPORTED_MODULE_3__.Gamepad.XBOX) {
                    _this.gamepad = gamepad;
                }
            }
        });
        this._onGamepadDisconnectedObserver = manager.onGamepadDisconnectedObservable.add(function (gamepad) {
            if (_this.gamepad === gamepad) {
                _this.gamepad = null;
            }
        });
        this.gamepad = manager.getGamepadByType(_Gamepads_gamepad__WEBPACK_IMPORTED_MODULE_3__.Gamepad.XBOX);
    };
    /**
     * Detach the current controls from the specified dom element.
     * @param element Defines the element to stop listening the inputs from
     */
    FreeCameraGamepadInput.prototype.detachControl = function (element) {
        this.camera.getScene().gamepadManager.onGamepadConnectedObservable.remove(this._onGamepadConnectedObserver);
        this.camera.getScene().gamepadManager.onGamepadDisconnectedObservable.remove(this._onGamepadDisconnectedObserver);
        this.gamepad = null;
    };
    /**
     * Update the current camera state depending on the inputs that have been used this frame.
     * This is a dynamically created lambda to avoid the performance penalty of looping for inputs in the render loop.
     */
    FreeCameraGamepadInput.prototype.checkInputs = function () {
        if (this.gamepad && this.gamepad.leftStick) {
            var camera = this.camera;
            var LSValues = this.gamepad.leftStick;
            var normalizedLX = LSValues.x / this.gamepadMoveSensibility;
            var normalizedLY = LSValues.y / this.gamepadMoveSensibility;
            LSValues.x = Math.abs(normalizedLX) > 0.005 ? 0 + normalizedLX : 0;
            LSValues.y = Math.abs(normalizedLY) > 0.005 ? 0 + normalizedLY : 0;
            var RSValues = this.gamepad.rightStick;
            if (RSValues) {
                var normalizedRX = RSValues.x / this.gamepadAngularSensibility;
                var normalizedRY = (RSValues.y / this.gamepadAngularSensibility) * this._yAxisScale;
                RSValues.x = Math.abs(normalizedRX) > 0.001 ? 0 + normalizedRX : 0;
                RSValues.y = Math.abs(normalizedRY) > 0.001 ? 0 + normalizedRY : 0;
            }
            else {
                RSValues = { x: 0, y: 0 };
            }
            if (!camera.rotationQuaternion) {
                _Maths_math_vector__WEBPACK_IMPORTED_MODULE_2__.Matrix.RotationYawPitchRollToRef(camera.rotation.y, camera.rotation.x, 0, this._cameraTransform);
            }
            else {
                camera.rotationQuaternion.toRotationMatrix(this._cameraTransform);
            }
            var speed = camera._computeLocalCameraSpeed() * 50.0;
            this._vector3.copyFromFloats(LSValues.x * speed, 0, -LSValues.y * speed);
            _Maths_math_vector__WEBPACK_IMPORTED_MODULE_2__.Vector3.TransformCoordinatesToRef(this._vector3, this._cameraTransform, this._deltaTransform);
            camera.cameraDirection.addInPlace(this._deltaTransform);
            this._vector2.copyFromFloats(RSValues.y, RSValues.x);
            camera.cameraRotation.addInPlace(this._vector2);
        }
    };
    /**
     * Gets the class name of the current intput.
     * @returns the class name
     */
    FreeCameraGamepadInput.prototype.getClassName = function () {
        return "FreeCameraGamepadInput";
    };
    /**
     * Get the friendly name associated with the input class.
     * @returns the input friendly name
     */
    FreeCameraGamepadInput.prototype.getSimpleName = function () {
        return "gamepad";
    };
    (0,tslib__WEBPACK_IMPORTED_MODULE_4__.__decorate)([
        (0,_Misc_decorators__WEBPACK_IMPORTED_MODULE_0__.serialize)()
    ], FreeCameraGamepadInput.prototype, "gamepadAngularSensibility", void 0);
    (0,tslib__WEBPACK_IMPORTED_MODULE_4__.__decorate)([
        (0,_Misc_decorators__WEBPACK_IMPORTED_MODULE_0__.serialize)()
    ], FreeCameraGamepadInput.prototype, "gamepadMoveSensibility", void 0);
    return FreeCameraGamepadInput;
}());

_Cameras_cameraInputsManager__WEBPACK_IMPORTED_MODULE_1__.CameraInputTypes.FreeCameraGamepadInput = FreeCameraGamepadInput;
//# sourceMappingURL=freeCameraGamepadInput.js.map

/***/ }),

/***/ "./node_modules/@babylonjs/core/Cameras/Inputs/freeCameraKeyboardMoveInput.js":
/*!************************************************************************************!*\
  !*** ./node_modules/@babylonjs/core/Cameras/Inputs/freeCameraKeyboardMoveInput.js ***!
  \************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "FreeCameraKeyboardMoveInput": () => (/* binding */ FreeCameraKeyboardMoveInput)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _Misc_decorators__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../Misc/decorators */ "./node_modules/@babylonjs/core/Misc/decorators.js");
/* harmony import */ var _Cameras_cameraInputsManager__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../Cameras/cameraInputsManager */ "./node_modules/@babylonjs/core/Cameras/cameraInputsManager.js");
/* harmony import */ var _Events_keyboardEvents__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../Events/keyboardEvents */ "./node_modules/@babylonjs/core/Events/keyboardEvents.js");
/* harmony import */ var _Maths_math_vector__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../Maths/math.vector */ "./node_modules/@babylonjs/core/Maths/math.vector.js");





/**
 * Manage the keyboard inputs to control the movement of a free camera.
 * @see http://doc.babylonjs.com/how_to/customizing_camera_inputs
 */
var FreeCameraKeyboardMoveInput = /** @class */ (function () {
    function FreeCameraKeyboardMoveInput() {
        /**
         * Gets or Set the list of keyboard keys used to control the forward move of the camera.
         */
        this.keysUp = [38];
        /**
         * Gets or Set the list of keyboard keys used to control the backward move of the camera.
         */
        this.keysDown = [40];
        /**
         * Gets or Set the list of keyboard keys used to control the left strafe move of the camera.
         */
        this.keysLeft = [37];
        /**
         * Gets or Set the list of keyboard keys used to control the right strafe move of the camera.
         */
        this.keysRight = [39];
        this._keys = new Array();
    }
    /**
     * Attach the input controls to a specific dom element to get the input from.
     * @param element Defines the element the controls should be listened from
     * @param noPreventDefault Defines whether event caught by the controls should call preventdefault() (https://developer.mozilla.org/en-US/docs/Web/API/Event/preventDefault)
     */
    FreeCameraKeyboardMoveInput.prototype.attachControl = function (element, noPreventDefault) {
        var _this = this;
        if (this._onCanvasBlurObserver) {
            return;
        }
        this._scene = this.camera.getScene();
        this._engine = this._scene.getEngine();
        this._onCanvasBlurObserver = this._engine.onCanvasBlurObservable.add(function () {
            _this._keys = [];
        });
        this._onKeyboardObserver = this._scene.onKeyboardObservable.add(function (info) {
            var evt = info.event;
            if (!evt.metaKey) {
                if (info.type === _Events_keyboardEvents__WEBPACK_IMPORTED_MODULE_2__.KeyboardEventTypes.KEYDOWN) {
                    if (_this.keysUp.indexOf(evt.keyCode) !== -1 ||
                        _this.keysDown.indexOf(evt.keyCode) !== -1 ||
                        _this.keysLeft.indexOf(evt.keyCode) !== -1 ||
                        _this.keysRight.indexOf(evt.keyCode) !== -1) {
                        var index = _this._keys.indexOf(evt.keyCode);
                        if (index === -1) {
                            _this._keys.push(evt.keyCode);
                        }
                        if (!noPreventDefault) {
                            evt.preventDefault();
                        }
                    }
                }
                else {
                    if (_this.keysUp.indexOf(evt.keyCode) !== -1 ||
                        _this.keysDown.indexOf(evt.keyCode) !== -1 ||
                        _this.keysLeft.indexOf(evt.keyCode) !== -1 ||
                        _this.keysRight.indexOf(evt.keyCode) !== -1) {
                        var index = _this._keys.indexOf(evt.keyCode);
                        if (index >= 0) {
                            _this._keys.splice(index, 1);
                        }
                        if (!noPreventDefault) {
                            evt.preventDefault();
                        }
                    }
                }
            }
        });
    };
    /**
     * Detach the current controls from the specified dom element.
     * @param element Defines the element to stop listening the inputs from
     */
    FreeCameraKeyboardMoveInput.prototype.detachControl = function (element) {
        if (this._scene) {
            if (this._onKeyboardObserver) {
                this._scene.onKeyboardObservable.remove(this._onKeyboardObserver);
            }
            if (this._onCanvasBlurObserver) {
                this._engine.onCanvasBlurObservable.remove(this._onCanvasBlurObserver);
            }
            this._onKeyboardObserver = null;
            this._onCanvasBlurObserver = null;
        }
        this._keys = [];
    };
    /**
     * Update the current camera state depending on the inputs that have been used this frame.
     * This is a dynamically created lambda to avoid the performance penalty of looping for inputs in the render loop.
     */
    FreeCameraKeyboardMoveInput.prototype.checkInputs = function () {
        if (this._onKeyboardObserver) {
            var camera = this.camera;
            // Keyboard
            for (var index = 0; index < this._keys.length; index++) {
                var keyCode = this._keys[index];
                var speed = camera._computeLocalCameraSpeed();
                if (this.keysLeft.indexOf(keyCode) !== -1) {
                    camera._localDirection.copyFromFloats(-speed, 0, 0);
                }
                else if (this.keysUp.indexOf(keyCode) !== -1) {
                    camera._localDirection.copyFromFloats(0, 0, speed);
                }
                else if (this.keysRight.indexOf(keyCode) !== -1) {
                    camera._localDirection.copyFromFloats(speed, 0, 0);
                }
                else if (this.keysDown.indexOf(keyCode) !== -1) {
                    camera._localDirection.copyFromFloats(0, 0, -speed);
                }
                if (camera.getScene().useRightHandedSystem) {
                    camera._localDirection.z *= -1;
                }
                camera.getViewMatrix().invertToRef(camera._cameraTransformMatrix);
                _Maths_math_vector__WEBPACK_IMPORTED_MODULE_3__.Vector3.TransformNormalToRef(camera._localDirection, camera._cameraTransformMatrix, camera._transformedDirection);
                camera.cameraDirection.addInPlace(camera._transformedDirection);
            }
        }
    };
    /**
     * Gets the class name of the current intput.
     * @returns the class name
     */
    FreeCameraKeyboardMoveInput.prototype.getClassName = function () {
        return "FreeCameraKeyboardMoveInput";
    };
    /** @hidden */
    FreeCameraKeyboardMoveInput.prototype._onLostFocus = function () {
        this._keys = [];
    };
    /**
     * Get the friendly name associated with the input class.
     * @returns the input friendly name
     */
    FreeCameraKeyboardMoveInput.prototype.getSimpleName = function () {
        return "keyboard";
    };
    (0,tslib__WEBPACK_IMPORTED_MODULE_4__.__decorate)([
        (0,_Misc_decorators__WEBPACK_IMPORTED_MODULE_0__.serialize)()
    ], FreeCameraKeyboardMoveInput.prototype, "keysUp", void 0);
    (0,tslib__WEBPACK_IMPORTED_MODULE_4__.__decorate)([
        (0,_Misc_decorators__WEBPACK_IMPORTED_MODULE_0__.serialize)()
    ], FreeCameraKeyboardMoveInput.prototype, "keysDown", void 0);
    (0,tslib__WEBPACK_IMPORTED_MODULE_4__.__decorate)([
        (0,_Misc_decorators__WEBPACK_IMPORTED_MODULE_0__.serialize)()
    ], FreeCameraKeyboardMoveInput.prototype, "keysLeft", void 0);
    (0,tslib__WEBPACK_IMPORTED_MODULE_4__.__decorate)([
        (0,_Misc_decorators__WEBPACK_IMPORTED_MODULE_0__.serialize)()
    ], FreeCameraKeyboardMoveInput.prototype, "keysRight", void 0);
    return FreeCameraKeyboardMoveInput;
}());

_Cameras_cameraInputsManager__WEBPACK_IMPORTED_MODULE_1__.CameraInputTypes.FreeCameraKeyboardMoveInput = FreeCameraKeyboardMoveInput;
//# sourceMappingURL=freeCameraKeyboardMoveInput.js.map

/***/ }),

/***/ "./node_modules/@babylonjs/core/Cameras/Inputs/freeCameraMouseInput.js":
/*!*****************************************************************************!*\
  !*** ./node_modules/@babylonjs/core/Cameras/Inputs/freeCameraMouseInput.js ***!
  \*****************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "FreeCameraMouseInput": () => (/* binding */ FreeCameraMouseInput)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _Misc_observable__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../Misc/observable */ "./node_modules/@babylonjs/core/Misc/observable.js");
/* harmony import */ var _Misc_decorators__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../Misc/decorators */ "./node_modules/@babylonjs/core/Misc/decorators.js");
/* harmony import */ var _Cameras_cameraInputsManager__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../Cameras/cameraInputsManager */ "./node_modules/@babylonjs/core/Cameras/cameraInputsManager.js");
/* harmony import */ var _Events_pointerEvents__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../Events/pointerEvents */ "./node_modules/@babylonjs/core/Events/pointerEvents.js");





/**
 * Manage the mouse inputs to control the movement of a free camera.
 * @see http://doc.babylonjs.com/how_to/customizing_camera_inputs
 */
var FreeCameraMouseInput = /** @class */ (function () {
    /**
     * Manage the mouse inputs to control the movement of a free camera.
     * @see http://doc.babylonjs.com/how_to/customizing_camera_inputs
     * @param touchEnabled Defines if touch is enabled or not
     */
    function FreeCameraMouseInput(
    /**
     * Define if touch is enabled in the mouse input
     */
    touchEnabled) {
        if (touchEnabled === void 0) { touchEnabled = true; }
        this.touchEnabled = touchEnabled;
        /**
         * Defines the buttons associated with the input to handle camera move.
         */
        this.buttons = [0, 1, 2];
        /**
         * Defines the pointer angular sensibility  along the X and Y axis or how fast is the camera rotating.
         */
        this.angularSensibility = 2000.0;
        this.previousPosition = null;
        /**
         * Observable for when a pointer move event occurs containing the move offset
         */
        this.onPointerMovedObservable = new _Misc_observable__WEBPACK_IMPORTED_MODULE_0__.Observable();
        /**
         * @hidden
         * If the camera should be rotated automatically based on pointer movement
         */
        this._allowCameraRotation = true;
    }
    /**
     * Attach the input controls to a specific dom element to get the input from.
     * @param element Defines the element the controls should be listened from
     * @param noPreventDefault Defines whether event caught by the controls should call preventdefault() (https://developer.mozilla.org/en-US/docs/Web/API/Event/preventDefault)
     */
    FreeCameraMouseInput.prototype.attachControl = function (element, noPreventDefault) {
        var _this = this;
        var engine = this.camera.getEngine();
        if (!this._pointerInput) {
            this._pointerInput = function (p) {
                var evt = p.event;
                if (engine.isInVRExclusivePointerMode) {
                    return;
                }
                if (!_this.touchEnabled && evt.pointerType === "touch") {
                    return;
                }
                if (p.type !== _Events_pointerEvents__WEBPACK_IMPORTED_MODULE_3__.PointerEventTypes.POINTERMOVE && _this.buttons.indexOf(evt.button) === -1) {
                    return;
                }
                var srcElement = (evt.srcElement || evt.target);
                if (p.type === _Events_pointerEvents__WEBPACK_IMPORTED_MODULE_3__.PointerEventTypes.POINTERDOWN && srcElement) {
                    try {
                        srcElement.setPointerCapture(evt.pointerId);
                    }
                    catch (e) {
                        //Nothing to do with the error. Execution will continue.
                    }
                    _this.previousPosition = {
                        x: evt.clientX,
                        y: evt.clientY
                    };
                    if (!noPreventDefault) {
                        evt.preventDefault();
                        element.focus();
                    }
                }
                else if (p.type === _Events_pointerEvents__WEBPACK_IMPORTED_MODULE_3__.PointerEventTypes.POINTERUP && srcElement) {
                    try {
                        srcElement.releasePointerCapture(evt.pointerId);
                    }
                    catch (e) {
                        //Nothing to do with the error.
                    }
                    _this.previousPosition = null;
                    if (!noPreventDefault) {
                        evt.preventDefault();
                    }
                }
                else if (p.type === _Events_pointerEvents__WEBPACK_IMPORTED_MODULE_3__.PointerEventTypes.POINTERMOVE) {
                    if (!_this.previousPosition || engine.isPointerLock) {
                        return;
                    }
                    var offsetX = evt.clientX - _this.previousPosition.x;
                    var offsetY = evt.clientY - _this.previousPosition.y;
                    if (_this.camera.getScene().useRightHandedSystem) {
                        offsetX *= -1;
                    }
                    if (_this.camera.parent && _this.camera.parent._getWorldMatrixDeterminant() < 0) {
                        offsetX *= -1;
                    }
                    if (_this._allowCameraRotation) {
                        _this.camera.cameraRotation.y += offsetX / _this.angularSensibility;
                        _this.camera.cameraRotation.x += offsetY / _this.angularSensibility;
                    }
                    _this.onPointerMovedObservable.notifyObservers({ offsetX: offsetX, offsetY: offsetY });
                    _this.previousPosition = {
                        x: evt.clientX,
                        y: evt.clientY
                    };
                    if (!noPreventDefault) {
                        evt.preventDefault();
                    }
                }
            };
        }
        this._onMouseMove = function (evt) {
            if (!engine.isPointerLock) {
                return;
            }
            if (engine.isInVRExclusivePointerMode) {
                return;
            }
            var offsetX = evt.movementX || evt.mozMovementX || evt.webkitMovementX || evt.msMovementX || 0;
            if (_this.camera.getScene().useRightHandedSystem) {
                offsetX *= -1;
            }
            if (_this.camera.parent && _this.camera.parent._getWorldMatrixDeterminant() < 0) {
                offsetX *= -1;
            }
            _this.camera.cameraRotation.y += offsetX / _this.angularSensibility;
            var offsetY = evt.movementY || evt.mozMovementY || evt.webkitMovementY || evt.msMovementY || 0;
            _this.camera.cameraRotation.x += offsetY / _this.angularSensibility;
            _this.previousPosition = null;
            if (!noPreventDefault) {
                evt.preventDefault();
            }
        };
        this._observer = this.camera.getScene().onPointerObservable.add(this._pointerInput, _Events_pointerEvents__WEBPACK_IMPORTED_MODULE_3__.PointerEventTypes.POINTERDOWN | _Events_pointerEvents__WEBPACK_IMPORTED_MODULE_3__.PointerEventTypes.POINTERUP | _Events_pointerEvents__WEBPACK_IMPORTED_MODULE_3__.PointerEventTypes.POINTERMOVE);
        element.addEventListener("mousemove", this._onMouseMove, false);
        element.addEventListener("contextmenu", this.onContextMenu.bind(this), false);
    };
    /**
     * Called on JS contextmenu event.
     * Override this method to provide functionality.
     */
    FreeCameraMouseInput.prototype.onContextMenu = function (evt) {
        evt.preventDefault();
    };
    /**
     * Detach the current controls from the specified dom element.
     * @param element Defines the element to stop listening the inputs from
     */
    FreeCameraMouseInput.prototype.detachControl = function (element) {
        if (this._observer && element) {
            this.camera.getScene().onPointerObservable.remove(this._observer);
            if (this._onMouseMove) {
                element.removeEventListener("mousemove", this._onMouseMove);
            }
            if (this.onContextMenu) {
                element.removeEventListener("contextmenu", this.onContextMenu);
            }
            if (this.onPointerMovedObservable) {
                this.onPointerMovedObservable.clear();
            }
            this._observer = null;
            this._onMouseMove = null;
            this.previousPosition = null;
        }
    };
    /**
     * Gets the class name of the current intput.
     * @returns the class name
     */
    FreeCameraMouseInput.prototype.getClassName = function () {
        return "FreeCameraMouseInput";
    };
    /**
     * Get the friendly name associated with the input class.
     * @returns the input friendly name
     */
    FreeCameraMouseInput.prototype.getSimpleName = function () {
        return "mouse";
    };
    (0,tslib__WEBPACK_IMPORTED_MODULE_4__.__decorate)([
        (0,_Misc_decorators__WEBPACK_IMPORTED_MODULE_1__.serialize)()
    ], FreeCameraMouseInput.prototype, "buttons", void 0);
    (0,tslib__WEBPACK_IMPORTED_MODULE_4__.__decorate)([
        (0,_Misc_decorators__WEBPACK_IMPORTED_MODULE_1__.serialize)()
    ], FreeCameraMouseInput.prototype, "angularSensibility", void 0);
    return FreeCameraMouseInput;
}());

_Cameras_cameraInputsManager__WEBPACK_IMPORTED_MODULE_2__.CameraInputTypes.FreeCameraMouseInput = FreeCameraMouseInput;
//# sourceMappingURL=freeCameraMouseInput.js.map

/***/ }),

/***/ "./node_modules/@babylonjs/core/Cameras/Inputs/freeCameraTouchInput.js":
/*!*****************************************************************************!*\
  !*** ./node_modules/@babylonjs/core/Cameras/Inputs/freeCameraTouchInput.js ***!
  \*****************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "FreeCameraTouchInput": () => (/* binding */ FreeCameraTouchInput)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _Misc_decorators__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../Misc/decorators */ "./node_modules/@babylonjs/core/Misc/decorators.js");
/* harmony import */ var _Cameras_cameraInputsManager__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../Cameras/cameraInputsManager */ "./node_modules/@babylonjs/core/Cameras/cameraInputsManager.js");
/* harmony import */ var _Events_pointerEvents__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../Events/pointerEvents */ "./node_modules/@babylonjs/core/Events/pointerEvents.js");
/* harmony import */ var _Maths_math_vector__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../Maths/math.vector */ "./node_modules/@babylonjs/core/Maths/math.vector.js");





/**
 * Manage the touch inputs to control the movement of a free camera.
 * @see http://doc.babylonjs.com/how_to/customizing_camera_inputs
 */
var FreeCameraTouchInput = /** @class */ (function () {
    function FreeCameraTouchInput() {
        /**
         * Defines the touch sensibility for rotation.
         * The higher the faster.
         */
        this.touchAngularSensibility = 200000.0;
        /**
         * Defines the touch sensibility for move.
         * The higher the faster.
         */
        this.touchMoveSensibility = 250.0;
        this._offsetX = null;
        this._offsetY = null;
        this._pointerPressed = new Array();
    }
    /**
     * Attach the input controls to a specific dom element to get the input from.
     * @param element Defines the element the controls should be listened from
     * @param noPreventDefault Defines whether event caught by the controls should call preventdefault() (https://developer.mozilla.org/en-US/docs/Web/API/Event/preventDefault)
     */
    FreeCameraTouchInput.prototype.attachControl = function (element, noPreventDefault) {
        var _this = this;
        var previousPosition = null;
        if (this._pointerInput === undefined) {
            this._onLostFocus = function () {
                _this._offsetX = null;
                _this._offsetY = null;
            };
            this._pointerInput = function (p) {
                var evt = p.event;
                if (evt.pointerType === "mouse") {
                    return;
                }
                if (p.type === _Events_pointerEvents__WEBPACK_IMPORTED_MODULE_2__.PointerEventTypes.POINTERDOWN) {
                    if (!noPreventDefault) {
                        evt.preventDefault();
                    }
                    _this._pointerPressed.push(evt.pointerId);
                    if (_this._pointerPressed.length !== 1) {
                        return;
                    }
                    previousPosition = {
                        x: evt.clientX,
                        y: evt.clientY
                    };
                }
                else if (p.type === _Events_pointerEvents__WEBPACK_IMPORTED_MODULE_2__.PointerEventTypes.POINTERUP) {
                    if (!noPreventDefault) {
                        evt.preventDefault();
                    }
                    var index = _this._pointerPressed.indexOf(evt.pointerId);
                    if (index === -1) {
                        return;
                    }
                    _this._pointerPressed.splice(index, 1);
                    if (index != 0) {
                        return;
                    }
                    previousPosition = null;
                    _this._offsetX = null;
                    _this._offsetY = null;
                }
                else if (p.type === _Events_pointerEvents__WEBPACK_IMPORTED_MODULE_2__.PointerEventTypes.POINTERMOVE) {
                    if (!noPreventDefault) {
                        evt.preventDefault();
                    }
                    if (!previousPosition) {
                        return;
                    }
                    var index = _this._pointerPressed.indexOf(evt.pointerId);
                    if (index != 0) {
                        return;
                    }
                    _this._offsetX = evt.clientX - previousPosition.x;
                    _this._offsetY = -(evt.clientY - previousPosition.y);
                }
            };
        }
        this._observer = this.camera.getScene().onPointerObservable.add(this._pointerInput, _Events_pointerEvents__WEBPACK_IMPORTED_MODULE_2__.PointerEventTypes.POINTERDOWN | _Events_pointerEvents__WEBPACK_IMPORTED_MODULE_2__.PointerEventTypes.POINTERUP | _Events_pointerEvents__WEBPACK_IMPORTED_MODULE_2__.PointerEventTypes.POINTERMOVE);
        if (this._onLostFocus) {
            element.addEventListener("blur", this._onLostFocus);
        }
    };
    /**
     * Detach the current controls from the specified dom element.
     * @param element Defines the element to stop listening the inputs from
     */
    FreeCameraTouchInput.prototype.detachControl = function (element) {
        if (this._pointerInput && element) {
            if (this._observer) {
                this.camera.getScene().onPointerObservable.remove(this._observer);
                this._observer = null;
            }
            if (this._onLostFocus) {
                element.removeEventListener("blur", this._onLostFocus);
                this._onLostFocus = null;
            }
            this._pointerPressed = [];
            this._offsetX = null;
            this._offsetY = null;
        }
    };
    /**
     * Update the current camera state depending on the inputs that have been used this frame.
     * This is a dynamically created lambda to avoid the performance penalty of looping for inputs in the render loop.
     */
    FreeCameraTouchInput.prototype.checkInputs = function () {
        if (this._offsetX && this._offsetY) {
            var camera = this.camera;
            camera.cameraRotation.y += this._offsetX / this.touchAngularSensibility;
            if (this._pointerPressed.length > 1) {
                camera.cameraRotation.x += -this._offsetY / this.touchAngularSensibility;
            }
            else {
                var speed = camera._computeLocalCameraSpeed();
                var direction = new _Maths_math_vector__WEBPACK_IMPORTED_MODULE_3__.Vector3(0, 0, speed * this._offsetY / this.touchMoveSensibility);
                _Maths_math_vector__WEBPACK_IMPORTED_MODULE_3__.Matrix.RotationYawPitchRollToRef(camera.rotation.y, camera.rotation.x, 0, camera._cameraRotationMatrix);
                camera.cameraDirection.addInPlace(_Maths_math_vector__WEBPACK_IMPORTED_MODULE_3__.Vector3.TransformCoordinates(direction, camera._cameraRotationMatrix));
            }
        }
    };
    /**
     * Gets the class name of the current intput.
     * @returns the class name
     */
    FreeCameraTouchInput.prototype.getClassName = function () {
        return "FreeCameraTouchInput";
    };
    /**
     * Get the friendly name associated with the input class.
     * @returns the input friendly name
     */
    FreeCameraTouchInput.prototype.getSimpleName = function () {
        return "touch";
    };
    (0,tslib__WEBPACK_IMPORTED_MODULE_4__.__decorate)([
        (0,_Misc_decorators__WEBPACK_IMPORTED_MODULE_0__.serialize)()
    ], FreeCameraTouchInput.prototype, "touchAngularSensibility", void 0);
    (0,tslib__WEBPACK_IMPORTED_MODULE_4__.__decorate)([
        (0,_Misc_decorators__WEBPACK_IMPORTED_MODULE_0__.serialize)()
    ], FreeCameraTouchInput.prototype, "touchMoveSensibility", void 0);
    return FreeCameraTouchInput;
}());

_Cameras_cameraInputsManager__WEBPACK_IMPORTED_MODULE_1__.CameraInputTypes.FreeCameraTouchInput = FreeCameraTouchInput;
//# sourceMappingURL=freeCameraTouchInput.js.map

/***/ }),

/***/ "./node_modules/@babylonjs/core/Cameras/Inputs/freeCameraVirtualJoystickInput.js":
/*!***************************************************************************************!*\
  !*** ./node_modules/@babylonjs/core/Cameras/Inputs/freeCameraVirtualJoystickInput.js ***!
  \***************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "FreeCameraVirtualJoystickInput": () => (/* binding */ FreeCameraVirtualJoystickInput)
/* harmony export */ });
/* harmony import */ var _Misc_virtualJoystick__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../Misc/virtualJoystick */ "./node_modules/@babylonjs/core/Misc/virtualJoystick.js");
/* harmony import */ var _Cameras_cameraInputsManager__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../Cameras/cameraInputsManager */ "./node_modules/@babylonjs/core/Cameras/cameraInputsManager.js");
/* harmony import */ var _Maths_math_vector__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../Maths/math.vector */ "./node_modules/@babylonjs/core/Maths/math.vector.js");
/* harmony import */ var _Cameras_freeCameraInputsManager__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../Cameras/freeCameraInputsManager */ "./node_modules/@babylonjs/core/Cameras/freeCameraInputsManager.js");




/**
* Add virtual joystick input support to the input manager.
* @returns the current input manager
*/
_Cameras_freeCameraInputsManager__WEBPACK_IMPORTED_MODULE_3__.FreeCameraInputsManager.prototype.addVirtualJoystick = function () {
    this.add(new FreeCameraVirtualJoystickInput());
    return this;
};
/**
 * Manage the Virtual Joystick inputs to control the movement of a free camera.
 * @see http://doc.babylonjs.com/how_to/customizing_camera_inputs
 */
var FreeCameraVirtualJoystickInput = /** @class */ (function () {
    function FreeCameraVirtualJoystickInput() {
    }
    /**
     * Gets the left stick of the virtual joystick.
     * @returns The virtual Joystick
     */
    FreeCameraVirtualJoystickInput.prototype.getLeftJoystick = function () {
        return this._leftjoystick;
    };
    /**
     * Gets the right stick of the virtual joystick.
     * @returns The virtual Joystick
     */
    FreeCameraVirtualJoystickInput.prototype.getRightJoystick = function () {
        return this._rightjoystick;
    };
    /**
     * Update the current camera state depending on the inputs that have been used this frame.
     * This is a dynamically created lambda to avoid the performance penalty of looping for inputs in the render loop.
     */
    FreeCameraVirtualJoystickInput.prototype.checkInputs = function () {
        if (this._leftjoystick) {
            var camera = this.camera;
            var speed = camera._computeLocalCameraSpeed() * 50;
            var cameraTransform = _Maths_math_vector__WEBPACK_IMPORTED_MODULE_2__.Matrix.RotationYawPitchRoll(camera.rotation.y, camera.rotation.x, 0);
            var deltaTransform = _Maths_math_vector__WEBPACK_IMPORTED_MODULE_2__.Vector3.TransformCoordinates(new _Maths_math_vector__WEBPACK_IMPORTED_MODULE_2__.Vector3(this._leftjoystick.deltaPosition.x * speed, this._leftjoystick.deltaPosition.y * speed, this._leftjoystick.deltaPosition.z * speed), cameraTransform);
            camera.cameraDirection = camera.cameraDirection.add(deltaTransform);
            camera.cameraRotation = camera.cameraRotation.addVector3(this._rightjoystick.deltaPosition);
            if (!this._leftjoystick.pressed) {
                this._leftjoystick.deltaPosition = this._leftjoystick.deltaPosition.scale(0.9);
            }
            if (!this._rightjoystick.pressed) {
                this._rightjoystick.deltaPosition = this._rightjoystick.deltaPosition.scale(0.9);
            }
        }
    };
    /**
     * Attach the input controls to a specific dom element to get the input from.
     * @param element Defines the element the controls should be listened from
     * @param noPreventDefault Defines whether event caught by the controls should call preventdefault() (https://developer.mozilla.org/en-US/docs/Web/API/Event/preventDefault)
     */
    FreeCameraVirtualJoystickInput.prototype.attachControl = function (element, noPreventDefault) {
        this._leftjoystick = new _Misc_virtualJoystick__WEBPACK_IMPORTED_MODULE_0__.VirtualJoystick(true);
        this._leftjoystick.setAxisForUpDown(_Misc_virtualJoystick__WEBPACK_IMPORTED_MODULE_0__.JoystickAxis.Z);
        this._leftjoystick.setAxisForLeftRight(_Misc_virtualJoystick__WEBPACK_IMPORTED_MODULE_0__.JoystickAxis.X);
        this._leftjoystick.setJoystickSensibility(0.15);
        this._rightjoystick = new _Misc_virtualJoystick__WEBPACK_IMPORTED_MODULE_0__.VirtualJoystick(false);
        this._rightjoystick.setAxisForUpDown(_Misc_virtualJoystick__WEBPACK_IMPORTED_MODULE_0__.JoystickAxis.X);
        this._rightjoystick.setAxisForLeftRight(_Misc_virtualJoystick__WEBPACK_IMPORTED_MODULE_0__.JoystickAxis.Y);
        this._rightjoystick.reverseUpDown = true;
        this._rightjoystick.setJoystickSensibility(0.05);
        this._rightjoystick.setJoystickColor("yellow");
    };
    /**
     * Detach the current controls from the specified dom element.
     * @param element Defines the element to stop listening the inputs from
     */
    FreeCameraVirtualJoystickInput.prototype.detachControl = function (element) {
        this._leftjoystick.releaseCanvas();
        this._rightjoystick.releaseCanvas();
    };
    /**
     * Gets the class name of the current intput.
     * @returns the class name
     */
    FreeCameraVirtualJoystickInput.prototype.getClassName = function () {
        return "FreeCameraVirtualJoystickInput";
    };
    /**
     * Get the friendly name associated with the input class.
     * @returns the input friendly name
     */
    FreeCameraVirtualJoystickInput.prototype.getSimpleName = function () {
        return "virtualJoystick";
    };
    return FreeCameraVirtualJoystickInput;
}());

_Cameras_cameraInputsManager__WEBPACK_IMPORTED_MODULE_1__.CameraInputTypes.FreeCameraVirtualJoystickInput = FreeCameraVirtualJoystickInput;
//# sourceMappingURL=freeCameraVirtualJoystickInput.js.map

/***/ }),

/***/ "./node_modules/@babylonjs/core/Cameras/Inputs/index.js":
/*!**************************************************************!*\
  !*** ./node_modules/@babylonjs/core/Cameras/Inputs/index.js ***!
  \**************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ArcRotateCameraGamepadInput": () => (/* reexport safe */ _arcRotateCameraGamepadInput__WEBPACK_IMPORTED_MODULE_0__.ArcRotateCameraGamepadInput),
/* harmony export */   "ArcRotateCameraKeyboardMoveInput": () => (/* reexport safe */ _arcRotateCameraKeyboardMoveInput__WEBPACK_IMPORTED_MODULE_1__.ArcRotateCameraKeyboardMoveInput),
/* harmony export */   "ArcRotateCameraMouseWheelInput": () => (/* reexport safe */ _arcRotateCameraMouseWheelInput__WEBPACK_IMPORTED_MODULE_2__.ArcRotateCameraMouseWheelInput),
/* harmony export */   "ArcRotateCameraPointersInput": () => (/* reexport safe */ _arcRotateCameraPointersInput__WEBPACK_IMPORTED_MODULE_3__.ArcRotateCameraPointersInput),
/* harmony export */   "ArcRotateCameraVRDeviceOrientationInput": () => (/* reexport safe */ _arcRotateCameraVRDeviceOrientationInput__WEBPACK_IMPORTED_MODULE_4__.ArcRotateCameraVRDeviceOrientationInput),
/* harmony export */   "FlyCameraKeyboardInput": () => (/* reexport safe */ _flyCameraKeyboardInput__WEBPACK_IMPORTED_MODULE_5__.FlyCameraKeyboardInput),
/* harmony export */   "FlyCameraMouseInput": () => (/* reexport safe */ _flyCameraMouseInput__WEBPACK_IMPORTED_MODULE_6__.FlyCameraMouseInput),
/* harmony export */   "FollowCameraKeyboardMoveInput": () => (/* reexport safe */ _followCameraKeyboardMoveInput__WEBPACK_IMPORTED_MODULE_7__.FollowCameraKeyboardMoveInput),
/* harmony export */   "FollowCameraMouseWheelInput": () => (/* reexport safe */ _followCameraMouseWheelInput__WEBPACK_IMPORTED_MODULE_8__.FollowCameraMouseWheelInput),
/* harmony export */   "FollowCameraPointersInput": () => (/* reexport safe */ _followCameraPointersInput__WEBPACK_IMPORTED_MODULE_9__.FollowCameraPointersInput),
/* harmony export */   "FreeCameraDeviceOrientationInput": () => (/* reexport safe */ _freeCameraDeviceOrientationInput__WEBPACK_IMPORTED_MODULE_10__.FreeCameraDeviceOrientationInput),
/* harmony export */   "FreeCameraGamepadInput": () => (/* reexport safe */ _freeCameraGamepadInput__WEBPACK_IMPORTED_MODULE_11__.FreeCameraGamepadInput),
/* harmony export */   "FreeCameraKeyboardMoveInput": () => (/* reexport safe */ _freeCameraKeyboardMoveInput__WEBPACK_IMPORTED_MODULE_12__.FreeCameraKeyboardMoveInput),
/* harmony export */   "FreeCameraMouseInput": () => (/* reexport safe */ _freeCameraMouseInput__WEBPACK_IMPORTED_MODULE_13__.FreeCameraMouseInput),
/* harmony export */   "FreeCameraTouchInput": () => (/* reexport safe */ _freeCameraTouchInput__WEBPACK_IMPORTED_MODULE_14__.FreeCameraTouchInput),
/* harmony export */   "FreeCameraVirtualJoystickInput": () => (/* reexport safe */ _freeCameraVirtualJoystickInput__WEBPACK_IMPORTED_MODULE_15__.FreeCameraVirtualJoystickInput)
/* harmony export */ });
/* harmony import */ var _arcRotateCameraGamepadInput__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./arcRotateCameraGamepadInput */ "./node_modules/@babylonjs/core/Cameras/Inputs/arcRotateCameraGamepadInput.js");
/* harmony import */ var _arcRotateCameraKeyboardMoveInput__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./arcRotateCameraKeyboardMoveInput */ "./node_modules/@babylonjs/core/Cameras/Inputs/arcRotateCameraKeyboardMoveInput.js");
/* harmony import */ var _arcRotateCameraMouseWheelInput__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./arcRotateCameraMouseWheelInput */ "./node_modules/@babylonjs/core/Cameras/Inputs/arcRotateCameraMouseWheelInput.js");
/* harmony import */ var _arcRotateCameraPointersInput__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./arcRotateCameraPointersInput */ "./node_modules/@babylonjs/core/Cameras/Inputs/arcRotateCameraPointersInput.js");
/* harmony import */ var _arcRotateCameraVRDeviceOrientationInput__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./arcRotateCameraVRDeviceOrientationInput */ "./node_modules/@babylonjs/core/Cameras/Inputs/arcRotateCameraVRDeviceOrientationInput.js");
/* harmony import */ var _flyCameraKeyboardInput__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./flyCameraKeyboardInput */ "./node_modules/@babylonjs/core/Cameras/Inputs/flyCameraKeyboardInput.js");
/* harmony import */ var _flyCameraMouseInput__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./flyCameraMouseInput */ "./node_modules/@babylonjs/core/Cameras/Inputs/flyCameraMouseInput.js");
/* harmony import */ var _followCameraKeyboardMoveInput__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./followCameraKeyboardMoveInput */ "./node_modules/@babylonjs/core/Cameras/Inputs/followCameraKeyboardMoveInput.js");
/* harmony import */ var _followCameraMouseWheelInput__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./followCameraMouseWheelInput */ "./node_modules/@babylonjs/core/Cameras/Inputs/followCameraMouseWheelInput.js");
/* harmony import */ var _followCameraPointersInput__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./followCameraPointersInput */ "./node_modules/@babylonjs/core/Cameras/Inputs/followCameraPointersInput.js");
/* harmony import */ var _freeCameraDeviceOrientationInput__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./freeCameraDeviceOrientationInput */ "./node_modules/@babylonjs/core/Cameras/Inputs/freeCameraDeviceOrientationInput.js");
/* harmony import */ var _freeCameraGamepadInput__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./freeCameraGamepadInput */ "./node_modules/@babylonjs/core/Cameras/Inputs/freeCameraGamepadInput.js");
/* harmony import */ var _freeCameraKeyboardMoveInput__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./freeCameraKeyboardMoveInput */ "./node_modules/@babylonjs/core/Cameras/Inputs/freeCameraKeyboardMoveInput.js");
/* harmony import */ var _freeCameraMouseInput__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ./freeCameraMouseInput */ "./node_modules/@babylonjs/core/Cameras/Inputs/freeCameraMouseInput.js");
/* harmony import */ var _freeCameraTouchInput__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ./freeCameraTouchInput */ "./node_modules/@babylonjs/core/Cameras/Inputs/freeCameraTouchInput.js");
/* harmony import */ var _freeCameraVirtualJoystickInput__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ./freeCameraVirtualJoystickInput */ "./node_modules/@babylonjs/core/Cameras/Inputs/freeCameraVirtualJoystickInput.js");
















//# sourceMappingURL=index.js.map

/***/ }),

/***/ "./node_modules/@babylonjs/core/Cameras/RigModes/stereoscopicAnaglyphRigMode.js":
/*!**************************************************************************************!*\
  !*** ./node_modules/@babylonjs/core/Cameras/RigModes/stereoscopicAnaglyphRigMode.js ***!
  \**************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _camera__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../camera */ "./node_modules/@babylonjs/core/Cameras/camera.js");
/* harmony import */ var _PostProcesses_passPostProcess__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../PostProcesses/passPostProcess */ "./node_modules/@babylonjs/core/PostProcesses/passPostProcess.js");
/* harmony import */ var _PostProcesses_anaglyphPostProcess__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../PostProcesses/anaglyphPostProcess */ "./node_modules/@babylonjs/core/PostProcesses/anaglyphPostProcess.js");



_camera__WEBPACK_IMPORTED_MODULE_0__.Camera._setStereoscopicAnaglyphRigMode = function (camera) {
    camera._rigCameras[0]._rigPostProcess = new _PostProcesses_passPostProcess__WEBPACK_IMPORTED_MODULE_1__.PassPostProcess(camera.name + "_passthru", 1.0, camera._rigCameras[0]);
    camera._rigCameras[1]._rigPostProcess = new _PostProcesses_anaglyphPostProcess__WEBPACK_IMPORTED_MODULE_2__.AnaglyphPostProcess(camera.name + "_anaglyph", 1.0, camera._rigCameras);
};
//# sourceMappingURL=stereoscopicAnaglyphRigMode.js.map

/***/ }),

/***/ "./node_modules/@babylonjs/core/Cameras/RigModes/stereoscopicRigMode.js":
/*!******************************************************************************!*\
  !*** ./node_modules/@babylonjs/core/Cameras/RigModes/stereoscopicRigMode.js ***!
  \******************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _camera__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../camera */ "./node_modules/@babylonjs/core/Cameras/camera.js");
/* harmony import */ var _PostProcesses_passPostProcess__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../PostProcesses/passPostProcess */ "./node_modules/@babylonjs/core/PostProcesses/passPostProcess.js");
/* harmony import */ var _PostProcesses_stereoscopicInterlacePostProcess__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../PostProcesses/stereoscopicInterlacePostProcess */ "./node_modules/@babylonjs/core/PostProcesses/stereoscopicInterlacePostProcess.js");



_camera__WEBPACK_IMPORTED_MODULE_0__.Camera._setStereoscopicRigMode = function (camera) {
    var isStereoscopicHoriz = camera.cameraRigMode === _camera__WEBPACK_IMPORTED_MODULE_0__.Camera.RIG_MODE_STEREOSCOPIC_SIDEBYSIDE_PARALLEL || camera.cameraRigMode === _camera__WEBPACK_IMPORTED_MODULE_0__.Camera.RIG_MODE_STEREOSCOPIC_SIDEBYSIDE_CROSSEYED;
    var isStereoscopicInterlaced = camera.cameraRigMode === _camera__WEBPACK_IMPORTED_MODULE_0__.Camera.RIG_MODE_STEREOSCOPIC_INTERLACED;
    camera._rigCameras[0]._rigPostProcess = new _PostProcesses_passPostProcess__WEBPACK_IMPORTED_MODULE_1__.PassPostProcess(camera.name + "_passthru", 1.0, camera._rigCameras[0]);
    camera._rigCameras[1]._rigPostProcess = new _PostProcesses_stereoscopicInterlacePostProcess__WEBPACK_IMPORTED_MODULE_2__.StereoscopicInterlacePostProcessI(camera.name + "_stereoInterlace", camera._rigCameras, isStereoscopicHoriz, isStereoscopicInterlaced);
};
//# sourceMappingURL=stereoscopicRigMode.js.map

/***/ }),

/***/ "./node_modules/@babylonjs/core/Cameras/RigModes/vrRigMode.js":
/*!********************************************************************!*\
  !*** ./node_modules/@babylonjs/core/Cameras/RigModes/vrRigMode.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _camera__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../camera */ "./node_modules/@babylonjs/core/Cameras/camera.js");
/* harmony import */ var _Maths_math_vector__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../Maths/math.vector */ "./node_modules/@babylonjs/core/Maths/math.vector.js");
/* harmony import */ var _PostProcesses_vrDistortionCorrectionPostProcess__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../PostProcesses/vrDistortionCorrectionPostProcess */ "./node_modules/@babylonjs/core/PostProcesses/vrDistortionCorrectionPostProcess.js");
/* harmony import */ var _PostProcesses_vrMultiviewToSingleviewPostProcess__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../PostProcesses/vrMultiviewToSingleviewPostProcess */ "./node_modules/@babylonjs/core/PostProcesses/vrMultiviewToSingleviewPostProcess.js");
/* harmony import */ var _VR_vrCameraMetrics__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../VR/vrCameraMetrics */ "./node_modules/@babylonjs/core/Cameras/VR/vrCameraMetrics.js");
/* harmony import */ var _Misc_logger__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../Misc/logger */ "./node_modules/@babylonjs/core/Misc/logger.js");
/* harmony import */ var _Maths_math_viewport__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../Maths/math.viewport */ "./node_modules/@babylonjs/core/Maths/math.viewport.js");







_camera__WEBPACK_IMPORTED_MODULE_0__.Camera._setVRRigMode = function (camera, rigParams) {
    var metrics = rigParams.vrCameraMetrics || _VR_vrCameraMetrics__WEBPACK_IMPORTED_MODULE_4__.VRCameraMetrics.GetDefault();
    camera._rigCameras[0]._cameraRigParams.vrMetrics = metrics;
    camera._rigCameras[0].viewport = new _Maths_math_viewport__WEBPACK_IMPORTED_MODULE_6__.Viewport(0, 0, 0.5, 1.0);
    camera._rigCameras[0]._cameraRigParams.vrWorkMatrix = new _Maths_math_vector__WEBPACK_IMPORTED_MODULE_1__.Matrix();
    camera._rigCameras[0]._cameraRigParams.vrHMatrix = metrics.leftHMatrix;
    camera._rigCameras[0]._cameraRigParams.vrPreViewMatrix = metrics.leftPreViewMatrix;
    camera._rigCameras[0].getProjectionMatrix = camera._rigCameras[0]._getVRProjectionMatrix;
    camera._rigCameras[1]._cameraRigParams.vrMetrics = metrics;
    camera._rigCameras[1].viewport = new _Maths_math_viewport__WEBPACK_IMPORTED_MODULE_6__.Viewport(0.5, 0, 0.5, 1.0);
    camera._rigCameras[1]._cameraRigParams.vrWorkMatrix = new _Maths_math_vector__WEBPACK_IMPORTED_MODULE_1__.Matrix();
    camera._rigCameras[1]._cameraRigParams.vrHMatrix = metrics.rightHMatrix;
    camera._rigCameras[1]._cameraRigParams.vrPreViewMatrix = metrics.rightPreViewMatrix;
    camera._rigCameras[1].getProjectionMatrix = camera._rigCameras[1]._getVRProjectionMatrix;
    // For multiview on a webVR camera
    // First multiview will be rendered to camera._multiviewTexture
    // Then this postprocess will run on each eye to copy the right texture to each eye
    if (metrics.multiviewEnabled) {
        if (!camera.getScene().getEngine().getCaps().multiview) {
            _Misc_logger__WEBPACK_IMPORTED_MODULE_5__.Logger.Warn("Multiview is not supported, falling back to standard rendering");
            metrics.multiviewEnabled = false;
        }
        else {
            camera._useMultiviewToSingleView = true;
            camera._rigPostProcess = new _PostProcesses_vrMultiviewToSingleviewPostProcess__WEBPACK_IMPORTED_MODULE_3__.VRMultiviewToSingleviewPostProcess("VRMultiviewToSingleview", camera, metrics.postProcessScaleFactor);
        }
    }
    if (metrics.compensateDistortion) {
        camera._rigCameras[0]._rigPostProcess = new _PostProcesses_vrDistortionCorrectionPostProcess__WEBPACK_IMPORTED_MODULE_2__.VRDistortionCorrectionPostProcess("VR_Distort_Compensation_Left", camera._rigCameras[0], false, metrics);
        camera._rigCameras[1]._rigPostProcess = new _PostProcesses_vrDistortionCorrectionPostProcess__WEBPACK_IMPORTED_MODULE_2__.VRDistortionCorrectionPostProcess("VR_Distort_Compensation_Right", camera._rigCameras[1], true, metrics);
    }
};
//# sourceMappingURL=vrRigMode.js.map

/***/ }),

/***/ "./node_modules/@babylonjs/core/Cameras/RigModes/webVRRigMode.js":
/*!***********************************************************************!*\
  !*** ./node_modules/@babylonjs/core/Cameras/RigModes/webVRRigMode.js ***!
  \***********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _camera__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../camera */ "./node_modules/@babylonjs/core/Cameras/camera.js");
/* harmony import */ var _Maths_math_vector__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../Maths/math.vector */ "./node_modules/@babylonjs/core/Maths/math.vector.js");
/* harmony import */ var _Maths_math_viewport__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../Maths/math.viewport */ "./node_modules/@babylonjs/core/Maths/math.viewport.js");



_camera__WEBPACK_IMPORTED_MODULE_0__.Camera._setWebVRRigMode = function (camera, rigParams) {
    if (rigParams.vrDisplay) {
        var leftEye = rigParams.vrDisplay.getEyeParameters('left');
        var rightEye = rigParams.vrDisplay.getEyeParameters('right');
        //Left eye
        camera._rigCameras[0].viewport = new _Maths_math_viewport__WEBPACK_IMPORTED_MODULE_2__.Viewport(0, 0, 0.5, 1.0);
        camera._rigCameras[0].setCameraRigParameter("left", true);
        //leaving this for future reference
        camera._rigCameras[0].setCameraRigParameter("specs", rigParams.specs);
        camera._rigCameras[0].setCameraRigParameter("eyeParameters", leftEye);
        camera._rigCameras[0].setCameraRigParameter("frameData", rigParams.frameData);
        camera._rigCameras[0].setCameraRigParameter("parentCamera", rigParams.parentCamera);
        camera._rigCameras[0]._cameraRigParams.vrWorkMatrix = new _Maths_math_vector__WEBPACK_IMPORTED_MODULE_1__.Matrix();
        camera._rigCameras[0].getProjectionMatrix = camera._getWebVRProjectionMatrix;
        camera._rigCameras[0].parent = camera;
        camera._rigCameras[0]._getViewMatrix = camera._getWebVRViewMatrix;
        //Right eye
        camera._rigCameras[1].viewport = new _Maths_math_viewport__WEBPACK_IMPORTED_MODULE_2__.Viewport(0.5, 0, 0.5, 1.0);
        camera._rigCameras[1].setCameraRigParameter('eyeParameters', rightEye);
        camera._rigCameras[1].setCameraRigParameter("specs", rigParams.specs);
        camera._rigCameras[1].setCameraRigParameter("frameData", rigParams.frameData);
        camera._rigCameras[1].setCameraRigParameter("parentCamera", rigParams.parentCamera);
        camera._rigCameras[1]._cameraRigParams.vrWorkMatrix = new _Maths_math_vector__WEBPACK_IMPORTED_MODULE_1__.Matrix();
        camera._rigCameras[1].getProjectionMatrix = camera._getWebVRProjectionMatrix;
        camera._rigCameras[1].parent = camera;
        camera._rigCameras[1]._getViewMatrix = camera._getWebVRViewMatrix;
    }
};
//# sourceMappingURL=webVRRigMode.js.map

/***/ }),

/***/ "./node_modules/@babylonjs/core/Cameras/Stereoscopic/anaglyphArcRotateCamera.js":
/*!**************************************************************************************!*\
  !*** ./node_modules/@babylonjs/core/Cameras/Stereoscopic/anaglyphArcRotateCamera.js ***!
  \**************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "AnaglyphArcRotateCamera": () => (/* binding */ AnaglyphArcRotateCamera)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _Cameras_camera__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../Cameras/camera */ "./node_modules/@babylonjs/core/Cameras/camera.js");
/* harmony import */ var _Cameras_arcRotateCamera__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../Cameras/arcRotateCamera */ "./node_modules/@babylonjs/core/Cameras/arcRotateCamera.js");
/* harmony import */ var _Maths_math_vector__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../Maths/math.vector */ "./node_modules/@babylonjs/core/Maths/math.vector.js");
/* harmony import */ var _node__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../node */ "./node_modules/@babylonjs/core/node.js");
/* harmony import */ var _RigModes_stereoscopicAnaglyphRigMode__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../RigModes/stereoscopicAnaglyphRigMode */ "./node_modules/@babylonjs/core/Cameras/RigModes/stereoscopicAnaglyphRigMode.js");





// Side effect import to define the stereoscopic mode.

_node__WEBPACK_IMPORTED_MODULE_3__.Node.AddNodeConstructor("AnaglyphArcRotateCamera", function (name, scene, options) {
    return function () { return new AnaglyphArcRotateCamera(name, 0, 0, 1.0, _Maths_math_vector__WEBPACK_IMPORTED_MODULE_2__.Vector3.Zero(), options.interaxial_distance, scene); };
});
/**
 * Camera used to simulate anaglyphic rendering (based on ArcRotateCamera)
 * @see http://doc.babylonjs.com/features/cameras#anaglyph-cameras
 */
var AnaglyphArcRotateCamera = /** @class */ (function (_super) {
    (0,tslib__WEBPACK_IMPORTED_MODULE_5__.__extends)(AnaglyphArcRotateCamera, _super);
    /**
     * Creates a new AnaglyphArcRotateCamera
     * @param name defines camera name
     * @param alpha defines alpha angle (in radians)
     * @param beta defines beta angle (in radians)
     * @param radius defines radius
     * @param target defines camera target
     * @param interaxialDistance defines distance between each color axis
     * @param scene defines the hosting scene
     */
    function AnaglyphArcRotateCamera(name, alpha, beta, radius, target, interaxialDistance, scene) {
        var _this = _super.call(this, name, alpha, beta, radius, target, scene) || this;
        _this.interaxialDistance = interaxialDistance;
        _this.setCameraRigMode(_Cameras_camera__WEBPACK_IMPORTED_MODULE_0__.Camera.RIG_MODE_STEREOSCOPIC_ANAGLYPH, { interaxialDistance: interaxialDistance });
        return _this;
    }
    /**
     * Gets camera class name
     * @returns AnaglyphArcRotateCamera
     */
    AnaglyphArcRotateCamera.prototype.getClassName = function () {
        return "AnaglyphArcRotateCamera";
    };
    return AnaglyphArcRotateCamera;
}(_Cameras_arcRotateCamera__WEBPACK_IMPORTED_MODULE_1__.ArcRotateCamera));

//# sourceMappingURL=anaglyphArcRotateCamera.js.map

/***/ }),

/***/ "./node_modules/@babylonjs/core/Cameras/Stereoscopic/anaglyphFreeCamera.js":
/*!*********************************************************************************!*\
  !*** ./node_modules/@babylonjs/core/Cameras/Stereoscopic/anaglyphFreeCamera.js ***!
  \*********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "AnaglyphFreeCamera": () => (/* binding */ AnaglyphFreeCamera)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _Cameras_camera__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../Cameras/camera */ "./node_modules/@babylonjs/core/Cameras/camera.js");
/* harmony import */ var _Cameras_freeCamera__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../Cameras/freeCamera */ "./node_modules/@babylonjs/core/Cameras/freeCamera.js");
/* harmony import */ var _Maths_math_vector__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../Maths/math.vector */ "./node_modules/@babylonjs/core/Maths/math.vector.js");
/* harmony import */ var _node__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../node */ "./node_modules/@babylonjs/core/node.js");
/* harmony import */ var _RigModes_stereoscopicAnaglyphRigMode__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../RigModes/stereoscopicAnaglyphRigMode */ "./node_modules/@babylonjs/core/Cameras/RigModes/stereoscopicAnaglyphRigMode.js");





// Side effect import to define the stereoscopic mode.

_node__WEBPACK_IMPORTED_MODULE_3__.Node.AddNodeConstructor("AnaglyphFreeCamera", function (name, scene, options) {
    return function () { return new AnaglyphFreeCamera(name, _Maths_math_vector__WEBPACK_IMPORTED_MODULE_2__.Vector3.Zero(), options.interaxial_distance, scene); };
});
/**
 * Camera used to simulate anaglyphic rendering (based on FreeCamera)
 * @see http://doc.babylonjs.com/features/cameras#anaglyph-cameras
 */
var AnaglyphFreeCamera = /** @class */ (function (_super) {
    (0,tslib__WEBPACK_IMPORTED_MODULE_5__.__extends)(AnaglyphFreeCamera, _super);
    /**
     * Creates a new AnaglyphFreeCamera
     * @param name defines camera name
     * @param position defines initial position
     * @param interaxialDistance defines distance between each color axis
     * @param scene defines the hosting scene
     */
    function AnaglyphFreeCamera(name, position, interaxialDistance, scene) {
        var _this = _super.call(this, name, position, scene) || this;
        _this.interaxialDistance = interaxialDistance;
        _this.setCameraRigMode(_Cameras_camera__WEBPACK_IMPORTED_MODULE_0__.Camera.RIG_MODE_STEREOSCOPIC_ANAGLYPH, { interaxialDistance: interaxialDistance });
        return _this;
    }
    /**
     * Gets camera class name
     * @returns AnaglyphFreeCamera
     */
    AnaglyphFreeCamera.prototype.getClassName = function () {
        return "AnaglyphFreeCamera";
    };
    return AnaglyphFreeCamera;
}(_Cameras_freeCamera__WEBPACK_IMPORTED_MODULE_1__.FreeCamera));

//# sourceMappingURL=anaglyphFreeCamera.js.map

/***/ }),

/***/ "./node_modules/@babylonjs/core/Cameras/Stereoscopic/anaglyphGamepadCamera.js":
/*!************************************************************************************!*\
  !*** ./node_modules/@babylonjs/core/Cameras/Stereoscopic/anaglyphGamepadCamera.js ***!
  \************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "AnaglyphGamepadCamera": () => (/* binding */ AnaglyphGamepadCamera)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _Cameras_camera__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../Cameras/camera */ "./node_modules/@babylonjs/core/Cameras/camera.js");
/* harmony import */ var _Cameras_gamepadCamera__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../Cameras/gamepadCamera */ "./node_modules/@babylonjs/core/Cameras/gamepadCamera.js");
/* harmony import */ var _Maths_math_vector__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../Maths/math.vector */ "./node_modules/@babylonjs/core/Maths/math.vector.js");
/* harmony import */ var _node__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../node */ "./node_modules/@babylonjs/core/node.js");
/* harmony import */ var _RigModes_stereoscopicAnaglyphRigMode__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../RigModes/stereoscopicAnaglyphRigMode */ "./node_modules/@babylonjs/core/Cameras/RigModes/stereoscopicAnaglyphRigMode.js");





// Side effect import to define the stereoscopic mode.

_node__WEBPACK_IMPORTED_MODULE_3__.Node.AddNodeConstructor("AnaglyphGamepadCamera", function (name, scene, options) {
    return function () { return new AnaglyphGamepadCamera(name, _Maths_math_vector__WEBPACK_IMPORTED_MODULE_2__.Vector3.Zero(), options.interaxial_distance, scene); };
});
/**
 * Camera used to simulate anaglyphic rendering (based on GamepadCamera)
 * @see http://doc.babylonjs.com/features/cameras#anaglyph-cameras
 */
var AnaglyphGamepadCamera = /** @class */ (function (_super) {
    (0,tslib__WEBPACK_IMPORTED_MODULE_5__.__extends)(AnaglyphGamepadCamera, _super);
    /**
     * Creates a new AnaglyphGamepadCamera
     * @param name defines camera name
     * @param position defines initial position
     * @param interaxialDistance defines distance between each color axis
     * @param scene defines the hosting scene
     */
    function AnaglyphGamepadCamera(name, position, interaxialDistance, scene) {
        var _this = _super.call(this, name, position, scene) || this;
        _this.interaxialDistance = interaxialDistance;
        _this.setCameraRigMode(_Cameras_camera__WEBPACK_IMPORTED_MODULE_0__.Camera.RIG_MODE_STEREOSCOPIC_ANAGLYPH, { interaxialDistance: interaxialDistance });
        return _this;
    }
    /**
     * Gets camera class name
     * @returns AnaglyphGamepadCamera
     */
    AnaglyphGamepadCamera.prototype.getClassName = function () {
        return "AnaglyphGamepadCamera";
    };
    return AnaglyphGamepadCamera;
}(_Cameras_gamepadCamera__WEBPACK_IMPORTED_MODULE_1__.GamepadCamera));

//# sourceMappingURL=anaglyphGamepadCamera.js.map

/***/ }),

/***/ "./node_modules/@babylonjs/core/Cameras/Stereoscopic/anaglyphUniversalCamera.js":
/*!**************************************************************************************!*\
  !*** ./node_modules/@babylonjs/core/Cameras/Stereoscopic/anaglyphUniversalCamera.js ***!
  \**************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "AnaglyphUniversalCamera": () => (/* binding */ AnaglyphUniversalCamera)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _Cameras_camera__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../Cameras/camera */ "./node_modules/@babylonjs/core/Cameras/camera.js");
/* harmony import */ var _Cameras_universalCamera__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../Cameras/universalCamera */ "./node_modules/@babylonjs/core/Cameras/universalCamera.js");
/* harmony import */ var _Maths_math_vector__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../Maths/math.vector */ "./node_modules/@babylonjs/core/Maths/math.vector.js");
/* harmony import */ var _node__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../node */ "./node_modules/@babylonjs/core/node.js");
/* harmony import */ var _RigModes_stereoscopicAnaglyphRigMode__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../RigModes/stereoscopicAnaglyphRigMode */ "./node_modules/@babylonjs/core/Cameras/RigModes/stereoscopicAnaglyphRigMode.js");





// Side effect import to define the stereoscopic mode.

_node__WEBPACK_IMPORTED_MODULE_3__.Node.AddNodeConstructor("AnaglyphUniversalCamera", function (name, scene, options) {
    return function () { return new AnaglyphUniversalCamera(name, _Maths_math_vector__WEBPACK_IMPORTED_MODULE_2__.Vector3.Zero(), options.interaxial_distance, scene); };
});
/**
 * Camera used to simulate anaglyphic rendering (based on UniversalCamera)
 * @see http://doc.babylonjs.com/features/cameras#anaglyph-cameras
 */
var AnaglyphUniversalCamera = /** @class */ (function (_super) {
    (0,tslib__WEBPACK_IMPORTED_MODULE_5__.__extends)(AnaglyphUniversalCamera, _super);
    /**
     * Creates a new AnaglyphUniversalCamera
     * @param name defines camera name
     * @param position defines initial position
     * @param interaxialDistance defines distance between each color axis
     * @param scene defines the hosting scene
     */
    function AnaglyphUniversalCamera(name, position, interaxialDistance, scene) {
        var _this = _super.call(this, name, position, scene) || this;
        _this.interaxialDistance = interaxialDistance;
        _this.setCameraRigMode(_Cameras_camera__WEBPACK_IMPORTED_MODULE_0__.Camera.RIG_MODE_STEREOSCOPIC_ANAGLYPH, { interaxialDistance: interaxialDistance });
        return _this;
    }
    /**
     * Gets camera class name
     * @returns AnaglyphUniversalCamera
     */
    AnaglyphUniversalCamera.prototype.getClassName = function () {
        return "AnaglyphUniversalCamera";
    };
    return AnaglyphUniversalCamera;
}(_Cameras_universalCamera__WEBPACK_IMPORTED_MODULE_1__.UniversalCamera));

//# sourceMappingURL=anaglyphUniversalCamera.js.map

/***/ }),

/***/ "./node_modules/@babylonjs/core/Cameras/Stereoscopic/index.js":
/*!********************************************************************!*\
  !*** ./node_modules/@babylonjs/core/Cameras/Stereoscopic/index.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "AnaglyphArcRotateCamera": () => (/* reexport safe */ _anaglyphArcRotateCamera__WEBPACK_IMPORTED_MODULE_0__.AnaglyphArcRotateCamera),
/* harmony export */   "AnaglyphFreeCamera": () => (/* reexport safe */ _anaglyphFreeCamera__WEBPACK_IMPORTED_MODULE_1__.AnaglyphFreeCamera),
/* harmony export */   "AnaglyphGamepadCamera": () => (/* reexport safe */ _anaglyphGamepadCamera__WEBPACK_IMPORTED_MODULE_2__.AnaglyphGamepadCamera),
/* harmony export */   "AnaglyphUniversalCamera": () => (/* reexport safe */ _anaglyphUniversalCamera__WEBPACK_IMPORTED_MODULE_3__.AnaglyphUniversalCamera),
/* harmony export */   "StereoscopicArcRotateCamera": () => (/* reexport safe */ _stereoscopicArcRotateCamera__WEBPACK_IMPORTED_MODULE_4__.StereoscopicArcRotateCamera),
/* harmony export */   "StereoscopicFreeCamera": () => (/* reexport safe */ _stereoscopicFreeCamera__WEBPACK_IMPORTED_MODULE_5__.StereoscopicFreeCamera),
/* harmony export */   "StereoscopicGamepadCamera": () => (/* reexport safe */ _stereoscopicGamepadCamera__WEBPACK_IMPORTED_MODULE_6__.StereoscopicGamepadCamera),
/* harmony export */   "StereoscopicUniversalCamera": () => (/* reexport safe */ _stereoscopicUniversalCamera__WEBPACK_IMPORTED_MODULE_7__.StereoscopicUniversalCamera)
/* harmony export */ });
/* harmony import */ var _anaglyphArcRotateCamera__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./anaglyphArcRotateCamera */ "./node_modules/@babylonjs/core/Cameras/Stereoscopic/anaglyphArcRotateCamera.js");
/* harmony import */ var _anaglyphFreeCamera__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./anaglyphFreeCamera */ "./node_modules/@babylonjs/core/Cameras/Stereoscopic/anaglyphFreeCamera.js");
/* harmony import */ var _anaglyphGamepadCamera__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./anaglyphGamepadCamera */ "./node_modules/@babylonjs/core/Cameras/Stereoscopic/anaglyphGamepadCamera.js");
/* harmony import */ var _anaglyphUniversalCamera__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./anaglyphUniversalCamera */ "./node_modules/@babylonjs/core/Cameras/Stereoscopic/anaglyphUniversalCamera.js");
/* harmony import */ var _stereoscopicArcRotateCamera__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./stereoscopicArcRotateCamera */ "./node_modules/@babylonjs/core/Cameras/Stereoscopic/stereoscopicArcRotateCamera.js");
/* harmony import */ var _stereoscopicFreeCamera__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./stereoscopicFreeCamera */ "./node_modules/@babylonjs/core/Cameras/Stereoscopic/stereoscopicFreeCamera.js");
/* harmony import */ var _stereoscopicGamepadCamera__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./stereoscopicGamepadCamera */ "./node_modules/@babylonjs/core/Cameras/Stereoscopic/stereoscopicGamepadCamera.js");
/* harmony import */ var _stereoscopicUniversalCamera__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./stereoscopicUniversalCamera */ "./node_modules/@babylonjs/core/Cameras/Stereoscopic/stereoscopicUniversalCamera.js");








//# sourceMappingURL=index.js.map

/***/ }),

/***/ "./node_modules/@babylonjs/core/Cameras/Stereoscopic/stereoscopicArcRotateCamera.js":
/*!******************************************************************************************!*\
  !*** ./node_modules/@babylonjs/core/Cameras/Stereoscopic/stereoscopicArcRotateCamera.js ***!
  \******************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "StereoscopicArcRotateCamera": () => (/* binding */ StereoscopicArcRotateCamera)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _Cameras_camera__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../Cameras/camera */ "./node_modules/@babylonjs/core/Cameras/camera.js");
/* harmony import */ var _Cameras_arcRotateCamera__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../Cameras/arcRotateCamera */ "./node_modules/@babylonjs/core/Cameras/arcRotateCamera.js");
/* harmony import */ var _Maths_math_vector__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../Maths/math.vector */ "./node_modules/@babylonjs/core/Maths/math.vector.js");
/* harmony import */ var _node__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../node */ "./node_modules/@babylonjs/core/node.js");
/* harmony import */ var _RigModes_stereoscopicRigMode__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../RigModes/stereoscopicRigMode */ "./node_modules/@babylonjs/core/Cameras/RigModes/stereoscopicRigMode.js");





// Side effect import to define the stereoscopic mode.

_node__WEBPACK_IMPORTED_MODULE_3__.Node.AddNodeConstructor("StereoscopicArcRotateCamera", function (name, scene, options) {
    return function () { return new StereoscopicArcRotateCamera(name, 0, 0, 1.0, _Maths_math_vector__WEBPACK_IMPORTED_MODULE_2__.Vector3.Zero(), options.interaxial_distance, options.isStereoscopicSideBySide, scene); };
});
/**
 * Camera used to simulate stereoscopic rendering (based on ArcRotateCamera)
 * @see http://doc.babylonjs.com/features/cameras
 */
var StereoscopicArcRotateCamera = /** @class */ (function (_super) {
    (0,tslib__WEBPACK_IMPORTED_MODULE_5__.__extends)(StereoscopicArcRotateCamera, _super);
    /**
     * Creates a new StereoscopicArcRotateCamera
     * @param name defines camera name
     * @param alpha defines alpha angle (in radians)
     * @param beta defines beta angle (in radians)
     * @param radius defines radius
     * @param target defines camera target
     * @param interaxialDistance defines distance between each color axis
     * @param isStereoscopicSideBySide defines is stereoscopic is done side by side or over under
     * @param scene defines the hosting scene
     */
    function StereoscopicArcRotateCamera(name, alpha, beta, radius, target, interaxialDistance, isStereoscopicSideBySide, scene) {
        var _this = _super.call(this, name, alpha, beta, radius, target, scene) || this;
        _this.interaxialDistance = interaxialDistance;
        _this.isStereoscopicSideBySide = isStereoscopicSideBySide;
        _this.setCameraRigMode(isStereoscopicSideBySide ? _Cameras_camera__WEBPACK_IMPORTED_MODULE_0__.Camera.RIG_MODE_STEREOSCOPIC_SIDEBYSIDE_PARALLEL : _Cameras_camera__WEBPACK_IMPORTED_MODULE_0__.Camera.RIG_MODE_STEREOSCOPIC_OVERUNDER, { interaxialDistance: interaxialDistance });
        return _this;
    }
    /**
     * Gets camera class name
     * @returns StereoscopicArcRotateCamera
     */
    StereoscopicArcRotateCamera.prototype.getClassName = function () {
        return "StereoscopicArcRotateCamera";
    };
    return StereoscopicArcRotateCamera;
}(_Cameras_arcRotateCamera__WEBPACK_IMPORTED_MODULE_1__.ArcRotateCamera));

//# sourceMappingURL=stereoscopicArcRotateCamera.js.map

/***/ }),

/***/ "./node_modules/@babylonjs/core/Cameras/Stereoscopic/stereoscopicFreeCamera.js":
/*!*************************************************************************************!*\
  !*** ./node_modules/@babylonjs/core/Cameras/Stereoscopic/stereoscopicFreeCamera.js ***!
  \*************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "StereoscopicFreeCamera": () => (/* binding */ StereoscopicFreeCamera)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _Cameras_camera__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../Cameras/camera */ "./node_modules/@babylonjs/core/Cameras/camera.js");
/* harmony import */ var _Cameras_freeCamera__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../Cameras/freeCamera */ "./node_modules/@babylonjs/core/Cameras/freeCamera.js");
/* harmony import */ var _Maths_math_vector__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../Maths/math.vector */ "./node_modules/@babylonjs/core/Maths/math.vector.js");
/* harmony import */ var _node__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../node */ "./node_modules/@babylonjs/core/node.js");
/* harmony import */ var _RigModes_stereoscopicRigMode__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../RigModes/stereoscopicRigMode */ "./node_modules/@babylonjs/core/Cameras/RigModes/stereoscopicRigMode.js");





// Side effect import to define the stereoscopic mode.

_node__WEBPACK_IMPORTED_MODULE_3__.Node.AddNodeConstructor("StereoscopicFreeCamera", function (name, scene, options) {
    return function () { return new StereoscopicFreeCamera(name, _Maths_math_vector__WEBPACK_IMPORTED_MODULE_2__.Vector3.Zero(), options.interaxial_distance, options.isStereoscopicSideBySide, scene); };
});
/**
 * Camera used to simulate stereoscopic rendering (based on FreeCamera)
 * @see http://doc.babylonjs.com/features/cameras
 */
var StereoscopicFreeCamera = /** @class */ (function (_super) {
    (0,tslib__WEBPACK_IMPORTED_MODULE_5__.__extends)(StereoscopicFreeCamera, _super);
    /**
     * Creates a new StereoscopicFreeCamera
     * @param name defines camera name
     * @param position defines initial position
     * @param interaxialDistance defines distance between each color axis
     * @param isStereoscopicSideBySide defines is stereoscopic is done side by side or over under
     * @param scene defines the hosting scene
     */
    function StereoscopicFreeCamera(name, position, interaxialDistance, isStereoscopicSideBySide, scene) {
        var _this = _super.call(this, name, position, scene) || this;
        _this.interaxialDistance = interaxialDistance;
        _this.isStereoscopicSideBySide = isStereoscopicSideBySide;
        _this.setCameraRigMode(isStereoscopicSideBySide ? _Cameras_camera__WEBPACK_IMPORTED_MODULE_0__.Camera.RIG_MODE_STEREOSCOPIC_SIDEBYSIDE_PARALLEL : _Cameras_camera__WEBPACK_IMPORTED_MODULE_0__.Camera.RIG_MODE_STEREOSCOPIC_OVERUNDER, { interaxialDistance: interaxialDistance });
        return _this;
    }
    /**
     * Gets camera class name
     * @returns StereoscopicFreeCamera
     */
    StereoscopicFreeCamera.prototype.getClassName = function () {
        return "StereoscopicFreeCamera";
    };
    return StereoscopicFreeCamera;
}(_Cameras_freeCamera__WEBPACK_IMPORTED_MODULE_1__.FreeCamera));

//# sourceMappingURL=stereoscopicFreeCamera.js.map

/***/ }),

/***/ "./node_modules/@babylonjs/core/Cameras/Stereoscopic/stereoscopicGamepadCamera.js":
/*!****************************************************************************************!*\
  !*** ./node_modules/@babylonjs/core/Cameras/Stereoscopic/stereoscopicGamepadCamera.js ***!
  \****************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "StereoscopicGamepadCamera": () => (/* binding */ StereoscopicGamepadCamera)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _Cameras_camera__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../Cameras/camera */ "./node_modules/@babylonjs/core/Cameras/camera.js");
/* harmony import */ var _Cameras_gamepadCamera__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../Cameras/gamepadCamera */ "./node_modules/@babylonjs/core/Cameras/gamepadCamera.js");
/* harmony import */ var _Maths_math_vector__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../Maths/math.vector */ "./node_modules/@babylonjs/core/Maths/math.vector.js");
/* harmony import */ var _node__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../node */ "./node_modules/@babylonjs/core/node.js");
/* harmony import */ var _RigModes_stereoscopicRigMode__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../RigModes/stereoscopicRigMode */ "./node_modules/@babylonjs/core/Cameras/RigModes/stereoscopicRigMode.js");





// Side effect import to define the stereoscopic mode.

_node__WEBPACK_IMPORTED_MODULE_3__.Node.AddNodeConstructor("StereoscopicGamepadCamera", function (name, scene, options) {
    return function () { return new StereoscopicGamepadCamera(name, _Maths_math_vector__WEBPACK_IMPORTED_MODULE_2__.Vector3.Zero(), options.interaxial_distance, options.isStereoscopicSideBySide, scene); };
});
/**
 * Camera used to simulate stereoscopic rendering (based on GamepadCamera)
 * @see http://doc.babylonjs.com/features/cameras
 */
var StereoscopicGamepadCamera = /** @class */ (function (_super) {
    (0,tslib__WEBPACK_IMPORTED_MODULE_5__.__extends)(StereoscopicGamepadCamera, _super);
    /**
     * Creates a new StereoscopicGamepadCamera
     * @param name defines camera name
     * @param position defines initial position
     * @param interaxialDistance defines distance between each color axis
     * @param isStereoscopicSideBySide defines is stereoscopic is done side by side or over under
     * @param scene defines the hosting scene
     */
    function StereoscopicGamepadCamera(name, position, interaxialDistance, isStereoscopicSideBySide, scene) {
        var _this = _super.call(this, name, position, scene) || this;
        _this.interaxialDistance = interaxialDistance;
        _this.isStereoscopicSideBySide = isStereoscopicSideBySide;
        _this.setCameraRigMode(isStereoscopicSideBySide ? _Cameras_camera__WEBPACK_IMPORTED_MODULE_0__.Camera.RIG_MODE_STEREOSCOPIC_SIDEBYSIDE_PARALLEL : _Cameras_camera__WEBPACK_IMPORTED_MODULE_0__.Camera.RIG_MODE_STEREOSCOPIC_OVERUNDER, { interaxialDistance: interaxialDistance });
        return _this;
    }
    /**
     * Gets camera class name
     * @returns StereoscopicGamepadCamera
     */
    StereoscopicGamepadCamera.prototype.getClassName = function () {
        return "StereoscopicGamepadCamera";
    };
    return StereoscopicGamepadCamera;
}(_Cameras_gamepadCamera__WEBPACK_IMPORTED_MODULE_1__.GamepadCamera));

//# sourceMappingURL=stereoscopicGamepadCamera.js.map

/***/ }),

/***/ "./node_modules/@babylonjs/core/Cameras/Stereoscopic/stereoscopicUniversalCamera.js":
/*!******************************************************************************************!*\
  !*** ./node_modules/@babylonjs/core/Cameras/Stereoscopic/stereoscopicUniversalCamera.js ***!
  \******************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "StereoscopicUniversalCamera": () => (/* binding */ StereoscopicUniversalCamera)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _Cameras_camera__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../Cameras/camera */ "./node_modules/@babylonjs/core/Cameras/camera.js");
/* harmony import */ var _Cameras_universalCamera__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../Cameras/universalCamera */ "./node_modules/@babylonjs/core/Cameras/universalCamera.js");
/* harmony import */ var _Maths_math_vector__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../Maths/math.vector */ "./node_modules/@babylonjs/core/Maths/math.vector.js");
/* harmony import */ var _node__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../node */ "./node_modules/@babylonjs/core/node.js");
/* harmony import */ var _RigModes_stereoscopicRigMode__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../RigModes/stereoscopicRigMode */ "./node_modules/@babylonjs/core/Cameras/RigModes/stereoscopicRigMode.js");





// Side effect import to define the stereoscopic mode.

_node__WEBPACK_IMPORTED_MODULE_3__.Node.AddNodeConstructor("StereoscopicFreeCamera", function (name, scene, options) {
    return function () { return new StereoscopicUniversalCamera(name, _Maths_math_vector__WEBPACK_IMPORTED_MODULE_2__.Vector3.Zero(), options.interaxial_distance, options.isStereoscopicSideBySide, scene); };
});
/**
 * Camera used to simulate stereoscopic rendering (based on UniversalCamera)
 * @see http://doc.babylonjs.com/features/cameras
 */
var StereoscopicUniversalCamera = /** @class */ (function (_super) {
    (0,tslib__WEBPACK_IMPORTED_MODULE_5__.__extends)(StereoscopicUniversalCamera, _super);
    /**
     * Creates a new StereoscopicUniversalCamera
     * @param name defines camera name
     * @param position defines initial position
     * @param interaxialDistance defines distance between each color axis
     * @param isStereoscopicSideBySide defines is stereoscopic is done side by side or over under
     * @param scene defines the hosting scene
     */
    function StereoscopicUniversalCamera(name, position, interaxialDistance, isStereoscopicSideBySide, scene) {
        var _this = _super.call(this, name, position, scene) || this;
        _this.interaxialDistance = interaxialDistance;
        _this.isStereoscopicSideBySide = isStereoscopicSideBySide;
        _this.setCameraRigMode(isStereoscopicSideBySide ? _Cameras_camera__WEBPACK_IMPORTED_MODULE_0__.Camera.RIG_MODE_STEREOSCOPIC_SIDEBYSIDE_PARALLEL : _Cameras_camera__WEBPACK_IMPORTED_MODULE_0__.Camera.RIG_MODE_STEREOSCOPIC_OVERUNDER, { interaxialDistance: interaxialDistance });
        return _this;
    }
    /**
     * Gets camera class name
     * @returns StereoscopicUniversalCamera
     */
    StereoscopicUniversalCamera.prototype.getClassName = function () {
        return "StereoscopicUniversalCamera";
    };
    return StereoscopicUniversalCamera;
}(_Cameras_universalCamera__WEBPACK_IMPORTED_MODULE_1__.UniversalCamera));

//# sourceMappingURL=stereoscopicUniversalCamera.js.map

/***/ }),

/***/ "./node_modules/@babylonjs/core/Cameras/VR/index.js":
/*!**********************************************************!*\
  !*** ./node_modules/@babylonjs/core/Cameras/VR/index.js ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "OnAfterEnteringVRObservableEvent": () => (/* reexport safe */ _vrExperienceHelper__WEBPACK_IMPORTED_MODULE_4__.OnAfterEnteringVRObservableEvent),
/* harmony export */   "VRCameraMetrics": () => (/* reexport safe */ _vrCameraMetrics__WEBPACK_IMPORTED_MODULE_0__.VRCameraMetrics),
/* harmony export */   "VRDeviceOrientationArcRotateCamera": () => (/* reexport safe */ _vrDeviceOrientationArcRotateCamera__WEBPACK_IMPORTED_MODULE_1__.VRDeviceOrientationArcRotateCamera),
/* harmony export */   "VRDeviceOrientationFreeCamera": () => (/* reexport safe */ _vrDeviceOrientationFreeCamera__WEBPACK_IMPORTED_MODULE_2__.VRDeviceOrientationFreeCamera),
/* harmony export */   "VRDeviceOrientationGamepadCamera": () => (/* reexport safe */ _vrDeviceOrientationGamepadCamera__WEBPACK_IMPORTED_MODULE_3__.VRDeviceOrientationGamepadCamera),
/* harmony export */   "VRExperienceHelper": () => (/* reexport safe */ _vrExperienceHelper__WEBPACK_IMPORTED_MODULE_4__.VRExperienceHelper),
/* harmony export */   "WebVRFreeCamera": () => (/* reexport safe */ _webVRCamera__WEBPACK_IMPORTED_MODULE_5__.WebVRFreeCamera)
/* harmony export */ });
/* harmony import */ var _vrCameraMetrics__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./vrCameraMetrics */ "./node_modules/@babylonjs/core/Cameras/VR/vrCameraMetrics.js");
/* harmony import */ var _vrDeviceOrientationArcRotateCamera__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./vrDeviceOrientationArcRotateCamera */ "./node_modules/@babylonjs/core/Cameras/VR/vrDeviceOrientationArcRotateCamera.js");
/* harmony import */ var _vrDeviceOrientationFreeCamera__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./vrDeviceOrientationFreeCamera */ "./node_modules/@babylonjs/core/Cameras/VR/vrDeviceOrientationFreeCamera.js");
/* harmony import */ var _vrDeviceOrientationGamepadCamera__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./vrDeviceOrientationGamepadCamera */ "./node_modules/@babylonjs/core/Cameras/VR/vrDeviceOrientationGamepadCamera.js");
/* harmony import */ var _vrExperienceHelper__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./vrExperienceHelper */ "./node_modules/@babylonjs/core/Cameras/VR/vrExperienceHelper.js");
/* harmony import */ var _webVRCamera__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./webVRCamera */ "./node_modules/@babylonjs/core/Cameras/VR/webVRCamera.js");






//# sourceMappingURL=index.js.map

/***/ }),

/***/ "./node_modules/@babylonjs/core/Cameras/VR/vrCameraMetrics.js":
/*!********************************************************************!*\
  !*** ./node_modules/@babylonjs/core/Cameras/VR/vrCameraMetrics.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "VRCameraMetrics": () => (/* binding */ VRCameraMetrics)
/* harmony export */ });
/* harmony import */ var _Maths_math_vector__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../Maths/math.vector */ "./node_modules/@babylonjs/core/Maths/math.vector.js");

/**
 * This represents all the required metrics to create a VR camera.
 * @see http://doc.babylonjs.com/babylon101/cameras#device-orientation-camera
 */
var VRCameraMetrics = /** @class */ (function () {
    function VRCameraMetrics() {
        /**
         * Define if the current vr camera should compensate the distortion of the lense or not.
         */
        this.compensateDistortion = true;
        /**
         * Defines if multiview should be enabled when rendering (Default: false)
         */
        this.multiviewEnabled = false;
    }
    Object.defineProperty(VRCameraMetrics.prototype, "aspectRatio", {
        /**
         * Gets the rendering aspect ratio based on the provided resolutions.
         */
        get: function () {
            return this.hResolution / (2 * this.vResolution);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(VRCameraMetrics.prototype, "aspectRatioFov", {
        /**
         * Gets the aspect ratio based on the FOV, scale factors, and real screen sizes.
         */
        get: function () {
            return (2 * Math.atan((this.postProcessScaleFactor * this.vScreenSize) / (2 * this.eyeToScreenDistance)));
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(VRCameraMetrics.prototype, "leftHMatrix", {
        /**
         * @hidden
         */
        get: function () {
            var meters = (this.hScreenSize / 4) - (this.lensSeparationDistance / 2);
            var h = (4 * meters) / this.hScreenSize;
            return _Maths_math_vector__WEBPACK_IMPORTED_MODULE_0__.Matrix.Translation(h, 0, 0);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(VRCameraMetrics.prototype, "rightHMatrix", {
        /**
         * @hidden
         */
        get: function () {
            var meters = (this.hScreenSize / 4) - (this.lensSeparationDistance / 2);
            var h = (4 * meters) / this.hScreenSize;
            return _Maths_math_vector__WEBPACK_IMPORTED_MODULE_0__.Matrix.Translation(-h, 0, 0);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(VRCameraMetrics.prototype, "leftPreViewMatrix", {
        /**
         * @hidden
         */
        get: function () {
            return _Maths_math_vector__WEBPACK_IMPORTED_MODULE_0__.Matrix.Translation(0.5 * this.interpupillaryDistance, 0, 0);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(VRCameraMetrics.prototype, "rightPreViewMatrix", {
        /**
         * @hidden
         */
        get: function () {
            return _Maths_math_vector__WEBPACK_IMPORTED_MODULE_0__.Matrix.Translation(-0.5 * this.interpupillaryDistance, 0, 0);
        },
        enumerable: true,
        configurable: true
    });
    /**
     * Get the default VRMetrics based on the most generic setup.
     * @returns the default vr metrics
     */
    VRCameraMetrics.GetDefault = function () {
        var result = new VRCameraMetrics();
        result.hResolution = 1280;
        result.vResolution = 800;
        result.hScreenSize = 0.149759993;
        result.vScreenSize = 0.0935999975;
        result.vScreenCenter = 0.0467999987;
        result.eyeToScreenDistance = 0.0410000011;
        result.lensSeparationDistance = 0.0635000020;
        result.interpupillaryDistance = 0.0640000030;
        result.distortionK = [1.0, 0.219999999, 0.239999995, 0.0];
        result.chromaAbCorrection = [0.995999992, -0.00400000019, 1.01400006, 0.0];
        result.postProcessScaleFactor = 1.714605507808412;
        result.lensCenterOffset = 0.151976421;
        return result;
    };
    return VRCameraMetrics;
}());

//# sourceMappingURL=vrCameraMetrics.js.map

/***/ }),

/***/ "./node_modules/@babylonjs/core/Cameras/VR/vrDeviceOrientationArcRotateCamera.js":
/*!***************************************************************************************!*\
  !*** ./node_modules/@babylonjs/core/Cameras/VR/vrDeviceOrientationArcRotateCamera.js ***!
  \***************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "VRDeviceOrientationArcRotateCamera": () => (/* binding */ VRDeviceOrientationArcRotateCamera)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _Cameras_camera__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../Cameras/camera */ "./node_modules/@babylonjs/core/Cameras/camera.js");
/* harmony import */ var _Cameras_arcRotateCamera__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../Cameras/arcRotateCamera */ "./node_modules/@babylonjs/core/Cameras/arcRotateCamera.js");
/* harmony import */ var _vrCameraMetrics__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./vrCameraMetrics */ "./node_modules/@babylonjs/core/Cameras/VR/vrCameraMetrics.js");
/* harmony import */ var _Maths_math_vector__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../Maths/math.vector */ "./node_modules/@babylonjs/core/Maths/math.vector.js");
/* harmony import */ var _node__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../node */ "./node_modules/@babylonjs/core/node.js");
/* harmony import */ var _Inputs_arcRotateCameraVRDeviceOrientationInput__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../Inputs/arcRotateCameraVRDeviceOrientationInput */ "./node_modules/@babylonjs/core/Cameras/Inputs/arcRotateCameraVRDeviceOrientationInput.js");
/* harmony import */ var _RigModes_vrRigMode__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../RigModes/vrRigMode */ "./node_modules/@babylonjs/core/Cameras/RigModes/vrRigMode.js");







// Side effect import to define the stereoscopic mode.

_node__WEBPACK_IMPORTED_MODULE_4__.Node.AddNodeConstructor("VRDeviceOrientationFreeCamera", function (name, scene) {
    return function () { return new VRDeviceOrientationArcRotateCamera(name, 0, 0, 1.0, _Maths_math_vector__WEBPACK_IMPORTED_MODULE_3__.Vector3.Zero(), scene); };
});
/**
 * Camera used to simulate VR rendering (based on ArcRotateCamera)
 * @see http://doc.babylonjs.com/babylon101/cameras#vr-device-orientation-cameras
 */
var VRDeviceOrientationArcRotateCamera = /** @class */ (function (_super) {
    (0,tslib__WEBPACK_IMPORTED_MODULE_7__.__extends)(VRDeviceOrientationArcRotateCamera, _super);
    /**
     * Creates a new VRDeviceOrientationArcRotateCamera
     * @param name defines camera name
     * @param alpha defines the camera rotation along the logitudinal axis
     * @param beta defines the camera rotation along the latitudinal axis
     * @param radius defines the camera distance from its target
     * @param target defines the camera target
     * @param scene defines the scene the camera belongs to
     * @param compensateDistortion defines if the camera needs to compensate the lens distorsion
     * @param vrCameraMetrics defines the vr metrics associated to the camera
     */
    function VRDeviceOrientationArcRotateCamera(name, alpha, beta, radius, target, scene, compensateDistortion, vrCameraMetrics) {
        if (compensateDistortion === void 0) { compensateDistortion = true; }
        if (vrCameraMetrics === void 0) { vrCameraMetrics = _vrCameraMetrics__WEBPACK_IMPORTED_MODULE_2__.VRCameraMetrics.GetDefault(); }
        var _this = _super.call(this, name, alpha, beta, radius, target, scene) || this;
        vrCameraMetrics.compensateDistortion = compensateDistortion;
        _this.setCameraRigMode(_Cameras_camera__WEBPACK_IMPORTED_MODULE_0__.Camera.RIG_MODE_VR, { vrCameraMetrics: vrCameraMetrics });
        _this.inputs.addVRDeviceOrientation();
        return _this;
    }
    /**
     * Gets camera class name
     * @returns VRDeviceOrientationArcRotateCamera
     */
    VRDeviceOrientationArcRotateCamera.prototype.getClassName = function () {
        return "VRDeviceOrientationArcRotateCamera";
    };
    return VRDeviceOrientationArcRotateCamera;
}(_Cameras_arcRotateCamera__WEBPACK_IMPORTED_MODULE_1__.ArcRotateCamera));

//# sourceMappingURL=vrDeviceOrientationArcRotateCamera.js.map

/***/ }),

/***/ "./node_modules/@babylonjs/core/Cameras/VR/vrDeviceOrientationFreeCamera.js":
/*!**********************************************************************************!*\
  !*** ./node_modules/@babylonjs/core/Cameras/VR/vrDeviceOrientationFreeCamera.js ***!
  \**********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "VRDeviceOrientationFreeCamera": () => (/* binding */ VRDeviceOrientationFreeCamera)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _Cameras_camera__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../Cameras/camera */ "./node_modules/@babylonjs/core/Cameras/camera.js");
/* harmony import */ var _Cameras_deviceOrientationCamera__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../Cameras/deviceOrientationCamera */ "./node_modules/@babylonjs/core/Cameras/deviceOrientationCamera.js");
/* harmony import */ var _vrCameraMetrics__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./vrCameraMetrics */ "./node_modules/@babylonjs/core/Cameras/VR/vrCameraMetrics.js");
/* harmony import */ var _Maths_math_vector__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../Maths/math.vector */ "./node_modules/@babylonjs/core/Maths/math.vector.js");
/* harmony import */ var _node__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../node */ "./node_modules/@babylonjs/core/node.js");
/* harmony import */ var _RigModes_vrRigMode__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../RigModes/vrRigMode */ "./node_modules/@babylonjs/core/Cameras/RigModes/vrRigMode.js");






// Side effect import to define the stereoscopic mode.

_node__WEBPACK_IMPORTED_MODULE_4__.Node.AddNodeConstructor("VRDeviceOrientationFreeCamera", function (name, scene) {
    return function () { return new VRDeviceOrientationFreeCamera(name, _Maths_math_vector__WEBPACK_IMPORTED_MODULE_3__.Vector3.Zero(), scene); };
});
/**
 * Camera used to simulate VR rendering (based on FreeCamera)
 * @see http://doc.babylonjs.com/babylon101/cameras#vr-device-orientation-cameras
 */
var VRDeviceOrientationFreeCamera = /** @class */ (function (_super) {
    (0,tslib__WEBPACK_IMPORTED_MODULE_6__.__extends)(VRDeviceOrientationFreeCamera, _super);
    /**
     * Creates a new VRDeviceOrientationFreeCamera
     * @param name defines camera name
     * @param position defines the start position of the camera
     * @param scene defines the scene the camera belongs to
     * @param compensateDistortion defines if the camera needs to compensate the lens distorsion
     * @param vrCameraMetrics defines the vr metrics associated to the camera
     */
    function VRDeviceOrientationFreeCamera(name, position, scene, compensateDistortion, vrCameraMetrics) {
        if (compensateDistortion === void 0) { compensateDistortion = true; }
        if (vrCameraMetrics === void 0) { vrCameraMetrics = _vrCameraMetrics__WEBPACK_IMPORTED_MODULE_2__.VRCameraMetrics.GetDefault(); }
        var _this = _super.call(this, name, position, scene) || this;
        vrCameraMetrics.compensateDistortion = compensateDistortion;
        _this.setCameraRigMode(_Cameras_camera__WEBPACK_IMPORTED_MODULE_0__.Camera.RIG_MODE_VR, { vrCameraMetrics: vrCameraMetrics });
        return _this;
    }
    /**
     * Gets camera class name
     * @returns VRDeviceOrientationFreeCamera
     */
    VRDeviceOrientationFreeCamera.prototype.getClassName = function () {
        return "VRDeviceOrientationFreeCamera";
    };
    return VRDeviceOrientationFreeCamera;
}(_Cameras_deviceOrientationCamera__WEBPACK_IMPORTED_MODULE_1__.DeviceOrientationCamera));

//# sourceMappingURL=vrDeviceOrientationFreeCamera.js.map

/***/ }),

/***/ "./node_modules/@babylonjs/core/Cameras/VR/vrDeviceOrientationGamepadCamera.js":
/*!*************************************************************************************!*\
  !*** ./node_modules/@babylonjs/core/Cameras/VR/vrDeviceOrientationGamepadCamera.js ***!
  \*************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "VRDeviceOrientationGamepadCamera": () => (/* binding */ VRDeviceOrientationGamepadCamera)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _vrDeviceOrientationFreeCamera__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./vrDeviceOrientationFreeCamera */ "./node_modules/@babylonjs/core/Cameras/VR/vrDeviceOrientationFreeCamera.js");
/* harmony import */ var _vrCameraMetrics__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./vrCameraMetrics */ "./node_modules/@babylonjs/core/Cameras/VR/vrCameraMetrics.js");
/* harmony import */ var _Maths_math_vector__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../Maths/math.vector */ "./node_modules/@babylonjs/core/Maths/math.vector.js");
/* harmony import */ var _node__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../node */ "./node_modules/@babylonjs/core/node.js");
/* harmony import */ var _Gamepads_gamepadSceneComponent__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../Gamepads/gamepadSceneComponent */ "./node_modules/@babylonjs/core/Gamepads/gamepadSceneComponent.js");






_node__WEBPACK_IMPORTED_MODULE_3__.Node.AddNodeConstructor("VRDeviceOrientationGamepadCamera", function (name, scene) {
    return function () { return new VRDeviceOrientationGamepadCamera(name, _Maths_math_vector__WEBPACK_IMPORTED_MODULE_2__.Vector3.Zero(), scene); };
});
/**
 * Camera used to simulate VR rendering (based on VRDeviceOrientationFreeCamera)
 * @see http://doc.babylonjs.com/babylon101/cameras#vr-device-orientation-cameras
 */
var VRDeviceOrientationGamepadCamera = /** @class */ (function (_super) {
    (0,tslib__WEBPACK_IMPORTED_MODULE_5__.__extends)(VRDeviceOrientationGamepadCamera, _super);
    /**
     * Creates a new VRDeviceOrientationGamepadCamera
     * @param name defines camera name
     * @param position defines the start position of the camera
     * @param scene defines the scene the camera belongs to
     * @param compensateDistortion defines if the camera needs to compensate the lens distorsion
     * @param vrCameraMetrics defines the vr metrics associated to the camera
     */
    function VRDeviceOrientationGamepadCamera(name, position, scene, compensateDistortion, vrCameraMetrics) {
        if (compensateDistortion === void 0) { compensateDistortion = true; }
        if (vrCameraMetrics === void 0) { vrCameraMetrics = _vrCameraMetrics__WEBPACK_IMPORTED_MODULE_1__.VRCameraMetrics.GetDefault(); }
        var _this = _super.call(this, name, position, scene, compensateDistortion, vrCameraMetrics) || this;
        _this.inputs.addGamepad();
        return _this;
    }
    /**
     * Gets camera class name
     * @returns VRDeviceOrientationGamepadCamera
     */
    VRDeviceOrientationGamepadCamera.prototype.getClassName = function () {
        return "VRDeviceOrientationGamepadCamera";
    };
    return VRDeviceOrientationGamepadCamera;
}(_vrDeviceOrientationFreeCamera__WEBPACK_IMPORTED_MODULE_0__.VRDeviceOrientationFreeCamera));

//# sourceMappingURL=vrDeviceOrientationGamepadCamera.js.map

/***/ }),

/***/ "./node_modules/@babylonjs/core/Cameras/VR/vrExperienceHelper.js":
/*!***********************************************************************!*\
  !*** ./node_modules/@babylonjs/core/Cameras/VR/vrExperienceHelper.js ***!
  \***********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "OnAfterEnteringVRObservableEvent": () => (/* binding */ OnAfterEnteringVRObservableEvent),
/* harmony export */   "VRExperienceHelper": () => (/* binding */ VRExperienceHelper)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_31__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _Misc_logger__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../Misc/logger */ "./node_modules/@babylonjs/core/Misc/logger.js");
/* harmony import */ var _Misc_observable__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../Misc/observable */ "./node_modules/@babylonjs/core/Misc/observable.js");
/* harmony import */ var _Cameras_freeCamera__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../Cameras/freeCamera */ "./node_modules/@babylonjs/core/Cameras/freeCamera.js");
/* harmony import */ var _Cameras_targetCamera__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../Cameras/targetCamera */ "./node_modules/@babylonjs/core/Cameras/targetCamera.js");
/* harmony import */ var _Cameras_deviceOrientationCamera__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../Cameras/deviceOrientationCamera */ "./node_modules/@babylonjs/core/Cameras/deviceOrientationCamera.js");
/* harmony import */ var _Cameras_VR_vrDeviceOrientationFreeCamera__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../Cameras/VR/vrDeviceOrientationFreeCamera */ "./node_modules/@babylonjs/core/Cameras/VR/vrDeviceOrientationFreeCamera.js");
/* harmony import */ var _Cameras_VR_webVRCamera__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../Cameras/VR/webVRCamera */ "./node_modules/@babylonjs/core/Cameras/VR/webVRCamera.js");
/* harmony import */ var _Events_pointerEvents__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../Events/pointerEvents */ "./node_modules/@babylonjs/core/Events/pointerEvents.js");
/* harmony import */ var _Maths_math_vector__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../Maths/math.vector */ "./node_modules/@babylonjs/core/Maths/math.vector.js");
/* harmony import */ var _Maths_math_color__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../Maths/math.color */ "./node_modules/@babylonjs/core/Maths/math.color.js");
/* harmony import */ var _Gamepads_gamepad__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../Gamepads/gamepad */ "./node_modules/@babylonjs/core/Gamepads/gamepad.js");
/* harmony import */ var _Gamepads_Controllers_poseEnabledController__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../../Gamepads/Controllers/poseEnabledController */ "./node_modules/@babylonjs/core/Gamepads/Controllers/poseEnabledController.js");
/* harmony import */ var _Gamepads_Controllers_webVRController__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../../Gamepads/Controllers/webVRController */ "./node_modules/@babylonjs/core/Gamepads/Controllers/webVRController.js");
/* harmony import */ var _Gamepads_xboxGamepad__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../../Gamepads/xboxGamepad */ "./node_modules/@babylonjs/core/Gamepads/xboxGamepad.js");
/* harmony import */ var _Meshes_mesh__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ../../Meshes/mesh */ "./node_modules/@babylonjs/core/Meshes/mesh.js");
/* harmony import */ var _Culling_ray__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ../../Culling/ray */ "./node_modules/@babylonjs/core/Culling/ray.js");
/* harmony import */ var _Materials_imageProcessingConfiguration__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ../../Materials/imageProcessingConfiguration */ "./node_modules/@babylonjs/core/Materials/imageProcessingConfiguration.js");
/* harmony import */ var _Materials_standardMaterial__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ../../Materials/standardMaterial */ "./node_modules/@babylonjs/core/Materials/standardMaterial.js");
/* harmony import */ var _Materials_Textures_dynamicTexture__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ../../Materials/Textures/dynamicTexture */ "./node_modules/@babylonjs/core/Materials/Textures/dynamicTexture.js");
/* harmony import */ var _PostProcesses_imageProcessingPostProcess__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! ../../PostProcesses/imageProcessingPostProcess */ "./node_modules/@babylonjs/core/PostProcesses/imageProcessingPostProcess.js");
/* harmony import */ var _Animations_easing__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! ../../Animations/easing */ "./node_modules/@babylonjs/core/Animations/easing.js");
/* harmony import */ var _Animations_animation__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! ../../Animations/animation */ "./node_modules/@babylonjs/core/Animations/animation.js");
/* harmony import */ var _Cameras_VR_vrCameraMetrics__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! ../../Cameras/VR/vrCameraMetrics */ "./node_modules/@babylonjs/core/Cameras/VR/vrCameraMetrics.js");
/* harmony import */ var _Meshes_Builders_groundBuilder__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! ../../Meshes/Builders/groundBuilder */ "./node_modules/@babylonjs/core/Meshes/Builders/groundBuilder.js");
/* harmony import */ var _Meshes_Builders_torusBuilder__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(/*! ../../Meshes/Builders/torusBuilder */ "./node_modules/@babylonjs/core/Meshes/Builders/torusBuilder.js");
/* harmony import */ var _Meshes_Builders_cylinderBuilder__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(/*! ../../Meshes/Builders/cylinderBuilder */ "./node_modules/@babylonjs/core/Meshes/Builders/cylinderBuilder.js");
/* harmony import */ var _Gamepads_gamepadSceneComponent__WEBPACK_IMPORTED_MODULE_26__ = __webpack_require__(/*! ../../Gamepads/gamepadSceneComponent */ "./node_modules/@babylonjs/core/Gamepads/gamepadSceneComponent.js");
/* harmony import */ var _Animations_animatable__WEBPACK_IMPORTED_MODULE_27__ = __webpack_require__(/*! ../../Animations/animatable */ "./node_modules/@babylonjs/core/Animations/animatable.js");
/* harmony import */ var _Maths_math_axis__WEBPACK_IMPORTED_MODULE_28__ = __webpack_require__(/*! ../../Maths/math.axis */ "./node_modules/@babylonjs/core/Maths/math.axis.js");
/* harmony import */ var _XR_webXRSessionManager__WEBPACK_IMPORTED_MODULE_29__ = __webpack_require__(/*! ../../XR/webXRSessionManager */ "./node_modules/@babylonjs/core/XR/webXRSessionManager.js");
/* harmony import */ var _XR_webXRTypes__WEBPACK_IMPORTED_MODULE_30__ = __webpack_require__(/*! ../../XR/webXRTypes */ "./node_modules/@babylonjs/core/XR/webXRTypes.js");
































var VRExperienceHelperGazer = /** @class */ (function () {
    function VRExperienceHelperGazer(scene, gazeTrackerToClone) {
        if (gazeTrackerToClone === void 0) { gazeTrackerToClone = null; }
        this.scene = scene;
        /** @hidden */
        this._pointerDownOnMeshAsked = false;
        /** @hidden */
        this._isActionableMesh = false;
        /** @hidden */
        this._teleportationRequestInitiated = false;
        /** @hidden */
        this._teleportationBackRequestInitiated = false;
        /** @hidden */
        this._rotationRightAsked = false;
        /** @hidden */
        this._rotationLeftAsked = false;
        /** @hidden */
        this._dpadPressed = true;
        /** @hidden */
        this._activePointer = false;
        this._id = VRExperienceHelperGazer._idCounter++;
        // Gaze tracker
        if (!gazeTrackerToClone) {
            this._gazeTracker = _Meshes_mesh__WEBPACK_IMPORTED_MODULE_14__.Mesh.CreateTorus("gazeTracker", 0.0035, 0.0025, 20, scene, false);
            this._gazeTracker.bakeCurrentTransformIntoVertices();
            this._gazeTracker.isPickable = false;
            this._gazeTracker.isVisible = false;
            var targetMat = new _Materials_standardMaterial__WEBPACK_IMPORTED_MODULE_17__.StandardMaterial("targetMat", scene);
            targetMat.specularColor = _Maths_math_color__WEBPACK_IMPORTED_MODULE_9__.Color3.Black();
            targetMat.emissiveColor = new _Maths_math_color__WEBPACK_IMPORTED_MODULE_9__.Color3(0.7, 0.7, 0.7);
            targetMat.backFaceCulling = false;
            this._gazeTracker.material = targetMat;
        }
        else {
            this._gazeTracker = gazeTrackerToClone.clone("gazeTracker");
        }
    }
    /** @hidden */
    VRExperienceHelperGazer.prototype._getForwardRay = function (length) {
        return new _Culling_ray__WEBPACK_IMPORTED_MODULE_15__.Ray(_Maths_math_vector__WEBPACK_IMPORTED_MODULE_8__.Vector3.Zero(), new _Maths_math_vector__WEBPACK_IMPORTED_MODULE_8__.Vector3(0, 0, length));
    };
    /** @hidden */
    VRExperienceHelperGazer.prototype._selectionPointerDown = function () {
        this._pointerDownOnMeshAsked = true;
        if (this._currentHit) {
            this.scene.simulatePointerDown(this._currentHit, { pointerId: this._id });
        }
    };
    /** @hidden */
    VRExperienceHelperGazer.prototype._selectionPointerUp = function () {
        if (this._currentHit) {
            this.scene.simulatePointerUp(this._currentHit, { pointerId: this._id });
        }
        this._pointerDownOnMeshAsked = false;
    };
    /** @hidden */
    VRExperienceHelperGazer.prototype._activatePointer = function () {
        this._activePointer = true;
    };
    /** @hidden */
    VRExperienceHelperGazer.prototype._deactivatePointer = function () {
        this._activePointer = false;
    };
    /** @hidden */
    VRExperienceHelperGazer.prototype._updatePointerDistance = function (distance) {
        if (distance === void 0) { distance = 100; }
    };
    VRExperienceHelperGazer.prototype.dispose = function () {
        this._interactionsEnabled = false;
        this._teleportationEnabled = false;
        if (this._gazeTracker) {
            this._gazeTracker.dispose();
        }
    };
    VRExperienceHelperGazer._idCounter = 0;
    return VRExperienceHelperGazer;
}());
var VRExperienceHelperControllerGazer = /** @class */ (function (_super) {
    (0,tslib__WEBPACK_IMPORTED_MODULE_31__.__extends)(VRExperienceHelperControllerGazer, _super);
    function VRExperienceHelperControllerGazer(webVRController, scene, gazeTrackerToClone) {
        var _this = _super.call(this, scene, gazeTrackerToClone) || this;
        _this.webVRController = webVRController;
        // Laser pointer
        _this._laserPointer = _Meshes_mesh__WEBPACK_IMPORTED_MODULE_14__.Mesh.CreateCylinder("laserPointer", 1, 0.004, 0.0002, 20, 1, scene, false);
        var laserPointerMaterial = new _Materials_standardMaterial__WEBPACK_IMPORTED_MODULE_17__.StandardMaterial("laserPointerMat", scene);
        laserPointerMaterial.emissiveColor = new _Maths_math_color__WEBPACK_IMPORTED_MODULE_9__.Color3(0.7, 0.7, 0.7);
        laserPointerMaterial.alpha = 0.6;
        _this._laserPointer.material = laserPointerMaterial;
        _this._laserPointer.rotation.x = Math.PI / 2;
        _this._laserPointer.position.z = -0.5;
        _this._laserPointer.isVisible = false;
        _this._laserPointer.isPickable = false;
        if (!webVRController.mesh) {
            // Create an empty mesh that is used prior to loading the high quality model
            var preloadMesh = new _Meshes_mesh__WEBPACK_IMPORTED_MODULE_14__.Mesh("preloadControllerMesh", scene);
            var preloadPointerPose = new _Meshes_mesh__WEBPACK_IMPORTED_MODULE_14__.Mesh(_Gamepads_Controllers_poseEnabledController__WEBPACK_IMPORTED_MODULE_11__.PoseEnabledController.POINTING_POSE, scene);
            preloadPointerPose.rotation.x = -0.7;
            preloadMesh.addChild(preloadPointerPose);
            webVRController.attachToMesh(preloadMesh);
        }
        _this._setLaserPointerParent(webVRController.mesh);
        _this._meshAttachedObserver = webVRController._meshAttachedObservable.add(function (mesh) {
            _this._setLaserPointerParent(mesh);
        });
        return _this;
    }
    VRExperienceHelperControllerGazer.prototype._getForwardRay = function (length) {
        return this.webVRController.getForwardRay(length);
    };
    /** @hidden */
    VRExperienceHelperControllerGazer.prototype._activatePointer = function () {
        _super.prototype._activatePointer.call(this);
        this._laserPointer.isVisible = true;
    };
    /** @hidden */
    VRExperienceHelperControllerGazer.prototype._deactivatePointer = function () {
        _super.prototype._deactivatePointer.call(this);
        this._laserPointer.isVisible = false;
    };
    /** @hidden */
    VRExperienceHelperControllerGazer.prototype._setLaserPointerColor = function (color) {
        this._laserPointer.material.emissiveColor = color;
    };
    /** @hidden */
    VRExperienceHelperControllerGazer.prototype._setLaserPointerLightingDisabled = function (disabled) {
        this._laserPointer.material.disableLighting = disabled;
    };
    /** @hidden */
    VRExperienceHelperControllerGazer.prototype._setLaserPointerParent = function (mesh) {
        var makeNotPick = function (root) {
            root.isPickable = false;
            root.getChildMeshes().forEach(function (c) {
                makeNotPick(c);
            });
        };
        makeNotPick(mesh);
        var meshChildren = mesh.getChildren(undefined, false);
        var laserParent = mesh;
        this.webVRController._pointingPoseNode = null;
        for (var i = 0; i < meshChildren.length; i++) {
            if (meshChildren[i].name && meshChildren[i].name.indexOf(_Gamepads_Controllers_poseEnabledController__WEBPACK_IMPORTED_MODULE_11__.PoseEnabledController.POINTING_POSE) >= 0) {
                laserParent = meshChildren[i];
                this.webVRController._pointingPoseNode = laserParent;
                break;
            }
        }
        this._laserPointer.parent = laserParent;
    };
    VRExperienceHelperControllerGazer.prototype._updatePointerDistance = function (distance) {
        if (distance === void 0) { distance = 100; }
        this._laserPointer.scaling.y = distance;
        this._laserPointer.position.z = -distance / 2;
    };
    VRExperienceHelperControllerGazer.prototype.dispose = function () {
        _super.prototype.dispose.call(this);
        this._laserPointer.dispose();
        if (this._meshAttachedObserver) {
            this.webVRController._meshAttachedObservable.remove(this._meshAttachedObserver);
        }
    };
    return VRExperienceHelperControllerGazer;
}(VRExperienceHelperGazer));
var VRExperienceHelperCameraGazer = /** @class */ (function (_super) {
    (0,tslib__WEBPACK_IMPORTED_MODULE_31__.__extends)(VRExperienceHelperCameraGazer, _super);
    function VRExperienceHelperCameraGazer(getCamera, scene) {
        var _this = _super.call(this, scene) || this;
        _this.getCamera = getCamera;
        return _this;
    }
    VRExperienceHelperCameraGazer.prototype._getForwardRay = function (length) {
        var camera = this.getCamera();
        if (camera) {
            return camera.getForwardRay(length);
        }
        else {
            return new _Culling_ray__WEBPACK_IMPORTED_MODULE_15__.Ray(_Maths_math_vector__WEBPACK_IMPORTED_MODULE_8__.Vector3.Zero(), _Maths_math_vector__WEBPACK_IMPORTED_MODULE_8__.Vector3.Forward());
        }
    };
    return VRExperienceHelperCameraGazer;
}(VRExperienceHelperGazer));
/**
 * Event containing information after VR has been entered
 */
var OnAfterEnteringVRObservableEvent = /** @class */ (function () {
    function OnAfterEnteringVRObservableEvent() {
    }
    return OnAfterEnteringVRObservableEvent;
}());

/**
 * Helps to quickly add VR support to an existing scene.
 * See http://doc.babylonjs.com/how_to/webvr_helper
 */
var VRExperienceHelper = /** @class */ (function () {
    /**
     * Instantiates a VRExperienceHelper.
     * Helps to quickly add VR support to an existing scene.
     * @param scene The scene the VRExperienceHelper belongs to.
     * @param webVROptions Options to modify the vr experience helper's behavior.
     */
    function VRExperienceHelper(scene, 
    /** Options to modify the vr experience helper's behavior. */
    webVROptions) {
        var _this = this;
        if (webVROptions === void 0) { webVROptions = {}; }
        this.webVROptions = webVROptions;
        // Can the system support WebVR, even if a headset isn't plugged in?
        this._webVRsupported = false;
        // If WebVR is supported, is a headset plugged in and are we ready to present?
        this._webVRready = false;
        // Are we waiting for the requestPresent callback to complete?
        this._webVRrequesting = false;
        // Are we presenting to the headset right now? (this is the vrDevice state)
        this._webVRpresenting = false;
        // Are we presenting in the fullscreen fallback?
        this._fullscreenVRpresenting = false;
        /**
         * Gets or sets a boolean indicating that gaze can be enabled even if pointer lock is not engage (useful on iOS where fullscreen mode and pointer lock are not supported)
         */
        this.enableGazeEvenWhenNoPointerLock = false;
        /**
         * Gets or sets a boolean indicating that the VREXperienceHelper will exit VR if double tap is detected
         */
        this.exitVROnDoubleTap = true;
        /**
         * Observable raised right before entering VR.
         */
        this.onEnteringVRObservable = new _Misc_observable__WEBPACK_IMPORTED_MODULE_1__.Observable();
        /**
         * Observable raised when entering VR has completed.
         */
        this.onAfterEnteringVRObservable = new _Misc_observable__WEBPACK_IMPORTED_MODULE_1__.Observable();
        /**
         * Observable raised when exiting VR.
         */
        this.onExitingVRObservable = new _Misc_observable__WEBPACK_IMPORTED_MODULE_1__.Observable();
        /**
         * Observable raised when controller mesh is loaded.
         */
        this.onControllerMeshLoadedObservable = new _Misc_observable__WEBPACK_IMPORTED_MODULE_1__.Observable();
        this._useCustomVRButton = false;
        this._teleportationRequested = false;
        this._teleportActive = false;
        this._floorMeshesCollection = [];
        this._teleportationMode = VRExperienceHelper.TELEPORTATIONMODE_CONSTANTTIME;
        this._teleportationTime = 122;
        this._teleportationSpeed = 20;
        this._rotationAllowed = true;
        this._teleportBackwardsVector = new _Maths_math_vector__WEBPACK_IMPORTED_MODULE_8__.Vector3(0, -1, -1);
        this._isDefaultTeleportationTarget = true;
        this._teleportationFillColor = "#444444";
        this._teleportationBorderColor = "#FFFFFF";
        this._rotationAngle = 0;
        this._haloCenter = new _Maths_math_vector__WEBPACK_IMPORTED_MODULE_8__.Vector3(0, 0, 0);
        this._padSensibilityUp = 0.65;
        this._padSensibilityDown = 0.35;
        this._leftController = null;
        this._rightController = null;
        this._gazeColor = new _Maths_math_color__WEBPACK_IMPORTED_MODULE_9__.Color3(0.7, 0.7, 0.7);
        this._laserColor = new _Maths_math_color__WEBPACK_IMPORTED_MODULE_9__.Color3(0.7, 0.7, 0.7);
        this._pickedLaserColor = new _Maths_math_color__WEBPACK_IMPORTED_MODULE_9__.Color3(0.2, 0.2, 1);
        this._pickedGazeColor = new _Maths_math_color__WEBPACK_IMPORTED_MODULE_9__.Color3(0, 0, 1);
        /**
         * Observable raised when a new mesh is selected based on meshSelectionPredicate
         */
        this.onNewMeshSelected = new _Misc_observable__WEBPACK_IMPORTED_MODULE_1__.Observable();
        /**
         * Observable raised when a new mesh is selected based on meshSelectionPredicate.
         * This observable will provide the mesh and the controller used to select the mesh
         */
        this.onMeshSelectedWithController = new _Misc_observable__WEBPACK_IMPORTED_MODULE_1__.Observable();
        /**
         * Observable raised when a new mesh is picked based on meshSelectionPredicate
         */
        this.onNewMeshPicked = new _Misc_observable__WEBPACK_IMPORTED_MODULE_1__.Observable();
        /**
         * Observable raised before camera teleportation
        */
        this.onBeforeCameraTeleport = new _Misc_observable__WEBPACK_IMPORTED_MODULE_1__.Observable();
        /**
         *  Observable raised after camera teleportation
        */
        this.onAfterCameraTeleport = new _Misc_observable__WEBPACK_IMPORTED_MODULE_1__.Observable();
        /**
        * Observable raised when current selected mesh gets unselected
        */
        this.onSelectedMeshUnselected = new _Misc_observable__WEBPACK_IMPORTED_MODULE_1__.Observable();
        /**
         * Set teleportation enabled. If set to false camera teleportation will be disabled but camera rotation will be kept.
         */
        this.teleportationEnabled = true;
        this._teleportationInitialized = false;
        this._interactionsEnabled = false;
        this._interactionsRequested = false;
        this._displayGaze = true;
        this._displayLaserPointer = true;
        /**
         * If the gaze trackers scale should be updated to be constant size when pointing at near/far meshes
         */
        this.updateGazeTrackerScale = true;
        /**
         * If the gaze trackers color should be updated when selecting meshes
         */
        this.updateGazeTrackerColor = true;
        /**
         * If the controller laser color should be updated when selecting meshes
         */
        this.updateControllerLaserColor = true;
        /**
         * Defines whether or not Pointer lock should be requested when switching to
         * full screen.
         */
        this.requestPointerLockOnFullScreen = true;
        /**
         * Was the XR test done already. If this is true AND this.xr exists, xr is initialized.
         * If this is true and no this.xr, xr exists but is not supported, using WebVR.
         */
        this.xrTestDone = false;
        this._onResize = function () {
            _this.moveButtonToBottomRight();
            if (_this._fullscreenVRpresenting && _this._webVRready) {
                _this.exitVR();
            }
        };
        this._onFullscreenChange = function () {
            var anyDoc = document;
            if (anyDoc.fullscreen !== undefined) {
                _this._fullscreenVRpresenting = document.fullscreen;
            }
            else if (anyDoc.mozFullScreen !== undefined) {
                _this._fullscreenVRpresenting = anyDoc.mozFullScreen;
            }
            else if (anyDoc.webkitIsFullScreen !== undefined) {
                _this._fullscreenVRpresenting = anyDoc.webkitIsFullScreen;
            }
            else if (anyDoc.msIsFullScreen !== undefined) {
                _this._fullscreenVRpresenting = anyDoc.msIsFullScreen;
            }
            else if (document.msFullscreenElement !== undefined) {
                _this._fullscreenVRpresenting = document.msFullscreenElement;
            }
            if (!_this._fullscreenVRpresenting && _this._inputElement) {
                _this.exitVR();
                if (!_this._useCustomVRButton && _this._btnVR) {
                    _this._btnVR.style.top = _this._inputElement.offsetTop + _this._inputElement.offsetHeight - 70 + "px";
                    _this._btnVR.style.left = _this._inputElement.offsetLeft + _this._inputElement.offsetWidth - 100 + "px";
                    // make sure the button is visible after setting its position
                    _this.updateButtonVisibility();
                }
            }
        };
        this._cachedAngularSensibility = { angularSensibilityX: null, angularSensibilityY: null, angularSensibility: null };
        this.beforeRender = function () {
            if (_this._leftController && _this._leftController._activePointer) {
                _this._castRayAndSelectObject(_this._leftController);
            }
            if (_this._rightController && _this._rightController._activePointer) {
                _this._castRayAndSelectObject(_this._rightController);
            }
            if (_this._noControllerIsActive && (_this._scene.getEngine().isPointerLock || _this.enableGazeEvenWhenNoPointerLock)) {
                _this._castRayAndSelectObject(_this._cameraGazer);
            }
            else {
                _this._cameraGazer._gazeTracker.isVisible = false;
            }
        };
        this._onNewGamepadConnected = function (gamepad) {
            if (gamepad.type !== _Gamepads_gamepad__WEBPACK_IMPORTED_MODULE_10__.Gamepad.POSE_ENABLED) {
                if (gamepad.leftStick) {
                    gamepad.onleftstickchanged(function (stickValues) {
                        if (_this._teleportationInitialized && _this.teleportationEnabled) {
                            // Listening to classic/xbox gamepad only if no VR controller is active
                            if ((!_this._leftController && !_this._rightController) ||
                                ((_this._leftController && !_this._leftController._activePointer) &&
                                    (_this._rightController && !_this._rightController._activePointer))) {
                                _this._checkTeleportWithRay(stickValues, _this._cameraGazer);
                                _this._checkTeleportBackwards(stickValues, _this._cameraGazer);
                            }
                        }
                    });
                }
                if (gamepad.rightStick) {
                    gamepad.onrightstickchanged(function (stickValues) {
                        if (_this._teleportationInitialized) {
                            _this._checkRotate(stickValues, _this._cameraGazer);
                        }
                    });
                }
                if (gamepad.type === _Gamepads_gamepad__WEBPACK_IMPORTED_MODULE_10__.Gamepad.XBOX) {
                    gamepad.onbuttondown(function (buttonPressed) {
                        if (_this._interactionsEnabled && buttonPressed === _Gamepads_xboxGamepad__WEBPACK_IMPORTED_MODULE_13__.Xbox360Button.A) {
                            _this._cameraGazer._selectionPointerDown();
                        }
                    });
                    gamepad.onbuttonup(function (buttonPressed) {
                        if (_this._interactionsEnabled && buttonPressed === _Gamepads_xboxGamepad__WEBPACK_IMPORTED_MODULE_13__.Xbox360Button.A) {
                            _this._cameraGazer._selectionPointerUp();
                        }
                    });
                }
            }
            else {
                var webVRController = gamepad;
                var controller = new VRExperienceHelperControllerGazer(webVRController, _this._scene, _this._cameraGazer._gazeTracker);
                if (webVRController.hand === "right" || (_this._leftController && _this._leftController.webVRController != webVRController)) {
                    _this._rightController = controller;
                }
                else {
                    _this._leftController = controller;
                }
                _this._tryEnableInteractionOnController(controller);
            }
        };
        // This only succeeds if the controller's mesh exists for the controller so this must be called whenever new controller is connected or when mesh is loaded
        this._tryEnableInteractionOnController = function (controller) {
            if (_this._interactionsRequested && !controller._interactionsEnabled) {
                _this._enableInteractionOnController(controller);
            }
            if (_this._teleportationRequested && !controller._teleportationEnabled) {
                _this._enableTeleportationOnController(controller);
            }
        };
        this._onNewGamepadDisconnected = function (gamepad) {
            if (gamepad instanceof _Gamepads_Controllers_webVRController__WEBPACK_IMPORTED_MODULE_12__.WebVRController) {
                if (gamepad.hand === "left" && _this._leftController != null) {
                    _this._leftController.dispose();
                    _this._leftController = null;
                }
                if (gamepad.hand === "right" && _this._rightController != null) {
                    _this._rightController.dispose();
                    _this._rightController = null;
                }
            }
        };
        this._workingVector = _Maths_math_vector__WEBPACK_IMPORTED_MODULE_8__.Vector3.Zero();
        this._workingQuaternion = _Maths_math_vector__WEBPACK_IMPORTED_MODULE_8__.Quaternion.Identity();
        this._workingMatrix = _Maths_math_vector__WEBPACK_IMPORTED_MODULE_8__.Matrix.Identity();
        this._scene = scene;
        this._inputElement = scene.getEngine().getInputElement();
        // check for VR support:
        var vrSupported = 'getVRDisplays' in navigator;
        // no VR support? force XR
        if (!vrSupported) {
            webVROptions.useXR = true;
        }
        // Parse options
        if (webVROptions.createFallbackVRDeviceOrientationFreeCamera === undefined) {
            webVROptions.createFallbackVRDeviceOrientationFreeCamera = true;
        }
        if (webVROptions.createDeviceOrientationCamera === undefined) {
            webVROptions.createDeviceOrientationCamera = true;
        }
        if (webVROptions.laserToggle === undefined) {
            webVROptions.laserToggle = true;
        }
        if (webVROptions.defaultHeight === undefined) {
            webVROptions.defaultHeight = 1.7;
        }
        if (webVROptions.useCustomVRButton) {
            this._useCustomVRButton = true;
            if (webVROptions.customVRButton) {
                this._btnVR = webVROptions.customVRButton;
            }
        }
        if (webVROptions.rayLength) {
            this._rayLength = webVROptions.rayLength;
        }
        this._defaultHeight = webVROptions.defaultHeight;
        if (webVROptions.positionScale) {
            this._rayLength *= webVROptions.positionScale;
            this._defaultHeight *= webVROptions.positionScale;
        }
        this._hasEnteredVR = false;
        // Set position
        if (this._scene.activeCamera) {
            this._position = this._scene.activeCamera.position.clone();
        }
        else {
            this._position = new _Maths_math_vector__WEBPACK_IMPORTED_MODULE_8__.Vector3(0, this._defaultHeight, 0);
        }
        // Set non-vr camera
        if (webVROptions.createDeviceOrientationCamera || !this._scene.activeCamera) {
            this._deviceOrientationCamera = new _Cameras_deviceOrientationCamera__WEBPACK_IMPORTED_MODULE_4__.DeviceOrientationCamera("deviceOrientationVRHelper", this._position.clone(), scene);
            // Copy data from existing camera
            if (this._scene.activeCamera) {
                this._deviceOrientationCamera.minZ = this._scene.activeCamera.minZ;
                this._deviceOrientationCamera.maxZ = this._scene.activeCamera.maxZ;
                // Set rotation from previous camera
                if (this._scene.activeCamera instanceof _Cameras_targetCamera__WEBPACK_IMPORTED_MODULE_3__.TargetCamera && this._scene.activeCamera.rotation) {
                    var targetCamera = this._scene.activeCamera;
                    if (targetCamera.rotationQuaternion) {
                        this._deviceOrientationCamera.rotationQuaternion.copyFrom(targetCamera.rotationQuaternion);
                    }
                    else {
                        this._deviceOrientationCamera.rotationQuaternion.copyFrom(_Maths_math_vector__WEBPACK_IMPORTED_MODULE_8__.Quaternion.RotationYawPitchRoll(targetCamera.rotation.y, targetCamera.rotation.x, targetCamera.rotation.z));
                    }
                    this._deviceOrientationCamera.rotation = targetCamera.rotation.clone();
                }
            }
            this._scene.activeCamera = this._deviceOrientationCamera;
            if (this._inputElement) {
                this._scene.activeCamera.attachControl(this._inputElement);
            }
        }
        else {
            this._existingCamera = this._scene.activeCamera;
        }
        if (this.webVROptions.useXR && navigator.xr) {
            // force-check XR session support
            _XR_webXRSessionManager__WEBPACK_IMPORTED_MODULE_29__.WebXRSessionManager.IsSessionSupportedAsync("immersive-vr").then(function (supported) {
                if (supported) {
                    _Misc_logger__WEBPACK_IMPORTED_MODULE_0__.Logger.Log("Using WebXR. It is recommended to use the WebXRDefaultExperience directly");
                    // it is possible to use XR, let's do it!
                    scene.createDefaultXRExperienceAsync({
                        floorMeshes: webVROptions.floorMeshes || []
                    }).then(function (xr) {
                        _this.xr = xr;
                        // connect observables
                        _this.xrTestDone = true;
                        _this._cameraGazer = new VRExperienceHelperCameraGazer(function () { return _this.xr.baseExperience.camera; }, scene);
                        _this.xr.baseExperience.onStateChangedObservable.add(function (state) {
                            // support for entering / exiting
                            switch (state) {
                                case _XR_webXRTypes__WEBPACK_IMPORTED_MODULE_30__.WebXRState.ENTERING_XR:
                                    _this.onEnteringVRObservable.notifyObservers(_this);
                                    if (!_this._interactionsEnabled) {
                                        _this.xr.pointerSelection.detach();
                                    }
                                    _this.xr.pointerSelection.displayLaserPointer = _this._displayLaserPointer;
                                    break;
                                case _XR_webXRTypes__WEBPACK_IMPORTED_MODULE_30__.WebXRState.EXITING_XR:
                                    _this.onExitingVRObservable.notifyObservers(_this);
                                    // resize to update width and height when exiting vr exits fullscreen
                                    _this._scene.getEngine().resize();
                                    break;
                                case _XR_webXRTypes__WEBPACK_IMPORTED_MODULE_30__.WebXRState.IN_XR:
                                    _this._hasEnteredVR = true;
                                    break;
                                case _XR_webXRTypes__WEBPACK_IMPORTED_MODULE_30__.WebXRState.NOT_IN_XR:
                                    _this._hasEnteredVR = false;
                                    break;
                            }
                        });
                    });
                }
                else {
                    // XR not supported (thou exists), continue WebVR init
                    _this.completeVRInit(scene, webVROptions);
                }
            });
        }
        else {
            // no XR, continue init synchronous
            this.completeVRInit(scene, webVROptions);
        }
    }
    Object.defineProperty(VRExperienceHelper.prototype, "onEnteringVR", {
        /** Return this.onEnteringVRObservable
         * Note: This one is for backward compatibility. Please use onEnteringVRObservable directly
         */
        get: function () {
            return this.onEnteringVRObservable;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(VRExperienceHelper.prototype, "onExitingVR", {
        /** Return this.onExitingVRObservable
         * Note: This one is for backward compatibility. Please use onExitingVRObservable directly
         */
        get: function () {
            return this.onExitingVRObservable;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(VRExperienceHelper.prototype, "onControllerMeshLoaded", {
        /** Return this.onControllerMeshLoadedObservable
         * Note: This one is for backward compatibility. Please use onControllerMeshLoadedObservable directly
         */
        get: function () {
            return this.onControllerMeshLoadedObservable;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(VRExperienceHelper.prototype, "teleportationTarget", {
        /**
         * The mesh used to display where the user is going to teleport.
         */
        get: function () {
            return this._teleportationTarget;
        },
        /**
         * Sets the mesh to be used to display where the user is going to teleport.
         */
        set: function (value) {
            if (value) {
                value.name = "teleportationTarget";
                this._isDefaultTeleportationTarget = false;
                this._teleportationTarget = value;
            }
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(VRExperienceHelper.prototype, "gazeTrackerMesh", {
        /**
         * The mesh used to display where the user is selecting, this mesh will be cloned and set as the gazeTracker for the left and right controller
         * when set bakeCurrentTransformIntoVertices will be called on the mesh.
         * See http://doc.babylonjs.com/resources/baking_transformations
         */
        get: function () {
            return this._cameraGazer._gazeTracker;
        },
        set: function (value) {
            if (value) {
                // Dispose of existing meshes
                if (this._cameraGazer._gazeTracker) {
                    this._cameraGazer._gazeTracker.dispose();
                }
                if (this._leftController && this._leftController._gazeTracker) {
                    this._leftController._gazeTracker.dispose();
                }
                if (this._rightController && this._rightController._gazeTracker) {
                    this._rightController._gazeTracker.dispose();
                }
                // Set and create gaze trackers on head and controllers
                this._cameraGazer._gazeTracker = value;
                this._cameraGazer._gazeTracker.bakeCurrentTransformIntoVertices();
                this._cameraGazer._gazeTracker.isPickable = false;
                this._cameraGazer._gazeTracker.isVisible = false;
                this._cameraGazer._gazeTracker.name = "gazeTracker";
                if (this._leftController) {
                    this._leftController._gazeTracker = this._cameraGazer._gazeTracker.clone("gazeTracker");
                }
                if (this._rightController) {
                    this._rightController._gazeTracker = this._cameraGazer._gazeTracker.clone("gazeTracker");
                }
            }
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(VRExperienceHelper.prototype, "leftControllerGazeTrackerMesh", {
        /**
         * The gaze tracking mesh corresponding to the left controller
         */
        get: function () {
            if (this._leftController) {
                return this._leftController._gazeTracker;
            }
            return null;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(VRExperienceHelper.prototype, "rightControllerGazeTrackerMesh", {
        /**
         * The gaze tracking mesh corresponding to the right controller
         */
        get: function () {
            if (this._rightController) {
                return this._rightController._gazeTracker;
            }
            return null;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(VRExperienceHelper.prototype, "displayGaze", {
        /**
         * If the ray of the gaze should be displayed.
         */
        get: function () {
            return this._displayGaze;
        },
        /**
         * Sets if the ray of the gaze should be displayed.
         */
        set: function (value) {
            this._displayGaze = value;
            if (!value) {
                this._cameraGazer._gazeTracker.isVisible = false;
                if (this._leftController) {
                    this._leftController._gazeTracker.isVisible = false;
                }
                if (this._rightController) {
                    this._rightController._gazeTracker.isVisible = false;
                }
            }
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(VRExperienceHelper.prototype, "displayLaserPointer", {
        /**
         * If the ray of the LaserPointer should be displayed.
         */
        get: function () {
            return this._displayLaserPointer;
        },
        /**
         * Sets if the ray of the LaserPointer should be displayed.
         */
        set: function (value) {
            this._displayLaserPointer = value;
            if (!value) {
                if (this._rightController) {
                    this._rightController._deactivatePointer();
                    this._rightController._gazeTracker.isVisible = false;
                }
                if (this._leftController) {
                    this._leftController._deactivatePointer();
                    this._leftController._gazeTracker.isVisible = false;
                }
            }
            else {
                if (this._rightController) {
                    this._rightController._activatePointer();
                }
                if (this._leftController) {
                    this._leftController._activatePointer();
                }
            }
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(VRExperienceHelper.prototype, "deviceOrientationCamera", {
        /**
         * The deviceOrientationCamera used as the camera when not in VR.
         */
        get: function () {
            return this._deviceOrientationCamera;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(VRExperienceHelper.prototype, "currentVRCamera", {
        /**
         * Based on the current WebVR support, returns the current VR camera used.
         */
        get: function () {
            if (this._webVRready) {
                return this._webVRCamera;
            }
            else {
                return this._scene.activeCamera;
            }
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(VRExperienceHelper.prototype, "webVRCamera", {
        /**
         * The webVRCamera which is used when in VR.
         */
        get: function () {
            return this._webVRCamera;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(VRExperienceHelper.prototype, "vrDeviceOrientationCamera", {
        /**
         * The deviceOrientationCamera that is used as a fallback when vr device is not connected.
         */
        get: function () {
            return this._vrDeviceOrientationCamera;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(VRExperienceHelper.prototype, "vrButton", {
        /**
         * The html button that is used to trigger entering into VR.
         */
        get: function () {
            return this._btnVR;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(VRExperienceHelper.prototype, "_teleportationRequestInitiated", {
        get: function () {
            var result = this._cameraGazer._teleportationRequestInitiated
                || (this._leftController !== null && this._leftController._teleportationRequestInitiated)
                || (this._rightController !== null && this._rightController._teleportationRequestInitiated);
            return result;
        },
        enumerable: true,
        configurable: true
    });
    VRExperienceHelper.prototype.completeVRInit = function (scene, webVROptions) {
        var _this = this;
        this.xrTestDone = true;
        // Create VR cameras
        if (webVROptions.createFallbackVRDeviceOrientationFreeCamera) {
            if (webVROptions.useMultiview) {
                if (!webVROptions.vrDeviceOrientationCameraMetrics) {
                    webVROptions.vrDeviceOrientationCameraMetrics = _Cameras_VR_vrCameraMetrics__WEBPACK_IMPORTED_MODULE_22__.VRCameraMetrics.GetDefault();
                }
                webVROptions.vrDeviceOrientationCameraMetrics.multiviewEnabled = true;
            }
            this._vrDeviceOrientationCamera = new _Cameras_VR_vrDeviceOrientationFreeCamera__WEBPACK_IMPORTED_MODULE_5__.VRDeviceOrientationFreeCamera("VRDeviceOrientationVRHelper", this._position, this._scene, true, webVROptions.vrDeviceOrientationCameraMetrics);
            this._vrDeviceOrientationCamera.angularSensibility = Number.MAX_VALUE;
        }
        this._webVRCamera = new _Cameras_VR_webVRCamera__WEBPACK_IMPORTED_MODULE_6__.WebVRFreeCamera("WebVRHelper", this._position, this._scene, webVROptions);
        this._webVRCamera.useStandingMatrix();
        this._cameraGazer = new VRExperienceHelperCameraGazer(function () { return _this.currentVRCamera; }, scene);
        // Create default button
        if (!this._useCustomVRButton) {
            this._btnVR = document.createElement("BUTTON");
            this._btnVR.className = "babylonVRicon";
            this._btnVR.id = "babylonVRiconbtn";
            this._btnVR.title = "Click to switch to VR";
            var url = !window.SVGSVGElement ? "https://cdn.babylonjs.com/Assets/vrButton.png" : "data:image/svg+xml;charset=UTF-8,%3Csvg%20xmlns%3D%22http%3A//www.w3.org/2000/svg%22%20width%3D%222048%22%20height%3D%221152%22%20viewBox%3D%220%200%202048%201152%22%20version%3D%221.1%22%3E%3Cpath%20transform%3D%22rotate%28180%201024%2C576.0000000000001%29%22%20d%3D%22m1109%2C896q17%2C0%2030%2C-12t13%2C-30t-12.5%2C-30.5t-30.5%2C-12.5l-170%2C0q-18%2C0%20-30.5%2C12.5t-12.5%2C30.5t13%2C30t30%2C12l170%2C0zm-85%2C256q59%2C0%20132.5%2C-1.5t154.5%2C-5.5t164.5%2C-11.5t163%2C-20t150%2C-30t124.5%2C-41.5q23%2C-11%2042%2C-24t38%2C-30q27%2C-25%2041%2C-61.5t14%2C-72.5l0%2C-257q0%2C-123%20-47%2C-232t-128%2C-190t-190%2C-128t-232%2C-47l-81%2C0q-37%2C0%20-68.5%2C14t-60.5%2C34.5t-55.5%2C45t-53%2C45t-53%2C34.5t-55.5%2C14t-55.5%2C-14t-53%2C-34.5t-53%2C-45t-55.5%2C-45t-60.5%2C-34.5t-68.5%2C-14l-81%2C0q-123%2C0%20-232%2C47t-190%2C128t-128%2C190t-47%2C232l0%2C257q0%2C68%2038%2C115t97%2C73q54%2C24%20124.5%2C41.5t150%2C30t163%2C20t164.5%2C11.5t154.5%2C5.5t132.5%2C1.5zm939%2C-298q0%2C39%20-24.5%2C67t-58.5%2C42q-54%2C23%20-122%2C39.5t-143.5%2C28t-155.5%2C19t-157%2C11t-148.5%2C5t-129.5%2C1.5q-59%2C0%20-130%2C-1.5t-148%2C-5t-157%2C-11t-155.5%2C-19t-143.5%2C-28t-122%2C-39.5q-34%2C-14%20-58.5%2C-42t-24.5%2C-67l0%2C-257q0%2C-106%2040.5%2C-199t110%2C-162.5t162.5%2C-109.5t199%2C-40l81%2C0q27%2C0%2052%2C14t50%2C34.5t51%2C44.5t55.5%2C44.5t63.5%2C34.5t74%2C14t74%2C-14t63.5%2C-34.5t55.5%2C-44.5t51%2C-44.5t50%2C-34.5t52%2C-14l14%2C0q37%2C0%2070%2C0.5t64.5%2C4.5t63.5%2C12t68%2C23q71%2C30%20128.5%2C78.5t98.5%2C110t63.5%2C133.5t22.5%2C149l0%2C257z%22%20fill%3D%22white%22%20/%3E%3C/svg%3E%0A";
            var css = ".babylonVRicon { position: absolute; right: 20px; height: 50px; width: 80px; background-color: rgba(51,51,51,0.7); background-image: url(" + url + "); background-size: 80%; background-repeat:no-repeat; background-position: center; border: none; outline: none; transition: transform 0.125s ease-out } .babylonVRicon:hover { transform: scale(1.05) } .babylonVRicon:active {background-color: rgba(51,51,51,1) } .babylonVRicon:focus {background-color: rgba(51,51,51,1) }";
            css += ".babylonVRicon.vrdisplaypresenting { display: none; }";
            // TODO: Add user feedback so that they know what state the VRDisplay is in (disconnected, connected, entering-VR)
            // css += ".babylonVRicon.vrdisplaysupported { }";
            // css += ".babylonVRicon.vrdisplayready { }";
            // css += ".babylonVRicon.vrdisplayrequesting { }";
            var style = document.createElement('style');
            style.appendChild(document.createTextNode(css));
            document.getElementsByTagName('head')[0].appendChild(style);
            this.moveButtonToBottomRight();
        }
        // VR button click event
        if (this._btnVR) {
            this._btnVR.addEventListener("click", function () {
                if (!_this.isInVRMode) {
                    _this.enterVR();
                }
                else {
                    _this._scene.getEngine().disableVR();
                }
            });
        }
        // Window events
        var hostWindow = this._scene.getEngine().getHostWindow();
        if (!hostWindow) {
            return;
        }
        hostWindow.addEventListener("resize", this._onResize);
        document.addEventListener("fullscreenchange", this._onFullscreenChange, false);
        document.addEventListener("mozfullscreenchange", this._onFullscreenChange, false);
        document.addEventListener("webkitfullscreenchange", this._onFullscreenChange, false);
        document.addEventListener("msfullscreenchange", this._onFullscreenChange, false);
        document.onmsfullscreenchange = this._onFullscreenChange;
        // Display vr button when headset is connected
        if (webVROptions.createFallbackVRDeviceOrientationFreeCamera) {
            this.displayVRButton();
        }
        else {
            this._scene.getEngine().onVRDisplayChangedObservable.add(function (e) {
                if (e.vrDisplay) {
                    _this.displayVRButton();
                }
            });
        }
        // Exiting VR mode using 'ESC' key on desktop
        this._onKeyDown = function (event) {
            if (event.keyCode === 27 && _this.isInVRMode) {
                _this.exitVR();
            }
        };
        document.addEventListener("keydown", this._onKeyDown);
        // Exiting VR mode double tapping the touch screen
        this._scene.onPrePointerObservable.add(function () {
            if (_this._hasEnteredVR && _this.exitVROnDoubleTap) {
                _this.exitVR();
                if (_this._fullscreenVRpresenting) {
                    _this._scene.getEngine().exitFullscreen();
                }
            }
        }, _Events_pointerEvents__WEBPACK_IMPORTED_MODULE_7__.PointerEventTypes.POINTERDOUBLETAP, false);
        // Listen for WebVR display changes
        this._onVRDisplayChanged = function (eventArgs) { return _this.onVRDisplayChanged(eventArgs); };
        this._onVrDisplayPresentChange = function () { return _this.onVrDisplayPresentChange(); };
        this._onVRRequestPresentStart = function () {
            _this._webVRrequesting = true;
            _this.updateButtonVisibility();
        };
        this._onVRRequestPresentComplete = function () {
            _this._webVRrequesting = false;
            _this.updateButtonVisibility();
        };
        scene.getEngine().onVRDisplayChangedObservable.add(this._onVRDisplayChanged);
        scene.getEngine().onVRRequestPresentStart.add(this._onVRRequestPresentStart);
        scene.getEngine().onVRRequestPresentComplete.add(this._onVRRequestPresentComplete);
        hostWindow.addEventListener('vrdisplaypresentchange', this._onVrDisplayPresentChange);
        scene.onDisposeObservable.add(function () {
            _this.dispose();
        });
        // Gamepad connection events
        this._webVRCamera.onControllerMeshLoadedObservable.add(function (webVRController) { return _this._onDefaultMeshLoaded(webVRController); });
        this._scene.gamepadManager.onGamepadConnectedObservable.add(this._onNewGamepadConnected);
        this._scene.gamepadManager.onGamepadDisconnectedObservable.add(this._onNewGamepadDisconnected);
        this.updateButtonVisibility();
        //create easing functions
        this._circleEase = new _Animations_easing__WEBPACK_IMPORTED_MODULE_20__.CircleEase();
        this._circleEase.setEasingMode(_Animations_easing__WEBPACK_IMPORTED_MODULE_20__.EasingFunction.EASINGMODE_EASEINOUT);
        this._teleportationEasing = this._circleEase;
        // Allow clicking in the vrDeviceOrientationCamera
        scene.onPointerObservable.add(function (e) {
            if (_this._interactionsEnabled) {
                if (scene.activeCamera === _this.vrDeviceOrientationCamera && e.event.pointerType === "mouse") {
                    if (e.type === _Events_pointerEvents__WEBPACK_IMPORTED_MODULE_7__.PointerEventTypes.POINTERDOWN) {
                        _this._cameraGazer._selectionPointerDown();
                    }
                    else if (e.type === _Events_pointerEvents__WEBPACK_IMPORTED_MODULE_7__.PointerEventTypes.POINTERUP) {
                        _this._cameraGazer._selectionPointerUp();
                    }
                }
            }
        });
        if (this.webVROptions.floorMeshes) {
            this.enableTeleportation({ floorMeshes: this.webVROptions.floorMeshes });
        }
    };
    // Raised when one of the controller has loaded successfully its associated default mesh
    VRExperienceHelper.prototype._onDefaultMeshLoaded = function (webVRController) {
        if (this._leftController && this._leftController.webVRController == webVRController) {
            if (webVRController.mesh) {
                this._leftController._setLaserPointerParent(webVRController.mesh);
            }
        }
        if (this._rightController && this._rightController.webVRController == webVRController) {
            if (webVRController.mesh) {
                this._rightController._setLaserPointerParent(webVRController.mesh);
            }
        }
        try {
            this.onControllerMeshLoadedObservable.notifyObservers(webVRController);
        }
        catch (err) {
            _Misc_logger__WEBPACK_IMPORTED_MODULE_0__.Logger.Warn("Error in your custom logic onControllerMeshLoaded: " + err);
        }
    };
    Object.defineProperty(VRExperienceHelper.prototype, "isInVRMode", {
        /**
         * Gets a value indicating if we are currently in VR mode.
         */
        get: function () {
            return (this.xr && this.webVROptions.useXR && this.xr.baseExperience.state === _XR_webXRTypes__WEBPACK_IMPORTED_MODULE_30__.WebXRState.IN_XR) || (this._webVRpresenting || this._fullscreenVRpresenting);
        },
        enumerable: true,
        configurable: true
    });
    VRExperienceHelper.prototype.onVrDisplayPresentChange = function () {
        var vrDisplay = this._scene.getEngine().getVRDevice();
        if (vrDisplay) {
            var wasPresenting = this._webVRpresenting;
            this._webVRpresenting = vrDisplay.isPresenting;
            if (wasPresenting && !this._webVRpresenting) {
                this.exitVR();
            }
        }
        else {
            _Misc_logger__WEBPACK_IMPORTED_MODULE_0__.Logger.Warn('Detected VRDisplayPresentChange on an unknown VRDisplay. Did you can enterVR on the vrExperienceHelper?');
        }
        this.updateButtonVisibility();
    };
    VRExperienceHelper.prototype.onVRDisplayChanged = function (eventArgs) {
        this._webVRsupported = eventArgs.vrSupported;
        this._webVRready = !!eventArgs.vrDisplay;
        this._webVRpresenting = eventArgs.vrDisplay && eventArgs.vrDisplay.isPresenting;
        this.updateButtonVisibility();
    };
    VRExperienceHelper.prototype.moveButtonToBottomRight = function () {
        if (this._inputElement && !this._useCustomVRButton && this._btnVR) {
            var rect = this._inputElement.getBoundingClientRect();
            this._btnVR.style.top = rect.top + rect.height - 70 + "px";
            this._btnVR.style.left = rect.left + rect.width - 100 + "px";
        }
    };
    VRExperienceHelper.prototype.displayVRButton = function () {
        if (!this._useCustomVRButton && !this._btnVRDisplayed && this._btnVR) {
            document.body.appendChild(this._btnVR);
            this._btnVRDisplayed = true;
        }
    };
    VRExperienceHelper.prototype.updateButtonVisibility = function () {
        if (!this._btnVR || this._useCustomVRButton) {
            return;
        }
        this._btnVR.className = "babylonVRicon";
        if (this.isInVRMode) {
            this._btnVR.className += " vrdisplaypresenting";
        }
        else {
            if (this._webVRready) {
                this._btnVR.className += " vrdisplayready";
            }
            if (this._webVRsupported) {
                this._btnVR.className += " vrdisplaysupported";
            }
            if (this._webVRrequesting) {
                this._btnVR.className += " vrdisplayrequesting";
            }
        }
    };
    /**
     * Attempt to enter VR. If a headset is connected and ready, will request present on that.
     * Otherwise, will use the fullscreen API.
     */
    VRExperienceHelper.prototype.enterVR = function () {
        var _this = this;
        if (this.xr) {
            this.xr.baseExperience.enterXRAsync("immersive-vr", "local-floor", this.xr.renderTarget);
            return;
        }
        if (this.onEnteringVRObservable) {
            try {
                this.onEnteringVRObservable.notifyObservers(this);
            }
            catch (err) {
                _Misc_logger__WEBPACK_IMPORTED_MODULE_0__.Logger.Warn("Error in your custom logic onEnteringVR: " + err);
            }
        }
        if (this._scene.activeCamera) {
            this._position = this._scene.activeCamera.position.clone();
            if (this.vrDeviceOrientationCamera) {
                this.vrDeviceOrientationCamera.rotation = _Maths_math_vector__WEBPACK_IMPORTED_MODULE_8__.Quaternion.FromRotationMatrix(this._scene.activeCamera.getWorldMatrix().getRotationMatrix()).toEulerAngles();
                this.vrDeviceOrientationCamera.angularSensibility = 2000;
            }
            if (this.webVRCamera) {
                var currentYRotation = this.webVRCamera.deviceRotationQuaternion.toEulerAngles().y;
                var desiredYRotation = _Maths_math_vector__WEBPACK_IMPORTED_MODULE_8__.Quaternion.FromRotationMatrix(this._scene.activeCamera.getWorldMatrix().getRotationMatrix()).toEulerAngles().y;
                var delta = desiredYRotation - currentYRotation;
                var currentGlobalRotation = this.webVRCamera.rotationQuaternion.toEulerAngles().y;
                this.webVRCamera.rotationQuaternion = _Maths_math_vector__WEBPACK_IMPORTED_MODULE_8__.Quaternion.FromEulerAngles(0, currentGlobalRotation + delta, 0);
            }
            // make sure that we return to the last active camera
            this._existingCamera = this._scene.activeCamera;
            // Remove and cache angular sensability to avoid camera rotation when in VR
            if (this._existingCamera.angularSensibilityX) {
                this._cachedAngularSensibility.angularSensibilityX = this._existingCamera.angularSensibilityX;
                this._existingCamera.angularSensibilityX = Number.MAX_VALUE;
            }
            if (this._existingCamera.angularSensibilityY) {
                this._cachedAngularSensibility.angularSensibilityY = this._existingCamera.angularSensibilityY;
                this._existingCamera.angularSensibilityY = Number.MAX_VALUE;
            }
            if (this._existingCamera.angularSensibility) {
                this._cachedAngularSensibility.angularSensibility = this._existingCamera.angularSensibility;
                this._existingCamera.angularSensibility = Number.MAX_VALUE;
            }
        }
        if (this._webVRrequesting) {
            return;
        }
        // If WebVR is supported and a headset is connected
        if (this._webVRready) {
            if (!this._webVRpresenting) {
                this._scene.getEngine().onVRRequestPresentComplete.addOnce(function (result) {
                    _this.onAfterEnteringVRObservable.notifyObservers({ success: result });
                });
                this._webVRCamera.position = this._position;
                this._scene.activeCamera = this._webVRCamera;
            }
        }
        else if (this._vrDeviceOrientationCamera) {
            this._vrDeviceOrientationCamera.position = this._position;
            if (this._scene.activeCamera) {
                this._vrDeviceOrientationCamera.minZ = this._scene.activeCamera.minZ;
            }
            this._scene.activeCamera = this._vrDeviceOrientationCamera;
            this._scene.getEngine().enterFullscreen(this.requestPointerLockOnFullScreen);
            this.updateButtonVisibility();
            this._vrDeviceOrientationCamera.onViewMatrixChangedObservable.addOnce(function () {
                _this.onAfterEnteringVRObservable.notifyObservers({ success: true });
            });
        }
        if (this._scene.activeCamera && this._inputElement) {
            this._scene.activeCamera.attachControl(this._inputElement);
        }
        if (this._interactionsEnabled) {
            this._scene.registerBeforeRender(this.beforeRender);
        }
        if (this._displayLaserPointer) {
            [this._leftController, this._rightController].forEach(function (controller) {
                if (controller) {
                    controller._activatePointer();
                }
            });
        }
        this._hasEnteredVR = true;
    };
    /**
     * Attempt to exit VR, or fullscreen.
     */
    VRExperienceHelper.prototype.exitVR = function () {
        if (this.xr) {
            this.xr.baseExperience.exitXRAsync();
            return;
        }
        if (this._hasEnteredVR) {
            if (this.onExitingVRObservable) {
                try {
                    this.onExitingVRObservable.notifyObservers(this);
                }
                catch (err) {
                    _Misc_logger__WEBPACK_IMPORTED_MODULE_0__.Logger.Warn("Error in your custom logic onExitingVR: " + err);
                }
            }
            if (this._webVRpresenting) {
                this._scene.getEngine().disableVR();
            }
            if (this._scene.activeCamera) {
                this._position = this._scene.activeCamera.position.clone();
            }
            if (this.vrDeviceOrientationCamera) {
                this.vrDeviceOrientationCamera.angularSensibility = Number.MAX_VALUE;
            }
            if (this._deviceOrientationCamera) {
                this._deviceOrientationCamera.position = this._position;
                this._scene.activeCamera = this._deviceOrientationCamera;
                // Restore angular sensibility
                if (this._cachedAngularSensibility.angularSensibilityX) {
                    this._deviceOrientationCamera.angularSensibilityX = this._cachedAngularSensibility.angularSensibilityX;
                    this._cachedAngularSensibility.angularSensibilityX = null;
                }
                if (this._cachedAngularSensibility.angularSensibilityY) {
                    this._deviceOrientationCamera.angularSensibilityY = this._cachedAngularSensibility.angularSensibilityY;
                    this._cachedAngularSensibility.angularSensibilityY = null;
                }
                if (this._cachedAngularSensibility.angularSensibility) {
                    this._deviceOrientationCamera.angularSensibility = this._cachedAngularSensibility.angularSensibility;
                    this._cachedAngularSensibility.angularSensibility = null;
                }
            }
            else if (this._existingCamera) {
                this._existingCamera.position = this._position;
                this._scene.activeCamera = this._existingCamera;
                if (this._inputElement) {
                    this._scene.activeCamera.attachControl(this._inputElement);
                }
                // Restore angular sensibility
                if (this._cachedAngularSensibility.angularSensibilityX) {
                    this._existingCamera.angularSensibilityX = this._cachedAngularSensibility.angularSensibilityX;
                    this._cachedAngularSensibility.angularSensibilityX = null;
                }
                if (this._cachedAngularSensibility.angularSensibilityY) {
                    this._existingCamera.angularSensibilityY = this._cachedAngularSensibility.angularSensibilityY;
                    this._cachedAngularSensibility.angularSensibilityY = null;
                }
                if (this._cachedAngularSensibility.angularSensibility) {
                    this._existingCamera.angularSensibility = this._cachedAngularSensibility.angularSensibility;
                    this._cachedAngularSensibility.angularSensibility = null;
                }
            }
            this.updateButtonVisibility();
            if (this._interactionsEnabled) {
                this._scene.unregisterBeforeRender(this.beforeRender);
                this._cameraGazer._gazeTracker.isVisible = false;
                if (this._leftController) {
                    this._leftController._gazeTracker.isVisible = false;
                }
                if (this._rightController) {
                    this._rightController._gazeTracker.isVisible = false;
                }
            }
            // resize to update width and height when exiting vr exits fullscreen
            this._scene.getEngine().resize();
            [this._leftController, this._rightController].forEach(function (controller) {
                if (controller) {
                    controller._deactivatePointer();
                }
            });
            this._hasEnteredVR = false;
            // Update engine state to re enable non-vr camera input
            var engine = this._scene.getEngine();
            if (engine._onVrDisplayPresentChange) {
                engine._onVrDisplayPresentChange();
            }
        }
    };
    Object.defineProperty(VRExperienceHelper.prototype, "position", {
        /**
         * The position of the vr experience helper.
         */
        get: function () {
            return this._position;
        },
        /**
         * Sets the position of the vr experience helper.
         */
        set: function (value) {
            this._position = value;
            if (this._scene.activeCamera) {
                this._scene.activeCamera.position = value;
            }
        },
        enumerable: true,
        configurable: true
    });
    /**
     * Enables controllers and user interactions such as selecting and object or clicking on an object.
     */
    VRExperienceHelper.prototype.enableInteractions = function () {
        var _this = this;
        if (!this._interactionsEnabled) {
            this._interactionsRequested = true;
            // in XR it is enabled by def