"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ContainerImagePipeline = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_codepipeline_1 = require("aws-cdk-lib/aws-codepipeline");
const aws_codepipeline_actions_1 = require("aws-cdk-lib/aws-codepipeline-actions");
const aws_lambda_1 = require("aws-cdk-lib/aws-lambda");
const constructs_1 = require("constructs");
const HANDLER_PATH = path.join(__dirname, "..", "..", "assets", "automation", "ecs_pipeline_handler");
/**
 * Allows images pushed to an ECR repo to trigger updates to an ECS service.
 *
 * This construct produces a CodePipeline pipeline using the "ECR Source"
 * action, an "ECS Deploy" action, and a custom Lambda handler in between that
 * transforms the JSON from the "Source" action into the JSON needed for the
 * "Deploy" action.
 */
class ContainerImagePipeline extends constructs_1.Construct {
    /**
     * Creates a new ContainerImagePipeline.
     *
     * @param scope - The scope in which to define this construct.
     * @param id - The scoped construct ID.
     * @param props - Initialization properties for this construct.
     */
    constructor(scope, id, props) {
        super(scope, id);
        const { service, container, repository, tag = "latest", pipelineType, artifactBucket, } = props;
        const transformerFunction = new aws_lambda_1.SingletonFunction(this, "Transformer", {
            uuid: "76208d72-6a58-47de-b611-75e2f58ad601",
            lambdaPurpose: "EcsJsonTransform",
            runtime: aws_lambda_1.Runtime.PYTHON_3_12,
            handler: "index.lambda_handler",
            description: "Transforms the imageDetail.json from ECR into imagedefinitions.json for ECS",
            code: aws_lambda_1.Code.fromAsset(HANDLER_PATH),
            timeout: aws_cdk_lib_1.Duration.seconds(60),
        });
        const sourceArtifact = new aws_codepipeline_1.Artifact();
        const buildArtifact = new aws_codepipeline_1.Artifact();
        this.pipeline = new aws_codepipeline_1.Pipeline(this, "Pipeline", {
            crossAccountKeys: false,
            pipelineType,
            artifactBucket,
            stages: [
                {
                    stageName: "Source",
                    actions: [
                        new aws_codepipeline_actions_1.EcrSourceAction({
                            output: sourceArtifact,
                            actionName: "Receive-ECR-Notice",
                            imageTag: tag,
                            repository,
                        }),
                    ],
                },
                {
                    stageName: "Transform",
                    actions: [
                        new aws_codepipeline_actions_1.LambdaInvokeAction({
                            userParameters: { OutputContainerName: container },
                            actionName: "Produce-imagedefinitions.json",
                            lambda: transformerFunction,
                            inputs: [sourceArtifact],
                            outputs: [buildArtifact],
                        }),
                    ],
                },
                {
                    stageName: "Deploy",
                    actions: [
                        new aws_codepipeline_actions_1.EcsDeployAction({
                            actionName: "Update-ECS-Service",
                            input: buildArtifact,
                            service: service,
                        }),
                    ],
                },
            ],
        });
    }
}
exports.ContainerImagePipeline = ContainerImagePipeline;
_a = JSII_RTTI_SYMBOL_1;
ContainerImagePipeline[_a] = { fqn: "shady-island.automation.ContainerImagePipeline", version: "0.1.25" };
//# sourceMappingURL=data:application/json;base64,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