import { AccessLevelList } from "../shared/access-level";
import { PolicyStatement } from "../shared";
import { PolicyStatementProps } from "@aws-cdk/aws-iam";
/**
 * (experimental) Statement provider for service [gamelift](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazongamelift.html).
 *
 * @experimental
 */
export declare class Gamelift extends PolicyStatement {
    /**
     * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
     *
     * @experimental
     */
    servicePrefix: string;
    /**
     * (experimental) Registers player acceptance or rejection of a proposed FlexMatch match.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_AcceptMatch.html
     *
     * @experimental
     */
    toAcceptMatch(): this;
    /**
     * (experimental) Locates and reserves a game server to host a new game session.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_ClaimGameServer.html
     *
     * @experimental
     */
    toClaimGameServer(): this;
    /**
     * (experimental) Defines a new alias for a fleet.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_CreateAlias.html
     *
     * @experimental
     */
    toCreateAlias(): this;
    /**
     * (experimental) Creates a new game build using files stored in an Amazon S3 bucket.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_CreateBuild.html
     *
     * @experimental
     */
    toCreateBuild(): this;
    /**
     * (experimental) Creates a new fleet of computing resources to run your game servers.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_CreateFleet.html
     *
     * @experimental
     */
    toCreateFleet(): this;
    /**
     * (experimental) Creates a new game server group, sets up a corresponding Auto Scaling group, and launches instances to host game servers.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_CreateGameServerGroup.html
     *
     * @experimental
     */
    toCreateGameServerGroup(): this;
    /**
     * (experimental) Starts a new game session on a specified fleet.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_CreateGameSession.html
     *
     * @experimental
     */
    toCreateGameSession(): this;
    /**
     * (experimental) Sets up a new queue for processing new game session placement requests.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_CreateGameSessionQueue.html
     *
     * @experimental
     */
    toCreateGameSessionQueue(): this;
    /**
     * (experimental) Creates a new FlexMatch matchmaker.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_CreateMatchmakingConfiguration.html
     *
     * @experimental
     */
    toCreateMatchmakingConfiguration(): this;
    /**
     * (experimental) Creates a new matchmaking rule set for FlexMatch.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_CreateMatchmakingRuleSet.html
     *
     * @experimental
     */
    toCreateMatchmakingRuleSet(): this;
    /**
     * (experimental) Reserves an available game session slot for a player.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_CreatePlayerSession.html
     *
     * @experimental
     */
    toCreatePlayerSession(): this;
    /**
     * (experimental) Reserves available game session slots for multiple players.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_CreatePlayerSessions.html
     *
     * @experimental
     */
    toCreatePlayerSessions(): this;
    /**
     * (experimental) Creates a new Realtime Servers script.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_CreateScript.html
     *
     * @experimental
     */
    toCreateScript(): this;
    /**
     * (experimental) Allows GameLift to create or delete a peering connection between a GameLift fleet VPC and a VPC on another AWS account.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_CreateVpcPeeringAuthorization.html
     *
     * @experimental
     */
    toCreateVpcPeeringAuthorization(): this;
    /**
     * (experimental) Establishes a peering connection between your GameLift fleet VPC and a VPC on another account.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_CreateVpcPeeringConnection.html
     *
     * @experimental
     */
    toCreateVpcPeeringConnection(): this;
    /**
     * (experimental) Deletes an alias.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_DeleteAlias.html
     *
     * @experimental
     */
    toDeleteAlias(): this;
    /**
     * (experimental) Deletes a game build.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_DeleteBuild.html
     *
     * @experimental
     */
    toDeleteBuild(): this;
    /**
     * (experimental) Deletes an empty fleet.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_DeleteFleet.html
     *
     * @experimental
     */
    toDeleteFleet(): this;
    /**
     * (experimental) Permanently deletes a game server group and terminates FleetIQ activity for the corresponding Auto Scaling group.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_DeleteGameServerGroup.html
     *
     * @experimental
     */
    toDeleteGameServerGroup(): this;
    /**
     * (experimental) Deletes an existing game session queue.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_DeleteGameSessionQueue.html
     *
     * @experimental
     */
    toDeleteGameSessionQueue(): this;
    /**
     * (experimental) Deletes an existing FlexMatch matchmaker.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_DeleteMatchmakingConfiguration.html
     *
     * @experimental
     */
    toDeleteMatchmakingConfiguration(): this;
    /**
     * (experimental) Deletes an existing FlexMatch matchmaking rule set.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_DeleteMatchmakingRuleSet.html
     *
     * @experimental
     */
    toDeleteMatchmakingRuleSet(): this;
    /**
     * (experimental) Deletes a set of auto-scaling rules.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_DeleteScalingPolicy.html
     *
     * @experimental
     */
    toDeleteScalingPolicy(): this;
    /**
     * (experimental) Deletes a Realtime Servers script.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_DeleteScript.html
     *
     * @experimental
     */
    toDeleteScript(): this;
    /**
     * (experimental) Cancels a VPC peering authorization.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_DeleteVpcPeeringAuthorization.html
     *
     * @experimental
     */
    toDeleteVpcPeeringAuthorization(): this;
    /**
     * (experimental) Removes a peering connection between VPCs.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_DeleteVpcPeeringConnection.html
     *
     * @experimental
     */
    toDeleteVpcPeeringConnection(): this;
    /**
     * (experimental) Removes a game server from a game server group.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_DeregisterGameServer.html
     *
     * @experimental
     */
    toDeregisterGameServer(): this;
    /**
     * (experimental) Retrieves properties for an alias.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeAlias.html
     *
     * @experimental
     */
    toDescribeAlias(): this;
    /**
     * (experimental) Retrieves properties for a game build.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeBuild.html
     *
     * @experimental
     */
    toDescribeBuild(): this;
    /**
     * (experimental) Retrieves the maximum allowed and current usage for EC2 instance types.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeEC2InstanceLimits.html
     *
     * @experimental
     */
    toDescribeEC2InstanceLimits(): this;
    /**
     * (experimental) Retrieves general properties, including status, for fleets.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeFleetAttributes.html
     *
     * @experimental
     */
    toDescribeFleetAttributes(): this;
    /**
     * (experimental) Retrieves the current capacity setting for fleets.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeFleetCapacity.html
     *
     * @experimental
     */
    toDescribeFleetCapacity(): this;
    /**
     * (experimental) Retrieves entries from a fleet's event log.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeFleetEvents.html
     *
     * @experimental
     */
    toDescribeFleetEvents(): this;
    /**
     * (experimental) Retrieves the inbound connection permissions for a fleet.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeFleetPortSettings.html
     *
     * @experimental
     */
    toDescribeFleetPortSettings(): this;
    /**
     * (experimental) Retrieves utilization statistics for fleets.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeFleetUtilization.html
     *
     * @experimental
     */
    toDescribeFleetUtilization(): this;
    /**
     * (experimental) Retrieves properties for a game server.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeGameServer.html
     *
     * @experimental
     */
    toDescribeGameServer(): this;
    /**
     * (experimental) Retrieves properties for a game server group.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeGameServerGroup.html
     *
     * @experimental
     */
    toDescribeGameServerGroup(): this;
    /**
     * (experimental) Retrieves the status of EC2 instances in a game server group.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeGameServerInstances.html
     *
     * @experimental
     */
    toDescribeGameServerInstances(): this;
    /**
     * (experimental) Retrieves properties for game sessions in a fleet, including the protection policy.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeGameSessionDetails.html
     *
     * @experimental
     */
    toDescribeGameSessionDetails(): this;
    /**
     * (experimental) Retrieves details of a game session placement request.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeGameSessionPlacement.html
     *
     * @experimental
     */
    toDescribeGameSessionPlacement(): this;
    /**
     * (experimental) Retrieves properties for game session queues.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeGameSessionQueues.html
     *
     * @experimental
     */
    toDescribeGameSessionQueues(): this;
    /**
     * (experimental) Retrieves properties for game sessions in a fleet.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeGameSessions.html
     *
     * @experimental
     */
    toDescribeGameSessions(): this;
    /**
     * (experimental) Retrieves information about instances in a fleet.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeInstances.html
     *
     * @experimental
     */
    toDescribeInstances(): this;
    /**
     * (experimental) Retrieves details of matchmaking tickets.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeMatchmaking.html
     *
     * @experimental
     */
    toDescribeMatchmaking(): this;
    /**
     * (experimental) Retrieves properties for FlexMatch matchmakers.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeMatchmakingConfigurations.html
     *
     * @experimental
     */
    toDescribeMatchmakingConfigurations(): this;
    /**
     * (experimental) Retrieves properties for FlexMatch matchmaking rule sets.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeMatchmakingRuleSets.html
     *
     * @experimental
     */
    toDescribeMatchmakingRuleSets(): this;
    /**
     * (experimental) Retrieves properties for player sessions in a game session.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribePlayerSessions.html
     *
     * @experimental
     */
    toDescribePlayerSessions(): this;
    /**
     * (experimental) Retrieves the current runtime configuration for a fleet.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeRuntimeConfiguration.html
     *
     * @experimental
     */
    toDescribeRuntimeConfiguration(): this;
    /**
     * (experimental) Retrieves all scaling policies that are applied to a fleet.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeScalingPolicies.html
     *
     * @experimental
     */
    toDescribeScalingPolicies(): this;
    /**
     * (experimental) Retrieves properties for a Realtime Servers script.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeScript.html
     *
     * @experimental
     */
    toDescribeScript(): this;
    /**
     * (experimental) Retrieves valid VPC peering authorizations.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeVpcPeeringAuthorizations.html
     *
     * @experimental
     */
    toDescribeVpcPeeringAuthorizations(): this;
    /**
     * (experimental) Retrieves details on active or pending VPC peering connections.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeVpcPeeringConnections.html
     *
     * @experimental
     */
    toDescribeVpcPeeringConnections(): this;
    /**
     * (experimental) Retrieves the location of stored logs for a game session.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_GetGameSessionLogUrl.html
     *
     * @experimental
     */
    toGetGameSessionLogUrl(): this;
    /**
     * (experimental) Requests remote access to a specified fleet instance.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_GetInstanceAccess.html
     *
     * @experimental
     */
    toGetInstanceAccess(): this;
    /**
     * (experimental) Retrieves all aliases that are defined in the current region.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_ListAliases.html
     *
     * @experimental
     */
    toListAliases(): this;
    /**
     * (experimental) Retrieves all game build in the current region.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_ListBuilds.html
     *
     * @experimental
     */
    toListBuilds(): this;
    /**
     * (experimental) Retrieves a list of fleet IDs for all fleets in the current region.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_ListFleets.html
     *
     * @experimental
     */
    toListFleets(): this;
    /**
     * (experimental) Retrieves all game server groups that are defined in the current region.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_ListGameServerGroups.html
     *
     * @experimental
     */
    toListGameServerGroups(): this;
    /**
     * (experimental) Retrieves all game servers that are currently running in a game server group.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_ListGameServers.html
     *
     * @experimental
     */
    toListGameServers(): this;
    /**
     * (experimental) Retrieves properties for all Realtime Servers scripts in the current region.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_ListScripts.html
     *
     * @experimental
     */
    toListScripts(): this;
    /**
     * (experimental) Lists tags for GameLift resources.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_ListTagsForResource.html
     *
     * @experimental
     */
    toListTagsForResource(): this;
    /**
     * (experimental) Creates or updates a fleet auto-scaling policy.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_PutScalingPolicy.html
     *
     * @experimental
     */
    toPutScalingPolicy(): this;
    /**
     * (experimental) Notifies GameLift FleetIQ when a new game server is ready to host gameplay.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_RegisterGameServer.html
     *
     * @experimental
     */
    toRegisterGameServer(): this;
    /**
     * (experimental) Retrieves fresh upload credentials to use when uploading a new game build.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_RequestUploadCredentials.html
     *
     * @experimental
     */
    toRequestUploadCredentials(): this;
    /**
     * (experimental) Retrieves the fleet ID associated with an alias.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_ResolveAlias.html
     *
     * @experimental
     */
    toResolveAlias(): this;
    /**
     * (experimental) Reinstates suspended FleetIQ activity for a game server group.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_ResumeGameServerGroup.html
     *
     * @experimental
     */
    toResumeGameServerGroup(): this;
    /**
     * (experimental) Retrieves game sessions that match a set of search criteria.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_SearchGameSessions.html
     *
     * @experimental
     */
    toSearchGameSessions(): this;
    /**
     * (experimental) Resumes auto-scaling activity on a fleet after it was suspended with StopFleetActions().
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_StartFleetActions.html
     *
     * @experimental
     */
    toStartFleetActions(): this;
    /**
     * (experimental) Sends a game session placement request to a game session queue.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_StartGameSessionPlacement.html
     *
     * @experimental
     */
    toStartGameSessionPlacement(): this;
    /**
     * (experimental) Requests FlexMatch matchmaking to fill available player slots in an existing game session.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_StartMatchBackfill.html
     *
     * @experimental
     */
    toStartMatchBackfill(): this;
    /**
     * (experimental) Requests FlexMatch matchmaking for one or a group of players and game session placement for a resulting match.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_StartMatchmaking.html
     *
     * @experimental
     */
    toStartMatchmaking(): this;
    /**
     * (experimental) Suspends auto-scaling activity on a fleet.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_StopFleetActions.html
     *
     * @experimental
     */
    toStopFleetActions(): this;
    /**
     * (experimental) Cancels a game session placement request that is in progress.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_StopGameSessionPlacement.html
     *
     * @experimental
     */
    toStopGameSessionPlacement(): this;
    /**
     * (experimental) Cancels a matchmaking or match backfill request that is in progress.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_StopMatchmaking.html
     *
     * @experimental
     */
    toStopMatchmaking(): this;
    /**
     * (experimental) Temporarily stops FleetIQ activity for a game server group.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_SuspendGameServerGroup.html
     *
     * @experimental
     */
    toSuspendGameServerGroup(): this;
    /**
     * (experimental) Tags GameLift resources.
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_TagResource.html
     *
     * @experimental
     */
    toTagResource(): this;
    /**
     * (experimental) Untags GameLift resources.
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_UntagResource.html
     *
     * @experimental
     */
    toUntagResource(): this;
    /**
     * (experimental) Updates the properties of an existing alias.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_UpdateAlias.html
     *
     * @experimental
     */
    toUpdateAlias(): this;
    /**
     * (experimental) Updates an existing build's metadata.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_UpdateBuild.html
     *
     * @experimental
     */
    toUpdateBuild(): this;
    /**
     * (experimental) Updates the general properties of an existing fleet.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_UpdateFleetAttributes.html
     *
     * @experimental
     */
    toUpdateFleetAttributes(): this;
    /**
     * (experimental) Adjusts a fleet's capacity settings.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_UpdateFleetCapacity.html
     *
     * @experimental
     */
    toUpdateFleetCapacity(): this;
    /**
     * (experimental) Adjusts a fleet's port settings.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_UpdateFleetPortSettings.html
     *
     * @experimental
     */
    toUpdateFleetPortSettings(): this;
    /**
     * (experimental) Changes game server properties, health status, or utilization status.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_UpdateGameServer.html
     *
     * @experimental
     */
    toUpdateGameServer(): this;
    /**
     * (experimental) Updates properties for game server group, including allowed instance types.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_UpdateGameServerGroup.html
     *
     * @experimental
     */
    toUpdateGameServerGroup(): this;
    /**
     * (experimental) Updates the properties of an existing game session.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_UpdateGameSession.html
     *
     * @experimental
     */
    toUpdateGameSession(): this;
    /**
     * (experimental) Updates properties of an existing game session queue.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_UpdateGameSessionQueue.html
     *
     * @experimental
     */
    toUpdateGameSessionQueue(): this;
    /**
     * (experimental) Updates properties of an existing FlexMatch matchmaking configuration.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_UpdateMatchmakingConfiguration.html
     *
     * @experimental
     */
    toUpdateMatchmakingConfiguration(): this;
    /**
     * (experimental) Updates how server processes are configured on instances in an existing fleet.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_UpdateRuntimeConfiguration.html
     *
     * @experimental
     */
    toUpdateRuntimeConfiguration(): this;
    /**
     * (experimental) Updates the metadata and content of an existing Realtime Servers script.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_UpdateScript.html
     *
     * @experimental
     */
    toUpdateScript(): this;
    /**
     * (experimental) Validates the syntax of a FlexMatch matchmaking rule set.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_ValidateMatchmakingRuleSet.html
     *
     * @experimental
     */
    toValidateMatchmakingRuleSet(): this;
    /**
     * @experimental
     */
    protected accessLevelList: AccessLevelList;
    /**
     * (experimental) Adds a resource of type alias to the statement.
     *
     * https://docs.aws.amazon.com/gamelift/latest/developerguide/API_Alias.html
     *
     * @param aliasId - Identifier for the aliasId.
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onAlias(aliasId: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type build to the statement.
     *
     * https://docs.aws.amazon.com/gamelift/latest/developerguide/API_Build.html
     *
     * @param buildId - Identifier for the buildId.
     * @param accountId - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onBuild(buildId: string, accountId?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type script to the statement.
     *
     * https://docs.aws.amazon.com/gamelift/latest/developerguide/API_Script.html
     *
     * @param scriptId - Identifier for the scriptId.
     * @param accountId - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onScript(scriptId: string, accountId?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type fleet to the statement.
     *
     * https://docs.aws.amazon.com/gamelift/latest/developerguide/API_FleetAttributes.html
     *
     * @param fleetId - Identifier for the fleetId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onFleet(fleetId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type gameSessionQueue to the statement.
     *
     * https://docs.aws.amazon.com/gamelift/latest/developerguide/API_GameSessionQueue.html
     *
     * @param gameSessionQueueName - Identifier for the gameSessionQueueName.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onGameSessionQueue(gameSessionQueueName: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type matchmakingConfiguration to the statement.
     *
     * https://docs.aws.amazon.com/gamelift/latest/developerguide/API_MatchmakingConfiguration.html
     *
     * @param matchmakingConfigurationName - Identifier for the matchmakingConfigurationName.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onMatchmakingConfiguration(matchmakingConfigurationName: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type matchmakingRuleSet to the statement.
     *
     * https://docs.aws.amazon.com/gamelift/latest/developerguide/API_MatchmakingRuleSet.html
     *
     * @param matchmakingRuleSetName - Identifier for the matchmakingRuleSetName.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onMatchmakingRuleSet(matchmakingRuleSetName: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type gameServerGroup to the statement.
     *
     * https://docs.aws.amazon.com/gamelift/latest/developerguide/API_GameServerGroup.html
     *
     * @param gameServerGroupName - Identifier for the gameServerGroupName.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onGameServerGroup(gameServerGroupName: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Statement provider for service [gamelift](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazongamelift.html).
     *
     * @experimental
     */
    constructor(props?: PolicyStatementProps);
}
