# -*- coding: utf-8 -*-
# Generated by Django 1.11.5 on 2017-10-03 04:27
from __future__ import unicode_literals

import django.core.validators
from django.db import migrations, models
import django.db.models.deletion
import djpush.models
import timezone_field.fields


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='Notification',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=100)),
                ('enabled', models.BooleanField(default=False, help_text='The notification will not be sent if this is unchecked')),
                ('slug', models.SlugField(unique=True, validators=[djpush.models.ValidNotificationSlug])),
                ('description', models.TextField()),
                ('title', models.TextField(blank=True, default='')),
                ('body', models.TextField(blank=True, default='')),
                ('sound', models.TextField(blank=True, default='')),
                ('priority', models.CharField(choices=[('normal', 'Normal'), ('high', 'High')], default='high', help_text='Valid values are "normal" and "high.". In APNs 5 and 10', max_length=20)),
                ('apns_alert_title_loc_key', models.TextField(blank=True, default='')),
                ('apns_alert_title_loc_args', models.TextField(blank=True, default='')),
                ('apns_alert_loc_key', models.TextField(blank=True, default='')),
                ('apns_alert_log_args', models.TextField(blank=True, default='')),
                ('apns_alert_action_loc_key', models.TextField(blank=True, default='')),
                ('apns_alert_launch_image', models.TextField(blank=True, default='')),
                ('apns_custom', models.TextField(blank=True, default='')),
                ('gcm_notification_icon', models.TextField(blank=True, default='')),
                ('gcm_notification_tag', models.TextField(blank=True, default='')),
                ('gcm_notification_color', models.TextField(blank=True, default='')),
                ('gcm_notification_click_action', models.TextField(blank=True, default='')),
                ('gcm_notification_body_loc_key', models.TextField(blank=True, default='')),
                ('gcm_notification_body_loc_args', models.TextField(blank=True, default='')),
                ('gcm_notification_title_loc_key', models.TextField(blank=True, default='')),
                ('gcm_notification_title_loc_args', models.TextField(blank=True, default='')),
                ('gcm_option_collapse_key', models.TextField(blank=True, default='')),
                ('gcm_option_content_available', models.TextField(blank=True, default='')),
                ('gcm_option_delay_while_idle', models.BooleanField(default=False, help_text='When this parameter is set to true, it indicates that the message should not be sent until the device becomes active.')),
                ('gcm_option_time_to_live', models.IntegerField(blank=True, help_text='This parameter specifies how long (in seconds) the message should be kept in GCM storage if the device is offline. The maximum time to live supported is 4 weeks', null=True, validators=[django.core.validators.MaxValueValidator(40320)])),
                ('gcm_option_restricted_package_name', models.TextField(blank=True, default='')),
                ('gcm_data', models.TextField(blank=True, default='', help_text="This parameter specifies the custom key-value pairs of the message's payload.")),
                ('os_template_id', models.TextField(blank=True, default='')),
            ],
        ),
        migrations.CreateModel(
            name='NotificationCategory',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=100)),
                ('opt_out', models.BooleanField(default=False, help_text='If checked the user can opt-out receiving this category')),
            ],
        ),
        migrations.CreateModel(
            name='NotificationInstance',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('provider', models.CharField(max_length=20)),
                ('tokens', models.TextField()),
                ('data', models.TextField()),
                ('scheduled_at', models.DateTimeField(null=True)),
                ('canceled', models.BooleanField(default=False)),
                ('timezone', timezone_field.fields.TimeZoneField()),
                ('sent_at', models.DateTimeField(null=True)),
                ('result', models.TextField(blank=True, default='')),
                ('notification', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='djpush.Notification')),
            ],
        ),
        migrations.CreateModel(
            name='NotificationScheduler',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('order', models.IntegerField()),
                ('notification', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='djpush.Notification')),
            ],
        ),
        migrations.CreateModel(
            name='Scheduler',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
            ],
        ),
        migrations.CreateModel(
            name='SchedulerInTimeRange',
            fields=[
                ('scheduler_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='djpush.Scheduler')),
                ('start_hour', models.IntegerField(blank=True, null=True, validators=[django.core.validators.MinValueValidator(0), django.core.validators.MaxValueValidator(23)])),
                ('end_hour', models.IntegerField(blank=True, null=True, validators=[django.core.validators.MinValueValidator(0), django.core.validators.MaxValueValidator(23)])),
                ('discard', models.BooleanField(default=False, help_text='If checked the notification will be discarded instead of being scheduling to be sent later')),
            ],
            bases=('djpush.scheduler',),
        ),
        migrations.CreateModel(
            name='SchedulerMinutesLater',
            fields=[
                ('scheduler_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='djpush.Scheduler')),
                ('minutes', models.IntegerField()),
            ],
            bases=('djpush.scheduler',),
        ),
        migrations.AddField(
            model_name='notificationscheduler',
            name='scheduler',
            field=models.ForeignKey(help_text='No scheduler means the notification will be sent immediately', on_delete=django.db.models.deletion.CASCADE, to='djpush.Scheduler'),
        ),
        migrations.AddField(
            model_name='notification',
            name='category',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='djpush.NotificationCategory'),
        ),
        migrations.AlterUniqueTogether(
            name='notificationscheduler',
            unique_together=set([('notification', 'scheduler', 'order')]),
        ),
    ]
