/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.keyword.validator.draftv3;

import com.github.fge.jsonschema.core.exceptions.ProcessingException;
import com.github.fge.jsonschema.core.processing.Processor;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import com.github.fge.jsonschema.keyword.validator.AbstractKeywordValidator;
import com.github.fge.jsonschema.processors.data.FullData;
import com.github.fge.msgsimple.bundle.MessageBundle;
import io.ray.shaded.com.fasterxml.jackson.databind.JsonNode;
import io.ray.shaded.com.google.common.collect.ImmutableSet;
import io.ray.shaded.com.google.common.collect.Sets;
import java.util.LinkedHashSet;
import java.util.Set;

public final class PropertiesValidator
extends AbstractKeywordValidator {
    private final Set<String> required;

    public PropertiesValidator(JsonNode digest) {
        super("properties");
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (JsonNode element : digest.get("required")) {
            builder.add(element.textValue());
        }
        this.required = builder.build();
    }

    @Override
    public void validate(Processor<FullData, FullData> processor, ProcessingReport report, MessageBundle bundle, FullData data) throws ProcessingException {
        LinkedHashSet<String> set = Sets.newLinkedHashSet(this.required);
        set.removeAll(Sets.newHashSet(data.getInstance().getNode().fieldNames()));
        if (!set.isEmpty()) {
            report.error(this.newMsg(data, bundle, "err.common.object.missingMembers").put("required", this.required).putArgument("missing", PropertiesValidator.toArrayNode(set)));
        }
    }

    @Override
    public String toString() {
        return "required: " + this.required.size() + " properties";
    }
}

