# -*- coding: utf-8 -*-
# Generated by Django 1.10.5 on 2017-12-12 00:31
from __future__ import unicode_literals

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='Article',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(max_length=255)),
                ('short_body', models.TextField(blank=True, null=True)),
                ('long_body', models.TextField()),
                ('image', models.ImageField(upload_to=b'thrive_images')),
                ('slug', models.SlugField(unique=True)),
                ('phase', models.CharField(blank=True, choices=[(b'A', b'Phase A'), (b'B', b'Phase B'), (b'C', b'Phase C')], max_length=1, null=True)),
                ('quarter', models.CharField(blank=True, choices=[(b'Au', b'Autumn'), (b'Wi', b'Winter'), (b'Sp', b'Spring'), (b'Su', b'Summer')], max_length=2, null=True)),
                ('week', models.IntegerField(blank=True, null=True)),
            ],
        ),
        migrations.CreateModel(
            name='Category',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(max_length=255)),
                ('slug', models.SlugField(unique=True)),
            ],
            options={
                'verbose_name_plural': 'Categories',
            },
        ),
        migrations.CreateModel(
            name='RelatedArticle',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('parent_article', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='parent_article', to='hx_toolkit.Article')),
                ('related_article', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='related_article', to='hx_toolkit.Article')),
            ],
        ),
        migrations.CreateModel(
            name='ResourceLink',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('url', models.URLField()),
                ('title', models.CharField(max_length=255)),
            ],
        ),
        migrations.AddField(
            model_name='article',
            name='category',
            field=models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to='hx_toolkit.Category'),
        ),
        migrations.AddField(
            model_name='article',
            name='related_articles',
            field=models.ManyToManyField(blank=True, related_name='_article_related_articles_+', to='hx_toolkit.Article'),
        ),
        migrations.AddField(
            model_name='article',
            name='related_links',
            field=models.ManyToManyField(blank=True, to='hx_toolkit.ResourceLink'),
        ),
    ]
