"""
interact async with the huawei inverter using modbus to get production data
"""
from importlib.metadata import PackageNotFoundError, version

from .bridge import HuaweiSolarBridge  # noqa
from .exceptions import *  # noqa
from .huawei_solar import *  # noqa
from .registers import *  # noqa

try:
    VERSION = version(__name__)
except PackageNotFoundError:  # pragma: no cover
    try:
        from .version import version as VERSION  # noqa
    except ImportError as err:  # pragma: no cover
        raise ImportError(
            "Failed to find (autogenerated) version.py. "
            "This might be because you are installing from GitHub's tarballs, "
            "use the PyPI ones."
        ) from err
__version__ = VERSION
