import cdk = require('@aws-cdk/core');
/**
 * Properties for defining a `AWS::Budgets::Budget`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-budgets-budget.html
 */
export interface CfnBudgetProps {
    /**
     * `AWS::Budgets::Budget.Budget`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-budgets-budget.html#cfn-budgets-budget-budget
     */
    readonly budget: CfnBudget.BudgetDataProperty | cdk.IResolvable;
    /**
     * `AWS::Budgets::Budget.NotificationsWithSubscribers`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-budgets-budget.html#cfn-budgets-budget-notificationswithsubscribers
     */
    readonly notificationsWithSubscribers?: Array<CfnBudget.NotificationWithSubscribersProperty | cdk.IResolvable> | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::Budgets::Budget`
 *
 * @cloudformationResource AWS::Budgets::Budget
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-budgets-budget.html
 */
export declare class CfnBudget extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Budgets::Budget";
    /**
     * `AWS::Budgets::Budget.Budget`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-budgets-budget.html#cfn-budgets-budget-budget
     */
    budget: CfnBudget.BudgetDataProperty | cdk.IResolvable;
    /**
     * `AWS::Budgets::Budget.NotificationsWithSubscribers`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-budgets-budget.html#cfn-budgets-budget-notificationswithsubscribers
     */
    notificationsWithSubscribers: Array<CfnBudget.NotificationWithSubscribersProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::Budgets::Budget`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnBudgetProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected readonly cfnProperties: {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
export declare namespace CfnBudget {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-budgetdata.html
     */
    interface BudgetDataProperty {
        /**
         * `CfnBudget.BudgetDataProperty.BudgetLimit`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-budgetdata.html#cfn-budgets-budget-budgetdata-budgetlimit
         */
        readonly budgetLimit?: CfnBudget.SpendProperty | cdk.IResolvable;
        /**
         * `CfnBudget.BudgetDataProperty.BudgetName`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-budgetdata.html#cfn-budgets-budget-budgetdata-budgetname
         */
        readonly budgetName?: string;
        /**
         * `CfnBudget.BudgetDataProperty.BudgetType`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-budgetdata.html#cfn-budgets-budget-budgetdata-budgettype
         */
        readonly budgetType: string;
        /**
         * `CfnBudget.BudgetDataProperty.CostFilters`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-budgetdata.html#cfn-budgets-budget-budgetdata-costfilters
         */
        readonly costFilters?: any | cdk.IResolvable;
        /**
         * `CfnBudget.BudgetDataProperty.CostTypes`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-budgetdata.html#cfn-budgets-budget-budgetdata-costtypes
         */
        readonly costTypes?: CfnBudget.CostTypesProperty | cdk.IResolvable;
        /**
         * `CfnBudget.BudgetDataProperty.PlannedBudgetLimits`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-budgetdata.html#cfn-budgets-budget-budgetdata-plannedbudgetlimits
         */
        readonly plannedBudgetLimits?: any | cdk.IResolvable;
        /**
         * `CfnBudget.BudgetDataProperty.TimePeriod`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-budgetdata.html#cfn-budgets-budget-budgetdata-timeperiod
         */
        readonly timePeriod?: CfnBudget.TimePeriodProperty | cdk.IResolvable;
        /**
         * `CfnBudget.BudgetDataProperty.TimeUnit`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-budgetdata.html#cfn-budgets-budget-budgetdata-timeunit
         */
        readonly timeUnit: string;
    }
}
export declare namespace CfnBudget {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-costtypes.html
     */
    interface CostTypesProperty {
        /**
         * `CfnBudget.CostTypesProperty.IncludeCredit`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-costtypes.html#cfn-budgets-budget-costtypes-includecredit
         */
        readonly includeCredit?: boolean | cdk.IResolvable;
        /**
         * `CfnBudget.CostTypesProperty.IncludeDiscount`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-costtypes.html#cfn-budgets-budget-costtypes-includediscount
         */
        readonly includeDiscount?: boolean | cdk.IResolvable;
        /**
         * `CfnBudget.CostTypesProperty.IncludeOtherSubscription`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-costtypes.html#cfn-budgets-budget-costtypes-includeothersubscription
         */
        readonly includeOtherSubscription?: boolean | cdk.IResolvable;
        /**
         * `CfnBudget.CostTypesProperty.IncludeRecurring`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-costtypes.html#cfn-budgets-budget-costtypes-includerecurring
         */
        readonly includeRecurring?: boolean | cdk.IResolvable;
        /**
         * `CfnBudget.CostTypesProperty.IncludeRefund`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-costtypes.html#cfn-budgets-budget-costtypes-includerefund
         */
        readonly includeRefund?: boolean | cdk.IResolvable;
        /**
         * `CfnBudget.CostTypesProperty.IncludeSubscription`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-costtypes.html#cfn-budgets-budget-costtypes-includesubscription
         */
        readonly includeSubscription?: boolean | cdk.IResolvable;
        /**
         * `CfnBudget.CostTypesProperty.IncludeSupport`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-costtypes.html#cfn-budgets-budget-costtypes-includesupport
         */
        readonly includeSupport?: boolean | cdk.IResolvable;
        /**
         * `CfnBudget.CostTypesProperty.IncludeTax`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-costtypes.html#cfn-budgets-budget-costtypes-includetax
         */
        readonly includeTax?: boolean | cdk.IResolvable;
        /**
         * `CfnBudget.CostTypesProperty.IncludeUpfront`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-costtypes.html#cfn-budgets-budget-costtypes-includeupfront
         */
        readonly includeUpfront?: boolean | cdk.IResolvable;
        /**
         * `CfnBudget.CostTypesProperty.UseAmortized`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-costtypes.html#cfn-budgets-budget-costtypes-useamortized
         */
        readonly useAmortized?: boolean | cdk.IResolvable;
        /**
         * `CfnBudget.CostTypesProperty.UseBlended`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-costtypes.html#cfn-budgets-budget-costtypes-useblended
         */
        readonly useBlended?: boolean | cdk.IResolvable;
    }
}
export declare namespace CfnBudget {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-notification.html
     */
    interface NotificationProperty {
        /**
         * `CfnBudget.NotificationProperty.ComparisonOperator`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-notification.html#cfn-budgets-budget-notification-comparisonoperator
         */
        readonly comparisonOperator: string;
        /**
         * `CfnBudget.NotificationProperty.NotificationType`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-notification.html#cfn-budgets-budget-notification-notificationtype
         */
        readonly notificationType: string;
        /**
         * `CfnBudget.NotificationProperty.Threshold`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-notification.html#cfn-budgets-budget-notification-threshold
         */
        readonly threshold: number;
        /**
         * `CfnBudget.NotificationProperty.ThresholdType`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-notification.html#cfn-budgets-budget-notification-thresholdtype
         */
        readonly thresholdType?: string;
    }
}
export declare namespace CfnBudget {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-notificationwithsubscribers.html
     */
    interface NotificationWithSubscribersProperty {
        /**
         * `CfnBudget.NotificationWithSubscribersProperty.Notification`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-notificationwithsubscribers.html#cfn-budgets-budget-notificationwithsubscribers-notification
         */
        readonly notification: CfnBudget.NotificationProperty | cdk.IResolvable;
        /**
         * `CfnBudget.NotificationWithSubscribersProperty.Subscribers`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-notificationwithsubscribers.html#cfn-budgets-budget-notificationwithsubscribers-subscribers
         */
        readonly subscribers: Array<CfnBudget.SubscriberProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
export declare namespace CfnBudget {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-spend.html
     */
    interface SpendProperty {
        /**
         * `CfnBudget.SpendProperty.Amount`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-spend.html#cfn-budgets-budget-spend-amount
         */
        readonly amount: number;
        /**
         * `CfnBudget.SpendProperty.Unit`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-spend.html#cfn-budgets-budget-spend-unit
         */
        readonly unit: string;
    }
}
export declare namespace CfnBudget {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-subscriber.html
     */
    interface SubscriberProperty {
        /**
         * `CfnBudget.SubscriberProperty.Address`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-subscriber.html#cfn-budgets-budget-subscriber-address
         */
        readonly address: string;
        /**
         * `CfnBudget.SubscriberProperty.SubscriptionType`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-subscriber.html#cfn-budgets-budget-subscriber-subscriptiontype
         */
        readonly subscriptionType: string;
    }
}
export declare namespace CfnBudget {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-timeperiod.html
     */
    interface TimePeriodProperty {
        /**
         * `CfnBudget.TimePeriodProperty.End`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-timeperiod.html#cfn-budgets-budget-timeperiod-end
         */
        readonly end?: string;
        /**
         * `CfnBudget.TimePeriodProperty.Start`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-budgets-budget-timeperiod.html#cfn-budgets-budget-timeperiod-start
         */
        readonly start?: string;
    }
}
