"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.BackupBucket = void 0;
const aws_s3_1 = require("@aws-cdk/aws-s3");
const core_1 = require("@aws-cdk/core");
class BackupBucket extends aws_s3_1.Bucket {
    constructor(scope, id, props) {
        const { retentionPeriod = core_1.Duration.days(35), ...rest } = props || {};
        super(scope, id, {
            lifecycleRules: [
                {
                    expiration: retentionPeriod,
                },
            ],
            encryption: aws_s3_1.BucketEncryption.S3_MANAGED,
            publicReadAccess: false,
            blockPublicAccess: aws_s3_1.BlockPublicAccess.BLOCK_ALL,
            removalPolicy: core_1.RemovalPolicy.RETAIN,
            ...rest,
        });
    }
}
exports.BackupBucket = BackupBucket;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYmFja3VwLWJ1Y2tldC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uL3NyYy9iYWNrdXAtYnVja2V0LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7OztBQUFBLDRDQUEyRjtBQUMzRix3Q0FBbUU7QUFNbkUsTUFBYSxZQUFhLFNBQVEsZUFBTTtJQUN0QyxZQUFZLEtBQWdCLEVBQUUsRUFBVSxFQUFFLEtBQXlCO1FBQ2pFLE1BQU0sRUFBRSxlQUFlLEdBQUcsZUFBUSxDQUFDLElBQUksQ0FBQyxFQUFFLENBQUMsRUFBRSxHQUFHLElBQUksRUFBRSxHQUFHLEtBQUssSUFBSSxFQUFFLENBQUM7UUFFckUsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLEVBQUU7WUFDZixjQUFjLEVBQUU7Z0JBQ2Q7b0JBQ0UsVUFBVSxFQUFFLGVBQWU7aUJBQzVCO2FBQ0Y7WUFDRCxVQUFVLEVBQUUseUJBQWdCLENBQUMsVUFBVTtZQUN2QyxnQkFBZ0IsRUFBRSxLQUFLO1lBQ3ZCLGlCQUFpQixFQUFFLDBCQUFpQixDQUFDLFNBQVM7WUFDOUMsYUFBYSxFQUFFLG9CQUFhLENBQUMsTUFBTTtZQUNuQyxHQUFHLElBQUk7U0FDUixDQUFDLENBQUM7SUFDTCxDQUFDO0NBQ0Y7QUFqQkQsb0NBaUJDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgQnVja2V0LCBCdWNrZXRQcm9wcywgQnVja2V0RW5jcnlwdGlvbiwgQmxvY2tQdWJsaWNBY2Nlc3MgfSBmcm9tICdAYXdzLWNkay9hd3MtczMnO1xuaW1wb3J0IHsgQ29uc3RydWN0LCBSZW1vdmFsUG9saWN5LCBEdXJhdGlvbiB9IGZyb20gJ0Bhd3MtY2RrL2NvcmUnO1xuXG5leHBvcnQgaW50ZXJmYWNlIEJhY2t1cEJ1Y2tldFByb3BzIGV4dGVuZHMgQnVja2V0UHJvcHMge1xuICByZWFkb25seSByZXRlbnRpb25QZXJpb2Q/OiBEdXJhdGlvbjtcbn1cblxuZXhwb3J0IGNsYXNzIEJhY2t1cEJ1Y2tldCBleHRlbmRzIEJ1Y2tldCB7XG4gIGNvbnN0cnVjdG9yKHNjb3BlOiBDb25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHByb3BzPzogQmFja3VwQnVja2V0UHJvcHMpIHtcbiAgICBjb25zdCB7IHJldGVudGlvblBlcmlvZCA9IER1cmF0aW9uLmRheXMoMzUpLCAuLi5yZXN0IH0gPSBwcm9wcyB8fCB7fTtcblxuICAgIHN1cGVyKHNjb3BlLCBpZCwge1xuICAgICAgbGlmZWN5Y2xlUnVsZXM6IFtcbiAgICAgICAge1xuICAgICAgICAgIGV4cGlyYXRpb246IHJldGVudGlvblBlcmlvZCxcbiAgICAgICAgfSxcbiAgICAgIF0sXG4gICAgICBlbmNyeXB0aW9uOiBCdWNrZXRFbmNyeXB0aW9uLlMzX01BTkFHRUQsXG4gICAgICBwdWJsaWNSZWFkQWNjZXNzOiBmYWxzZSxcbiAgICAgIGJsb2NrUHVibGljQWNjZXNzOiBCbG9ja1B1YmxpY0FjY2Vzcy5CTE9DS19BTEwsXG4gICAgICByZW1vdmFsUG9saWN5OiBSZW1vdmFsUG9saWN5LlJFVEFJTixcbiAgICAgIC4uLnJlc3QsXG4gICAgfSk7XG4gIH1cbn1cbiJdfQ==