from typing import Tuple, Optional
from langchain_core.tools import tool
from ..utls import log, exec_sh_cmd


@tool
def validate_mermaid_md(
    file_path: str, output_file_path: Optional[str] = None
) -> Tuple[str, str]:
    """Validates a .md file that contains Mermaid in it, by converting it to an image using Mermaid CLI.

    Args:
      filepath: The file path of the .md containing Mermaidto validate.
      output_file_path: The output file path, for any artifacts generated by the validation operation. Defaults to None.

    Returns:
      Tuple[str, str]: A tuple, with the first value being the validation output and the second the error, if there is one.
    """

    cmd = f"mmdc -i {file_path} -o {output_file_path or "tmp.md"}"

    log(f"validate_mermaid_md START. file_path: {file_path}, cmd: {cmd}")

    return exec_sh_cmd(cmd)
