from utils import validate_time, validate_bases, validate_bases_weights, validate_risk_level


# ++++ ENDPOINTS MAPPING ++++ 
endpoints_mapping = [{"endpoint_name":"Assets","data_type":"Reference data","description":"retrieves a dataframe of supported assets.","schema_name":"","url":"https://reference-data-api.kaiko.io/v1/","suffix":"assets","allowed_instrument_classes":"-"},{"endpoint_name":"Exchanges","data_type":"Reference data","description":"retrieves a dataframe of supported exchanges.","schema_name":"","url":"https://reference-data-api.kaiko.io/v1/","suffix":"exchanges","allowed_instrument_classes":"-"},{"endpoint_name":"Instruments","data_type":"Reference data","description":"retrieves a dataframe of supported instruments.","schema_name":"instruments_schema","url":"https://reference-data-api.kaiko.io/v1/","suffix":"instruments","allowed_instrument_classes":"spot,future,option,perpetual-future,etf,option_combo,future_combo"},{"endpoint_name":"Pools","data_type":"Reference data","description":"retrieves a dataframe of supported pools.","schema_name":"pools_schema","url":"https://reference-data-api.kaiko.io/v1/","suffix":"pools","allowed_instrument_classes":"-"},{"endpoint_name":"Real-time & Historical Trade Data","data_type":"Trade data","description":"retrieves trades for an instrument on a specific exchange.","schema_name":"trade_data_schema","url":"https://us.market-api.kaiko.io/v2/data/","suffix":"{}.{}/exchanges/{}/{}/{}/trades","allowed_instrument_classes":"spot,future,option,perpetual-future,etf,option_combo,future_combo"},{"endpoint_name":"Order Book Snapshots: Full","data_type":"Order Book data","description":"returns all the following one month of historical order book data: the snapshot itself (bids and asks), the depth of the order book (the cummulative volume of the base asset at 0.1%, 0.2%, 0.3%, 0.4%, 0.5%, 0.6%, 0.7%, 0.8%, 0.9%, 1%, 1.5%, 2%, 4%, 6%, 8% and 10% from the best ask and best bid respectively), the spread, the mid price and, when the slippage parameter is not empty, the percentage of slippage for a given order size, either calculated from the best bid/ask or calculated from the mid price.","schema_name":"order_book_snapshots_full_schema","url":"https://us.market-api.kaiko.io/v2/data/","suffix":"{}.{}/exchanges/{}/{}/{}/snapshots/full","allowed_instrument_classes":"spot,future,option,perpetual-future,etf,option_combo,future_combo"},{"endpoint_name":"Order Book Snapshots: Raw","data_type":"Order Book data","description":"returns the one month of historical raw snapshots of bids and asks without any additional metrics.","schema_name":"order_book_snapshots_raw_schema","url":"https://us.market-api.kaiko.io/v2/data/","suffix":"{}.{}/exchanges/{}/{}/{}/snapshots/raw","allowed_instrument_classes":"spot,future,option,perpetual-future,etf,option_combo,future_combo"},{"endpoint_name":"Order Book Snapshots: Depth","data_type":"Order Book data","description":"returns the one month of metrics on the depth of the order book (the cummulative volume of the base asset at 0.1%, 0.2%, 0.3%, 0.4%, 0.5%, 0.6%, 0.7%, 0.8%, 0.9%, 1%, 1.5%, 2%, 4%, 6%, 8% and 10% from the mid price) per snapshot.","schema_name":"order_book_snapshots_depth_schema","url":"https://us.market-api.kaiko.io/v2/data/","suffix":"{}.{}/exchanges/{}/{}/{}/snapshots/depth","allowed_instrument_classes":"spot,future,option,perpetual-future,etf,option_combo,future_combo"},{"endpoint_name":"Order Book Snapshots: Slippage","data_type":"Order Book data","description":"returns slippage for a given order size, either calculated from the best bid/ask or calculated from the mid price.","schema_name":"order_book_snapshots_slippage_schema","url":"https://us.market-api.kaiko.io/v2/data/","suffix":"{}.{}/exchanges/{}/{}/{}/snapshots/slippage","allowed_instrument_classes":"spot,future,option,perpetual-future,etf,option_combo,future_combo"},{"endpoint_name":"Order Book Aggregations: Full","data_type":"Order Book data","description":"gives access to one month of historical 10% order book aggregated data. It returns metrics on the average depth of the order book (the cummulative volume of the base asset at 0.1%, 0.2%, 0.3%, 0.4%, 0.5%, 0.6%, 0.7%, 0.8%, 0.9%, 1%, 1.5%, 2%, 4%, 6%, 8% and 10% from the mid price), the average spread, the average mid price and, when the slippage parameter is not empty, the average percentage of slippage for a given order size, either calculated from the best bid/ask or calculated from the mid price for a given interval. For each interval, the aggregates are calculated by taking the average metrics of each snapshot within that interval. For example, the aggregated 1 hour spread is calculated by taking all spreads of each snapshot within an hour and calculating the average.","schema_name":"order_book_aggregations_full_schema","url":"https://us.market-api.kaiko.io/v2/data/","suffix":"{}.{}/exchanges/{}/{}/{}/ob_aggregations/full","allowed_instrument_classes":"spot,future,option,perpetual-future,etf,option_combo,future_combo"},{"endpoint_name":"Order Book Aggregations: Depth","data_type":"Order Book data","description":"returns metrics on average the depth of the order book (the cummulative volume of the base asset at 0.1%, 0.2%, 0.3%, 0.4%, 0.5%, 0.6%, 0.7%, 0.8%, 0.9%, 1%, 1.5%, 2%, 4%, 6%, 8% and 10% from the mid price) per snapshot. For each interval, the aggregates are calculated by taking the average metrics of each snapshot within that interval. For example, the aggregated 1 hour spread is calculated by taking all spreads of each snapshot within an hour and calculating the average.","schema_name":"order_book_aggregations_depth_schema","url":"https://us.market-api.kaiko.io/v2/data/","suffix":"{}.{}/exchanges/{}/{}/{}/ob_aggregations/depth","allowed_instrument_classes":"spot,future,option,perpetual-future,etf,option_combo,future_combo"},{"endpoint_name":"Order Book Aggregations: Slippage","data_type":"Order Book data","description":"returns the average slippage for a given order size, either calculated from the best bid/ask or calculated from the mid price. For each interval, the aggregates are calculated by taking the average metrics of each snapshot within that interval.u00a0For example, the aggregated 1 hour spread is calculated by taking all spreads of each snapshot within an hour and calculating the average.","schema_name":"order_book_aggregations_slippage_schema","url":"https://us.market-api.kaiko.io/v2/data/","suffix":"{}.{}/exchanges/{}/{}/{}/ob_aggregations/slippage","allowed_instrument_classes":"spot,future,option,perpetual-future,etf,option_combo,future_combo"},{"endpoint_name":"OHLCV (Candles)","data_type":"Aggregates","description":"retrieves the OHLCV history for an instrument on an exchange. The interval parameter is suffixed with s, m, h or d to specify seconds, minutes, hours or days, respectively.","schema_name":"ohlcv_candles_schema","url":"https://us.market-api.kaiko.io/v2/data/","suffix":"{}.{}/exchanges/{}/{}/{}/aggregations/ohlcv","allowed_instrument_classes":"spot,future,option,perpetual-future,etf,option_combo,future_combo"},{"endpoint_name":"VWAP (Prices)","data_type":"Aggregates","description":"retrieves aggregated VWAP (volume-weighted average price) history for an instrument on an exchange. The interval parameter is suffixed with s, m, h or d to specify seconds, minutes, hours or days, respectively.","schema_name":"vwap_prices_schema","url":"https://us.market-api.kaiko.io/v2/data/","suffix":"{}.{}/exchanges/{}/{}/{}/aggregations/vwap","allowed_instrument_classes":"spot,future,option,perpetual-future,etf,option_combo,future_combo"},{"endpoint_name":"Count-OHLCV-VWAP","data_type":"Aggregates","description":"retrieves the trade count, OHLCV and VWAP history for an instrument on an exchange. The interval parameter is suffixed with s, m, h or d to specify seconds, minutes, hours or days, respectively.","schema_name":"count_ohlcv_vwap_schema","url":"https://us.market-api.kaiko.io/v2/data/","suffix":"{}.{}/exchanges/{}/{}/{}/aggregations/count_ohlcv_vwap","allowed_instrument_classes":"spot,future,option,perpetual-future,etf,option_combo,future_combo"},{"endpoint_name":"Asset Price - Aggregated VWAP","data_type":"Pricing Services","description":"generates an aggregated price for an asset pair across all exchanges with spot markets for the pair. Only asset combinations which are actively being traded on one of our covered exchanges are being taken into account for the calculation of the price. Unsupported asset combinations will return no data. To return data used as input for the calculation of the aggregated price, set the sources parameter to True. Setting the sources parameter to False (default) will yield a faster response time. ","schema_name":"asset_price_schema","url":"https://us.market-api.kaiko.io/v2/data/","suffix":"trades.{}/spot_direct_exchange_rate/{}/{}","allowed_instrument_classes":"spot,future,option,perpetual-future,etf,option_combo,future_combo"},{"endpoint_name":"Robust Pair Price","data_type":"Pricing Services","description":"Retrieve Kaikou2019s proprietary aggregated price. The new methodology aims to be more resilient and robust to outliers. The computation is based on two principles:nA robust aggregation of prices (derived from a weighted median methodology: full details available here)nAn incremental increase of the estimation window seeking for sufficient dataset to compute a robust price (e.g. number of trades under a certain threshold)nAt the end of the algorithm, in case there are still no trades, a null value will be returned.","schema_name":"robust_pair_price_schema","url":"https://us.market-api.kaiko.io/v2/data/","suffix":"trades.{}/robust_pair_price/{}/{}","allowed_instrument_classes":"spot,future,option,perpetual-future,etf,option_combo,future_combo"},{"endpoint_name":"Cross Price","data_type":"Pricing Services","description":"[Not supported] returns the price of any asset quoted in a Fiat currency within Open Exchange Rate. The USD price is calculated based on the path of the highest liquidity, with an additional step using forex rates to get the final fiat price. This means that, even though an asset might trade directly against all Open Exchange Rate currencies, the price might still be established by using cross-rates1","schema_name":"cross_price_schema","url":"https://us.market-api.kaiko.io/v2/data/","suffix":"trades.{}/spot_exchange_rate/{}/{}","allowed_instrument_classes":"spot,future,option,perpetual-future,etf,option_combo,future_combo"},{"endpoint_name":"OANDA FX Rates","data_type":"Pricing Services","description":"The OANDA FX Rates endpoint provides auditable, reliable and IFRS compliant FX rates for over 70 forex pairs.","schema_name":"oanda_fx_rates_schema","url":"https://us.market-api.kaiko.io/v2/data/","suffix":"analytics.{}/oanda_fx_rates","allowed_instrument_classes":"spot,future,option,perpetual-future,etf,option_combo,future_combo"},{"endpoint_name":"Liquidity Events","data_type":"DEX Liquidity","description":"provides flows data about the mint & the burn (adds & removals) type transactions associated to tokens amounts registered on DEXs liquidity pools. This data is made available at a transactional level and at a block granularity.","schema_name":"liquidity_events_schema","url":"https://us.market-api.kaiko.io/v2/data/","suffix":"liquidity.v1/events","allowed_instrument_classes":"spot"},{"endpoint_name":"Liquidity Snapshots","data_type":"DEX Liquidity","description":"provides the total amount of reserves per token, made available at a liquidity pool level for all the covered DEXs. Specifically for Uniswap V3, this data is also made available in a per tick level, and enables the users to visualise the distribution of liquidity across ticks, for every block and liquidity pool available on Uniswap V3.","schema_name":"liquidity_snapshots_schema","url":"https://us.market-api.kaiko.io/v2/data/","suffix":"liquidity.v1/snapshots","allowed_instrument_classes":"spot"},{"endpoint_name":"Uniswap v3 Liquidity Snapshots","data_type":"DEX Liquidity","description":"Uniswapu2019s v3 liquidity snapshots are represented by a distribution of liquidity amongst all possible price levels for a pair of tokens. Each price range is defined by the interval [lower_tick, upper_tick[. This dataset provides the amount of tokens and liquidity made available at each price level. The range of price levels is limited to u00b110% around the current price of each block. The data is provided in a block-by-block granularity.","schema_name":"uniswap_v3_liquidity_snapshot_schema","url":"https://us.market-api.kaiko.io/v2/data/","suffix":"liquidity.v1/snapshots/usp3","allowed_instrument_classes":"spot"},{"endpoint_name":"Lending and Borrowing Events","data_type":"Lending & Borrowing Protocols","description":"Transactions (borrows, repayments, withdrawals, deposits and liquidations) registered on-chain, for the main L&B protocols.","schema_name":"lending_and_borrowing_events_schema","url":"https://us.market-api.kaiko.io/v2/data/","suffix":"lending.v1/events","allowed_instrument_classes":"spot"},{"endpoint_name":"Lending & Borrowing Rates and Liquidity","data_type":"Lending & Borrowing Protocols","description":"This endpoint provides information about lending pools. It shows data such as how many tokens has been deposited and borrowed, as well as the interest rates for lending and borrowing at each block.","schema_name":"lending_and_borrowing_snapshots_schema","url":"https://us.market-api.kaiko.io/v2/data/","suffix":"lending.v1/snapshots","allowed_instrument_classes":"spot"},{"endpoint_name":"Custom Valuation","data_type":"Portfolio Solutions","description":"allows you to build completely customizable single-asset or multi-asset price feeds for NAV calculations, portfolio valuation, asset allocation strategies, and indices.","schema_name":"valuation_schema","url":"https://us.market-api.kaiko.io/v2/data/","suffix":"trades.{}/valuation","allowed_instrument_classes":""},{"endpoint_name":"Value at Risk","data_type":"Portfolio Solutions","description":"Daily Value at Risk (VaR) estimator for single and multi-asset portfolios. Computed by a proprietary and thoroughly backtested methodology that accounts for the idiosyncrasies of crypto market structure.","schema_name":"value_at_risk_schema","url":"https://us.market-api.kaiko.io/v2/data/","suffix":"analytics.{}/value_at_risk","allowed_instrument_classes":""},{"endpoint_name":"Derivatives Metrics: Reference","data_type":"Derivatives Metrics","description":"provides details of the contracts, including base asset, quote asset, contract size, contract size unit, listing_timestamp, expiry, strike price, and underlying index.","schema_name":"reference_schema","url":"https://us.market-api.kaiko.io/v2/data/","suffix":"derivatives.v2/reference","allowed_instrument_classes":"future,option,perpetual-future,option_combo,future_combo"},{"endpoint_name":"Derivatives Metrics: Risk","data_type":"Derivatives Metrics","description":"indicates data that can be used to analyze risks related with derivatives, such as open interest, funidng rates, and option greeks.","schema_name":"risk_schema","url":"https://us.market-api.kaiko.io/v2/data/","suffix":"derivatives.v2/price","allowed_instrument_classes":"future,option,perpetual-future,option_combo,future_combo"},{"endpoint_name":"Derivatives Metrics: Price","data_type":"Derivatives Metrics","description":"shows the mark price, index price, and price (last traded price).","schema_name":"price_schema","url":"https://us.market-api.kaiko.io/v2/data/","suffix":"derivatives.v2/risk","allowed_instrument_classes":"future,option,perpetual-future,option_combo,future_combo"},{"endpoint_name":"Implied Volatility Smile","data_type":"Derivatives Analytics","description":"This analytics API suite provides calibrated implied volatilities extracted from options market prices. The implied_volatility_smile endpoint returns a volatility curve for a listed expiry date computed on a set of strike prices. The computation includes space interpolation and allows users to compute consistent volatilities on non-listed strikes. Implied volatilities for non-listed expiries will be coming soon.","schema_name":"iv_smile_schema","url":"https://us.market-api.kaiko.io/v2/data/","suffix":"analytics.v2/implied_volatility_smile","allowed_instrument_classes":"future,option,perpetual-future,option_combo,future_combo"},{"endpoint_name":"Implied Volatility Surface","data_type":"Derivatives Analytics","description":"Retrieve calibrated and interpolated implied volatilities from options market prices. The implied_volatility_surface endpoint returns a volatility surface for a given list of expiries or time-to-expiries grid and a given set of strike prices or forward log moneyness grid. The computation includes space and time interpolation and allows users to compute consistent volatilities on non-listed strikes and non-listed expiries.","schema_name":"iv_surface_schema","url":"https://us.market-api.kaiko.io/v2/data/","suffix":"analytics.v2/implied_volatility_surface","allowed_instrument_classes":"future,option,perpetual-future,option_combo,future_combo"},{"endpoint_name":"Asset Metrics","data_type":"Market & Asset Analytics","description":"Retrieve off-chain and on-chain metrics that help performing asset analysis. Data is aggregated across all instruments trading the given asset (See Instruments Reference Data Endpoint).nnTrading activity includes total volume (in USD and asset unit), total trade count, total CeX volume (in USD and asset unit), total CeX trade count, total DeX volume (in USD and asset unit), and total DeX trade count and detailed information by exchange. Trades data is aggregated accross all instruments including the token as base or quote asset.nnLiquidity information includes total buy market depth (CeX only) for several price deviations (from 0.1% to 10%), total sell market depth (CeX only) for several price deviations (from 0.1% to 10%) and detailed information by exchange. Liquidity data is aggregated accross all instruments including the token as base asset only. Market Depth for DeXs available soon.nnTokenu2019s information include tokenu2019s address, total supply, number of holders (addresses), main holders (who owns more than 1% of the total supply). Only available for some ERC-20 tokens (new tokens can be added on demand).n","schema_name":"asset_metrics_schema","url":"https://us.market-api.kaiko.io/v2/data/","suffix":"analytics.v2/asset_metrics","allowed_instrument_classes":"spot"}]


# ++++ API WRAPPER PARAMETERS ++++ 
api_wrapper_params = [{"parameter":"endpoint_name","type":"string","required":True,"default":"","parameter_comment":"The name of the endpoint","ref_data":"","Assets":"","Exchanges":"","Instruments":"","Pools":"","Real-time & Historical Trade Data":"","Order Book Snapshots: Full":"","Order Book Snapshots: Raw":"","Order Book Snapshots: Depth":"","Order Book Snapshots: Slippage":"","Order Book Aggregations: Full":"","Order Book Aggregations: Depth":"","Order Book Aggregations: Slippage":"","OHLCV (Candles)":"","VWAP (Prices)":"","Count-OHLCV-VWAP":"","Asset Price - Aggregated VWAP":"","Robust Pair Price":"","Cross Price":"","OANDA FX Rates":"","Liquidity Events":"","Liquidity Snapshots":"","Uniswap v3 Liquidity Snapshots":"","Lending and Borrowing Events":"","Lending & Borrowing Rates and Liquidity":"","Custom Valuation":"","Value at Risk":"","Derivatives Metrics: Reference":"","Derivatives Metrics: Risk":"","Derivatives Metrics: Price":"","Implied Volatility Smile":"","Implied Volatility Surface":"","Asset Metrics":""},{"parameter":"multiprocessing","type":"boolean","required":True,"default":False,"parameter_comment":"Turn on/off async requests (beware: has to be executed under __name__ == '__main__' condition)  [Only relevant for Market Data]","ref_data":"","Assets":"-","Exchanges":"-","Instruments":"-","Pools":"-","Real-time & Historical Trade Data":1.0,"Order Book Snapshots: Full":1.0,"Order Book Snapshots: Raw":1.0,"Order Book Snapshots: Depth":1.0,"Order Book Snapshots: Slippage":1.0,"Order Book Aggregations: Full":1.0,"Order Book Aggregations: Depth":1.0,"Order Book Aggregations: Slippage":1.0,"OHLCV (Candles)":1.0,"VWAP (Prices)":1.0,"Count-OHLCV-VWAP":1.0,"Asset Price - Aggregated VWAP":1.0,"Robust Pair Price":1.0,"Cross Price":1.0,"OANDA FX Rates":1.0,"Liquidity Events":1.0,"Liquidity Snapshots":1.0,"Uniswap v3 Liquidity Snapshots":1.0,"Lending and Borrowing Events":1.0,"Lending & Borrowing Rates and Liquidity":1.0,"Custom Valuation":1.0,"Value at Risk":1.0,"Derivatives Metrics: Reference":1.0,"Derivatives Metrics: Risk":1.0,"Derivatives Metrics: Price":1.0,"Implied Volatility Smile":1.0,"Implied Volatility Surface":1.0,"Asset Metrics":1.0},{"parameter":"usd_conversion","type":"boolean","required":True,"default":True,"parameter_comment":"Convert values into USD  [Only relevant for Market Data]","ref_data":"","Assets":"-","Exchanges":"-","Instruments":"-","Pools":"-","Real-time & Historical Trade Data":"amount","Order Book Snapshots: Full":"bid_volume,ask_volume","Order Book Snapshots: Raw":"","Order Book Snapshots: Depth":"bid_volume,ask_volume","Order Book Snapshots: Slippage":"","Order Book Aggregations: Full":1.0,"Order Book Aggregations: Depth":1.0,"Order Book Aggregations: Slippage":1.0,"OHLCV (Candles)":1.0,"VWAP (Prices)":1.0,"Count-OHLCV-VWAP":1.0,"Asset Price - Aggregated VWAP":"-","Robust Pair Price":"-","Cross Price":"-","OANDA FX Rates":"-","Liquidity Events":1.0,"Liquidity Snapshots":1.0,"Uniswap v3 Liquidity Snapshots":1.0,"Lending and Borrowing Events":1.0,"Lending & Borrowing Rates and Liquidity":1.0,"Custom Valuation":"-","Value at Risk":"-","Derivatives Metrics: Reference":"-","Derivatives Metrics: Risk":"-","Derivatives Metrics: Price":"-","Implied Volatility Smile":"-","Implied Volatility Surface":"-","Asset Metrics":"-"},{"parameter":"period","type":"list","required":True,"default":"Last month","parameter_comment":"Start and end dates in the format 'YYYY-MM-DD', if only one value is specified in the list, will treat it as a start date and today's date as the end date.  [Only relevant for Market Data]","ref_data":"","Assets":"-","Exchanges":"-","Instruments":"trade_start_timestamp,trade_end_timestamp","Pools":"-","Real-time & Historical Trade Data":"start_time,end_time","Order Book Snapshots: Full":"start_time,end_time","Order Book Snapshots: Raw":"start_time,end_time","Order Book Snapshots: Depth":"start_time,end_time","Order Book Snapshots: Slippage":"start_time,end_time","Order Book Aggregations: Full":"start_time,end_time","Order Book Aggregations: Depth":"start_time,end_time","Order Book Aggregations: Slippage":"start_time,end_time","OHLCV (Candles)":"start_time,end_time","VWAP (Prices)":"start_time,end_time","Count-OHLCV-VWAP":"start_time,end_time","Asset Price - Aggregated VWAP":"start_time,end_time","Robust Pair Price":"start_time,end_time","Cross Price":"start_time,end_time","OANDA FX Rates":"start_time,end_time","Liquidity Events":"start_time,end_time","Liquidity Snapshots":"start_time,end_time","Uniswap v3 Liquidity Snapshots":"start_time,end_time","Lending and Borrowing Events":"start_time,end_time","Lending & Borrowing Rates and Liquidity":"start_time,end_time","Custom Valuation":"start_time,end_time","Value at Risk":"start_time,end_time","Derivatives Metrics: Reference":"start_time,end_time","Derivatives Metrics: Risk":"start_time,end_time","Derivatives Metrics: Price":"start_time,end_time","Implied Volatility Smile":"time,expiry","Implied Volatility Surface":"time,expiry_list","Asset Metrics":"start_time,end_time"},{"parameter":"base_assets","type":"list","required":False,"default":"All","parameter_comment":"The list of base asset codes  [Only relevant for Market Data]","ref_data":"base_asset","Assets":"-","Exchanges":"-","Instruments":"base_asset,base_asset","Pools":"tokens,base_asset","Real-time & Historical Trade Data":"instrument,code","Order Book Snapshots: Full":"instrument,code","Order Book Snapshots: Raw":"instrument,code","Order Book Snapshots: Depth":"instrument,code","Order Book Snapshots: Slippage":"instrument,code","Order Book Aggregations: Full":"instrument,code","Order Book Aggregations: Depth":"instrument,code","Order Book Aggregations: Slippage":"instrument,code","OHLCV (Candles)":"instrument,code","VWAP (Prices)":"instrument,code","Count-OHLCV-VWAP":"instrument,code","Asset Price - Aggregated VWAP":"base_asset,base_asset","Robust Pair Price":"base_asset,base_asset","Cross Price":"base_asset,base_asset","OANDA FX Rates":"base,base_asset","Liquidity Events":"-","Liquidity Snapshots":"-","Uniswap v3 Liquidity Snapshots":"-","Lending and Borrowing Events":"asset,base_asset","Lending & Borrowing Rates and Liquidity":"asset,base_asset","Custom Valuation":"bases,base_asset","Value at Risk":"bases,base_asset","Derivatives Metrics: Reference":"base_assets,base_asset","Derivatives Metrics: Risk":"instrument,code","Derivatives Metrics: Price":"instrument,code","Implied Volatility Smile":"base,base_asset","Implied Volatility Surface":"base,base_asset","Asset Metrics":"base,base_asset"},{"parameter":"quote_assets","type":"list","required":False,"default":"All","parameter_comment":"The list of quote asset codes  [Only relevant for Market Data]","ref_data":"quote_asset","Assets":"-","Exchanges":"-","Instruments":"quote_asset,quote_asset","Pools":"-","Real-time & Historical Trade Data":"instrument,code","Order Book Snapshots: Full":"instrument,code","Order Book Snapshots: Raw":"instrument,code","Order Book Snapshots: Depth":"instrument,code","Order Book Snapshots: Slippage":"instrument,code","Order Book Aggregations: Full":"instrument,code","Order Book Aggregations: Depth":"instrument,code","Order Book Aggregations: Slippage":"instrument,code","OHLCV (Candles)":"instrument,code","VWAP (Prices)":"instrument,code","Count-OHLCV-VWAP":"instrument,code","Asset Price - Aggregated VWAP":"quote_asset,quote_asset","Robust Pair Price":"quote_asset,quote_asset","Cross Price":"quote_asset,quote_asset","OANDA FX Rates":"quote,quote_asset","Liquidity Events":"-","Liquidity Snapshots":"-","Uniswap v3 Liquidity Snapshots":"-","Lending and Borrowing Events":"-","Lending & Borrowing Rates and Liquidity":"-","Custom Valuation":"quote,quote_asset","Value at Risk":"quote,quote_asset","Derivatives Metrics: Reference":"quote_asset,quote_asset","Derivatives Metrics: Risk":"instrument,code","Derivatives Metrics: Price":"instrument,code","Implied Volatility Smile":"quote,quote_asset","Implied Volatility Surface":"quote,quote_asset","Asset Metrics":"-"},{"parameter":"instrument_classes","type":"list","required":False,"default":"All","parameter_comment":"The list of instrument classes  [Only relevant for Market Data]","ref_data":"class","Assets":"-","Exchanges":"-","Instruments":"class,class","Pools":"-","Real-time & Historical Trade Data":"instrument_class,class","Order Book Snapshots: Full":"instrument_class,class","Order Book Snapshots: Raw":"instrument_class,class","Order Book Snapshots: Depth":"instrument_class,class","Order Book Snapshots: Slippage":"instrument_class,class","Order Book Aggregations: Full":"instrument_class,class","Order Book Aggregations: Depth":"instrument_class,class","Order Book Aggregations: Slippage":"instrument_class,class","OHLCV (Candles)":"instrument_class,class","VWAP (Prices)":"instrument_class,class","Count-OHLCV-VWAP":"instrument_class,class","Asset Price - Aggregated VWAP":"-","Robust Pair Price":"-","Cross Price":"-","OANDA FX Rates":"-","Liquidity Events":"-","Liquidity Snapshots":"-","Uniswap v3 Liquidity Snapshots":"-","Lending and Borrowing Events":"-","Lending & Borrowing Rates and Liquidity":"-","Custom Valuation":"-","Value at Risk":"-","Derivatives Metrics: Reference":"instrument_class,class","Derivatives Metrics: Risk":"instrument_class,class","Derivatives Metrics: Price":"instrument_class,class","Implied Volatility Smile":"-","Implied Volatility Surface":"-","Asset Metrics":"-"},{"parameter":"exchanges","type":"list","required":False,"default":"All","parameter_comment":"The list of exchange codes  [Only relevant for Market Data]","ref_data":"exchange_code","Assets":"-","Exchanges":"-","Instruments":"exchange_code,exchange_code","Pools":"-","Real-time & Historical Trade Data":"exchange,exchange_code","Order Book Snapshots: Full":"exchange,exchange_code","Order Book Snapshots: Raw":"exchange,exchange_code","Order Book Snapshots: Depth":"exchange,exchange_code","Order Book Snapshots: Slippage":"exchange,exchange_code","Order Book Aggregations: Full":"exchange,exchange_code","Order Book Aggregations: Depth":"exchange,exchange_code","Order Book Aggregations: Slippage":"exchange,exchange_code","OHLCV (Candles)":"exchange,exchange_code","VWAP (Prices)":"exchange,exchange_code","Count-OHLCV-VWAP":"exchange,exchange_code","Asset Price - Aggregated VWAP":"-","Robust Pair Price":"-","Cross Price":"-","OANDA FX Rates":"-","Liquidity Events":"-","Liquidity Snapshots":"-","Uniswap v3 Liquidity Snapshots":"-","Lending and Borrowing Events":"-","Lending & Borrowing Rates and Liquidity":"-","Custom Valuation":"exchanges,exchange_code","Value at Risk":"exchanges,exchange_code","Derivatives Metrics: Reference":"exchange,exchange_code","Derivatives Metrics: Risk":"exchange,exchange_code","Derivatives Metrics: Price":"exchange,exchange_code","Implied Volatility Smile":"exchange,exchange_code","Implied Volatility Surface":"-","Asset Metrics":"-"},{"parameter":"pools","type":"list","required":False,"default":"All","parameter_comment":"The list of pool codes  [Only relevant for Market Data]","ref_data":"","Assets":"-","Exchanges":"-","Instruments":"-","Pools":"address,address","Real-time & Historical Trade Data":"-","Order Book Snapshots: Full":"-","Order Book Snapshots: Raw":"-","Order Book Snapshots: Depth":"-","Order Book Snapshots: Slippage":"-","Order Book Aggregations: Full":"-","Order Book Aggregations: Depth":"-","Order Book Aggregations: Slippage":"-","OHLCV (Candles)":"-","VWAP (Prices)":"-","Count-OHLCV-VWAP":"-","Asset Price - Aggregated VWAP":"-","Robust Pair Price":"-","Cross Price":"-","OANDA FX Rates":"-","Liquidity Events":"pool_address,address","Liquidity Snapshots":"pool_address,address","Uniswap v3 Liquidity Snapshots":"pool_address,address","Lending and Borrowing Events":"-","Lending & Borrowing Rates and Liquidity":"-","Custom Valuation":"-","Value at Risk":"-","Derivatives Metrics: Reference":"-","Derivatives Metrics: Risk":"-","Derivatives Metrics: Price":"-","Implied Volatility Smile":"-","Implied Volatility Surface":"-","Asset Metrics":"-"},{"parameter":"sources","type":"boolean","required":False,"default":False,"parameter_comment":"Indicator to return the data with sources ussed for aggregations  [Only relevant for Market Data]","ref_data":"","Assets":"-","Exchanges":"-","Instruments":"with_list_pools","Pools":"-","Real-time & Historical Trade Data":"-","Order Book Snapshots: Full":"-","Order Book Snapshots: Raw":"-","Order Book Snapshots: Depth":"-","Order Book Snapshots: Slippage":"-","Order Book Aggregations: Full":"-","Order Book Aggregations: Depth":"-","Order Book Aggregations: Slippage":"-","OHLCV (Candles)":"-","VWAP (Prices)":"-","Count-OHLCV-VWAP":"-","Asset Price - Aggregated VWAP":"sources","Robust Pair Price":"-","Cross Price":"sources","OANDA FX Rates":"-","Liquidity Events":"-","Liquidity Snapshots":"-","Uniswap v3 Liquidity Snapshots":"-","Lending and Borrowing Events":"-","Lending & Borrowing Rates and Liquidity":"-","Custom Valuation":"sources","Value at Risk":"sources","Derivatives Metrics: Reference":"-","Derivatives Metrics: Risk":"-","Derivatives Metrics: Price":"-","Implied Volatility Smile":"-","Implied Volatility Surface":"-","Asset Metrics":"sources"},{"parameter":"interval","type":"string","required":False,"default":"","parameter_comment":"The interval at which you want information, specific to endpoint, please check Kaiko API documentation  [Only relevant for Market Data]","ref_data":"","Assets":"-","Exchanges":"-","Instruments":"-","Pools":"-","Real-time & Historical Trade Data":"-","Order Book Snapshots: Full":"-","Order Book Snapshots: Raw":"-","Order Book Snapshots: Depth":"-","Order Book Snapshots: Slippage":"-","Order Book Aggregations: Full":"interval","Order Book Aggregations: Depth":"interval","Order Book Aggregations: Slippage":"interval","OHLCV (Candles)":"interval","VWAP (Prices)":"interval","Count-OHLCV-VWAP":"interval","Asset Price - Aggregated VWAP":"interval","Robust Pair Price":"interval","Cross Price":"interval","OANDA FX Rates":"interval","Liquidity Events":"-","Liquidity Snapshots":"-","Uniswap v3 Liquidity Snapshots":"-","Lending and Borrowing Events":"-","Lending & Borrowing Rates and Liquidity":"interval","Custom Valuation":"interval","Value at Risk":"-","Derivatives Metrics: Reference":"-","Derivatives Metrics: Risk":"interval","Derivatives Metrics: Price":"interval","Implied Volatility Smile":"-","Implied Volatility Surface":"-","Asset Metrics":"interval"},{"parameter":"continuation_token","type":"string","required":False,"default":"","parameter_comment":"The marker provided in the body of the API response to retrieve the next segment of a larger set of results  [Only relevant for Market Data]","ref_data":"","Assets":"-","Exchanges":"-","Instruments":"continuation_token","Pools":"-","Real-time & Historical Trade Data":"continuation_token","Order Book Snapshots: Full":"continuation_token","Order Book Snapshots: Raw":"continuation_token","Order Book Snapshots: Depth":"continuation_token","Order Book Snapshots: Slippage":"continuation_token","Order Book Aggregations: Full":"continuation_token","Order Book Aggregations: Depth":"continuation_token","Order Book Aggregations: Slippage":"continuation_token","OHLCV (Candles)":"continuation_token","VWAP (Prices)":"continuation_token","Count-OHLCV-VWAP":"continuation_token","Asset Price - Aggregated VWAP":"-","Robust Pair Price":"-","Cross Price":"-","OANDA FX Rates":"continuation_token","Liquidity Events":"-","Liquidity Snapshots":"-","Uniswap v3 Liquidity Snapshots":"-","Lending and Borrowing Events":"-","Lending & Borrowing Rates and Liquidity":"-","Custom Valuation":"continuation_token","Value at Risk":"-","Derivatives Metrics: Reference":"-","Derivatives Metrics: Risk":"-","Derivatives Metrics: Price":"-","Implied Volatility Smile":"-","Implied Volatility Surface":"-","Asset Metrics":"-"},{"parameter":"page_size","type":"integer","required":False,"default":"","parameter_comment":"The maximum number of records to return in one response  [Only relevant for Market Data]","ref_data":"","Assets":"-","Exchanges":"-","Instruments":"page_size","Pools":"-","Real-time & Historical Trade Data":"page_size","Order Book Snapshots: Full":"page_size","Order Book Snapshots: Raw":"page_size","Order Book Snapshots: Depth":"page_size","Order Book Snapshots: Slippage":"page_size","Order Book Aggregations: Full":"page_size","Order Book Aggregations: Depth":"page_size","Order Book Aggregations: Slippage":"page_size","OHLCV (Candles)":"page_size","VWAP (Prices)":"page_size","Count-OHLCV-VWAP":"page_size","Asset Price - Aggregated VWAP":"page_size","Robust Pair Price":"-","Cross Price":"page_size","OANDA FX Rates":"page_size","Liquidity Events":"page_size","Liquidity Snapshots":"page_size","Uniswap v3 Liquidity Snapshots":"page_size","Lending and Borrowing Events":"page_size","Lending & Borrowing Rates and Liquidity":"-","Custom Valuation":"-","Value at Risk":"-","Derivatives Metrics: Reference":"page_size","Derivatives Metrics: Risk":"page_size","Derivatives Metrics: Price":"page_size","Implied Volatility Smile":"-","Implied Volatility Surface":"-","Asset Metrics":"page_size"},{"parameter":"commodity","type":"string","required":False,"default":"","parameter_comment":"The data commodity  [Only relevant for Market Data]","ref_data":"","Assets":"-","Exchanges":"-","Instruments":"-","Pools":"-","Real-time & Historical Trade Data":"commodity","Order Book Snapshots: Full":"commodity","Order Book Snapshots: Raw":"commodity","Order Book Snapshots: Depth":"commodity","Order Book Snapshots: Slippage":"commodity","Order Book Aggregations: Full":"commodity","Order Book Aggregations: Depth":"commodity","Order Book Aggregations: Slippage":"commodity","OHLCV (Candles)":"commodity","VWAP (Prices)":"commodity","Count-OHLCV-VWAP":"commodity","Asset Price - Aggregated VWAP":"-","Robust Pair Price":"-","Cross Price":"-","OANDA FX Rates":"-","Liquidity Events":"-","Liquidity Snapshots":"-","Uniswap v3 Liquidity Snapshots":"-","Lending and Borrowing Events":"-","Lending & Borrowing Rates and Liquidity":"-","Custom Valuation":"-","Value at Risk":"-","Derivatives Metrics: Reference":"-","Derivatives Metrics: Risk":"-","Derivatives Metrics: Price":"-","Implied Volatility Smile":"-","Implied Volatility Surface":"-","Asset Metrics":"-"},{"parameter":"data_version","type":"string","required":False,"default":"","parameter_comment":"The data version  [Only relevant for Market Data]","ref_data":"","Assets":"-","Exchanges":"-","Instruments":"-","Pools":"-","Real-time & Historical Trade Data":"data_version","Order Book Snapshots: Full":"data_version","Order Book Snapshots: Raw":"data_version","Order Book Snapshots: Depth":"data_version","Order Book Snapshots: Slippage":"data_version","Order Book Aggregations: Full":"data_version","Order Book Aggregations: Depth":"data_version","Order Book Aggregations: Slippage":"data_version","OHLCV (Candles)":"data_version","VWAP (Prices)":"data_version","Count-OHLCV-VWAP":"data_version","Asset Price - Aggregated VWAP":"data_version","Robust Pair Price":"-","Cross Price":"data_version","OANDA FX Rates":"data_version","Liquidity Events":"-","Liquidity Snapshots":"-","Uniswap v3 Liquidity Snapshots":"-","Lending and Borrowing Events":"-","Lending & Borrowing Rates and Liquidity":"-","Custom Valuation":"data_version","Value at Risk":"data_version","Derivatives Metrics: Reference":"-","Derivatives Metrics: Risk":"-","Derivatives Metrics: Price":"-","Implied Volatility Smile":"-","Implied Volatility Surface":"-","Asset Metrics":"-"},{"parameter":"sort","type":"string","required":False,"default":"Descending","parameter_comment":"Return the data in ascending or descending order  [Only relevant for Market Data]","ref_data":"","Assets":"-","Exchanges":"-","Instruments":"order","Pools":"-","Real-time & Historical Trade Data":"-","Order Book Snapshots: Full":"sort","Order Book Snapshots: Raw":"sort","Order Book Snapshots: Depth":"sort","Order Book Snapshots: Slippage":"sort","Order Book Aggregations: Full":"sort","Order Book Aggregations: Depth":"sort","Order Book Aggregations: Slippage":"sort","OHLCV (Candles)":"sort","VWAP (Prices)":"sort","Count-OHLCV-VWAP":"sort","Asset Price - Aggregated VWAP":"sort","Robust Pair Price":"-","Cross Price":"sort","OANDA FX Rates":"sort","Liquidity Events":"sort","Liquidity Snapshots":"sort","Uniswap v3 Liquidity Snapshots":"-","Lending and Borrowing Events":"sort","Lending & Borrowing Rates and Liquidity":"-","Custom Valuation":"-","Value at Risk":"-","Derivatives Metrics: Reference":"-","Derivatives Metrics: Risk":"sort","Derivatives Metrics: Price":"sort","Implied Volatility Smile":"-","Implied Volatility Surface":"-","Asset Metrics":"-"}]


# ++++ ENDPOINTS SCHEMAS ++++ 
# REFERENCE DATA
# Instruments
instruments_schema = {'exchange_code': {'type': 'string', 'required': False, 'part_of_query': True}, 'base_asset': {'type': 'string', 'required': False, 'part_of_query': True}, 'quote_asset': {'type': 'string', 'required': False, 'part_of_query': True}, 'code': {'type': 'string', 'required': False, 'part_of_query': True}, 'kaiko_legacy_symbol': {'type': 'string', 'required': False, 'part_of_query': True}, 'class': {'type': 'string', 'required': False, 'part_of_query': True, 'allowed': ['spot', 'future', 'perpetual-future']}, 'base_asset_class': {'type': 'string', 'required': False, 'part_of_query': True, 'allowed': ['cryptocurrency', 'fiat', 'stablecoin', 'commodity', 'leveraged-token']}, 'quote_asset_class': {'type': 'string', 'required': False, 'part_of_query': True, 'allowed': ['cryptocurrency', 'fiat', 'stablecoin', 'commodity', 'leveraged-token']}, 'trade_start_timestamp': {'type': 'string', 'required': False, 'part_of_query': True}, 'trade_end_timestamp': {'type': 'string', 'required': False, 'part_of_query': True}, 'trade_count_min': {'type': 'string', 'required': False, 'part_of_query': True}, 'trade_count_max': {'type': 'string', 'required': False, 'part_of_query': True}, 'with_list_pools': {'type': 'boolean', 'required': False, 'part_of_query': True}, 'continuation_token': {'type': 'string', 'required': False, 'part_of_query': True}, 'page_size': {'type': 'integer', 'required': False, 'part_of_query': True}, 'orderBy': {'type': 'string', 'required': False, 'part_of_query': True, 'allowed': ['exchange_code', 'class', 'kaiko_legacy_symbol', 'trade_start_timestamp', 'trade_end_timestamp', 'trade_count', 'base_asset', 'quote_asset', 'code', 'trade_count_min', 'trade_count_max']}, 'order': {'type': 'string', 'required': False, 'part_of_query': True, 'allowed': ['1', '-1']}}
# Pools
pools_schema = {'address': {'type': 'string', 'required': False, 'part_of_query': True}, 'protocol': {'type': 'string', 'required': False, 'part_of_query': True}, 'type': {'type': 'string', 'required': False, 'part_of_query': True}, 'fee': {'type': 'string', 'required': False, 'part_of_query': True}, 'tokens': {'type': 'string', 'required': False, 'part_of_query': True}, 'underlying_tokens': {'type': 'string', 'required': False, 'part_of_query': True}}

# TRADE DATA
# Real-time & Historical Trade Data
trade_data_schema = {'commodity': {'type': 'string', 'required': True, 'part_of_query': False, 'allowed': ['trades'], 'default': 'trades'}, 'continuation_token': {'type': 'string', 'required': False, 'part_of_query': True}, 'data_version': {'type': 'string', 'required': True, 'part_of_query': False, 'allowed': ['v1', 'v2'], 'default': 'v1'}, 'end_time': {'type': 'string', 'required': False, 'part_of_query': True, 'default': '2023-01-31T00:00:00.000Z', 'validator': validate_time}, 'exchange': {'type': 'string', 'required': True, 'part_of_query': False, 'default': 'krkn'}, 'instrument_class': {'type': 'string', 'required': True, 'part_of_query': False, 'allowed': ['spot', 'future', 'perpetual-future'], 'default': 'spot'}, 'instrument': {'type': 'string', 'required': True, 'part_of_query': False, 'default': 'btc-usdt'}, 'page_size': {'type': 'integer', 'required': False, 'part_of_query': True, 'default': 100000}, 'start_time': {'type': 'string', 'required': False, 'part_of_query': True, 'default': '2022-10-01T00:00:00.000Z', 'validator': validate_time}}

# ORDER BOOK DATA
# Order Book Snapshots: Full
order_book_snapshots_full_schema = {'commodity': {'type': 'string', 'required': True, 'part_of_query': False, 'allowed': ['order_book_snapshots'], 'default': 'order_book_snapshots'}, 'continuation_token': {'type': 'string', 'required': False, 'part_of_query': True}, 'data_version': {'type': 'string', 'required': True, 'part_of_query': False, 'allowed': ['v1', 'v2'], 'default': 'v1'}, 'end_time': {'type': 'string', 'required': False, 'part_of_query': True, 'validator': validate_time}, 'exchange': {'type': 'string', 'required': True, 'part_of_query': False, 'default': 'krkn'}, 'instrument_class': {'type': 'string', 'required': True, 'part_of_query': False, 'allowed': ['spot', 'future', 'perpetual-future'], 'default': 'spot'}, 'instrument': {'type': 'string', 'required': True, 'part_of_query': False, 'default': 'btc-usdt'}, 'limit_orders': {'type': 'string', 'required': False, 'part_of_query': True}, 'page_size': {'type': 'integer', 'required': False, 'part_of_query': True, 'default': 100}, 'sort': {'type': 'string', 'required': False, 'part_of_query': True}, 'start_time': {'type': 'string', 'required': False, 'part_of_query': True, 'validator': validate_time}, 'slippage': {'type': 'string', 'required': False, 'part_of_query': True}, 'slippage_ref': {'type': 'string', 'required': False, 'part_of_query': True}}
# Order Book Snapshots: Raw
order_book_snapshots_raw_schema = {'commodity': {'type': 'string', 'required': True, 'part_of_query': False, 'allowed': ['order_book_snapshots'], 'default': 'order_book_snapshots'}, 'continuation_token': {'type': 'string', 'required': False, 'part_of_query': True}, 'data_version': {'type': 'string', 'required': True, 'part_of_query': False, 'allowed': ['v1', 'v2'], 'default': 'v1'}, 'end_time': {'type': 'string', 'required': False, 'part_of_query': True, 'validator': validate_time}, 'exchange': {'type': 'string', 'required': True, 'part_of_query': False, 'default': 'krkn'}, 'instrument_class': {'type': 'string', 'required': True, 'part_of_query': False, 'allowed': ['spot', 'future', 'perpetual-future'], 'default': 'spot'}, 'instrument': {'type': 'string', 'required': True, 'part_of_query': False, 'default': 'btc-usdt'}, 'limit_orders': {'type': 'string', 'required': False, 'part_of_query': True}, 'page_size': {'type': 'integer', 'required': False, 'part_of_query': True, 'default': 100}, 'sort': {'type': 'string', 'required': False, 'part_of_query': True}, 'start_time': {'type': 'string', 'required': False, 'part_of_query': True, 'validator': validate_time}}
# Order Book Snapshots: Depth
order_book_snapshots_depth_schema = {'commodity': {'type': 'string', 'required': True, 'part_of_query': False, 'allowed': ['order_book_snapshots'], 'default': 'order_book_snapshots'}, 'continuation_token': {'type': 'string', 'required': False, 'part_of_query': True}, 'data_version': {'type': 'string', 'required': True, 'part_of_query': False, 'allowed': ['v1', 'v2'], 'default': 'v1'}, 'end_time': {'type': 'string', 'required': False, 'part_of_query': True, 'validator': validate_time}, 'exchange': {'type': 'string', 'required': True, 'part_of_query': False, 'default': 'krkn'}, 'instrument_class': {'type': 'string', 'required': True, 'part_of_query': False, 'allowed': ['spot', 'future', 'perpetual-future'], 'default': 'spot'}, 'instrument': {'type': 'string', 'required': True, 'part_of_query': False, 'default': 'btc-usdt'}, 'page_size': {'type': 'integer', 'required': False, 'part_of_query': True, 'default': 100}, 'sort': {'type': 'string', 'required': False, 'part_of_query': True}, 'start_time': {'type': 'string', 'required': False, 'part_of_query': True, 'validator': validate_time}}
# Order Book Snapshots: Slippage
order_book_snapshots_slippage_schema = {'commodity': {'type': 'string', 'required': True, 'part_of_query': False, 'allowed': ['order_book_snapshots'], 'default': 'order_book_snapshots'}, 'continuation_token': {'type': 'string', 'required': False, 'part_of_query': True}, 'data_version': {'type': 'string', 'required': True, 'part_of_query': False, 'allowed': ['v1', 'v2'], 'default': 'v1'}, 'end_time': {'type': 'string', 'required': False, 'part_of_query': True, 'validator': validate_time}, 'exchange': {'type': 'string', 'required': True, 'part_of_query': False, 'default': 'krkn'}, 'instrument_class': {'type': 'string', 'required': True, 'part_of_query': False, 'allowed': ['spot', 'future', 'perpetual-future'], 'default': 'spot'}, 'instrument': {'type': 'string', 'required': True, 'part_of_query': False, 'default': 'btc-usdt'}, 'page_size': {'type': 'integer', 'required': False, 'part_of_query': True, 'default': 100}, 'sort': {'type': 'string', 'required': False, 'part_of_query': True}, 'start_time': {'type': 'string', 'required': False, 'part_of_query': True, 'validator': validate_time}, 'slippage': {'type': 'string', 'required': False, 'part_of_query': True}, 'slippage_ref': {'type': 'string', 'required': False, 'part_of_query': True}}
# Order Book Aggregations: Full
order_book_aggregations_full_schema = {'commodity': {'type': 'string', 'required': True, 'part_of_query': False, 'allowed': ['order_book_snapshots'], 'default': 'order_book_snapshots'}, 'continuation_token': {'type': 'string', 'required': False, 'part_of_query': True}, 'data_version': {'type': 'string', 'required': True, 'part_of_query': False, 'allowed': ['v1', 'v2'], 'default': 'v1'}, 'end_time': {'type': 'string', 'required': False, 'part_of_query': True, 'validator': validate_time}, 'exchange': {'type': 'string', 'required': True, 'part_of_query': False, 'default': 'krkn'}, 'instrument_class': {'type': 'string', 'required': True, 'part_of_query': False, 'allowed': ['spot', 'future', 'perpetual-future'], 'default': 'spot'}, 'instrument': {'type': 'string', 'required': True, 'part_of_query': False, 'default': 'btc-usdt'}, 'interval': {'type': 'string', 'required': False, 'part_of_query': True, 'default': '1h'}, 'page_size': {'type': 'integer', 'required': False, 'part_of_query': True, 'default': 100}, 'sort': {'type': 'string', 'required': False, 'part_of_query': True}, 'start_time': {'type': 'string', 'required': False, 'part_of_query': True, 'validator': validate_time}, 'slippage': {'type': 'string', 'required': False, 'part_of_query': True}, 'slippage_ref': {'type': 'string', 'required': False, 'part_of_query': True}}
# Order Book Aggregations: Depth
order_book_aggregations_depth_schema = {'commodity': {'type': 'string', 'required': True, 'part_of_query': False, 'allowed': ['order_book_snapshots'], 'default': 'order_book_snapshots'}, 'continuation_token': {'type': 'string', 'required': False, 'part_of_query': True}, 'data_version': {'type': 'string', 'required': True, 'part_of_query': False, 'allowed': ['v1', 'v2'], 'default': 'v1'}, 'end_time': {'type': 'string', 'required': False, 'part_of_query': True, 'validator': validate_time}, 'exchange': {'type': 'string', 'required': True, 'part_of_query': False, 'default': 'krkn'}, 'instrument_class': {'type': 'string', 'required': True, 'part_of_query': False, 'allowed': ['spot', 'future', 'perpetual-future'], 'default': 'spot'}, 'instrument': {'type': 'string', 'required': True, 'part_of_query': False, 'default': 'btc-usdt'}, 'interval': {'type': 'string', 'required': False, 'part_of_query': True, 'default': '1h'}, 'page_size': {'type': 'integer', 'required': False, 'part_of_query': True, 'default': 100}, 'sort': {'type': 'string', 'required': False, 'part_of_query': True}, 'start_time': {'type': 'string', 'required': False, 'part_of_query': True, 'validator': validate_time}}
# Order Book Aggregations: Slippage
order_book_aggregations_slippage_schema = {'commodity': {'type': 'string', 'required': True, 'part_of_query': False, 'allowed': ['order_book_snapshots'], 'default': 'order_book_snapshots'}, 'continuation_token': {'type': 'string', 'required': False, 'part_of_query': True}, 'data_version': {'type': 'string', 'required': True, 'part_of_query': False, 'allowed': ['v1', 'v2'], 'default': 'v1'}, 'end_time': {'type': 'string', 'required': False, 'part_of_query': True, 'validator': validate_time}, 'exchange': {'type': 'string', 'required': True, 'part_of_query': False, 'default': 'krkn'}, 'instrument_class': {'type': 'string', 'required': True, 'part_of_query': False, 'allowed': ['spot', 'future', 'perpetual-future'], 'default': 'spot'}, 'instrument': {'type': 'string', 'required': True, 'part_of_query': False, 'default': 'btc-usdt'}, 'interval': {'type': 'string', 'required': False, 'part_of_query': True, 'default': '1h'}, 'page_size': {'type': 'integer', 'required': False, 'part_of_query': True, 'default': 100}, 'sort': {'type': 'string', 'required': False, 'part_of_query': True}, 'start_time': {'type': 'string', 'required': False, 'part_of_query': True, 'validator': validate_time}, 'slippage': {'type': 'string', 'required': False, 'part_of_query': True}, 'slippage_ref': {'type': 'string', 'required': False, 'part_of_query': True}}

# AGGREGATES
# OHLCV (Candles)
ohlcv_candles_schema = {'commodity': {'type': 'string', 'required': True, 'part_of_query': False, 'allowed': ['trades'], 'default': 'trades'}, 'continuation_token': {'type': 'string', 'required': False, 'part_of_query': True}, 'data_version': {'type': 'string', 'required': True, 'part_of_query': False, 'allowed': ['v1', 'v2'], 'default': 'v1'}, 'end_time': {'type': 'string', 'required': False, 'part_of_query': True, 'default': '2023-01-31T00:00:00.000Z', 'validator': validate_time}, 'exchange': {'type': 'string', 'required': True, 'part_of_query': False, 'default': 'krkn'}, 'instrument_class': {'type': 'string', 'required': True, 'part_of_query': False, 'allowed': ['spot', 'future', 'perpetual-future'], 'default': 'spot'}, 'instrument': {'type': 'string', 'required': True, 'part_of_query': False, 'default': 'btc-usdt'}, 'interval': {'type': 'string', 'required': False, 'part_of_query': True, 'default': '1d'}, 'page_size': {'type': 'integer', 'required': False, 'part_of_query': True, 'default': 100000}, 'start_time': {'type': 'string', 'required': False, 'part_of_query': True, 'default': '2022-10-01T00:00:00.000Z', 'validator': validate_time}, 'sort': {'type': 'string', 'required': False, 'part_of_query': True}}
# VWAP (Prices)
vwap_prices_schema = {'commodity': {'type': 'string', 'required': True, 'part_of_query': False, 'allowed': ['trades'], 'default': 'trades'}, 'continuation_token': {'type': 'string', 'required': False, 'part_of_query': True}, 'data_version': {'type': 'string', 'required': True, 'part_of_query': False, 'allowed': ['v1', 'v2'], 'default': 'v1'}, 'end_time': {'type': 'string', 'required': False, 'part_of_query': True, 'default': '2023-01-31T00:00:00.000Z', 'validator': validate_time}, 'exchange': {'type': 'string', 'required': True, 'part_of_query': False, 'default': 'krkn'}, 'instrument_class': {'type': 'string', 'required': True, 'part_of_query': False, 'allowed': ['spot', 'future', 'perpetual-future'], 'default': 'spot'}, 'instrument': {'type': 'string', 'required': True, 'part_of_query': False, 'default': 'btc-usdt'}, 'interval': {'type': 'string', 'required': False, 'part_of_query': True, 'default': '1d'}, 'page_size': {'type': 'integer', 'required': False, 'part_of_query': True, 'default': 100000}, 'start_time': {'type': 'string', 'required': False, 'part_of_query': True, 'default': '2022-10-01T00:00:00.000Z', 'validator': validate_time}, 'sort': {'type': 'string', 'required': False, 'part_of_query': True}}
# Count-OHLCV-VWAP
count_ohlcv_vwap_schema = {'commodity': {'type': 'string', 'required': True, 'part_of_query': False, 'allowed': ['trades'], 'default': 'trades'}, 'continuation_token': {'type': 'string', 'required': False, 'part_of_query': True}, 'data_version': {'type': 'string', 'required': True, 'part_of_query': False, 'allowed': ['v1', 'v2'], 'default': 'v1'}, 'end_time': {'type': 'string', 'required': False, 'part_of_query': True, 'default': '2023-01-31T00:00:00.000Z', 'validator': validate_time}, 'exchange': {'type': 'string', 'required': True, 'part_of_query': False, 'default': 'krkn'}, 'instrument_class': {'type': 'string', 'required': True, 'part_of_query': False, 'allowed': ['spot', 'future', 'perpetual-future'], 'default': 'spot'}, 'instrument': {'type': 'string', 'required': True, 'part_of_query': False, 'default': 'btc-usdt'}, 'interval': {'type': 'string', 'required': False, 'part_of_query': True, 'default': '1d'}, 'page_size': {'type': 'integer', 'required': False, 'part_of_query': True, 'default': 100000}, 'start_time': {'type': 'string', 'required': False, 'part_of_query': True, 'default': '2022-10-01T00:00:00.000Z', 'validator': validate_time}, 'sort': {'type': 'string', 'required': False, 'part_of_query': True}}

# PRICING SERVICES
# Asset Price - Aggregated VWAP
asset_price_schema = {'base_asset': {'type': 'string', 'required': True, 'part_of_query': False, 'default': 'btc'}, 'data_version': {'type': 'string', 'required': True, 'part_of_query': False, 'allowed': ['v1', 'v2'], 'default': 'v1'}, 'end_time': {'type': 'string', 'required': False, 'part_of_query': True, 'default': '2023-01-31T00:00:00.000Z', 'validator': validate_time}, 'exclude_exchanges': {'type': 'string', 'required': False, 'part_of_query': True}, 'interval': {'type': 'string', 'required': False, 'part_of_query': True, 'default': '1d'}, 'include_exchanges': {'type': 'string', 'required': False, 'part_of_query': True}, 'page_size': {'type': 'integer', 'required': False, 'part_of_query': True, 'default': 1000}, 'quote_asset': {'type': 'string', 'required': True, 'part_of_query': False, 'default': 'usd'}, 'start_time': {'type': 'string', 'required': True, 'part_of_query': True, 'default': '2022-10-01T00:00:00.000Z', 'validator': validate_time}, 'sort': {'type': 'string', 'required': False, 'part_of_query': True}, 'sources': {'type': 'boolean', 'required': False, 'part_of_query': True}}
# Robust Pair Price
robust_pair_price_schema = {'data_version': {'type': 'string', 'required': True, 'part_of_query': False, 'allowed': ['v1', 'v2'], 'default': 'v1'}, 'base_asset': {'type': 'string', 'required': True, 'part_of_query': False}, 'quote_asset': {'type': 'string', 'required': True, 'part_of_query': False}, 'start_time': {'type': 'string', 'required': True, 'part_of_query': True}, 'end_time': {'type': 'string', 'required': True, 'part_of_query': True}, 'interval': {'type': 'string', 'required': True, 'part_of_query': True, 'default': '24h'}, 'page_size': {'type': 'integer', 'required': False, 'part_of_query': True, 'default': 4}, 'sort': {'type': 'string', 'required': False, 'part_of_query': True}, 'include_exchanges': {'type': 'string', 'required': False, 'part_of_query': True}, 'exclude_exchanges': {'type': 'string', 'required': False, 'part_of_query': True}, 'extrapolate_missing_values': {'type': 'boolean', 'required': False, 'part_of_query': True}}
# Cross Price
cross_price_schema = {'base_asset': {'type': 'string', 'required': True, 'part_of_query': False, 'default': 'btc'}, 'data_version': {'type': 'string', 'required': True, 'part_of_query': False, 'allowed': ['v1', 'v2'], 'default': 'v1'}, 'end_time': {'type': 'string', 'required': False, 'part_of_query': True, 'default': '2023-01-31T00:00:00.000Z', 'validator': validate_time}, 'exclude_exchanges': {'type': 'string', 'required': False, 'part_of_query': True}, 'interval': {'type': 'string', 'required': False, 'part_of_query': True, 'default': '1d'}, 'include_exchanges': {'type': 'string', 'required': False, 'part_of_query': True}, 'outliers_strategy': {'type': 'string', 'required': False, 'part_of_query': True}, 'outliers_min_data': {'type': 'string', 'required': False, 'part_of_query': True}, 'outliers_threshold': {'type': 'string', 'required': False, 'part_of_query': True}, 'page_size': {'type': 'integer', 'required': False, 'part_of_query': True, 'default': 100}, 'quote_asset': {'type': 'string', 'required': True, 'part_of_query': False, 'default': 'usd'}, 'start_time': {'type': 'string', 'required': True, 'part_of_query': True, 'default': '2022-10-01T00:00:00.000Z', 'validator': validate_time}, 'sort': {'type': 'string', 'required': False, 'part_of_query': True}, 'sources': {'type': 'boolean', 'required': False, 'part_of_query': True}, 'extrapolate_missing_values': {'type': 'string', 'required': False, 'part_of_query': True}}

# PORTFOLIO SOLUTIONS
# Custom Valuation
valuation_schema = {'bases': {'type': 'string', 'required': True, 'part_of_query': True, 'default': 'btc,eth', 'validator': validate_bases}, 'continuation_token': {'type': 'string', 'required': False, 'part_of_query': True}, 'data_version': {'type': 'string', 'required': True, 'part_of_query': False, 'allowed': ['v1', 'v2'], 'default': 'v1'}, 'end_time': {'type': 'string', 'required': False, 'part_of_query': True, 'default': '2023-01-31T00:00:00.000Z', 'validator': validate_time}, 'exchanges': {'type': 'string', 'required': False, 'part_of_query': True}, 'interval': {'type': 'string', 'required': False, 'part_of_query': True, 'default': '1d'}, 'percentages': {'type': 'string', 'required': True, 'part_of_query': True, 'default': '1'}, 'start_time': {'type': 'string', 'required': False, 'part_of_query': True, 'default': '2022-10-01T00:00:00.000Z', 'validator': validate_time}, 'semi_length_window': {'type': 'string', 'required': True, 'part_of_query': True, 'default': '30m'}, 'sources': {'type': 'boolean', 'required': False, 'part_of_query': True}, 'quote': {'type': 'string', 'required': True, 'part_of_query': True, 'default': 'usd'}, 'weights': {'type': 'string', 'required': True, 'part_of_query': True, 'default': '0.5,0.5', 'validator': validate_bases_weights}}

# PRICING SERVICES
# OANDA FX Rates
oanda_fx_rates_schema = {'base': {'type': 'string', 'required': True, 'part_of_query': True, 'default': 'usd'}, 'continuation_token': {'type': 'string', 'required': False, 'part_of_query': True}, 'data_version': {'type': 'string', 'required': True, 'part_of_query': False, 'allowed': ['v1', 'v2'], 'default': 'v2'}, 'end_time': {'type': 'string', 'required': False, 'part_of_query': True, 'default': '2023-01-31T00:00:00.000Z', 'validator': validate_time}, 'interval': {'type': 'string', 'required': False, 'part_of_query': True, 'default': '1h'}, 'page_size': {'type': 'integer', 'required': False, 'part_of_query': True, 'default': 1000}, 'quote': {'type': 'string', 'required': True, 'part_of_query': True, 'default': 'eur'}, 'start_time': {'type': 'string', 'required': False, 'part_of_query': True, 'default': '2022-10-01T00:00:00.000Z', 'validator': validate_time}, 'sort': {'type': 'string', 'required': False, 'part_of_query': True}}

# DEX LIQUIDITY
# Liquidity Events
liquidity_events_schema = {'protocol': {'type': 'string', 'required': False, 'part_of_query': True}, 'pool_address': {'type': 'string', 'required': False, 'part_of_query': True, 'default': '0xDC24316b9AE028F1497c275EB9192a3Ea0f67022'}, 'pool_contains': {'type': 'string', 'required': False, 'part_of_query': True}, 'block_number': {'type': 'string', 'required': False, 'part_of_query': True}, 'user_addresses': {'type': 'string', 'required': False, 'part_of_query': True}, 'tx_hash': {'type': 'string', 'required': False, 'part_of_query': True}, 'start_block': {'type': 'string', 'required': False, 'part_of_query': True}, 'end_block': {'type': 'string', 'required': False, 'part_of_query': True}, 'start_time': {'type': 'string', 'required': False, 'part_of_query': True, 'default': '2022-10-01T00:00:00.000Z', 'validator': validate_time}, 'end_time': {'type': 'string', 'required': False, 'part_of_query': True, 'default': '2023-01-31T00:00:00.000Z', 'validator': validate_time}, 'sort': {'type': 'string', 'required': False, 'part_of_query': True}, 'type': {'type': 'string', 'required': False, 'part_of_query': True}, 'page_size': {'type': 'integer', 'required': False, 'part_of_query': True, 'default': 1000}}
# Liquidity Snapshots
liquidity_snapshots_schema = {'pool_address': {'type': 'string', 'required': True, 'part_of_query': True, 'default': '0xDC24316b9AE028F1497c275EB9192a3Ea0f67022'}, 'start_block': {'type': 'string', 'required': False, 'part_of_query': True}, 'end_block': {'type': 'string', 'required': False, 'part_of_query': True}, 'start_time': {'type': 'string', 'required': False, 'part_of_query': True, 'default': '2022-10-01T00:00:00.000Z', 'validator': validate_time}, 'end_time': {'type': 'string', 'required': False, 'part_of_query': True, 'default': '2023-01-31T00:00:00.000Z', 'validator': validate_time}, 'sort': {'type': 'string', 'required': False, 'part_of_query': True}, 'page_size': {'type': 'integer', 'required': False, 'part_of_query': True, 'default': 1000}}
# Uniswap v3 Liquidity Snapshots
uniswap_v3_liquidity_snapshot_schema = {'pool_address': {'type': 'string', 'required': True, 'part_of_query': True, 'default': '0xDC24316b9AE028F1497c275EB9192a3Ea0f67022'}, 'start_block': {'type': 'string', 'required': False, 'part_of_query': True}, 'end_block': {'type': 'string', 'required': False, 'part_of_query': True}, 'start_time': {'type': 'string', 'required': False, 'part_of_query': True, 'default': '2022-10-01T00:00:00.000Z', 'validator': validate_time}, 'end_time': {'type': 'string', 'required': False, 'part_of_query': True, 'default': '2023-01-31T00:00:00.000Z', 'validator': validate_time}, 'price_range': {'type': 'string', 'required': False, 'part_of_query': True}, 'page_size': {'type': 'integer', 'required': False, 'part_of_query': True, 'default': 100}}

# LENDING & BORROWING PROTOCOLS
# Lending and Borrowing Events
lending_and_borrowing_events_schema = {'blockchain': {'type': 'string', 'required': False, 'part_of_query': True}, 'protocol': {'type': 'string', 'required': True, 'part_of_query': True, 'default': 'aav2'}, 'user_address': {'type': 'string', 'required': False, 'part_of_query': True}, 'tx_hash': {'type': 'string', 'required': False, 'part_of_query': True}, 'asset': {'type': 'string', 'required': False, 'part_of_query': True}, 'type': {'type': 'string', 'required': False, 'part_of_query': True}, 'block_number': {'type': 'string', 'required': False, 'part_of_query': True}, 'start_block': {'type': 'string', 'required': False, 'part_of_query': True}, 'end_block': {'type': 'string', 'required': False, 'part_of_query': True}, 'start_time': {'type': 'string', 'required': False, 'part_of_query': True, 'default': '2022-10-01T00:00:00.000Z', 'validator': validate_time}, 'end_time': {'type': 'string', 'required': False, 'part_of_query': True, 'default': '2023-01-31T00:00:00.000Z', 'validator': validate_time}, 'sort': {'type': 'string', 'required': False, 'part_of_query': True}, 'page_size': {'type': 'integer', 'required': False, 'part_of_query': True, 'default': 1000}}
# Lending & Borrowing Rates and Liquidity
lending_and_borrowing_snapshots_schema = {'blockchain': {'type': 'string', 'required': False, 'part_of_query': True}, 'protocol': {'type': 'string', 'required': True, 'part_of_query': True}, 'asset': {'type': 'string', 'required': True, 'part_of_query': True}, 'block_number': {'type': 'integer', 'required': False, 'part_of_query': True}, 'start_block': {'type': 'integer', 'required': False, 'part_of_query': True}, 'end_block': {'type': 'integer', 'required': False, 'part_of_query': True}, 'start_time': {'type': 'string', 'required': False, 'part_of_query': True}, 'end_time': {'type': 'string', 'required': False, 'part_of_query': True}, 'interval': {'type': 'string', 'required': False, 'part_of_query': True, 'default': '1b'}, 'sort': {'type': 'string', 'required': False, 'part_of_query': True}, 'page_size': {'type': 'integer', 'required': False, 'part_of_query': True, 'default': 1000}}

# PORTFOLIO SOLUTIONS
# Value at Risk
value_at_risk_schema = {'bases': {'type': 'string', 'required': True, 'part_of_query': True, 'default': 'eth,btc,ltc', 'validator': validate_bases}, 'quote': {'type': 'string', 'required': True, 'part_of_query': True, 'default': 'usd'}, 'quantities': {'type': 'string', 'required': True, 'part_of_query': True, 'default': '3,2,5'}, 'risk_level': {'type': 'string', 'required': True, 'part_of_query': True, 'default': '0.95', 'validator': validate_risk_level}, 'start_time': {'type': 'string', 'required': True, 'part_of_query': True, 'default': '2022-10-01T00:00:00.000Z', 'validator': validate_time}, 'end_time': {'type': 'string', 'required': True, 'part_of_query': True, 'default': '2023-01-31T00:00:00.000Z', 'validator': validate_time}, 'exchanges': {'type': 'string', 'required': True, 'part_of_query': True, 'default': 'krkn'}, 'sources': {'type': 'boolean', 'required': False, 'part_of_query': True}, 'data_version': {'type': 'string', 'required': True, 'part_of_query': False, 'allowed': ['v1', 'v2'], 'default': 'v2'}}

# DERIVATIVES METRICS
# Derivatives Metrics: Reference
reference_schema = {'exchange': {'type': 'string', 'required': True, 'part_of_query': True, 'default': 'drbt'}, 'instrument_class': {'type': 'string', 'required': True, 'part_of_query': True, 'allowed': ['future', 'perpetual-future', 'option'], 'default': 'perpetual-future'}, 'instrument': {'type': 'string', 'required': False, 'part_of_query': True}, 'base_assets': {'type': 'string', 'required': False, 'part_of_query': True, 'default': 'btc'}, 'quote_assets': {'type': 'string', 'required': False, 'part_of_query': True, 'default': 'usdt'}, 'option_type': {'type': 'string', 'required': False, 'part_of_query': True}, 'start_time': {'type': 'string', 'required': False, 'part_of_query': True, 'default': '2022-10-01T00:00:00.000Z', 'validator': validate_time}, 'end_time': {'type': 'string', 'required': False, 'part_of_query': True, 'default': '2023-01-31T00:00:00.000Z', 'validator': validate_time}, 'page_size': {'type': 'integer', 'required': False, 'part_of_query': True, 'default': 500}}
# Derivatives Metrics: Risk
risk_schema = {'exchange': {'type': 'string', 'required': True, 'part_of_query': True, 'default': 'krkn'}, 'instrument_class': {'type': 'string', 'required': True, 'part_of_query': True, 'allowed': ['spot', 'future', 'perpetual-future'], 'default': 'spot'}, 'instrument': {'type': 'string', 'required': True, 'part_of_query': True, 'default': 'btc-usdt'}, 'interval': {'type': 'string', 'required': False, 'part_of_query': True, 'default': '1d'}, 'page_size': {'type': 'integer', 'required': False, 'part_of_query': True, 'default': 1000}, 'sort': {'type': 'string', 'required': False, 'part_of_query': True}, 'start_time': {'type': 'string', 'required': False, 'part_of_query': True, 'default': '2022-10-01T00:00:00.000Z', 'validator': validate_time}, 'end_time': {'type': 'string', 'required': False, 'part_of_query': True, 'default': '2023-01-31T00:00:00.000Z', 'validator': validate_time}}
# Derivatives Metrics: Price
price_schema = {'exchange': {'type': 'string', 'required': True, 'part_of_query': True, 'default': 'okex'}, 'instrument_class': {'type': 'string', 'required': True, 'part_of_query': True, 'allowed': ['future', 'perpetual-future', 'option'], 'default': 'perpetual-future'}, 'instrument': {'type': 'string', 'required': True, 'part_of_query': True, 'default': 'btc-usdt'}, 'interval': {'type': 'string', 'required': False, 'part_of_query': True, 'default': '1d'}, 'page_size': {'type': 'integer', 'required': False, 'part_of_query': True, 'default': 1000}, 'sort': {'type': 'string', 'required': False, 'part_of_query': True}, 'start_time': {'type': 'string', 'required': False, 'part_of_query': True, 'validator': validate_time}, 'end_time': {'type': 'string', 'required': False, 'part_of_query': True, 'validator': validate_time}}

# DERIVATIVES ANALYTICS
# Implied Volatility Smile
iv_smile_schema = {'base': {'type': 'string', 'required': True, 'part_of_query': True, 'default': 'btc'}, 'quote': {'type': 'string', 'required': True, 'part_of_query': True, 'default': 'usd'}, 'exchange': {'type': 'string', 'required': False, 'part_of_query': True}, 'time': {'type': 'string', 'required': True, 'part_of_query': True, 'default': '2022-10-01T00:00:00.000Z', 'validator': validate_time}, 'expiry': {'type': 'string', 'required': True, 'part_of_query': True, 'default': '2022-11-01T00:00:00.000Z', 'validator': validate_time}, 'strikes': {'type': 'string', 'required': False, 'part_of_query': True, 'default': '1'}, 'forward_log_moneynequantitiessses': {'type': 'string', 'required': False, 'part_of_query': True}}
# Implied Volatility Surface
iv_surface_schema = {'base': {'type': 'string', 'required': True, 'part_of_query': True}, 'quote': {'type': 'string', 'required': True, 'part_of_query': True}, 'exchange': {'type': 'string', 'required': True, 'part_of_query': True}, 'time': {'type': 'string', 'required': True, 'part_of_query': True}, 'expiry_list': {'type': 'string', 'required': True, 'part_of_query': True}, 'tte_min': {'type': 'string', 'required': True, 'part_of_query': True}, 'tte_max': {'type': 'string', 'required': True, 'part_of_query': True}, 'tte_step': {'type': 'string', 'required': True, 'part_of_query': True}, 'strike_list': {'type': 'string', 'required': True, 'part_of_query': True}, 'f_log_m_min': {'type': 'string', 'required': True, 'part_of_query': True}, 'f_log_m_max': {'type': 'string', 'required': True, 'part_of_query': True}, 'f_log_m_step': {'type': 'string', 'required': True, 'part_of_query': True}}

# MARKET & ASSET ANALYTICS
# Asset Metrics
asset_metrics_schema = {'asset': {'type': 'string', 'required': True, 'part_of_query': True, 'default': 'btc'}, 'start_time': {'type': 'string', 'required': True, 'part_of_query': True, 'default': '2022-10-01T00:00:00.000Z', 'validator': validate_time}, 'end_time': {'type': 'string', 'required': True, 'part_of_query': True, 'default': '2023-01-31T00:00:00.000Z', 'validator': validate_time}, 'interval': {'type': 'string', 'required': True, 'part_of_query': True, 'default': '1d'}, 'sources': {'type': 'string', 'required': False, 'part_of_query': True}, 'page_size': {'type': 'integer', 'required': False, 'part_of_query': True, 'default': 100}}
