# -*- coding: utf-8 -*-
# Generated by Django 1.11.9 on 2018-01-18 13:07
from __future__ import unicode_literals

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import github_issues.utils
import model_utils.fields


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('user_activities', '0001_initial'),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='Issue',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('number', models.PositiveIntegerField(blank=True, null=True)),
                ('title', models.CharField(max_length=100)),
                ('body', models.TextField()),
                ('screenshot', models.ImageField(blank=True, height_field='height_field', null=True, upload_to=github_issues.utils.upload_issue_location, width_field='width_field')),
                ('height_field', models.IntegerField(default=0)),
                ('width_field', models.IntegerField(default=0)),
                ('status', models.PositiveSmallIntegerField(choices=[(1, 'open'), (2, 'closed')], default=1)),
                ('priority', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='priority_issues', to='user_activities.Tag')),
            ],
            options={
                'verbose_name': 'Issue',
                'verbose_name_plural': 'Issues',
            },
        ),
        migrations.CreateModel(
            name='Repo',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('label', models.CharField(max_length=50, unique=True)),
                ('description', models.CharField(blank=True, max_length=255)),
                ('slug', models.SlugField(unique=True)),
                ('active', models.BooleanField(default=True)),
                ('owner', models.CharField(max_length=75)),
                ('descriptive_name', models.CharField(max_length=75)),
                ('html_url', models.URLField(unique=True)),
                ('api_url', models.URLField(unique=True)),
            ],
            options={
                'verbose_name': 'Repo',
                'verbose_name_plural': 'Repos',
            },
        ),
        migrations.AddField(
            model_name='issue',
            name='repo',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='issues', to='github_issues.Repo'),
        ),
        migrations.AddField(
            model_name='issue',
            name='tags',
            field=models.ManyToManyField(blank=True, related_name='tags_issues', to='user_activities.Tag'),
        ),
        migrations.AddField(
            model_name='issue',
            name='user',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL),
        ),
        migrations.AlterUniqueTogether(
            name='issue',
            unique_together=set([('repo', 'number')]),
        ),
    ]
