import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataAzurermNetappSnapshotPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/netapp_snapshot_policy.html#account_name DataAzurermNetappSnapshotPolicy#account_name}.
     *
     * @stability stable
     */
    readonly accountName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/netapp_snapshot_policy.html#name DataAzurermNetappSnapshotPolicy#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/netapp_snapshot_policy.html#resource_group_name DataAzurermNetappSnapshotPolicy#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/netapp_snapshot_policy.html#timeouts DataAzurermNetappSnapshotPolicy#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataAzurermNetappSnapshotPolicyTimeouts;
}
/**
 * @stability stable
 */
export declare class DataAzurermNetappSnapshotPolicyDailySchedule extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get hour(): number;
    /**
     * @stability stable
     */
    get minute(): number;
    /**
     * @stability stable
     */
    get snapshotsToKeep(): number;
}
/**
 * @stability stable
 */
export declare class DataAzurermNetappSnapshotPolicyHourlySchedule extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get minute(): number;
    /**
     * @stability stable
     */
    get snapshotsToKeep(): number;
}
/**
 * @stability stable
 */
export declare class DataAzurermNetappSnapshotPolicyMonthlySchedule extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get daysOfMonth(): any;
    /**
     * @stability stable
     */
    get hour(): number;
    /**
     * @stability stable
     */
    get minute(): number;
    /**
     * @stability stable
     */
    get snapshotsToKeep(): number;
}
/**
 * @stability stable
 */
export declare class DataAzurermNetappSnapshotPolicyWeeklySchedule extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get daysOfWeek(): string[];
    /**
     * @stability stable
     */
    get hour(): number;
    /**
     * @stability stable
     */
    get minute(): number;
    /**
     * @stability stable
     */
    get snapshotsToKeep(): number;
}
/**
 * @stability stable
 */
export interface DataAzurermNetappSnapshotPolicyTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/netapp_snapshot_policy.html#read DataAzurermNetappSnapshotPolicy#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function dataAzurermNetappSnapshotPolicyTimeoutsToTerraform(struct?: DataAzurermNetappSnapshotPolicyTimeoutsOutputReference | DataAzurermNetappSnapshotPolicyTimeouts): any;
/**
 * @stability stable
 */
export declare class DataAzurermNetappSnapshotPolicyTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataAzurermNetappSnapshotPolicyTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataAzurermNetappSnapshotPolicyTimeouts | undefined);
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/netapp_snapshot_policy.html azurerm_netapp_snapshot_policy}.
 *
 * @stability stable
 */
export declare class DataAzurermNetappSnapshotPolicy extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/netapp_snapshot_policy.html azurerm_netapp_snapshot_policy} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataAzurermNetappSnapshotPolicyConfig);
    private _accountName?;
    /**
     * @stability stable
     */
    get accountName(): string;
    /**
     * @stability stable
     */
    set accountName(value: string);
    /**
     * @stability stable
     */
    get accountNameInput(): string | undefined;
    /**
     * @stability stable
     */
    dailySchedule(index: string): DataAzurermNetappSnapshotPolicyDailySchedule;
    /**
     * @stability stable
     */
    get enabled(): any;
    /**
     * @stability stable
     */
    hourlySchedule(index: string): DataAzurermNetappSnapshotPolicyHourlySchedule;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    monthlySchedule(index: string): DataAzurermNetappSnapshotPolicyMonthlySchedule;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    /**
     * @stability stable
     */
    tags(key: string): string;
    /**
     * @stability stable
     */
    weeklySchedule(index: string): DataAzurermNetappSnapshotPolicyWeeklySchedule;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataAzurermNetappSnapshotPolicyTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataAzurermNetappSnapshotPolicyTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataAzurermNetappSnapshotPolicyTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
