import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface NatGatewayPublicIpPrefixAssociationConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/nat_gateway_public_ip_prefix_association.html#nat_gateway_id NatGatewayPublicIpPrefixAssociation#nat_gateway_id}.
     *
     * @stability stable
     */
    readonly natGatewayId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/nat_gateway_public_ip_prefix_association.html#public_ip_prefix_id NatGatewayPublicIpPrefixAssociation#public_ip_prefix_id}.
     *
     * @stability stable
     */
    readonly publicIpPrefixId: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/nat_gateway_public_ip_prefix_association.html#timeouts NatGatewayPublicIpPrefixAssociation#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: NatGatewayPublicIpPrefixAssociationTimeouts;
}
/**
 * @stability stable
 */
export interface NatGatewayPublicIpPrefixAssociationTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/nat_gateway_public_ip_prefix_association.html#create NatGatewayPublicIpPrefixAssociation#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/nat_gateway_public_ip_prefix_association.html#delete NatGatewayPublicIpPrefixAssociation#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/nat_gateway_public_ip_prefix_association.html#read NatGatewayPublicIpPrefixAssociation#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function natGatewayPublicIpPrefixAssociationTimeoutsToTerraform(struct?: NatGatewayPublicIpPrefixAssociationTimeoutsOutputReference | NatGatewayPublicIpPrefixAssociationTimeouts): any;
/**
 * @stability stable
 */
export declare class NatGatewayPublicIpPrefixAssociationTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): NatGatewayPublicIpPrefixAssociationTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: NatGatewayPublicIpPrefixAssociationTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/nat_gateway_public_ip_prefix_association.html azurerm_nat_gateway_public_ip_prefix_association}.
 *
 * @stability stable
 */
export declare class NatGatewayPublicIpPrefixAssociation extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/nat_gateway_public_ip_prefix_association.html azurerm_nat_gateway_public_ip_prefix_association} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: NatGatewayPublicIpPrefixAssociationConfig);
    /**
     * @stability stable
     */
    get id(): string;
    private _natGatewayId?;
    /**
     * @stability stable
     */
    get natGatewayId(): string;
    /**
     * @stability stable
     */
    set natGatewayId(value: string);
    /**
     * @stability stable
     */
    get natGatewayIdInput(): string | undefined;
    private _publicIpPrefixId?;
    /**
     * @stability stable
     */
    get publicIpPrefixId(): string;
    /**
     * @stability stable
     */
    set publicIpPrefixId(value: string);
    /**
     * @stability stable
     */
    get publicIpPrefixIdInput(): string | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): NatGatewayPublicIpPrefixAssociationTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: NatGatewayPublicIpPrefixAssociationTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): NatGatewayPublicIpPrefixAssociationTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
