# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Code generated by Microsoft (R) AutoRest Code Generator (autorest: 3.10.2, generator: @autorest/python@6.26.0)
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
from io import IOBase
import sys
from typing import Any, Callable, Dict, IO, List, Optional, TypeVar, Union, overload

from azure.core import MatchConditions
from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceModifiedError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    map_error,
)
from azure.core.pipeline import PipelineResponse
from azure.core.rest import AsyncHttpResponse, HttpRequest
from azure.core.tracing.decorator_async import distributed_trace_async
from azure.core.utils import case_insensitive_dict

from ... import models as _models
from ...operations._operations import (
    build_auth_authorization_flow_complete_request,
    build_auth_authorization_flow_request,
    build_auth_do_device_flow_request,
    build_auth_finish_device_flow_request,
    build_auth_finished_request,
    build_auth_get_refresh_tokens_request,
    build_auth_initiate_device_flow_request,
    build_auth_revoke_refresh_token_request,
    build_auth_userinfo_request,
    build_config_serve_config_request,
    build_jobs_assign_sandbox_to_job_request,
    build_jobs_delete_bulk_jobs_request,
    build_jobs_delete_single_job_request,
    build_jobs_get_job_sandbox_request,
    build_jobs_get_job_sandboxes_request,
    build_jobs_get_job_status_bulk_request,
    build_jobs_get_job_status_history_bulk_request,
    build_jobs_get_sandbox_file_request,
    build_jobs_get_single_job_request,
    build_jobs_get_single_job_status_history_request,
    build_jobs_get_single_job_status_request,
    build_jobs_initiate_sandbox_upload_request,
    build_jobs_kill_bulk_jobs_request,
    build_jobs_kill_single_job_request,
    build_jobs_remove_bulk_jobs_request,
    build_jobs_remove_single_job_request,
    build_jobs_reschedule_bulk_jobs_request,
    build_jobs_reschedule_single_job_request,
    build_jobs_search_request,
    build_jobs_set_job_status_bulk_request,
    build_jobs_set_single_job_properties_request,
    build_jobs_set_single_job_status_request,
    build_jobs_submit_bulk_jobs_request,
    build_jobs_summary_request,
    build_jobs_unassign_bulk_jobs_sandboxes_request,
    build_jobs_unassign_job_sandboxes_request,
    build_well_known_installation_metadata_request,
    build_well_known_openid_configuration_request,
)
from .._vendor import raise_if_not_implemented

if sys.version_info >= (3, 9):
    from collections.abc import MutableMapping
else:
    from typing import MutableMapping  # type: ignore
T = TypeVar("T")
ClsType = Optional[
    Callable[[PipelineResponse[HttpRequest, AsyncHttpResponse], T, Dict[str, Any]], Any]
]
JSON = MutableMapping[str, Any]  # pylint: disable=unsubscriptable-object


class WellKnownOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~generated.aio.Dirac`'s
        :attr:`well_known` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = (
            input_args.pop(0) if input_args else kwargs.pop("deserializer")
        )

    @distributed_trace_async
    async def openid_configuration(self, **kwargs: Any) -> Any:
        """Openid Configuration.

        OpenID Connect discovery endpoint.

        :return: any
        :rtype: any
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[Any] = kwargs.pop("cls", None)

        _request = build_well_known_openid_configuration_request(
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        deserialized = self._deserialize("object", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def installation_metadata(self, **kwargs: Any) -> _models.Metadata:
        """Installation Metadata.

        Get metadata about the dirac installation.

        :return: Metadata
        :rtype: ~generated.models.Metadata
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.Metadata] = kwargs.pop("cls", None)

        _request = build_well_known_installation_metadata_request(
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        deserialized = self._deserialize("Metadata", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore


class AuthOperations:  # pylint: disable=abstract-class-instantiated
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~generated.aio.Dirac`'s
        :attr:`auth` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = (
            input_args.pop(0) if input_args else kwargs.pop("deserializer")
        )

        raise_if_not_implemented(
            self.__class__,
            [
                "token",
            ],
        )

    @distributed_trace_async
    async def initiate_device_flow(
        self, *, client_id: str, scope: str, **kwargs: Any
    ) -> _models.InitiateDeviceFlowResponse:
        """Initiate Device Flow.

        Initiate the device flow against DIRAC authorization Server.
        Scope must have exactly up to one ``group`` (otherwise default) and
        one or more ``property`` scope.
        If no property, then get default one.

        Offers the user to go with the browser to
        ``auth/<vo>/device?user_code=XYZ``.

        :keyword client_id: Required.
        :paramtype client_id: str
        :keyword scope: Required.
        :paramtype scope: str
        :return: InitiateDeviceFlowResponse
        :rtype: ~generated.models.InitiateDeviceFlowResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.InitiateDeviceFlowResponse] = kwargs.pop("cls", None)

        _request = build_auth_initiate_device_flow_request(
            client_id=client_id,
            scope=scope,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        deserialized = self._deserialize(
            "InitiateDeviceFlowResponse", pipeline_response.http_response
        )

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def do_device_flow(self, *, user_code: str, **kwargs: Any) -> Any:
        """Do Device Flow.

        This is called as the verification URI for the device flow.
        It will redirect to the actual OpenID server (IAM, CheckIn) to
        perform a authorization code flow.

        We set the user_code obtained from the device flow in a cookie
        to be able to map the authorization flow with the corresponding
        device flow.
        (note: it can't be put as parameter or in the URL).

        :keyword user_code: Required.
        :paramtype user_code: str
        :return: any
        :rtype: any
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[Any] = kwargs.pop("cls", None)

        _request = build_auth_do_device_flow_request(
            user_code=user_code,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        deserialized = self._deserialize("object", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def finish_device_flow(self, *, code: str, state: str, **kwargs: Any) -> Any:
        """Finish Device Flow.

        This the url callbacked by IAM/Checkin after the authorization
        flow was granted.
        It gets us the code we need for the authorization flow, and we
        can map it to the corresponding device flow using the user_code
        in the cookie/session.

        :keyword code: Required.
        :paramtype code: str
        :keyword state: Required.
        :paramtype state: str
        :return: any
        :rtype: any
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[Any] = kwargs.pop("cls", None)

        _request = build_auth_finish_device_flow_request(
            code=code,
            state=state,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        deserialized = self._deserialize("object", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def finished(self, **kwargs: Any) -> Any:
        """Finished.

        This is the final step of the device flow.

        :return: any
        :rtype: any
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[Any] = kwargs.pop("cls", None)

        _request = build_auth_finished_request(
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        deserialized = self._deserialize("object", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get_refresh_tokens(self, **kwargs: Any) -> List[Any]:
        """Get Refresh Tokens.

        Get all refresh tokens for the user. If the user has the ``proxy_management`` property, then
        the subject is not used to filter the refresh tokens.

        :return: list of any
        :rtype: list[any]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[Any]] = kwargs.pop("cls", None)

        _request = build_auth_get_refresh_tokens_request(
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        deserialized = self._deserialize("[object]", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def revoke_refresh_token(self, jti: str, **kwargs: Any) -> str:
        """Revoke Refresh Token.

        Revoke a refresh token. If the user has the ``proxy_management`` property, then
        the subject is not used to filter the refresh tokens.

        :param jti: Required.
        :type jti: str
        :return: str
        :rtype: str
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[str] = kwargs.pop("cls", None)

        _request = build_auth_revoke_refresh_token_request(
            jti=jti,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        deserialized = self._deserialize("str", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def userinfo(self, **kwargs: Any) -> _models.UserInfoResponse:
        """Userinfo.

        Get information about the user's identity.

        :return: UserInfoResponse
        :rtype: ~generated.models.UserInfoResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.UserInfoResponse] = kwargs.pop("cls", None)

        _request = build_auth_userinfo_request(
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        deserialized = self._deserialize(
            "UserInfoResponse", pipeline_response.http_response
        )

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def authorization_flow(
        self,
        *,
        response_type: Union[str, _models.Enum0],
        code_challenge: str,
        code_challenge_method: Union[str, _models.Enum1],
        client_id: str,
        redirect_uri: str,
        scope: str,
        state: str,
        **kwargs: Any,
    ) -> Any:
        """Authorization Flow.

        Initiate the authorization flow.
        It will redirect to the actual OpenID server (IAM, CheckIn) to
        perform a authorization code flow.

        We set the user details obtained from the user authorize flow in a cookie
        to be able to map the authorization flow with the corresponding
        user authorize flow.

        :keyword response_type: "code" Required.
        :paramtype response_type: str or ~generated.models.Enum0
        :keyword code_challenge: Required.
        :paramtype code_challenge: str
        :keyword code_challenge_method: "S256" Required.
        :paramtype code_challenge_method: str or ~generated.models.Enum1
        :keyword client_id: Required.
        :paramtype client_id: str
        :keyword redirect_uri: Required.
        :paramtype redirect_uri: str
        :keyword scope: Required.
        :paramtype scope: str
        :keyword state: Required.
        :paramtype state: str
        :return: any
        :rtype: any
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[Any] = kwargs.pop("cls", None)

        _request = build_auth_authorization_flow_request(
            response_type=response_type,
            code_challenge=code_challenge,
            code_challenge_method=code_challenge_method,
            client_id=client_id,
            redirect_uri=redirect_uri,
            scope=scope,
            state=state,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        deserialized = self._deserialize("object", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def authorization_flow_complete(
        self, *, code: str, state: str, **kwargs: Any
    ) -> Any:
        """Authorization Flow Complete.

        Complete the authorization flow.

        The user is redirected back to the DIRAC auth service after completing the IAM's authorization
        flow.
        We retrieve the original flow details from the decrypted state and store the ID token requested
        from the IAM.
        The user is then redirected to the client's redirect URI.

        :keyword code: Required.
        :paramtype code: str
        :keyword state: Required.
        :paramtype state: str
        :return: any
        :rtype: any
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[Any] = kwargs.pop("cls", None)

        _request = build_auth_authorization_flow_complete_request(
            code=code,
            state=state,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        deserialized = self._deserialize("object", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore


class ConfigOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~generated.aio.Dirac`'s
        :attr:`config` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = (
            input_args.pop(0) if input_args else kwargs.pop("deserializer")
        )

    @distributed_trace_async
    async def serve_config(
        self,
        *,
        if_modified_since: Optional[str] = None,
        etag: Optional[str] = None,
        match_condition: Optional[MatchConditions] = None,
        **kwargs: Any,
    ) -> Any:
        """Serve Config.

        Get the latest view of the config.

        If If-None-Match header is given and matches the latest ETag, return 304

        If If-Modified-Since is given and is newer than latest,
            return 304: this is to avoid flip/flopping.

        :keyword if_modified_since: Default value is None.
        :paramtype if_modified_since: str
        :keyword etag: check if resource is changed. Set None to skip checking etag. Default value is
         None.
        :paramtype etag: str
        :keyword match_condition: The match condition to use upon the etag. Default value is None.
        :paramtype match_condition: ~azure.core.MatchConditions
        :return: any
        :rtype: any
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        if match_condition == MatchConditions.IfNotModified:
            error_map[412] = ResourceModifiedError
        elif match_condition == MatchConditions.IfPresent:
            error_map[412] = ResourceNotFoundError
        elif match_condition == MatchConditions.IfMissing:
            error_map[412] = ResourceExistsError
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[Any] = kwargs.pop("cls", None)

        _request = build_config_serve_config_request(
            if_modified_since=if_modified_since,
            etag=etag,
            match_condition=match_condition,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        deserialized = self._deserialize("object", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore


class JobsOperations:  # pylint: disable=too-many-public-methods
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~generated.aio.Dirac`'s
        :attr:`jobs` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = (
            input_args.pop(0) if input_args else kwargs.pop("deserializer")
        )

    @overload
    async def initiate_sandbox_upload(
        self,
        body: _models.SandboxInfo,
        *,
        content_type: str = "application/json",
        **kwargs: Any,
    ) -> _models.SandboxUploadResponse:
        """Initiate Sandbox Upload.

        Get the PFN for the given sandbox, initiate an upload as required.

        If the sandbox already exists in the database then the PFN is returned
        and there is no "url" field in the response.

        If the sandbox does not exist in the database then the "url" and "fields"
        should be used to upload the sandbox to the storage backend.

        :param body: Required.
        :type body: ~generated.models.SandboxInfo
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: SandboxUploadResponse
        :rtype: ~generated.models.SandboxUploadResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def initiate_sandbox_upload(
        self, body: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.SandboxUploadResponse:
        """Initiate Sandbox Upload.

        Get the PFN for the given sandbox, initiate an upload as required.

        If the sandbox already exists in the database then the PFN is returned
        and there is no "url" field in the response.

        If the sandbox does not exist in the database then the "url" and "fields"
        should be used to upload the sandbox to the storage backend.

        :param body: Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: SandboxUploadResponse
        :rtype: ~generated.models.SandboxUploadResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def initiate_sandbox_upload(
        self, body: Union[_models.SandboxInfo, IO[bytes]], **kwargs: Any
    ) -> _models.SandboxUploadResponse:
        """Initiate Sandbox Upload.

        Get the PFN for the given sandbox, initiate an upload as required.

        If the sandbox already exists in the database then the PFN is returned
        and there is no "url" field in the response.

        If the sandbox does not exist in the database then the "url" and "fields"
        should be used to upload the sandbox to the storage backend.

        :param body: Is either a SandboxInfo type or a IO[bytes] type. Required.
        :type body: ~generated.models.SandboxInfo or IO[bytes]
        :return: SandboxUploadResponse
        :rtype: ~generated.models.SandboxUploadResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop(
            "content_type", _headers.pop("Content-Type", None)
        )
        cls: ClsType[_models.SandboxUploadResponse] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _json = self._serialize.body(body, "SandboxInfo")

        _request = build_jobs_initiate_sandbox_upload_request(
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        deserialized = self._deserialize(
            "SandboxUploadResponse", pipeline_response.http_response
        )

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get_sandbox_file(
        self, *, pfn: str, **kwargs: Any
    ) -> _models.SandboxDownloadResponse:
        """Get Sandbox File.

        Get a presigned URL to download a sandbox file.

        This route cannot use a redirect response most clients will also send the
        authorization header when following a redirect. This is not desirable as
        it would leak the authorization token to the storage backend. Additionally,
        most storage backends return an error when they receive an authorization
        header for a presigned URL.

        :keyword pfn: Required.
        :paramtype pfn: str
        :return: SandboxDownloadResponse
        :rtype: ~generated.models.SandboxDownloadResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.SandboxDownloadResponse] = kwargs.pop("cls", None)

        _request = build_jobs_get_sandbox_file_request(
            pfn=pfn,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        deserialized = self._deserialize(
            "SandboxDownloadResponse", pipeline_response.http_response
        )

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def unassign_bulk_jobs_sandboxes(
        self, *, jobs_ids: List[int], **kwargs: Any
    ) -> Any:
        """Unassign Bulk Jobs Sandboxes.

        Delete bulk jobs sandbox mapping.

        :keyword jobs_ids: Required.
        :paramtype jobs_ids: list[int]
        :return: any
        :rtype: any
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[Any] = kwargs.pop("cls", None)

        _request = build_jobs_unassign_bulk_jobs_sandboxes_request(
            jobs_ids=jobs_ids,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        deserialized = self._deserialize("object", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get_job_sandboxes(
        self, job_id: int, **kwargs: Any
    ) -> Dict[str, List[Any]]:
        """Get Job Sandboxes.

        Get input and output sandboxes of given job.

        :param job_id: Required.
        :type job_id: int
        :return: dict mapping str to list of any
        :rtype: dict[str, list[any]]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[Dict[str, List[Any]]] = kwargs.pop("cls", None)

        _request = build_jobs_get_job_sandboxes_request(
            job_id=job_id,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        deserialized = self._deserialize("{[object]}", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def unassign_job_sandboxes(self, job_id: int, **kwargs: Any) -> Any:
        """Unassign Job Sandboxes.

        Delete single job sandbox mapping.

        :param job_id: Required.
        :type job_id: int
        :return: any
        :rtype: any
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[Any] = kwargs.pop("cls", None)

        _request = build_jobs_unassign_job_sandboxes_request(
            job_id=job_id,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        deserialized = self._deserialize("object", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get_job_sandbox(
        self, job_id: int, sandbox_type: Union[str, _models.SandboxType], **kwargs: Any
    ) -> List[Any]:
        """Get Job Sandbox.

        Get input or output sandbox of given job.

        :param job_id: Required.
        :type job_id: int
        :param sandbox_type: Known values are: "input" and "output". Required.
        :type sandbox_type: str or ~generated.models.SandboxType
        :return: list of any
        :rtype: list[any]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[Any]] = kwargs.pop("cls", None)

        _request = build_jobs_get_job_sandbox_request(
            job_id=job_id,
            sandbox_type=sandbox_type,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        deserialized = self._deserialize("[object]", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def assign_sandbox_to_job(self, job_id: int, body: str, **kwargs: Any) -> Any:
        """Assign Sandbox To Job.

        Map the pfn as output sandbox to job.

        :param job_id: Required.
        :type job_id: int
        :param body: Required.
        :type body: str
        :return: any
        :rtype: any
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: str = kwargs.pop(
            "content_type", _headers.pop("Content-Type", "application/json")
        )
        cls: ClsType[Any] = kwargs.pop("cls", None)

        _content = self._serialize.body(body, "str")

        _request = build_jobs_assign_sandbox_to_job_request(
            job_id=job_id,
            content_type=content_type,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        deserialized = self._deserialize("object", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def submit_bulk_jobs(
        self, body: List[str], *, content_type: str = "application/json", **kwargs: Any
    ) -> List[_models.InsertedJob]:
        """Submit Bulk Jobs.

        Submit Bulk Jobs.

        :param body: Required.
        :type body: list[str]
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: list of InsertedJob
        :rtype: list[~generated.models.InsertedJob]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def submit_bulk_jobs(
        self, body: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> List[_models.InsertedJob]:
        """Submit Bulk Jobs.

        Submit Bulk Jobs.

        :param body: Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: list of InsertedJob
        :rtype: list[~generated.models.InsertedJob]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def submit_bulk_jobs(
        self, body: Union[List[str], IO[bytes]], **kwargs: Any
    ) -> List[_models.InsertedJob]:
        """Submit Bulk Jobs.

        Submit Bulk Jobs.

        :param body: Is either a [str] type or a IO[bytes] type. Required.
        :type body: list[str] or IO[bytes]
        :return: list of InsertedJob
        :rtype: list[~generated.models.InsertedJob]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop(
            "content_type", _headers.pop("Content-Type", None)
        )
        cls: ClsType[List[_models.InsertedJob]] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _json = self._serialize.body(body, "[str]")

        _request = build_jobs_submit_bulk_jobs_request(
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        deserialized = self._deserialize(
            "[InsertedJob]", pipeline_response.http_response
        )

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def delete_bulk_jobs(self, *, job_ids: List[int], **kwargs: Any) -> Any:
        """Delete Bulk Jobs.

        Delete Bulk Jobs.

        :keyword job_ids: Required.
        :paramtype job_ids: list[int]
        :return: any
        :rtype: any
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[Any] = kwargs.pop("cls", None)

        _request = build_jobs_delete_bulk_jobs_request(
            job_ids=job_ids,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        deserialized = self._deserialize("object", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def kill_bulk_jobs(self, *, job_ids: List[int], **kwargs: Any) -> Any:
        """Kill Bulk Jobs.

        Kill Bulk Jobs.

        :keyword job_ids: Required.
        :paramtype job_ids: list[int]
        :return: any
        :rtype: any
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[Any] = kwargs.pop("cls", None)

        _request = build_jobs_kill_bulk_jobs_request(
            job_ids=job_ids,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        deserialized = self._deserialize("object", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def remove_bulk_jobs(self, *, job_ids: List[int], **kwargs: Any) -> Any:
        """Remove Bulk Jobs.

        Fully remove a list of jobs from the WMS databases.

        WARNING: This endpoint has been implemented for the compatibility with the legacy DIRAC WMS
        and the JobCleaningAgent. However, once this agent is ported to diracx, this endpoint should
        be removed, and the delete endpoint should be used instead for any other purpose.

        :keyword job_ids: Required.
        :paramtype job_ids: list[int]
        :return: any
        :rtype: any
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[Any] = kwargs.pop("cls", None)

        _request = build_jobs_remove_bulk_jobs_request(
            job_ids=job_ids,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        deserialized = self._deserialize("object", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get_job_status_bulk(
        self, *, job_ids: List[int], **kwargs: Any
    ) -> Dict[str, _models.LimitedJobStatusReturn]:
        """Get Job Status Bulk.

        Get Job Status Bulk.

        :keyword job_ids: Required.
        :paramtype job_ids: list[int]
        :return: dict mapping str to LimitedJobStatusReturn
        :rtype: dict[str, ~generated.models.LimitedJobStatusReturn]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[Dict[str, _models.LimitedJobStatusReturn]] = kwargs.pop(
            "cls", None
        )

        _request = build_jobs_get_job_status_bulk_request(
            job_ids=job_ids,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        deserialized = self._deserialize(
            "{LimitedJobStatusReturn}", pipeline_response.http_response
        )

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def set_job_status_bulk(
        self,
        body: Dict[str, Dict[str, _models.JobStatusUpdate]],
        *,
        force: bool = False,
        content_type: str = "application/json",
        **kwargs: Any,
    ) -> Dict[str, _models.SetJobStatusReturn]:
        """Set Job Status Bulk.

        Set Job Status Bulk.

        :param body: Required.
        :type body: dict[str, dict[str, ~generated.models.JobStatusUpdate]]
        :keyword force: Default value is False.
        :paramtype force: bool
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: dict mapping str to SetJobStatusReturn
        :rtype: dict[str, ~generated.models.SetJobStatusReturn]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def set_job_status_bulk(
        self,
        body: IO[bytes],
        *,
        force: bool = False,
        content_type: str = "application/json",
        **kwargs: Any,
    ) -> Dict[str, _models.SetJobStatusReturn]:
        """Set Job Status Bulk.

        Set Job Status Bulk.

        :param body: Required.
        :type body: IO[bytes]
        :keyword force: Default value is False.
        :paramtype force: bool
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: dict mapping str to SetJobStatusReturn
        :rtype: dict[str, ~generated.models.SetJobStatusReturn]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def set_job_status_bulk(
        self,
        body: Union[Dict[str, Dict[str, _models.JobStatusUpdate]], IO[bytes]],
        *,
        force: bool = False,
        **kwargs: Any,
    ) -> Dict[str, _models.SetJobStatusReturn]:
        """Set Job Status Bulk.

        Set Job Status Bulk.

        :param body: Is either a {str: {str: JobStatusUpdate}} type or a IO[bytes] type. Required.
        :type body: dict[str, dict[str, ~generated.models.JobStatusUpdate]] or IO[bytes]
        :keyword force: Default value is False.
        :paramtype force: bool
        :return: dict mapping str to SetJobStatusReturn
        :rtype: dict[str, ~generated.models.SetJobStatusReturn]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop(
            "content_type", _headers.pop("Content-Type", None)
        )
        cls: ClsType[Dict[str, _models.SetJobStatusReturn]] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _json = self._serialize.body(body, "{{JobStatusUpdate}}")

        _request = build_jobs_set_job_status_bulk_request(
            force=force,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        deserialized = self._deserialize(
            "{SetJobStatusReturn}", pipeline_response.http_response
        )

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get_job_status_history_bulk(
        self, *, job_ids: List[int], **kwargs: Any
    ) -> Dict[str, List[_models.JobStatusReturn]]:
        """Get Job Status History Bulk.

        Get Job Status History Bulk.

        :keyword job_ids: Required.
        :paramtype job_ids: list[int]
        :return: dict mapping str to list of JobStatusReturn
        :rtype: dict[str, list[~generated.models.JobStatusReturn]]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[Dict[str, List[_models.JobStatusReturn]]] = kwargs.pop("cls", None)

        _request = build_jobs_get_job_status_history_bulk_request(
            job_ids=job_ids,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        deserialized = self._deserialize(
            "{[JobStatusReturn]}", pipeline_response.http_response
        )

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def reschedule_bulk_jobs(self, *, job_ids: List[int], **kwargs: Any) -> Any:
        """Reschedule Bulk Jobs.

        Reschedule Bulk Jobs.

        :keyword job_ids: Required.
        :paramtype job_ids: list[int]
        :return: any
        :rtype: any
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[Any] = kwargs.pop("cls", None)

        _request = build_jobs_reschedule_bulk_jobs_request(
            job_ids=job_ids,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        deserialized = self._deserialize("object", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def reschedule_single_job(self, job_id: int, **kwargs: Any) -> Any:
        """Reschedule Single Job.

        Reschedule Single Job.

        :param job_id: Required.
        :type job_id: int
        :return: any
        :rtype: any
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[Any] = kwargs.pop("cls", None)

        _request = build_jobs_reschedule_single_job_request(
            job_id=job_id,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        deserialized = self._deserialize("object", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def search(
        self,
        body: Optional[_models.JobSearchParams] = None,
        *,
        page: int = 1,
        per_page: int = 100,
        content_type: str = "application/json",
        **kwargs: Any,
    ) -> List[JSON]:
        """Search.

        Retrieve information about jobs.

        **TODO: Add more docs**.

        :param body: Default value is None.
        :type body: ~generated.models.JobSearchParams
        :keyword page: Default value is 1.
        :paramtype page: int
        :keyword per_page: Default value is 100.
        :paramtype per_page: int
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: list of JSON
        :rtype: list[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def search(
        self,
        body: Optional[IO[bytes]] = None,
        *,
        page: int = 1,
        per_page: int = 100,
        content_type: str = "application/json",
        **kwargs: Any,
    ) -> List[JSON]:
        """Search.

        Retrieve information about jobs.

        **TODO: Add more docs**.

        :param body: Default value is None.
        :type body: IO[bytes]
        :keyword page: Default value is 1.
        :paramtype page: int
        :keyword per_page: Default value is 100.
        :paramtype per_page: int
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: list of JSON
        :rtype: list[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def search(
        self,
        body: Optional[Union[_models.JobSearchParams, IO[bytes]]] = None,
        *,
        page: int = 1,
        per_page: int = 100,
        **kwargs: Any,
    ) -> List[JSON]:
        """Search.

        Retrieve information about jobs.

        **TODO: Add more docs**.

        :param body: Is either a JobSearchParams type or a IO[bytes] type. Default value is None.
        :type body: ~generated.models.JobSearchParams or IO[bytes]
        :keyword page: Default value is 1.
        :paramtype page: int
        :keyword per_page: Default value is 100.
        :paramtype per_page: int
        :return: list of JSON
        :rtype: list[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop(
            "content_type", _headers.pop("Content-Type", None)
        )
        cls: ClsType[List[JSON]] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            if body is not None:
                _json = self._serialize.body(body, "JobSearchParams")
            else:
                _json = None

        _request = build_jobs_search_request(
            page=page,
            per_page=per_page,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 206]:
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        response_headers = {}
        if response.status_code == 206:
            response_headers["Content-Range"] = self._deserialize(
                "str", response.headers.get("Content-Range")
            )

        deserialized = self._deserialize("[object]", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def summary(
        self,
        body: _models.JobSummaryParams,
        *,
        content_type: str = "application/json",
        **kwargs: Any,
    ) -> Any:
        """Summary.

        Show information suitable for plotting.

        :param body: Required.
        :type body: ~generated.models.JobSummaryParams
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: any
        :rtype: any
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def summary(
        self, body: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> Any:
        """Summary.

        Show information suitable for plotting.

        :param body: Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: any
        :rtype: any
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def summary(
        self, body: Union[_models.JobSummaryParams, IO[bytes]], **kwargs: Any
    ) -> Any:
        """Summary.

        Show information suitable for plotting.

        :param body: Is either a JobSummaryParams type or a IO[bytes] type. Required.
        :type body: ~generated.models.JobSummaryParams or IO[bytes]
        :return: any
        :rtype: any
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop(
            "content_type", _headers.pop("Content-Type", None)
        )
        cls: ClsType[Any] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _json = self._serialize.body(body, "JobSummaryParams")

        _request = build_jobs_summary_request(
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        deserialized = self._deserialize("object", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get_single_job(self, job_id: int, **kwargs: Any) -> Any:
        """Get Single Job.

        Get Single Job.

        :param job_id: Required.
        :type job_id: int
        :return: any
        :rtype: any
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[Any] = kwargs.pop("cls", None)

        _request = build_jobs_get_single_job_request(
            job_id=job_id,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        deserialized = self._deserialize("object", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def delete_single_job(self, job_id: int, **kwargs: Any) -> Any:
        """Delete Single Job.

        Delete a job by killing and setting the job status to DELETED.

        :param job_id: Required.
        :type job_id: int
        :return: any
        :rtype: any
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[Any] = kwargs.pop("cls", None)

        _request = build_jobs_delete_single_job_request(
            job_id=job_id,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        deserialized = self._deserialize("object", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def set_single_job_properties(
        self, job_id: int, body: JSON, *, update_timestamp: bool = False, **kwargs: Any
    ) -> Any:
        """Set Single Job Properties.

        Update the given job properties (MinorStatus, ApplicationStatus, etc).

        :param job_id: Required.
        :type job_id: int
        :param body: Required.
        :type body: JSON
        :keyword update_timestamp: Default value is False.
        :paramtype update_timestamp: bool
        :return: any
        :rtype: any
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: str = kwargs.pop(
            "content_type", _headers.pop("Content-Type", "application/json")
        )
        cls: ClsType[Any] = kwargs.pop("cls", None)

        _json = self._serialize.body(body, "object")

        _request = build_jobs_set_single_job_properties_request(
            job_id=job_id,
            update_timestamp=update_timestamp,
            content_type=content_type,
            json=_json,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        deserialized = self._deserialize("object", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def kill_single_job(self, job_id: int, **kwargs: Any) -> Any:
        """Kill Single Job.

        Kill a job.

        :param job_id: Required.
        :type job_id: int
        :return: any
        :rtype: any
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[Any] = kwargs.pop("cls", None)

        _request = build_jobs_kill_single_job_request(
            job_id=job_id,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        deserialized = self._deserialize("object", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def remove_single_job(self, job_id: int, **kwargs: Any) -> Any:
        """Remove Single Job.

        Fully remove a job from the WMS databases.

        WARNING: This endpoint has been implemented for the compatibility with the legacy DIRAC WMS
        and the JobCleaningAgent. However, once this agent is ported to diracx, this endpoint should
        be removed, and the delete endpoint should be used instead.

        :param job_id: Required.
        :type job_id: int
        :return: any
        :rtype: any
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[Any] = kwargs.pop("cls", None)

        _request = build_jobs_remove_single_job_request(
            job_id=job_id,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        deserialized = self._deserialize("object", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get_single_job_status(
        self, job_id: int, **kwargs: Any
    ) -> Dict[str, _models.LimitedJobStatusReturn]:
        """Get Single Job Status.

        Get Single Job Status.

        :param job_id: Required.
        :type job_id: int
        :return: dict mapping str to LimitedJobStatusReturn
        :rtype: dict[str, ~generated.models.LimitedJobStatusReturn]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[Dict[str, _models.LimitedJobStatusReturn]] = kwargs.pop(
            "cls", None
        )

        _request = build_jobs_get_single_job_status_request(
            job_id=job_id,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        deserialized = self._deserialize(
            "{LimitedJobStatusReturn}", pipeline_response.http_response
        )

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def set_single_job_status(
        self,
        job_id: int,
        body: Dict[str, _models.JobStatusUpdate],
        *,
        force: bool = False,
        content_type: str = "application/json",
        **kwargs: Any,
    ) -> Dict[str, _models.SetJobStatusReturn]:
        """Set Single Job Status.

        Set Single Job Status.

        :param job_id: Required.
        :type job_id: int
        :param body: Required.
        :type body: dict[str, ~generated.models.JobStatusUpdate]
        :keyword force: Default value is False.
        :paramtype force: bool
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: dict mapping str to SetJobStatusReturn
        :rtype: dict[str, ~generated.models.SetJobStatusReturn]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def set_single_job_status(
        self,
        job_id: int,
        body: IO[bytes],
        *,
        force: bool = False,
        content_type: str = "application/json",
        **kwargs: Any,
    ) -> Dict[str, _models.SetJobStatusReturn]:
        """Set Single Job Status.

        Set Single Job Status.

        :param job_id: Required.
        :type job_id: int
        :param body: Required.
        :type body: IO[bytes]
        :keyword force: Default value is False.
        :paramtype force: bool
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: dict mapping str to SetJobStatusReturn
        :rtype: dict[str, ~generated.models.SetJobStatusReturn]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def set_single_job_status(
        self,
        job_id: int,
        body: Union[Dict[str, _models.JobStatusUpdate], IO[bytes]],
        *,
        force: bool = False,
        **kwargs: Any,
    ) -> Dict[str, _models.SetJobStatusReturn]:
        """Set Single Job Status.

        Set Single Job Status.

        :param job_id: Required.
        :type job_id: int
        :param body: Is either a {str: JobStatusUpdate} type or a IO[bytes] type. Required.
        :type body: dict[str, ~generated.models.JobStatusUpdate] or IO[bytes]
        :keyword force: Default value is False.
        :paramtype force: bool
        :return: dict mapping str to SetJobStatusReturn
        :rtype: dict[str, ~generated.models.SetJobStatusReturn]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop(
            "content_type", _headers.pop("Content-Type", None)
        )
        cls: ClsType[Dict[str, _models.SetJobStatusReturn]] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _json = self._serialize.body(body, "{JobStatusUpdate}")

        _request = build_jobs_set_single_job_status_request(
            job_id=job_id,
            force=force,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        deserialized = self._deserialize(
            "{SetJobStatusReturn}", pipeline_response.http_response
        )

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get_single_job_status_history(
        self, job_id: int, **kwargs: Any
    ) -> Dict[str, List[_models.JobStatusReturn]]:
        """Get Single Job Status History.

        Get Single Job Status History.

        :param job_id: Required.
        :type job_id: int
        :return: dict mapping str to list of JobStatusReturn
        :rtype: dict[str, list[~generated.models.JobStatusReturn]]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[Dict[str, List[_models.JobStatusReturn]]] = kwargs.pop("cls", None)

        _request = build_jobs_get_single_job_status_history_request(
            job_id=job_id,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = (
            await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        deserialized = self._deserialize(
            "{[JobStatusReturn]}", pipeline_response.http_response
        )

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore
