# generated by datamodel-codegen:
#   filename:  entity/services/connections/dashboard/lookerConnection.json
#   timestamp: 2022-10-06T12:48:30+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional

from pydantic import AnyUrl, BaseModel, Extra, Field, SecretStr

from .. import connectionBasicType


class LookerType(Enum):
    Looker = 'Looker'


class LookerConnection(BaseModel):
    class Config:
        extra = Extra.forbid

    type: Optional[LookerType] = Field(
        LookerType.Looker, description='Service Type', title='Service Type'
    )
    clientId: str = Field(
        ...,
        description="User's Client ID. This user should have privileges to read all the metadata in Looker.",
        title='Client ID',
    )
    clientSecret: SecretStr = Field(
        ..., description="User's Client Secret.", title='Client Secret'
    )
    hostPort: AnyUrl = Field(
        ..., description='URL to the Looker instance.', title='Host and Port'
    )
    supportsMetadataExtraction: Optional[
        connectionBasicType.SupportsMetadataExtraction
    ] = Field(None, title='Supports Metadata Extraction')
