# generated by datamodel-codegen:
#   filename:  entity/services/connections/database/prestoConnection.json
#   timestamp: 2022-10-06T12:48:30+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional

from pydantic import BaseModel, Extra, Field, SecretStr

from .. import connectionBasicType


class PrestoType(Enum):
    Presto = 'Presto'


class PrestoScheme(Enum):
    presto = 'presto'


class PrestoConnection(BaseModel):
    class Config:
        extra = Extra.forbid

    type: Optional[PrestoType] = Field(
        PrestoType.Presto, description='Service Type', title='Service Type'
    )
    scheme: Optional[PrestoScheme] = Field(
        PrestoScheme.presto,
        description='SQLAlchemy driver scheme options.',
        title='Connection Scheme',
    )
    username: str = Field(
        ...,
        description='Username to connect to Presto. This user should have privileges to read all the metadata in Postgres.',
        title='Username',
    )
    password: Optional[SecretStr] = Field(
        None, description='Password to connect to Presto.', title='Password'
    )
    hostPort: str = Field(
        ..., description='Host and port of the Presto service.', title='Host and Port'
    )
    databaseSchema: Optional[str] = Field(
        None,
        description='databaseSchema of the data source. This is optional parameter, if you would like to restrict the metadata reading to a single databaseSchema. When left blank, OpenMetadata Ingestion attempts to scan all the databaseSchema.',
        title='databaseSchema',
    )
    catalog: str = Field(..., description='Presto catalog', title='Catalog')
    connectionOptions: Optional[connectionBasicType.ConnectionOptions] = Field(
        None, title='Connection Options'
    )
    connectionArguments: Optional[connectionBasicType.ConnectionArguments] = Field(
        None, title='Connection Arguments'
    )
    supportsMetadataExtraction: Optional[
        connectionBasicType.SupportsMetadataExtraction
    ] = Field(None, title='Supports Metadata Extraction')
    supportsProfiler: Optional[connectionBasicType.SupportsProfiler] = Field(
        None, title='Supports Profiler'
    )
    supportsDatabase: Optional[connectionBasicType.SupportsDatabase] = Field(
        None, title='Supports Profiler'
    )
    supportsQueryComment: Optional[connectionBasicType.SupportsQueryComment] = Field(
        None, title='Supports Query Comment'
    )
