# generated by datamodel-codegen:
#   filename:  metadataIngestion/databaseServiceProfilerPipeline.json
#   timestamp: 2022-10-06T12:48:30+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional

from pydantic import BaseModel, Extra, Field, confloat

from ..type import filterPattern


class ProfilerConfigType(Enum):
    Profiler = 'Profiler'


class DatabaseServiceProfilerPipeline(BaseModel):
    class Config:
        extra = Extra.forbid

    type: Optional[ProfilerConfigType] = Field(
        ProfilerConfigType.Profiler, description='Pipeline type'
    )
    schemaFilterPattern: Optional[filterPattern.FilterPattern] = Field(
        None,
        description='Regex to only fetch tables or databases that matches the pattern.',
    )
    tableFilterPattern: Optional[filterPattern.FilterPattern] = Field(
        None, description='Regex exclude tables or databases that matches the pattern.'
    )
    databaseFilterPattern: Optional[filterPattern.FilterPattern] = Field(
        None, description='Regex to only fetch databases that matches the pattern.'
    )
    generateSampleData: Optional[bool] = Field(
        True, description='Option to turn on/off generating sample data.'
    )
    profileSample: Optional[confloat(le=100.0, gt=0.0)] = Field(
        None,
        description='Percentage of data used to execute the profiler for the whole workflow. This percentage will be applied to all tables in the workflow. Represented in the range (0, 100].',
    )
    threadCount: Optional[float] = Field(
        5, description='Number of threads to use during metric computations'
    )
