# generated by datamodel-codegen:
#   filename:  settings/settings.json
#   timestamp: 2022-10-06T12:48:30+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional, Union

from pydantic import BaseModel, Extra, Field

from ..configuration import (
    airflowConfiguration,
    authenticationConfiguration,
    authorizerConfiguration,
    elasticSearchConfiguration,
    eventHandlerConfiguration,
    fernetConfiguration,
    jwtTokenConfiguration,
    slackChatConfiguration,
    slackEventPubConfiguration,
)


class SettingType(Enum):
    authorizerConfiguration = 'authorizerConfiguration'
    authenticationConfiguration = 'authenticationConfiguration'
    jwtTokenConfiguration = 'jwtTokenConfiguration'
    elasticsearch = 'elasticsearch'
    eventHandlerConfiguration = 'eventHandlerConfiguration'
    airflowConfiguration = 'airflowConfiguration'
    fernetConfiguration = 'fernetConfiguration'
    slackEventPublishers = 'slackEventPublishers'
    activityFeedFilterSetting = 'activityFeedFilterSetting'
    secretsManagerConfiguration = 'secretsManagerConfiguration'
    sandboxModeEnabled = 'sandboxModeEnabled'
    slackChat = 'slackChat'


class Settings(BaseModel):
    class Config:
        extra = Extra.forbid

    config_type: SettingType = Field(
        ..., description='Unique identifier that identifies an entity instance.'
    )
    config_value: Optional[
        Union[
            airflowConfiguration.AirflowConfiguration,
            authenticationConfiguration.AuthenticationConfiguration,
            authorizerConfiguration.AuthorizerConfiguration,
            elasticSearchConfiguration.ElasticSearchConfiguration,
            eventHandlerConfiguration.EventHandlerConfiguration,
            fernetConfiguration.FernetConfiguration,
            jwtTokenConfiguration.JWTTokenConfiguration,
            slackChatConfiguration.SlackChatConfiguration,
            slackEventPubConfiguration.SlackPublisherConfiguration,
        ]
    ] = None
