# -*- coding: utf-8 -*-

try:
    from setuptools import setup
except ImportError:
    from distutils.core import setup

long_description = """
# Yandex.Checkout API Python Client Library

[![Build Status](https://travis-ci.org/yandex-money/yandex-checkout-sdk-python.svg?branch=master)](https://travis-ci.org/yandex-money/yandex-checkout-sdk-python)
[![Latest Stable Version](https://img.shields.io/pypi/v/yandex-checkout.svg)](https://pypi.org/project/yandex-checkout/)
[![Total Downloads](https://img.shields.io/pypi/dm/yandex-checkout.svg)](https://pypi.org/project/yandex-checkout/)
[![License](https://img.shields.io/pypi/l/yandex-checkout.svg)](https://github.com/yandex-money/yandex-checkout-sdk-python)

[Russian](https://github.com/yandex-money/yandex-checkout-sdk-python/blob/master/README.md) | English

This product is used for managing payments under [The Yandex.Checkout API](https://kassa.yandex.ru/docs/checkout-api/)
For usage by those who implemented Yandex.Checkout using the API method.

## Requirements
1. Python 2.7 or Python 3.x
2. pip

## Installation
### Under console using pip

1. Install pip.
2. In the console, run the following command:
```bash
pip install --upgrade yandex_checkout
```

### Under console using easy_install
1. Install easy_install.
2. In the console, run the following command:
```bash
easy_install --upgrade yandex_checkout
```

### Manually

1. In the console, run the following command:
```bash
wget https://pypi.python.org/packages/5a/be/5eafdfb14aa6f32107e9feb6514ca1ad3fe56f8e5ee59d20693b32f7e79f/yandex_checkout-1.0.0.tar.gz#md5=46595279b5578fd82a199bfd4cd51db2
tar zxf yandex_checkout-1.0.0.tar.gz
cd yandex_checkout-1.0.0
python setup.py install
```


## Commencing work

1. Import module
```python
import yandex_checkout
```

2. Configure a Client
```python
from yandex_checkout import Configuration

Configuration.configure(<Account Id>,<Secret Key>)
```

or

```python
from yandex_checkout import Configuration

Configuration.account_id = <Account Id>
Configuration.secret_key = <Secret Key>
```
3. Call the required API method. [More details in our documentation for the Yandex.Chechout API](url)
"""

setup(
    name="yandex_checkout",
    version="1.4.5",
    description="Yandex Checkout SDK Python Library",
    long_description=long_description,
    long_description_content_type="text/markdown",
    url="https://github.com/yandex-money/yandex-checkout-sdk-python",
    author="Yandex.Money",
    packages=["yandex_checkout", "yandex_checkout.domain.request", "yandex_checkout.domain.response",
              "yandex_checkout.domain.notification", "yandex_checkout.domain.models", "yandex_checkout.domain",
              "yandex_checkout.domain.models.confirmation", "yandex_checkout.domain.models.confirmation.request",
              "yandex_checkout.domain.models.confirmation.response", "yandex_checkout.domain.models.payment_data",
              "yandex_checkout.domain.models.payment_data.request", "yandex_checkout.domain.common",
              "yandex_checkout.domain.models.payment_data.response", "yandex_checkout.domain.exceptions"],
    install_requires=["requests", "uuid", "urllib3"],
    zip_safe=False,
    license="MIT",
    classifiers=[
        "License :: OSI Approved :: MIT License",
        "Programming Language :: Python :: 2.7",
        "Programming Language :: Python :: 3.3",
        "Programming Language :: Python :: 3.4",
        "Programming Language :: Python :: 3.5",
        "Programming Language :: Python :: 3.6",
        "Programming Language :: Python :: 3.7"
    ]
)
